//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armbotservice.ClientFactory type.
type ServerFactory struct {
	BotConnectionServer              BotConnectionServer
	BotsServer                       BotsServer
	ChannelsServer                   ChannelsServer
	DirectLineServer                 DirectLineServer
	EmailServer                      EmailServer
	HostSettingsServer               HostSettingsServer
	OperationResultsServer           OperationResultsServer
	OperationsServer                 OperationsServer
	PrivateEndpointConnectionsServer PrivateEndpointConnectionsServer
	PrivateLinkResourcesServer       PrivateLinkResourcesServer
	QnAMakerEndpointKeysServer       QnAMakerEndpointKeysServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armbotservice.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armbotservice.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                *ServerFactory
	trMu                               sync.Mutex
	trBotConnectionServer              *BotConnectionServerTransport
	trBotsServer                       *BotsServerTransport
	trChannelsServer                   *ChannelsServerTransport
	trDirectLineServer                 *DirectLineServerTransport
	trEmailServer                      *EmailServerTransport
	trHostSettingsServer               *HostSettingsServerTransport
	trOperationResultsServer           *OperationResultsServerTransport
	trOperationsServer                 *OperationsServerTransport
	trPrivateEndpointConnectionsServer *PrivateEndpointConnectionsServerTransport
	trPrivateLinkResourcesServer       *PrivateLinkResourcesServerTransport
	trQnAMakerEndpointKeysServer       *QnAMakerEndpointKeysServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "BotConnectionClient":
		initServer(s, &s.trBotConnectionServer, func() *BotConnectionServerTransport {
			return NewBotConnectionServerTransport(&s.srv.BotConnectionServer)
		})
		resp, err = s.trBotConnectionServer.Do(req)
	case "BotsClient":
		initServer(s, &s.trBotsServer, func() *BotsServerTransport { return NewBotsServerTransport(&s.srv.BotsServer) })
		resp, err = s.trBotsServer.Do(req)
	case "ChannelsClient":
		initServer(s, &s.trChannelsServer, func() *ChannelsServerTransport { return NewChannelsServerTransport(&s.srv.ChannelsServer) })
		resp, err = s.trChannelsServer.Do(req)
	case "DirectLineClient":
		initServer(s, &s.trDirectLineServer, func() *DirectLineServerTransport { return NewDirectLineServerTransport(&s.srv.DirectLineServer) })
		resp, err = s.trDirectLineServer.Do(req)
	case "EmailClient":
		initServer(s, &s.trEmailServer, func() *EmailServerTransport { return NewEmailServerTransport(&s.srv.EmailServer) })
		resp, err = s.trEmailServer.Do(req)
	case "HostSettingsClient":
		initServer(s, &s.trHostSettingsServer, func() *HostSettingsServerTransport { return NewHostSettingsServerTransport(&s.srv.HostSettingsServer) })
		resp, err = s.trHostSettingsServer.Do(req)
	case "OperationResultsClient":
		initServer(s, &s.trOperationResultsServer, func() *OperationResultsServerTransport {
			return NewOperationResultsServerTransport(&s.srv.OperationResultsServer)
		})
		resp, err = s.trOperationResultsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PrivateEndpointConnectionsClient":
		initServer(s, &s.trPrivateEndpointConnectionsServer, func() *PrivateEndpointConnectionsServerTransport {
			return NewPrivateEndpointConnectionsServerTransport(&s.srv.PrivateEndpointConnectionsServer)
		})
		resp, err = s.trPrivateEndpointConnectionsServer.Do(req)
	case "PrivateLinkResourcesClient":
		initServer(s, &s.trPrivateLinkResourcesServer, func() *PrivateLinkResourcesServerTransport {
			return NewPrivateLinkResourcesServerTransport(&s.srv.PrivateLinkResourcesServer)
		})
		resp, err = s.trPrivateLinkResourcesServer.Do(req)
	case "QnAMakerEndpointKeysClient":
		initServer(s, &s.trQnAMakerEndpointKeysServer, func() *QnAMakerEndpointKeysServerTransport {
			return NewQnAMakerEndpointKeysServerTransport(&s.srv.QnAMakerEndpointKeysServer)
		})
		resp, err = s.trQnAMakerEndpointKeysServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
