//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/containerservice/armcontainerservice/v4"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// ManagedClustersServer is a fake server for instances of the armcontainerservice.ManagedClustersClient type.
type ManagedClustersServer struct {
	// BeginAbortLatestOperation is the fake for method ManagedClustersClient.BeginAbortLatestOperation
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginAbortLatestOperation func(ctx context.Context, resourceGroupName string, resourceName string, options *armcontainerservice.ManagedClustersClientBeginAbortLatestOperationOptions) (resp azfake.PollerResponder[armcontainerservice.ManagedClustersClientAbortLatestOperationResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method ManagedClustersClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, resourceName string, parameters armcontainerservice.ManagedCluster, options *armcontainerservice.ManagedClustersClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armcontainerservice.ManagedClustersClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ManagedClustersClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, resourceName string, options *armcontainerservice.ManagedClustersClientBeginDeleteOptions) (resp azfake.PollerResponder[armcontainerservice.ManagedClustersClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ManagedClustersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, resourceName string, options *armcontainerservice.ManagedClustersClientGetOptions) (resp azfake.Responder[armcontainerservice.ManagedClustersClientGetResponse], errResp azfake.ErrorResponder)

	// GetAccessProfile is the fake for method ManagedClustersClient.GetAccessProfile
	// HTTP status codes to indicate success: http.StatusOK
	GetAccessProfile func(ctx context.Context, resourceGroupName string, resourceName string, roleName string, options *armcontainerservice.ManagedClustersClientGetAccessProfileOptions) (resp azfake.Responder[armcontainerservice.ManagedClustersClientGetAccessProfileResponse], errResp azfake.ErrorResponder)

	// GetCommandResult is the fake for method ManagedClustersClient.GetCommandResult
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	GetCommandResult func(ctx context.Context, resourceGroupName string, resourceName string, commandID string, options *armcontainerservice.ManagedClustersClientGetCommandResultOptions) (resp azfake.Responder[armcontainerservice.ManagedClustersClientGetCommandResultResponse], errResp azfake.ErrorResponder)

	// GetGuardrailsVersions is the fake for method ManagedClustersClient.GetGuardrailsVersions
	// HTTP status codes to indicate success: http.StatusOK
	GetGuardrailsVersions func(ctx context.Context, location string, version string, options *armcontainerservice.ManagedClustersClientGetGuardrailsVersionsOptions) (resp azfake.Responder[armcontainerservice.ManagedClustersClientGetGuardrailsVersionsResponse], errResp azfake.ErrorResponder)

	// GetMeshRevisionProfile is the fake for method ManagedClustersClient.GetMeshRevisionProfile
	// HTTP status codes to indicate success: http.StatusOK
	GetMeshRevisionProfile func(ctx context.Context, location string, mode string, options *armcontainerservice.ManagedClustersClientGetMeshRevisionProfileOptions) (resp azfake.Responder[armcontainerservice.ManagedClustersClientGetMeshRevisionProfileResponse], errResp azfake.ErrorResponder)

	// GetMeshUpgradeProfile is the fake for method ManagedClustersClient.GetMeshUpgradeProfile
	// HTTP status codes to indicate success: http.StatusOK
	GetMeshUpgradeProfile func(ctx context.Context, resourceGroupName string, resourceName string, mode string, options *armcontainerservice.ManagedClustersClientGetMeshUpgradeProfileOptions) (resp azfake.Responder[armcontainerservice.ManagedClustersClientGetMeshUpgradeProfileResponse], errResp azfake.ErrorResponder)

	// GetOSOptions is the fake for method ManagedClustersClient.GetOSOptions
	// HTTP status codes to indicate success: http.StatusOK
	GetOSOptions func(ctx context.Context, location string, options *armcontainerservice.ManagedClustersClientGetOSOptionsOptions) (resp azfake.Responder[armcontainerservice.ManagedClustersClientGetOSOptionsResponse], errResp azfake.ErrorResponder)

	// GetUpgradeProfile is the fake for method ManagedClustersClient.GetUpgradeProfile
	// HTTP status codes to indicate success: http.StatusOK
	GetUpgradeProfile func(ctx context.Context, resourceGroupName string, resourceName string, options *armcontainerservice.ManagedClustersClientGetUpgradeProfileOptions) (resp azfake.Responder[armcontainerservice.ManagedClustersClientGetUpgradeProfileResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ManagedClustersClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armcontainerservice.ManagedClustersClientListOptions) (resp azfake.PagerResponder[armcontainerservice.ManagedClustersClientListResponse])

	// NewListByResourceGroupPager is the fake for method ManagedClustersClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armcontainerservice.ManagedClustersClientListByResourceGroupOptions) (resp azfake.PagerResponder[armcontainerservice.ManagedClustersClientListByResourceGroupResponse])

	// ListClusterAdminCredentials is the fake for method ManagedClustersClient.ListClusterAdminCredentials
	// HTTP status codes to indicate success: http.StatusOK
	ListClusterAdminCredentials func(ctx context.Context, resourceGroupName string, resourceName string, options *armcontainerservice.ManagedClustersClientListClusterAdminCredentialsOptions) (resp azfake.Responder[armcontainerservice.ManagedClustersClientListClusterAdminCredentialsResponse], errResp azfake.ErrorResponder)

	// ListClusterMonitoringUserCredentials is the fake for method ManagedClustersClient.ListClusterMonitoringUserCredentials
	// HTTP status codes to indicate success: http.StatusOK
	ListClusterMonitoringUserCredentials func(ctx context.Context, resourceGroupName string, resourceName string, options *armcontainerservice.ManagedClustersClientListClusterMonitoringUserCredentialsOptions) (resp azfake.Responder[armcontainerservice.ManagedClustersClientListClusterMonitoringUserCredentialsResponse], errResp azfake.ErrorResponder)

	// ListClusterUserCredentials is the fake for method ManagedClustersClient.ListClusterUserCredentials
	// HTTP status codes to indicate success: http.StatusOK
	ListClusterUserCredentials func(ctx context.Context, resourceGroupName string, resourceName string, options *armcontainerservice.ManagedClustersClientListClusterUserCredentialsOptions) (resp azfake.Responder[armcontainerservice.ManagedClustersClientListClusterUserCredentialsResponse], errResp azfake.ErrorResponder)

	// NewListGuardrailsVersionsPager is the fake for method ManagedClustersClient.NewListGuardrailsVersionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListGuardrailsVersionsPager func(location string, options *armcontainerservice.ManagedClustersClientListGuardrailsVersionsOptions) (resp azfake.PagerResponder[armcontainerservice.ManagedClustersClientListGuardrailsVersionsResponse])

	// ListKubernetesVersions is the fake for method ManagedClustersClient.ListKubernetesVersions
	// HTTP status codes to indicate success: http.StatusOK
	ListKubernetesVersions func(ctx context.Context, location string, options *armcontainerservice.ManagedClustersClientListKubernetesVersionsOptions) (resp azfake.Responder[armcontainerservice.ManagedClustersClientListKubernetesVersionsResponse], errResp azfake.ErrorResponder)

	// NewListMeshRevisionProfilesPager is the fake for method ManagedClustersClient.NewListMeshRevisionProfilesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMeshRevisionProfilesPager func(location string, options *armcontainerservice.ManagedClustersClientListMeshRevisionProfilesOptions) (resp azfake.PagerResponder[armcontainerservice.ManagedClustersClientListMeshRevisionProfilesResponse])

	// NewListMeshUpgradeProfilesPager is the fake for method ManagedClustersClient.NewListMeshUpgradeProfilesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMeshUpgradeProfilesPager func(resourceGroupName string, resourceName string, options *armcontainerservice.ManagedClustersClientListMeshUpgradeProfilesOptions) (resp azfake.PagerResponder[armcontainerservice.ManagedClustersClientListMeshUpgradeProfilesResponse])

	// NewListOutboundNetworkDependenciesEndpointsPager is the fake for method ManagedClustersClient.NewListOutboundNetworkDependenciesEndpointsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListOutboundNetworkDependenciesEndpointsPager func(resourceGroupName string, resourceName string, options *armcontainerservice.ManagedClustersClientListOutboundNetworkDependenciesEndpointsOptions) (resp azfake.PagerResponder[armcontainerservice.ManagedClustersClientListOutboundNetworkDependenciesEndpointsResponse])

	// BeginResetAADProfile is the fake for method ManagedClustersClient.BeginResetAADProfile
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginResetAADProfile func(ctx context.Context, resourceGroupName string, resourceName string, parameters armcontainerservice.ManagedClusterAADProfile, options *armcontainerservice.ManagedClustersClientBeginResetAADProfileOptions) (resp azfake.PollerResponder[armcontainerservice.ManagedClustersClientResetAADProfileResponse], errResp azfake.ErrorResponder)

	// BeginResetServicePrincipalProfile is the fake for method ManagedClustersClient.BeginResetServicePrincipalProfile
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginResetServicePrincipalProfile func(ctx context.Context, resourceGroupName string, resourceName string, parameters armcontainerservice.ManagedClusterServicePrincipalProfile, options *armcontainerservice.ManagedClustersClientBeginResetServicePrincipalProfileOptions) (resp azfake.PollerResponder[armcontainerservice.ManagedClustersClientResetServicePrincipalProfileResponse], errResp azfake.ErrorResponder)

	// BeginRotateClusterCertificates is the fake for method ManagedClustersClient.BeginRotateClusterCertificates
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginRotateClusterCertificates func(ctx context.Context, resourceGroupName string, resourceName string, options *armcontainerservice.ManagedClustersClientBeginRotateClusterCertificatesOptions) (resp azfake.PollerResponder[armcontainerservice.ManagedClustersClientRotateClusterCertificatesResponse], errResp azfake.ErrorResponder)

	// BeginRotateServiceAccountSigningKeys is the fake for method ManagedClustersClient.BeginRotateServiceAccountSigningKeys
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginRotateServiceAccountSigningKeys func(ctx context.Context, resourceGroupName string, resourceName string, options *armcontainerservice.ManagedClustersClientBeginRotateServiceAccountSigningKeysOptions) (resp azfake.PollerResponder[armcontainerservice.ManagedClustersClientRotateServiceAccountSigningKeysResponse], errResp azfake.ErrorResponder)

	// BeginRunCommand is the fake for method ManagedClustersClient.BeginRunCommand
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRunCommand func(ctx context.Context, resourceGroupName string, resourceName string, requestPayload armcontainerservice.RunCommandRequest, options *armcontainerservice.ManagedClustersClientBeginRunCommandOptions) (resp azfake.PollerResponder[armcontainerservice.ManagedClustersClientRunCommandResponse], errResp azfake.ErrorResponder)

	// BeginStart is the fake for method ManagedClustersClient.BeginStart
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginStart func(ctx context.Context, resourceGroupName string, resourceName string, options *armcontainerservice.ManagedClustersClientBeginStartOptions) (resp azfake.PollerResponder[armcontainerservice.ManagedClustersClientStartResponse], errResp azfake.ErrorResponder)

	// BeginStop is the fake for method ManagedClustersClient.BeginStop
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginStop func(ctx context.Context, resourceGroupName string, resourceName string, options *armcontainerservice.ManagedClustersClientBeginStopOptions) (resp azfake.PollerResponder[armcontainerservice.ManagedClustersClientStopResponse], errResp azfake.ErrorResponder)

	// BeginUpdateTags is the fake for method ManagedClustersClient.BeginUpdateTags
	// HTTP status codes to indicate success: http.StatusOK
	BeginUpdateTags func(ctx context.Context, resourceGroupName string, resourceName string, parameters armcontainerservice.TagsObject, options *armcontainerservice.ManagedClustersClientBeginUpdateTagsOptions) (resp azfake.PollerResponder[armcontainerservice.ManagedClustersClientUpdateTagsResponse], errResp azfake.ErrorResponder)
}

// NewManagedClustersServerTransport creates a new instance of ManagedClustersServerTransport with the provided implementation.
// The returned ManagedClustersServerTransport instance is connected to an instance of armcontainerservice.ManagedClustersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagedClustersServerTransport(srv *ManagedClustersServer) *ManagedClustersServerTransport {
	return &ManagedClustersServerTransport{
		srv:                              srv,
		beginAbortLatestOperation:        newTracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientAbortLatestOperationResponse]](),
		beginCreateOrUpdate:              newTracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientCreateOrUpdateResponse]](),
		beginDelete:                      newTracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientDeleteResponse]](),
		newListPager:                     newTracker[azfake.PagerResponder[armcontainerservice.ManagedClustersClientListResponse]](),
		newListByResourceGroupPager:      newTracker[azfake.PagerResponder[armcontainerservice.ManagedClustersClientListByResourceGroupResponse]](),
		newListGuardrailsVersionsPager:   newTracker[azfake.PagerResponder[armcontainerservice.ManagedClustersClientListGuardrailsVersionsResponse]](),
		newListMeshRevisionProfilesPager: newTracker[azfake.PagerResponder[armcontainerservice.ManagedClustersClientListMeshRevisionProfilesResponse]](),
		newListMeshUpgradeProfilesPager:  newTracker[azfake.PagerResponder[armcontainerservice.ManagedClustersClientListMeshUpgradeProfilesResponse]](),
		newListOutboundNetworkDependenciesEndpointsPager: newTracker[azfake.PagerResponder[armcontainerservice.ManagedClustersClientListOutboundNetworkDependenciesEndpointsResponse]](),
		beginResetAADProfile:                             newTracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientResetAADProfileResponse]](),
		beginResetServicePrincipalProfile:                newTracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientResetServicePrincipalProfileResponse]](),
		beginRotateClusterCertificates:                   newTracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientRotateClusterCertificatesResponse]](),
		beginRotateServiceAccountSigningKeys:             newTracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientRotateServiceAccountSigningKeysResponse]](),
		beginRunCommand:                                  newTracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientRunCommandResponse]](),
		beginStart:                                       newTracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientStartResponse]](),
		beginStop:                                        newTracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientStopResponse]](),
		beginUpdateTags:                                  newTracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientUpdateTagsResponse]](),
	}
}

// ManagedClustersServerTransport connects instances of armcontainerservice.ManagedClustersClient to instances of ManagedClustersServer.
// Don't use this type directly, use NewManagedClustersServerTransport instead.
type ManagedClustersServerTransport struct {
	srv                                              *ManagedClustersServer
	beginAbortLatestOperation                        *tracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientAbortLatestOperationResponse]]
	beginCreateOrUpdate                              *tracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientCreateOrUpdateResponse]]
	beginDelete                                      *tracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientDeleteResponse]]
	newListPager                                     *tracker[azfake.PagerResponder[armcontainerservice.ManagedClustersClientListResponse]]
	newListByResourceGroupPager                      *tracker[azfake.PagerResponder[armcontainerservice.ManagedClustersClientListByResourceGroupResponse]]
	newListGuardrailsVersionsPager                   *tracker[azfake.PagerResponder[armcontainerservice.ManagedClustersClientListGuardrailsVersionsResponse]]
	newListMeshRevisionProfilesPager                 *tracker[azfake.PagerResponder[armcontainerservice.ManagedClustersClientListMeshRevisionProfilesResponse]]
	newListMeshUpgradeProfilesPager                  *tracker[azfake.PagerResponder[armcontainerservice.ManagedClustersClientListMeshUpgradeProfilesResponse]]
	newListOutboundNetworkDependenciesEndpointsPager *tracker[azfake.PagerResponder[armcontainerservice.ManagedClustersClientListOutboundNetworkDependenciesEndpointsResponse]]
	beginResetAADProfile                             *tracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientResetAADProfileResponse]]
	beginResetServicePrincipalProfile                *tracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientResetServicePrincipalProfileResponse]]
	beginRotateClusterCertificates                   *tracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientRotateClusterCertificatesResponse]]
	beginRotateServiceAccountSigningKeys             *tracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientRotateServiceAccountSigningKeysResponse]]
	beginRunCommand                                  *tracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientRunCommandResponse]]
	beginStart                                       *tracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientStartResponse]]
	beginStop                                        *tracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientStopResponse]]
	beginUpdateTags                                  *tracker[azfake.PollerResponder[armcontainerservice.ManagedClustersClientUpdateTagsResponse]]
}

// Do implements the policy.Transporter interface for ManagedClustersServerTransport.
func (m *ManagedClustersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagedClustersClient.BeginAbortLatestOperation":
		resp, err = m.dispatchBeginAbortLatestOperation(req)
	case "ManagedClustersClient.BeginCreateOrUpdate":
		resp, err = m.dispatchBeginCreateOrUpdate(req)
	case "ManagedClustersClient.BeginDelete":
		resp, err = m.dispatchBeginDelete(req)
	case "ManagedClustersClient.Get":
		resp, err = m.dispatchGet(req)
	case "ManagedClustersClient.GetAccessProfile":
		resp, err = m.dispatchGetAccessProfile(req)
	case "ManagedClustersClient.GetCommandResult":
		resp, err = m.dispatchGetCommandResult(req)
	case "ManagedClustersClient.GetGuardrailsVersions":
		resp, err = m.dispatchGetGuardrailsVersions(req)
	case "ManagedClustersClient.GetMeshRevisionProfile":
		resp, err = m.dispatchGetMeshRevisionProfile(req)
	case "ManagedClustersClient.GetMeshUpgradeProfile":
		resp, err = m.dispatchGetMeshUpgradeProfile(req)
	case "ManagedClustersClient.GetOSOptions":
		resp, err = m.dispatchGetOSOptions(req)
	case "ManagedClustersClient.GetUpgradeProfile":
		resp, err = m.dispatchGetUpgradeProfile(req)
	case "ManagedClustersClient.NewListPager":
		resp, err = m.dispatchNewListPager(req)
	case "ManagedClustersClient.NewListByResourceGroupPager":
		resp, err = m.dispatchNewListByResourceGroupPager(req)
	case "ManagedClustersClient.ListClusterAdminCredentials":
		resp, err = m.dispatchListClusterAdminCredentials(req)
	case "ManagedClustersClient.ListClusterMonitoringUserCredentials":
		resp, err = m.dispatchListClusterMonitoringUserCredentials(req)
	case "ManagedClustersClient.ListClusterUserCredentials":
		resp, err = m.dispatchListClusterUserCredentials(req)
	case "ManagedClustersClient.NewListGuardrailsVersionsPager":
		resp, err = m.dispatchNewListGuardrailsVersionsPager(req)
	case "ManagedClustersClient.ListKubernetesVersions":
		resp, err = m.dispatchListKubernetesVersions(req)
	case "ManagedClustersClient.NewListMeshRevisionProfilesPager":
		resp, err = m.dispatchNewListMeshRevisionProfilesPager(req)
	case "ManagedClustersClient.NewListMeshUpgradeProfilesPager":
		resp, err = m.dispatchNewListMeshUpgradeProfilesPager(req)
	case "ManagedClustersClient.NewListOutboundNetworkDependenciesEndpointsPager":
		resp, err = m.dispatchNewListOutboundNetworkDependenciesEndpointsPager(req)
	case "ManagedClustersClient.BeginResetAADProfile":
		resp, err = m.dispatchBeginResetAADProfile(req)
	case "ManagedClustersClient.BeginResetServicePrincipalProfile":
		resp, err = m.dispatchBeginResetServicePrincipalProfile(req)
	case "ManagedClustersClient.BeginRotateClusterCertificates":
		resp, err = m.dispatchBeginRotateClusterCertificates(req)
	case "ManagedClustersClient.BeginRotateServiceAccountSigningKeys":
		resp, err = m.dispatchBeginRotateServiceAccountSigningKeys(req)
	case "ManagedClustersClient.BeginRunCommand":
		resp, err = m.dispatchBeginRunCommand(req)
	case "ManagedClustersClient.BeginStart":
		resp, err = m.dispatchBeginStart(req)
	case "ManagedClustersClient.BeginStop":
		resp, err = m.dispatchBeginStop(req)
	case "ManagedClustersClient.BeginUpdateTags":
		resp, err = m.dispatchBeginUpdateTags(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchBeginAbortLatestOperation(req *http.Request) (*http.Response, error) {
	if m.srv.BeginAbortLatestOperation == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginAbortLatestOperation not implemented")}
	}
	beginAbortLatestOperation := m.beginAbortLatestOperation.get(req)
	if beginAbortLatestOperation == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedclusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/abort`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginAbortLatestOperation(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginAbortLatestOperation = &respr
		m.beginAbortLatestOperation.add(req, beginAbortLatestOperation)
	}

	resp, err := server.PollerResponderNext(beginAbortLatestOperation, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginAbortLatestOperation.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginAbortLatestOperation) {
		m.beginAbortLatestOperation.remove(req)
	}

	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := m.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcontainerservice.ManagedCluster](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, resourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		m.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		m.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		m.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := m.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		ignorePodDisruptionBudgetUnescaped, err := url.QueryUnescape(qp.Get("ignore-pod-disruption-budget"))
		if err != nil {
			return nil, err
		}
		ignorePodDisruptionBudgetParam, err := parseOptional(ignorePodDisruptionBudgetUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armcontainerservice.ManagedClustersClientBeginDeleteOptions
		if ignorePodDisruptionBudgetParam != nil {
			options = &armcontainerservice.ManagedClustersClientBeginDeleteOptions{
				IgnorePodDisruptionBudget: ignorePodDisruptionBudgetParam,
			}
		}
		respr, errRespr := m.srv.BeginDelete(req.Context(), resourceGroupNameParam, resourceNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		m.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		m.beginDelete.remove(req)
	}

	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagedCluster, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchGetAccessProfile(req *http.Request) (*http.Response, error) {
	if m.srv.GetAccessProfile == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAccessProfile not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accessProfiles/(?P<roleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listCredential`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	roleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("roleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetAccessProfile(req.Context(), resourceGroupNameParam, resourceNameParam, roleNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagedClusterAccessProfile, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchGetCommandResult(req *http.Request) (*http.Response, error) {
	if m.srv.GetCommandResult == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetCommandResult not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/commandResults/(?P<commandId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	commandIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("commandId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetCommandResult(req.Context(), resourceGroupNameParam, resourceNameParam, commandIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RunCommandResult, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).Location; val != nil {
		resp.Header.Set("Location", *val)
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchGetGuardrailsVersions(req *http.Request) (*http.Response, error) {
	if m.srv.GetGuardrailsVersions == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetGuardrailsVersions not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/guardrailsVersions/(?P<version>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	versionParam, err := url.PathUnescape(matches[regex.SubexpIndex("version")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetGuardrailsVersions(req.Context(), locationParam, versionParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GuardrailsAvailableVersion, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchGetMeshRevisionProfile(req *http.Request) (*http.Response, error) {
	if m.srv.GetMeshRevisionProfile == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMeshRevisionProfile not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/meshRevisionProfiles/(?P<mode>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	modeParam, err := url.PathUnescape(matches[regex.SubexpIndex("mode")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetMeshRevisionProfile(req.Context(), locationParam, modeParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MeshRevisionProfile, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchGetMeshUpgradeProfile(req *http.Request) (*http.Response, error) {
	if m.srv.GetMeshUpgradeProfile == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMeshUpgradeProfile not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/meshUpgradeProfiles/(?P<mode>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	modeParam, err := url.PathUnescape(matches[regex.SubexpIndex("mode")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetMeshUpgradeProfile(req.Context(), resourceGroupNameParam, resourceNameParam, modeParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MeshUpgradeProfile, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchGetOSOptions(req *http.Request) (*http.Response, error) {
	if m.srv.GetOSOptions == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetOSOptions not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/osOptions/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	resourceTypeUnescaped, err := url.QueryUnescape(qp.Get("resource-type"))
	if err != nil {
		return nil, err
	}
	resourceTypeParam := getOptional(resourceTypeUnescaped)
	var options *armcontainerservice.ManagedClustersClientGetOSOptionsOptions
	if resourceTypeParam != nil {
		options = &armcontainerservice.ManagedClustersClientGetOSOptionsOptions{
			ResourceType: resourceTypeParam,
		}
	}
	respr, errRespr := m.srv.GetOSOptions(req.Context(), locationParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).OSOptionProfile, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchGetUpgradeProfile(req *http.Request) (*http.Response, error) {
	if m.srv.GetUpgradeProfile == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetUpgradeProfile not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/upgradeProfiles/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetUpgradeProfile(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagedClusterUpgradeProfile, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := m.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := m.srv.NewListPager(nil)
		newListPager = &resp
		m.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armcontainerservice.ManagedClustersClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		m.newListPager.remove(req)
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := m.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		m.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armcontainerservice.ManagedClustersClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		m.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchListClusterAdminCredentials(req *http.Request) (*http.Response, error) {
	if m.srv.ListClusterAdminCredentials == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListClusterAdminCredentials not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listClusterAdminCredential`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	serverFqdnUnescaped, err := url.QueryUnescape(qp.Get("server-fqdn"))
	if err != nil {
		return nil, err
	}
	serverFqdnParam := getOptional(serverFqdnUnescaped)
	var options *armcontainerservice.ManagedClustersClientListClusterAdminCredentialsOptions
	if serverFqdnParam != nil {
		options = &armcontainerservice.ManagedClustersClientListClusterAdminCredentialsOptions{
			ServerFqdn: serverFqdnParam,
		}
	}
	respr, errRespr := m.srv.ListClusterAdminCredentials(req.Context(), resourceGroupNameParam, resourceNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CredentialResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchListClusterMonitoringUserCredentials(req *http.Request) (*http.Response, error) {
	if m.srv.ListClusterMonitoringUserCredentials == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListClusterMonitoringUserCredentials not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listClusterMonitoringUserCredential`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	serverFqdnUnescaped, err := url.QueryUnescape(qp.Get("server-fqdn"))
	if err != nil {
		return nil, err
	}
	serverFqdnParam := getOptional(serverFqdnUnescaped)
	var options *armcontainerservice.ManagedClustersClientListClusterMonitoringUserCredentialsOptions
	if serverFqdnParam != nil {
		options = &armcontainerservice.ManagedClustersClientListClusterMonitoringUserCredentialsOptions{
			ServerFqdn: serverFqdnParam,
		}
	}
	respr, errRespr := m.srv.ListClusterMonitoringUserCredentials(req.Context(), resourceGroupNameParam, resourceNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CredentialResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchListClusterUserCredentials(req *http.Request) (*http.Response, error) {
	if m.srv.ListClusterUserCredentials == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListClusterUserCredentials not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listClusterUserCredential`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	serverFqdnUnescaped, err := url.QueryUnescape(qp.Get("server-fqdn"))
	if err != nil {
		return nil, err
	}
	serverFqdnParam := getOptional(serverFqdnUnescaped)
	formatUnescaped, err := url.QueryUnescape(qp.Get("format"))
	if err != nil {
		return nil, err
	}
	formatParam := getOptional(armcontainerservice.Format(formatUnescaped))
	var options *armcontainerservice.ManagedClustersClientListClusterUserCredentialsOptions
	if serverFqdnParam != nil || formatParam != nil {
		options = &armcontainerservice.ManagedClustersClientListClusterUserCredentialsOptions{
			ServerFqdn: serverFqdnParam,
			Format:     formatParam,
		}
	}
	respr, errRespr := m.srv.ListClusterUserCredentials(req.Context(), resourceGroupNameParam, resourceNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CredentialResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchNewListGuardrailsVersionsPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListGuardrailsVersionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListGuardrailsVersionsPager not implemented")}
	}
	newListGuardrailsVersionsPager := m.newListGuardrailsVersionsPager.get(req)
	if newListGuardrailsVersionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/guardrailsVersions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListGuardrailsVersionsPager(locationParam, nil)
		newListGuardrailsVersionsPager = &resp
		m.newListGuardrailsVersionsPager.add(req, newListGuardrailsVersionsPager)
		server.PagerResponderInjectNextLinks(newListGuardrailsVersionsPager, req, func(page *armcontainerservice.ManagedClustersClientListGuardrailsVersionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListGuardrailsVersionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListGuardrailsVersionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListGuardrailsVersionsPager) {
		m.newListGuardrailsVersionsPager.remove(req)
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchListKubernetesVersions(req *http.Request) (*http.Response, error) {
	if m.srv.ListKubernetesVersions == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListKubernetesVersions not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kubernetesVersions`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.ListKubernetesVersions(req.Context(), locationParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KubernetesVersionListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchNewListMeshRevisionProfilesPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListMeshRevisionProfilesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMeshRevisionProfilesPager not implemented")}
	}
	newListMeshRevisionProfilesPager := m.newListMeshRevisionProfilesPager.get(req)
	if newListMeshRevisionProfilesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/meshRevisionProfiles`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListMeshRevisionProfilesPager(locationParam, nil)
		newListMeshRevisionProfilesPager = &resp
		m.newListMeshRevisionProfilesPager.add(req, newListMeshRevisionProfilesPager)
		server.PagerResponderInjectNextLinks(newListMeshRevisionProfilesPager, req, func(page *armcontainerservice.ManagedClustersClientListMeshRevisionProfilesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListMeshRevisionProfilesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListMeshRevisionProfilesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMeshRevisionProfilesPager) {
		m.newListMeshRevisionProfilesPager.remove(req)
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchNewListMeshUpgradeProfilesPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListMeshUpgradeProfilesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMeshUpgradeProfilesPager not implemented")}
	}
	newListMeshUpgradeProfilesPager := m.newListMeshUpgradeProfilesPager.get(req)
	if newListMeshUpgradeProfilesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/meshUpgradeProfiles`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListMeshUpgradeProfilesPager(resourceGroupNameParam, resourceNameParam, nil)
		newListMeshUpgradeProfilesPager = &resp
		m.newListMeshUpgradeProfilesPager.add(req, newListMeshUpgradeProfilesPager)
		server.PagerResponderInjectNextLinks(newListMeshUpgradeProfilesPager, req, func(page *armcontainerservice.ManagedClustersClientListMeshUpgradeProfilesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListMeshUpgradeProfilesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListMeshUpgradeProfilesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMeshUpgradeProfilesPager) {
		m.newListMeshUpgradeProfilesPager.remove(req)
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchNewListOutboundNetworkDependenciesEndpointsPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListOutboundNetworkDependenciesEndpointsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListOutboundNetworkDependenciesEndpointsPager not implemented")}
	}
	newListOutboundNetworkDependenciesEndpointsPager := m.newListOutboundNetworkDependenciesEndpointsPager.get(req)
	if newListOutboundNetworkDependenciesEndpointsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/outboundNetworkDependenciesEndpoints`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListOutboundNetworkDependenciesEndpointsPager(resourceGroupNameParam, resourceNameParam, nil)
		newListOutboundNetworkDependenciesEndpointsPager = &resp
		m.newListOutboundNetworkDependenciesEndpointsPager.add(req, newListOutboundNetworkDependenciesEndpointsPager)
		server.PagerResponderInjectNextLinks(newListOutboundNetworkDependenciesEndpointsPager, req, func(page *armcontainerservice.ManagedClustersClientListOutboundNetworkDependenciesEndpointsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListOutboundNetworkDependenciesEndpointsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListOutboundNetworkDependenciesEndpointsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListOutboundNetworkDependenciesEndpointsPager) {
		m.newListOutboundNetworkDependenciesEndpointsPager.remove(req)
	}
	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchBeginResetAADProfile(req *http.Request) (*http.Response, error) {
	if m.srv.BeginResetAADProfile == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResetAADProfile not implemented")}
	}
	beginResetAADProfile := m.beginResetAADProfile.get(req)
	if beginResetAADProfile == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resetAADProfile`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcontainerservice.ManagedClusterAADProfile](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginResetAADProfile(req.Context(), resourceGroupNameParam, resourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResetAADProfile = &respr
		m.beginResetAADProfile.add(req, beginResetAADProfile)
	}

	resp, err := server.PollerResponderNext(beginResetAADProfile, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginResetAADProfile.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResetAADProfile) {
		m.beginResetAADProfile.remove(req)
	}

	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchBeginResetServicePrincipalProfile(req *http.Request) (*http.Response, error) {
	if m.srv.BeginResetServicePrincipalProfile == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResetServicePrincipalProfile not implemented")}
	}
	beginResetServicePrincipalProfile := m.beginResetServicePrincipalProfile.get(req)
	if beginResetServicePrincipalProfile == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resetServicePrincipalProfile`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcontainerservice.ManagedClusterServicePrincipalProfile](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginResetServicePrincipalProfile(req.Context(), resourceGroupNameParam, resourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResetServicePrincipalProfile = &respr
		m.beginResetServicePrincipalProfile.add(req, beginResetServicePrincipalProfile)
	}

	resp, err := server.PollerResponderNext(beginResetServicePrincipalProfile, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginResetServicePrincipalProfile.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResetServicePrincipalProfile) {
		m.beginResetServicePrincipalProfile.remove(req)
	}

	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchBeginRotateClusterCertificates(req *http.Request) (*http.Response, error) {
	if m.srv.BeginRotateClusterCertificates == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRotateClusterCertificates not implemented")}
	}
	beginRotateClusterCertificates := m.beginRotateClusterCertificates.get(req)
	if beginRotateClusterCertificates == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/rotateClusterCertificates`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginRotateClusterCertificates(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRotateClusterCertificates = &respr
		m.beginRotateClusterCertificates.add(req, beginRotateClusterCertificates)
	}

	resp, err := server.PollerResponderNext(beginRotateClusterCertificates, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginRotateClusterCertificates.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRotateClusterCertificates) {
		m.beginRotateClusterCertificates.remove(req)
	}

	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchBeginRotateServiceAccountSigningKeys(req *http.Request) (*http.Response, error) {
	if m.srv.BeginRotateServiceAccountSigningKeys == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRotateServiceAccountSigningKeys not implemented")}
	}
	beginRotateServiceAccountSigningKeys := m.beginRotateServiceAccountSigningKeys.get(req)
	if beginRotateServiceAccountSigningKeys == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/rotateServiceAccountSigningKeys`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginRotateServiceAccountSigningKeys(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRotateServiceAccountSigningKeys = &respr
		m.beginRotateServiceAccountSigningKeys.add(req, beginRotateServiceAccountSigningKeys)
	}

	resp, err := server.PollerResponderNext(beginRotateServiceAccountSigningKeys, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginRotateServiceAccountSigningKeys.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRotateServiceAccountSigningKeys) {
		m.beginRotateServiceAccountSigningKeys.remove(req)
	}

	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchBeginRunCommand(req *http.Request) (*http.Response, error) {
	if m.srv.BeginRunCommand == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRunCommand not implemented")}
	}
	beginRunCommand := m.beginRunCommand.get(req)
	if beginRunCommand == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/runCommand`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcontainerservice.RunCommandRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginRunCommand(req.Context(), resourceGroupNameParam, resourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRunCommand = &respr
		m.beginRunCommand.add(req, beginRunCommand)
	}

	resp, err := server.PollerResponderNext(beginRunCommand, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginRunCommand.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRunCommand) {
		m.beginRunCommand.remove(req)
	}

	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchBeginStart(req *http.Request) (*http.Response, error) {
	if m.srv.BeginStart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStart not implemented")}
	}
	beginStart := m.beginStart.get(req)
	if beginStart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginStart(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStart = &respr
		m.beginStart.add(req, beginStart)
	}

	resp, err := server.PollerResponderNext(beginStart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginStart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStart) {
		m.beginStart.remove(req)
	}

	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchBeginStop(req *http.Request) (*http.Response, error) {
	if m.srv.BeginStop == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStop not implemented")}
	}
	beginStop := m.beginStop.get(req)
	if beginStop == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginStop(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStop = &respr
		m.beginStop.add(req, beginStop)
	}

	resp, err := server.PollerResponderNext(beginStop, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginStop.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStop) {
		m.beginStop.remove(req)
	}

	return resp, nil
}

func (m *ManagedClustersServerTransport) dispatchBeginUpdateTags(req *http.Request) (*http.Response, error) {
	if m.srv.BeginUpdateTags == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateTags not implemented")}
	}
	beginUpdateTags := m.beginUpdateTags.get(req)
	if beginUpdateTags == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerService/managedClusters/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcontainerservice.TagsObject](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginUpdateTags(req.Context(), resourceGroupNameParam, resourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateTags = &respr
		m.beginUpdateTags.add(req, beginUpdateTags)
	}

	resp, err := server.PollerResponderNext(beginUpdateTags, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.beginUpdateTags.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateTags) {
		m.beginUpdateTags.remove(req)
	}

	return resp, nil
}
