//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsynapse

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// WorkspaceManagedSQLServerVulnerabilityAssessmentsClient contains the methods for the WorkspaceManagedSQLServerVulnerabilityAssessments group.
// Don't use this type directly, use NewWorkspaceManagedSQLServerVulnerabilityAssessmentsClient() instead.
type WorkspaceManagedSQLServerVulnerabilityAssessmentsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewWorkspaceManagedSQLServerVulnerabilityAssessmentsClient creates a new instance of WorkspaceManagedSQLServerVulnerabilityAssessmentsClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewWorkspaceManagedSQLServerVulnerabilityAssessmentsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*WorkspaceManagedSQLServerVulnerabilityAssessmentsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &WorkspaceManagedSQLServerVulnerabilityAssessmentsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - Create or Update workspace managed sql server's vulnerability assessment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-06-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the workspace.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - parameters - Properties for vulnerability assessment.
//   - options - WorkspaceManagedSQLServerVulnerabilityAssessmentsClientCreateOrUpdateOptions contains the optional parameters
//     for the WorkspaceManagedSQLServerVulnerabilityAssessmentsClient.CreateOrUpdate method.
func (client *WorkspaceManagedSQLServerVulnerabilityAssessmentsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, workspaceName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, parameters ServerVulnerabilityAssessment, options *WorkspaceManagedSQLServerVulnerabilityAssessmentsClientCreateOrUpdateOptions) (WorkspaceManagedSQLServerVulnerabilityAssessmentsClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "WorkspaceManagedSQLServerVulnerabilityAssessmentsClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, workspaceName, vulnerabilityAssessmentName, parameters, options)
	if err != nil {
		return WorkspaceManagedSQLServerVulnerabilityAssessmentsClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return WorkspaceManagedSQLServerVulnerabilityAssessmentsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return WorkspaceManagedSQLServerVulnerabilityAssessmentsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *WorkspaceManagedSQLServerVulnerabilityAssessmentsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, parameters ServerVulnerabilityAssessment, options *WorkspaceManagedSQLServerVulnerabilityAssessmentsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *WorkspaceManagedSQLServerVulnerabilityAssessmentsClient) createOrUpdateHandleResponse(resp *http.Response) (WorkspaceManagedSQLServerVulnerabilityAssessmentsClientCreateOrUpdateResponse, error) {
	result := WorkspaceManagedSQLServerVulnerabilityAssessmentsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServerVulnerabilityAssessment); err != nil {
		return WorkspaceManagedSQLServerVulnerabilityAssessmentsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Remove workspace managed sql server's vulnerability assessment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-06-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the workspace.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - options - WorkspaceManagedSQLServerVulnerabilityAssessmentsClientDeleteOptions contains the optional parameters for the
//     WorkspaceManagedSQLServerVulnerabilityAssessmentsClient.Delete method.
func (client *WorkspaceManagedSQLServerVulnerabilityAssessmentsClient) Delete(ctx context.Context, resourceGroupName string, workspaceName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *WorkspaceManagedSQLServerVulnerabilityAssessmentsClientDeleteOptions) (WorkspaceManagedSQLServerVulnerabilityAssessmentsClientDeleteResponse, error) {
	var err error
	const operationName = "WorkspaceManagedSQLServerVulnerabilityAssessmentsClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, workspaceName, vulnerabilityAssessmentName, options)
	if err != nil {
		return WorkspaceManagedSQLServerVulnerabilityAssessmentsClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return WorkspaceManagedSQLServerVulnerabilityAssessmentsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return WorkspaceManagedSQLServerVulnerabilityAssessmentsClientDeleteResponse{}, err
	}
	return WorkspaceManagedSQLServerVulnerabilityAssessmentsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *WorkspaceManagedSQLServerVulnerabilityAssessmentsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *WorkspaceManagedSQLServerVulnerabilityAssessmentsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - Get workspace managed sql server's vulnerability assessment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-06-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the workspace.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - options - WorkspaceManagedSQLServerVulnerabilityAssessmentsClientGetOptions contains the optional parameters for the WorkspaceManagedSQLServerVulnerabilityAssessmentsClient.Get
//     method.
func (client *WorkspaceManagedSQLServerVulnerabilityAssessmentsClient) Get(ctx context.Context, resourceGroupName string, workspaceName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *WorkspaceManagedSQLServerVulnerabilityAssessmentsClientGetOptions) (WorkspaceManagedSQLServerVulnerabilityAssessmentsClientGetResponse, error) {
	var err error
	const operationName = "WorkspaceManagedSQLServerVulnerabilityAssessmentsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, workspaceName, vulnerabilityAssessmentName, options)
	if err != nil {
		return WorkspaceManagedSQLServerVulnerabilityAssessmentsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return WorkspaceManagedSQLServerVulnerabilityAssessmentsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return WorkspaceManagedSQLServerVulnerabilityAssessmentsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *WorkspaceManagedSQLServerVulnerabilityAssessmentsClient) getCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *WorkspaceManagedSQLServerVulnerabilityAssessmentsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *WorkspaceManagedSQLServerVulnerabilityAssessmentsClient) getHandleResponse(resp *http.Response) (WorkspaceManagedSQLServerVulnerabilityAssessmentsClientGetResponse, error) {
	result := WorkspaceManagedSQLServerVulnerabilityAssessmentsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServerVulnerabilityAssessment); err != nil {
		return WorkspaceManagedSQLServerVulnerabilityAssessmentsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Lists the vulnerability assessment policies associated with a workspace managed sql server.
//
// Generated from API version 2021-06-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the workspace.
//   - options - WorkspaceManagedSQLServerVulnerabilityAssessmentsClientListOptions contains the optional parameters for the WorkspaceManagedSQLServerVulnerabilityAssessmentsClient.NewListPager
//     method.
func (client *WorkspaceManagedSQLServerVulnerabilityAssessmentsClient) NewListPager(resourceGroupName string, workspaceName string, options *WorkspaceManagedSQLServerVulnerabilityAssessmentsClientListOptions) *runtime.Pager[WorkspaceManagedSQLServerVulnerabilityAssessmentsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[WorkspaceManagedSQLServerVulnerabilityAssessmentsClientListResponse]{
		More: func(page WorkspaceManagedSQLServerVulnerabilityAssessmentsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WorkspaceManagedSQLServerVulnerabilityAssessmentsClientListResponse) (WorkspaceManagedSQLServerVulnerabilityAssessmentsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "WorkspaceManagedSQLServerVulnerabilityAssessmentsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, workspaceName, options)
			}, nil)
			if err != nil {
				return WorkspaceManagedSQLServerVulnerabilityAssessmentsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *WorkspaceManagedSQLServerVulnerabilityAssessmentsClient) listCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, options *WorkspaceManagedSQLServerVulnerabilityAssessmentsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/vulnerabilityAssessments"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *WorkspaceManagedSQLServerVulnerabilityAssessmentsClient) listHandleResponse(resp *http.Response) (WorkspaceManagedSQLServerVulnerabilityAssessmentsClientListResponse, error) {
	result := WorkspaceManagedSQLServerVulnerabilityAssessmentsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ServerVulnerabilityAssessmentListResult); err != nil {
		return WorkspaceManagedSQLServerVulnerabilityAssessmentsClientListResponse{}, err
	}
	return result, nil
}
