---
title: IsDefault
description: Reports whether the given site is the default site across all dimensions.
categories: []
keywords: []
params:
  functions_and_methods:
    returnType: bool
    signatures: [SITE.IsDefault]
---

{{< new-in 0.156.0 />}}

The `IsDefault` method on a `Site` object reports whether the given site is the [default site](g) across all dimensions: [language](g), [version](g), and [role](g). This is useful to ensure that a block of code executes only once per build, regardless of the number of [sites](g) generated by your [dimensions](g).

For example, the following configuration defines a matrix of sites across language and version dimensions.

{{< code-toggle file=hugo >}}
[languages.de]
contentDir = 'content/de'
languageCode = 'de-DE'
languageDirection = 'ltr'
languageName = 'Deutsch'
title = 'Projekt Dokumentation'
weight = 1

[languages.en]
contentDir = 'content/en'
languageCode = 'en-US'
languageDirection = 'ltr'
languageName = 'English'
title = 'Project Documentation'
weight = 2

[versions.'v1.0.0']
[versions.'v2.0.0']
[versions.'v3.0.0']
{{< /code-toggle >}}

If you call an initialization partial to handle one-time build logic or global variable setup, wrap that call in an [`if`][] statement using this function. This prevents the logic from being executed for every dimensional variation.

```go-html-template
{{ if .Site.IsDefault }}
  {{ partial "init.html" . }}
{{ end }}
```

In this setup, the code block is only executed for the English version v3.0.0 site. English is selected because it has the lowest weight, and version v3.0.0 is selected because it is the first version when sorted semantically in descending order.

[`if`]: /functions/go-template/if/
