include(../../test_helpers.cmake)

macro(test_version_file filename version)
    unset(PACKAGE_VERSION)
    unset(PACKAGE_VERSION_COMPATIBLE)
    unset(PACKAGE_VERSION_EXACT)
    set(PACKAGE_FIND_VERSION "${version}")
    if(PACKAGE_FIND_VERSION MATCHES "^([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.([0-9]+)$")
        set(PACKAGE_FIND_VERSION_MAJOR "${CMAKE_MATCH_1}")
        set(PACKAGE_FIND_VERSION_MINOR "${CMAKE_MATCH_2}")
        set(PACKAGE_FIND_VERSION_PATCH "${CMAKE_MATCH_3}")
        set(PACKAGE_FIND_VERSION_TWEAK "${CMAKE_MATCH_4}")
        set(PACKAGE_FIND_VERSION_COUNT 4)
    elseif(PACKAGE_FIND_VERSION MATCHES "^([0-9]+)\\.([0-9]+)\\.([0-9]+)$")
        set(PACKAGE_FIND_VERSION_MAJOR "${CMAKE_MATCH_1}")
        set(PACKAGE_FIND_VERSION_MINOR "${CMAKE_MATCH_2}")
        set(PACKAGE_FIND_VERSION_PATCH "${CMAKE_MATCH_3}")
        set(PACKAGE_FIND_VERSION_TWEAK)
        set(PACKAGE_FIND_VERSION_COUNT 3)
    elseif(PACKAGE_FIND_VERSION MATCHES "^([0-9]+)\\.([0-9]+)$")
        set(PACKAGE_FIND_VERSION_MAJOR "${CMAKE_MATCH_1}")
        set(PACKAGE_FIND_VERSION_MINOR "${CMAKE_MATCH_2}")
        set(PACKAGE_FIND_VERSION_PATCH)
        set(PACKAGE_FIND_VERSION_TWEAK)
        set(PACKAGE_FIND_VERSION_COUNT 2)
    elseif(PACKAGE_FIND_VERSION MATCHES "^([0-9]+)$")
        set(PACKAGE_FIND_VERSION_MAJOR "${CMAKE_MATCH_1}")
        set(PACKAGE_FIND_VERSION_MINOR)
        set(PACKAGE_FIND_VERSION_PATCH)
        set(PACKAGE_FIND_VERSION_TWEAK)
        set(PACKAGE_FIND_VERSION_COUNT 1)
    elseif(PACKAGE_FIND_VERSION STREQUAL "")
        set(PACKAGE_FIND_VERSION_MAJOR)
        set(PACKAGE_FIND_VERSION_MINOR)
        set(PACKAGE_FIND_VERSION_PATCH)
        set(PACKAGE_FIND_VERSION_TWEAK)
        set(PACKAGE_FIND_VERSION_COUNT 0)
    else()
        message(STATUS "Invalid version ${PACKAGE_FIND_VERSION}")
    endif()
    include("${filename}")
endmacro()

macro(version_var_checks prefix version)
    assert_var_str_value(${prefix}_VERSION "${version}")
    if(ECM_GLOBAL_FIND_VERSION VERSION_LESS 5.83.0)
        assert_var_str_value(${prefix}_VERSION_STRING "${version}")
    endif()
    if("${version}" MATCHES "^([0-9]+)")
        assert_var_num_value(${prefix}_VERSION_MAJOR ${CMAKE_MATCH_1})
    endif()
    if("${version}" MATCHES "^[0-9]+\\.([0-9]+)")
        assert_var_num_value(${prefix}_VERSION_MINOR ${CMAKE_MATCH_1})
    endif()
    if("${version}" MATCHES "^[0-9]+\\.[0-9]+\\.([0-9]+)")
        assert_var_num_value(${prefix}_VERSION_PATCH ${CMAKE_MATCH_1})
    endif()
    if("${version}" MATCHES "^[0-9]+\\.[0-9]+\\.[0-9]+\\.([0-9]+)")
        assert_var_num_value(${prefix}_VERSION_TWEAK ${CMAKE_MATCH_1})
    endif()
endmacro()

macro(project_version_var_checks version)
    version_var_checks(PROJECT "${version}")
endmacro()

macro(standard_version_var_checks prefix version)
    version_var_checks(PROJECT "${version}")
    version_var_checks("${prefix}" "${version}")
    if(${ARGC} GREATER 2)
        assert_var_num_value(${prefix}_SOVERSION ${ARGV2})
    elseif(DEFINED ${prefix}_VERSION_MAJOR AND NOT ${prefix}_VERSION_MAJOR STREQUAL "")
        assert_var_num_value(${prefix}_SOVERSION "${${prefix}_VERSION_MAJOR}")
    endif()
endmacro()

macro(AnyNewer_2_3_4_checks filename)
    # too old - fails
    test_version_file("${filename}" "3.1.1")
    assert_var_str_value(PACKAGE_VERSION "2.3.4")
    assert_var_bool_value(PACKAGE_VERSION_COMPATIBLE FALSE ALLOW_UNDEFINED)
    assert_var_bool_value(PACKAGE_VERSION_EXACT FALSE ALLOW_UNDEFINED)

    # too old - fails
    test_version_file("${filename}" "3")
    assert_var_str_value(PACKAGE_VERSION "2.3.4")
    assert_var_bool_value(PACKAGE_VERSION_COMPATIBLE FALSE ALLOW_UNDEFINED)
    assert_var_bool_value(PACKAGE_VERSION_EXACT FALSE ALLOW_UNDEFINED)

    # too old - fails
    test_version_file("${filename}" "2.3.4.1")
    assert_var_str_value(PACKAGE_VERSION "2.3.4")
    assert_var_bool_value(PACKAGE_VERSION_COMPATIBLE FALSE ALLOW_UNDEFINED)
    assert_var_bool_value(PACKAGE_VERSION_EXACT FALSE ALLOW_UNDEFINED)

    # newer - succeeds
    test_version_file("${filename}" "1.1.1")
    assert_var_str_value(PACKAGE_VERSION "2.3.4")
    assert_var_bool_value(PACKAGE_VERSION_COMPATIBLE TRUE)
    assert_var_bool_value(PACKAGE_VERSION_EXACT FALSE ALLOW_UNDEFINED)

    # newer - succeeds
    test_version_file("${filename}" "2.1.1")
    assert_var_str_value(PACKAGE_VERSION "2.3.4")
    assert_var_bool_value(PACKAGE_VERSION_COMPATIBLE TRUE)
    assert_var_bool_value(PACKAGE_VERSION_EXACT FALSE ALLOW_UNDEFINED)

    # newer - succeeds
    test_version_file("${filename}" "2")
    assert_var_str_value(PACKAGE_VERSION "2.3.4")
    assert_var_bool_value(PACKAGE_VERSION_COMPATIBLE TRUE)
    assert_var_bool_value(PACKAGE_VERSION_EXACT FALSE ALLOW_UNDEFINED)

    # unspecified - succeeds
    test_version_file("${filename}" "")
    assert_var_str_value(PACKAGE_VERSION "2.3.4")
    assert_var_bool_value(PACKAGE_VERSION_COMPATIBLE TRUE)
    assert_var_bool_value(PACKAGE_VERSION_EXACT FALSE ALLOW_UNDEFINED)

    # exact - succeeds
    test_version_file("${filename}" "2.3.4")
    assert_var_str_value(PACKAGE_VERSION "2.3.4")
    assert_var_bool_value(PACKAGE_VERSION_COMPATIBLE TRUE)
    assert_var_bool_value(PACKAGE_VERSION_EXACT TRUE)
endmacro()
