% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfwl.R
\name{wf}
\alias{wf}
\alias{wl}
\title{Get the index of the first/last TRUE}
\usage{
wf(x, use.names = TRUE)

wl(x, use.names = TRUE)
}
\arguments{
\item{x}{[\code{logical}]\cr
Logical vector.}

\item{use.names}{[\code{logical(1)}]\cr
If \code{TRUE} and \code{x} is named, the result is also
named.}
}
\value{
[\code{integer(1)} | \code{integer(0)}].
 Returns the index of the first/last \code{TRUE} value in \code{x} or
 an empty integer vector if none is found. NAs are ignored.
}
\description{
A quick C implementation for \dQuote{which.first} (\code{head(which(x), 1)}) and
\dQuote{which.last} (\code{tail(which(x), 1)}).
}
\examples{
wf(c(FALSE, TRUE))
wl(c(FALSE, FALSE))
wf(NA)
}
