% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend-hive.R
\name{backend-hive}
\alias{simulate_hive}
\title{Backend: Hive}
\usage{
simulate_hive()
}
\description{
See \code{vignette("translation-function")} and \code{vignette("translation-verb")} for
details of overall translation technology. Key differences for this backend
are a scattering of custom translations provided by users.

Use \code{simulate_hive()} with \code{lazy_frame()} to see simulated SQL without
converting to live access database.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

lf <- lazy_frame(a = TRUE, b = 1, d = 2, c = "z", con = simulate_hive())
lf \%>\% transmute(x = cot(b))
lf \%>\% transmute(x = bitwShiftL(c, 1L))
lf \%>\% transmute(x = str_replace_all(c, "a", "b"))

lf \%>\% summarise(x = median(d, na.rm = TRUE))
lf \%>\% summarise(x = var(c, na.rm = TRUE))
}
