% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-subset-expand.R
\name{expand.dtplyr_step}
\alias{expand.dtplyr_step}
\title{Expand data frame to include all possible combinations of values.}
\usage{
\method{expand}{dtplyr_step}(data, ..., .name_repair = "check_unique")
}
\arguments{
\item{data}{A \code{\link[=lazy_dt]{lazy_dt()}}.}

\item{...}{Specification of columns to expand. Columns can be atomic vectors
or lists.
\itemize{
\item To find all unique combinations of \code{x}, \code{y} and \code{z}, including those not
present in the data, supply each variable as a separate argument:
\code{expand(df, x, y, z)}.
\item To find only the combinations that occur in the
data, use \code{nesting}: \code{expand(df, nesting(x, y, z))}.
\item You can combine the two forms. For example,
\code{expand(df, nesting(school_id, student_id), date)} would produce
a row for each present school-student combination for all possible
dates.
}

Unlike the data.frame method, this method does not use the full set of
levels, just those that appear in the data.

When used with continuous variables, you may need to fill in values
that do not appear in the data: to do so use expressions like
\code{year = 2010:2020} or \code{year = full_seq(year,1)}.}

\item{.name_repair}{One of \code{"check_unique"}, \code{"unique"}, \code{"universal"},
\code{"minimal"}, \code{"unique_quiet"}, or \code{"universal_quiet"}. See \code{\link[vctrs:vec_as_names]{vec_as_names()}}
for the meaning of these options.}
}
\description{
This is a method for the tidyr \code{expand()} generic. It is translated to
\code{\link[data.table:J]{data.table::CJ()}}.
}
\examples{
library(tidyr)

fruits <- lazy_dt(tibble(
  type   = c("apple", "orange", "apple", "orange", "orange", "orange"),
  year   = c(2010, 2010, 2012, 2010, 2010, 2012),
  size  =  factor(
    c("XS", "S",  "M", "S", "S", "M"),
    levels = c("XS", "S", "M", "L")
  ),
  weights = rnorm(6, as.numeric(size) + 2)
))

# All possible combinations ---------------------------------------
# Note that only present levels of the factor variable `size` are retained.
fruits \%>\% expand(type)
fruits \%>\% expand(type, size)

# This is different from the data frame behaviour:
fruits \%>\% dplyr::collect() \%>\% expand(type, size)

# Other uses -------------------------------------------------------
fruits \%>\% expand(type, size, 2010:2012)

# Use `anti_join()` to determine which observations are missing
all <- fruits \%>\% expand(type, size, year)
all
all \%>\% dplyr::anti_join(fruits)

# Use with `right_join()` to fill in missing rows
fruits \%>\% dplyr::right_join(all)
}
