% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.predictCSC.R
\name{confint.predictCSC}
\alias{confint.predictCSC}
\title{Confidence Intervals and Confidence Bands for the Predicted Absolute Risk (Cumulative Incidence Function)}
\usage{
\method{confint}{predictCSC}(
  object,
  parm = NULL,
  level = 0.95,
  n.sim = 10000,
  absRisk.transform = "loglog",
  seed = NA,
  ...
)
}
\arguments{
\item{object}{A \code{predictCSC} object, i.e. output of the \code{predictCSC} function.}

\item{parm}{not used. For compatibility with the generic method.}

\item{level}{[numeric, 0-1] Level of confidence.}

\item{n.sim}{[integer, >0] the number of simulations used to compute the quantiles for the confidence bands.}

\item{absRisk.transform}{[character] the transformation used to improve coverage
of the confidence intervals for the predicted absolute risk in small samples.
Can be \code{"none"}, \code{"log"}, \code{"loglog"}, \code{"cloglog"}.}

\item{seed}{[integer, >0] seed number set before performing simulations for the confidence bands.
If not given or NA no seed is set.}

\item{...}{not used.}
}
\description{
Confidence intervals and confidence Bands for the predicted absolute risk (cumulative incidence function).
}
\details{
The confidence bands and confidence intervals are automatically restricted to the interval [0;1].
}
\examples{
library(survival)
library(prodlim)
#### generate data ####
set.seed(10)
d <- sampleData(100) 

#### estimate a stratified CSC model ###
fit <- CSC(Hist(time,event)~ X1 + strata(X2) + X6, data=d)

#### compute individual specific risks
fit.pred <- predict(fit, newdata=d[1:3], times=c(3,8), cause = 1,
                    se = TRUE, iid = TRUE, band = TRUE)
fit.pred

## check confidence intervals
newse <- fit.pred$absRisk.se/(-fit.pred$absRisk*log(fit.pred$absRisk))
cbind(lower = as.double(exp(-exp(log(-log(fit.pred$absRisk)) + 1.96 * newse))),
      upper = as.double(exp(-exp(log(-log(fit.pred$absRisk)) - 1.96 * newse)))
)

#### compute confidence intervals without transformation
confint(fit.pred, absRisk.transform = "none")
cbind(lower = as.double(fit.pred$absRisk - 1.96 * fit.pred$absRisk.se),
      upper = as.double(fit.pred$absRisk + 1.96 * fit.pred$absRisk.se)
)


}
\author{
Brice Ozenne
}
