// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package entries

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	stderrors "errors"
	"io"
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/validate"

	"github.com/sigstore/rekor/pkg/generated/models"
)

// NewSearchLogQueryParams creates a new SearchLogQueryParams object
//
// There are no default values defined in the spec.
func NewSearchLogQueryParams() SearchLogQueryParams {

	return SearchLogQueryParams{}
}

// SearchLogQueryParams contains all the bound params for the search log query operation
// typically these are obtained from a http.Request
//
// swagger:parameters searchLogQuery
type SearchLogQueryParams struct {
	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*
	  Required: true
	  In: body
	*/
	Entry *models.SearchLogQuery
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewSearchLogQueryParams() beforehand.
func (o *SearchLogQueryParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	if runtime.HasBody(r) {
		defer func() {
			_ = r.Body.Close()
		}()
		var body models.SearchLogQuery
		if err := route.Consumer.Consume(r.Body, &body); err != nil {
			if stderrors.Is(err, io.EOF) {
				res = append(res, errors.Required("entry", "body", ""))
			} else {
				res = append(res, errors.NewParseError("entry", "body", "", err))
			}
		} else {
			// validate body object
			if err := body.Validate(route.Formats); err != nil {
				res = append(res, err)
			}

			ctx := validate.WithOperationRequest(r.Context())
			if err := body.ContextValidate(ctx, route.Formats); err != nil {
				res = append(res, err)
			}

			if len(res) == 0 {
				o.Entry = &body
			}
		}
	} else {
		res = append(res, errors.Required("entry", "body", ""))
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
