# typed: false

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `erb` gem.
# Please instead update this file by running `bin/tapioca gem erb`.


# source://erb//lib/erb/version.rb#2
class ERB
  # :markup: markdown
  #
  # :call-seq:
  #   ERB.new(template, trim_mode: nil, eoutvar: '_erbout')
  #
  # Returns a new \ERB object containing the given string +template+.
  #
  # For details about `template`, its embedded tags, and generated results, see ERB.
  #
  # **Keyword Argument `trim_mode`**
  #
  # You can use keyword argument `trim_mode: '%'`
  # to enable the [shorthand format][shorthand format] for execution tags.
  #
  # This value allows [blank line control][blank line control]:
  #
  # - `'-'`: Omit each blank line ending with `'%>'`.
  #
  # Other values allow [newline control][newline control]:
  #
  # - `'>'`: Omit newline for each line ending with `'%>'`.
  # - `'<>'`: Omit newline for each line starting with `'<%'` and ending with `'%>'`.
  #
  # You can also [combine trim modes][combine trim modes].
  #
  # **Keyword Argument `eoutvar`**
  #
  # The string value of keyword argument `eoutvar` specifies the name of the variable
  # that method #result uses to construct its result string;
  # see #src.
  #
  # This is useful when you need to run multiple \ERB templates through the same binding
  # and/or when you want to control where output ends up.
  #
  # It's good practice to choose a variable name that begins with an underscore: `'_'`.
  #
  # [blank line control]: rdoc-ref:ERB@Suppressing+Unwanted+Blank+Lines
  # [combine trim modes]: rdoc-ref:ERB@Combining+Trim+Modes
  # [newline control]: rdoc-ref:ERB@Suppressing+Unwanted+Newlines
  # [shorthand format]: rdoc-ref:ERB@Shorthand+Format+for+Execution+Tags
  #
  # @return [ERB] a new instance of ERB
  #
  # source://erb//lib/erb.rb#832
  def initialize(str, trim_mode: T.unsafe(nil), eoutvar: T.unsafe(nil)); end

  # :markup: markdown
  #
  # :call-seq:
  #   def_class(super_class = Object, method_name = 'result') -> new_class
  #
  # Returns a new nameless class whose superclass is `super_class`,
  # and which has instance method `method_name`.
  #
  # Create a template from HTML that has embedded expression tags that use `@arg1` and `@arg2`:
  #
  # ```
  # html = <<TEMPLATE
  # <html>
  # <body>
  #   <p><%= @arg1 %></p>
  #   <p><%= @arg2 %></p>
  # </body>
  # </html>
  # TEMPLATE
  # template = ERB.new(html)
  # ```
  #
  # Create a base class that has `@arg1` and `@arg2`:
  #
  # ```
  # class MyBaseClass
  #   def initialize(arg1, arg2)
  #     @arg1 = arg1
  #     @arg2 = arg2
  #   end
  # end
  # ```
  #
  # Use method #def_class to create a subclass that has method `:render`:
  #
  # ```
  # MySubClass = template.def_class(MyBaseClass, :render)
  # ```
  #
  # Generate the result:
  #
  # ```
  # puts MySubClass.new('foo', 123).render
  # <html>
  # <body>
  #   <p>foo</p>
  #   <p>123</p>
  # </body>
  # </html>
  # ```
  #
  # source://erb//lib/erb.rb#1170
  def def_class(superklass = T.unsafe(nil), methodname = T.unsafe(nil)); end

  # :markup: markdown
  #
  # :call-seq:
  #   def_method(module, method_signature, filename = '(ERB)') -> method_name
  #
  # Creates and returns a new instance method in the given module `module`;
  # returns the method name as a symbol.
  #
  # The method is created from the given `method_signature`,
  # which consists of the method name and its argument names (if any).
  #
  # The `filename` sets the value of #filename;
  # see [Error Reporting][error reporting].
  #
  # [error reporting]: rdoc-ref:ERB@Error+Reporting
  #
  # ```
  # template = '<%= arg1 %> <%= arg2 %>'
  # erb = ERB.new(template)
  # MyModule = Module.new
  # erb.def_method(MyModule, 'render(arg1, arg2)') # => :render
  # class MyClass; include MyModule; end
  # MyClass.new.render('foo', 123)                      # => "foo 123"
  # ```
  #
  # source://erb//lib/erb.rb#1088
  def def_method(mod, methodname, fname = T.unsafe(nil)); end

  # :markup: markdown
  #
  # :call-seq:
  #    def_module(method_name = 'erb') -> new_module
  #
  # Returns a new nameless module that has instance method `method_name`.
  #
  # ```
  # template = '<%= arg1 %> <%= arg2 %>'
  # erb = ERB.new(template)
  # MyModule = template.def_module('render(arg1, arg2)')
  # class MyClass
  #   include MyModule
  # end
  # MyClass.new.render('foo', 123)
  # # => "foo 123"
  # ```
  #
  # source://erb//lib/erb.rb#1113
  def def_module(methodname = T.unsafe(nil)); end

  # :markup: markdown
  #
  # Returns the encoding of `self`;
  # see [Encodings][encodings]:
  #
  # [encodings]: rdoc-ref:ERB@Encodings
  #
  # source://erb//lib/erb.rb#909
  def encoding; end

  # :markup: markdown
  #
  # Sets or returns the file name to be used in reporting errors;
  # see [Error Reporting][error reporting].
  #
  # [error reporting]: rdoc-ref:ERB@Error+Reporting
  #
  # source://erb//lib/erb.rb#917
  def filename; end

  # :markup: markdown
  #
  # Sets or returns the file name to be used in reporting errors;
  # see [Error Reporting][error reporting].
  #
  # [error reporting]: rdoc-ref:ERB@Error+Reporting
  #
  # source://erb//lib/erb.rb#917
  def filename=(_arg0); end

  # :markup: markdown
  #
  # Sets or returns the line number to be used in reporting errors;
  # see [Error Reporting][error reporting].
  #
  # [error reporting]: rdoc-ref:ERB@Error+Reporting
  #
  # source://erb//lib/erb.rb#925
  def lineno; end

  # :markup: markdown
  #
  # Sets or returns the line number to be used in reporting errors;
  # see [Error Reporting][error reporting].
  #
  # [error reporting]: rdoc-ref:ERB@Error+Reporting
  #
  # source://erb//lib/erb.rb#925
  def lineno=(_arg0); end

  # :markup: markdown
  #
  # :call-seq:
  #   location = [filename, lineno] => [filename, lineno]
  #   location = filename -> filename
  #
  # Sets the values of #filename and, if given, #lineno;
  # see [Error Reporting][error reporting].
  #
  # [error reporting]: rdoc-ref:ERB@Error+Reporting
  #
  # source://erb//lib/erb.rb#937
  def location=(_arg0); end

  # :markup: markdown
  #
  # :call-seq:
  #   make_compiler -> erb_compiler
  #
  # Returns a new ERB::Compiler with the given `trim_mode`;
  # for `trim_mode` values, see ERB.new:
  #
  # ```
  # ERB.new('').make_compiler(nil)
  # # => #<ERB::Compiler:0x000001cff9467678 @insert_cmd="print", @percent=false, @post_cmd=[], @pre_cmd=[], @put_cmd="print", @trim_mode=nil>
  # ```
  #
  # source://erb//lib/erb.rb#854
  def make_compiler(trim_mode); end

  # :markup: markdown
  #
  # :call-seq:
  #   result(binding = new_toplevel) -> new_string
  #
  # Returns the string result formed by processing \ERB tags found in the stored template in `self`.
  #
  # With no argument given, uses the default binding;
  # see [Default Binding][default binding].
  #
  # With argument `binding` given, uses the local binding;
  # see [Local Binding][local binding].
  #
  # See also #result_with_hash.
  #
  # [default binding]: rdoc-ref:ERB@Default+Binding
  # [local binding]: rdoc-ref:ERB@Local+Binding
  #
  # source://erb//lib/erb.rb#1008
  def result(b = T.unsafe(nil)); end

  # :markup: markdown
  #
  # :call-seq:
  #   result_with_hash(hash) -> new_string
  #
  # Returns the string result formed by processing \ERB tags found in the stored string in `self`;
  # see [Augmented Binding][augmented binding].
  #
  # See also #result.
  #
  # [augmented binding]: rdoc-ref:ERB@Augmented+Binding
  #
  # source://erb//lib/erb.rb#1027
  def result_with_hash(hash); end

  # :markup: markdown
  #
  # :call-seq:
  #   run(binding = new_toplevel) -> nil
  #
  # Like #result, but prints the result string (instead of returning it);
  # returns `nil`.
  #
  # source://erb//lib/erb.rb#986
  def run(b = T.unsafe(nil)); end

  # :markup: markdown
  #
  # :call-seq:
  #   set_eoutvar(compiler, eoutvar = '_erbout') -> [eoutvar]
  #
  # Sets the `eoutvar` value in the ERB::Compiler object `compiler`;
  # returns a 1-element array containing the value of `eoutvar`:
  #
  # ```
  # template = ERB.new('')
  # compiler = template.make_compiler(nil)
  # pp compiler
  # #<ERB::Compiler:0x000001cff8a9aa00
  #  @insert_cmd="print",
  #  @percent=false,
  #  @post_cmd=[],
  #  @pre_cmd=[],
  #  @put_cmd="print",
  #  @trim_mode=nil>
  # template.set_eoutvar(compiler, '_foo') # => ["_foo"]
  # pp compiler
  # #<ERB::Compiler:0x000001cff8a9aa00
  #  @insert_cmd="_foo.<<",
  #  @percent=false,
  #  @post_cmd=["_foo"],
  #  @pre_cmd=["_foo = +''"],
  #  @put_cmd="_foo.<<",
  #  @trim_mode=nil>
  # ```
  #
  # source://erb//lib/erb.rb#972
  def set_eoutvar(compiler, eoutvar = T.unsafe(nil)); end

  # :markup: markdown
  #
  # Returns the Ruby code that, when executed, generates the result;
  # the code is executed by method #result,
  # and by its wrapper methods #result_with_hash and #run:
  #
  # ```
  # template = 'The time is <%= Time.now %>.'
  # erb = ERB.new(template)
  # erb.src
  # # => "#coding:UTF-8\n_erbout = +''; _erbout.<< \"The time is \".freeze; _erbout.<<(( Time.now ).to_s); _erbout.<< \".\".freeze; _erbout"
  # erb.result
  # # => "The time is 2025-09-18 15:58:08 -0500."
  # ```
  #
  # In a more readable format:
  #
  # ```
  #   # puts erb.src.split('; ')
  #   # #coding:UTF-8
  #   # _erbout = +''
  #   # _erbout.<< "The time is ".freeze
  #   # _erbout.<<(( Time.now ).to_s)
  #   # _erbout.<< ".".freeze
  #   # _erbout
  # ```
  #
  # Variable `_erbout` is used to store the intermediate results in the code;
  # the name `_erbout` is the default in ERB.new,
  # and can be changed via keyword argument `eoutvar`:
  #
  # ```
  # erb = ERB.new(template, eoutvar: '_foo')
  # puts template.src.split('; ')
  # #coding:UTF-8
  # _foo = +''
  # _foo.<< "The time is ".freeze
  # _foo.<<(( Time.now ).to_s)
  # _foo.<< ".".freeze
  # _foo
  # ```
  #
  # source://erb//lib/erb.rb#900
  def src; end

  private

  # :markup: markdown
  #
  # :call-seq:
  #   new_toplevel(symbols) -> new_binding
  #
  # Returns a new binding based on `TOPLEVEL_BINDING`;
  # used to create a default binding for a call to #result.
  #
  # See [Default Binding][default binding].
  #
  # Argument `symbols` is an array of symbols;
  # each symbol `symbol` is defined as a new variable to hide and
  # prevent it from overwriting a variable of the same name already
  # defined within the binding.
  #
  # [default binding]: rdoc-ref:ERB@Default+Binding
  #
  # source://erb//lib/erb.rb#1051
  def new_toplevel(vars = T.unsafe(nil)); end

  class << self
    # :markup: markdown
    #
    # :call-seq:
    #   self.version -> string
    #
    # Returns the string \ERB version.
    #
    # source://erb//lib/erb.rb#787
    def version; end
  end
end

# --
# ERB::Compiler
#
# Compiles ERB templates into Ruby code; the compiled code produces the
# template result when evaluated. ERB::Compiler provides hooks to define how
# generated output is handled.
#
# Internally ERB does something like this to generate the code returned by
# ERB#src:
#
#   compiler = ERB::Compiler.new('<>')
#   compiler.pre_cmd    = ["_erbout=+''"]
#   compiler.put_cmd    = "_erbout.<<"
#   compiler.insert_cmd = "_erbout.<<"
#   compiler.post_cmd   = ["_erbout"]
#
#   code, enc = compiler.compile("Got <%= obj %>!\n")
#   puts code
#
# <i>Generates</i>:
#
#   #coding:UTF-8
#   _erbout=+''; _erbout.<< "Got ".freeze; _erbout.<<(( obj ).to_s); _erbout.<< "!\n".freeze; _erbout
#
# By default the output is sent to the print method.  For example:
#
#   compiler = ERB::Compiler.new('<>')
#   code, enc = compiler.compile("Got <%= obj %>!\n")
#   puts code
#
# <i>Generates</i>:
#
#   #coding:UTF-8
#   print "Got ".freeze; print(( obj ).to_s); print "!\n".freeze
#
# == Evaluation
#
# The compiled code can be used in any context where the names in the code
# correctly resolve. Using the last example, each of these print 'Got It!'
#
# Evaluate using a variable:
#
#   obj = 'It'
#   eval code
#
# Evaluate using an input:
#
#   mod = Module.new
#   mod.module_eval %{
#     def get(obj)
#       #{code}
#     end
#   }
#   extend mod
#   get('It')
#
# Evaluate using an accessor:
#
#   klass = Class.new Object
#   klass.class_eval %{
#     attr_accessor :obj
#     def initialize(obj)
#       @obj = obj
#     end
#     def get_it
#       #{code}
#     end
#   }
#   klass.new('It').get_it
#
# Good! See also ERB#def_method, ERB#def_module, and ERB#def_class.
#
# source://erb//lib/erb/compiler.rb#73
class ERB::Compiler
  # Construct a new compiler using the trim_mode. See ERB::new for available
  # trim modes.
  #
  # @return [Compiler] a new instance of Compiler
  #
  # source://erb//lib/erb/compiler.rb#433
  def initialize(trim_mode); end

  # source://erb//lib/erb/compiler.rb#315
  def add_insert_cmd(out, content); end

  # source://erb//lib/erb/compiler.rb#311
  def add_put_cmd(out, content); end

  # Compiles an ERB template into Ruby code.  Returns an array of the code
  # and encoding like ["code", Encoding].
  #
  # @raise [ArgumentError]
  #
  # source://erb//lib/erb/compiler.rb#321
  def compile(s); end

  # source://erb//lib/erb/compiler.rb#381
  def compile_content(stag, out); end

  # source://erb//lib/erb/compiler.rb#368
  def compile_etag(etag, out, scanner); end

  # source://erb//lib/erb/compiler.rb#344
  def compile_stag(stag, out, scanner); end

  # The command to handle text that is inserted prior to a newline
  #
  # source://erb//lib/erb/compiler.rb#446
  def insert_cmd; end

  # The command to handle text that is inserted prior to a newline
  #
  # source://erb//lib/erb/compiler.rb#446
  def insert_cmd=(_arg0); end

  # source://erb//lib/erb/compiler.rb#427
  def make_scanner(src); end

  # Returns the value of attribute percent.
  #
  # source://erb//lib/erb/compiler.rb#440
  def percent; end

  # An array of commands appended to compiled code
  #
  # source://erb//lib/erb/compiler.rb#452
  def post_cmd; end

  # An array of commands appended to compiled code
  #
  # source://erb//lib/erb/compiler.rb#452
  def post_cmd=(_arg0); end

  # An array of commands prepended to compiled code
  #
  # source://erb//lib/erb/compiler.rb#449
  def pre_cmd; end

  # An array of commands prepended to compiled code
  #
  # source://erb//lib/erb/compiler.rb#449
  def pre_cmd=(_arg0); end

  # source://erb//lib/erb/compiler.rb#398
  def prepare_trim_mode(mode); end

  # The command to handle text that ends with a newline
  #
  # source://erb//lib/erb/compiler.rb#443
  def put_cmd; end

  # The command to handle text that ends with a newline
  #
  # source://erb//lib/erb/compiler.rb#443
  def put_cmd=(_arg0); end

  # Returns the value of attribute trim_mode.
  #
  # source://erb//lib/erb/compiler.rb#440
  def trim_mode; end

  private

  # A buffered text in #compile
  #
  # source://erb//lib/erb/compiler.rb#457
  def content; end

  # A buffered text in #compile
  #
  # source://erb//lib/erb/compiler.rb#457
  def content=(_arg0); end

  # source://erb//lib/erb/compiler.rb#459
  def detect_magic_comment(s, enc = T.unsafe(nil)); end

  # source://erb//lib/erb/compiler.rb#484
  def warn_invalid_trim_mode(mode, uplevel:); end
end

# source://erb//lib/erb/compiler.rb#278
class ERB::Compiler::Buffer
  # @return [Buffer] a new instance of Buffer
  #
  # source://erb//lib/erb/compiler.rb#279
  def initialize(compiler, enc = T.unsafe(nil), frozen = T.unsafe(nil)); end

  # source://erb//lib/erb/compiler.rb#301
  def close; end

  # source://erb//lib/erb/compiler.rb#295
  def cr; end

  # source://erb//lib/erb/compiler.rb#291
  def push(cmd); end

  # Returns the value of attribute script.
  #
  # source://erb//lib/erb/compiler.rb#289
  def script; end
end

# source://erb//lib/erb/compiler.rb#254
class ERB::Compiler::ExplicitScanner < ::ERB::Compiler::Scanner
  # source://erb//lib/erb/compiler.rb#255
  def scan; end
end

# source://erb//lib/erb/compiler.rb#74
class ERB::Compiler::PercentLine
  # @return [PercentLine] a new instance of PercentLine
  #
  # source://erb//lib/erb/compiler.rb#75
  def initialize(str); end

  # Returns the value of attribute value.
  #
  # source://erb//lib/erb/compiler.rb#79
  def to_s; end

  # Returns the value of attribute value.
  #
  # source://erb//lib/erb/compiler.rb#78
  def value; end
end

# source://erb//lib/erb/compiler.rb#82
class ERB::Compiler::Scanner
  # @return [Scanner] a new instance of Scanner
  #
  # source://erb//lib/erb/compiler.rb#108
  def initialize(src, trim_mode, percent); end

  # Returns the value of attribute etags.
  #
  # source://erb//lib/erb/compiler.rb#115
  def etags; end

  # source://erb//lib/erb/compiler.rb#117
  def scan; end

  # Returns the value of attribute stag.
  #
  # source://erb//lib/erb/compiler.rb#114
  def stag; end

  # Sets the attribute stag
  #
  # @param value the value to set the attribute stag to.
  #
  # source://erb//lib/erb/compiler.rb#114
  def stag=(_arg0); end

  # Returns the value of attribute stags.
  #
  # source://erb//lib/erb/compiler.rb#115
  def stags; end

  class << self
    # source://erb//lib/erb/compiler.rb#97
    def default_scanner=(klass); end

    # source://erb//lib/erb/compiler.rb#101
    def make_scanner(src, trim_mode, percent); end

    # source://erb//lib/erb/compiler.rb#94
    def regist_scanner(klass, trim_mode, percent); end

    # source://erb//lib/erb/compiler.rb#86
    def register_scanner(klass, trim_mode, percent); end
  end
end

# source://erb//lib/erb/compiler.rb#107
ERB::Compiler::Scanner::DEFAULT_ETAGS = T.let(T.unsafe(nil), Array)

# source://erb//lib/erb/compiler.rb#106
ERB::Compiler::Scanner::DEFAULT_STAGS = T.let(T.unsafe(nil), Array)

# source://erb//lib/erb/compiler.rb#240
class ERB::Compiler::SimpleScanner < ::ERB::Compiler::Scanner
  # source://erb//lib/erb/compiler.rb#241
  def scan; end
end

# source://erb//lib/erb/compiler.rb#120
class ERB::Compiler::TrimScanner < ::ERB::Compiler::Scanner
  # @return [TrimScanner] a new instance of TrimScanner
  #
  # source://erb//lib/erb/compiler.rb#121
  def initialize(src, trim_mode, percent); end

  # source://erb//lib/erb/compiler.rb#210
  def explicit_trim_line(line); end

  # @return [Boolean]
  #
  # source://erb//lib/erb/compiler.rb#229
  def is_erb_stag?(s); end

  # source://erb//lib/erb/compiler.rb#152
  def percent_line(line, &block); end

  # source://erb//lib/erb/compiler.rb#140
  def scan(&block); end

  # source://erb//lib/erb/compiler.rb#165
  def scan_line(line); end

  # source://erb//lib/erb/compiler.rb#174
  def trim_line1(line); end

  # source://erb//lib/erb/compiler.rb#188
  def trim_line2(line); end
end

# :stopdoc:
#
# source://erb//lib/erb/compiler.rb#476
ERB::Compiler::WARNING_UPLEVEL = T.let(T.unsafe(nil), Integer)

# ERB::DefMethod
#
# Utility module to define eRuby script as instance method.
#
# === Example
#
# example.rhtml:
#   <% for item in @items %>
#   <b><%= item %></b>
#   <% end %>
#
# example.rb:
#   require 'erb'
#   class MyClass
#     extend ERB::DefMethod
#     def_erb_method('render()', 'example.rhtml')
#     def initialize(items)
#       @items = items
#     end
#   end
#   print MyClass.new([10,20,30]).render()
#
# result:
#
#   <b>10</b>
#
#   <b>20</b>
#
#   <b>30</b>
#
# source://erb//lib/erb/def_method.rb#33
module ERB::DefMethod
  private

  # define _methodname_ as instance method of current module, using ERB
  # object or eRuby file
  #
  # source://erb//lib/erb/def_method.rb#36
  def def_erb_method(methodname, erb_or_fname); end

  class << self
    # define _methodname_ as instance method of current module, using ERB
    # object or eRuby file
    #
    # source://erb//lib/erb/def_method.rb#46
    def def_erb_method(methodname, erb_or_fname); end
  end
end

module ERB::Escape; end

# ERB::Util
#
# A utility module for conversion routines, often handy in HTML generation.
#
# source://erb//lib/erb/util.rb#33
module ERB::Util
  include ::ERB::Escape

  private

  # source://erb//lib/erb/util.rb#48
  def h(_arg0); end

  # cgi.gem <= v0.3.2
  #
  # source://erb//lib/erb/util.rb#74
  def u(s); end

  # cgi.gem <= v0.3.2
  #
  # source://erb//lib/erb/util.rb#64
  def url_encode(s); end

  class << self
    # source://erb//lib/erb/util.rb#49
    def h(_arg0); end

    # source://erb//lib/erb/util.rb#47
    def html_escape(_arg0); end

    # cgi.gem <= v0.3.2
    #
    # source://erb//lib/erb/util.rb#75
    def u(s); end

    # cgi.gem <= v0.3.2
    #
    # source://erb//lib/erb/util.rb#76
    def url_encode(s); end
  end
end

# The string \ERB version.
#
# source://erb//lib/erb/version.rb#4
ERB::VERSION = T.let(T.unsafe(nil), String)
