# typed: false

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `json` gem.
# Please instead update this file by running `bin/tapioca gem json`.


class Array
  include ::Enumerable
  include ::JSON::Ext::Generator::GeneratorMethods::Array
end

class FalseClass
  include ::JSON::Ext::Generator::GeneratorMethods::FalseClass
end

class Float < ::Numeric
  include ::JSON::Ext::Generator::GeneratorMethods::Float
end

class Hash
  include ::Enumerable
  include ::JSON::Ext::Generator::GeneratorMethods::Hash
end

class Integer < ::Numeric
  include ::JSON::Ext::Generator::GeneratorMethods::Integer
end

# = JavaScript \Object Notation (\JSON)
#
# \JSON is a lightweight data-interchange format.
#
# A \JSON value is one of the following:
# - Double-quoted text:  <tt>"foo"</tt>.
# - Number:  +1+, +1.0+, +2.0e2+.
# - Boolean:  +true+, +false+.
# - Null: +null+.
# - \Array: an ordered list of values, enclosed by square brackets:
#     ["foo", 1, 1.0, 2.0e2, true, false, null]
#
# - \Object: a collection of name/value pairs, enclosed by curly braces;
#   each name is double-quoted text;
#   the values may be any \JSON values:
#     {"a": "foo", "b": 1, "c": 1.0, "d": 2.0e2, "e": true, "f": false, "g": null}
#
# A \JSON array or object may contain nested arrays, objects, and scalars
# to any depth:
#   {"foo": {"bar": 1, "baz": 2}, "bat": [0, 1, 2]}
#   [{"foo": 0, "bar": 1}, ["baz", 2]]
#
# == Using \Module \JSON
#
# To make module \JSON available in your code, begin with:
#   require 'json'
#
# All examples here assume that this has been done.
#
# === Parsing \JSON
#
# You can parse a \String containing \JSON data using
# either of two methods:
# - <tt>JSON.parse(source, opts)</tt>
# - <tt>JSON.parse!(source, opts)</tt>
#
# where
# - +source+ is a Ruby object.
# - +opts+ is a \Hash object containing options
#   that control both input allowed and output formatting.
#
# The difference between the two methods
# is that JSON.parse! omits some checks
# and may not be safe for some +source+ data;
# use it only for data from trusted sources.
# Use the safer method JSON.parse for less trusted sources.
#
# ==== Parsing \JSON Arrays
#
# When +source+ is a \JSON array, JSON.parse by default returns a Ruby \Array:
#   json = '["foo", 1, 1.0, 2.0e2, true, false, null]'
#   ruby = JSON.parse(json)
#   ruby # => ["foo", 1, 1.0, 200.0, true, false, nil]
#   ruby.class # => Array
#
# The \JSON array may contain nested arrays, objects, and scalars
# to any depth:
#   json = '[{"foo": 0, "bar": 1}, ["baz", 2]]'
#   JSON.parse(json) # => [{"foo"=>0, "bar"=>1}, ["baz", 2]]
#
# ==== Parsing \JSON \Objects
#
# When the source is a \JSON object, JSON.parse by default returns a Ruby \Hash:
#   json = '{"a": "foo", "b": 1, "c": 1.0, "d": 2.0e2, "e": true, "f": false, "g": null}'
#   ruby = JSON.parse(json)
#   ruby # => {"a"=>"foo", "b"=>1, "c"=>1.0, "d"=>200.0, "e"=>true, "f"=>false, "g"=>nil}
#   ruby.class # => Hash
#
# The \JSON object may contain nested arrays, objects, and scalars
# to any depth:
#   json = '{"foo": {"bar": 1, "baz": 2}, "bat": [0, 1, 2]}'
#   JSON.parse(json) # => {"foo"=>{"bar"=>1, "baz"=>2}, "bat"=>[0, 1, 2]}
#
# ==== Parsing \JSON Scalars
#
# When the source is a \JSON scalar (not an array or object),
# JSON.parse returns a Ruby scalar.
#
# \String:
#   ruby = JSON.parse('"foo"')
#   ruby # => 'foo'
#   ruby.class # => String
# \Integer:
#   ruby = JSON.parse('1')
#   ruby # => 1
#   ruby.class # => Integer
# \Float:
#   ruby = JSON.parse('1.0')
#   ruby # => 1.0
#   ruby.class # => Float
#   ruby = JSON.parse('2.0e2')
#   ruby # => 200
#   ruby.class # => Float
# Boolean:
#   ruby = JSON.parse('true')
#   ruby # => true
#   ruby.class # => TrueClass
#   ruby = JSON.parse('false')
#   ruby # => false
#   ruby.class # => FalseClass
# Null:
#   ruby = JSON.parse('null')
#   ruby # => nil
#   ruby.class # => NilClass
#
# ==== Parsing Options
#
# ====== Input Options
#
# Option +max_nesting+ (\Integer) specifies the maximum nesting depth allowed;
# defaults to +100+; specify +false+ to disable depth checking.
#
# With the default, +false+:
#   source = '[0, [1, [2, [3]]]]'
#   ruby = JSON.parse(source)
#   ruby # => [0, [1, [2, [3]]]]
# Too deep:
#   # Raises JSON::NestingError (nesting of 2 is too deep):
#   JSON.parse(source, {max_nesting: 1})
# Bad value:
#   # Raises TypeError (wrong argument type Symbol (expected Fixnum)):
#   JSON.parse(source, {max_nesting: :foo})
#
# ---
#
# Option +allow_duplicate_key+ specifies whether duplicate keys in objects
# should be ignored or cause an error to be raised:
#
# When not specified:
#   # The last value is used and a deprecation warning emitted.
#   JSON.parse('{"a": 1, "a":2}') => {"a" => 2}
#   # warning: detected duplicate keys in JSON object.
#   # This will raise an error in json 3.0 unless enabled via `allow_duplicate_key: true`
#
# When set to `+true+`
#   # The last value is used.
#   JSON.parse('{"a": 1, "a":2}') => {"a" => 2}
#
# When set to `+false+`, the future default:
#   JSON.parse('{"a": 1, "a":2}') => duplicate key at line 1 column 1 (JSON::ParserError)
#
# ---
#
# Option +allow_nan+ (boolean) specifies whether to allow
# NaN, Infinity, and MinusInfinity in +source+;
# defaults to +false+.
#
# With the default, +false+:
#   # Raises JSON::ParserError (225: unexpected token at '[NaN]'):
#   JSON.parse('[NaN]')
#   # Raises JSON::ParserError (232: unexpected token at '[Infinity]'):
#   JSON.parse('[Infinity]')
#   # Raises JSON::ParserError (248: unexpected token at '[-Infinity]'):
#   JSON.parse('[-Infinity]')
# Allow:
#   source = '[NaN, Infinity, -Infinity]'
#   ruby = JSON.parse(source, {allow_nan: true})
#   ruby # => [NaN, Infinity, -Infinity]
#
# ---
#
# Option +allow_trailing_comma+ (boolean) specifies whether to allow
# trailing commas in objects and arrays;
# defaults to +false+.
#
# With the default, +false+:
#   JSON.parse('[1,]') # unexpected character: ']' at line 1 column 4 (JSON::ParserError)
#
# When enabled:
#   JSON.parse('[1,]', allow_trailing_comma: true) # => [1]
#
# ====== Output Options
#
# Option +freeze+ (boolean) specifies whether the returned objects will be frozen;
# defaults to +false+.
#
# Option +symbolize_names+ (boolean) specifies whether returned \Hash keys
# should be Symbols;
# defaults to +false+ (use Strings).
#
# With the default, +false+:
#   source = '{"a": "foo", "b": 1.0, "c": true, "d": false, "e": null}'
#   ruby = JSON.parse(source)
#   ruby # => {"a"=>"foo", "b"=>1.0, "c"=>true, "d"=>false, "e"=>nil}
# Use Symbols:
#   ruby = JSON.parse(source, {symbolize_names: true})
#   ruby # => {:a=>"foo", :b=>1.0, :c=>true, :d=>false, :e=>nil}
#
# ---
#
# Option +object_class+ (\Class) specifies the Ruby class to be used
# for each \JSON object;
# defaults to \Hash.
#
# With the default, \Hash:
#   source = '{"a": "foo", "b": 1.0, "c": true, "d": false, "e": null}'
#   ruby = JSON.parse(source)
#   ruby.class # => Hash
# Use class \OpenStruct:
#   ruby = JSON.parse(source, {object_class: OpenStruct})
#   ruby # => #<OpenStruct a="foo", b=1.0, c=true, d=false, e=nil>
#
# ---
#
# Option +array_class+ (\Class) specifies the Ruby class to be used
# for each \JSON array;
# defaults to \Array.
#
# With the default, \Array:
#   source = '["foo", 1.0, true, false, null]'
#   ruby = JSON.parse(source)
#   ruby.class # => Array
# Use class \Set:
#   ruby = JSON.parse(source, {array_class: Set})
#   ruby # => #<Set: {"foo", 1.0, true, false, nil}>
#
# ---
#
# Option +create_additions+ (boolean) specifies whether to use \JSON additions in parsing.
# See {\JSON Additions}[#module-JSON-label-JSON+Additions].
#
# === Generating \JSON
#
# To generate a Ruby \String containing \JSON data,
# use method <tt>JSON.generate(source, opts)</tt>, where
# - +source+ is a Ruby object.
# - +opts+ is a \Hash object containing options
#   that control both input allowed and output formatting.
#
# ==== Generating \JSON from Arrays
#
# When the source is a Ruby \Array, JSON.generate returns
# a \String containing a \JSON array:
#   ruby = [0, 's', :foo]
#   json = JSON.generate(ruby)
#   json # => '[0,"s","foo"]'
#
# The Ruby \Array array may contain nested arrays, hashes, and scalars
# to any depth:
#   ruby = [0, [1, 2], {foo: 3, bar: 4}]
#   json = JSON.generate(ruby)
#   json # => '[0,[1,2],{"foo":3,"bar":4}]'
#
# ==== Generating \JSON from Hashes
#
# When the source is a Ruby \Hash, JSON.generate returns
# a \String containing a \JSON object:
#   ruby = {foo: 0, bar: 's', baz: :bat}
#   json = JSON.generate(ruby)
#   json # => '{"foo":0,"bar":"s","baz":"bat"}'
#
# The Ruby \Hash array may contain nested arrays, hashes, and scalars
# to any depth:
#   ruby = {foo: [0, 1], bar: {baz: 2, bat: 3}, bam: :bad}
#   json = JSON.generate(ruby)
#   json # => '{"foo":[0,1],"bar":{"baz":2,"bat":3},"bam":"bad"}'
#
# ==== Generating \JSON from Other Objects
#
# When the source is neither an \Array nor a \Hash,
# the generated \JSON data depends on the class of the source.
#
# When the source is a Ruby \Integer or \Float, JSON.generate returns
# a \String containing a \JSON number:
#   JSON.generate(42) # => '42'
#   JSON.generate(0.42) # => '0.42'
#
# When the source is a Ruby \String, JSON.generate returns
# a \String containing a \JSON string (with double-quotes):
#   JSON.generate('A string') # => '"A string"'
#
# When the source is +true+, +false+ or +nil+, JSON.generate returns
# a \String containing the corresponding \JSON token:
#   JSON.generate(true) # => 'true'
#   JSON.generate(false) # => 'false'
#   JSON.generate(nil) # => 'null'
#
# When the source is none of the above, JSON.generate returns
# a \String containing a \JSON string representation of the source:
#   JSON.generate(:foo) # => '"foo"'
#   JSON.generate(Complex(0, 0)) # => '"0+0i"'
#   JSON.generate(Dir.new('.')) # => '"#<Dir>"'
#
# ==== Generating Options
#
# ====== Input Options
#
# Option +allow_nan+ (boolean) specifies whether
# +NaN+, +Infinity+, and <tt>-Infinity</tt> may be generated;
# defaults to +false+.
#
# With the default, +false+:
#   # Raises JSON::GeneratorError (920: NaN not allowed in JSON):
#   JSON.generate(JSON::NaN)
#   # Raises JSON::GeneratorError (917: Infinity not allowed in JSON):
#   JSON.generate(JSON::Infinity)
#   # Raises JSON::GeneratorError (917: -Infinity not allowed in JSON):
#   JSON.generate(JSON::MinusInfinity)
#
# Allow:
#   ruby = [Float::NaN, Float::Infinity, Float::MinusInfinity]
#   JSON.generate(ruby, allow_nan: true) # => '[NaN,Infinity,-Infinity]'
#
# ---
#
# Option +allow_duplicate_key+ (boolean) specifies whether
# hashes with duplicate keys should be allowed or produce an error.
# defaults to emit a deprecation warning.
#
# With the default, (not set):
#   Warning[:deprecated] = true
#   JSON.generate({ foo: 1, "foo" => 2 })
#   # warning: detected duplicate key "foo" in {foo: 1, "foo" => 2}.
#   # This will raise an error in json 3.0 unless enabled via `allow_duplicate_key: true`
#   # => '{"foo":1,"foo":2}'
#
# With <tt>false</tt>
#   JSON.generate({ foo: 1, "foo" => 2 }, allow_duplicate_key: false)
#   # detected duplicate key "foo" in {foo: 1, "foo" => 2} (JSON::GeneratorError)
#
# In version 3.0, <tt>false</tt> will become the default.
#
# ---
#
# Option +max_nesting+ (\Integer) specifies the maximum nesting depth
# in +obj+; defaults to +100+.
#
# With the default, +100+:
#   obj = [[[[[[0]]]]]]
#   JSON.generate(obj) # => '[[[[[[0]]]]]]'
#
# Too deep:
#   # Raises JSON::NestingError (nesting of 2 is too deep):
#   JSON.generate(obj, max_nesting: 2)
#
# ====== Escaping Options
#
# Options +script_safe+ (boolean) specifies wether <tt>'\u2028'</tt>, <tt>'\u2029'</tt>
# and <tt>'/'</tt> should be escaped as to make the JSON object safe to interpolate in script
# tags.
#
# Options +ascii_only+ (boolean) specifies wether all characters outside the ASCII range
# should be escaped.
#
# ====== Output Options
#
# The default formatting options generate the most compact
# \JSON data, all on one line and with no whitespace.
#
# You can use these formatting options to generate
# \JSON data in a more open format, using whitespace.
# See also JSON.pretty_generate.
#
# - Option +array_nl+ (\String) specifies a string (usually a newline)
#   to be inserted after each \JSON array; defaults to the empty \String, <tt>''</tt>.
# - Option +object_nl+ (\String) specifies a string (usually a newline)
#   to be inserted after each \JSON object; defaults to the empty \String, <tt>''</tt>.
# - Option +indent+ (\String) specifies the string (usually spaces) to be
#   used for indentation; defaults to the empty \String, <tt>''</tt>;
#   defaults to the empty \String, <tt>''</tt>;
#   has no effect unless options +array_nl+ or +object_nl+ specify newlines.
# - Option +space+ (\String) specifies a string (usually a space) to be
#   inserted after the colon in each \JSON object's pair;
#   defaults to the empty \String, <tt>''</tt>.
# - Option +space_before+ (\String) specifies a string (usually a space) to be
#   inserted before the colon in each \JSON object's pair;
#   defaults to the empty \String, <tt>''</tt>.
#
# In this example, +obj+ is used first to generate the shortest
# \JSON data (no whitespace), then again with all formatting options
# specified:
#
#   obj = {foo: [:bar, :baz], bat: {bam: 0, bad: 1}}
#   json = JSON.generate(obj)
#   puts 'Compact:', json
#   opts = {
#     array_nl: "\n",
#     object_nl: "\n",
#     indent: '  ',
#     space_before: ' ',
#     space: ' '
#   }
#   puts 'Open:', JSON.generate(obj, opts)
#
# Output:
#   Compact:
#   {"foo":["bar","baz"],"bat":{"bam":0,"bad":1}}
#   Open:
#   {
#     "foo" : [
#       "bar",
#       "baz"
#   ],
#     "bat" : {
#       "bam" : 0,
#       "bad" : 1
#     }
#   }
#
# == \JSON Additions
#
# Note that JSON Additions must only be used with trusted data, and is
# deprecated.
#
# When you "round trip" a non-\String object from Ruby to \JSON and back,
# you have a new \String, instead of the object you began with:
#   ruby0 = Range.new(0, 2)
#   json = JSON.generate(ruby0)
#   json # => '0..2"'
#   ruby1 = JSON.parse(json)
#   ruby1 # => '0..2'
#   ruby1.class # => String
#
# You can use \JSON _additions_ to preserve the original object.
# The addition is an extension of a ruby class, so that:
# - \JSON.generate stores more information in the \JSON string.
# - \JSON.parse, called with option +create_additions+,
#   uses that information to create a proper Ruby object.
#
# This example shows a \Range being generated into \JSON
# and parsed back into Ruby, both without and with
# the addition for \Range:
#   ruby = Range.new(0, 2)
#   # This passage does not use the addition for Range.
#   json0 = JSON.generate(ruby)
#   ruby0 = JSON.parse(json0)
#   # This passage uses the addition for Range.
#   require 'json/add/range'
#   json1 = JSON.generate(ruby)
#   ruby1 = JSON.parse(json1, create_additions: true)
#   # Make a nice display.
#   display = <<~EOT
#     Generated JSON:
#       Without addition:  #{json0} (#{json0.class})
#       With addition:     #{json1} (#{json1.class})
#     Parsed JSON:
#       Without addition:  #{ruby0.inspect} (#{ruby0.class})
#       With addition:     #{ruby1.inspect} (#{ruby1.class})
#   EOT
#   puts display
#
# This output shows the different results:
#   Generated JSON:
#     Without addition:  "0..2" (String)
#     With addition:     {"json_class":"Range","a":[0,2,false]} (String)
#   Parsed JSON:
#     Without addition:  "0..2" (String)
#     With addition:     0..2 (Range)
#
# The \JSON module includes additions for certain classes.
# You can also craft custom additions.
# See {Custom \JSON Additions}[#module-JSON-label-Custom+JSON+Additions].
#
# === Built-in Additions
#
# The \JSON module includes additions for certain classes.
# To use an addition, +require+ its source:
# - BigDecimal: <tt>require 'json/add/bigdecimal'</tt>
# - Complex: <tt>require 'json/add/complex'</tt>
# - Date: <tt>require 'json/add/date'</tt>
# - DateTime: <tt>require 'json/add/date_time'</tt>
# - Exception: <tt>require 'json/add/exception'</tt>
# - OpenStruct: <tt>require 'json/add/ostruct'</tt>
# - Range: <tt>require 'json/add/range'</tt>
# - Rational: <tt>require 'json/add/rational'</tt>
# - Regexp: <tt>require 'json/add/regexp'</tt>
# - Set: <tt>require 'json/add/set'</tt>
# - Struct: <tt>require 'json/add/struct'</tt>
# - Symbol: <tt>require 'json/add/symbol'</tt>
# - Time: <tt>require 'json/add/time'</tt>
#
# To reduce punctuation clutter, the examples below
# show the generated \JSON via +puts+, rather than the usual +inspect+,
#
# \BigDecimal:
#   require 'json/add/bigdecimal'
#   ruby0 = BigDecimal(0) # 0.0
#   json = JSON.generate(ruby0) # {"json_class":"BigDecimal","b":"27:0.0"}
#   ruby1 = JSON.parse(json, create_additions: true) # 0.0
#   ruby1.class # => BigDecimal
#
# \Complex:
#   require 'json/add/complex'
#   ruby0 = Complex(1+0i) # 1+0i
#   json = JSON.generate(ruby0) # {"json_class":"Complex","r":1,"i":0}
#   ruby1 = JSON.parse(json, create_additions: true) # 1+0i
#   ruby1.class # Complex
#
# \Date:
#   require 'json/add/date'
#   ruby0 = Date.today # 2020-05-02
#   json = JSON.generate(ruby0) # {"json_class":"Date","y":2020,"m":5,"d":2,"sg":2299161.0}
#   ruby1 = JSON.parse(json, create_additions: true) # 2020-05-02
#   ruby1.class # Date
#
# \DateTime:
#   require 'json/add/date_time'
#   ruby0 = DateTime.now # 2020-05-02T10:38:13-05:00
#   json = JSON.generate(ruby0) # {"json_class":"DateTime","y":2020,"m":5,"d":2,"H":10,"M":38,"S":13,"of":"-5/24","sg":2299161.0}
#   ruby1 = JSON.parse(json, create_additions: true) # 2020-05-02T10:38:13-05:00
#   ruby1.class # DateTime
#
# \Exception (and its subclasses including \RuntimeError):
#   require 'json/add/exception'
#   ruby0 = Exception.new('A message') # A message
#   json = JSON.generate(ruby0) # {"json_class":"Exception","m":"A message","b":null}
#   ruby1 = JSON.parse(json, create_additions: true) # A message
#   ruby1.class # Exception
#   ruby0 = RuntimeError.new('Another message') # Another message
#   json = JSON.generate(ruby0) # {"json_class":"RuntimeError","m":"Another message","b":null}
#   ruby1 = JSON.parse(json, create_additions: true) # Another message
#   ruby1.class # RuntimeError
#
# \OpenStruct:
#   require 'json/add/ostruct'
#   ruby0 = OpenStruct.new(name: 'Matz', language: 'Ruby') # #<OpenStruct name="Matz", language="Ruby">
#   json = JSON.generate(ruby0) # {"json_class":"OpenStruct","t":{"name":"Matz","language":"Ruby"}}
#   ruby1 = JSON.parse(json, create_additions: true) # #<OpenStruct name="Matz", language="Ruby">
#   ruby1.class # OpenStruct
#
# \Range:
#   require 'json/add/range'
#   ruby0 = Range.new(0, 2) # 0..2
#   json = JSON.generate(ruby0) # {"json_class":"Range","a":[0,2,false]}
#   ruby1 = JSON.parse(json, create_additions: true) # 0..2
#   ruby1.class # Range
#
# \Rational:
#   require 'json/add/rational'
#   ruby0 = Rational(1, 3) # 1/3
#   json = JSON.generate(ruby0) # {"json_class":"Rational","n":1,"d":3}
#   ruby1 = JSON.parse(json, create_additions: true) # 1/3
#   ruby1.class # Rational
#
# \Regexp:
#   require 'json/add/regexp'
#   ruby0 = Regexp.new('foo') # (?-mix:foo)
#   json = JSON.generate(ruby0) # {"json_class":"Regexp","o":0,"s":"foo"}
#   ruby1 = JSON.parse(json, create_additions: true) # (?-mix:foo)
#   ruby1.class # Regexp
#
# \Set:
#   require 'json/add/set'
#   ruby0 = Set.new([0, 1, 2]) # #<Set: {0, 1, 2}>
#   json = JSON.generate(ruby0) # {"json_class":"Set","a":[0,1,2]}
#   ruby1 = JSON.parse(json, create_additions: true) # #<Set: {0, 1, 2}>
#   ruby1.class # Set
#
# \Struct:
#   require 'json/add/struct'
#   Customer = Struct.new(:name, :address) # Customer
#   ruby0 = Customer.new("Dave", "123 Main") # #<struct Customer name="Dave", address="123 Main">
#   json = JSON.generate(ruby0) # {"json_class":"Customer","v":["Dave","123 Main"]}
#   ruby1 = JSON.parse(json, create_additions: true) # #<struct Customer name="Dave", address="123 Main">
#   ruby1.class # Customer
#
# \Symbol:
#   require 'json/add/symbol'
#   ruby0 = :foo # foo
#   json = JSON.generate(ruby0) # {"json_class":"Symbol","s":"foo"}
#   ruby1 = JSON.parse(json, create_additions: true) # foo
#   ruby1.class # Symbol
#
# \Time:
#   require 'json/add/time'
#   ruby0 = Time.now # 2020-05-02 11:28:26 -0500
#   json = JSON.generate(ruby0) # {"json_class":"Time","s":1588436906,"n":840560000}
#   ruby1 = JSON.parse(json, create_additions: true) # 2020-05-02 11:28:26 -0500
#   ruby1.class # Time
#
#
# === Custom \JSON Additions
#
# In addition to the \JSON additions provided,
# you can craft \JSON additions of your own,
# either for Ruby built-in classes or for user-defined classes.
#
# Here's a user-defined class +Foo+:
#   class Foo
#     attr_accessor :bar, :baz
#     def initialize(bar, baz)
#       self.bar = bar
#       self.baz = baz
#     end
#   end
#
# Here's the \JSON addition for it:
#   # Extend class Foo with JSON addition.
#   class Foo
#     # Serialize Foo object with its class name and arguments
#     def to_json(*args)
#       {
#         JSON.create_id  => self.class.name,
#         'a'             => [ bar, baz ]
#       }.to_json(*args)
#     end
#     # Deserialize JSON string by constructing new Foo object with arguments.
#     def self.json_create(object)
#       new(*object['a'])
#     end
#   end
#
# Demonstration:
#   require 'json'
#   # This Foo object has no custom addition.
#   foo0 = Foo.new(0, 1)
#   json0 = JSON.generate(foo0)
#   obj0 = JSON.parse(json0)
#   # Lood the custom addition.
#   require_relative 'foo_addition'
#   # This foo has the custom addition.
#   foo1 = Foo.new(0, 1)
#   json1 = JSON.generate(foo1)
#   obj1 = JSON.parse(json1, create_additions: true)
#   #   Make a nice display.
#   display = <<~EOT
#     Generated JSON:
#       Without custom addition:  #{json0} (#{json0.class})
#       With custom addition:     #{json1} (#{json1.class})
#     Parsed JSON:
#       Without custom addition:  #{obj0.inspect} (#{obj0.class})
#       With custom addition:     #{obj1.inspect} (#{obj1.class})
#   EOT
#   puts display
#
# Output:
#
#   Generated JSON:
#     Without custom addition:  "#<Foo:0x0000000006534e80>" (String)
#     With custom addition:     {"json_class":"Foo","a":[0,1]} (String)
#   Parsed JSON:
#     Without custom addition:  "#<Foo:0x0000000006534e80>" (String)
#     With custom addition:     #<Foo:0x0000000006473bb8 @bar=0, @baz=1> (Foo)
#
# source://json//lib/json/version.rb#3
module JSON
  private

  # :call-seq:
  #   JSON.dump(obj, io = nil, limit = nil)
  #
  # Dumps +obj+ as a \JSON string, i.e. calls generate on the object and returns the result.
  #
  # The default options can be changed via method JSON.dump_default_options.
  #
  # - Argument +io+, if given, should respond to method +write+;
  #   the \JSON \String is written to +io+, and +io+ is returned.
  #   If +io+ is not given, the \JSON \String is returned.
  # - Argument +limit+, if given, is passed to JSON.generate as option +max_nesting+.
  #
  # ---
  #
  # When argument +io+ is not given, returns the \JSON \String generated from +obj+:
  #   obj = {foo: [0, 1], bar: {baz: 2, bat: 3}, bam: :bad}
  #   json = JSON.dump(obj)
  #   json # => "{\"foo\":[0,1],\"bar\":{\"baz\":2,\"bat\":3},\"bam\":\"bad\"}"
  #
  # When argument +io+ is given, writes the \JSON \String to +io+ and returns +io+:
  #   path = 't.json'
  #   File.open(path, 'w') do |file|
  #     JSON.dump(obj, file)
  #   end # => #<File:t.json (closed)>
  #   puts File.read(path)
  # Output:
  #   {"foo":[0,1],"bar":{"baz":2,"bat":3},"bam":"bad"}
  #
  # source://json//lib/json/common.rb#930
  def dump(obj, anIO = T.unsafe(nil), limit = T.unsafe(nil), kwargs = T.unsafe(nil)); end

  # :call-seq:
  #   JSON.fast_generate(obj, opts) -> new_string
  #
  # Arguments +obj+ and +opts+ here are the same as
  # arguments +obj+ and +opts+ in JSON.generate.
  #
  # By default, generates \JSON data without checking
  # for circular references in +obj+ (option +max_nesting+ set to +false+, disabled).
  #
  # Raises an exception if +obj+ contains circular references:
  #   a = []; b = []; a.push(b); b.push(a)
  #   # Raises SystemStackError (stack level too deep):
  #   JSON.fast_generate(a)
  #
  # source://json//lib/json/common.rb#460
  def fast_generate(obj, opts = T.unsafe(nil)); end

  # source://json//lib/json/common.rb#975
  def fast_unparse(*_arg0, **_arg1, &_arg2); end

  # :call-seq:
  #   JSON.generate(obj, opts = nil) -> new_string
  #
  # Returns a \String containing the generated \JSON data.
  #
  # See also JSON.pretty_generate.
  #
  # Argument +obj+ is the Ruby object to be converted to \JSON.
  #
  # Argument +opts+, if given, contains a \Hash of options for the generation.
  # See {Generating Options}[#module-JSON-label-Generating+Options].
  #
  # ---
  #
  # When +obj+ is an \Array, returns a \String containing a \JSON array:
  #   obj = ["foo", 1.0, true, false, nil]
  #   json = JSON.generate(obj)
  #   json # => '["foo",1.0,true,false,null]'
  #
  # When +obj+ is a \Hash, returns a \String containing a \JSON object:
  #   obj = {foo: 0, bar: 's', baz: :bat}
  #   json = JSON.generate(obj)
  #   json # => '{"foo":0,"bar":"s","baz":"bat"}'
  #
  # For examples of generating from other Ruby objects, see
  # {Generating \JSON from Other Objects}[#module-JSON-label-Generating+JSON+from+Other+Objects].
  #
  # ---
  #
  # Raises an exception if any formatting option is not a \String.
  #
  # Raises an exception if +obj+ contains circular references:
  #   a = []; b = []; a.push(b); b.push(a)
  #   # Raises JSON::NestingError (nesting of 100 is too deep):
  #   JSON.generate(a)
  #
  # source://json//lib/json/common.rb#439
  def generate(obj, opts = T.unsafe(nil)); end

  # :call-seq:
  #   JSON.load(source, options = {}) -> object
  #   JSON.load(source, proc = nil, options = {}) -> object
  #
  # Returns the Ruby objects created by parsing the given +source+.
  #
  # BEWARE: This method is meant to serialise data from trusted user input,
  # like from your own database server or clients under your control, it could
  # be dangerous to allow untrusted users to pass JSON sources into it.
  # If you must use it, use JSON.unsafe_load instead to make it clear.
  #
  # Since JSON version 2.8.0, `load` emits a deprecation warning when a
  # non native type is deserialized, without `create_additions` being explicitly
  # enabled, and in JSON version 3.0, `load` will have `create_additions` disabled
  # by default.
  #
  # - Argument +source+ must be, or be convertible to, a \String:
  #   - If +source+ responds to instance method +to_str+,
  #     <tt>source.to_str</tt> becomes the source.
  #   - If +source+ responds to instance method +to_io+,
  #     <tt>source.to_io.read</tt> becomes the source.
  #   - If +source+ responds to instance method +read+,
  #     <tt>source.read</tt> becomes the source.
  #   - If both of the following are true, source becomes the \String <tt>'null'</tt>:
  #     - Option +allow_blank+ specifies a truthy value.
  #     - The source, as defined above, is +nil+ or the empty \String <tt>''</tt>.
  #   - Otherwise, +source+ remains the source.
  # - Argument +proc+, if given, must be a \Proc that accepts one argument.
  #   It will be called recursively with each result (depth-first order).
  #   See details below.
  # - Argument +opts+, if given, contains a \Hash of options for the parsing.
  #   See {Parsing Options}[#module-JSON-label-Parsing+Options].
  #   The default options can be changed via method JSON.load_default_options=.
  #
  # ---
  #
  # When no +proc+ is given, modifies +source+ as above and returns the result of
  # <tt>parse(source, opts)</tt>;  see #parse.
  #
  # Source for following examples:
  #   source = <<~JSON
  #     {
  #       "name": "Dave",
  #       "age" :40,
  #       "hats": [
  #         "Cattleman's",
  #         "Panama",
  #         "Tophat"
  #       ]
  #     }
  #   JSON
  #
  # Load a \String:
  #   ruby = JSON.load(source)
  #   ruby # => {"name"=>"Dave", "age"=>40, "hats"=>["Cattleman's", "Panama", "Tophat"]}
  #
  # Load an \IO object:
  #   require 'stringio'
  #   object = JSON.load(StringIO.new(source))
  #   object # => {"name"=>"Dave", "age"=>40, "hats"=>["Cattleman's", "Panama", "Tophat"]}
  #
  # Load a \File object:
  #   path = 't.json'
  #   File.write(path, source)
  #   File.open(path) do |file|
  #     JSON.load(file)
  #   end # => {"name"=>"Dave", "age"=>40, "hats"=>["Cattleman's", "Panama", "Tophat"]}
  #
  # ---
  #
  # When +proc+ is given:
  # - Modifies +source+ as above.
  # - Gets the +result+ from calling <tt>parse(source, opts)</tt>.
  # - Recursively calls <tt>proc(result)</tt>.
  # - Returns the final result.
  #
  # Example:
  #   require 'json'
  #
  #   # Some classes for the example.
  #   class Base
  #     def initialize(attributes)
  #       @attributes = attributes
  #     end
  #   end
  #   class User    < Base; end
  #   class Account < Base; end
  #   class Admin   < Base; end
  #   # The JSON source.
  #   json = <<-EOF
  #   {
  #     "users": [
  #         {"type": "User", "username": "jane", "email": "jane@example.com"},
  #         {"type": "User", "username": "john", "email": "john@example.com"}
  #     ],
  #     "accounts": [
  #         {"account": {"type": "Account", "paid": true, "account_id": "1234"}},
  #         {"account": {"type": "Account", "paid": false, "account_id": "1235"}}
  #     ],
  #     "admins": {"type": "Admin", "password": "0wn3d"}
  #   }
  #   EOF
  #   # Deserializer method.
  #   def deserialize_obj(obj, safe_types = %w(User Account Admin))
  #     type = obj.is_a?(Hash) && obj["type"]
  #     safe_types.include?(type) ? Object.const_get(type).new(obj) : obj
  #   end
  #   # Call to JSON.load
  #   ruby = JSON.load(json, proc {|obj|
  #     case obj
  #     when Hash
  #       obj.each {|k, v| obj[k] = deserialize_obj v }
  #     when Array
  #       obj.map! {|v| deserialize_obj v }
  #     end
  #     obj
  #   })
  #   pp ruby
  # Output:
  #   {"users"=>
  #      [#<User:0x00000000064c4c98
  #        @attributes=
  #          {"type"=>"User", "username"=>"jane", "email"=>"jane@example.com"}>,
  #        #<User:0x00000000064c4bd0
  #        @attributes=
  #          {"type"=>"User", "username"=>"john", "email"=>"john@example.com"}>],
  #    "accounts"=>
  #      [{"account"=>
  #          #<Account:0x00000000064c4928
  #          @attributes={"type"=>"Account", "paid"=>true, "account_id"=>"1234"}>},
  #       {"account"=>
  #          #<Account:0x00000000064c4680
  #          @attributes={"type"=>"Account", "paid"=>false, "account_id"=>"1235"}>}],
  #    "admins"=>
  #      #<Admin:0x00000000064c41f8
  #      @attributes={"type"=>"Admin", "password"=>"0wn3d"}>}
  #
  # source://json//lib/json/common.rb#854
  def load(source, proc = T.unsafe(nil), options = T.unsafe(nil)); end

  # :call-seq:
  #   JSON.load_file(path, opts={}) -> object
  #
  # Calls:
  #   parse(File.read(path), opts)
  #
  # See method #parse.
  #
  # source://json//lib/json/common.rb#388
  def load_file(filespec, opts = T.unsafe(nil)); end

  # :call-seq:
  #   JSON.load_file!(path, opts = {})
  #
  # Calls:
  #   JSON.parse!(File.read(path, opts))
  #
  # See method #parse!
  #
  # source://json//lib/json/common.rb#399
  def load_file!(filespec, opts = T.unsafe(nil)); end

  # :call-seq:
  #   JSON.parse(source, opts) -> object
  #
  # Returns the Ruby objects created by parsing the given +source+.
  #
  # Argument +source+ contains the \String to be parsed.
  #
  # Argument +opts+, if given, contains a \Hash of options for the parsing.
  # See {Parsing Options}[#module-JSON-label-Parsing+Options].
  #
  # ---
  #
  # When +source+ is a \JSON array, returns a Ruby \Array:
  #   source = '["foo", 1.0, true, false, null]'
  #   ruby = JSON.parse(source)
  #   ruby # => ["foo", 1.0, true, false, nil]
  #   ruby.class # => Array
  #
  # When +source+ is a \JSON object, returns a Ruby \Hash:
  #   source = '{"a": "foo", "b": 1.0, "c": true, "d": false, "e": null}'
  #   ruby = JSON.parse(source)
  #   ruby # => {"a"=>"foo", "b"=>1.0, "c"=>true, "d"=>false, "e"=>nil}
  #   ruby.class # => Hash
  #
  # For examples of parsing for all \JSON data types, see
  # {Parsing \JSON}[#module-JSON-label-Parsing+JSON].
  #
  # Parses nested JSON objects:
  #   source = <<~JSON
  #     {
  #     "name": "Dave",
  #       "age" :40,
  #       "hats": [
  #         "Cattleman's",
  #         "Panama",
  #         "Tophat"
  #       ]
  #     }
  #   JSON
  #   ruby = JSON.parse(source)
  #   ruby # => {"name"=>"Dave", "age"=>40, "hats"=>["Cattleman's", "Panama", "Tophat"]}
  #
  # ---
  #
  # Raises an exception if +source+ is not valid JSON:
  #   # Raises JSON::ParserError (783: unexpected token at ''):
  #   JSON.parse('')
  #
  # source://json//lib/json/common.rb#351
  def parse(source, opts = T.unsafe(nil)); end

  # :call-seq:
  #   JSON.parse!(source, opts) -> object
  #
  # Calls
  #   parse(source, opts)
  # with +source+ and possibly modified +opts+.
  #
  # Differences from JSON.parse:
  # - Option +max_nesting+, if not provided, defaults to +false+,
  #   which disables checking for nesting depth.
  # - Option +allow_nan+, if not provided, defaults to +true+.
  #
  # source://json//lib/json/common.rb#373
  def parse!(source, opts = T.unsafe(nil)); end

  # :call-seq:
  #   JSON.pretty_generate(obj, opts = nil) -> new_string
  #
  # Arguments +obj+ and +opts+ here are the same as
  # arguments +obj+ and +opts+ in JSON.generate.
  #
  # Default options are:
  #   {
  #     indent: '  ',   # Two spaces
  #     space: ' ',     # One space
  #     array_nl: "\n", # Newline
  #     object_nl: "\n" # Newline
  #   }
  #
  # Example:
  #   obj = {foo: [:bar, :baz], bat: {bam: 0, bad: 1}}
  #   json = JSON.pretty_generate(obj)
  #   puts json
  # Output:
  #   {
  #     "foo": [
  #       "bar",
  #       "baz"
  #     ],
  #     "bat": {
  #       "bam": 0,
  #       "bad": 1
  #     }
  #   }
  #
  # source://json//lib/json/common.rb#507
  def pretty_generate(obj, opts = T.unsafe(nil)); end

  # source://json//lib/json/common.rb#985
  def pretty_unparse(*_arg0, **_arg1, &_arg2); end

  # source://json//lib/json/common.rb#995
  def restore(*_arg0, **_arg1, &_arg2); end

  # :stopdoc:
  # All these were meant to be deprecated circa 2009, but were just set as undocumented
  # so usage still exist in the wild.
  #
  # source://json//lib/json/common.rb#965
  def unparse(*_arg0, **_arg1, &_arg2); end

  # :call-seq:
  #   JSON.unsafe_load(source, options = {}) -> object
  #   JSON.unsafe_load(source, proc = nil, options = {}) -> object
  #
  # Returns the Ruby objects created by parsing the given +source+.
  #
  # BEWARE: This method is meant to serialise data from trusted user input,
  # like from your own database server or clients under your control, it could
  # be dangerous to allow untrusted users to pass JSON sources into it.
  #
  # - Argument +source+ must be, or be convertible to, a \String:
  #   - If +source+ responds to instance method +to_str+,
  #     <tt>source.to_str</tt> becomes the source.
  #   - If +source+ responds to instance method +to_io+,
  #     <tt>source.to_io.read</tt> becomes the source.
  #   - If +source+ responds to instance method +read+,
  #     <tt>source.read</tt> becomes the source.
  #   - If both of the following are true, source becomes the \String <tt>'null'</tt>:
  #     - Option +allow_blank+ specifies a truthy value.
  #     - The source, as defined above, is +nil+ or the empty \String <tt>''</tt>.
  #   - Otherwise, +source+ remains the source.
  # - Argument +proc+, if given, must be a \Proc that accepts one argument.
  #   It will be called recursively with each result (depth-first order).
  #   See details below.
  # - Argument +opts+, if given, contains a \Hash of options for the parsing.
  #   See {Parsing Options}[#module-JSON-label-Parsing+Options].
  #   The default options can be changed via method JSON.unsafe_load_default_options=.
  #
  # ---
  #
  # When no +proc+ is given, modifies +source+ as above and returns the result of
  # <tt>parse(source, opts)</tt>;  see #parse.
  #
  # Source for following examples:
  #   source = <<~JSON
  #     {
  #       "name": "Dave",
  #       "age" :40,
  #       "hats": [
  #         "Cattleman's",
  #         "Panama",
  #         "Tophat"
  #       ]
  #     }
  #   JSON
  #
  # Load a \String:
  #   ruby = JSON.unsafe_load(source)
  #   ruby # => {"name"=>"Dave", "age"=>40, "hats"=>["Cattleman's", "Panama", "Tophat"]}
  #
  # Load an \IO object:
  #   require 'stringio'
  #   object = JSON.unsafe_load(StringIO.new(source))
  #   object # => {"name"=>"Dave", "age"=>40, "hats"=>["Cattleman's", "Panama", "Tophat"]}
  #
  # Load a \File object:
  #   path = 't.json'
  #   File.write(path, source)
  #   File.open(path) do |file|
  #     JSON.unsafe_load(file)
  #   end # => {"name"=>"Dave", "age"=>40, "hats"=>["Cattleman's", "Panama", "Tophat"]}
  #
  # ---
  #
  # When +proc+ is given:
  # - Modifies +source+ as above.
  # - Gets the +result+ from calling <tt>parse(source, opts)</tt>.
  # - Recursively calls <tt>proc(result)</tt>.
  # - Returns the final result.
  #
  # Example:
  #   require 'json'
  #
  #   # Some classes for the example.
  #   class Base
  #     def initialize(attributes)
  #       @attributes = attributes
  #     end
  #   end
  #   class User    < Base; end
  #   class Account < Base; end
  #   class Admin   < Base; end
  #   # The JSON source.
  #   json = <<-EOF
  #   {
  #     "users": [
  #         {"type": "User", "username": "jane", "email": "jane@example.com"},
  #         {"type": "User", "username": "john", "email": "john@example.com"}
  #     ],
  #     "accounts": [
  #         {"account": {"type": "Account", "paid": true, "account_id": "1234"}},
  #         {"account": {"type": "Account", "paid": false, "account_id": "1235"}}
  #     ],
  #     "admins": {"type": "Admin", "password": "0wn3d"}
  #   }
  #   EOF
  #   # Deserializer method.
  #   def deserialize_obj(obj, safe_types = %w(User Account Admin))
  #     type = obj.is_a?(Hash) && obj["type"]
  #     safe_types.include?(type) ? Object.const_get(type).new(obj) : obj
  #   end
  #   # Call to JSON.unsafe_load
  #   ruby = JSON.unsafe_load(json, proc {|obj|
  #     case obj
  #     when Hash
  #       obj.each {|k, v| obj[k] = deserialize_obj v }
  #     when Array
  #       obj.map! {|v| deserialize_obj v }
  #     end
  #     obj
  #   })
  #   pp ruby
  # Output:
  #   {"users"=>
  #      [#<User:0x00000000064c4c98
  #        @attributes=
  #          {"type"=>"User", "username"=>"jane", "email"=>"jane@example.com"}>,
  #        #<User:0x00000000064c4bd0
  #        @attributes=
  #          {"type"=>"User", "username"=>"john", "email"=>"john@example.com"}>],
  #    "accounts"=>
  #      [{"account"=>
  #          #<Account:0x00000000064c4928
  #          @attributes={"type"=>"Account", "paid"=>true, "account_id"=>"1234"}>},
  #       {"account"=>
  #          #<Account:0x00000000064c4680
  #          @attributes={"type"=>"Account", "paid"=>false, "account_id"=>"1235"}>}],
  #    "admins"=>
  #      #<Admin:0x00000000064c41f8
  #      @attributes={"type"=>"Admin", "password"=>"0wn3d"}>}
  #
  # source://json//lib/json/common.rb#683
  def unsafe_load(source, proc = T.unsafe(nil), options = T.unsafe(nil)); end

  class << self
    # :call-seq:
    #   JSON[object] -> new_array or new_string
    #
    # If +object+ is a \String,
    # calls JSON.parse with +object+ and +opts+ (see method #parse):
    #   json = '[0, 1, null]'
    #   JSON[json]# => [0, 1, nil]
    #
    # Otherwise, calls JSON.generate with +object+ and +opts+ (see method #generate):
    #   ruby = [0, 1, nil]
    #   JSON[ruby] # => '[0,1,null]'
    #
    # source://json//lib/json/common.rb#132
    def [](object, opts = T.unsafe(nil)); end

    # source://json//lib/json/common.rb#206
    def _dump_default_options; end

    # source://json//lib/json/common.rb#206
    def _load_default_options; end

    # source://json//lib/json/common.rb#206
    def _unsafe_load_default_options; end

    # Returns the current create identifier.
    # See also JSON.create_id=.
    #
    # source://json//lib/json/common.rb#234
    def create_id; end

    # Sets create identifier, which is used to decide if the _json_create_
    # hook of a class should be called; initial value is +json_class+:
    #   JSON.create_id # => 'json_class'
    #
    # source://json//lib/json/common.rb#228
    def create_id=(new_value); end

    # source://json//lib/json/common.rb#104
    def deprecation_warning(message, uplevel = T.unsafe(nil)); end

    # :call-seq:
    #   JSON.dump(obj, io = nil, limit = nil)
    #
    # Dumps +obj+ as a \JSON string, i.e. calls generate on the object and returns the result.
    #
    # The default options can be changed via method JSON.dump_default_options.
    #
    # - Argument +io+, if given, should respond to method +write+;
    #   the \JSON \String is written to +io+, and +io+ is returned.
    #   If +io+ is not given, the \JSON \String is returned.
    # - Argument +limit+, if given, is passed to JSON.generate as option +max_nesting+.
    #
    # ---
    #
    # When argument +io+ is not given, returns the \JSON \String generated from +obj+:
    #   obj = {foo: [0, 1], bar: {baz: 2, bat: 3}, bam: :bad}
    #   json = JSON.dump(obj)
    #   json # => "{\"foo\":[0,1],\"bar\":{\"baz\":2,\"bat\":3},\"bam\":\"bad\"}"
    #
    # When argument +io+ is given, writes the \JSON \String to +io+ and returns +io+:
    #   path = 't.json'
    #   File.open(path, 'w') do |file|
    #     JSON.dump(obj, file)
    #   end # => #<File:t.json (closed)>
    #   puts File.read(path)
    # Output:
    #   {"foo":[0,1],"bar":{"baz":2,"bat":3},"bam":"bad"}
    #
    # source://json//lib/json/common.rb#930
    def dump(obj, anIO = T.unsafe(nil), limit = T.unsafe(nil), kwargs = T.unsafe(nil)); end

    # source://json//lib/json/common.rb#206
    def dump_default_options; end

    # source://json//lib/json/common.rb#206
    def dump_default_options=(val); end

    # :call-seq:
    #   JSON.fast_generate(obj, opts) -> new_string
    #
    # Arguments +obj+ and +opts+ here are the same as
    # arguments +obj+ and +opts+ in JSON.generate.
    #
    # By default, generates \JSON data without checking
    # for circular references in +obj+ (option +max_nesting+ set to +false+, disabled).
    #
    # Raises an exception if +obj+ contains circular references:
    #   a = []; b = []; a.push(b); b.push(a)
    #   # Raises SystemStackError (stack level too deep):
    #   JSON.fast_generate(a)
    #
    # source://json//lib/json/common.rb#460
    def fast_generate(obj, opts = T.unsafe(nil)); end

    # source://json//lib/json/common.rb#975
    def fast_unparse(*_arg0, **_arg1, &_arg2); end

    # :call-seq:
    #   JSON.generate(obj, opts = nil) -> new_string
    #
    # Returns a \String containing the generated \JSON data.
    #
    # See also JSON.pretty_generate.
    #
    # Argument +obj+ is the Ruby object to be converted to \JSON.
    #
    # Argument +opts+, if given, contains a \Hash of options for the generation.
    # See {Generating Options}[#module-JSON-label-Generating+Options].
    #
    # ---
    #
    # When +obj+ is an \Array, returns a \String containing a \JSON array:
    #   obj = ["foo", 1.0, true, false, nil]
    #   json = JSON.generate(obj)
    #   json # => '["foo",1.0,true,false,null]'
    #
    # When +obj+ is a \Hash, returns a \String containing a \JSON object:
    #   obj = {foo: 0, bar: 's', baz: :bat}
    #   json = JSON.generate(obj)
    #   json # => '{"foo":0,"bar":"s","baz":"bat"}'
    #
    # For examples of generating from other Ruby objects, see
    # {Generating \JSON from Other Objects}[#module-JSON-label-Generating+JSON+from+Other+Objects].
    #
    # ---
    #
    # Raises an exception if any formatting option is not a \String.
    #
    # Raises an exception if +obj+ contains circular references:
    #   a = []; b = []; a.push(b); b.push(a)
    #   # Raises JSON::NestingError (nesting of 100 is too deep):
    #   JSON.generate(a)
    #
    # source://json//lib/json/common.rb#439
    def generate(obj, opts = T.unsafe(nil)); end

    # Returns the JSON generator module that is used by JSON.
    #
    # source://json//lib/json/common.rb#177
    def generator; end

    # Set the module _generator_ to be used by JSON.
    #
    # source://json//lib/json/common.rb#156
    def generator=(generator); end

    # :call-seq:
    #   JSON.load(source, options = {}) -> object
    #   JSON.load(source, proc = nil, options = {}) -> object
    #
    # Returns the Ruby objects created by parsing the given +source+.
    #
    # BEWARE: This method is meant to serialise data from trusted user input,
    # like from your own database server or clients under your control, it could
    # be dangerous to allow untrusted users to pass JSON sources into it.
    # If you must use it, use JSON.unsafe_load instead to make it clear.
    #
    # Since JSON version 2.8.0, `load` emits a deprecation warning when a
    # non native type is deserialized, without `create_additions` being explicitly
    # enabled, and in JSON version 3.0, `load` will have `create_additions` disabled
    # by default.
    #
    # - Argument +source+ must be, or be convertible to, a \String:
    #   - If +source+ responds to instance method +to_str+,
    #     <tt>source.to_str</tt> becomes the source.
    #   - If +source+ responds to instance method +to_io+,
    #     <tt>source.to_io.read</tt> becomes the source.
    #   - If +source+ responds to instance method +read+,
    #     <tt>source.read</tt> becomes the source.
    #   - If both of the following are true, source becomes the \String <tt>'null'</tt>:
    #     - Option +allow_blank+ specifies a truthy value.
    #     - The source, as defined above, is +nil+ or the empty \String <tt>''</tt>.
    #   - Otherwise, +source+ remains the source.
    # - Argument +proc+, if given, must be a \Proc that accepts one argument.
    #   It will be called recursively with each result (depth-first order).
    #   See details below.
    # - Argument +opts+, if given, contains a \Hash of options for the parsing.
    #   See {Parsing Options}[#module-JSON-label-Parsing+Options].
    #   The default options can be changed via method JSON.load_default_options=.
    #
    # ---
    #
    # When no +proc+ is given, modifies +source+ as above and returns the result of
    # <tt>parse(source, opts)</tt>;  see #parse.
    #
    # Source for following examples:
    #   source = <<~JSON
    #     {
    #       "name": "Dave",
    #       "age" :40,
    #       "hats": [
    #         "Cattleman's",
    #         "Panama",
    #         "Tophat"
    #       ]
    #     }
    #   JSON
    #
    # Load a \String:
    #   ruby = JSON.load(source)
    #   ruby # => {"name"=>"Dave", "age"=>40, "hats"=>["Cattleman's", "Panama", "Tophat"]}
    #
    # Load an \IO object:
    #   require 'stringio'
    #   object = JSON.load(StringIO.new(source))
    #   object # => {"name"=>"Dave", "age"=>40, "hats"=>["Cattleman's", "Panama", "Tophat"]}
    #
    # Load a \File object:
    #   path = 't.json'
    #   File.write(path, source)
    #   File.open(path) do |file|
    #     JSON.load(file)
    #   end # => {"name"=>"Dave", "age"=>40, "hats"=>["Cattleman's", "Panama", "Tophat"]}
    #
    # ---
    #
    # When +proc+ is given:
    # - Modifies +source+ as above.
    # - Gets the +result+ from calling <tt>parse(source, opts)</tt>.
    # - Recursively calls <tt>proc(result)</tt>.
    # - Returns the final result.
    #
    # Example:
    #   require 'json'
    #
    #   # Some classes for the example.
    #   class Base
    #     def initialize(attributes)
    #       @attributes = attributes
    #     end
    #   end
    #   class User    < Base; end
    #   class Account < Base; end
    #   class Admin   < Base; end
    #   # The JSON source.
    #   json = <<-EOF
    #   {
    #     "users": [
    #         {"type": "User", "username": "jane", "email": "jane@example.com"},
    #         {"type": "User", "username": "john", "email": "john@example.com"}
    #     ],
    #     "accounts": [
    #         {"account": {"type": "Account", "paid": true, "account_id": "1234"}},
    #         {"account": {"type": "Account", "paid": false, "account_id": "1235"}}
    #     ],
    #     "admins": {"type": "Admin", "password": "0wn3d"}
    #   }
    #   EOF
    #   # Deserializer method.
    #   def deserialize_obj(obj, safe_types = %w(User Account Admin))
    #     type = obj.is_a?(Hash) && obj["type"]
    #     safe_types.include?(type) ? Object.const_get(type).new(obj) : obj
    #   end
    #   # Call to JSON.load
    #   ruby = JSON.load(json, proc {|obj|
    #     case obj
    #     when Hash
    #       obj.each {|k, v| obj[k] = deserialize_obj v }
    #     when Array
    #       obj.map! {|v| deserialize_obj v }
    #     end
    #     obj
    #   })
    #   pp ruby
    # Output:
    #   {"users"=>
    #      [#<User:0x00000000064c4c98
    #        @attributes=
    #          {"type"=>"User", "username"=>"jane", "email"=>"jane@example.com"}>,
    #        #<User:0x00000000064c4bd0
    #        @attributes=
    #          {"type"=>"User", "username"=>"john", "email"=>"john@example.com"}>],
    #    "accounts"=>
    #      [{"account"=>
    #          #<Account:0x00000000064c4928
    #          @attributes={"type"=>"Account", "paid"=>true, "account_id"=>"1234"}>},
    #       {"account"=>
    #          #<Account:0x00000000064c4680
    #          @attributes={"type"=>"Account", "paid"=>false, "account_id"=>"1235"}>}],
    #    "admins"=>
    #      #<Admin:0x00000000064c41f8
    #      @attributes={"type"=>"Admin", "password"=>"0wn3d"}>}
    #
    # source://json//lib/json/common.rb#854
    def load(source, proc = T.unsafe(nil), options = T.unsafe(nil)); end

    # source://json//lib/json/common.rb#206
    def load_default_options; end

    # source://json//lib/json/common.rb#206
    def load_default_options=(val); end

    # :call-seq:
    #   JSON.load_file(path, opts={}) -> object
    #
    # Calls:
    #   parse(File.read(path), opts)
    #
    # See method #parse.
    #
    # source://json//lib/json/common.rb#388
    def load_file(filespec, opts = T.unsafe(nil)); end

    # :call-seq:
    #   JSON.load_file!(path, opts = {})
    #
    # Calls:
    #   JSON.parse!(File.read(path, opts))
    #
    # See method #parse!
    #
    # source://json//lib/json/common.rb#399
    def load_file!(filespec, opts = T.unsafe(nil)); end

    # :call-seq:
    #   JSON.parse(source, opts) -> object
    #
    # Returns the Ruby objects created by parsing the given +source+.
    #
    # Argument +source+ contains the \String to be parsed.
    #
    # Argument +opts+, if given, contains a \Hash of options for the parsing.
    # See {Parsing Options}[#module-JSON-label-Parsing+Options].
    #
    # ---
    #
    # When +source+ is a \JSON array, returns a Ruby \Array:
    #   source = '["foo", 1.0, true, false, null]'
    #   ruby = JSON.parse(source)
    #   ruby # => ["foo", 1.0, true, false, nil]
    #   ruby.class # => Array
    #
    # When +source+ is a \JSON object, returns a Ruby \Hash:
    #   source = '{"a": "foo", "b": 1.0, "c": true, "d": false, "e": null}'
    #   ruby = JSON.parse(source)
    #   ruby # => {"a"=>"foo", "b"=>1.0, "c"=>true, "d"=>false, "e"=>nil}
    #   ruby.class # => Hash
    #
    # For examples of parsing for all \JSON data types, see
    # {Parsing \JSON}[#module-JSON-label-Parsing+JSON].
    #
    # Parses nested JSON objects:
    #   source = <<~JSON
    #     {
    #     "name": "Dave",
    #       "age" :40,
    #       "hats": [
    #         "Cattleman's",
    #         "Panama",
    #         "Tophat"
    #       ]
    #     }
    #   JSON
    #   ruby = JSON.parse(source)
    #   ruby # => {"name"=>"Dave", "age"=>40, "hats"=>["Cattleman's", "Panama", "Tophat"]}
    #
    # ---
    #
    # Raises an exception if +source+ is not valid JSON:
    #   # Raises JSON::ParserError (783: unexpected token at ''):
    #   JSON.parse('')
    #
    # source://json//lib/json/common.rb#351
    def parse(source, opts = T.unsafe(nil)); end

    # :call-seq:
    #   JSON.parse!(source, opts) -> object
    #
    # Calls
    #   parse(source, opts)
    # with +source+ and possibly modified +opts+.
    #
    # Differences from JSON.parse:
    # - Option +max_nesting+, if not provided, defaults to +false+,
    #   which disables checking for nesting depth.
    # - Option +allow_nan+, if not provided, defaults to +true+.
    #
    # source://json//lib/json/common.rb#373
    def parse!(source, opts = T.unsafe(nil)); end

    # Returns the JSON parser class that is used by JSON.
    #
    # source://json//lib/json/common.rb#146
    def parser; end

    # Set the JSON parser class _parser_ to be used by JSON.
    #
    # source://json//lib/json/common.rb#149
    def parser=(parser); end

    # :call-seq:
    #   JSON.pretty_generate(obj, opts = nil) -> new_string
    #
    # Arguments +obj+ and +opts+ here are the same as
    # arguments +obj+ and +opts+ in JSON.generate.
    #
    # Default options are:
    #   {
    #     indent: '  ',   # Two spaces
    #     space: ' ',     # One space
    #     array_nl: "\n", # Newline
    #     object_nl: "\n" # Newline
    #   }
    #
    # Example:
    #   obj = {foo: [:bar, :baz], bat: {bam: 0, bad: 1}}
    #   json = JSON.pretty_generate(obj)
    #   puts json
    # Output:
    #   {
    #     "foo": [
    #       "bar",
    #       "baz"
    #     ],
    #     "bat": {
    #       "bam": 0,
    #       "bad": 1
    #     }
    #   }
    #
    # source://json//lib/json/common.rb#507
    def pretty_generate(obj, opts = T.unsafe(nil)); end

    # source://json//lib/json/common.rb#985
    def pretty_unparse(*_arg0, **_arg1, &_arg2); end

    # source://json//lib/json/common.rb#995
    def restore(*_arg0, **_arg1, &_arg2); end

    # Sets or Returns the JSON generator state class that is used by JSON.
    #
    # source://json//lib/json/common.rb#180
    def state; end

    # Sets or Returns the JSON generator state class that is used by JSON.
    #
    # source://json//lib/json/common.rb#180
    def state=(_arg0); end

    # :stopdoc:
    # All these were meant to be deprecated circa 2009, but were just set as undocumented
    # so usage still exist in the wild.
    #
    # source://json//lib/json/common.rb#965
    def unparse(*_arg0, **_arg1, &_arg2); end

    # :call-seq:
    #   JSON.unsafe_load(source, options = {}) -> object
    #   JSON.unsafe_load(source, proc = nil, options = {}) -> object
    #
    # Returns the Ruby objects created by parsing the given +source+.
    #
    # BEWARE: This method is meant to serialise data from trusted user input,
    # like from your own database server or clients under your control, it could
    # be dangerous to allow untrusted users to pass JSON sources into it.
    #
    # - Argument +source+ must be, or be convertible to, a \String:
    #   - If +source+ responds to instance method +to_str+,
    #     <tt>source.to_str</tt> becomes the source.
    #   - If +source+ responds to instance method +to_io+,
    #     <tt>source.to_io.read</tt> becomes the source.
    #   - If +source+ responds to instance method +read+,
    #     <tt>source.read</tt> becomes the source.
    #   - If both of the following are true, source becomes the \String <tt>'null'</tt>:
    #     - Option +allow_blank+ specifies a truthy value.
    #     - The source, as defined above, is +nil+ or the empty \String <tt>''</tt>.
    #   - Otherwise, +source+ remains the source.
    # - Argument +proc+, if given, must be a \Proc that accepts one argument.
    #   It will be called recursively with each result (depth-first order).
    #   See details below.
    # - Argument +opts+, if given, contains a \Hash of options for the parsing.
    #   See {Parsing Options}[#module-JSON-label-Parsing+Options].
    #   The default options can be changed via method JSON.unsafe_load_default_options=.
    #
    # ---
    #
    # When no +proc+ is given, modifies +source+ as above and returns the result of
    # <tt>parse(source, opts)</tt>;  see #parse.
    #
    # Source for following examples:
    #   source = <<~JSON
    #     {
    #       "name": "Dave",
    #       "age" :40,
    #       "hats": [
    #         "Cattleman's",
    #         "Panama",
    #         "Tophat"
    #       ]
    #     }
    #   JSON
    #
    # Load a \String:
    #   ruby = JSON.unsafe_load(source)
    #   ruby # => {"name"=>"Dave", "age"=>40, "hats"=>["Cattleman's", "Panama", "Tophat"]}
    #
    # Load an \IO object:
    #   require 'stringio'
    #   object = JSON.unsafe_load(StringIO.new(source))
    #   object # => {"name"=>"Dave", "age"=>40, "hats"=>["Cattleman's", "Panama", "Tophat"]}
    #
    # Load a \File object:
    #   path = 't.json'
    #   File.write(path, source)
    #   File.open(path) do |file|
    #     JSON.unsafe_load(file)
    #   end # => {"name"=>"Dave", "age"=>40, "hats"=>["Cattleman's", "Panama", "Tophat"]}
    #
    # ---
    #
    # When +proc+ is given:
    # - Modifies +source+ as above.
    # - Gets the +result+ from calling <tt>parse(source, opts)</tt>.
    # - Recursively calls <tt>proc(result)</tt>.
    # - Returns the final result.
    #
    # Example:
    #   require 'json'
    #
    #   # Some classes for the example.
    #   class Base
    #     def initialize(attributes)
    #       @attributes = attributes
    #     end
    #   end
    #   class User    < Base; end
    #   class Account < Base; end
    #   class Admin   < Base; end
    #   # The JSON source.
    #   json = <<-EOF
    #   {
    #     "users": [
    #         {"type": "User", "username": "jane", "email": "jane@example.com"},
    #         {"type": "User", "username": "john", "email": "john@example.com"}
    #     ],
    #     "accounts": [
    #         {"account": {"type": "Account", "paid": true, "account_id": "1234"}},
    #         {"account": {"type": "Account", "paid": false, "account_id": "1235"}}
    #     ],
    #     "admins": {"type": "Admin", "password": "0wn3d"}
    #   }
    #   EOF
    #   # Deserializer method.
    #   def deserialize_obj(obj, safe_types = %w(User Account Admin))
    #     type = obj.is_a?(Hash) && obj["type"]
    #     safe_types.include?(type) ? Object.const_get(type).new(obj) : obj
    #   end
    #   # Call to JSON.unsafe_load
    #   ruby = JSON.unsafe_load(json, proc {|obj|
    #     case obj
    #     when Hash
    #       obj.each {|k, v| obj[k] = deserialize_obj v }
    #     when Array
    #       obj.map! {|v| deserialize_obj v }
    #     end
    #     obj
    #   })
    #   pp ruby
    # Output:
    #   {"users"=>
    #      [#<User:0x00000000064c4c98
    #        @attributes=
    #          {"type"=>"User", "username"=>"jane", "email"=>"jane@example.com"}>,
    #        #<User:0x00000000064c4bd0
    #        @attributes=
    #          {"type"=>"User", "username"=>"john", "email"=>"john@example.com"}>],
    #    "accounts"=>
    #      [{"account"=>
    #          #<Account:0x00000000064c4928
    #          @attributes={"type"=>"Account", "paid"=>true, "account_id"=>"1234"}>},
    #       {"account"=>
    #          #<Account:0x00000000064c4680
    #          @attributes={"type"=>"Account", "paid"=>false, "account_id"=>"1235"}>}],
    #    "admins"=>
    #      #<Admin:0x00000000064c41f8
    #      @attributes={"type"=>"Admin", "password"=>"0wn3d"}>}
    #
    # source://json//lib/json/common.rb#683
    def unsafe_load(source, proc = T.unsafe(nil), options = T.unsafe(nil)); end

    # source://json//lib/json/common.rb#206
    def unsafe_load_default_options; end

    # source://json//lib/json/common.rb#206
    def unsafe_load_default_options=(val); end

    private

    # source://json//lib/json/common.rb#1008
    def const_missing(const_name); end

    # source://json//lib/json/common.rb#203
    def deprecated_singleton_attr_accessor(*attrs); end

    # Called from the extension when a hash has both string and symbol keys
    #
    # source://json//lib/json/common.rb#185
    def on_mixed_keys_hash(hash, do_raise); end
  end
end

# JSON::Coder holds a parser and generator configuration.
#
#   module MyApp
#     JSONC_CODER = JSON::Coder.new(
#       allow_trailing_comma: true
#     )
#   end
#
#   MyApp::JSONC_CODER.load(document)
#
# source://json//lib/json/common.rb#1034
class JSON::Coder
  # :call-seq:
  #   JSON.new(options = nil, &block)
  #
  # Argument +options+, if given, contains a \Hash of options for both parsing and generating.
  # See {Parsing Options}[#module-JSON-label-Parsing+Options], and {Generating Options}[#module-JSON-label-Generating+Options].
  #
  # For generation, the <tt>strict: true</tt> option is always set. When a Ruby object with no native \JSON counterpart is
  # encountered, the block provided to the initialize method is invoked, and must return a Ruby object that has a native
  # \JSON counterpart:
  #
  #  module MyApp
  #    API_JSON_CODER = JSON::Coder.new do |object|
  #      case object
  #      when Time
  #        object.iso8601(3)
  #      else
  #        object # Unknown type, will raise
  #      end
  #    end
  #  end
  #
  #  puts MyApp::API_JSON_CODER.dump(Time.now.utc) # => "2025-01-21T08:41:44.286Z"
  #
  # @return [Coder] a new instance of Coder
  #
  # source://json//lib/json/common.rb#1058
  def initialize(options = T.unsafe(nil), &as_json); end

  # call-seq:
  #   dump(object) -> String
  #   dump(object, io) -> io
  #
  # Serialize the given object into a \JSON document.
  #
  # source://json//lib/json/common.rb#1076
  def dump(object, io = T.unsafe(nil)); end

  # call-seq:
  #   dump(object) -> String
  #   dump(object, io) -> io
  #
  # Serialize the given object into a \JSON document.
  #
  # source://json//lib/json/common.rb#1079
  def generate(object, io = T.unsafe(nil)); end

  # call-seq:
  #   load(string) -> Object
  #
  # Parse the given \JSON document and return an equivalent Ruby object.
  #
  # source://json//lib/json/common.rb#1085
  def load(source); end

  # call-seq:
  #   load(path) -> Object
  #
  # Parse the given \JSON document and return an equivalent Ruby object.
  #
  # source://json//lib/json/common.rb#1094
  def load_file(path); end

  # call-seq:
  #   load(string) -> Object
  #
  # Parse the given \JSON document and return an equivalent Ruby object.
  #
  # source://json//lib/json/common.rb#1088
  def parse(source); end
end

module JSON::Ext::Generator::GeneratorMethods::Array
  # source://json//lib/json/ext.rb#39
  def to_json(*_arg0); end
end

module JSON::Ext::Generator::GeneratorMethods::FalseClass
  # source://json//lib/json/ext.rb#39
  def to_json(*_arg0); end
end

module JSON::Ext::Generator::GeneratorMethods::Float
  # source://json//lib/json/ext.rb#39
  def to_json(*_arg0); end
end

module JSON::Ext::Generator::GeneratorMethods::Hash
  # source://json//lib/json/ext.rb#39
  def to_json(*_arg0); end
end

module JSON::Ext::Generator::GeneratorMethods::Integer
  # source://json//lib/json/ext.rb#39
  def to_json(*_arg0); end
end

module JSON::Ext::Generator::GeneratorMethods::NilClass
  # source://json//lib/json/ext.rb#39
  def to_json(*_arg0); end
end

module JSON::Ext::Generator::GeneratorMethods::Object
  # source://json//lib/json/ext.rb#39
  def to_json(*_arg0); end
end

module JSON::Ext::Generator::GeneratorMethods::String
  # source://json//lib/json/ext.rb#39
  def to_json(*_arg0); end
end

module JSON::Ext::Generator::GeneratorMethods::TrueClass
  # source://json//lib/json/ext.rb#39
  def to_json(*_arg0); end
end

# source://json//lib/json/ext/generator/state.rb#6
class JSON::Ext::Generator::State
  # call-seq: new(opts = {})
  #
  # Instantiates a new State object, configured by _opts_.
  #
  # Argument +opts+, if given, contains a \Hash of options for the generation.
  # See {Generating Options}[#module-JSON-label-Generating+Options].
  #
  # @return [State] a new instance of State
  #
  # source://json//lib/json/ext.rb#39
  def initialize(opts = T.unsafe(nil)); end

  # call-seq: [](name)
  #
  # Returns the value returned by method +name+.
  #
  # source://json//lib/json/ext/generator/state.rb#77
  def [](name); end

  # call-seq: []=(name, value)
  #
  # Sets the attribute name to value.
  #
  # source://json//lib/json/ext/generator/state.rb#91
  def []=(name, value); end

  # source://json//lib/json/ext.rb#39
  def allow_nan=(_arg0); end

  # source://json//lib/json/ext.rb#39
  def allow_nan?; end

  # source://json//lib/json/ext.rb#39
  def array_nl; end

  # source://json//lib/json/ext.rb#39
  def array_nl=(_arg0); end

  # source://json//lib/json/ext.rb#39
  def as_json; end

  # source://json//lib/json/ext.rb#39
  def as_json=(_arg0); end

  # source://json//lib/json/ext.rb#39
  def ascii_only=(_arg0); end

  # source://json//lib/json/ext.rb#39
  def ascii_only?; end

  # source://json//lib/json/ext.rb#39
  def buffer_initial_length; end

  # source://json//lib/json/ext.rb#39
  def buffer_initial_length=(_arg0); end

  # source://json//lib/json/ext.rb#39
  def check_circular?; end

  # call-seq: configure(opts)
  #
  # Configure this State instance with the Hash _opts_, and return
  # itself.
  #
  # source://json//lib/json/ext/generator/state.rb#23
  def configure(opts); end

  # source://json//lib/json/ext.rb#39
  def depth; end

  # source://json//lib/json/ext.rb#39
  def depth=(_arg0); end

  # source://json//lib/json/ext.rb#39
  def escape_slash; end

  # source://json//lib/json/ext.rb#39
  def escape_slash=(_arg0); end

  # source://json//lib/json/ext.rb#39
  def escape_slash?; end

  # source://json//lib/json/ext.rb#39
  def generate(*_arg0); end

  # source://json//lib/json/ext.rb#39
  def indent; end

  # source://json//lib/json/ext.rb#39
  def indent=(_arg0); end

  # source://json//lib/json/ext.rb#39
  def max_nesting; end

  # source://json//lib/json/ext.rb#39
  def max_nesting=(_arg0); end

  # call-seq: configure(opts)
  #
  # Configure this State instance with the Hash _opts_, and return
  # itself.
  #
  # source://json//lib/json/ext/generator/state.rb#36
  def merge(opts); end

  # source://json//lib/json/ext.rb#39
  def object_nl; end

  # source://json//lib/json/ext.rb#39
  def object_nl=(_arg0); end

  # source://json//lib/json/ext.rb#39
  def script_safe; end

  # source://json//lib/json/ext.rb#39
  def script_safe=(_arg0); end

  # source://json//lib/json/ext.rb#39
  def script_safe?; end

  # source://json//lib/json/ext.rb#39
  def space; end

  # source://json//lib/json/ext.rb#39
  def space=(_arg0); end

  # source://json//lib/json/ext.rb#39
  def space_before; end

  # source://json//lib/json/ext.rb#39
  def space_before=(_arg0); end

  # source://json//lib/json/ext.rb#39
  def strict; end

  # source://json//lib/json/ext.rb#39
  def strict=(_arg0); end

  # source://json//lib/json/ext.rb#39
  def strict?; end

  # call-seq: to_h
  #
  # Returns the configuration instance variables as a hash, that can be
  # passed to the configure method.
  #
  # source://json//lib/json/ext/generator/state.rb#42
  def to_h; end

  # call-seq: to_h
  #
  # Returns the configuration instance variables as a hash, that can be
  # passed to the configure method.
  #
  # source://json//lib/json/ext/generator/state.rb#72
  def to_hash; end

  private

  # source://json//lib/json/ext.rb#39
  def _configure(_arg0); end

  # source://json//lib/json/ext.rb#39
  def allow_duplicate_key?; end

  # source://json//lib/json/ext.rb#39
  def initialize_copy(_arg0); end

  class << self
    # source://json//lib/json/ext.rb#39
    def from_state(_arg0); end

    # source://json//lib/json/ext.rb#39
    def generate(_arg0, _arg1, _arg2); end
  end
end

# source://json//lib/json/ext.rb#9
class JSON::Ext::Parser
  # @return [Parser] a new instance of Parser
  #
  # source://json//lib/json/ext.rb#17
  def initialize(source, opts = T.unsafe(nil)); end

  # source://json//lib/json/ext.rb#26
  def parse; end

  # source://json//lib/json/ext.rb#22
  def source; end

  class << self
    # Allow redefinition by extensions
    # Allow redefinition by extensions
    #
    # source://json//lib/json/ext.rb#11
    def parse(_arg0, _arg1); end
  end
end

# source://json//lib/json/ext.rb#32
JSON::Ext::Parser::Config = JSON::Ext::ParserConfig

class JSON::Ext::ParserConfig
  # source://json//lib/json/ext.rb#31
  def initialize(_arg0); end

  # source://json//lib/json/ext.rb#31
  def parse(_arg0); end
end

# Fragment of JSON document that is to be included as is:
#   fragment = JSON::Fragment.new("[1, 2, 3]")
#   JSON.generate({ count: 3, items: fragments })
#
# This allows to easily assemble multiple JSON fragments that have
# been persisted somewhere without having to parse them nor resorting
# to string interpolation.
#
# Note: no validation is performed on the provided string. It is the
# responsibility of the caller to ensure the string contains valid JSON.
#
# source://json//lib/json/common.rb#287
class JSON::Fragment < ::Struct
  # @return [Fragment] a new instance of Fragment
  #
  # source://json//lib/json/common.rb#288
  def initialize(json); end

  # Returns the value of attribute json
  #
  # @return [Object] the current value of json
  #
  # source://json//lib/json/common.rb#287
  def json; end

  # Sets the attribute json
  #
  # @param value [Object] the value to set the attribute json to.
  # @return [Object] the newly set value
  #
  # source://json//lib/json/common.rb#287
  def json=(_); end

  # source://json//lib/json/common.rb#296
  def to_json(state = T.unsafe(nil), *_arg1); end

  class << self
    # source://json//lib/json/common.rb#287
    def [](*_arg0); end

    # source://json//lib/json/common.rb#287
    def inspect; end

    # source://json//lib/json/common.rb#287
    def keyword_init?; end

    # source://json//lib/json/common.rb#287
    def members; end

    # source://json//lib/json/common.rb#287
    def new(*_arg0); end
  end
end

# This exception is raised if a generator or unparser error occurs.
#
# source://json//lib/json/common.rb#257
class JSON::GeneratorError < ::JSON::JSONError
  # @return [GeneratorError] a new instance of GeneratorError
  #
  # source://json//lib/json/common.rb#260
  def initialize(message, invalid_object = T.unsafe(nil)); end

  # source://json//lib/json/common.rb#265
  def detailed_message(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute invalid_object.
  #
  # source://json//lib/json/common.rb#258
  def invalid_object; end
end

# source://json//lib/json/common.rb#356
JSON::PARSE_L_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://json//lib/json/common.rb#469
JSON::PRETTY_GENERATE_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://json//lib/json/common.rb#152
JSON::Parser = JSON::Ext::Parser

# This exception is raised if a parser error occurs.
#
# source://json//lib/json/common.rb#248
class JSON::ParserError < ::JSON::JSONError
  # Returns the value of attribute column.
  #
  # source://json//lib/json/common.rb#249
  def column; end

  # Returns the value of attribute line.
  #
  # source://json//lib/json/common.rb#249
  def line; end
end

# source://json//lib/json/common.rb#8
module JSON::ParserOptions
  class << self
    # source://json//lib/json/common.rb#10
    def prepare(opts); end

    private

    # source://json//lib/json/common.rb#40
    def array_class_proc(array_class, on_load); end

    # TODO: extract :create_additions support to another gem for version 3.0
    #
    # source://json//lib/json/common.rb#52
    def create_additions_proc(opts); end

    # source://json//lib/json/common.rb#95
    def create_additions_warning; end

    # source://json//lib/json/common.rb#29
    def object_class_proc(object_class, on_load); end
  end
end

# source://json//lib/json/common.rb#171
JSON::State = JSON::Ext::Generator::State

# source://json//lib/json/common.rb#1100
module Kernel
  private

  # If _object_ is string-like, parse the string and return the parsed result as
  # a Ruby data structure. Otherwise, generate a JSON text from the Ruby data
  # structure object and return it.
  #
  # The _opts_ argument is passed through to generate/parse respectively. See
  # generate and parse for their documentation.
  #
  # source://json//lib/json/common.rb#1139
  def JSON(object, opts = T.unsafe(nil)); end

  # Outputs _objs_ to STDOUT as JSON strings in the shortest form, that is in
  # one line.
  #
  # source://json//lib/json/common.rb#1105
  def j(*objs); end

  # Outputs _objs_ to STDOUT as JSON strings in a pretty format, with
  # indentation and over many lines.
  #
  # source://json//lib/json/common.rb#1120
  def jj(*objs); end
end

class NilClass
  include ::JSON::Ext::Generator::GeneratorMethods::NilClass
end

class Object < ::BasicObject
  include ::Kernel
  include ::PP::ObjectMixin
  include ::JSON::Ext::Generator::GeneratorMethods::Object
end

class String
  include ::Comparable
  include ::JSON::Ext::Generator::GeneratorMethods::String
end

class TrueClass
  include ::JSON::Ext::Generator::GeneratorMethods::TrueClass
end
