# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `language_server-protocol` gem.
# Please instead update this file by running `bin/tapioca gem language_server-protocol`.


# source://language_server-protocol//lib/language_server/protocol/version.rb#1
module LanguageServer; end

# source://language_server-protocol//lib/language_server/protocol/version.rb#2
module LanguageServer::Protocol; end

# source://language_server-protocol//lib/language_server/protocol/constant.rb#3
module LanguageServer::Protocol::Constant; end

# The kind of a code action.
#
# Kinds are a hierarchical list of identifiers separated by `.`,
# e.g. `"refactor.extract.function"`.
#
# The set of kinds is open and client needs to announce the kinds it supports
# to the server during initialization.
# A set of predefined code action kinds.
#
# source://language_server-protocol//lib/language_server/protocol/constant/code_action_kind.rb#14
module LanguageServer::Protocol::Constant::CodeActionKind; end

# Empty kind.
#
# source://language_server-protocol//lib/language_server/protocol/constant/code_action_kind.rb#18
LanguageServer::Protocol::Constant::CodeActionKind::EMPTY = T.let(T.unsafe(nil), String)

# Base kind for quickfix actions: 'quickfix'.
#
# source://language_server-protocol//lib/language_server/protocol/constant/code_action_kind.rb#22
LanguageServer::Protocol::Constant::CodeActionKind::QUICK_FIX = T.let(T.unsafe(nil), String)

# Base kind for refactoring actions: 'refactor'.
#
# source://language_server-protocol//lib/language_server/protocol/constant/code_action_kind.rb#26
LanguageServer::Protocol::Constant::CodeActionKind::REFACTOR = T.let(T.unsafe(nil), String)

# Base kind for refactoring extraction actions: 'refactor.extract'.
#
# Example extract actions:
#
# - Extract method
# - Extract function
# - Extract variable
# - Extract interface from class
# - ...
#
# source://language_server-protocol//lib/language_server/protocol/constant/code_action_kind.rb#38
LanguageServer::Protocol::Constant::CodeActionKind::REFACTOR_EXTRACT = T.let(T.unsafe(nil), String)

# Base kind for refactoring inline actions: 'refactor.inline'.
#
# Example inline actions:
#
# - Inline function
# - Inline variable
# - Inline constant
# - ...
#
# source://language_server-protocol//lib/language_server/protocol/constant/code_action_kind.rb#49
LanguageServer::Protocol::Constant::CodeActionKind::REFACTOR_INLINE = T.let(T.unsafe(nil), String)

# Base kind for refactoring rewrite actions: 'refactor.rewrite'.
#
# Example rewrite actions:
#
# - Convert JavaScript function to class
# - Add or remove parameter
# - Encapsulate field
# - Make method static
# - Move method to base class
# - ...
#
# source://language_server-protocol//lib/language_server/protocol/constant/code_action_kind.rb#62
LanguageServer::Protocol::Constant::CodeActionKind::REFACTOR_REWRITE = T.let(T.unsafe(nil), String)

# Base kind for source actions: `source`.
#
# Source code actions apply to the entire file.
#
# source://language_server-protocol//lib/language_server/protocol/constant/code_action_kind.rb#68
LanguageServer::Protocol::Constant::CodeActionKind::SOURCE = T.let(T.unsafe(nil), String)

# Base kind for a 'fix all' source action: `source.fixAll`.
#
# 'Fix all' actions automatically fix errors that have a clear fix that
# do not require user input. They should not suppress errors or perform
# unsafe fixes such as generating new types or classes.
#
# source://language_server-protocol//lib/language_server/protocol/constant/code_action_kind.rb#81
LanguageServer::Protocol::Constant::CodeActionKind::SOURCE_FIX_ALL = T.let(T.unsafe(nil), String)

# Base kind for an organize imports source action:
# `source.organizeImports`.
#
# source://language_server-protocol//lib/language_server/protocol/constant/code_action_kind.rb#73
LanguageServer::Protocol::Constant::CodeActionKind::SOURCE_ORGANIZE_IMPORTS = T.let(T.unsafe(nil), String)

# The reason why code actions were requested.
#
# source://language_server-protocol//lib/language_server/protocol/constant/code_action_trigger_kind.rb#7
module LanguageServer::Protocol::Constant::CodeActionTriggerKind; end

# Code actions were requested automatically.
#
# This typically happens when current selection in a file changes, but can
# also be triggered when file content changes.
#
# source://language_server-protocol//lib/language_server/protocol/constant/code_action_trigger_kind.rb#18
LanguageServer::Protocol::Constant::CodeActionTriggerKind::AUTOMATIC = T.let(T.unsafe(nil), Integer)

# Code actions were explicitly requested by the user or by an extension.
#
# source://language_server-protocol//lib/language_server/protocol/constant/code_action_trigger_kind.rb#11
LanguageServer::Protocol::Constant::CodeActionTriggerKind::INVOKED = T.let(T.unsafe(nil), Integer)

# The kind of a completion entry.
#
# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#7
module LanguageServer::Protocol::Constant::CompletionItemKind; end

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#14
LanguageServer::Protocol::Constant::CompletionItemKind::CLASS = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#23
LanguageServer::Protocol::Constant::CompletionItemKind::COLOR = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#28
LanguageServer::Protocol::Constant::CompletionItemKind::CONSTANT = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#11
LanguageServer::Protocol::Constant::CompletionItemKind::CONSTRUCTOR = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#20
LanguageServer::Protocol::Constant::CompletionItemKind::ENUM = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#27
LanguageServer::Protocol::Constant::CompletionItemKind::ENUM_MEMBER = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#30
LanguageServer::Protocol::Constant::CompletionItemKind::EVENT = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#12
LanguageServer::Protocol::Constant::CompletionItemKind::FIELD = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#24
LanguageServer::Protocol::Constant::CompletionItemKind::FILE = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#26
LanguageServer::Protocol::Constant::CompletionItemKind::FOLDER = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#10
LanguageServer::Protocol::Constant::CompletionItemKind::FUNCTION = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#15
LanguageServer::Protocol::Constant::CompletionItemKind::INTERFACE = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#21
LanguageServer::Protocol::Constant::CompletionItemKind::KEYWORD = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#9
LanguageServer::Protocol::Constant::CompletionItemKind::METHOD = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#16
LanguageServer::Protocol::Constant::CompletionItemKind::MODULE = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#31
LanguageServer::Protocol::Constant::CompletionItemKind::OPERATOR = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#17
LanguageServer::Protocol::Constant::CompletionItemKind::PROPERTY = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#25
LanguageServer::Protocol::Constant::CompletionItemKind::REFERENCE = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#22
LanguageServer::Protocol::Constant::CompletionItemKind::SNIPPET = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#29
LanguageServer::Protocol::Constant::CompletionItemKind::STRUCT = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#8
LanguageServer::Protocol::Constant::CompletionItemKind::TEXT = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#32
LanguageServer::Protocol::Constant::CompletionItemKind::TYPE_PARAMETER = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#18
LanguageServer::Protocol::Constant::CompletionItemKind::UNIT = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#19
LanguageServer::Protocol::Constant::CompletionItemKind::VALUE = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_kind.rb#13
LanguageServer::Protocol::Constant::CompletionItemKind::VARIABLE = T.let(T.unsafe(nil), Integer)

# Completion item tags are extra annotations that tweak the rendering of a
# completion item.
#
# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_tag.rb#8
module LanguageServer::Protocol::Constant::CompletionItemTag; end

# Render a completion as obsolete, usually using a strike-out.
#
# source://language_server-protocol//lib/language_server/protocol/constant/completion_item_tag.rb#12
LanguageServer::Protocol::Constant::CompletionItemTag::DEPRECATED = T.let(T.unsafe(nil), Integer)

# How a completion was triggered
#
# source://language_server-protocol//lib/language_server/protocol/constant/completion_trigger_kind.rb#7
module LanguageServer::Protocol::Constant::CompletionTriggerKind; end

# Completion was triggered by typing an identifier (24x7 code
# complete), manual invocation (e.g Ctrl+Space) or via API.
#
# source://language_server-protocol//lib/language_server/protocol/constant/completion_trigger_kind.rb#12
LanguageServer::Protocol::Constant::CompletionTriggerKind::INVOKED = T.let(T.unsafe(nil), Integer)

# Completion was triggered by a trigger character specified by
# the `triggerCharacters` properties of the
# `CompletionRegistrationOptions`.
#
# source://language_server-protocol//lib/language_server/protocol/constant/completion_trigger_kind.rb#18
LanguageServer::Protocol::Constant::CompletionTriggerKind::TRIGGER_CHARACTER = T.let(T.unsafe(nil), Integer)

# Completion was re-triggered as the current completion list is incomplete.
#
# source://language_server-protocol//lib/language_server/protocol/constant/completion_trigger_kind.rb#22
LanguageServer::Protocol::Constant::CompletionTriggerKind::TRIGGER_FOR_INCOMPLETE_COMPLETIONS = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/diagnostic_severity.rb#4
module LanguageServer::Protocol::Constant::DiagnosticSeverity; end

# Reports an error.
#
# source://language_server-protocol//lib/language_server/protocol/constant/diagnostic_severity.rb#8
LanguageServer::Protocol::Constant::DiagnosticSeverity::ERROR = T.let(T.unsafe(nil), Integer)

# Reports a hint.
#
# source://language_server-protocol//lib/language_server/protocol/constant/diagnostic_severity.rb#20
LanguageServer::Protocol::Constant::DiagnosticSeverity::HINT = T.let(T.unsafe(nil), Integer)

# Reports an information.
#
# source://language_server-protocol//lib/language_server/protocol/constant/diagnostic_severity.rb#16
LanguageServer::Protocol::Constant::DiagnosticSeverity::INFORMATION = T.let(T.unsafe(nil), Integer)

# Reports a warning.
#
# source://language_server-protocol//lib/language_server/protocol/constant/diagnostic_severity.rb#12
LanguageServer::Protocol::Constant::DiagnosticSeverity::WARNING = T.let(T.unsafe(nil), Integer)

# The diagnostic tags.
#
# source://language_server-protocol//lib/language_server/protocol/constant/diagnostic_tag.rb#7
module LanguageServer::Protocol::Constant::DiagnosticTag; end

# Deprecated or obsolete code.
#
# Clients are allowed to rendered diagnostics with this tag strike through.
#
# source://language_server-protocol//lib/language_server/protocol/constant/diagnostic_tag.rb#20
LanguageServer::Protocol::Constant::DiagnosticTag::DEPRECATED = T.let(T.unsafe(nil), Integer)

# Unused or unnecessary code.
#
# Clients are allowed to render diagnostics with this tag faded out
# instead of having an error squiggle.
#
# source://language_server-protocol//lib/language_server/protocol/constant/diagnostic_tag.rb#14
LanguageServer::Protocol::Constant::DiagnosticTag::UNNECESSARY = T.let(T.unsafe(nil), Integer)

# The document diagnostic report kinds.
#
# source://language_server-protocol//lib/language_server/protocol/constant/document_diagnostic_report_kind.rb#7
module LanguageServer::Protocol::Constant::DocumentDiagnosticReportKind; end

# A diagnostic report with a full
# set of problems.
#
# source://language_server-protocol//lib/language_server/protocol/constant/document_diagnostic_report_kind.rb#12
LanguageServer::Protocol::Constant::DocumentDiagnosticReportKind::FULL = T.let(T.unsafe(nil), String)

# A report indicating that the last
# returned report is still accurate.
#
# source://language_server-protocol//lib/language_server/protocol/constant/document_diagnostic_report_kind.rb#17
LanguageServer::Protocol::Constant::DocumentDiagnosticReportKind::UNCHANGED = T.let(T.unsafe(nil), String)

# A document highlight kind.
#
# source://language_server-protocol//lib/language_server/protocol/constant/document_highlight_kind.rb#7
module LanguageServer::Protocol::Constant::DocumentHighlightKind; end

# Read-access of a symbol, like reading a variable.
#
# source://language_server-protocol//lib/language_server/protocol/constant/document_highlight_kind.rb#15
LanguageServer::Protocol::Constant::DocumentHighlightKind::READ = T.let(T.unsafe(nil), Integer)

# A textual occurrence.
#
# source://language_server-protocol//lib/language_server/protocol/constant/document_highlight_kind.rb#11
LanguageServer::Protocol::Constant::DocumentHighlightKind::TEXT = T.let(T.unsafe(nil), Integer)

# Write-access of a symbol, like writing to a variable.
#
# source://language_server-protocol//lib/language_server/protocol/constant/document_highlight_kind.rb#19
LanguageServer::Protocol::Constant::DocumentHighlightKind::WRITE = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#4
module LanguageServer::Protocol::Constant::ErrorCodes; end

# The server detected that the content of a document got
# modified outside normal conditions. A server should
# NOT send this error code if it detects a content change
# in it unprocessed messages. The result even computed
# on an older state might still be useful for the client.
#
# If a client decides that a result is not of any use anymore
# the client should cancel the request.
#
# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#59
LanguageServer::Protocol::Constant::ErrorCodes::CONTENT_MODIFIED = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#9
LanguageServer::Protocol::Constant::ErrorCodes::INTERNAL_ERROR = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#8
LanguageServer::Protocol::Constant::ErrorCodes::INVALID_PARAMS = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#6
LanguageServer::Protocol::Constant::ErrorCodes::INVALID_REQUEST = T.let(T.unsafe(nil), Integer)

# This is the end range of JSON-RPC reserved error codes.
# It doesn't denote a real error code.
#
# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#29
LanguageServer::Protocol::Constant::ErrorCodes::JSONRPC_RESERVED_ERROR_RANGE_END = T.let(T.unsafe(nil), Integer)

# This is the start range of JSON-RPC reserved error codes.
# It doesn't denote a real error code. No LSP error codes should
# be defined between the start and end range. For backwards
# compatibility the `ServerNotInitialized` and the `UnknownErrorCode`
# are left in the range.
#
# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#17
LanguageServer::Protocol::Constant::ErrorCodes::JSONRPC_RESERVED_ERROR_RANGE_START = T.let(T.unsafe(nil), Integer)

# This is the end range of LSP reserved error codes.
# It doesn't denote a real error code.
#
# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#69
LanguageServer::Protocol::Constant::ErrorCodes::LSP_RESERVED_ERROR_RANGE_END = T.let(T.unsafe(nil), Integer)

# This is the start range of LSP reserved error codes.
# It doesn't denote a real error code.
#
# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#35
LanguageServer::Protocol::Constant::ErrorCodes::LSP_RESERVED_ERROR_RANGE_START = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#7
LanguageServer::Protocol::Constant::ErrorCodes::METHOD_NOT_FOUND = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#5
LanguageServer::Protocol::Constant::ErrorCodes::PARSE_ERROR = T.let(T.unsafe(nil), Integer)

# The client has canceled a request and a server as detected
# the cancel.
#
# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#64
LanguageServer::Protocol::Constant::ErrorCodes::REQUEST_CANCELLED = T.let(T.unsafe(nil), Integer)

# A request failed but it was syntactically correct, e.g the
# method name was known and the parameters were valid. The error
# message should contain human readable information about why
# the request failed.
#
# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#42
LanguageServer::Protocol::Constant::ErrorCodes::REQUEST_FAILED = T.let(T.unsafe(nil), Integer)

# The server cancelled the request. This error code should
# only be used for requests that explicitly support being
# server cancellable.
#
# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#48
LanguageServer::Protocol::Constant::ErrorCodes::SERVER_CANCELLED = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#30
LanguageServer::Protocol::Constant::ErrorCodes::SERVER_ERROR_END = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#18
LanguageServer::Protocol::Constant::ErrorCodes::SERVER_ERROR_START = T.let(T.unsafe(nil), Integer)

# Error code indicating that a server received a notification or
# request before the server has received the `initialize` request.
#
# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#23
LanguageServer::Protocol::Constant::ErrorCodes::SERVER_NOT_INITIALIZED = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/error_codes.rb#24
LanguageServer::Protocol::Constant::ErrorCodes::UNKNOWN_ERROR_CODE = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/failure_handling_kind.rb#4
module LanguageServer::Protocol::Constant::FailureHandlingKind; end

# Applying the workspace change is simply aborted if one of the changes
# provided fails. All operations executed before the failing operation
# stay executed.
#
# source://language_server-protocol//lib/language_server/protocol/constant/failure_handling_kind.rb#10
LanguageServer::Protocol::Constant::FailureHandlingKind::ABORT = T.let(T.unsafe(nil), String)

# If the workspace edit contains only textual file changes they are
# executed transactional. If resource changes (create, rename or delete
# file) are part of the change the failure handling strategy is abort.
#
# source://language_server-protocol//lib/language_server/protocol/constant/failure_handling_kind.rb#21
LanguageServer::Protocol::Constant::FailureHandlingKind::TEXT_ONLY_TRANSACTIONAL = T.let(T.unsafe(nil), String)

# All operations are executed transactional. That means they either all
# succeed or no changes at all are applied to the workspace.
#
# source://language_server-protocol//lib/language_server/protocol/constant/failure_handling_kind.rb#15
LanguageServer::Protocol::Constant::FailureHandlingKind::TRANSACTIONAL = T.let(T.unsafe(nil), String)

# The client tries to undo the operations already executed. But there is no
# guarantee that this is succeeding.
#
# source://language_server-protocol//lib/language_server/protocol/constant/failure_handling_kind.rb#26
LanguageServer::Protocol::Constant::FailureHandlingKind::UNDO = T.let(T.unsafe(nil), String)

# The file event type.
#
# source://language_server-protocol//lib/language_server/protocol/constant/file_change_type.rb#7
module LanguageServer::Protocol::Constant::FileChangeType; end

# The file got changed.
#
# source://language_server-protocol//lib/language_server/protocol/constant/file_change_type.rb#15
LanguageServer::Protocol::Constant::FileChangeType::CHANGED = T.let(T.unsafe(nil), Integer)

# The file got created.
#
# source://language_server-protocol//lib/language_server/protocol/constant/file_change_type.rb#11
LanguageServer::Protocol::Constant::FileChangeType::CREATED = T.let(T.unsafe(nil), Integer)

# The file got deleted.
#
# source://language_server-protocol//lib/language_server/protocol/constant/file_change_type.rb#19
LanguageServer::Protocol::Constant::FileChangeType::DELETED = T.let(T.unsafe(nil), Integer)

# A pattern kind describing if a glob pattern matches a file a folder or
# both.
#
# source://language_server-protocol//lib/language_server/protocol/constant/file_operation_pattern_kind.rb#8
module LanguageServer::Protocol::Constant::FileOperationPatternKind; end

# The pattern matches a file only.
#
# source://language_server-protocol//lib/language_server/protocol/constant/file_operation_pattern_kind.rb#12
LanguageServer::Protocol::Constant::FileOperationPatternKind::FILE = T.let(T.unsafe(nil), String)

# The pattern matches a folder only.
#
# source://language_server-protocol//lib/language_server/protocol/constant/file_operation_pattern_kind.rb#16
LanguageServer::Protocol::Constant::FileOperationPatternKind::FOLDER = T.let(T.unsafe(nil), String)

# A set of predefined range kinds.
# The type is a string since the value set is extensible
#
# source://language_server-protocol//lib/language_server/protocol/constant/folding_range_kind.rb#8
module LanguageServer::Protocol::Constant::FoldingRangeKind; end

# Folding range for a comment
#
# source://language_server-protocol//lib/language_server/protocol/constant/folding_range_kind.rb#12
LanguageServer::Protocol::Constant::FoldingRangeKind::COMMENT = T.let(T.unsafe(nil), String)

# Folding range for imports or includes
#
# source://language_server-protocol//lib/language_server/protocol/constant/folding_range_kind.rb#16
LanguageServer::Protocol::Constant::FoldingRangeKind::IMPORTS = T.let(T.unsafe(nil), String)

# Folding range for a region (e.g. `#region`)
#
# source://language_server-protocol//lib/language_server/protocol/constant/folding_range_kind.rb#20
LanguageServer::Protocol::Constant::FoldingRangeKind::REGION = T.let(T.unsafe(nil), String)

# Known error codes for an `InitializeErrorCodes`;
#
# source://language_server-protocol//lib/language_server/protocol/constant/initialize_error_codes.rb#7
module LanguageServer::Protocol::Constant::InitializeErrorCodes; end

# If the protocol version provided by the client can't be handled by
# the server.
#
# source://language_server-protocol//lib/language_server/protocol/constant/initialize_error_codes.rb#12
LanguageServer::Protocol::Constant::InitializeErrorCodes::UNKNOWN_PROTOCOL_VERSION = T.let(T.unsafe(nil), Integer)

# Inlay hint kinds.
#
# source://language_server-protocol//lib/language_server/protocol/constant/inlay_hint_kind.rb#7
module LanguageServer::Protocol::Constant::InlayHintKind; end

# An inlay hint that is for a parameter.
#
# source://language_server-protocol//lib/language_server/protocol/constant/inlay_hint_kind.rb#15
LanguageServer::Protocol::Constant::InlayHintKind::PARAMETER = T.let(T.unsafe(nil), Integer)

# An inlay hint that for a type annotation.
#
# source://language_server-protocol//lib/language_server/protocol/constant/inlay_hint_kind.rb#11
LanguageServer::Protocol::Constant::InlayHintKind::TYPE = T.let(T.unsafe(nil), Integer)

# Defines whether the insert text in a completion item should be interpreted as
# plain text or a snippet.
#
# source://language_server-protocol//lib/language_server/protocol/constant/insert_text_format.rb#8
module LanguageServer::Protocol::Constant::InsertTextFormat; end

# The primary text to be inserted is treated as a plain string.
#
# source://language_server-protocol//lib/language_server/protocol/constant/insert_text_format.rb#12
LanguageServer::Protocol::Constant::InsertTextFormat::PLAIN_TEXT = T.let(T.unsafe(nil), Integer)

# The primary text to be inserted is treated as a snippet.
#
# A snippet can define tab stops and placeholders with `$1`, `$2`
# and `${3:foo}`. `$0` defines the final tab stop, it defaults to
# the end of the snippet. Placeholders with equal identifiers are linked,
# that is typing in one will update others too.
#
# source://language_server-protocol//lib/language_server/protocol/constant/insert_text_format.rb#21
LanguageServer::Protocol::Constant::InsertTextFormat::SNIPPET = T.let(T.unsafe(nil), Integer)

# How whitespace and indentation is handled during completion
# item insertion.
#
# source://language_server-protocol//lib/language_server/protocol/constant/insert_text_mode.rb#8
module LanguageServer::Protocol::Constant::InsertTextMode; end

# The editor adjusts leading whitespace of new lines so that
# they match the indentation up to the cursor of the line for
# which the item is accepted.
#
# Consider a line like this: <2tabs><cursor><3tabs>foo. Accepting a
# multi line completion item is indented using 2 tabs and all
# following lines inserted will be indented using 2 tabs as well.
#
# source://language_server-protocol//lib/language_server/protocol/constant/insert_text_mode.rb#26
LanguageServer::Protocol::Constant::InsertTextMode::ADJUST_INDENTATION = T.let(T.unsafe(nil), Integer)

# The insertion or replace strings is taken as it is. If the
# value is multi line the lines below the cursor will be
# inserted using the indentation defined in the string value.
# The client will not apply any kind of adjustments to the
# string.
#
# source://language_server-protocol//lib/language_server/protocol/constant/insert_text_mode.rb#16
LanguageServer::Protocol::Constant::InsertTextMode::AS_IS = T.let(T.unsafe(nil), Integer)

# Describes the content type that a client supports in various
# result literals like `Hover`, `ParameterInfo` or `CompletionItem`.
#
# Please note that `MarkupKinds` must not start with a `$`. This kinds
# are reserved for internal usage.
#
# source://language_server-protocol//lib/language_server/protocol/constant/markup_kind.rb#11
module LanguageServer::Protocol::Constant::MarkupKind; end

# Markdown is supported as a content format
#
# source://language_server-protocol//lib/language_server/protocol/constant/markup_kind.rb#19
LanguageServer::Protocol::Constant::MarkupKind::MARKDOWN = T.let(T.unsafe(nil), String)

# Plain text is supported as a content format
#
# source://language_server-protocol//lib/language_server/protocol/constant/markup_kind.rb#15
LanguageServer::Protocol::Constant::MarkupKind::PLAIN_TEXT = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/message_type.rb#4
module LanguageServer::Protocol::Constant::MessageType; end

# An error message.
#
# source://language_server-protocol//lib/language_server/protocol/constant/message_type.rb#8
LanguageServer::Protocol::Constant::MessageType::ERROR = T.let(T.unsafe(nil), Integer)

# An information message.
#
# source://language_server-protocol//lib/language_server/protocol/constant/message_type.rb#16
LanguageServer::Protocol::Constant::MessageType::INFO = T.let(T.unsafe(nil), Integer)

# A log message.
#
# source://language_server-protocol//lib/language_server/protocol/constant/message_type.rb#20
LanguageServer::Protocol::Constant::MessageType::LOG = T.let(T.unsafe(nil), Integer)

# A warning message.
#
# source://language_server-protocol//lib/language_server/protocol/constant/message_type.rb#12
LanguageServer::Protocol::Constant::MessageType::WARNING = T.let(T.unsafe(nil), Integer)

# The moniker kind.
#
# source://language_server-protocol//lib/language_server/protocol/constant/moniker_kind.rb#7
module LanguageServer::Protocol::Constant::MonikerKind; end

# The moniker represents a symbol that is exported from a project
#
# source://language_server-protocol//lib/language_server/protocol/constant/moniker_kind.rb#15
LanguageServer::Protocol::Constant::MonikerKind::EXPORT = T.let(T.unsafe(nil), String)

# The moniker represent a symbol that is imported into a project
#
# source://language_server-protocol//lib/language_server/protocol/constant/moniker_kind.rb#11
LanguageServer::Protocol::Constant::MonikerKind::IMPORT = T.let(T.unsafe(nil), String)

# The moniker represents a symbol that is local to a project (e.g. a local
# variable of a function, a class not visible outside the project, ...)
#
# source://language_server-protocol//lib/language_server/protocol/constant/moniker_kind.rb#20
LanguageServer::Protocol::Constant::MonikerKind::LOCAL = T.let(T.unsafe(nil), String)

# A notebook cell kind.
#
# source://language_server-protocol//lib/language_server/protocol/constant/notebook_cell_kind.rb#7
module LanguageServer::Protocol::Constant::NotebookCellKind; end

# A code-cell is source code.
#
# source://language_server-protocol//lib/language_server/protocol/constant/notebook_cell_kind.rb#15
LanguageServer::Protocol::Constant::NotebookCellKind::CODE = T.let(T.unsafe(nil), Integer)

# A markup-cell is formatted source that is used for display.
#
# source://language_server-protocol//lib/language_server/protocol/constant/notebook_cell_kind.rb#11
LanguageServer::Protocol::Constant::NotebookCellKind::MARKUP = T.let(T.unsafe(nil), Integer)

# A type indicating how positions are encoded,
# specifically what column offsets mean.
# A set of predefined position encoding kinds.
#
# source://language_server-protocol//lib/language_server/protocol/constant/position_encoding_kind.rb#9
module LanguageServer::Protocol::Constant::PositionEncodingKind; end

# Character offsets count UTF-16 code units.
#
# This is the default and must always be supported
# by servers
#
# source://language_server-protocol//lib/language_server/protocol/constant/position_encoding_kind.rb#20
LanguageServer::Protocol::Constant::PositionEncodingKind::UTF16 = T.let(T.unsafe(nil), String)

# Character offsets count UTF-32 code units.
#
# Implementation note: these are the same as Unicode code points,
# so this `PositionEncodingKind` may also be used for an
# encoding-agnostic representation of character offsets.
#
# source://language_server-protocol//lib/language_server/protocol/constant/position_encoding_kind.rb#28
LanguageServer::Protocol::Constant::PositionEncodingKind::UTF32 = T.let(T.unsafe(nil), String)

# Character offsets count UTF-8 code units (e.g bytes).
#
# source://language_server-protocol//lib/language_server/protocol/constant/position_encoding_kind.rb#13
LanguageServer::Protocol::Constant::PositionEncodingKind::UTF8 = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/prepare_support_default_behavior.rb#4
module LanguageServer::Protocol::Constant::PrepareSupportDefaultBehavior; end

# The client's default behavior is to select the identifier
# according to the language's syntax rule.
#
# source://language_server-protocol//lib/language_server/protocol/constant/prepare_support_default_behavior.rb#9
LanguageServer::Protocol::Constant::PrepareSupportDefaultBehavior::IDENTIFIER = T.let(T.unsafe(nil), Integer)

# The kind of resource operations supported by the client.
#
# source://language_server-protocol//lib/language_server/protocol/constant/resource_operation_kind.rb#7
module LanguageServer::Protocol::Constant::ResourceOperationKind; end

# Supports creating new files and folders.
#
# source://language_server-protocol//lib/language_server/protocol/constant/resource_operation_kind.rb#11
LanguageServer::Protocol::Constant::ResourceOperationKind::CREATE = T.let(T.unsafe(nil), String)

# Supports deleting existing files and folders.
#
# source://language_server-protocol//lib/language_server/protocol/constant/resource_operation_kind.rb#19
LanguageServer::Protocol::Constant::ResourceOperationKind::DELETE = T.let(T.unsafe(nil), String)

# Supports renaming existing files and folders.
#
# source://language_server-protocol//lib/language_server/protocol/constant/resource_operation_kind.rb#15
LanguageServer::Protocol::Constant::ResourceOperationKind::RENAME = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_modifiers.rb#4
module LanguageServer::Protocol::Constant::SemanticTokenModifiers; end

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_modifiers.rb#10
LanguageServer::Protocol::Constant::SemanticTokenModifiers::ABSTRACT = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_modifiers.rb#11
LanguageServer::Protocol::Constant::SemanticTokenModifiers::ASYNC = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_modifiers.rb#5
LanguageServer::Protocol::Constant::SemanticTokenModifiers::DECLARATION = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_modifiers.rb#14
LanguageServer::Protocol::Constant::SemanticTokenModifiers::DEFAULT_LIBRARY = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_modifiers.rb#6
LanguageServer::Protocol::Constant::SemanticTokenModifiers::DEFINITION = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_modifiers.rb#9
LanguageServer::Protocol::Constant::SemanticTokenModifiers::DEPRECATED = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_modifiers.rb#13
LanguageServer::Protocol::Constant::SemanticTokenModifiers::DOCUMENTATION = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_modifiers.rb#12
LanguageServer::Protocol::Constant::SemanticTokenModifiers::MODIFICATION = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_modifiers.rb#7
LanguageServer::Protocol::Constant::SemanticTokenModifiers::READONLY = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_modifiers.rb#8
LanguageServer::Protocol::Constant::SemanticTokenModifiers::STATIC = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#4
module LanguageServer::Protocol::Constant::SemanticTokenTypes; end

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#11
LanguageServer::Protocol::Constant::SemanticTokenTypes::CLASS = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#26
LanguageServer::Protocol::Constant::SemanticTokenTypes::COMMENT = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#31
LanguageServer::Protocol::Constant::SemanticTokenTypes::DECORATOR = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#12
LanguageServer::Protocol::Constant::SemanticTokenTypes::ENUM = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#19
LanguageServer::Protocol::Constant::SemanticTokenTypes::ENUM_MEMBER = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#20
LanguageServer::Protocol::Constant::SemanticTokenTypes::EVENT = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#21
LanguageServer::Protocol::Constant::SemanticTokenTypes::FUNCTION = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#13
LanguageServer::Protocol::Constant::SemanticTokenTypes::INTERFACE = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#24
LanguageServer::Protocol::Constant::SemanticTokenTypes::KEYWORD = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#23
LanguageServer::Protocol::Constant::SemanticTokenTypes::MACRO = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#22
LanguageServer::Protocol::Constant::SemanticTokenTypes::METHOD = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#25
LanguageServer::Protocol::Constant::SemanticTokenTypes::MODIFIER = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#5
LanguageServer::Protocol::Constant::SemanticTokenTypes::NAMESPACE = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#28
LanguageServer::Protocol::Constant::SemanticTokenTypes::NUMBER = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#30
LanguageServer::Protocol::Constant::SemanticTokenTypes::OPERATOR = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#16
LanguageServer::Protocol::Constant::SemanticTokenTypes::PARAMETER = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#18
LanguageServer::Protocol::Constant::SemanticTokenTypes::PROPERTY = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#29
LanguageServer::Protocol::Constant::SemanticTokenTypes::REGEXP = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#27
LanguageServer::Protocol::Constant::SemanticTokenTypes::STRING = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#14
LanguageServer::Protocol::Constant::SemanticTokenTypes::STRUCT = T.let(T.unsafe(nil), String)

# Represents a generic type. Acts as a fallback for types which
# can't be mapped to a specific type like class or enum.
#
# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#10
LanguageServer::Protocol::Constant::SemanticTokenTypes::TYPE = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#15
LanguageServer::Protocol::Constant::SemanticTokenTypes::TYPE_PARAMETER = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/semantic_token_types.rb#17
LanguageServer::Protocol::Constant::SemanticTokenTypes::VARIABLE = T.let(T.unsafe(nil), String)

# How a signature help was triggered.
#
# source://language_server-protocol//lib/language_server/protocol/constant/signature_help_trigger_kind.rb#7
module LanguageServer::Protocol::Constant::SignatureHelpTriggerKind; end

# Signature help was triggered by the cursor moving or by the document
# content changing.
#
# source://language_server-protocol//lib/language_server/protocol/constant/signature_help_trigger_kind.rb#20
LanguageServer::Protocol::Constant::SignatureHelpTriggerKind::CONTENT_CHANGE = T.let(T.unsafe(nil), Integer)

# Signature help was invoked manually by the user or by a command.
#
# source://language_server-protocol//lib/language_server/protocol/constant/signature_help_trigger_kind.rb#11
LanguageServer::Protocol::Constant::SignatureHelpTriggerKind::INVOKED = T.let(T.unsafe(nil), Integer)

# Signature help was triggered by a trigger character.
#
# source://language_server-protocol//lib/language_server/protocol/constant/signature_help_trigger_kind.rb#15
LanguageServer::Protocol::Constant::SignatureHelpTriggerKind::TRIGGER_CHARACTER = T.let(T.unsafe(nil), Integer)

# A symbol kind.
#
# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#7
module LanguageServer::Protocol::Constant::SymbolKind; end

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#25
LanguageServer::Protocol::Constant::SymbolKind::ARRAY = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#24
LanguageServer::Protocol::Constant::SymbolKind::BOOLEAN = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#12
LanguageServer::Protocol::Constant::SymbolKind::CLASS = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#21
LanguageServer::Protocol::Constant::SymbolKind::CONSTANT = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#16
LanguageServer::Protocol::Constant::SymbolKind::CONSTRUCTOR = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#17
LanguageServer::Protocol::Constant::SymbolKind::ENUM = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#29
LanguageServer::Protocol::Constant::SymbolKind::ENUM_MEMBER = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#31
LanguageServer::Protocol::Constant::SymbolKind::EVENT = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#15
LanguageServer::Protocol::Constant::SymbolKind::FIELD = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#8
LanguageServer::Protocol::Constant::SymbolKind::FILE = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#19
LanguageServer::Protocol::Constant::SymbolKind::FUNCTION = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#18
LanguageServer::Protocol::Constant::SymbolKind::INTERFACE = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#27
LanguageServer::Protocol::Constant::SymbolKind::KEY = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#13
LanguageServer::Protocol::Constant::SymbolKind::METHOD = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#9
LanguageServer::Protocol::Constant::SymbolKind::MODULE = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#10
LanguageServer::Protocol::Constant::SymbolKind::NAMESPACE = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#28
LanguageServer::Protocol::Constant::SymbolKind::NULL = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#23
LanguageServer::Protocol::Constant::SymbolKind::NUMBER = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#26
LanguageServer::Protocol::Constant::SymbolKind::OBJECT = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#32
LanguageServer::Protocol::Constant::SymbolKind::OPERATOR = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#11
LanguageServer::Protocol::Constant::SymbolKind::PACKAGE = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#14
LanguageServer::Protocol::Constant::SymbolKind::PROPERTY = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#22
LanguageServer::Protocol::Constant::SymbolKind::STRING = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#30
LanguageServer::Protocol::Constant::SymbolKind::STRUCT = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#33
LanguageServer::Protocol::Constant::SymbolKind::TYPE_PARAMETER = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/symbol_kind.rb#20
LanguageServer::Protocol::Constant::SymbolKind::VARIABLE = T.let(T.unsafe(nil), Integer)

# Symbol tags are extra annotations that tweak the rendering of a symbol.
#
# source://language_server-protocol//lib/language_server/protocol/constant/symbol_tag.rb#7
module LanguageServer::Protocol::Constant::SymbolTag; end

# Render a symbol as obsolete, usually using a strike-out.
#
# source://language_server-protocol//lib/language_server/protocol/constant/symbol_tag.rb#11
LanguageServer::Protocol::Constant::SymbolTag::DEPRECATED = T.let(T.unsafe(nil), Integer)

# Represents reasons why a text document is saved.
#
# source://language_server-protocol//lib/language_server/protocol/constant/text_document_save_reason.rb#7
module LanguageServer::Protocol::Constant::TextDocumentSaveReason; end

# Automatic after a delay.
#
# source://language_server-protocol//lib/language_server/protocol/constant/text_document_save_reason.rb#16
LanguageServer::Protocol::Constant::TextDocumentSaveReason::AFTER_DELAY = T.let(T.unsafe(nil), Integer)

# When the editor lost focus.
#
# source://language_server-protocol//lib/language_server/protocol/constant/text_document_save_reason.rb#20
LanguageServer::Protocol::Constant::TextDocumentSaveReason::FOCUS_OUT = T.let(T.unsafe(nil), Integer)

# Manually triggered, e.g. by the user pressing save, by starting
# debugging, or by an API call.
#
# source://language_server-protocol//lib/language_server/protocol/constant/text_document_save_reason.rb#12
LanguageServer::Protocol::Constant::TextDocumentSaveReason::MANUAL = T.let(T.unsafe(nil), Integer)

# Defines how the host (editor) should sync document changes to the language
# server.
#
# source://language_server-protocol//lib/language_server/protocol/constant/text_document_sync_kind.rb#8
module LanguageServer::Protocol::Constant::TextDocumentSyncKind; end

# Documents are synced by always sending the full content
# of the document.
#
# source://language_server-protocol//lib/language_server/protocol/constant/text_document_sync_kind.rb#17
LanguageServer::Protocol::Constant::TextDocumentSyncKind::FULL = T.let(T.unsafe(nil), Integer)

# Documents are synced by sending the full content on open.
# After that only incremental updates to the document are
# sent.
#
# source://language_server-protocol//lib/language_server/protocol/constant/text_document_sync_kind.rb#23
LanguageServer::Protocol::Constant::TextDocumentSyncKind::INCREMENTAL = T.let(T.unsafe(nil), Integer)

# Documents should not be synced at all.
#
# source://language_server-protocol//lib/language_server/protocol/constant/text_document_sync_kind.rb#12
LanguageServer::Protocol::Constant::TextDocumentSyncKind::NONE = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/constant/token_format.rb#4
module LanguageServer::Protocol::Constant::TokenFormat; end

# source://language_server-protocol//lib/language_server/protocol/constant/token_format.rb#5
LanguageServer::Protocol::Constant::TokenFormat::RELATIVE = T.let(T.unsafe(nil), String)

# Moniker uniqueness level to define scope of the moniker.
#
# source://language_server-protocol//lib/language_server/protocol/constant/uniqueness_level.rb#7
module LanguageServer::Protocol::Constant::UniquenessLevel; end

# The moniker is only unique inside a document
#
# source://language_server-protocol//lib/language_server/protocol/constant/uniqueness_level.rb#11
LanguageServer::Protocol::Constant::UniquenessLevel::DOCUMENT = T.let(T.unsafe(nil), String)

# The moniker is globally unique
#
# source://language_server-protocol//lib/language_server/protocol/constant/uniqueness_level.rb#27
LanguageServer::Protocol::Constant::UniquenessLevel::GLOBAL = T.let(T.unsafe(nil), String)

# The moniker is unique inside the group to which a project belongs
#
# source://language_server-protocol//lib/language_server/protocol/constant/uniqueness_level.rb#19
LanguageServer::Protocol::Constant::UniquenessLevel::GROUP = T.let(T.unsafe(nil), String)

# The moniker is unique inside a project for which a dump got created
#
# source://language_server-protocol//lib/language_server/protocol/constant/uniqueness_level.rb#15
LanguageServer::Protocol::Constant::UniquenessLevel::PROJECT = T.let(T.unsafe(nil), String)

# The moniker is unique inside the moniker scheme.
#
# source://language_server-protocol//lib/language_server/protocol/constant/uniqueness_level.rb#23
LanguageServer::Protocol::Constant::UniquenessLevel::SCHEME = T.let(T.unsafe(nil), String)

# source://language_server-protocol//lib/language_server/protocol/constant/watch_kind.rb#4
module LanguageServer::Protocol::Constant::WatchKind; end

# Interested in change events
#
# source://language_server-protocol//lib/language_server/protocol/constant/watch_kind.rb#12
LanguageServer::Protocol::Constant::WatchKind::CHANGE = T.let(T.unsafe(nil), Integer)

# Interested in create events.
#
# source://language_server-protocol//lib/language_server/protocol/constant/watch_kind.rb#8
LanguageServer::Protocol::Constant::WatchKind::CREATE = T.let(T.unsafe(nil), Integer)

# Interested in delete events
#
# source://language_server-protocol//lib/language_server/protocol/constant/watch_kind.rb#16
LanguageServer::Protocol::Constant::WatchKind::DELETE = T.let(T.unsafe(nil), Integer)

# source://language_server-protocol//lib/language_server/protocol/interface.rb#3
module LanguageServer::Protocol::Interface; end

# A special text edit with an additional change annotation.
#
# source://language_server-protocol//lib/language_server/protocol/interface/annotated_text_edit.rb#7
class LanguageServer::Protocol::Interface::AnnotatedTextEdit
  # @return [AnnotatedTextEdit] a new instance of AnnotatedTextEdit
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/annotated_text_edit.rb#8
  def initialize(range:, new_text:, annotation_id:); end

  # The actual annotation identifier.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/annotated_text_edit.rb#40
  def annotation_id; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/annotated_text_edit.rb#44
  def attributes; end

  # The string to be inserted. For delete operations use an
  # empty string.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/annotated_text_edit.rb#32
  def new_text; end

  # The range of the text document to be manipulated. To insert
  # text into a document create a range where start === end.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/annotated_text_edit.rb#23
  def range; end

  # source://language_server-protocol//lib/language_server/protocol/interface/annotated_text_edit.rb#46
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/annotated_text_edit.rb#50
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/apply_workspace_edit_params.rb#4
class LanguageServer::Protocol::Interface::ApplyWorkspaceEditParams
  # @return [ApplyWorkspaceEditParams] a new instance of ApplyWorkspaceEditParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/apply_workspace_edit_params.rb#5
  def initialize(edit:, label: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/apply_workspace_edit_params.rb#32
  def attributes; end

  # The edits to apply.
  #
  # @return [WorkspaceEdit]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/apply_workspace_edit_params.rb#28
  def edit; end

  # An optional label of the workspace edit. This label is
  # presented in the user interface for example on an undo
  # stack to undo the workspace edit.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/apply_workspace_edit_params.rb#20
  def label; end

  # source://language_server-protocol//lib/language_server/protocol/interface/apply_workspace_edit_params.rb#34
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/apply_workspace_edit_params.rb#38
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/apply_workspace_edit_result.rb#4
class LanguageServer::Protocol::Interface::ApplyWorkspaceEditResult
  # @return [ApplyWorkspaceEditResult] a new instance of ApplyWorkspaceEditResult
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/apply_workspace_edit_result.rb#5
  def initialize(applied:, failure_reason: T.unsafe(nil), failed_change: T.unsafe(nil)); end

  # Indicates whether the edit was applied or not.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/apply_workspace_edit_result.rb#19
  def applied; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/apply_workspace_edit_result.rb#44
  def attributes; end

  # Depending on the client's failure handling strategy `failedChange`
  # might contain the index of the change that failed. This property is
  # only available if the client signals a `failureHandling` strategy
  # in its client capabilities.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/apply_workspace_edit_result.rb#40
  def failed_change; end

  # An optional textual description for why the edit was not applied.
  # This may be used by the server for diagnostic logging or to provide
  # a suitable error for a request that triggered the edit.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/apply_workspace_edit_result.rb#29
  def failure_reason; end

  # source://language_server-protocol//lib/language_server/protocol/interface/apply_workspace_edit_result.rb#46
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/apply_workspace_edit_result.rb#50
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::CallHierarchyClientCapabilities
  # @return [CallHierarchyClientCapabilities] a new instance of CallHierarchyClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_client_capabilities.rb#24
  def attributes; end

  # Whether implementation supports dynamic registration. If this is set to
  # `true` the client supports the new `(TextDocumentRegistrationOptions &
  # StaticRegistrationOptions)` return value for the corresponding server
  # capability as well.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_client_capabilities.rb#20
  def dynamic_registration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_client_capabilities.rb#26
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_client_capabilities.rb#30
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_incoming_call.rb#4
class LanguageServer::Protocol::Interface::CallHierarchyIncomingCall
  # @return [CallHierarchyIncomingCall] a new instance of CallHierarchyIncomingCall
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_incoming_call.rb#5
  def initialize(from:, from_ranges:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_incoming_call.rb#31
  def attributes; end

  # The item that makes the call.
  #
  # @return [CallHierarchyItem]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_incoming_call.rb#18
  def from; end

  # The ranges at which the calls appear. This is relative to the caller
  # denoted by [`this.from`](#CallHierarchyIncomingCall.from).
  #
  # @return [Range[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_incoming_call.rb#27
  def from_ranges; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_incoming_call.rb#33
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_incoming_call.rb#37
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_incoming_calls_params.rb#4
class LanguageServer::Protocol::Interface::CallHierarchyIncomingCallsParams
  # @return [CallHierarchyIncomingCallsParams] a new instance of CallHierarchyIncomingCallsParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_incoming_calls_params.rb#5
  def initialize(item:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_incoming_calls_params.rb#37
  def attributes; end

  # @return [CallHierarchyItem]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_incoming_calls_params.rb#33
  def item; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_incoming_calls_params.rb#28
  def partial_result_token; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_incoming_calls_params.rb#39
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_incoming_calls_params.rb#43
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_incoming_calls_params.rb#19
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_item.rb#4
class LanguageServer::Protocol::Interface::CallHierarchyItem
  # @return [CallHierarchyItem] a new instance of CallHierarchyItem
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_item.rb#5
  def initialize(name:, kind:, uri:, range:, selection_range:, tags: T.unsafe(nil), detail: T.unsafe(nil), data: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_item.rb#88
  def attributes; end

  # A data entry field that is preserved between a call hierarchy prepare and
  # incoming calls or outgoing calls requests.
  #
  # @return [unknown]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_item.rb#84
  def data; end

  # More detail for this item, e.g. the signature of a function.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_item.rb#48
  def detail; end

  # The kind of this item.
  #
  # @return [SymbolKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_item.rb#32
  def kind; end

  # The name of this item.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_item.rb#24
  def name; end

  # The range enclosing this symbol not including leading/trailing whitespace
  # but everything else, e.g. comments and code.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_item.rb#65
  def range; end

  # The range that should be selected and revealed when this symbol is being
  # picked, e.g. the name of a function. Must be contained by the
  # [`range`](#CallHierarchyItem.range).
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_item.rb#75
  def selection_range; end

  # Tags for this item.
  #
  # @return [1[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_item.rb#40
  def tags; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_item.rb#90
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_item.rb#94
  def to_json(*args); end

  # The resource identifier of this item.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_item.rb#56
  def uri; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_options.rb#4
class LanguageServer::Protocol::Interface::CallHierarchyOptions
  # @return [CallHierarchyOptions] a new instance of CallHierarchyOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_options.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_options.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_options.rb#24
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_options.rb#14
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_outgoing_call.rb#4
class LanguageServer::Protocol::Interface::CallHierarchyOutgoingCall
  # @return [CallHierarchyOutgoingCall] a new instance of CallHierarchyOutgoingCall
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_outgoing_call.rb#5
  def initialize(to:, from_ranges:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_outgoing_call.rb#31
  def attributes; end

  # The range at which this item is called. This is the range relative to
  # the caller, e.g the item passed to `callHierarchy/outgoingCalls` request.
  #
  # @return [Range[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_outgoing_call.rb#27
  def from_ranges; end

  # The item that is called.
  #
  # @return [CallHierarchyItem]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_outgoing_call.rb#18
  def to; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_outgoing_call.rb#33
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_outgoing_call.rb#37
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_outgoing_calls_params.rb#4
class LanguageServer::Protocol::Interface::CallHierarchyOutgoingCallsParams
  # @return [CallHierarchyOutgoingCallsParams] a new instance of CallHierarchyOutgoingCallsParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_outgoing_calls_params.rb#5
  def initialize(item:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_outgoing_calls_params.rb#37
  def attributes; end

  # @return [CallHierarchyItem]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_outgoing_calls_params.rb#33
  def item; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_outgoing_calls_params.rb#28
  def partial_result_token; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_outgoing_calls_params.rb#39
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_outgoing_calls_params.rb#43
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_outgoing_calls_params.rb#19
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_prepare_params.rb#4
class LanguageServer::Protocol::Interface::CallHierarchyPrepareParams
  # @return [CallHierarchyPrepareParams] a new instance of CallHierarchyPrepareParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_prepare_params.rb#5
  def initialize(text_document:, position:, work_done_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_prepare_params.rb#39
  def attributes; end

  # The position inside the text document.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_prepare_params.rb#27
  def position; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_prepare_params.rb#19
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_prepare_params.rb#41
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_prepare_params.rb#45
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_prepare_params.rb#35
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_registration_options.rb#4
class LanguageServer::Protocol::Interface::CallHierarchyRegistrationOptions
  # @return [CallHierarchyRegistrationOptions] a new instance of CallHierarchyRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil), id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_registration_options.rb#38
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_registration_options.rb#20
  def document_selector; end

  # The id used to register the request. The id can be used to deregister
  # the request again. See also Registration#id.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_registration_options.rb#34
  def id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_registration_options.rb#40
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_registration_options.rb#44
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/call_hierarchy_registration_options.rb#25
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/cancel_params.rb#4
class LanguageServer::Protocol::Interface::CancelParams
  # @return [CancelParams] a new instance of CancelParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/cancel_params.rb#5
  def initialize(id:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/cancel_params.rb#21
  def attributes; end

  # The request id to cancel.
  #
  # @return [string | number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/cancel_params.rb#17
  def id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/cancel_params.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/cancel_params.rb#27
  def to_json(*args); end
end

# Additional information that describes document changes.
#
# source://language_server-protocol//lib/language_server/protocol/interface/change_annotation.rb#7
class LanguageServer::Protocol::Interface::ChangeAnnotation
  # @return [ChangeAnnotation] a new instance of ChangeAnnotation
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/change_annotation.rb#8
  def initialize(label:, needs_confirmation: T.unsafe(nil), description: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/change_annotation.rb#45
  def attributes; end

  # A human-readable string which is rendered less prominent in
  # the user interface.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/change_annotation.rb#41
  def description; end

  # A human-readable string describing the actual change. The string
  # is rendered prominent in the user interface.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/change_annotation.rb#23
  def label; end

  # A flag which indicates that user confirmation is needed
  # before applying the change.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/change_annotation.rb#32
  def needs_confirmation; end

  # source://language_server-protocol//lib/language_server/protocol/interface/change_annotation.rb#47
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/change_annotation.rb#51
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/client_capabilities.rb#4
class LanguageServer::Protocol::Interface::ClientCapabilities
  # @return [ClientCapabilities] a new instance of ClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/client_capabilities.rb#5
  def initialize(workspace: T.unsafe(nil), text_document: T.unsafe(nil), notebook_document: T.unsafe(nil), window: T.unsafe(nil), general: T.unsafe(nil), experimental: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/client_capabilities.rb#66
  def attributes; end

  # Experimental client capabilities.
  #
  # @return [LSPAny]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/client_capabilities.rb#62
  def experimental; end

  # General client capabilities.
  #
  # @return [{ staleRequestSupport?: { cancel: boolean; retryOnContentModified: string[]; }; regularExpressions?: RegularExpressionsClientCapabilities; markdown?: any; positionEncodings?: string[]; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/client_capabilities.rb#54
  def general; end

  # Capabilities specific to the notebook document support.
  #
  # @return [NotebookDocumentClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/client_capabilities.rb#38
  def notebook_document; end

  # Text document specific client capabilities.
  #
  # @return [TextDocumentClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/client_capabilities.rb#30
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/client_capabilities.rb#68
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/client_capabilities.rb#72
  def to_json(*args); end

  # Window specific client capabilities.
  #
  # @return [{ workDoneProgress?: boolean; showMessage?: ShowMessageRequestClientCapabilities; showDocument?: ShowDocumentClientCapabilities; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/client_capabilities.rb#46
  def window; end

  # Workspace specific client capabilities.
  #
  # @return [{ applyEdit?: boolean; workspaceEdit?: WorkspaceEditClientCapabilities; didChangeConfiguration?: DidChangeConfigurationClientCapabilities; ... 10 more ...; diagnostics?: DiagnosticWorkspaceClientCapabilities; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/client_capabilities.rb#22
  def workspace; end
end

# A code action represents a change that can be performed in code, e.g. to fix
# a problem or to refactor code.
#
# A CodeAction must set either `edit` and/or a `command`. If both are supplied,
# the `edit` is applied first, then the `command` is executed.
#
# source://language_server-protocol//lib/language_server/protocol/interface/code_action.rb#11
class LanguageServer::Protocol::Interface::CodeAction
  # @return [CodeAction] a new instance of CodeAction
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action.rb#12
  def initialize(title:, kind: T.unsafe(nil), diagnostics: T.unsafe(nil), is_preferred: T.unsafe(nil), disabled: T.unsafe(nil), edit: T.unsafe(nil), command: T.unsafe(nil), data: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action.rb#115
  def attributes; end

  # A command this code action executes. If a code action
  # provides an edit and a command, first the edit is
  # executed and then the command.
  #
  # @return [Command]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action.rb#102
  def command; end

  # A data entry field that is preserved on a code action between
  # a `textDocument/codeAction` and a `codeAction/resolve` request.
  #
  # @return [LSPAny]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action.rb#111
  def data; end

  # The diagnostics that this code action resolves.
  #
  # @return [Diagnostic[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action.rb#49
  def diagnostics; end

  # Marks that the code action cannot currently be applied.
  #
  # Clients should follow the following guidelines regarding disabled code
  # actions:
  #
  # - Disabled code actions are not shown in automatic lightbulbs code
  # action menus.
  #
  # - Disabled actions are shown as faded out in the code action menu when
  # the user request a more specific type of code action, such as
  # refactorings.
  #
  # - If the user has a keybinding that auto applies a code action and only
  # a disabled code actions are returned, the client should show the user
  # an error message with `reason` in the editor.
  #
  # @return [{ reason: string; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action.rb#84
  def disabled; end

  # The workspace edit this code action performs.
  #
  # @return [WorkspaceEdit]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action.rb#92
  def edit; end

  # Marks this as a preferred action. Preferred actions are used by the
  # `auto fix` command and can be targeted by keybindings.
  #
  # A quick fix should be marked preferred if it properly addresses the
  # underlying error. A refactoring should be marked preferred if it is the
  # most reasonable choice of actions to take.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action.rb#62
  def is_preferred; end

  # The kind of the code action.
  #
  # Used to filter code actions.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action.rb#41
  def kind; end

  # A short, human-readable, title for this code action.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action.rb#31
  def title; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_action.rb#117
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_action.rb#121
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/code_action_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::CodeActionClientCapabilities
  # @return [CodeActionClientCapabilities] a new instance of CodeActionClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil), code_action_literal_support: T.unsafe(nil), is_preferred_support: T.unsafe(nil), disabled_support: T.unsafe(nil), data_support: T.unsafe(nil), resolve_support: T.unsafe(nil), honors_change_annotations: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_client_capabilities.rb#83
  def attributes; end

  # The client supports code action literals as a valid
  # response of the `textDocument/codeAction` request.
  #
  # @return [{ codeActionKind: { valueSet: string[]; }; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_client_capabilities.rb#32
  def code_action_literal_support; end

  # Whether code action supports the `data` property which is
  # preserved between a `textDocument/codeAction` and a
  # `codeAction/resolve` request.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_client_capabilities.rb#58
  def data_support; end

  # Whether code action supports the `disabled` property.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_client_capabilities.rb#48
  def disabled_support; end

  # Whether code action supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_client_capabilities.rb#23
  def dynamic_registration; end

  # Whether the client honors the change annotations in
  # text edits and resource operations returned via the
  # `CodeAction#edit` property by for example presenting
  # the workspace edit in the user interface and asking
  # for confirmation.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_client_capabilities.rb#79
  def honors_change_annotations; end

  # Whether code action supports the `isPreferred` property.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_client_capabilities.rb#40
  def is_preferred_support; end

  # Whether the client supports resolving additional code action
  # properties via a separate `codeAction/resolve` request.
  #
  # @return [{ properties: string[]; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_client_capabilities.rb#67
  def resolve_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_client_capabilities.rb#85
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_client_capabilities.rb#89
  def to_json(*args); end
end

# Contains additional diagnostic information about the context in which
# a code action is run.
#
# source://language_server-protocol//lib/language_server/protocol/interface/code_action_context.rb#8
class LanguageServer::Protocol::Interface::CodeActionContext
  # @return [CodeActionContext] a new instance of CodeActionContext
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_context.rb#9
  def initialize(diagnostics:, only: T.unsafe(nil), trigger_kind: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_context.rb#51
  def attributes; end

  # An array of diagnostics known on the client side overlapping the range
  # provided to the `textDocument/codeAction` request. They are provided so
  # that the server knows which errors are currently presented to the user
  # for the given range. There is no guarantee that these accurately reflect
  # the error state of the resource. The primary parameter
  # to compute code actions is the provided range.
  #
  # @return [Diagnostic[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_context.rb#28
  def diagnostics; end

  # Requested kind of actions to return.
  #
  # Actions not of this kind are filtered out by the client before being
  # shown. So servers can omit computing them.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_context.rb#39
  def only; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_context.rb#53
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_context.rb#57
  def to_json(*args); end

  # The reason why code actions were requested.
  #
  # @return [CodeActionTriggerKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_context.rb#47
  def trigger_kind; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/code_action_options.rb#4
class LanguageServer::Protocol::Interface::CodeActionOptions
  # @return [CodeActionOptions] a new instance of CodeActionOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil), code_action_kinds: T.unsafe(nil), resolve_provider: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_options.rb#40
  def attributes; end

  # CodeActionKinds that this server may return.
  #
  # The list of kinds may be generic, such as `CodeActionKind.Refactor`,
  # or the server may list out every specific kind they provide.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_options.rb#27
  def code_action_kinds; end

  # The server provides support to resolve additional
  # information for a code action.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_options.rb#36
  def resolve_provider; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_options.rb#42
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_options.rb#46
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_options.rb#16
  def work_done_progress; end
end

# Params for the CodeActionRequest
#
# source://language_server-protocol//lib/language_server/protocol/interface/code_action_params.rb#7
class LanguageServer::Protocol::Interface::CodeActionParams
  # @return [CodeActionParams] a new instance of CodeActionParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_params.rb#8
  def initialize(text_document:, range:, context:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_params.rb#61
  def attributes; end

  # Context carrying additional information.
  #
  # @return [CodeActionContext]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_params.rb#57
  def context; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_params.rb#33
  def partial_result_token; end

  # The range for which the command was invoked.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_params.rb#49
  def range; end

  # The document in which the command was invoked.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_params.rb#41
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_params.rb#63
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_params.rb#67
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_params.rb#24
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/code_action_registration_options.rb#4
class LanguageServer::Protocol::Interface::CodeActionRegistrationOptions
  # @return [CodeActionRegistrationOptions] a new instance of CodeActionRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil), code_action_kinds: T.unsafe(nil), resolve_provider: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_registration_options.rb#50
  def attributes; end

  # CodeActionKinds that this server may return.
  #
  # The list of kinds may be generic, such as `CodeActionKind.Refactor`,
  # or the server may list out every specific kind they provide.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_registration_options.rb#37
  def code_action_kinds; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_registration_options.rb#21
  def document_selector; end

  # The server provides support to resolve additional
  # information for a code action.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_registration_options.rb#46
  def resolve_provider; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_registration_options.rb#52
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_registration_options.rb#56
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_action_registration_options.rb#26
  def work_done_progress; end
end

# Structure to capture a description for an error code.
#
# source://language_server-protocol//lib/language_server/protocol/interface/code_description.rb#7
class LanguageServer::Protocol::Interface::CodeDescription
  # @return [CodeDescription] a new instance of CodeDescription
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_description.rb#8
  def initialize(href:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_description.rb#24
  def attributes; end

  # An URI to open with more information about the diagnostic error.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_description.rb#20
  def href; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_description.rb#26
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_description.rb#30
  def to_json(*args); end
end

# A code lens represents a command that should be shown along with
# source text, like the number of references, a way to run tests, etc.
#
# A code lens is _unresolved_ when no command is associated to it. For
# performance reasons the creation of a code lens and resolving should be done
# in two stages.
#
# source://language_server-protocol//lib/language_server/protocol/interface/code_lens.rb#12
class LanguageServer::Protocol::Interface::CodeLens
  # @return [CodeLens] a new instance of CodeLens
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens.rb#13
  def initialize(range:, command: T.unsafe(nil), data: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens.rb#49
  def attributes; end

  # The command this code lens represents.
  #
  # @return [Command]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens.rb#36
  def command; end

  # A data entry field that is preserved on a code lens item between
  # a code lens and a code lens resolve request.
  #
  # @return [LSPAny]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens.rb#45
  def data; end

  # The range in which this code lens is valid. Should only span a single
  # line.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens.rb#28
  def range; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens.rb#51
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens.rb#55
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/code_lens_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::CodeLensClientCapabilities
  # @return [CodeLensClientCapabilities] a new instance of CodeLensClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_client_capabilities.rb#21
  def attributes; end

  # Whether code lens supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_client_capabilities.rb#17
  def dynamic_registration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_client_capabilities.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_client_capabilities.rb#27
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/code_lens_options.rb#4
class LanguageServer::Protocol::Interface::CodeLensOptions
  # @return [CodeLensOptions] a new instance of CodeLensOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil), resolve_provider: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_options.rb#27
  def attributes; end

  # Code lens has a resolve provider as well.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_options.rb#23
  def resolve_provider; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_options.rb#29
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_options.rb#33
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_options.rb#15
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/code_lens_params.rb#4
class LanguageServer::Protocol::Interface::CodeLensParams
  # @return [CodeLensParams] a new instance of CodeLensParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_params.rb#5
  def initialize(text_document:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_params.rb#40
  def attributes; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_params.rb#28
  def partial_result_token; end

  # The document to request code lens for.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_params.rb#36
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_params.rb#42
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_params.rb#46
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_params.rb#19
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/code_lens_registration_options.rb#4
class LanguageServer::Protocol::Interface::CodeLensRegistrationOptions
  # @return [CodeLensRegistrationOptions] a new instance of CodeLensRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil), resolve_provider: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_registration_options.rb#37
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_registration_options.rb#20
  def document_selector; end

  # Code lens has a resolve provider as well.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_registration_options.rb#33
  def resolve_provider; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_registration_options.rb#39
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_registration_options.rb#43
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_registration_options.rb#25
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/code_lens_workspace_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::CodeLensWorkspaceClientCapabilities
  # @return [CodeLensWorkspaceClientCapabilities] a new instance of CodeLensWorkspaceClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_workspace_client_capabilities.rb#5
  def initialize(refresh_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_workspace_client_capabilities.rb#27
  def attributes; end

  # Whether the client implementation supports a refresh request sent from the
  # server to the client.
  #
  # Note that this event is global and will force the client to refresh all
  # code lenses currently shown. It should be used with absolute care and is
  # useful for situation where a server for example detect a project wide
  # change that requires such a calculation.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_workspace_client_capabilities.rb#23
  def refresh_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_workspace_client_capabilities.rb#29
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/code_lens_workspace_client_capabilities.rb#33
  def to_json(*args); end
end

# Represents a color in RGBA space.
#
# source://language_server-protocol//lib/language_server/protocol/interface/color.rb#7
class LanguageServer::Protocol::Interface::Color
  # @return [Color] a new instance of Color
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color.rb#8
  def initialize(red:, green:, blue:, alpha:); end

  # The alpha component of this color in the range [0-1].
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color.rb#47
  def alpha; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color.rb#51
  def attributes; end

  # The blue component of this color in the range [0-1].
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color.rb#39
  def blue; end

  # The green component of this color in the range [0-1].
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color.rb#31
  def green; end

  # The red component of this color in the range [0-1].
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color.rb#23
  def red; end

  # source://language_server-protocol//lib/language_server/protocol/interface/color.rb#53
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/color.rb#57
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/color_information.rb#4
class LanguageServer::Protocol::Interface::ColorInformation
  # @return [ColorInformation] a new instance of ColorInformation
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color_information.rb#5
  def initialize(range:, color:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color_information.rb#30
  def attributes; end

  # The actual color value for this color range.
  #
  # @return [Color]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color_information.rb#26
  def color; end

  # The range in the document where this color appears.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color_information.rb#18
  def range; end

  # source://language_server-protocol//lib/language_server/protocol/interface/color_information.rb#32
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/color_information.rb#36
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/color_presentation.rb#4
class LanguageServer::Protocol::Interface::ColorPresentation
  # @return [ColorPresentation] a new instance of ColorPresentation
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color_presentation.rb#5
  def initialize(label:, text_edit: T.unsafe(nil), additional_text_edits: T.unsafe(nil)); end

  # An optional array of additional [text edits](#TextEdit) that are applied
  # when selecting this color presentation. Edits must not overlap with the
  # main [edit](#ColorPresentation.textEdit) nor with themselves.
  #
  # @return [TextEdit[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color_presentation.rb#41
  def additional_text_edits; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color_presentation.rb#45
  def attributes; end

  # The label of this color presentation. It will be shown on the color
  # picker header. By default this is also the text that is inserted when
  # selecting this color presentation.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color_presentation.rb#21
  def label; end

  # An [edit](#TextEdit) which is applied to a document when selecting
  # this presentation for the color. When omitted the
  # [label](#ColorPresentation.label) is used.
  #
  # @return [TextEdit]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color_presentation.rb#31
  def text_edit; end

  # source://language_server-protocol//lib/language_server/protocol/interface/color_presentation.rb#47
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/color_presentation.rb#51
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/color_presentation_params.rb#4
class LanguageServer::Protocol::Interface::ColorPresentationParams
  # @return [ColorPresentationParams] a new instance of ColorPresentationParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color_presentation_params.rb#5
  def initialize(text_document:, color:, range:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color_presentation_params.rb#58
  def attributes; end

  # The color information to request presentations for.
  #
  # @return [Color]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color_presentation_params.rb#46
  def color; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color_presentation_params.rb#30
  def partial_result_token; end

  # The range where the color would be inserted. Serves as a context.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color_presentation_params.rb#54
  def range; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color_presentation_params.rb#38
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/color_presentation_params.rb#60
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/color_presentation_params.rb#64
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/color_presentation_params.rb#21
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/command.rb#4
class LanguageServer::Protocol::Interface::Command
  # @return [Command] a new instance of Command
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/command.rb#5
  def initialize(title:, command:, arguments: T.unsafe(nil)); end

  # Arguments that the command handler should be
  # invoked with.
  #
  # @return [LSPAny[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/command.rb#36
  def arguments; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/command.rb#40
  def attributes; end

  # The identifier of the actual command handler.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/command.rb#27
  def command; end

  # Title of the command, like `save`.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/command.rb#19
  def title; end

  # source://language_server-protocol//lib/language_server/protocol/interface/command.rb#42
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/command.rb#46
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/completion_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::CompletionClientCapabilities
  # @return [CompletionClientCapabilities] a new instance of CompletionClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil), completion_item: T.unsafe(nil), completion_item_kind: T.unsafe(nil), context_support: T.unsafe(nil), insert_text_mode: T.unsafe(nil), completion_list: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_client_capabilities.rb#67
  def attributes; end

  # The client supports the following `CompletionItem` specific
  # capabilities.
  #
  # @return [{ snippetSupport?: boolean; commitCharactersSupport?: boolean; documentationFormat?: MarkupKind[]; deprecatedSupport?: boolean; preselectSupport?: boolean; tagSupport?: { valueSet: 1[]; }; insertReplaceSupport?: boolean; resolveSupport?: { ...; }; insertTextModeSupport?: { ...; }; labelDetailsSupport?: boolean; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_client_capabilities.rb#31
  def completion_item; end

  # @return [{ valueSet?: CompletionItemKind[]; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_client_capabilities.rb#36
  def completion_item_kind; end

  # The client supports the following `CompletionList` specific
  # capabilities.
  #
  # @return [{ itemDefaults?: string[]; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_client_capabilities.rb#63
  def completion_list; end

  # The client supports to send additional context information for a
  # `textDocument/completion` request.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_client_capabilities.rb#45
  def context_support; end

  # Whether completion supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_client_capabilities.rb#22
  def dynamic_registration; end

  # The client's default when the completion item doesn't provide a
  # `insertTextMode` property.
  #
  # @return [InsertTextMode]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_client_capabilities.rb#54
  def insert_text_mode; end

  # source://language_server-protocol//lib/language_server/protocol/interface/completion_client_capabilities.rb#69
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/completion_client_capabilities.rb#73
  def to_json(*args); end
end

# Contains additional information about the context in which a completion
# request is triggered.
#
# source://language_server-protocol//lib/language_server/protocol/interface/completion_context.rb#8
class LanguageServer::Protocol::Interface::CompletionContext
  # @return [CompletionContext] a new instance of CompletionContext
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_context.rb#9
  def initialize(trigger_kind:, trigger_character: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_context.rb#36
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/completion_context.rb#38
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/completion_context.rb#42
  def to_json(*args); end

  # The trigger character (a single character) that has trigger code
  # complete. Is undefined if
  # `triggerKind !== CompletionTriggerKind.TriggerCharacter`
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_context.rb#32
  def trigger_character; end

  # How the completion was triggered.
  #
  # @return [CompletionTriggerKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_context.rb#22
  def trigger_kind; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#4
class LanguageServer::Protocol::Interface::CompletionItem
  # @return [CompletionItem] a new instance of CompletionItem
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#5
  def initialize(label:, label_details: T.unsafe(nil), kind: T.unsafe(nil), tags: T.unsafe(nil), detail: T.unsafe(nil), documentation: T.unsafe(nil), deprecated: T.unsafe(nil), preselect: T.unsafe(nil), sort_text: T.unsafe(nil), filter_text: T.unsafe(nil), insert_text: T.unsafe(nil), insert_text_format: T.unsafe(nil), insert_text_mode: T.unsafe(nil), text_edit: T.unsafe(nil), text_edit_text: T.unsafe(nil), additional_text_edits: T.unsafe(nil), commit_characters: T.unsafe(nil), command: T.unsafe(nil), data: T.unsafe(nil)); end

  # An optional array of additional text edits that are applied when
  # selecting this completion. Edits must not overlap (including the same
  # insert position) with the main edit nor with themselves.
  #
  # Additional text edits should be used to change text unrelated to the
  # current cursor position (for example adding an import statement at the
  # top of the file if the completion item will insert an unqualified type).
  #
  # @return [TextEdit[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#221
  def additional_text_edits; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#255
  def attributes; end

  # An optional command that is executed *after* inserting this completion.
  # *Note* that additional modifications to the current document should be
  # described with the additionalTextEdits-property.
  #
  # @return [Command]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#242
  def command; end

  # An optional set of characters that when pressed while this completion is
  # active will accept it first and then type that character. *Note* that all
  # commit characters should have `length=1` and that superfluous characters
  # will be ignored.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#232
  def commit_characters; end

  # A data entry field that is preserved on a completion item between
  # a completion and a completion resolve request.
  #
  # @return [LSPAny]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#251
  def data; end

  # Indicates if this item is deprecated.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#92
  def deprecated; end

  # A human-readable string with additional information
  # about this item, like type or symbol information.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#76
  def detail; end

  # A human-readable string that represents a doc-comment.
  #
  # @return [string | MarkupContent]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#84
  def documentation; end

  # A string that should be used when filtering a set of
  # completion items. When omitted the label is used as the
  # filter text for this item.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#124
  def filter_text; end

  # A string that should be inserted into a document when selecting
  # this completion. When omitted the label is used as the insert text
  # for this item.
  #
  # The `insertText` is subject to interpretation by the client side.
  # Some tools might not take the string literally. For example
  # VS Code when code complete is requested in this example
  # `con<cursor position>` and a completion item with an `insertText` of
  # `console` is provided it will only insert `sole`. Therefore it is
  # recommended to use `textEdit` instead since it avoids additional client
  # side interpretation.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#142
  def insert_text; end

  # The format of the insert text. The format applies to both the
  # `insertText` property and the `newText` property of a provided
  # `textEdit`. If omitted defaults to `InsertTextFormat.PlainText`.
  #
  # Please note that the insertTextFormat doesn't apply to
  # `additionalTextEdits`.
  #
  # @return [InsertTextFormat]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#155
  def insert_text_format; end

  # How whitespace and indentation is handled during completion
  # item insertion. If not provided the client's default value depends on
  # the `textDocument.completion.insertTextMode` client capability.
  #
  # @return [InsertTextMode]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#165
  def insert_text_mode; end

  # The kind of this completion item. Based of the kind
  # an icon is chosen by the editor. The standardized set
  # of available values is defined in `CompletionItemKind`.
  #
  # @return [CompletionItemKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#59
  def kind; end

  # The label of this completion item.
  #
  # The label property is also by default the text that
  # is inserted when selecting this completion.
  #
  # If label details are provided the label itself should
  # be an unqualified name of the completion item.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#41
  def label; end

  # Additional details for the label
  #
  # @return [CompletionItemLabelDetails]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#49
  def label_details; end

  # Select this item when showing.
  #
  # *Note* that only one completion item can be selected and that the
  # tool / client decides which item that is. The rule is that the *first*
  # item of those that match best is selected.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#104
  def preselect; end

  # A string that should be used when comparing this item
  # with other items. When omitted the label is used
  # as the sort text for this item.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#114
  def sort_text; end

  # Tags for this completion item.
  #
  # @return [1[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#67
  def tags; end

  # An edit which is applied to a document when selecting this completion.
  # When an edit is provided the value of `insertText` is ignored.
  #
  # *Note:* The range of the edit must be a single line range and it must
  # contain the position at which completion has been requested.
  #
  # Most editors support two different operations when accepting a completion
  # item. One is to insert a completion text and the other is to replace an
  # existing text with a completion text. Since this can usually not be
  # predetermined by a server it can report both ranges. Clients need to
  # signal support for `InsertReplaceEdit`s via the
  # `textDocument.completion.completionItem.insertReplaceSupport` client
  # capability property.
  #
  # *Note 1:* The text edit's range as well as both ranges from an insert
  # replace edit must be a [single line] and they must contain the position
  # at which completion has been requested.
  # *Note 2:* If an `InsertReplaceEdit` is returned the edit's insert range
  # must be a prefix of the edit's replace range, that means it must be
  # contained and starting at the same position.
  #
  # @return [TextEdit | InsertReplaceEdit]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#192
  def text_edit; end

  # The edit text used if the completion item is part of a CompletionList and
  # CompletionList defines an item default for the text edit range.
  #
  # Clients will only honor this property if they opt into completion list
  # item defaults using the capability `completionList.itemDefaults`.
  #
  # If not provided and a list's default range is provided the label
  # property is used as a text.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#207
  def text_edit_text; end

  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#257
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item.rb#261
  def to_json(*args); end
end

# Additional details for a completion item label.
#
# source://language_server-protocol//lib/language_server/protocol/interface/completion_item_label_details.rb#7
class LanguageServer::Protocol::Interface::CompletionItemLabelDetails
  # @return [CompletionItemLabelDetails] a new instance of CompletionItemLabelDetails
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item_label_details.rb#8
  def initialize(detail: T.unsafe(nil), description: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item_label_details.rb#37
  def attributes; end

  # An optional string which is rendered less prominently after
  # {@link CompletionItemLabelDetails.detail}. Should be used for fully qualified
  # names or file path.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item_label_details.rb#33
  def description; end

  # An optional string which is rendered less prominently directly after
  # {@link CompletionItem.label label}, without any spacing. Should be
  # used for function signatures or type annotations.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item_label_details.rb#23
  def detail; end

  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item_label_details.rb#39
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/completion_item_label_details.rb#43
  def to_json(*args); end
end

# Represents a collection of [completion items](#CompletionItem) to be
# presented in the editor.
#
# source://language_server-protocol//lib/language_server/protocol/interface/completion_list.rb#8
class LanguageServer::Protocol::Interface::CompletionList
  # @return [CompletionList] a new instance of CompletionList
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_list.rb#9
  def initialize(is_incomplete:, items:, item_defaults: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_list.rb#57
  def attributes; end

  # This list is not complete. Further typing should result in recomputing
  # this list.
  #
  # Recomputed lists have all their items replaced (not appended) in the
  # incomplete completion sessions.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_list.rb#27
  def is_incomplete; end

  # In many cases the items of an actual completion result share the same
  # value for properties like `commitCharacters` or the range of a text
  # edit. A completion list can therefore define item defaults which will
  # be used if a completion item itself doesn't specify the value.
  #
  # If a completion list specifies a default value and a completion item
  # also specifies a corresponding value the one from the item is used.
  #
  # Servers are only allowed to return default values if the client
  # signals support for this via the `completionList.itemDefaults`
  # capability.
  #
  # @return [{ commitCharacters?: string[]; editRange?: Range | { insert: Range; replace: Range; }; insertTextFormat?: InsertTextFormat; insertTextMode?: InsertTextMode; data?: LSPAny; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_list.rb#45
  def item_defaults; end

  # The completion items.
  #
  # @return [CompletionItem[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_list.rb#53
  def items; end

  # source://language_server-protocol//lib/language_server/protocol/interface/completion_list.rb#59
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/completion_list.rb#63
  def to_json(*args); end
end

# Completion options.
#
# source://language_server-protocol//lib/language_server/protocol/interface/completion_options.rb#7
class LanguageServer::Protocol::Interface::CompletionOptions
  # @return [CompletionOptions] a new instance of CompletionOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_options.rb#8
  def initialize(work_done_progress: T.unsafe(nil), trigger_characters: T.unsafe(nil), all_commit_characters: T.unsafe(nil), resolve_provider: T.unsafe(nil), completion_item: T.unsafe(nil)); end

  # The list of all possible characters that commit a completion. This field
  # can be used if clients don't support individual commit characters per
  # completion item. See client capability
  # `completion.completionItem.commitCharactersSupport`.
  #
  # If a server provides both `allCommitCharacters` and commit characters on
  # an individual completion item the ones on the completion item win.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_options.rb#53
  def all_commit_characters; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_options.rb#75
  def attributes; end

  # The server supports the following `CompletionItem` specific
  # capabilities.
  #
  # @return [{ labelDetailsSupport?: boolean; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_options.rb#71
  def completion_item; end

  # The server provides support to resolve additional
  # information for a completion item.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_options.rb#62
  def resolve_provider; end

  # source://language_server-protocol//lib/language_server/protocol/interface/completion_options.rb#77
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/completion_options.rb#81
  def to_json(*args); end

  # The additional characters, beyond the defaults provided by the client (typically
  # [a-zA-Z]), that should automatically trigger a completion request. For example
  # `.` in JavaScript represents the beginning of an object property or method and is
  # thus a good candidate for triggering a completion request.
  #
  # Most tools trigger a completion request automatically without explicitly
  # requesting it using a keyboard shortcut (e.g. Ctrl+Space). Typically they
  # do so when the user starts to type an identifier. For example if the user
  # types `c` in a JavaScript file code complete will automatically pop up
  # present `console` besides others as a completion item. Characters that
  # make up identifiers don't need to be listed here.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_options.rb#39
  def trigger_characters; end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_options.rb#21
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/completion_params.rb#4
class LanguageServer::Protocol::Interface::CompletionParams
  # @return [CompletionParams] a new instance of CompletionParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_params.rb#5
  def initialize(text_document:, position:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil), context: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_params.rb#60
  def attributes; end

  # The completion context. This is only available if the client specifies
  # to send this using the client capability
  # `completion.contextSupport === true`
  #
  # @return [CompletionContext]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_params.rb#56
  def context; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_params.rb#46
  def partial_result_token; end

  # The position inside the text document.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_params.rb#29
  def position; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_params.rb#21
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/completion_params.rb#62
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/completion_params.rb#66
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_params.rb#37
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/completion_registration_options.rb#4
class LanguageServer::Protocol::Interface::CompletionRegistrationOptions
  # @return [CompletionRegistrationOptions] a new instance of CompletionRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil), trigger_characters: T.unsafe(nil), all_commit_characters: T.unsafe(nil), resolve_provider: T.unsafe(nil), completion_item: T.unsafe(nil)); end

  # The list of all possible characters that commit a completion. This field
  # can be used if clients don't support individual commit characters per
  # completion item. See client capability
  # `completion.completionItem.commitCharactersSupport`.
  #
  # If a server provides both `allCommitCharacters` and commit characters on
  # an individual completion item the ones on the completion item win.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_registration_options.rb#60
  def all_commit_characters; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_registration_options.rb#82
  def attributes; end

  # The server supports the following `CompletionItem` specific
  # capabilities.
  #
  # @return [{ labelDetailsSupport?: boolean; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_registration_options.rb#78
  def completion_item; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_registration_options.rb#23
  def document_selector; end

  # The server provides support to resolve additional
  # information for a completion item.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_registration_options.rb#69
  def resolve_provider; end

  # source://language_server-protocol//lib/language_server/protocol/interface/completion_registration_options.rb#84
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/completion_registration_options.rb#88
  def to_json(*args); end

  # The additional characters, beyond the defaults provided by the client (typically
  # [a-zA-Z]), that should automatically trigger a completion request. For example
  # `.` in JavaScript represents the beginning of an object property or method and is
  # thus a good candidate for triggering a completion request.
  #
  # Most tools trigger a completion request automatically without explicitly
  # requesting it using a keyboard shortcut (e.g. Ctrl+Space). Typically they
  # do so when the user starts to type an identifier. For example if the user
  # types `c` in a JavaScript file code complete will automatically pop up
  # present `console` besides others as a completion item. Characters that
  # make up identifiers don't need to be listed here.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_registration_options.rb#46
  def trigger_characters; end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/completion_registration_options.rb#28
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/configuration_item.rb#4
class LanguageServer::Protocol::Interface::ConfigurationItem
  # @return [ConfigurationItem] a new instance of ConfigurationItem
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/configuration_item.rb#5
  def initialize(scope_uri: T.unsafe(nil), section: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/configuration_item.rb#30
  def attributes; end

  # The scope to get the configuration section for.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/configuration_item.rb#18
  def scope_uri; end

  # The configuration section asked for.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/configuration_item.rb#26
  def section; end

  # source://language_server-protocol//lib/language_server/protocol/interface/configuration_item.rb#32
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/configuration_item.rb#36
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/configuration_params.rb#4
class LanguageServer::Protocol::Interface::ConfigurationParams
  # @return [ConfigurationParams] a new instance of ConfigurationParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/configuration_params.rb#5
  def initialize(items:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/configuration_params.rb#18
  def attributes; end

  # @return [ConfigurationItem[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/configuration_params.rb#14
  def items; end

  # source://language_server-protocol//lib/language_server/protocol/interface/configuration_params.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/configuration_params.rb#24
  def to_json(*args); end
end

# Create file operation
#
# source://language_server-protocol//lib/language_server/protocol/interface/create_file.rb#7
class LanguageServer::Protocol::Interface::CreateFile
  # @return [CreateFile] a new instance of CreateFile
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/create_file.rb#8
  def initialize(kind:, uri:, options: T.unsafe(nil), annotation_id: T.unsafe(nil)); end

  # An optional annotation identifier describing the operation.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/create_file.rb#47
  def annotation_id; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/create_file.rb#51
  def attributes; end

  # A create
  #
  # @return ["create"]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/create_file.rb#23
  def kind; end

  # Additional options
  #
  # @return [CreateFileOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/create_file.rb#39
  def options; end

  # source://language_server-protocol//lib/language_server/protocol/interface/create_file.rb#53
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/create_file.rb#57
  def to_json(*args); end

  # The resource to create.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/create_file.rb#31
  def uri; end
end

# Options to create a file.
#
# source://language_server-protocol//lib/language_server/protocol/interface/create_file_options.rb#7
class LanguageServer::Protocol::Interface::CreateFileOptions
  # @return [CreateFileOptions] a new instance of CreateFileOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/create_file_options.rb#8
  def initialize(overwrite: T.unsafe(nil), ignore_if_exists: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/create_file_options.rb#33
  def attributes; end

  # Ignore if exists.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/create_file_options.rb#29
  def ignore_if_exists; end

  # Overwrite existing file. Overwrite wins over `ignoreIfExists`
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/create_file_options.rb#21
  def overwrite; end

  # source://language_server-protocol//lib/language_server/protocol/interface/create_file_options.rb#35
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/create_file_options.rb#39
  def to_json(*args); end
end

# The parameters sent in notifications/requests for user-initiated creation
# of files.
#
# source://language_server-protocol//lib/language_server/protocol/interface/create_files_params.rb#8
class LanguageServer::Protocol::Interface::CreateFilesParams
  # @return [CreateFilesParams] a new instance of CreateFilesParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/create_files_params.rb#9
  def initialize(files:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/create_files_params.rb#25
  def attributes; end

  # An array of all files/folders created in this operation.
  #
  # @return [FileCreate[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/create_files_params.rb#21
  def files; end

  # source://language_server-protocol//lib/language_server/protocol/interface/create_files_params.rb#27
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/create_files_params.rb#31
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/declaration_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::DeclarationClientCapabilities
  # @return [DeclarationClientCapabilities] a new instance of DeclarationClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil), link_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_client_capabilities.rb#32
  def attributes; end

  # Whether declaration supports dynamic registration. If this is set to
  # `true` the client supports the new `DeclarationRegistrationOptions`
  # return value for the corresponding server capability as well.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_client_capabilities.rb#20
  def dynamic_registration; end

  # The client supports additional metadata in the form of declaration links.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_client_capabilities.rb#28
  def link_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_client_capabilities.rb#34
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_client_capabilities.rb#38
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/declaration_options.rb#4
class LanguageServer::Protocol::Interface::DeclarationOptions
  # @return [DeclarationOptions] a new instance of DeclarationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_options.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_options.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_options.rb#24
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_options.rb#14
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/declaration_params.rb#4
class LanguageServer::Protocol::Interface::DeclarationParams
  # @return [DeclarationParams] a new instance of DeclarationParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_params.rb#5
  def initialize(text_document:, position:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_params.rb#49
  def attributes; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_params.rb#45
  def partial_result_token; end

  # The position inside the text document.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_params.rb#28
  def position; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_params.rb#20
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_params.rb#51
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_params.rb#55
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_params.rb#36
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/declaration_registration_options.rb#4
class LanguageServer::Protocol::Interface::DeclarationRegistrationOptions
  # @return [DeclarationRegistrationOptions] a new instance of DeclarationRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil), id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_registration_options.rb#38
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_registration_options.rb#25
  def document_selector; end

  # The id used to register the request. The id can be used to deregister
  # the request again. See also Registration#id.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_registration_options.rb#34
  def id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_registration_options.rb#40
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_registration_options.rb#44
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/declaration_registration_options.rb#16
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/definition_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::DefinitionClientCapabilities
  # @return [DefinitionClientCapabilities] a new instance of DefinitionClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/definition_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil), link_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/definition_client_capabilities.rb#30
  def attributes; end

  # Whether definition supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/definition_client_capabilities.rb#18
  def dynamic_registration; end

  # The client supports additional metadata in the form of definition links.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/definition_client_capabilities.rb#26
  def link_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/definition_client_capabilities.rb#32
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/definition_client_capabilities.rb#36
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/definition_options.rb#4
class LanguageServer::Protocol::Interface::DefinitionOptions
  # @return [DefinitionOptions] a new instance of DefinitionOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/definition_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/definition_options.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/definition_options.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/definition_options.rb#24
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/definition_options.rb#14
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/definition_params.rb#4
class LanguageServer::Protocol::Interface::DefinitionParams
  # @return [DefinitionParams] a new instance of DefinitionParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/definition_params.rb#5
  def initialize(text_document:, position:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/definition_params.rb#49
  def attributes; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/definition_params.rb#45
  def partial_result_token; end

  # The position inside the text document.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/definition_params.rb#28
  def position; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/definition_params.rb#20
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/definition_params.rb#51
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/definition_params.rb#55
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/definition_params.rb#36
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/definition_registration_options.rb#4
class LanguageServer::Protocol::Interface::DefinitionRegistrationOptions
  # @return [DefinitionRegistrationOptions] a new instance of DefinitionRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/definition_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/definition_registration_options.rb#28
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/definition_registration_options.rb#19
  def document_selector; end

  # source://language_server-protocol//lib/language_server/protocol/interface/definition_registration_options.rb#30
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/definition_registration_options.rb#34
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/definition_registration_options.rb#24
  def work_done_progress; end
end

# Delete file operation
#
# source://language_server-protocol//lib/language_server/protocol/interface/delete_file.rb#7
class LanguageServer::Protocol::Interface::DeleteFile
  # @return [DeleteFile] a new instance of DeleteFile
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/delete_file.rb#8
  def initialize(kind:, uri:, options: T.unsafe(nil), annotation_id: T.unsafe(nil)); end

  # An optional annotation identifier describing the operation.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/delete_file.rb#47
  def annotation_id; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/delete_file.rb#51
  def attributes; end

  # A delete
  #
  # @return ["delete"]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/delete_file.rb#23
  def kind; end

  # Delete options.
  #
  # @return [DeleteFileOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/delete_file.rb#39
  def options; end

  # source://language_server-protocol//lib/language_server/protocol/interface/delete_file.rb#53
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/delete_file.rb#57
  def to_json(*args); end

  # The file to delete.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/delete_file.rb#31
  def uri; end
end

# Delete file options
#
# source://language_server-protocol//lib/language_server/protocol/interface/delete_file_options.rb#7
class LanguageServer::Protocol::Interface::DeleteFileOptions
  # @return [DeleteFileOptions] a new instance of DeleteFileOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/delete_file_options.rb#8
  def initialize(recursive: T.unsafe(nil), ignore_if_not_exists: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/delete_file_options.rb#33
  def attributes; end

  # Ignore the operation if the file doesn't exist.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/delete_file_options.rb#29
  def ignore_if_not_exists; end

  # Delete the content recursively if a folder is denoted.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/delete_file_options.rb#21
  def recursive; end

  # source://language_server-protocol//lib/language_server/protocol/interface/delete_file_options.rb#35
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/delete_file_options.rb#39
  def to_json(*args); end
end

# The parameters sent in notifications/requests for user-initiated deletes
# of files.
#
# source://language_server-protocol//lib/language_server/protocol/interface/delete_files_params.rb#8
class LanguageServer::Protocol::Interface::DeleteFilesParams
  # @return [DeleteFilesParams] a new instance of DeleteFilesParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/delete_files_params.rb#9
  def initialize(files:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/delete_files_params.rb#25
  def attributes; end

  # An array of all files/folders deleted in this operation.
  #
  # @return [FileDelete[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/delete_files_params.rb#21
  def files; end

  # source://language_server-protocol//lib/language_server/protocol/interface/delete_files_params.rb#27
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/delete_files_params.rb#31
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/diagnostic.rb#4
class LanguageServer::Protocol::Interface::Diagnostic
  # @return [Diagnostic] a new instance of Diagnostic
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic.rb#5
  def initialize(range:, message:, severity: T.unsafe(nil), code: T.unsafe(nil), code_description: T.unsafe(nil), source: T.unsafe(nil), tags: T.unsafe(nil), related_information: T.unsafe(nil), data: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic.rb#98
  def attributes; end

  # The diagnostic's code, which might appear in the user interface.
  #
  # @return [string | number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic.rb#42
  def code; end

  # An optional property to describe the error code.
  #
  # @return [CodeDescription]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic.rb#50
  def code_description; end

  # A data entry field that is preserved between a
  # `textDocument/publishDiagnostics` notification and
  # `textDocument/codeAction` request.
  #
  # @return [unknown]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic.rb#94
  def data; end

  # The diagnostic's message.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic.rb#67
  def message; end

  # The range at which the message applies.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic.rb#25
  def range; end

  # An array of related diagnostic information, e.g. when symbol-names within
  # a scope collide all definitions can be marked via this property.
  #
  # @return [DiagnosticRelatedInformation[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic.rb#84
  def related_information; end

  # The diagnostic's severity. Can be omitted. If omitted it is up to the
  # client to interpret diagnostics as error, warning, info or hint.
  #
  # @return [DiagnosticSeverity]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic.rb#34
  def severity; end

  # A human-readable string describing the source of this
  # diagnostic, e.g. 'typescript' or 'super lint'.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic.rb#59
  def source; end

  # Additional metadata about the diagnostic.
  #
  # @return [DiagnosticTag[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic.rb#75
  def tags; end

  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic.rb#100
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic.rb#104
  def to_json(*args); end
end

# Client capabilities specific to diagnostic pull requests.
#
# source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_client_capabilities.rb#7
class LanguageServer::Protocol::Interface::DiagnosticClientCapabilities
  # @return [DiagnosticClientCapabilities] a new instance of DiagnosticClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_client_capabilities.rb#8
  def initialize(dynamic_registration: T.unsafe(nil), related_document_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_client_capabilities.rb#37
  def attributes; end

  # Whether implementation supports dynamic registration. If this is set to
  # `true` the client supports the new
  # `(TextDocumentRegistrationOptions & StaticRegistrationOptions)`
  # return value for the corresponding server capability as well.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_client_capabilities.rb#24
  def dynamic_registration; end

  # Whether the clients supports related documents for document diagnostic
  # pulls.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_client_capabilities.rb#33
  def related_document_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_client_capabilities.rb#39
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_client_capabilities.rb#43
  def to_json(*args); end
end

# Diagnostic options.
#
# source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_options.rb#7
class LanguageServer::Protocol::Interface::DiagnosticOptions
  # @return [DiagnosticOptions] a new instance of DiagnosticOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_options.rb#8
  def initialize(inter_file_dependencies:, workspace_diagnostics:, work_done_progress: T.unsafe(nil), identifier: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_options.rb#52
  def attributes; end

  # An optional identifier under which the diagnostics are
  # managed by the client.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_options.rb#29
  def identifier; end

  # Whether the language has inter file dependencies meaning that
  # editing code in one file can result in a different diagnostic
  # set in another file. Inter file dependencies are common for
  # most programming languages and typically uncommon for linters.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_options.rb#40
  def inter_file_dependencies; end

  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_options.rb#54
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_options.rb#58
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_options.rb#20
  def work_done_progress; end

  # The server provides support for workspace diagnostics as well.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_options.rb#48
  def workspace_diagnostics; end
end

# Diagnostic registration options.
#
# source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_registration_options.rb#7
class LanguageServer::Protocol::Interface::DiagnosticRegistrationOptions
  # @return [DiagnosticRegistrationOptions] a new instance of DiagnosticRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_registration_options.rb#8
  def initialize(document_selector:, inter_file_dependencies:, workspace_diagnostics:, work_done_progress: T.unsafe(nil), identifier: T.unsafe(nil), id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_registration_options.rb#72
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_registration_options.rb#26
  def document_selector; end

  # The id used to register the request. The id can be used to deregister
  # the request again. See also Registration#id.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_registration_options.rb#68
  def id; end

  # An optional identifier under which the diagnostics are
  # managed by the client.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_registration_options.rb#40
  def identifier; end

  # Whether the language has inter file dependencies meaning that
  # editing code in one file can result in a different diagnostic
  # set in another file. Inter file dependencies are common for
  # most programming languages and typically uncommon for linters.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_registration_options.rb#51
  def inter_file_dependencies; end

  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_registration_options.rb#74
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_registration_options.rb#78
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_registration_options.rb#31
  def work_done_progress; end

  # The server provides support for workspace diagnostics as well.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_registration_options.rb#59
  def workspace_diagnostics; end
end

# Represents a related message and source code location for a diagnostic.
# This should be used to point to code locations that cause or are related to
# a diagnostics, e.g when duplicating a symbol in a scope.
#
# source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_related_information.rb#9
class LanguageServer::Protocol::Interface::DiagnosticRelatedInformation
  # @return [DiagnosticRelatedInformation] a new instance of DiagnosticRelatedInformation
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_related_information.rb#10
  def initialize(location:, message:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_related_information.rb#35
  def attributes; end

  # The location of this related diagnostic information.
  #
  # @return [Location]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_related_information.rb#23
  def location; end

  # The message of this related diagnostic information.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_related_information.rb#31
  def message; end

  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_related_information.rb#37
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_related_information.rb#41
  def to_json(*args); end
end

# Cancellation data returned from a diagnostic request.
#
# source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_server_cancellation_data.rb#7
class LanguageServer::Protocol::Interface::DiagnosticServerCancellationData
  # @return [DiagnosticServerCancellationData] a new instance of DiagnosticServerCancellationData
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_server_cancellation_data.rb#8
  def initialize(retrigger_request:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_server_cancellation_data.rb#21
  def attributes; end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_server_cancellation_data.rb#17
  def retrigger_request; end

  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_server_cancellation_data.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_server_cancellation_data.rb#27
  def to_json(*args); end
end

# Workspace client capabilities specific to diagnostic pull requests.
#
# source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_workspace_client_capabilities.rb#7
class LanguageServer::Protocol::Interface::DiagnosticWorkspaceClientCapabilities
  # @return [DiagnosticWorkspaceClientCapabilities] a new instance of DiagnosticWorkspaceClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_workspace_client_capabilities.rb#8
  def initialize(refresh_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_workspace_client_capabilities.rb#30
  def attributes; end

  # Whether the client implementation supports a refresh request sent from
  # the server to the client.
  #
  # Note that this event is global and will force the client to refresh all
  # pulled diagnostics currently shown. It should be used with absolute care
  # and is useful for situation where a server for example detects a project
  # wide change that requires such a calculation.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_workspace_client_capabilities.rb#26
  def refresh_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_workspace_client_capabilities.rb#32
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/diagnostic_workspace_client_capabilities.rb#36
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/did_change_configuration_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::DidChangeConfigurationClientCapabilities
  # @return [DidChangeConfigurationClientCapabilities] a new instance of DidChangeConfigurationClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_configuration_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_configuration_client_capabilities.rb#21
  def attributes; end

  # Did change configuration notification supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_configuration_client_capabilities.rb#17
  def dynamic_registration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_configuration_client_capabilities.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_configuration_client_capabilities.rb#27
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/did_change_configuration_params.rb#4
class LanguageServer::Protocol::Interface::DidChangeConfigurationParams
  # @return [DidChangeConfigurationParams] a new instance of DidChangeConfigurationParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_configuration_params.rb#5
  def initialize(settings:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_configuration_params.rb#21
  def attributes; end

  # The actual changed settings
  #
  # @return [LSPAny]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_configuration_params.rb#17
  def settings; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_configuration_params.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_configuration_params.rb#27
  def to_json(*args); end
end

# The params sent in a change notebook document notification.
#
# source://language_server-protocol//lib/language_server/protocol/interface/did_change_notebook_document_params.rb#7
class LanguageServer::Protocol::Interface::DidChangeNotebookDocumentParams
  # @return [DidChangeNotebookDocumentParams] a new instance of DidChangeNotebookDocumentParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_notebook_document_params.rb#8
  def initialize(notebook_document:, change:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_notebook_document_params.rb#44
  def attributes; end

  # The actual changes to the notebook document.
  #
  # The change describes single state change to the notebook document.
  # So it moves a notebook document, its cells and its cell text document
  # contents from state S to S'.
  #
  # To mirror the content of a notebook using change events use the
  # following approach:
  # - start with the same initial content
  # - apply the 'notebookDocument/didChange' notifications in the order
  # you receive them.
  #
  # @return [NotebookDocumentChangeEvent]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_notebook_document_params.rb#40
  def change; end

  # The notebook document that did change. The version number points
  # to the version after all provided changes have been applied.
  #
  # @return [VersionedNotebookDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_notebook_document_params.rb#22
  def notebook_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_notebook_document_params.rb#46
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_notebook_document_params.rb#50
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/did_change_text_document_params.rb#4
class LanguageServer::Protocol::Interface::DidChangeTextDocumentParams
  # @return [DidChangeTextDocumentParams] a new instance of DidChangeTextDocumentParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_text_document_params.rb#5
  def initialize(text_document:, content_changes:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_text_document_params.rb#44
  def attributes; end

  # The actual content changes. The content changes describe single state
  # changes to the document. So if there are two content changes c1 (at
  # array index 0) and c2 (at array index 1) for a document in state S then
  # c1 moves the document from S to S' and c2 from S' to S''. So c1 is
  # computed on the state S and c2 is computed on the state S'.
  #
  # To mirror the content of a document using change events use the following
  # approach:
  # - start with the same initial content
  # - apply the 'textDocument/didChange' notifications in the order you
  # receive them.
  # - apply the `TextDocumentContentChangeEvent`s in a single notification
  # in the order you receive them.
  #
  # @return [TextDocumentContentChangeEvent[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_text_document_params.rb#40
  def content_changes; end

  # The document that did change. The version number points
  # to the version after all provided content changes have
  # been applied.
  #
  # @return [VersionedTextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_text_document_params.rb#20
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_text_document_params.rb#46
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_text_document_params.rb#50
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::DidChangeWatchedFilesClientCapabilities
  # @return [DidChangeWatchedFilesClientCapabilities] a new instance of DidChangeWatchedFilesClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil), relative_pattern_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_client_capabilities.rb#33
  def attributes; end

  # Did change watched files notification supports dynamic registration.
  # Please note that the current protocol doesn't support static
  # configuration for file changes from the server side.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_client_capabilities.rb#20
  def dynamic_registration; end

  # Whether the client has support for relative patterns
  # or not.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_client_capabilities.rb#29
  def relative_pattern_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_client_capabilities.rb#35
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_client_capabilities.rb#39
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_params.rb#4
class LanguageServer::Protocol::Interface::DidChangeWatchedFilesParams
  # @return [DidChangeWatchedFilesParams] a new instance of DidChangeWatchedFilesParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_params.rb#5
  def initialize(changes:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_params.rb#21
  def attributes; end

  # The actual file events.
  #
  # @return [FileEvent[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_params.rb#17
  def changes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_params.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_params.rb#27
  def to_json(*args); end
end

# Describe options to be used when registering for file system change events.
#
# source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_registration_options.rb#7
class LanguageServer::Protocol::Interface::DidChangeWatchedFilesRegistrationOptions
  # @return [DidChangeWatchedFilesRegistrationOptions] a new instance of DidChangeWatchedFilesRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_registration_options.rb#8
  def initialize(watchers:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_registration_options.rb#24
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_registration_options.rb#26
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_registration_options.rb#30
  def to_json(*args); end

  # The watchers to register.
  #
  # @return [FileSystemWatcher[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_watched_files_registration_options.rb#20
  def watchers; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/did_change_workspace_folders_params.rb#4
class LanguageServer::Protocol::Interface::DidChangeWorkspaceFoldersParams
  # @return [DidChangeWorkspaceFoldersParams] a new instance of DidChangeWorkspaceFoldersParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_workspace_folders_params.rb#5
  def initialize(event:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_workspace_folders_params.rb#21
  def attributes; end

  # The actual workspace folder change event.
  #
  # @return [WorkspaceFoldersChangeEvent]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_workspace_folders_params.rb#17
  def event; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_workspace_folders_params.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_change_workspace_folders_params.rb#27
  def to_json(*args); end
end

# The params sent in a close notebook document notification.
#
# source://language_server-protocol//lib/language_server/protocol/interface/did_close_notebook_document_params.rb#7
class LanguageServer::Protocol::Interface::DidCloseNotebookDocumentParams
  # @return [DidCloseNotebookDocumentParams] a new instance of DidCloseNotebookDocumentParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_close_notebook_document_params.rb#8
  def initialize(notebook_document:, cell_text_documents:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_close_notebook_document_params.rb#34
  def attributes; end

  # The text documents that represent the content
  # of a notebook cell that got closed.
  #
  # @return [TextDocumentIdentifier[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_close_notebook_document_params.rb#30
  def cell_text_documents; end

  # The notebook document that got closed.
  #
  # @return [NotebookDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_close_notebook_document_params.rb#21
  def notebook_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_close_notebook_document_params.rb#36
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_close_notebook_document_params.rb#40
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/did_close_text_document_params.rb#4
class LanguageServer::Protocol::Interface::DidCloseTextDocumentParams
  # @return [DidCloseTextDocumentParams] a new instance of DidCloseTextDocumentParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_close_text_document_params.rb#5
  def initialize(text_document:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_close_text_document_params.rb#21
  def attributes; end

  # The document that was closed.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_close_text_document_params.rb#17
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_close_text_document_params.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_close_text_document_params.rb#27
  def to_json(*args); end
end

# The params sent in an open notebook document notification.
#
# source://language_server-protocol//lib/language_server/protocol/interface/did_open_notebook_document_params.rb#7
class LanguageServer::Protocol::Interface::DidOpenNotebookDocumentParams
  # @return [DidOpenNotebookDocumentParams] a new instance of DidOpenNotebookDocumentParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_open_notebook_document_params.rb#8
  def initialize(notebook_document:, cell_text_documents:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_open_notebook_document_params.rb#34
  def attributes; end

  # The text documents that represent the content
  # of a notebook cell.
  #
  # @return [TextDocumentItem[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_open_notebook_document_params.rb#30
  def cell_text_documents; end

  # The notebook document that got opened.
  #
  # @return [NotebookDocument]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_open_notebook_document_params.rb#21
  def notebook_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_open_notebook_document_params.rb#36
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_open_notebook_document_params.rb#40
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/did_open_text_document_params.rb#4
class LanguageServer::Protocol::Interface::DidOpenTextDocumentParams
  # @return [DidOpenTextDocumentParams] a new instance of DidOpenTextDocumentParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_open_text_document_params.rb#5
  def initialize(text_document:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_open_text_document_params.rb#21
  def attributes; end

  # The document that was opened.
  #
  # @return [TextDocumentItem]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_open_text_document_params.rb#17
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_open_text_document_params.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_open_text_document_params.rb#27
  def to_json(*args); end
end

# The params sent in a save notebook document notification.
#
# source://language_server-protocol//lib/language_server/protocol/interface/did_save_notebook_document_params.rb#7
class LanguageServer::Protocol::Interface::DidSaveNotebookDocumentParams
  # @return [DidSaveNotebookDocumentParams] a new instance of DidSaveNotebookDocumentParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_save_notebook_document_params.rb#8
  def initialize(notebook_document:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_save_notebook_document_params.rb#24
  def attributes; end

  # The notebook document that got saved.
  #
  # @return [NotebookDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_save_notebook_document_params.rb#20
  def notebook_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_save_notebook_document_params.rb#26
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_save_notebook_document_params.rb#30
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/did_save_text_document_params.rb#4
class LanguageServer::Protocol::Interface::DidSaveTextDocumentParams
  # @return [DidSaveTextDocumentParams] a new instance of DidSaveTextDocumentParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_save_text_document_params.rb#5
  def initialize(text_document:, text: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_save_text_document_params.rb#31
  def attributes; end

  # Optional the content when saved. Depends on the includeText value
  # when the save notification was requested.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_save_text_document_params.rb#27
  def text; end

  # The document that was saved.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/did_save_text_document_params.rb#18
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_save_text_document_params.rb#33
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/did_save_text_document_params.rb#37
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_color_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::DocumentColorClientCapabilities
  # @return [DocumentColorClientCapabilities] a new instance of DocumentColorClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_client_capabilities.rb#21
  def attributes; end

  # Whether document color supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_client_capabilities.rb#17
  def dynamic_registration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_client_capabilities.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_client_capabilities.rb#27
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_color_options.rb#4
class LanguageServer::Protocol::Interface::DocumentColorOptions
  # @return [DocumentColorOptions] a new instance of DocumentColorOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_options.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_options.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_options.rb#24
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_options.rb#14
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_color_params.rb#4
class LanguageServer::Protocol::Interface::DocumentColorParams
  # @return [DocumentColorParams] a new instance of DocumentColorParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_params.rb#5
  def initialize(text_document:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_params.rb#40
  def attributes; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_params.rb#28
  def partial_result_token; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_params.rb#36
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_params.rb#42
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_params.rb#46
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_params.rb#19
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_color_registration_options.rb#4
class LanguageServer::Protocol::Interface::DocumentColorRegistrationOptions
  # @return [DocumentColorRegistrationOptions] a new instance of DocumentColorRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_registration_options.rb#5
  def initialize(document_selector:, id: T.unsafe(nil), work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_registration_options.rb#38
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_registration_options.rb#20
  def document_selector; end

  # The id used to register the request. The id can be used to deregister
  # the request again. See also Registration#id.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_registration_options.rb#29
  def id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_registration_options.rb#40
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_registration_options.rb#44
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_color_registration_options.rb#34
  def work_done_progress; end
end

# Parameters of the document diagnostic request.
#
# source://language_server-protocol//lib/language_server/protocol/interface/document_diagnostic_params.rb#7
class LanguageServer::Protocol::Interface::DocumentDiagnosticParams
  # @return [DocumentDiagnosticParams] a new instance of DocumentDiagnosticParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_diagnostic_params.rb#8
  def initialize(text_document:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil), identifier: T.unsafe(nil), previous_result_id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_diagnostic_params.rb#61
  def attributes; end

  # The additional identifier  provided during registration.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_diagnostic_params.rb#49
  def identifier; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_diagnostic_params.rb#33
  def partial_result_token; end

  # The result id of a previous response if provided.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_diagnostic_params.rb#57
  def previous_result_id; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_diagnostic_params.rb#41
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_diagnostic_params.rb#63
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_diagnostic_params.rb#67
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_diagnostic_params.rb#24
  def work_done_token; end
end

# A partial result for a document diagnostic report.
#
# source://language_server-protocol//lib/language_server/protocol/interface/document_diagnostic_report_partial_result.rb#7
class LanguageServer::Protocol::Interface::DocumentDiagnosticReportPartialResult
  # @return [DocumentDiagnosticReportPartialResult] a new instance of DocumentDiagnosticReportPartialResult
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_diagnostic_report_partial_result.rb#8
  def initialize(related_documents:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_diagnostic_report_partial_result.rb#21
  def attributes; end

  # @return [{ [uri: string]: FullDocumentDiagnosticReport | UnchangedDocumentDiagnosticReport; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_diagnostic_report_partial_result.rb#17
  def related_documents; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_diagnostic_report_partial_result.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_diagnostic_report_partial_result.rb#27
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_filter.rb#4
class LanguageServer::Protocol::Interface::DocumentFilter
  # @return [DocumentFilter] a new instance of DocumentFilter
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_filter.rb#5
  def initialize(language: T.unsafe(nil), scheme: T.unsafe(nil), pattern: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_filter.rb#51
  def attributes; end

  # A language id, like `typescript`.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_filter.rb#19
  def language; end

  # A glob pattern, like `*.{ts,js}`.
  #
  # Glob patterns can have the following syntax:
  # - `*` to match one or more characters in a path segment
  # - `?` to match on one character in a path segment
  # - `**` to match any number of path segments, including none
  # - `{}` to group sub patterns into an OR expression. (e.g. `**​/*.{ts,js}`
  # matches all TypeScript and JavaScript files)
  # - `[]` to declare a range of characters to match in a path segment
  # (e.g., `example.[0-9]` to match on `example.0`, `example.1`, …)
  # - `[!...]` to negate a range of characters to match in a path segment
  # (e.g., `example.[!0-9]` to match on `example.a`, `example.b`, but
  # not `example.0`)
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_filter.rb#47
  def pattern; end

  # A Uri [scheme](#Uri.scheme), like `file` or `untitled`.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_filter.rb#27
  def scheme; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_filter.rb#53
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_filter.rb#57
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::DocumentFormattingClientCapabilities
  # @return [DocumentFormattingClientCapabilities] a new instance of DocumentFormattingClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_client_capabilities.rb#21
  def attributes; end

  # Whether formatting supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_client_capabilities.rb#17
  def dynamic_registration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_client_capabilities.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_client_capabilities.rb#27
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_options.rb#4
class LanguageServer::Protocol::Interface::DocumentFormattingOptions
  # @return [DocumentFormattingOptions] a new instance of DocumentFormattingOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_options.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_options.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_options.rb#24
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_options.rb#14
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_params.rb#4
class LanguageServer::Protocol::Interface::DocumentFormattingParams
  # @return [DocumentFormattingParams] a new instance of DocumentFormattingParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_params.rb#5
  def initialize(text_document:, options:, work_done_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_params.rb#39
  def attributes; end

  # The format options.
  #
  # @return [FormattingOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_params.rb#35
  def options; end

  # The document to format.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_params.rb#27
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_params.rb#41
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_params.rb#45
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_params.rb#19
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_registration_options.rb#4
class LanguageServer::Protocol::Interface::DocumentFormattingRegistrationOptions
  # @return [DocumentFormattingRegistrationOptions] a new instance of DocumentFormattingRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_registration_options.rb#28
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_registration_options.rb#19
  def document_selector; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_registration_options.rb#30
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_registration_options.rb#34
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_formatting_registration_options.rb#24
  def work_done_progress; end
end

# A document highlight is a range inside a text document which deserves
# special attention. Usually a document highlight is visualized by changing
# the background color of its range.
#
# source://language_server-protocol//lib/language_server/protocol/interface/document_highlight.rb#9
class LanguageServer::Protocol::Interface::DocumentHighlight
  # @return [DocumentHighlight] a new instance of DocumentHighlight
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight.rb#10
  def initialize(range:, kind: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight.rb#35
  def attributes; end

  # The highlight kind, default is DocumentHighlightKind.Text.
  #
  # @return [DocumentHighlightKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight.rb#31
  def kind; end

  # The range this highlight applies to.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight.rb#23
  def range; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight.rb#37
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight.rb#41
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::DocumentHighlightClientCapabilities
  # @return [DocumentHighlightClientCapabilities] a new instance of DocumentHighlightClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_client_capabilities.rb#21
  def attributes; end

  # Whether document highlight supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_client_capabilities.rb#17
  def dynamic_registration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_client_capabilities.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_client_capabilities.rb#27
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_options.rb#4
class LanguageServer::Protocol::Interface::DocumentHighlightOptions
  # @return [DocumentHighlightOptions] a new instance of DocumentHighlightOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_options.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_options.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_options.rb#24
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_options.rb#14
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_params.rb#4
class LanguageServer::Protocol::Interface::DocumentHighlightParams
  # @return [DocumentHighlightParams] a new instance of DocumentHighlightParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_params.rb#5
  def initialize(text_document:, position:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_params.rb#49
  def attributes; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_params.rb#45
  def partial_result_token; end

  # The position inside the text document.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_params.rb#28
  def position; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_params.rb#20
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_params.rb#51
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_params.rb#55
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_params.rb#36
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_registration_options.rb#4
class LanguageServer::Protocol::Interface::DocumentHighlightRegistrationOptions
  # @return [DocumentHighlightRegistrationOptions] a new instance of DocumentHighlightRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_registration_options.rb#28
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_registration_options.rb#19
  def document_selector; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_registration_options.rb#30
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_registration_options.rb#34
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_highlight_registration_options.rb#24
  def work_done_progress; end
end

# A document link is a range in a text document that links to an internal or
# external resource, like another text document or a web site.
#
# source://language_server-protocol//lib/language_server/protocol/interface/document_link.rb#8
class LanguageServer::Protocol::Interface::DocumentLink
  # @return [DocumentLink] a new instance of DocumentLink
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link.rb#9
  def initialize(range:, target: T.unsafe(nil), tooltip: T.unsafe(nil), data: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link.rb#58
  def attributes; end

  # A data entry field that is preserved on a document link between a
  # DocumentLinkRequest and a DocumentLinkResolveRequest.
  #
  # @return [LSPAny]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link.rb#54
  def data; end

  # The range this link applies to.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link.rb#24
  def range; end

  # The uri this link points to. If missing a resolve request is sent later.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link.rb#32
  def target; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_link.rb#60
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_link.rb#64
  def to_json(*args); end

  # The tooltip text when you hover over this link.
  #
  # If a tooltip is provided, is will be displayed in a string that includes
  # instructions on how to trigger the link, such as `{0} (ctrl + click)`.
  # The specific instructions vary depending on OS, user settings, and
  # localization.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link.rb#45
  def tooltip; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_link_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::DocumentLinkClientCapabilities
  # @return [DocumentLinkClientCapabilities] a new instance of DocumentLinkClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil), tooltip_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_client_capabilities.rb#30
  def attributes; end

  # Whether document link supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_client_capabilities.rb#18
  def dynamic_registration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_client_capabilities.rb#32
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_client_capabilities.rb#36
  def to_json(*args); end

  # Whether the client supports the `tooltip` property on `DocumentLink`.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_client_capabilities.rb#26
  def tooltip_support; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_link_options.rb#4
class LanguageServer::Protocol::Interface::DocumentLinkOptions
  # @return [DocumentLinkOptions] a new instance of DocumentLinkOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil), resolve_provider: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_options.rb#27
  def attributes; end

  # Document links have a resolve provider as well.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_options.rb#23
  def resolve_provider; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_options.rb#29
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_options.rb#33
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_options.rb#15
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_link_params.rb#4
class LanguageServer::Protocol::Interface::DocumentLinkParams
  # @return [DocumentLinkParams] a new instance of DocumentLinkParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_params.rb#5
  def initialize(text_document:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_params.rb#40
  def attributes; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_params.rb#28
  def partial_result_token; end

  # The document to provide document links for.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_params.rb#36
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_params.rb#42
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_params.rb#46
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_params.rb#19
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_link_registration_options.rb#4
class LanguageServer::Protocol::Interface::DocumentLinkRegistrationOptions
  # @return [DocumentLinkRegistrationOptions] a new instance of DocumentLinkRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil), resolve_provider: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_registration_options.rb#37
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_registration_options.rb#20
  def document_selector; end

  # Document links have a resolve provider as well.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_registration_options.rb#33
  def resolve_provider; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_registration_options.rb#39
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_registration_options.rb#43
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_link_registration_options.rb#25
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::DocumentOnTypeFormattingClientCapabilities
  # @return [DocumentOnTypeFormattingClientCapabilities] a new instance of DocumentOnTypeFormattingClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_client_capabilities.rb#21
  def attributes; end

  # Whether on type formatting supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_client_capabilities.rb#17
  def dynamic_registration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_client_capabilities.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_client_capabilities.rb#27
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_options.rb#4
class LanguageServer::Protocol::Interface::DocumentOnTypeFormattingOptions
  # @return [DocumentOnTypeFormattingOptions] a new instance of DocumentOnTypeFormattingOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_options.rb#5
  def initialize(first_trigger_character:, more_trigger_character: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_options.rb#30
  def attributes; end

  # A character on which formatting should be triggered, like `{`.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_options.rb#18
  def first_trigger_character; end

  # More trigger characters.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_options.rb#26
  def more_trigger_character; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_options.rb#32
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_options.rb#36
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_params.rb#4
class LanguageServer::Protocol::Interface::DocumentOnTypeFormattingParams
  # @return [DocumentOnTypeFormattingParams] a new instance of DocumentOnTypeFormattingParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_params.rb#5
  def initialize(text_document:, position:, ch:, options:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_params.rb#53
  def attributes; end

  # The character that has been typed that triggered the formatting
  # on type request. That is not necessarily the last character that
  # got inserted into the document since the client could auto insert
  # characters as well (e.g. like automatic brace completion).
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_params.rb#41
  def ch; end

  # The formatting options.
  #
  # @return [FormattingOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_params.rb#49
  def options; end

  # The position around which the on type formatting should happen.
  # This is not necessarily the exact position where the character denoted
  # by the property `ch` got typed.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_params.rb#30
  def position; end

  # The document to format.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_params.rb#20
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_params.rb#55
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_params.rb#59
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_registration_options.rb#4
class LanguageServer::Protocol::Interface::DocumentOnTypeFormattingRegistrationOptions
  # @return [DocumentOnTypeFormattingRegistrationOptions] a new instance of DocumentOnTypeFormattingRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_registration_options.rb#5
  def initialize(document_selector:, first_trigger_character:, more_trigger_character: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_registration_options.rb#40
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_registration_options.rb#20
  def document_selector; end

  # A character on which formatting should be triggered, like `{`.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_registration_options.rb#28
  def first_trigger_character; end

  # More trigger characters.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_registration_options.rb#36
  def more_trigger_character; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_registration_options.rb#42
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_on_type_formatting_registration_options.rb#46
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::DocumentRangeFormattingClientCapabilities
  # @return [DocumentRangeFormattingClientCapabilities] a new instance of DocumentRangeFormattingClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_client_capabilities.rb#21
  def attributes; end

  # Whether formatting supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_client_capabilities.rb#17
  def dynamic_registration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_client_capabilities.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_client_capabilities.rb#27
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_options.rb#4
class LanguageServer::Protocol::Interface::DocumentRangeFormattingOptions
  # @return [DocumentRangeFormattingOptions] a new instance of DocumentRangeFormattingOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_options.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_options.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_options.rb#24
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_options.rb#14
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_params.rb#4
class LanguageServer::Protocol::Interface::DocumentRangeFormattingParams
  # @return [DocumentRangeFormattingParams] a new instance of DocumentRangeFormattingParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_params.rb#5
  def initialize(text_document:, range:, options:, work_done_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_params.rb#48
  def attributes; end

  # The format options
  #
  # @return [FormattingOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_params.rb#44
  def options; end

  # The range to format
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_params.rb#36
  def range; end

  # The document to format.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_params.rb#28
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_params.rb#50
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_params.rb#54
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_params.rb#20
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_registration_options.rb#4
class LanguageServer::Protocol::Interface::DocumentRangeFormattingRegistrationOptions
  # @return [DocumentRangeFormattingRegistrationOptions] a new instance of DocumentRangeFormattingRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_registration_options.rb#28
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_registration_options.rb#19
  def document_selector; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_registration_options.rb#30
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_registration_options.rb#34
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_range_formatting_registration_options.rb#24
  def work_done_progress; end
end

# Represents programming constructs like variables, classes, interfaces etc.
# that appear in a document. Document symbols can be hierarchical and they
# have two ranges: one that encloses its definition and one that points to its
# most interesting range, e.g. the range of an identifier.
#
# source://language_server-protocol//lib/language_server/protocol/interface/document_symbol.rb#10
class LanguageServer::Protocol::Interface::DocumentSymbol
  # @return [DocumentSymbol] a new instance of DocumentSymbol
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol.rb#11
  def initialize(name:, kind:, range:, selection_range:, detail: T.unsafe(nil), tags: T.unsafe(nil), deprecated: T.unsafe(nil), children: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol.rb#96
  def attributes; end

  # Children of this symbol, e.g. properties of a class.
  #
  # @return [DocumentSymbol[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol.rb#92
  def children; end

  # Indicates if this symbol is deprecated.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol.rb#64
  def deprecated; end

  # More detail for this symbol, e.g the signature of a function.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol.rb#40
  def detail; end

  # The kind of this symbol.
  #
  # @return [SymbolKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol.rb#48
  def kind; end

  # The name of this symbol. Will be displayed in the user interface and
  # therefore must not be an empty string or a string only consisting of
  # white spaces.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol.rb#32
  def name; end

  # The range enclosing this symbol not including leading/trailing whitespace
  # but everything else like comments. This information is typically used to
  # determine if the clients cursor is inside the symbol to reveal in the
  # symbol in the UI.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol.rb#75
  def range; end

  # The range that should be selected and revealed when this symbol is being
  # picked, e.g. the name of a function. Must be contained by the `range`.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol.rb#84
  def selection_range; end

  # Tags for this document symbol.
  #
  # @return [1[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol.rb#56
  def tags; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol.rb#98
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol.rb#102
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::DocumentSymbolClientCapabilities
  # @return [DocumentSymbolClientCapabilities] a new instance of DocumentSymbolClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil), symbol_kind: T.unsafe(nil), hierarchical_document_symbol_support: T.unsafe(nil), tag_support: T.unsafe(nil), label_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_client_capabilities.rb#61
  def attributes; end

  # Whether document symbol supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_client_capabilities.rb#21
  def dynamic_registration; end

  # The client supports hierarchical document symbols.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_client_capabilities.rb#38
  def hierarchical_document_symbol_support; end

  # The client supports an additional label presented in the UI when
  # registering a document symbol provider.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_client_capabilities.rb#57
  def label_support; end

  # Specific capabilities for the `SymbolKind` in the
  # `textDocument/documentSymbol` request.
  #
  # @return [{ valueSet?: SymbolKind[]; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_client_capabilities.rb#30
  def symbol_kind; end

  # The client supports tags on `SymbolInformation`. Tags are supported on
  # `DocumentSymbol` if `hierarchicalDocumentSymbolSupport` is set to true.
  # Clients supporting tags have to handle unknown tags gracefully.
  #
  # @return [{ valueSet: 1[]; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_client_capabilities.rb#48
  def tag_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_client_capabilities.rb#63
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_client_capabilities.rb#67
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_options.rb#4
class LanguageServer::Protocol::Interface::DocumentSymbolOptions
  # @return [DocumentSymbolOptions] a new instance of DocumentSymbolOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil), label: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_options.rb#28
  def attributes; end

  # A human-readable string that is shown when multiple outlines trees
  # are shown for the same document.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_options.rb#24
  def label; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_options.rb#30
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_options.rb#34
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_options.rb#15
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_params.rb#4
class LanguageServer::Protocol::Interface::DocumentSymbolParams
  # @return [DocumentSymbolParams] a new instance of DocumentSymbolParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_params.rb#5
  def initialize(text_document:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_params.rb#40
  def attributes; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_params.rb#28
  def partial_result_token; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_params.rb#36
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_params.rb#42
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_params.rb#46
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_params.rb#19
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_registration_options.rb#4
class LanguageServer::Protocol::Interface::DocumentSymbolRegistrationOptions
  # @return [DocumentSymbolRegistrationOptions] a new instance of DocumentSymbolRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil), label: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_registration_options.rb#38
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_registration_options.rb#20
  def document_selector; end

  # A human-readable string that is shown when multiple outlines trees
  # are shown for the same document.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_registration_options.rb#34
  def label; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_registration_options.rb#40
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_registration_options.rb#44
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/document_symbol_registration_options.rb#25
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/execute_command_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::ExecuteCommandClientCapabilities
  # @return [ExecuteCommandClientCapabilities] a new instance of ExecuteCommandClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_client_capabilities.rb#21
  def attributes; end

  # Execute command supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_client_capabilities.rb#17
  def dynamic_registration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_client_capabilities.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_client_capabilities.rb#27
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/execute_command_options.rb#4
class LanguageServer::Protocol::Interface::ExecuteCommandOptions
  # @return [ExecuteCommandOptions] a new instance of ExecuteCommandOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_options.rb#5
  def initialize(commands:, work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_options.rb#27
  def attributes; end

  # The commands to be executed on the server
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_options.rb#23
  def commands; end

  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_options.rb#29
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_options.rb#33
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_options.rb#15
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/execute_command_params.rb#4
class LanguageServer::Protocol::Interface::ExecuteCommandParams
  # @return [ExecuteCommandParams] a new instance of ExecuteCommandParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_params.rb#5
  def initialize(command:, work_done_token: T.unsafe(nil), arguments: T.unsafe(nil)); end

  # Arguments that the command should be invoked with.
  #
  # @return [LSPAny[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_params.rb#35
  def arguments; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_params.rb#39
  def attributes; end

  # The identifier of the actual command handler.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_params.rb#27
  def command; end

  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_params.rb#41
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_params.rb#45
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_params.rb#19
  def work_done_token; end
end

# Execute command registration options.
#
# source://language_server-protocol//lib/language_server/protocol/interface/execute_command_registration_options.rb#7
class LanguageServer::Protocol::Interface::ExecuteCommandRegistrationOptions
  # @return [ExecuteCommandRegistrationOptions] a new instance of ExecuteCommandRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_registration_options.rb#8
  def initialize(commands:, work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_registration_options.rb#30
  def attributes; end

  # The commands to be executed on the server
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_registration_options.rb#26
  def commands; end

  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_registration_options.rb#32
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_registration_options.rb#36
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execute_command_registration_options.rb#18
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/execution_summary.rb#4
class LanguageServer::Protocol::Interface::ExecutionSummary
  # @return [ExecutionSummary] a new instance of ExecutionSummary
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execution_summary.rb#5
  def initialize(execution_order:, success: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execution_summary.rb#33
  def attributes; end

  # A strict monotonically increasing value
  # indicating the execution order of a cell
  # inside a notebook.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execution_summary.rb#20
  def execution_order; end

  # Whether the execution was successful or
  # not if known by the client.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/execution_summary.rb#29
  def success; end

  # source://language_server-protocol//lib/language_server/protocol/interface/execution_summary.rb#35
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/execution_summary.rb#39
  def to_json(*args); end
end

# Represents information on a file/folder create.
#
# source://language_server-protocol//lib/language_server/protocol/interface/file_create.rb#7
class LanguageServer::Protocol::Interface::FileCreate
  # @return [FileCreate] a new instance of FileCreate
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_create.rb#8
  def initialize(uri:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_create.rb#24
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_create.rb#26
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_create.rb#30
  def to_json(*args); end

  # A file:// URI for the location of the file/folder being created.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_create.rb#20
  def uri; end
end

# Represents information on a file/folder delete.
#
# source://language_server-protocol//lib/language_server/protocol/interface/file_delete.rb#7
class LanguageServer::Protocol::Interface::FileDelete
  # @return [FileDelete] a new instance of FileDelete
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_delete.rb#8
  def initialize(uri:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_delete.rb#24
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_delete.rb#26
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_delete.rb#30
  def to_json(*args); end

  # A file:// URI for the location of the file/folder being deleted.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_delete.rb#20
  def uri; end
end

# An event describing a file change.
#
# source://language_server-protocol//lib/language_server/protocol/interface/file_event.rb#7
class LanguageServer::Protocol::Interface::FileEvent
  # @return [FileEvent] a new instance of FileEvent
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_event.rb#8
  def initialize(uri:, type:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_event.rb#33
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_event.rb#35
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_event.rb#39
  def to_json(*args); end

  # The change type.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_event.rb#29
  def type; end

  # The file's URI.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_event.rb#21
  def uri; end
end

# A filter to describe in which file operation requests or notifications
# the server is interested in.
#
# source://language_server-protocol//lib/language_server/protocol/interface/file_operation_filter.rb#8
class LanguageServer::Protocol::Interface::FileOperationFilter
  # @return [FileOperationFilter] a new instance of FileOperationFilter
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_filter.rb#9
  def initialize(pattern:, scheme: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_filter.rb#34
  def attributes; end

  # The actual file operation pattern.
  #
  # @return [FileOperationPattern]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_filter.rb#30
  def pattern; end

  # A Uri like `file` or `untitled`.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_filter.rb#22
  def scheme; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_filter.rb#36
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_filter.rb#40
  def to_json(*args); end
end

# A pattern to describe in which file operation requests or notifications
# the server is interested in.
#
# source://language_server-protocol//lib/language_server/protocol/interface/file_operation_pattern.rb#8
class LanguageServer::Protocol::Interface::FileOperationPattern
  # @return [FileOperationPattern] a new instance of FileOperationPattern
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_pattern.rb#9
  def initialize(glob:, matches: T.unsafe(nil), options: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_pattern.rb#55
  def attributes; end

  # The glob pattern to match. Glob patterns can have the following syntax:
  # - `*` to match one or more characters in a path segment
  # - `?` to match on one character in a path segment
  # - `**` to match any number of path segments, including none
  # - `{}` to group sub patterns into an OR expression. (e.g. `**​/*.{ts,js}`
  # matches all TypeScript and JavaScript files)
  # - `[]` to declare a range of characters to match in a path segment
  # (e.g., `example.[0-9]` to match on `example.0`, `example.1`, …)
  # - `[!...]` to negate a range of characters to match in a path segment
  # (e.g., `example.[!0-9]` to match on `example.a`, `example.b`, but
  # not `example.0`)
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_pattern.rb#33
  def glob; end

  # Whether to match files or folders with this pattern.
  #
  # Matches both if undefined.
  #
  # @return [FileOperationPatternKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_pattern.rb#43
  def matches; end

  # Additional options used during matching.
  #
  # @return [FileOperationPatternOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_pattern.rb#51
  def options; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_pattern.rb#57
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_pattern.rb#61
  def to_json(*args); end
end

# Matching options for the file operation pattern.
#
# source://language_server-protocol//lib/language_server/protocol/interface/file_operation_pattern_options.rb#7
class LanguageServer::Protocol::Interface::FileOperationPatternOptions
  # @return [FileOperationPatternOptions] a new instance of FileOperationPatternOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_pattern_options.rb#8
  def initialize(ignore_case: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_pattern_options.rb#24
  def attributes; end

  # The pattern should be matched ignoring casing.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_pattern_options.rb#20
  def ignore_case; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_pattern_options.rb#26
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_pattern_options.rb#30
  def to_json(*args); end
end

# The options to register for file operations.
#
# source://language_server-protocol//lib/language_server/protocol/interface/file_operation_registration_options.rb#7
class LanguageServer::Protocol::Interface::FileOperationRegistrationOptions
  # @return [FileOperationRegistrationOptions] a new instance of FileOperationRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_registration_options.rb#8
  def initialize(filters:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_registration_options.rb#24
  def attributes; end

  # The actual filters.
  #
  # @return [FileOperationFilter[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_registration_options.rb#20
  def filters; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_registration_options.rb#26
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_operation_registration_options.rb#30
  def to_json(*args); end
end

# Represents information on a file/folder rename.
#
# source://language_server-protocol//lib/language_server/protocol/interface/file_rename.rb#7
class LanguageServer::Protocol::Interface::FileRename
  # @return [FileRename] a new instance of FileRename
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_rename.rb#8
  def initialize(old_uri:, new_uri:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_rename.rb#33
  def attributes; end

  # A file:// URI for the new location of the file/folder being renamed.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_rename.rb#29
  def new_uri; end

  # A file:// URI for the original location of the file/folder being renamed.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_rename.rb#21
  def old_uri; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_rename.rb#35
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_rename.rb#39
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/file_system_watcher.rb#4
class LanguageServer::Protocol::Interface::FileSystemWatcher
  # @return [FileSystemWatcher] a new instance of FileSystemWatcher
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_system_watcher.rb#5
  def initialize(glob_pattern:, kind: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_system_watcher.rb#33
  def attributes; end

  # The glob pattern to watch. See {@link GlobPattern glob pattern}
  # for more detail.
  #
  # @return [GlobPattern]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_system_watcher.rb#19
  def glob_pattern; end

  # The kind of events of interest. If omitted it defaults
  # to WatchKind.Create | WatchKind.Change | WatchKind.Delete
  # which is 7.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/file_system_watcher.rb#29
  def kind; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_system_watcher.rb#35
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/file_system_watcher.rb#39
  def to_json(*args); end
end

# Represents a folding range. To be valid, start and end line must be bigger
# than zero and smaller than the number of lines in the document. Clients
# are free to ignore invalid ranges.
#
# source://language_server-protocol//lib/language_server/protocol/interface/folding_range.rb#9
class LanguageServer::Protocol::Interface::FoldingRange
  # @return [FoldingRange] a new instance of FoldingRange
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range.rb#10
  def initialize(start_line:, end_line:, start_character: T.unsafe(nil), end_character: T.unsafe(nil), kind: T.unsafe(nil), collapsed_text: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range.rb#82
  def attributes; end

  # The text that the client should show when the specified range is
  # collapsed. If not defined or not supported by the client, a default
  # will be chosen by the client.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range.rb#78
  def collapsed_text; end

  # The zero-based character offset before the folded range ends. If not
  # defined, defaults to the length of the end line.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range.rb#57
  def end_character; end

  # The zero-based end line of the range to fold. The folded area ends with
  # the line's last character. To be valid, the end must be zero or larger
  # and smaller than the number of lines in the document.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range.rb#48
  def end_line; end

  # Describes the kind of the folding range such as `comment` or `region`.
  # The kind is used to categorize folding ranges and used by commands like
  # 'Fold all comments'. See [FoldingRangeKind](#FoldingRangeKind) for an
  # enumeration of standardized kinds.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range.rb#68
  def kind; end

  # The zero-based character offset from where the folded range starts. If
  # not defined, defaults to the length of the start line.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range.rb#38
  def start_character; end

  # The zero-based start line of the range to fold. The folded area starts
  # after the line's last character. To be valid, the end must be zero or
  # larger and smaller than the number of lines in the document.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range.rb#29
  def start_line; end

  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range.rb#84
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range.rb#88
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/folding_range_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::FoldingRangeClientCapabilities
  # @return [FoldingRangeClientCapabilities] a new instance of FoldingRangeClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil), range_limit: T.unsafe(nil), line_folding_only: T.unsafe(nil), folding_range_kind: T.unsafe(nil), folding_range: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_client_capabilities.rb#64
  def attributes; end

  # Whether implementation supports dynamic registration for folding range
  # providers. If this is set to `true` the client supports the new
  # `FoldingRangeRegistrationOptions` return value for the corresponding
  # server capability as well.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_client_capabilities.rb#24
  def dynamic_registration; end

  # Specific options for the folding range.
  #
  # @return [{ collapsedText?: boolean; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_client_capabilities.rb#60
  def folding_range; end

  # Specific options for the folding range kind.
  #
  # @return [{ valueSet?: string[]; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_client_capabilities.rb#52
  def folding_range_kind; end

  # If set, the client signals that it only supports folding complete lines.
  # If set, client will ignore specified `startCharacter` and `endCharacter`
  # properties in a FoldingRange.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_client_capabilities.rb#44
  def line_folding_only; end

  # The maximum number of folding ranges that the client prefers to receive
  # per document. The value serves as a hint, servers are free to follow the
  # limit.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_client_capabilities.rb#34
  def range_limit; end

  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_client_capabilities.rb#66
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_client_capabilities.rb#70
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/folding_range_options.rb#4
class LanguageServer::Protocol::Interface::FoldingRangeOptions
  # @return [FoldingRangeOptions] a new instance of FoldingRangeOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_options.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_options.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_options.rb#24
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_options.rb#14
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/folding_range_params.rb#4
class LanguageServer::Protocol::Interface::FoldingRangeParams
  # @return [FoldingRangeParams] a new instance of FoldingRangeParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_params.rb#5
  def initialize(text_document:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_params.rb#40
  def attributes; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_params.rb#28
  def partial_result_token; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_params.rb#36
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_params.rb#42
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_params.rb#46
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_params.rb#19
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/folding_range_registration_options.rb#4
class LanguageServer::Protocol::Interface::FoldingRangeRegistrationOptions
  # @return [FoldingRangeRegistrationOptions] a new instance of FoldingRangeRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil), id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_registration_options.rb#38
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_registration_options.rb#20
  def document_selector; end

  # The id used to register the request. The id can be used to deregister
  # the request again. See also Registration#id.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_registration_options.rb#34
  def id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_registration_options.rb#40
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_registration_options.rb#44
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/folding_range_registration_options.rb#25
  def work_done_progress; end
end

# Value-object describing what options formatting should use.
#
# source://language_server-protocol//lib/language_server/protocol/interface/formatting_options.rb#7
class LanguageServer::Protocol::Interface::FormattingOptions
  # @return [FormattingOptions] a new instance of FormattingOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/formatting_options.rb#8
  def initialize(tab_size:, insert_spaces:, trim_trailing_whitespace: T.unsafe(nil), insert_final_newline: T.unsafe(nil), trim_final_newlines: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/formatting_options.rb#60
  def attributes; end

  # Insert a newline character at the end of the file if one does not exist.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/formatting_options.rb#48
  def insert_final_newline; end

  # Prefer spaces over tabs.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/formatting_options.rb#32
  def insert_spaces; end

  # Size of a tab in spaces.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/formatting_options.rb#24
  def tab_size; end

  # source://language_server-protocol//lib/language_server/protocol/interface/formatting_options.rb#62
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/formatting_options.rb#66
  def to_json(*args); end

  # Trim all newlines after the final newline at the end of the file.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/formatting_options.rb#56
  def trim_final_newlines; end

  # Trim trailing whitespace on a line.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/formatting_options.rb#40
  def trim_trailing_whitespace; end
end

# A diagnostic report with a full set of problems.
#
# source://language_server-protocol//lib/language_server/protocol/interface/full_document_diagnostic_report.rb#7
class LanguageServer::Protocol::Interface::FullDocumentDiagnosticReport
  # @return [FullDocumentDiagnosticReport] a new instance of FullDocumentDiagnosticReport
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/full_document_diagnostic_report.rb#8
  def initialize(kind:, items:, result_id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/full_document_diagnostic_report.rb#44
  def attributes; end

  # The actual items.
  #
  # @return [Diagnostic[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/full_document_diagnostic_report.rb#40
  def items; end

  # A full document diagnostic report.
  #
  # @return [any]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/full_document_diagnostic_report.rb#22
  def kind; end

  # An optional result id. If provided it will
  # be sent on the next diagnostic request for the
  # same document.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/full_document_diagnostic_report.rb#32
  def result_id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/full_document_diagnostic_report.rb#46
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/full_document_diagnostic_report.rb#50
  def to_json(*args); end
end

# The result of a hover request.
#
# source://language_server-protocol//lib/language_server/protocol/interface/hover.rb#7
class LanguageServer::Protocol::Interface::Hover
  # @return [Hover] a new instance of Hover
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover.rb#8
  def initialize(contents:, range: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover.rb#34
  def attributes; end

  # The hover's content
  #
  # @return [MarkupContent | MarkedString | MarkedString[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover.rb#21
  def contents; end

  # An optional range is a range inside a text document
  # that is used to visualize a hover, e.g. by changing the background color.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover.rb#30
  def range; end

  # source://language_server-protocol//lib/language_server/protocol/interface/hover.rb#36
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/hover.rb#40
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/hover_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::HoverClientCapabilities
  # @return [HoverClientCapabilities] a new instance of HoverClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil), content_format: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_client_capabilities.rb#32
  def attributes; end

  # Client supports the follow content formats if the content
  # property refers to a `literal of type MarkupContent`.
  # The order describes the preferred format of the client.
  #
  # @return [MarkupKind[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_client_capabilities.rb#28
  def content_format; end

  # Whether hover supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_client_capabilities.rb#18
  def dynamic_registration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/hover_client_capabilities.rb#34
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/hover_client_capabilities.rb#38
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/hover_options.rb#4
class LanguageServer::Protocol::Interface::HoverOptions
  # @return [HoverOptions] a new instance of HoverOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_options.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/hover_options.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/hover_options.rb#24
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_options.rb#14
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/hover_params.rb#4
class LanguageServer::Protocol::Interface::HoverParams
  # @return [HoverParams] a new instance of HoverParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_params.rb#5
  def initialize(text_document:, position:, work_done_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_params.rb#39
  def attributes; end

  # The position inside the text document.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_params.rb#27
  def position; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_params.rb#19
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/hover_params.rb#41
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/hover_params.rb#45
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_params.rb#35
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/hover_registration_options.rb#4
class LanguageServer::Protocol::Interface::HoverRegistrationOptions
  # @return [HoverRegistrationOptions] a new instance of HoverRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_registration_options.rb#28
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_registration_options.rb#19
  def document_selector; end

  # source://language_server-protocol//lib/language_server/protocol/interface/hover_registration_options.rb#30
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/hover_registration_options.rb#34
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_registration_options.rb#24
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/hover_result.rb#4
class LanguageServer::Protocol::Interface::HoverResult
  # @return [HoverResult] a new instance of HoverResult
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_result.rb#5
  def initialize(value:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_result.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/hover_result.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/hover_result.rb#24
  def to_json(*args); end

  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/hover_result.rb#14
  def value; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/implementation_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::ImplementationClientCapabilities
  # @return [ImplementationClientCapabilities] a new instance of ImplementationClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil), link_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_client_capabilities.rb#32
  def attributes; end

  # Whether implementation supports dynamic registration. If this is set to
  # `true` the client supports the new `ImplementationRegistrationOptions`
  # return value for the corresponding server capability as well.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_client_capabilities.rb#20
  def dynamic_registration; end

  # The client supports additional metadata in the form of definition links.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_client_capabilities.rb#28
  def link_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_client_capabilities.rb#34
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_client_capabilities.rb#38
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/implementation_options.rb#4
class LanguageServer::Protocol::Interface::ImplementationOptions
  # @return [ImplementationOptions] a new instance of ImplementationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_options.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_options.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_options.rb#24
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_options.rb#14
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/implementation_params.rb#4
class LanguageServer::Protocol::Interface::ImplementationParams
  # @return [ImplementationParams] a new instance of ImplementationParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_params.rb#5
  def initialize(text_document:, position:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_params.rb#49
  def attributes; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_params.rb#45
  def partial_result_token; end

  # The position inside the text document.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_params.rb#28
  def position; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_params.rb#20
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_params.rb#51
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_params.rb#55
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_params.rb#36
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/implementation_registration_options.rb#4
class LanguageServer::Protocol::Interface::ImplementationRegistrationOptions
  # @return [ImplementationRegistrationOptions] a new instance of ImplementationRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil), id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_registration_options.rb#38
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_registration_options.rb#20
  def document_selector; end

  # The id used to register the request. The id can be used to deregister
  # the request again. See also Registration#id.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_registration_options.rb#34
  def id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_registration_options.rb#40
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_registration_options.rb#44
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/implementation_registration_options.rb#25
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/initialize_error.rb#4
class LanguageServer::Protocol::Interface::InitializeError
  # @return [InitializeError] a new instance of InitializeError
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_error.rb#5
  def initialize(retry:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_error.rb#24
  def attributes; end

  # Indicates whether the client execute the following retry logic:
  # (1) show the message provided by the ResponseError to the user
  # (2) user selects retry or cancel
  # (3) if user selected retry the initialize method is sent again.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_error.rb#20
  def retry; end

  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_error.rb#26
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_error.rb#30
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/initialize_params.rb#4
class LanguageServer::Protocol::Interface::InitializeParams
  # @return [InitializeParams] a new instance of InitializeParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_params.rb#5
  def initialize(process_id:, root_uri:, capabilities:, work_done_token: T.unsafe(nil), client_info: T.unsafe(nil), locale: T.unsafe(nil), root_path: T.unsafe(nil), initialization_options: T.unsafe(nil), trace: T.unsafe(nil), workspace_folders: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_params.rb#116
  def attributes; end

  # The capabilities provided by the client (editor or tool)
  #
  # @return [ClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_params.rb#93
  def capabilities; end

  # Information about the client
  #
  # @return [{ name: string; version?: string; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_params.rb#45
  def client_info; end

  # User provided initialization options.
  #
  # @return [LSPAny]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_params.rb#85
  def initialization_options; end

  # The locale the client is currently showing the user interface
  # in. This must not necessarily be the locale of the operating
  # system.
  #
  # Uses IETF language tags as the value's syntax
  # (See https://en.wikipedia.org/wiki/IETF_language_tag)
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_params.rb#58
  def locale; end

  # The process Id of the parent process that started the server. Is null if
  # the process has not been started by another process. If the parent
  # process is not alive then the server should exit (see exit notification)
  # its process.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_params.rb#37
  def process_id; end

  # The rootPath of the workspace. Is null
  # if no folder is open.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_params.rb#67
  def root_path; end

  # The rootUri of the workspace. Is null if no
  # folder is open. If both `rootPath` and `rootUri` are set
  # `rootUri` wins.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_params.rb#77
  def root_uri; end

  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_params.rb#118
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_params.rb#122
  def to_json(*args); end

  # The initial trace setting. If omitted trace is disabled ('off').
  #
  # @return [TraceValue]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_params.rb#101
  def trace; end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_params.rb#26
  def work_done_token; end

  # The workspace folders configured in the client when the server starts.
  # This property is only available if the client supports workspace folders.
  # It can be `null` if the client supports workspace folders but none are
  # configured.
  #
  # @return [WorkspaceFolder[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_params.rb#112
  def workspace_folders; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/initialize_result.rb#4
class LanguageServer::Protocol::Interface::InitializeResult
  # @return [InitializeResult] a new instance of InitializeResult
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_result.rb#5
  def initialize(capabilities:, server_info: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_result.rb#30
  def attributes; end

  # The capabilities the language server provides.
  #
  # @return [ServerCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_result.rb#18
  def capabilities; end

  # Information about the server.
  #
  # @return [{ name: string; version?: string; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_result.rb#26
  def server_info; end

  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_result.rb#32
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/initialize_result.rb#36
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/initialized_params.rb#4
class LanguageServer::Protocol::Interface::InitializedParams
  # @return [InitializedParams] a new instance of InitializedParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialized_params.rb#5
  def initialize; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/initialized_params.rb#12
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/initialized_params.rb#14
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/initialized_params.rb#18
  def to_json(*args); end
end

# Inlay hint information.
#
# source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint.rb#7
class LanguageServer::Protocol::Interface::InlayHint
  # @return [InlayHint] a new instance of InlayHint
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint.rb#8
  def initialize(position:, label:, kind: T.unsafe(nil), text_edits: T.unsafe(nil), tooltip: T.unsafe(nil), padding_left: T.unsafe(nil), padding_right: T.unsafe(nil), data: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint.rb#110
  def attributes; end

  # A data entry field that is preserved on an inlay hint between
  # a `textDocument/inlayHint` and a `inlayHint/resolve` request.
  #
  # @return [LSPAny]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint.rb#106
  def data; end

  # The kind of this hint. Can be omitted in which case the client
  # should fall back to a reasonable default.
  #
  # @return [InlayHintKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint.rb#47
  def kind; end

  # The label of this hint. A human readable string or an array of
  # InlayHintLabelPart label parts.
  #
  # *Note* that neither the string nor the label part can be empty.
  #
  # @return [string | InlayHintLabelPart[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint.rb#38
  def label; end

  # Render padding before the hint.
  #
  # Note: Padding should use the editor's background color, not the
  # background color of the hint itself. That means padding can be used
  # to visually align/separate an inlay hint.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint.rb#85
  def padding_left; end

  # Render padding after the hint.
  #
  # Note: Padding should use the editor's background color, not the
  # background color of the hint itself. That means padding can be used
  # to visually align/separate an inlay hint.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint.rb#97
  def padding_right; end

  # The position of this hint.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint.rb#27
  def position; end

  # Optional text edits that are performed when accepting this inlay hint.
  #
  # *Note* that edits are expected to change the document so that the inlay
  # hint (or its nearest variant) is now part of the document and the inlay
  # hint itself is now obsolete.
  #
  # Depending on the client capability `inlayHint.resolveSupport` clients
  # might resolve this property late using the resolve request.
  #
  # @return [TextEdit[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint.rb#62
  def text_edits; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint.rb#112
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint.rb#116
  def to_json(*args); end

  # The tooltip text when you hover over this item.
  #
  # Depending on the client capability `inlayHint.resolveSupport` clients
  # might resolve this property late using the resolve request.
  #
  # @return [string | MarkupContent]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint.rb#73
  def tooltip; end
end

# Inlay hint client capabilities.
#
# source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_client_capabilities.rb#7
class LanguageServer::Protocol::Interface::InlayHintClientCapabilities
  # @return [InlayHintClientCapabilities] a new instance of InlayHintClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_client_capabilities.rb#8
  def initialize(dynamic_registration: T.unsafe(nil), resolve_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_client_capabilities.rb#34
  def attributes; end

  # Whether inlay hints support dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_client_capabilities.rb#21
  def dynamic_registration; end

  # Indicates which properties a client can resolve lazily on an inlay
  # hint.
  #
  # @return [{ properties: string[]; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_client_capabilities.rb#30
  def resolve_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_client_capabilities.rb#36
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_client_capabilities.rb#40
  def to_json(*args); end
end

# An inlay hint label part allows for interactive and composite labels
# of inlay hints.
#
# source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_label_part.rb#8
class LanguageServer::Protocol::Interface::InlayHintLabelPart
  # @return [InlayHintLabelPart] a new instance of InlayHintLabelPart
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_label_part.rb#9
  def initialize(value:, tooltip: T.unsafe(nil), location: T.unsafe(nil), command: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_label_part.rb#67
  def attributes; end

  # An optional command for this label part.
  #
  # Depending on the client capability `inlayHint.resolveSupport` clients
  # might resolve this property late using the resolve request.
  #
  # @return [Command]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_label_part.rb#63
  def command; end

  # An optional source code location that represents this
  # label part.
  #
  # The editor will use this location for the hover and for code navigation
  # features: This part will become a clickable link that resolves to the
  # definition of the symbol at the given location (not necessarily the
  # location itself), it shows the hover that shows at the given location,
  # and it shows a context menu with further code navigation commands.
  #
  # Depending on the client capability `inlayHint.resolveSupport` clients
  # might resolve this property late using the resolve request.
  #
  # @return [Location]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_label_part.rb#52
  def location; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_label_part.rb#69
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_label_part.rb#73
  def to_json(*args); end

  # The tooltip text when you hover over this label part. Depending on
  # the client capability `inlayHint.resolveSupport` clients might resolve
  # this property late using the resolve request.
  #
  # @return [string | MarkupContent]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_label_part.rb#34
  def tooltip; end

  # The value of this label part.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_label_part.rb#24
  def value; end
end

# Inlay hint options used during static registration.
#
# source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_options.rb#7
class LanguageServer::Protocol::Interface::InlayHintOptions
  # @return [InlayHintOptions] a new instance of InlayHintOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_options.rb#8
  def initialize(work_done_progress: T.unsafe(nil), resolve_provider: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_options.rb#31
  def attributes; end

  # The server provides support to resolve additional
  # information for an inlay hint item.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_options.rb#27
  def resolve_provider; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_options.rb#33
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_options.rb#37
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_options.rb#18
  def work_done_progress; end
end

# A parameter literal used in inlay hint requests.
#
# source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_params.rb#7
class LanguageServer::Protocol::Interface::InlayHintParams
  # @return [InlayHintParams] a new instance of InlayHintParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_params.rb#8
  def initialize(text_document:, range:, work_done_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_params.rb#42
  def attributes; end

  # The visible document range for which inlay hints should be computed.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_params.rb#38
  def range; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_params.rb#30
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_params.rb#44
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_params.rb#48
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_params.rb#22
  def work_done_token; end
end

# Inlay hint options used during static or dynamic registration.
#
# source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_registration_options.rb#7
class LanguageServer::Protocol::Interface::InlayHintRegistrationOptions
  # @return [InlayHintRegistrationOptions] a new instance of InlayHintRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_registration_options.rb#8
  def initialize(document_selector:, work_done_progress: T.unsafe(nil), resolve_provider: T.unsafe(nil), id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_registration_options.rb#51
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_registration_options.rb#38
  def document_selector; end

  # The id used to register the request. The id can be used to deregister
  # the request again. See also Registration#id.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_registration_options.rb#47
  def id; end

  # The server provides support to resolve additional
  # information for an inlay hint item.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_registration_options.rb#29
  def resolve_provider; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_registration_options.rb#53
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_registration_options.rb#57
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_registration_options.rb#20
  def work_done_progress; end
end

# Client workspace capabilities specific to inlay hints.
#
# source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_workspace_client_capabilities.rb#7
class LanguageServer::Protocol::Interface::InlayHintWorkspaceClientCapabilities
  # @return [InlayHintWorkspaceClientCapabilities] a new instance of InlayHintWorkspaceClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_workspace_client_capabilities.rb#8
  def initialize(refresh_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_workspace_client_capabilities.rb#30
  def attributes; end

  # Whether the client implementation supports a refresh request sent from
  # the server to the client.
  #
  # Note that this event is global and will force the client to refresh all
  # inlay hints currently shown. It should be used with absolute care and
  # is useful for situation where a server for example detects a project wide
  # change that requires such a calculation.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_workspace_client_capabilities.rb#26
  def refresh_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_workspace_client_capabilities.rb#32
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inlay_hint_workspace_client_capabilities.rb#36
  def to_json(*args); end
end

# Client capabilities specific to inline values.
#
# source://language_server-protocol//lib/language_server/protocol/interface/inline_value_client_capabilities.rb#7
class LanguageServer::Protocol::Interface::InlineValueClientCapabilities
  # @return [InlineValueClientCapabilities] a new instance of InlineValueClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_client_capabilities.rb#8
  def initialize(dynamic_registration: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_client_capabilities.rb#25
  def attributes; end

  # Whether implementation supports dynamic registration for inline
  # value providers.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_client_capabilities.rb#21
  def dynamic_registration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_client_capabilities.rb#27
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_client_capabilities.rb#31
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/inline_value_context.rb#4
class LanguageServer::Protocol::Interface::InlineValueContext
  # @return [InlineValueContext] a new instance of InlineValueContext
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_context.rb#5
  def initialize(frame_id:, stopped_location:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_context.rb#32
  def attributes; end

  # The stack frame (as a DAP Id) where the execution has stopped.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_context.rb#18
  def frame_id; end

  # The document range where execution has stopped.
  # Typically the end position of the range denotes the line where the
  # inline values are shown.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_context.rb#28
  def stopped_location; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_context.rb#34
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_context.rb#38
  def to_json(*args); end
end

# Provide an inline value through an expression evaluation.
#
# If only a range is specified, the expression will be extracted from the
# underlying document.
#
# An optional expression can be used to override the extracted expression.
#
# source://language_server-protocol//lib/language_server/protocol/interface/inline_value_evaluatable_expression.rb#12
class LanguageServer::Protocol::Interface::InlineValueEvaluatableExpression
  # @return [InlineValueEvaluatableExpression] a new instance of InlineValueEvaluatableExpression
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_evaluatable_expression.rb#13
  def initialize(range:, expression: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_evaluatable_expression.rb#40
  def attributes; end

  # If specified the expression overrides the extracted expression.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_evaluatable_expression.rb#36
  def expression; end

  # The document range for which the inline value applies.
  # The range is used to extract the evaluatable expression from the
  # underlying document.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_evaluatable_expression.rb#28
  def range; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_evaluatable_expression.rb#42
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_evaluatable_expression.rb#46
  def to_json(*args); end
end

# Inline value options used during static registration.
#
# source://language_server-protocol//lib/language_server/protocol/interface/inline_value_options.rb#7
class LanguageServer::Protocol::Interface::InlineValueOptions
  # @return [InlineValueOptions] a new instance of InlineValueOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_options.rb#8
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_options.rb#21
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_options.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_options.rb#27
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_options.rb#17
  def work_done_progress; end
end

# A parameter literal used in inline value requests.
#
# source://language_server-protocol//lib/language_server/protocol/interface/inline_value_params.rb#7
class LanguageServer::Protocol::Interface::InlineValueParams
  # @return [InlineValueParams] a new instance of InlineValueParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_params.rb#8
  def initialize(text_document:, range:, context:, work_done_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_params.rb#52
  def attributes; end

  # Additional information about the context in which inline values were
  # requested.
  #
  # @return [InlineValueContext]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_params.rb#48
  def context; end

  # The document range for which inline values should be computed.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_params.rb#39
  def range; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_params.rb#31
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_params.rb#54
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_params.rb#58
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_params.rb#23
  def work_done_token; end
end

# Inline value options used during static or dynamic registration.
#
# source://language_server-protocol//lib/language_server/protocol/interface/inline_value_registration_options.rb#7
class LanguageServer::Protocol::Interface::InlineValueRegistrationOptions
  # @return [InlineValueRegistrationOptions] a new instance of InlineValueRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_registration_options.rb#8
  def initialize(document_selector:, work_done_progress: T.unsafe(nil), id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_registration_options.rb#41
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_registration_options.rb#28
  def document_selector; end

  # The id used to register the request. The id can be used to deregister
  # the request again. See also Registration#id.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_registration_options.rb#37
  def id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_registration_options.rb#43
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_registration_options.rb#47
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_registration_options.rb#19
  def work_done_progress; end
end

# Provide inline value as text.
#
# source://language_server-protocol//lib/language_server/protocol/interface/inline_value_text.rb#7
class LanguageServer::Protocol::Interface::InlineValueText
  # @return [InlineValueText] a new instance of InlineValueText
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_text.rb#8
  def initialize(range:, text:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_text.rb#33
  def attributes; end

  # The document range for which the inline value applies.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_text.rb#21
  def range; end

  # The text of the inline value.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_text.rb#29
  def text; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_text.rb#35
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_text.rb#39
  def to_json(*args); end
end

# Provide inline value through a variable lookup.
#
# If only a range is specified, the variable name will be extracted from
# the underlying document.
#
# An optional variable name can be used to override the extracted name.
#
# source://language_server-protocol//lib/language_server/protocol/interface/inline_value_variable_lookup.rb#12
class LanguageServer::Protocol::Interface::InlineValueVariableLookup
  # @return [InlineValueVariableLookup] a new instance of InlineValueVariableLookup
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_variable_lookup.rb#13
  def initialize(range:, case_sensitive_lookup:, variable_name: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_variable_lookup.rb#49
  def attributes; end

  # How to perform the lookup.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_variable_lookup.rb#45
  def case_sensitive_lookup; end

  # The document range for which the inline value applies.
  # The range is used to extract the variable name from the underlying
  # document.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_variable_lookup.rb#29
  def range; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_variable_lookup.rb#51
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_variable_lookup.rb#55
  def to_json(*args); end

  # If specified the name of the variable to look up.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_variable_lookup.rb#37
  def variable_name; end
end

# Client workspace capabilities specific to inline values.
#
# source://language_server-protocol//lib/language_server/protocol/interface/inline_value_workspace_client_capabilities.rb#7
class LanguageServer::Protocol::Interface::InlineValueWorkspaceClientCapabilities
  # @return [InlineValueWorkspaceClientCapabilities] a new instance of InlineValueWorkspaceClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_workspace_client_capabilities.rb#8
  def initialize(refresh_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_workspace_client_capabilities.rb#30
  def attributes; end

  # Whether the client implementation supports a refresh request sent from
  # the server to the client.
  #
  # Note that this event is global and will force the client to refresh all
  # inline values currently shown. It should be used with absolute care and
  # is useful for situation where a server for example detect a project wide
  # change that requires such a calculation.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_workspace_client_capabilities.rb#26
  def refresh_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_workspace_client_capabilities.rb#32
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/inline_value_workspace_client_capabilities.rb#36
  def to_json(*args); end
end

# A special text edit to provide an insert and a replace operation.
#
# source://language_server-protocol//lib/language_server/protocol/interface/insert_replace_edit.rb#7
class LanguageServer::Protocol::Interface::InsertReplaceEdit
  # @return [InsertReplaceEdit] a new instance of InsertReplaceEdit
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/insert_replace_edit.rb#8
  def initialize(new_text:, insert:, replace:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/insert_replace_edit.rb#42
  def attributes; end

  # The range if the insert is requested
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/insert_replace_edit.rb#30
  def insert; end

  # The string to be inserted.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/insert_replace_edit.rb#22
  def new_text; end

  # The range if the replace is requested.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/insert_replace_edit.rb#38
  def replace; end

  # source://language_server-protocol//lib/language_server/protocol/interface/insert_replace_edit.rb#44
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/insert_replace_edit.rb#48
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::LinkedEditingRangeClientCapabilities
  # @return [LinkedEditingRangeClientCapabilities] a new instance of LinkedEditingRangeClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_client_capabilities.rb#24
  def attributes; end

  # Whether the implementation supports dynamic registration.
  # If this is set to `true` the client supports the new
  # `(TextDocumentRegistrationOptions & StaticRegistrationOptions)`
  # return value for the corresponding server capability as well.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_client_capabilities.rb#20
  def dynamic_registration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_client_capabilities.rb#26
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_client_capabilities.rb#30
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_options.rb#4
class LanguageServer::Protocol::Interface::LinkedEditingRangeOptions
  # @return [LinkedEditingRangeOptions] a new instance of LinkedEditingRangeOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_options.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_options.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_options.rb#24
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_options.rb#14
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_params.rb#4
class LanguageServer::Protocol::Interface::LinkedEditingRangeParams
  # @return [LinkedEditingRangeParams] a new instance of LinkedEditingRangeParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_params.rb#5
  def initialize(text_document:, position:, work_done_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_params.rb#39
  def attributes; end

  # The position inside the text document.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_params.rb#27
  def position; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_params.rb#19
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_params.rb#41
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_params.rb#45
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_params.rb#35
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_registration_options.rb#4
class LanguageServer::Protocol::Interface::LinkedEditingRangeRegistrationOptions
  # @return [LinkedEditingRangeRegistrationOptions] a new instance of LinkedEditingRangeRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil), id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_registration_options.rb#38
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_registration_options.rb#20
  def document_selector; end

  # The id used to register the request. The id can be used to deregister
  # the request again. See also Registration#id.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_registration_options.rb#34
  def id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_registration_options.rb#40
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_registration_options.rb#44
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_range_registration_options.rb#25
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_ranges.rb#4
class LanguageServer::Protocol::Interface::LinkedEditingRanges
  # @return [LinkedEditingRanges] a new instance of LinkedEditingRanges
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_ranges.rb#5
  def initialize(ranges:, word_pattern: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_ranges.rb#34
  def attributes; end

  # A list of ranges that can be renamed together. The ranges must have
  # identical length and contain identical text content. The ranges cannot
  # overlap.
  #
  # @return [Range[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_ranges.rb#20
  def ranges; end

  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_ranges.rb#36
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_ranges.rb#40
  def to_json(*args); end

  # An optional word pattern (regular expression) that describes valid
  # contents for the given ranges. If no pattern is provided, the client
  # configuration's word pattern will be used.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/linked_editing_ranges.rb#30
  def word_pattern; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/location.rb#4
class LanguageServer::Protocol::Interface::Location
  # @return [Location] a new instance of Location
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/location.rb#5
  def initialize(uri:, range:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/location.rb#24
  def attributes; end

  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/location.rb#20
  def range; end

  # source://language_server-protocol//lib/language_server/protocol/interface/location.rb#26
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/location.rb#30
  def to_json(*args); end

  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/location.rb#15
  def uri; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/location_link.rb#4
class LanguageServer::Protocol::Interface::LocationLink
  # @return [LocationLink] a new instance of LocationLink
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/location_link.rb#5
  def initialize(target_uri:, target_range:, target_selection_range:, origin_selection_range: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/location_link.rb#56
  def attributes; end

  # Span of the origin of this link.
  #
  # Used as the underlined span for mouse interaction. Defaults to the word
  # range at the mouse position.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/location_link.rb#23
  def origin_selection_range; end

  # The full target range of this link. If the target for example is a symbol
  # then target range is the range enclosing this symbol not including
  # leading/trailing whitespace but everything else like comments. This
  # information is typically used to highlight the range in the editor.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/location_link.rb#42
  def target_range; end

  # The range that should be selected and revealed when this link is being
  # followed, e.g the name of a function. Must be contained by the
  # `targetRange`. See also `DocumentSymbol#range`
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/location_link.rb#52
  def target_selection_range; end

  # The target resource identifier of this link.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/location_link.rb#31
  def target_uri; end

  # source://language_server-protocol//lib/language_server/protocol/interface/location_link.rb#58
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/location_link.rb#62
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/log_message_params.rb#4
class LanguageServer::Protocol::Interface::LogMessageParams
  # @return [LogMessageParams] a new instance of LogMessageParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/log_message_params.rb#5
  def initialize(type:, message:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/log_message_params.rb#30
  def attributes; end

  # The actual message
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/log_message_params.rb#26
  def message; end

  # source://language_server-protocol//lib/language_server/protocol/interface/log_message_params.rb#32
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/log_message_params.rb#36
  def to_json(*args); end

  # The message type. See {@link MessageType}
  #
  # @return [MessageType]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/log_message_params.rb#18
  def type; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/log_trace_params.rb#4
class LanguageServer::Protocol::Interface::LogTraceParams
  # @return [LogTraceParams] a new instance of LogTraceParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/log_trace_params.rb#5
  def initialize(message:, verbose: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/log_trace_params.rb#31
  def attributes; end

  # The message to be logged.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/log_trace_params.rb#18
  def message; end

  # source://language_server-protocol//lib/language_server/protocol/interface/log_trace_params.rb#33
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/log_trace_params.rb#37
  def to_json(*args); end

  # Additional information that can be computed if the `trace` configuration
  # is set to `'verbose'`
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/log_trace_params.rb#27
  def verbose; end
end

# A `MarkupContent` literal represents a string value which content is
# interpreted base on its kind flag. Currently the protocol supports
# `plaintext` and `markdown` as markup kinds.
#
# If the kind is `markdown` then the value can contain fenced code blocks like
# in GitHub issues.
#
# Here is an example how such a string can be constructed using
# JavaScript / TypeScript:
# ```typescript
# let markdown: MarkdownContent = {
# kind: MarkupKind.Markdown,
# value: [
# '# Header',
# 'Some text',
# '```typescript',
# 'someCode();',
# '```'
# ].join('\n')
# };
# ```
#
# *Please Note* that clients might sanitize the return markdown. A client could
# decide to remove HTML from the markdown to avoid script execution.
#
# source://language_server-protocol//lib/language_server/protocol/interface/markup_content.rb#30
class LanguageServer::Protocol::Interface::MarkupContent
  # @return [MarkupContent] a new instance of MarkupContent
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/markup_content.rb#31
  def initialize(kind:, value:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/markup_content.rb#56
  def attributes; end

  # The type of the Markup
  #
  # @return [MarkupKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/markup_content.rb#44
  def kind; end

  # source://language_server-protocol//lib/language_server/protocol/interface/markup_content.rb#58
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/markup_content.rb#62
  def to_json(*args); end

  # The content itself
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/markup_content.rb#52
  def value; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/message.rb#4
class LanguageServer::Protocol::Interface::Message
  # @return [Message] a new instance of Message
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/message.rb#5
  def initialize(jsonrpc:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/message.rb#18
  def attributes; end

  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/message.rb#14
  def jsonrpc; end

  # source://language_server-protocol//lib/language_server/protocol/interface/message.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/message.rb#24
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/message_action_item.rb#4
class LanguageServer::Protocol::Interface::MessageActionItem
  # @return [MessageActionItem] a new instance of MessageActionItem
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/message_action_item.rb#5
  def initialize(title:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/message_action_item.rb#21
  def attributes; end

  # A short title like 'Retry', 'Open Log' etc.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/message_action_item.rb#17
  def title; end

  # source://language_server-protocol//lib/language_server/protocol/interface/message_action_item.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/message_action_item.rb#27
  def to_json(*args); end
end

# Moniker definition to match LSIF 0.5 moniker definition.
#
# source://language_server-protocol//lib/language_server/protocol/interface/moniker.rb#7
class LanguageServer::Protocol::Interface::Moniker
  # @return [Moniker] a new instance of Moniker
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker.rb#8
  def initialize(scheme:, identifier:, unique:, kind: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker.rb#52
  def attributes; end

  # The identifier of the moniker. The value is opaque in LSIF however
  # schema owners are allowed to define the structure if they want.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker.rb#32
  def identifier; end

  # The moniker kind if known.
  #
  # @return [MonikerKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker.rb#48
  def kind; end

  # The scheme of the moniker. For example tsc or .Net
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker.rb#23
  def scheme; end

  # source://language_server-protocol//lib/language_server/protocol/interface/moniker.rb#54
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/moniker.rb#58
  def to_json(*args); end

  # The scope in which the moniker is unique
  #
  # @return [UniquenessLevel]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker.rb#40
  def unique; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/moniker_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::MonikerClientCapabilities
  # @return [MonikerClientCapabilities] a new instance of MonikerClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_client_capabilities.rb#24
  def attributes; end

  # Whether implementation supports dynamic registration. If this is set to
  # `true` the client supports the new `(TextDocumentRegistrationOptions &
  # StaticRegistrationOptions)` return value for the corresponding server
  # capability as well.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_client_capabilities.rb#20
  def dynamic_registration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_client_capabilities.rb#26
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_client_capabilities.rb#30
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/moniker_options.rb#4
class LanguageServer::Protocol::Interface::MonikerOptions
  # @return [MonikerOptions] a new instance of MonikerOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_options.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_options.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_options.rb#24
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_options.rb#14
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/moniker_params.rb#4
class LanguageServer::Protocol::Interface::MonikerParams
  # @return [MonikerParams] a new instance of MonikerParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_params.rb#5
  def initialize(text_document:, position:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_params.rb#49
  def attributes; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_params.rb#45
  def partial_result_token; end

  # The position inside the text document.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_params.rb#28
  def position; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_params.rb#20
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_params.rb#51
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_params.rb#55
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_params.rb#36
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/moniker_registration_options.rb#4
class LanguageServer::Protocol::Interface::MonikerRegistrationOptions
  # @return [MonikerRegistrationOptions] a new instance of MonikerRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_registration_options.rb#28
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_registration_options.rb#19
  def document_selector; end

  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_registration_options.rb#30
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_registration_options.rb#34
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/moniker_registration_options.rb#24
  def work_done_progress; end
end

# A notebook cell.
#
# A cell's document URI must be unique across ALL notebook
# cells and can therefore be used to uniquely identify a
# notebook cell or the cell's text document.
#
# source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell.rb#11
class LanguageServer::Protocol::Interface::NotebookCell
  # @return [NotebookCell] a new instance of NotebookCell
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell.rb#12
  def initialize(kind:, document:, metadata: T.unsafe(nil), execution_summary: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell.rb#57
  def attributes; end

  # The URI of the cell's text document
  # content.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell.rb#36
  def document; end

  # Additional execution summary information
  # if supported by the client.
  #
  # @return [ExecutionSummary]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell.rb#53
  def execution_summary; end

  # The cell's kind
  #
  # @return [any]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell.rb#27
  def kind; end

  # Additional metadata stored with the cell.
  #
  # @return [LSPObject]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell.rb#44
  def metadata; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell.rb#59
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell.rb#63
  def to_json(*args); end
end

# A change describing how to move a `NotebookCell`
# array from state S to S'.
#
# source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell_array_change.rb#8
class LanguageServer::Protocol::Interface::NotebookCellArrayChange
  # @return [NotebookCellArrayChange] a new instance of NotebookCellArrayChange
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell_array_change.rb#9
  def initialize(start:, delete_count:, cells: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell_array_change.rb#43
  def attributes; end

  # The new cells, if any
  #
  # @return [NotebookCell[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell_array_change.rb#39
  def cells; end

  # The deleted cells
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell_array_change.rb#31
  def delete_count; end

  # The start offset of the cell that changed.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell_array_change.rb#23
  def start; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell_array_change.rb#45
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell_array_change.rb#49
  def to_json(*args); end
end

# A notebook cell text document filter denotes a cell text
# document by different properties.
#
# source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell_text_document_filter.rb#8
class LanguageServer::Protocol::Interface::NotebookCellTextDocumentFilter
  # @return [NotebookCellTextDocumentFilter] a new instance of NotebookCellTextDocumentFilter
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell_text_document_filter.rb#9
  def initialize(notebook:, language: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell_text_document_filter.rb#40
  def attributes; end

  # A language id like `python`.
  #
  # Will be matched against the language id of the
  # notebook cell document. '*' matches every language.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell_text_document_filter.rb#36
  def language; end

  # A filter that matches against the notebook
  # containing the notebook cell. If a string
  # value is provided it matches against the
  # notebook type. '*' matches every notebook.
  #
  # @return [string | NotebookDocumentFilter]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell_text_document_filter.rb#25
  def notebook; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell_text_document_filter.rb#42
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_cell_text_document_filter.rb#46
  def to_json(*args); end
end

# A notebook document.
#
# source://language_server-protocol//lib/language_server/protocol/interface/notebook_document.rb#7
class LanguageServer::Protocol::Interface::NotebookDocument
  # @return [NotebookDocument] a new instance of NotebookDocument
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document.rb#8
  def initialize(uri:, notebook_type:, version:, cells:, metadata: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document.rb#62
  def attributes; end

  # The cells of a notebook.
  #
  # @return [NotebookCell[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document.rb#58
  def cells; end

  # Additional metadata stored with the notebook
  # document.
  #
  # @return [LSPObject]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document.rb#50
  def metadata; end

  # The type of the notebook.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document.rb#32
  def notebook_type; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document.rb#64
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document.rb#68
  def to_json(*args); end

  # The notebook document's URI.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document.rb#24
  def uri; end

  # The version number of this document (it will increase after each
  # change, including undo/redo).
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document.rb#41
  def version; end
end

# A change event for a notebook document.
#
# source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_change_event.rb#7
class LanguageServer::Protocol::Interface::NotebookDocumentChangeEvent
  # @return [NotebookDocumentChangeEvent] a new instance of NotebookDocumentChangeEvent
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_change_event.rb#8
  def initialize(metadata: T.unsafe(nil), cells: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_change_event.rb#33
  def attributes; end

  # Changes to cells
  #
  # @return [{ structure?: { array: NotebookCellArrayChange; didOpen?: TextDocumentItem[]; didClose?: TextDocumentIdentifier[]; }; data?: NotebookCell[]; textContent?: { ...; }[]; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_change_event.rb#29
  def cells; end

  # The changed meta data if any.
  #
  # @return [LSPObject]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_change_event.rb#21
  def metadata; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_change_event.rb#35
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_change_event.rb#39
  def to_json(*args); end
end

# Capabilities specific to the notebook document support.
#
# source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_client_capabilities.rb#7
class LanguageServer::Protocol::Interface::NotebookDocumentClientCapabilities
  # @return [NotebookDocumentClientCapabilities] a new instance of NotebookDocumentClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_client_capabilities.rb#8
  def initialize(synchronization:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_client_capabilities.rb#24
  def attributes; end

  # Capabilities specific to notebook document synchronization
  #
  # @return [NotebookDocumentSyncClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_client_capabilities.rb#20
  def synchronization; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_client_capabilities.rb#26
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_client_capabilities.rb#30
  def to_json(*args); end
end

# A notebook document filter denotes a notebook document by
# different properties.
#
# source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_filter.rb#8
class LanguageServer::Protocol::Interface::NotebookDocumentFilter
  # @return [NotebookDocumentFilter] a new instance of NotebookDocumentFilter
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_filter.rb#9
  def initialize(notebook_type: T.unsafe(nil), scheme: T.unsafe(nil), pattern: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_filter.rb#67
  def attributes; end

  # The type of the enclosing notebook.
  #
  # --- OR ---
  #
  # The type of the enclosing notebook.
  #
  # --- OR ---
  #
  # The type of the enclosing notebook.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_filter.rb#31
  def notebook_type; end

  # A glob pattern.
  #
  # --- OR ---
  #
  # A glob pattern.
  #
  # --- OR ---
  #
  # A glob pattern.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_filter.rb#63
  def pattern; end

  # A Uri [scheme](#Uri.scheme), like `file` or `untitled`.
  #
  # --- OR ---
  #
  # A Uri [scheme](#Uri.scheme), like `file` or `untitled`.
  #
  # --- OR ---
  #
  # A Uri [scheme](#Uri.scheme), like `file` or `untitled`.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_filter.rb#47
  def scheme; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_filter.rb#69
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_filter.rb#73
  def to_json(*args); end
end

# A literal to identify a notebook document in the client.
#
# source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_identifier.rb#7
class LanguageServer::Protocol::Interface::NotebookDocumentIdentifier
  # @return [NotebookDocumentIdentifier] a new instance of NotebookDocumentIdentifier
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_identifier.rb#8
  def initialize(uri:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_identifier.rb#24
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_identifier.rb#26
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_identifier.rb#30
  def to_json(*args); end

  # The notebook document's URI.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_identifier.rb#20
  def uri; end
end

# Notebook specific client capabilities.
#
# source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_client_capabilities.rb#7
class LanguageServer::Protocol::Interface::NotebookDocumentSyncClientCapabilities
  # @return [NotebookDocumentSyncClientCapabilities] a new instance of NotebookDocumentSyncClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_client_capabilities.rb#8
  def initialize(dynamic_registration: T.unsafe(nil), execution_summary_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_client_capabilities.rb#36
  def attributes; end

  # Whether implementation supports dynamic registration. If this is
  # set to `true` the client supports the new
  # `(TextDocumentRegistrationOptions & StaticRegistrationOptions)`
  # return value for the corresponding server capability as well.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_client_capabilities.rb#24
  def dynamic_registration; end

  # The client supports sending execution summary data per cell.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_client_capabilities.rb#32
  def execution_summary_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_client_capabilities.rb#38
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_client_capabilities.rb#42
  def to_json(*args); end
end

# Options specific to a notebook plus its cells
# to be synced to the server.
#
# If a selector provides a notebook document
# filter but no cell selector all cells of a
# matching notebook document will be synced.
#
# If a selector provides no notebook document
# filter but only a cell selector all notebook
# documents that contain at least one matching
# cell will be synced.
#
# source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_options.rb#17
class LanguageServer::Protocol::Interface::NotebookDocumentSyncOptions
  # @return [NotebookDocumentSyncOptions] a new instance of NotebookDocumentSyncOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_options.rb#18
  def initialize(notebook_selector:, save: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_options.rb#44
  def attributes; end

  # The notebooks to be synced
  #
  # @return [({ notebook: string | NotebookDocumentFilter; cells?: { language: string; }[]; } | { notebook?: string | NotebookDocumentFilter; cells: { ...; }[]; })[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_options.rb#31
  def notebook_selector; end

  # Whether save notification should be forwarded to
  # the server. Will only be honored if mode === `notebook`.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_options.rb#40
  def save; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_options.rb#46
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_options.rb#50
  def to_json(*args); end
end

# Registration options specific to a notebook.
#
# source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_registration_options.rb#7
class LanguageServer::Protocol::Interface::NotebookDocumentSyncRegistrationOptions
  # @return [NotebookDocumentSyncRegistrationOptions] a new instance of NotebookDocumentSyncRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_registration_options.rb#8
  def initialize(notebook_selector:, save: T.unsafe(nil), id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_registration_options.rb#44
  def attributes; end

  # The id used to register the request. The id can be used to deregister
  # the request again. See also Registration#id.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_registration_options.rb#40
  def id; end

  # The notebooks to be synced
  #
  # @return [({ notebook: string | NotebookDocumentFilter; cells?: { language: string; }[]; } | { notebook?: string | NotebookDocumentFilter; cells: { ...; }[]; })[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_registration_options.rb#22
  def notebook_selector; end

  # Whether save notification should be forwarded to
  # the server. Will only be honored if mode === `notebook`.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_registration_options.rb#31
  def save; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_registration_options.rb#46
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notebook_document_sync_registration_options.rb#50
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/notification_message.rb#4
class LanguageServer::Protocol::Interface::NotificationMessage
  # @return [NotificationMessage] a new instance of NotificationMessage
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notification_message.rb#5
  def initialize(jsonrpc:, method:, params: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notification_message.rb#36
  def attributes; end

  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notification_message.rb#16
  def jsonrpc; end

  # The method to be invoked.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notification_message.rb#24
  def method; end

  # The notification's params.
  #
  # @return [any]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/notification_message.rb#32
  def params; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notification_message.rb#38
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/notification_message.rb#42
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/optional_versioned_text_document_identifier.rb#4
class LanguageServer::Protocol::Interface::OptionalVersionedTextDocumentIdentifier
  # @return [OptionalVersionedTextDocumentIdentifier] a new instance of OptionalVersionedTextDocumentIdentifier
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/optional_versioned_text_document_identifier.rb#5
  def initialize(uri:, version:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/optional_versioned_text_document_identifier.rb#38
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/optional_versioned_text_document_identifier.rb#40
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/optional_versioned_text_document_identifier.rb#44
  def to_json(*args); end

  # The text document's URI.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/optional_versioned_text_document_identifier.rb#18
  def uri; end

  # The version number of this document. If an optional versioned text document
  # identifier is sent from the server to the client and the file is not
  # open in the editor (the server has not received an open notification
  # before) the server can send `null` to indicate that the version is
  # known and the content on disk is the master (as specified with document
  # content ownership).
  #
  # The version number of a document will increase after each change,
  # including undo/redo. The number doesn't need to be consecutive.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/optional_versioned_text_document_identifier.rb#34
  def version; end
end

# Represents a parameter of a callable-signature. A parameter can
# have a label and a doc-comment.
#
# source://language_server-protocol//lib/language_server/protocol/interface/parameter_information.rb#8
class LanguageServer::Protocol::Interface::ParameterInformation
  # @return [ParameterInformation] a new instance of ParameterInformation
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/parameter_information.rb#9
  def initialize(label:, documentation: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/parameter_information.rb#44
  def attributes; end

  # The human-readable doc-comment of this parameter. Will be shown
  # in the UI but can be omitted.
  #
  # @return [string | MarkupContent]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/parameter_information.rb#40
  def documentation; end

  # The label of this parameter information.
  #
  # Either a string or an inclusive start and exclusive end offsets within
  # its containing signature label. (see SignatureInformation.label). The
  # offsets are based on a UTF-16 string representation as `Position` and
  # `Range` does.
  #
  # *Note*: a label of type string should be a substring of its containing
  # signature label. Its intended use case is to highlight the parameter
  # label part in the `SignatureInformation.label`.
  #
  # @return [string | [number, number]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/parameter_information.rb#31
  def label; end

  # source://language_server-protocol//lib/language_server/protocol/interface/parameter_information.rb#46
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/parameter_information.rb#50
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/partial_result_params.rb#4
class LanguageServer::Protocol::Interface::PartialResultParams
  # @return [PartialResultParams] a new instance of PartialResultParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/partial_result_params.rb#5
  def initialize(partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/partial_result_params.rb#22
  def attributes; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/partial_result_params.rb#18
  def partial_result_token; end

  # source://language_server-protocol//lib/language_server/protocol/interface/partial_result_params.rb#24
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/partial_result_params.rb#28
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/position.rb#4
class LanguageServer::Protocol::Interface::Position
  # @return [Position] a new instance of Position
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/position.rb#5
  def initialize(line:, character:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/position.rb#34
  def attributes; end

  # Character offset on a line in a document (zero-based). The meaning of this
  # offset is determined by the negotiated `PositionEncodingKind`.
  #
  # If the character value is greater than the line length it defaults back
  # to the line length.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/position.rb#30
  def character; end

  # Line position in a document (zero-based).
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/position.rb#18
  def line; end

  # source://language_server-protocol//lib/language_server/protocol/interface/position.rb#36
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/position.rb#40
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/prepare_rename_params.rb#4
class LanguageServer::Protocol::Interface::PrepareRenameParams
  # @return [PrepareRenameParams] a new instance of PrepareRenameParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/prepare_rename_params.rb#5
  def initialize(text_document:, position:, work_done_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/prepare_rename_params.rb#39
  def attributes; end

  # The position inside the text document.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/prepare_rename_params.rb#27
  def position; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/prepare_rename_params.rb#19
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/prepare_rename_params.rb#41
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/prepare_rename_params.rb#45
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/prepare_rename_params.rb#35
  def work_done_token; end
end

# A previous result id in a workspace pull request.
#
# source://language_server-protocol//lib/language_server/protocol/interface/previous_result_id.rb#7
class LanguageServer::Protocol::Interface::PreviousResultId
  # @return [PreviousResultId] a new instance of PreviousResultId
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/previous_result_id.rb#8
  def initialize(uri:, value:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/previous_result_id.rb#34
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/previous_result_id.rb#36
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/previous_result_id.rb#40
  def to_json(*args); end

  # The URI for which the client knows a
  # result id.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/previous_result_id.rb#22
  def uri; end

  # The value of the previous result id.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/previous_result_id.rb#30
  def value; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/progress_params.rb#4
class LanguageServer::Protocol::Interface::ProgressParams
  # @return [ProgressParams] a new instance of ProgressParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/progress_params.rb#5
  def initialize(token:, value:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/progress_params.rb#30
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/progress_params.rb#32
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/progress_params.rb#36
  def to_json(*args); end

  # The progress token provided by the client or server.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/progress_params.rb#18
  def token; end

  # The progress data.
  #
  # @return [T]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/progress_params.rb#26
  def value; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::PublishDiagnosticsClientCapabilities
  # @return [PublishDiagnosticsClientCapabilities] a new instance of PublishDiagnosticsClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_client_capabilities.rb#5
  def initialize(related_information: T.unsafe(nil), tag_support: T.unsafe(nil), version_support: T.unsafe(nil), code_description_support: T.unsafe(nil), data_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_client_capabilities.rb#61
  def attributes; end

  # Client supports a codeDescription property
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_client_capabilities.rb#47
  def code_description_support; end

  # Whether code action supports the `data` property which is
  # preserved between a `textDocument/publishDiagnostics` and
  # `textDocument/codeAction` request.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_client_capabilities.rb#57
  def data_support; end

  # Whether the clients accepts diagnostics with related information.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_client_capabilities.rb#21
  def related_information; end

  # Client supports the tag property to provide meta data about a diagnostic.
  # Clients supporting tags have to handle unknown tags gracefully.
  #
  # @return [{ valueSet: DiagnosticTag[]; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_client_capabilities.rb#30
  def tag_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_client_capabilities.rb#63
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_client_capabilities.rb#67
  def to_json(*args); end

  # Whether the client interprets the version property of the
  # `textDocument/publishDiagnostics` notification's parameter.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_client_capabilities.rb#39
  def version_support; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_params.rb#4
class LanguageServer::Protocol::Interface::PublishDiagnosticsParams
  # @return [PublishDiagnosticsParams] a new instance of PublishDiagnosticsParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_params.rb#5
  def initialize(uri:, diagnostics:, version: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_params.rb#40
  def attributes; end

  # An array of diagnostic information items.
  #
  # @return [Diagnostic[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_params.rb#36
  def diagnostics; end

  # source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_params.rb#42
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_params.rb#46
  def to_json(*args); end

  # The URI for which diagnostic information is reported.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_params.rb#19
  def uri; end

  # Optional the version number of the document the diagnostics are published
  # for.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/publish_diagnostics_params.rb#28
  def version; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/range.rb#4
class LanguageServer::Protocol::Interface::Range
  # @return [Range] a new instance of Range
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/range.rb#5
  def initialize(start:, end:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/range.rb#30
  def attributes; end

  # The range's end position.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/range.rb#26
  def end; end

  # The range's start position.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/range.rb#18
  def start; end

  # source://language_server-protocol//lib/language_server/protocol/interface/range.rb#32
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/range.rb#36
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/reference_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::ReferenceClientCapabilities
  # @return [ReferenceClientCapabilities] a new instance of ReferenceClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_client_capabilities.rb#21
  def attributes; end

  # Whether references supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_client_capabilities.rb#17
  def dynamic_registration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/reference_client_capabilities.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/reference_client_capabilities.rb#27
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/reference_context.rb#4
class LanguageServer::Protocol::Interface::ReferenceContext
  # @return [ReferenceContext] a new instance of ReferenceContext
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_context.rb#5
  def initialize(include_declaration:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_context.rb#21
  def attributes; end

  # Include the declaration of the current symbol.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_context.rb#17
  def include_declaration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/reference_context.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/reference_context.rb#27
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/reference_options.rb#4
class LanguageServer::Protocol::Interface::ReferenceOptions
  # @return [ReferenceOptions] a new instance of ReferenceOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_options.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/reference_options.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/reference_options.rb#24
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_options.rb#14
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/reference_params.rb#4
class LanguageServer::Protocol::Interface::ReferenceParams
  # @return [ReferenceParams] a new instance of ReferenceParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_params.rb#5
  def initialize(text_document:, position:, context:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_params.rb#55
  def attributes; end

  # @return [ReferenceContext]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_params.rb#51
  def context; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_params.rb#46
  def partial_result_token; end

  # The position inside the text document.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_params.rb#29
  def position; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_params.rb#21
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/reference_params.rb#57
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/reference_params.rb#61
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_params.rb#37
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/reference_registration_options.rb#4
class LanguageServer::Protocol::Interface::ReferenceRegistrationOptions
  # @return [ReferenceRegistrationOptions] a new instance of ReferenceRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_registration_options.rb#28
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_registration_options.rb#19
  def document_selector; end

  # source://language_server-protocol//lib/language_server/protocol/interface/reference_registration_options.rb#30
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/reference_registration_options.rb#34
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/reference_registration_options.rb#24
  def work_done_progress; end
end

# General parameters to register for a capability.
#
# source://language_server-protocol//lib/language_server/protocol/interface/registration.rb#7
class LanguageServer::Protocol::Interface::Registration
  # @return [Registration] a new instance of Registration
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/registration.rb#8
  def initialize(id:, method:, register_options: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/registration.rb#43
  def attributes; end

  # The id used to register the request. The id can be used to deregister
  # the request again.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/registration.rb#23
  def id; end

  # The method / capability to register for.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/registration.rb#31
  def method; end

  # Options necessary for the registration.
  #
  # @return [LSPAny]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/registration.rb#39
  def register_options; end

  # source://language_server-protocol//lib/language_server/protocol/interface/registration.rb#45
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/registration.rb#49
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/registration_params.rb#4
class LanguageServer::Protocol::Interface::RegistrationParams
  # @return [RegistrationParams] a new instance of RegistrationParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/registration_params.rb#5
  def initialize(registrations:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/registration_params.rb#18
  def attributes; end

  # @return [Registration[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/registration_params.rb#14
  def registrations; end

  # source://language_server-protocol//lib/language_server/protocol/interface/registration_params.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/registration_params.rb#24
  def to_json(*args); end
end

# Client capabilities specific to regular expressions.
#
# source://language_server-protocol//lib/language_server/protocol/interface/regular_expressions_client_capabilities.rb#7
class LanguageServer::Protocol::Interface::RegularExpressionsClientCapabilities
  # @return [RegularExpressionsClientCapabilities] a new instance of RegularExpressionsClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/regular_expressions_client_capabilities.rb#8
  def initialize(engine:, version: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/regular_expressions_client_capabilities.rb#33
  def attributes; end

  # The engine's name.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/regular_expressions_client_capabilities.rb#21
  def engine; end

  # source://language_server-protocol//lib/language_server/protocol/interface/regular_expressions_client_capabilities.rb#35
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/regular_expressions_client_capabilities.rb#39
  def to_json(*args); end

  # The engine's version.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/regular_expressions_client_capabilities.rb#29
  def version; end
end

# A full diagnostic report with a set of related documents.
#
# source://language_server-protocol//lib/language_server/protocol/interface/related_full_document_diagnostic_report.rb#7
class LanguageServer::Protocol::Interface::RelatedFullDocumentDiagnosticReport
  # @return [RelatedFullDocumentDiagnosticReport] a new instance of RelatedFullDocumentDiagnosticReport
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/related_full_document_diagnostic_report.rb#8
  def initialize(kind:, items:, result_id: T.unsafe(nil), related_documents: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/related_full_document_diagnostic_report.rb#57
  def attributes; end

  # The actual items.
  #
  # @return [Diagnostic[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/related_full_document_diagnostic_report.rb#41
  def items; end

  # A full document diagnostic report.
  #
  # @return [any]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/related_full_document_diagnostic_report.rb#23
  def kind; end

  # Diagnostics of related documents. This information is useful
  # in programming languages where code in a file A can generate
  # diagnostics in a file B which A depends on. An example of
  # such a language is C/C++ where marco definitions in a file
  # a.cpp and result in errors in a header file b.hpp.
  #
  # @return [{ [uri: string]: FullDocumentDiagnosticReport | UnchangedDocumentDiagnosticReport; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/related_full_document_diagnostic_report.rb#53
  def related_documents; end

  # An optional result id. If provided it will
  # be sent on the next diagnostic request for the
  # same document.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/related_full_document_diagnostic_report.rb#33
  def result_id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/related_full_document_diagnostic_report.rb#59
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/related_full_document_diagnostic_report.rb#63
  def to_json(*args); end
end

# An unchanged diagnostic report with a set of related documents.
#
# source://language_server-protocol//lib/language_server/protocol/interface/related_unchanged_document_diagnostic_report.rb#7
class LanguageServer::Protocol::Interface::RelatedUnchangedDocumentDiagnosticReport
  # @return [RelatedUnchangedDocumentDiagnosticReport] a new instance of RelatedUnchangedDocumentDiagnosticReport
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/related_unchanged_document_diagnostic_report.rb#8
  def initialize(kind:, result_id:, related_documents: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/related_unchanged_document_diagnostic_report.rb#50
  def attributes; end

  # A document diagnostic report indicating
  # no changes to the last result. A server can
  # only return `unchanged` if result ids are
  # provided.
  #
  # @return [any]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/related_unchanged_document_diagnostic_report.rb#25
  def kind; end

  # Diagnostics of related documents. This information is useful
  # in programming languages where code in a file A can generate
  # diagnostics in a file B which A depends on. An example of
  # such a language is C/C++ where marco definitions in a file
  # a.cpp and result in errors in a header file b.hpp.
  #
  # @return [{ [uri: string]: FullDocumentDiagnosticReport | UnchangedDocumentDiagnosticReport; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/related_unchanged_document_diagnostic_report.rb#46
  def related_documents; end

  # A result id which will be sent on the next
  # diagnostic request for the same document.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/related_unchanged_document_diagnostic_report.rb#34
  def result_id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/related_unchanged_document_diagnostic_report.rb#52
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/related_unchanged_document_diagnostic_report.rb#56
  def to_json(*args); end
end

# A relative pattern is a helper to construct glob patterns that are matched
# relatively to a base URI. The common value for a `baseUri` is a workspace
# folder root, but it can be another absolute URI as well.
#
# source://language_server-protocol//lib/language_server/protocol/interface/relative_pattern.rb#9
class LanguageServer::Protocol::Interface::RelativePattern
  # @return [RelativePattern] a new instance of RelativePattern
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/relative_pattern.rb#10
  def initialize(base_uri:, pattern:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/relative_pattern.rb#36
  def attributes; end

  # A workspace folder or a base URI to which this pattern will be matched
  # against relatively.
  #
  # @return [string | WorkspaceFolder]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/relative_pattern.rb#24
  def base_uri; end

  # The actual glob pattern;
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/relative_pattern.rb#32
  def pattern; end

  # source://language_server-protocol//lib/language_server/protocol/interface/relative_pattern.rb#38
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/relative_pattern.rb#42
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/rename_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::RenameClientCapabilities
  # @return [RenameClientCapabilities] a new instance of RenameClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil), prepare_support: T.unsafe(nil), prepare_support_default_behavior: T.unsafe(nil), honors_change_annotations: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_client_capabilities.rb#57
  def attributes; end

  # Whether rename supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_client_capabilities.rb#20
  def dynamic_registration; end

  # Whether the client honors the change annotations in
  # text edits and resource operations returned via the
  # rename request's workspace edit by for example presenting
  # the workspace edit in the user interface and asking
  # for confirmation.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_client_capabilities.rb#53
  def honors_change_annotations; end

  # Client supports testing for validity of rename operations
  # before execution.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_client_capabilities.rb#29
  def prepare_support; end

  # Client supports the default behavior result
  # (`{ defaultBehavior: boolean }`).
  #
  # The value indicates the default behavior used by the
  # client.
  #
  # @return [1]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_client_capabilities.rb#41
  def prepare_support_default_behavior; end

  # source://language_server-protocol//lib/language_server/protocol/interface/rename_client_capabilities.rb#59
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/rename_client_capabilities.rb#63
  def to_json(*args); end
end

# Rename file operation
#
# source://language_server-protocol//lib/language_server/protocol/interface/rename_file.rb#7
class LanguageServer::Protocol::Interface::RenameFile
  # @return [RenameFile] a new instance of RenameFile
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_file.rb#8
  def initialize(kind:, old_uri:, new_uri:, options: T.unsafe(nil), annotation_id: T.unsafe(nil)); end

  # An optional annotation identifier describing the operation.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_file.rb#56
  def annotation_id; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_file.rb#60
  def attributes; end

  # A rename
  #
  # @return ["rename"]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_file.rb#24
  def kind; end

  # The new location.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_file.rb#40
  def new_uri; end

  # The old (existing) location.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_file.rb#32
  def old_uri; end

  # Rename options.
  #
  # @return [RenameFileOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_file.rb#48
  def options; end

  # source://language_server-protocol//lib/language_server/protocol/interface/rename_file.rb#62
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/rename_file.rb#66
  def to_json(*args); end
end

# Rename file options
#
# source://language_server-protocol//lib/language_server/protocol/interface/rename_file_options.rb#7
class LanguageServer::Protocol::Interface::RenameFileOptions
  # @return [RenameFileOptions] a new instance of RenameFileOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_file_options.rb#8
  def initialize(overwrite: T.unsafe(nil), ignore_if_exists: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_file_options.rb#33
  def attributes; end

  # Ignores if target exists.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_file_options.rb#29
  def ignore_if_exists; end

  # Overwrite target if existing. Overwrite wins over `ignoreIfExists`
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_file_options.rb#21
  def overwrite; end

  # source://language_server-protocol//lib/language_server/protocol/interface/rename_file_options.rb#35
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/rename_file_options.rb#39
  def to_json(*args); end
end

# The parameters sent in notifications/requests for user-initiated renames
# of files.
#
# source://language_server-protocol//lib/language_server/protocol/interface/rename_files_params.rb#8
class LanguageServer::Protocol::Interface::RenameFilesParams
  # @return [RenameFilesParams] a new instance of RenameFilesParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_files_params.rb#9
  def initialize(files:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_files_params.rb#26
  def attributes; end

  # An array of all files/folders renamed in this operation. When a folder
  # is renamed, only the folder will be included, and not its children.
  #
  # @return [FileRename[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_files_params.rb#22
  def files; end

  # source://language_server-protocol//lib/language_server/protocol/interface/rename_files_params.rb#28
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/rename_files_params.rb#32
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/rename_options.rb#4
class LanguageServer::Protocol::Interface::RenameOptions
  # @return [RenameOptions] a new instance of RenameOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil), prepare_provider: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_options.rb#27
  def attributes; end

  # Renames should be checked and tested before being executed.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_options.rb#23
  def prepare_provider; end

  # source://language_server-protocol//lib/language_server/protocol/interface/rename_options.rb#29
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/rename_options.rb#33
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_options.rb#15
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/rename_params.rb#4
class LanguageServer::Protocol::Interface::RenameParams
  # @return [RenameParams] a new instance of RenameParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_params.rb#5
  def initialize(text_document:, position:, new_name:, work_done_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_params.rb#50
  def attributes; end

  # The new name of the symbol. If the given name is not valid the
  # request must return a [ResponseError](#ResponseError) with an
  # appropriate message set.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_params.rb#46
  def new_name; end

  # The position inside the text document.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_params.rb#28
  def position; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_params.rb#20
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/rename_params.rb#52
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/rename_params.rb#56
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_params.rb#36
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/rename_registration_options.rb#4
class LanguageServer::Protocol::Interface::RenameRegistrationOptions
  # @return [RenameRegistrationOptions] a new instance of RenameRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil), prepare_provider: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_registration_options.rb#37
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_registration_options.rb#20
  def document_selector; end

  # Renames should be checked and tested before being executed.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_registration_options.rb#33
  def prepare_provider; end

  # source://language_server-protocol//lib/language_server/protocol/interface/rename_registration_options.rb#39
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/rename_registration_options.rb#43
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/rename_registration_options.rb#25
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/request_message.rb#4
class LanguageServer::Protocol::Interface::RequestMessage
  # @return [RequestMessage] a new instance of RequestMessage
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/request_message.rb#5
  def initialize(jsonrpc:, id:, method:, params: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/request_message.rb#45
  def attributes; end

  # The request id.
  #
  # @return [string | number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/request_message.rb#25
  def id; end

  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/request_message.rb#17
  def jsonrpc; end

  # The method to be invoked.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/request_message.rb#33
  def method; end

  # The method's params.
  #
  # @return [any]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/request_message.rb#41
  def params; end

  # source://language_server-protocol//lib/language_server/protocol/interface/request_message.rb#47
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/request_message.rb#51
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/response_error.rb#4
class LanguageServer::Protocol::Interface::ResponseError
  # @return [ResponseError] a new instance of ResponseError
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/response_error.rb#5
  def initialize(code:, message:, data: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/response_error.rb#40
  def attributes; end

  # A number indicating the error type that occurred.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/response_error.rb#19
  def code; end

  # A primitive or structured value that contains additional
  # information about the error. Can be omitted.
  #
  # @return [any]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/response_error.rb#36
  def data; end

  # A string providing a short description of the error.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/response_error.rb#27
  def message; end

  # source://language_server-protocol//lib/language_server/protocol/interface/response_error.rb#42
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/response_error.rb#46
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/response_message.rb#4
class LanguageServer::Protocol::Interface::ResponseMessage
  # @return [ResponseMessage] a new instance of ResponseMessage
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/response_message.rb#5
  def initialize(jsonrpc:, id:, result: T.unsafe(nil), error: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/response_message.rb#46
  def attributes; end

  # The error object in case a request fails.
  #
  # @return [ResponseError]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/response_message.rb#42
  def error; end

  # The request id.
  #
  # @return [string | number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/response_message.rb#25
  def id; end

  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/response_message.rb#17
  def jsonrpc; end

  # The result of a request. This member is REQUIRED on success.
  # This member MUST NOT exist if there was an error invoking the method.
  #
  # @return [string | number | boolean | object]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/response_message.rb#34
  def result; end

  # source://language_server-protocol//lib/language_server/protocol/interface/response_message.rb#48
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/response_message.rb#52
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/save_options.rb#4
class LanguageServer::Protocol::Interface::SaveOptions
  # @return [SaveOptions] a new instance of SaveOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/save_options.rb#5
  def initialize(include_text: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/save_options.rb#21
  def attributes; end

  # The client is supposed to include the content on save.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/save_options.rb#17
  def include_text; end

  # source://language_server-protocol//lib/language_server/protocol/interface/save_options.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/save_options.rb#27
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/selection_range.rb#4
class LanguageServer::Protocol::Interface::SelectionRange
  # @return [SelectionRange] a new instance of SelectionRange
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range.rb#5
  def initialize(range:, parent: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range.rb#31
  def attributes; end

  # The parent selection range containing this range. Therefore
  # `parent.range` must contain `this.range`.
  #
  # @return [SelectionRange]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range.rb#27
  def parent; end

  # The [range](#Range) of this selection range.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range.rb#18
  def range; end

  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range.rb#33
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range.rb#37
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/selection_range_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::SelectionRangeClientCapabilities
  # @return [SelectionRangeClientCapabilities] a new instance of SelectionRangeClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_client_capabilities.rb#24
  def attributes; end

  # Whether implementation supports dynamic registration for selection range
  # providers. If this is set to `true` the client supports the new
  # `SelectionRangeRegistrationOptions` return value for the corresponding
  # server capability as well.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_client_capabilities.rb#20
  def dynamic_registration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_client_capabilities.rb#26
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_client_capabilities.rb#30
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/selection_range_options.rb#4
class LanguageServer::Protocol::Interface::SelectionRangeOptions
  # @return [SelectionRangeOptions] a new instance of SelectionRangeOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_options.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_options.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_options.rb#24
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_options.rb#14
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/selection_range_params.rb#4
class LanguageServer::Protocol::Interface::SelectionRangeParams
  # @return [SelectionRangeParams] a new instance of SelectionRangeParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_params.rb#5
  def initialize(text_document:, positions:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_params.rb#49
  def attributes; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_params.rb#29
  def partial_result_token; end

  # The positions inside the text document.
  #
  # @return [Position[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_params.rb#45
  def positions; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_params.rb#37
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_params.rb#51
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_params.rb#55
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_params.rb#20
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/selection_range_registration_options.rb#4
class LanguageServer::Protocol::Interface::SelectionRangeRegistrationOptions
  # @return [SelectionRangeRegistrationOptions] a new instance of SelectionRangeRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil), id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_registration_options.rb#38
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_registration_options.rb#25
  def document_selector; end

  # The id used to register the request. The id can be used to deregister
  # the request again. See also Registration#id.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_registration_options.rb#34
  def id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_registration_options.rb#40
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_registration_options.rb#44
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/selection_range_registration_options.rb#16
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens.rb#4
class LanguageServer::Protocol::Interface::SemanticTokens
  # @return [SemanticTokens] a new instance of SemanticTokens
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens.rb#5
  def initialize(data:, result_id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens.rb#33
  def attributes; end

  # The actual tokens.
  #
  # @return [number[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens.rb#29
  def data; end

  # An optional result id. If provided and clients support delta updating
  # the client will include the result id in the next semantic token request.
  # A server can then instead of computing all semantic tokens again simply
  # send a delta.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens.rb#21
  def result_id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens.rb#35
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens.rb#39
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::SemanticTokensClientCapabilities
  # @return [SemanticTokensClientCapabilities] a new instance of SemanticTokensClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_client_capabilities.rb#5
  def initialize(requests:, token_types:, token_modifiers:, formats:, dynamic_registration: T.unsafe(nil), overlapping_token_support: T.unsafe(nil), multiline_token_support: T.unsafe(nil), server_cancel_support: T.unsafe(nil), augments_syntax_tokens: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_client_capabilities.rb#113
  def attributes; end

  # Whether the client uses semantic tokens to augment existing
  # syntax tokens. If set to `true` client side created syntax
  # tokens and semantic tokens are both used for colorization. If
  # set to `false` the client only uses the returned semantic tokens
  # for colorization.
  #
  # If the value is `undefined` then the client behavior is not
  # specified.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_client_capabilities.rb#109
  def augments_syntax_tokens; end

  # Whether implementation supports dynamic registration. If this is set to
  # `true` the client supports the new `(TextDocumentRegistrationOptions &
  # StaticRegistrationOptions)` return value for the corresponding server
  # capability as well.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_client_capabilities.rb#28
  def dynamic_registration; end

  # The formats the clients supports.
  #
  # @return ["relative"[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_client_capabilities.rb#67
  def formats; end

  # Whether the client supports tokens that can span multiple lines.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_client_capabilities.rb#83
  def multiline_token_support; end

  # Whether the client supports tokens that can overlap each other.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_client_capabilities.rb#75
  def overlapping_token_support; end

  # Which requests the client supports and might send to the server
  # depending on the server's capability. Please note that clients might not
  # show semantic tokens or degrade some of the user experience if a range
  # or full request is advertised by the client but not provided by the
  # server. If for example the client capability `requests.full` and
  # `request.range` are both set to true but the server only provides a
  # range provider the client might not render a minimap correctly or might
  # even decide to not show any semantic tokens at all.
  #
  # @return [{ range?: boolean | {}; full?: boolean | { delta?: boolean; }; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_client_capabilities.rb#43
  def requests; end

  # Whether the client allows the server to actively cancel a
  # semantic token request, e.g. supports returning
  # ErrorCodes.ServerCancelled. If a server does the client
  # needs to retrigger the request.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_client_capabilities.rb#94
  def server_cancel_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_client_capabilities.rb#115
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_client_capabilities.rb#119
  def to_json(*args); end

  # The token modifiers that the client supports.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_client_capabilities.rb#59
  def token_modifiers; end

  # The token types that the client supports.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_client_capabilities.rb#51
  def token_types; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta.rb#4
class LanguageServer::Protocol::Interface::SemanticTokensDelta
  # @return [SemanticTokensDelta] a new instance of SemanticTokensDelta
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta.rb#5
  def initialize(edits:, result_id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta.rb#28
  def attributes; end

  # The semantic token edits to transform a previous result into a new
  # result.
  #
  # @return [SemanticTokensEdit[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta.rb#24
  def edits; end

  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta.rb#15
  def result_id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta.rb#30
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta.rb#34
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta_params.rb#4
class LanguageServer::Protocol::Interface::SemanticTokensDeltaParams
  # @return [SemanticTokensDeltaParams] a new instance of SemanticTokensDeltaParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta_params.rb#5
  def initialize(text_document:, previous_result_id:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta_params.rb#50
  def attributes; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta_params.rb#29
  def partial_result_token; end

  # The result id of a previous response. The result Id can either point to
  # a full response or a delta response depending on what was received last.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta_params.rb#46
  def previous_result_id; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta_params.rb#37
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta_params.rb#52
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta_params.rb#56
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta_params.rb#20
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta_partial_result.rb#4
class LanguageServer::Protocol::Interface::SemanticTokensDeltaPartialResult
  # @return [SemanticTokensDeltaPartialResult] a new instance of SemanticTokensDeltaPartialResult
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta_partial_result.rb#5
  def initialize(edits:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta_partial_result.rb#18
  def attributes; end

  # @return [SemanticTokensEdit[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta_partial_result.rb#14
  def edits; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta_partial_result.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_delta_partial_result.rb#24
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_edit.rb#4
class LanguageServer::Protocol::Interface::SemanticTokensEdit
  # @return [SemanticTokensEdit] a new instance of SemanticTokensEdit
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_edit.rb#5
  def initialize(start:, delete_count:, data: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_edit.rb#39
  def attributes; end

  # The elements to insert.
  #
  # @return [number[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_edit.rb#35
  def data; end

  # The count of elements to remove.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_edit.rb#27
  def delete_count; end

  # The start offset of the edit.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_edit.rb#19
  def start; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_edit.rb#41
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_edit.rb#45
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_legend.rb#4
class LanguageServer::Protocol::Interface::SemanticTokensLegend
  # @return [SemanticTokensLegend] a new instance of SemanticTokensLegend
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_legend.rb#5
  def initialize(token_types:, token_modifiers:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_legend.rb#30
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_legend.rb#32
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_legend.rb#36
  def to_json(*args); end

  # The token modifiers a server uses.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_legend.rb#26
  def token_modifiers; end

  # The token types a server uses.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_legend.rb#18
  def token_types; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_options.rb#4
class LanguageServer::Protocol::Interface::SemanticTokensOptions
  # @return [SemanticTokensOptions] a new instance of SemanticTokensOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_options.rb#5
  def initialize(legend:, work_done_progress: T.unsafe(nil), range: T.unsafe(nil), full: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_options.rb#46
  def attributes; end

  # Server supports providing semantic tokens for a full document.
  #
  # @return [boolean | { delta?: boolean; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_options.rb#42
  def full; end

  # The legend used by the server
  #
  # @return [SemanticTokensLegend]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_options.rb#25
  def legend; end

  # Server supports providing semantic tokens for a specific range
  # of a document.
  #
  # @return [boolean | {}]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_options.rb#34
  def range; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_options.rb#48
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_options.rb#52
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_options.rb#17
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_params.rb#4
class LanguageServer::Protocol::Interface::SemanticTokensParams
  # @return [SemanticTokensParams] a new instance of SemanticTokensParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_params.rb#5
  def initialize(text_document:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_params.rb#40
  def attributes; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_params.rb#28
  def partial_result_token; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_params.rb#36
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_params.rb#42
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_params.rb#46
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_params.rb#19
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_partial_result.rb#4
class LanguageServer::Protocol::Interface::SemanticTokensPartialResult
  # @return [SemanticTokensPartialResult] a new instance of SemanticTokensPartialResult
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_partial_result.rb#5
  def initialize(data:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_partial_result.rb#18
  def attributes; end

  # @return [number[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_partial_result.rb#14
  def data; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_partial_result.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_partial_result.rb#24
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_range_params.rb#4
class LanguageServer::Protocol::Interface::SemanticTokensRangeParams
  # @return [SemanticTokensRangeParams] a new instance of SemanticTokensRangeParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_range_params.rb#5
  def initialize(text_document:, range:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_range_params.rb#49
  def attributes; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_range_params.rb#29
  def partial_result_token; end

  # The range the semantic tokens are requested for.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_range_params.rb#45
  def range; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_range_params.rb#37
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_range_params.rb#51
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_range_params.rb#55
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_range_params.rb#20
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_registration_options.rb#4
class LanguageServer::Protocol::Interface::SemanticTokensRegistrationOptions
  # @return [SemanticTokensRegistrationOptions] a new instance of SemanticTokensRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_registration_options.rb#5
  def initialize(document_selector:, legend:, work_done_progress: T.unsafe(nil), range: T.unsafe(nil), full: T.unsafe(nil), id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_registration_options.rb#66
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_registration_options.rb#23
  def document_selector; end

  # Server supports providing semantic tokens for a full document.
  #
  # @return [boolean | { delta?: boolean; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_registration_options.rb#53
  def full; end

  # The id used to register the request. The id can be used to deregister
  # the request again. See also Registration#id.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_registration_options.rb#62
  def id; end

  # The legend used by the server
  #
  # @return [SemanticTokensLegend]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_registration_options.rb#36
  def legend; end

  # Server supports providing semantic tokens for a specific range
  # of a document.
  #
  # @return [boolean | {}]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_registration_options.rb#45
  def range; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_registration_options.rb#68
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_registration_options.rb#72
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_registration_options.rb#28
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_workspace_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::SemanticTokensWorkspaceClientCapabilities
  # @return [SemanticTokensWorkspaceClientCapabilities] a new instance of SemanticTokensWorkspaceClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_workspace_client_capabilities.rb#5
  def initialize(refresh_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_workspace_client_capabilities.rb#27
  def attributes; end

  # Whether the client implementation supports a refresh request sent from
  # the server to the client.
  #
  # Note that this event is global and will force the client to refresh all
  # semantic tokens currently shown. It should be used with absolute care
  # and is useful for situation where a server for example detect a project
  # wide change that requires such a calculation.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_workspace_client_capabilities.rb#23
  def refresh_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_workspace_client_capabilities.rb#29
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/semantic_tokens_workspace_client_capabilities.rb#33
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#4
class LanguageServer::Protocol::Interface::ServerCapabilities
  # @return [ServerCapabilities] a new instance of ServerCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#5
  def initialize(position_encoding: T.unsafe(nil), text_document_sync: T.unsafe(nil), notebook_document_sync: T.unsafe(nil), completion_provider: T.unsafe(nil), hover_provider: T.unsafe(nil), signature_help_provider: T.unsafe(nil), declaration_provider: T.unsafe(nil), definition_provider: T.unsafe(nil), type_definition_provider: T.unsafe(nil), implementation_provider: T.unsafe(nil), references_provider: T.unsafe(nil), document_highlight_provider: T.unsafe(nil), document_symbol_provider: T.unsafe(nil), code_action_provider: T.unsafe(nil), code_lens_provider: T.unsafe(nil), document_link_provider: T.unsafe(nil), color_provider: T.unsafe(nil), document_formatting_provider: T.unsafe(nil), document_range_formatting_provider: T.unsafe(nil), document_on_type_formatting_provider: T.unsafe(nil), rename_provider: T.unsafe(nil), folding_range_provider: T.unsafe(nil), execute_command_provider: T.unsafe(nil), selection_range_provider: T.unsafe(nil), linked_editing_range_provider: T.unsafe(nil), call_hierarchy_provider: T.unsafe(nil), semantic_tokens_provider: T.unsafe(nil), moniker_provider: T.unsafe(nil), type_hierarchy_provider: T.unsafe(nil), inline_value_provider: T.unsafe(nil), inlay_hint_provider: T.unsafe(nil), diagnostic_provider: T.unsafe(nil), workspace_symbol_provider: T.unsafe(nil), workspace: T.unsafe(nil), experimental: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#340
  def attributes; end

  # The server provides call hierarchy support.
  #
  # @return [boolean | CallHierarchyOptions | CallHierarchyRegistrationOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#264
  def call_hierarchy_provider; end

  # The server provides code actions. The `CodeActionOptions` return type is
  # only valid if the client signals code action literal support via the
  # property `textDocument.codeAction.codeActionLiteralSupport`.
  #
  # @return [boolean | CodeActionOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#166
  def code_action_provider; end

  # The server provides code lens.
  #
  # @return [CodeLensOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#174
  def code_lens_provider; end

  # The server provides color provider support.
  #
  # @return [boolean | DocumentColorOptions | DocumentColorRegistrationOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#190
  def color_provider; end

  # The server provides completion support.
  #
  # @return [CompletionOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#84
  def completion_provider; end

  # The server provides go to declaration support.
  #
  # @return [boolean | DeclarationOptions | DeclarationRegistrationOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#108
  def declaration_provider; end

  # The server provides goto definition support.
  #
  # @return [boolean | DefinitionOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#116
  def definition_provider; end

  # The server has support for pull model diagnostics.
  #
  # @return [DiagnosticOptions | DiagnosticRegistrationOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#312
  def diagnostic_provider; end

  # The server provides document formatting.
  #
  # @return [boolean | DocumentFormattingOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#198
  def document_formatting_provider; end

  # The server provides document highlight support.
  #
  # @return [boolean | DocumentHighlightOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#148
  def document_highlight_provider; end

  # The server provides document link support.
  #
  # @return [DocumentLinkOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#182
  def document_link_provider; end

  # The server provides document formatting on typing.
  #
  # @return [DocumentOnTypeFormattingOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#214
  def document_on_type_formatting_provider; end

  # The server provides document range formatting.
  #
  # @return [boolean | DocumentRangeFormattingOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#206
  def document_range_formatting_provider; end

  # The server provides document symbol support.
  #
  # @return [boolean | DocumentSymbolOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#156
  def document_symbol_provider; end

  # The server provides execute command support.
  #
  # @return [ExecuteCommandOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#240
  def execute_command_provider; end

  # Experimental server capabilities.
  #
  # @return [LSPAny]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#336
  def experimental; end

  # The server provides folding provider support.
  #
  # @return [boolean | FoldingRangeOptions | FoldingRangeRegistrationOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#232
  def folding_range_provider; end

  # The server provides hover support.
  #
  # @return [boolean | HoverOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#92
  def hover_provider; end

  # The server provides goto implementation support.
  #
  # @return [boolean | ImplementationOptions | ImplementationRegistrationOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#132
  def implementation_provider; end

  # The server provides inlay hints.
  #
  # @return [boolean | InlayHintOptions | InlayHintRegistrationOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#304
  def inlay_hint_provider; end

  # The server provides inline values.
  #
  # @return [boolean | InlineValueOptions | InlineValueRegistrationOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#296
  def inline_value_provider; end

  # The server provides linked editing range support.
  #
  # @return [boolean | LinkedEditingRangeOptions | LinkedEditingRangeRegistrationOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#256
  def linked_editing_range_provider; end

  # Whether server provides moniker support.
  #
  # @return [boolean | MonikerOptions | MonikerRegistrationOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#280
  def moniker_provider; end

  # Defines how notebook documents are synced.
  #
  # @return [NotebookDocumentSyncOptions | NotebookDocumentSyncRegistrationOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#76
  def notebook_document_sync; end

  # The position encoding the server picked from the encodings offered
  # by the client via the client capability `general.positionEncodings`.
  #
  # If the client didn't provide any position encodings the only valid
  # value that a server can return is 'utf-16'.
  #
  # If omitted it defaults to 'utf-16'.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#57
  def position_encoding; end

  # The server provides find references support.
  #
  # @return [boolean | ReferenceOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#140
  def references_provider; end

  # The server provides rename support. RenameOptions may only be
  # specified if the client states that it supports
  # `prepareSupport` in its initial `initialize` request.
  #
  # @return [boolean | RenameOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#224
  def rename_provider; end

  # The server provides selection range support.
  #
  # @return [boolean | SelectionRangeOptions | SelectionRangeRegistrationOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#248
  def selection_range_provider; end

  # The server provides semantic tokens support.
  #
  # @return [SemanticTokensOptions | SemanticTokensRegistrationOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#272
  def semantic_tokens_provider; end

  # The server provides signature help support.
  #
  # @return [SignatureHelpOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#100
  def signature_help_provider; end

  # Defines how text documents are synced. Is either a detailed structure
  # defining each notification or for backwards compatibility the
  # TextDocumentSyncKind number. If omitted it defaults to
  # `TextDocumentSyncKind.None`.
  #
  # @return [TextDocumentSyncOptions | TextDocumentSyncKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#68
  def text_document_sync; end

  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#342
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#346
  def to_json(*args); end

  # The server provides goto type definition support.
  #
  # @return [boolean | TypeDefinitionOptions | TypeDefinitionRegistrationOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#124
  def type_definition_provider; end

  # The server provides type hierarchy support.
  #
  # @return [boolean | TypeHierarchyOptions | TypeHierarchyRegistrationOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#288
  def type_hierarchy_provider; end

  # Workspace specific server capabilities
  #
  # @return [{ workspaceFolders?: WorkspaceFoldersServerCapabilities; fileOperations?: { didCreate?: FileOperationRegistrationOptions; ... 4 more ...; willDelete?: FileOperationRegistrationOptions; }; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#328
  def workspace; end

  # The server provides workspace symbol support.
  #
  # @return [boolean | WorkspaceSymbolOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/server_capabilities.rb#320
  def workspace_symbol_provider; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/set_trace_params.rb#4
class LanguageServer::Protocol::Interface::SetTraceParams
  # @return [SetTraceParams] a new instance of SetTraceParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/set_trace_params.rb#5
  def initialize(value:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/set_trace_params.rb#21
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/set_trace_params.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/set_trace_params.rb#27
  def to_json(*args); end

  # The new value that should be assigned to the trace setting.
  #
  # @return [TraceValue]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/set_trace_params.rb#17
  def value; end
end

# Client capabilities for the show document request.
#
# source://language_server-protocol//lib/language_server/protocol/interface/show_document_client_capabilities.rb#7
class LanguageServer::Protocol::Interface::ShowDocumentClientCapabilities
  # @return [ShowDocumentClientCapabilities] a new instance of ShowDocumentClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_client_capabilities.rb#8
  def initialize(support:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_client_capabilities.rb#25
  def attributes; end

  # The client has support for the show document
  # request.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_client_capabilities.rb#21
  def support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_client_capabilities.rb#27
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_client_capabilities.rb#31
  def to_json(*args); end
end

# Params to show a resource.
#
# source://language_server-protocol//lib/language_server/protocol/interface/show_document_params.rb#7
class LanguageServer::Protocol::Interface::ShowDocumentParams
  # @return [ShowDocumentParams] a new instance of ShowDocumentParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_params.rb#8
  def initialize(uri:, external: T.unsafe(nil), take_focus: T.unsafe(nil), selection: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_params.rb#59
  def attributes; end

  # Indicates to show the resource in an external program.
  # To show, for example, `https://code.visualstudio.com/`
  # in the default WEB browser set `external` to `true`.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_params.rb#33
  def external; end

  # An optional selection range if the document is a text
  # document. Clients might ignore the property if an
  # external program is started or the file is not a text
  # file.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_params.rb#55
  def selection; end

  # An optional property to indicate whether the editor
  # showing the document should take focus or not.
  # Clients might ignore this property if an external
  # program is started.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_params.rb#44
  def take_focus; end

  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_params.rb#61
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_params.rb#65
  def to_json(*args); end

  # The uri to show.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_params.rb#23
  def uri; end
end

# The result of an show document request.
#
# source://language_server-protocol//lib/language_server/protocol/interface/show_document_result.rb#7
class LanguageServer::Protocol::Interface::ShowDocumentResult
  # @return [ShowDocumentResult] a new instance of ShowDocumentResult
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_result.rb#8
  def initialize(success:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_result.rb#24
  def attributes; end

  # A boolean indicating if the show was successful.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_result.rb#20
  def success; end

  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_result.rb#26
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/show_document_result.rb#30
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/show_message_params.rb#4
class LanguageServer::Protocol::Interface::ShowMessageParams
  # @return [ShowMessageParams] a new instance of ShowMessageParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_params.rb#5
  def initialize(type:, message:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_params.rb#30
  def attributes; end

  # The actual message.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_params.rb#26
  def message; end

  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_params.rb#32
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_params.rb#36
  def to_json(*args); end

  # The message type. See {@link MessageType}.
  #
  # @return [MessageType]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_params.rb#18
  def type; end
end

# Show message request client capabilities
#
# source://language_server-protocol//lib/language_server/protocol/interface/show_message_request_client_capabilities.rb#7
class LanguageServer::Protocol::Interface::ShowMessageRequestClientCapabilities
  # @return [ShowMessageRequestClientCapabilities] a new instance of ShowMessageRequestClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_request_client_capabilities.rb#8
  def initialize(message_action_item: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_request_client_capabilities.rb#24
  def attributes; end

  # Capabilities specific to the `MessageActionItem` type.
  #
  # @return [{ additionalPropertiesSupport?: boolean; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_request_client_capabilities.rb#20
  def message_action_item; end

  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_request_client_capabilities.rb#26
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_request_client_capabilities.rb#30
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/show_message_request_params.rb#4
class LanguageServer::Protocol::Interface::ShowMessageRequestParams
  # @return [ShowMessageRequestParams] a new instance of ShowMessageRequestParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_request_params.rb#5
  def initialize(type:, message:, actions: T.unsafe(nil)); end

  # The message action items to present.
  #
  # @return [MessageActionItem[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_request_params.rb#35
  def actions; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_request_params.rb#39
  def attributes; end

  # The actual message
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_request_params.rb#27
  def message; end

  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_request_params.rb#41
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_request_params.rb#45
  def to_json(*args); end

  # The message type. See {@link MessageType}
  #
  # @return [MessageType]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/show_message_request_params.rb#19
  def type; end
end

# Signature help represents the signature of something
# callable. There can be multiple signature but only one
# active and only one active parameter.
#
# source://language_server-protocol//lib/language_server/protocol/interface/signature_help.rb#9
class LanguageServer::Protocol::Interface::SignatureHelp
  # @return [SignatureHelp] a new instance of SignatureHelp
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help.rb#10
  def initialize(signatures:, active_signature: T.unsafe(nil), active_parameter: T.unsafe(nil)); end

  # The active parameter of the active signature. If omitted or the value
  # lies outside the range of `signatures[activeSignature].parameters`
  # defaults to 0 if the active signature has parameters. If
  # the active signature has no parameters it is ignored.
  # In future version of the protocol this property might become
  # mandatory to better express the active parameter if the
  # active signature does have any.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help.rb#55
  def active_parameter; end

  # The active signature. If omitted or the value lies outside the
  # range of `signatures` the value defaults to zero or is ignore if
  # the `SignatureHelp` as no signatures.
  #
  # Whenever possible implementors should make an active decision about
  # the active signature and shouldn't rely on a default value.
  #
  # In future version of the protocol this property might become
  # mandatory to better express this.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help.rb#41
  def active_signature; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help.rb#59
  def attributes; end

  # One or more signatures. If no signatures are available the signature help
  # request should return `null`.
  #
  # @return [SignatureInformation[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help.rb#25
  def signatures; end

  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help.rb#61
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help.rb#65
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/signature_help_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::SignatureHelpClientCapabilities
  # @return [SignatureHelpClientCapabilities] a new instance of SignatureHelpClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil), signature_information: T.unsafe(nil), context_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_client_capabilities.rb#43
  def attributes; end

  # The client supports to send additional context information for a
  # `textDocument/signatureHelp` request. A client that opts into
  # contextSupport will also support the `retriggerCharacters` on
  # `SignatureHelpOptions`.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_client_capabilities.rb#39
  def context_support; end

  # Whether signature help supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_client_capabilities.rb#19
  def dynamic_registration; end

  # The client supports the following `SignatureInformation`
  # specific properties.
  #
  # @return [{ documentationFormat?: MarkupKind[]; parameterInformation?: { labelOffsetSupport?: boolean; }; activeParameterSupport?: boolean; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_client_capabilities.rb#28
  def signature_information; end

  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_client_capabilities.rb#45
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_client_capabilities.rb#49
  def to_json(*args); end
end

# Additional information about the context in which a signature help request
# was triggered.
#
# source://language_server-protocol//lib/language_server/protocol/interface/signature_help_context.rb#8
class LanguageServer::Protocol::Interface::SignatureHelpContext
  # @return [SignatureHelpContext] a new instance of SignatureHelpContext
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_context.rb#9
  def initialize(trigger_kind:, is_retrigger:, trigger_character: T.unsafe(nil), active_signature_help: T.unsafe(nil)); end

  # The currently active `SignatureHelp`.
  #
  # The `activeSignatureHelp` has its `SignatureHelp.activeSignature` field
  # updated based on the user navigating through available signatures.
  #
  # @return [SignatureHelp]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_context.rb#58
  def active_signature_help; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_context.rb#62
  def attributes; end

  # `true` if signature help was already showing when it was triggered.
  #
  # Retriggers occur when the signature help is already active and can be
  # caused by actions such as typing a trigger character, a cursor move, or
  # document content changes.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_context.rb#47
  def is_retrigger; end

  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_context.rb#64
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_context.rb#68
  def to_json(*args); end

  # Character that caused signature help to be triggered.
  #
  # This is undefined when triggerKind !==
  # SignatureHelpTriggerKind.TriggerCharacter
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_context.rb#35
  def trigger_character; end

  # Action that caused signature help to be triggered.
  #
  # @return [SignatureHelpTriggerKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_context.rb#24
  def trigger_kind; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/signature_help_options.rb#4
class LanguageServer::Protocol::Interface::SignatureHelpOptions
  # @return [SignatureHelpOptions] a new instance of SignatureHelpOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil), trigger_characters: T.unsafe(nil), retrigger_characters: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_options.rb#41
  def attributes; end

  # List of characters that re-trigger signature help.
  #
  # These trigger characters are only active when signature help is already
  # showing. All trigger characters are also counted as re-trigger
  # characters.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_options.rb#37
  def retrigger_characters; end

  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_options.rb#43
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_options.rb#47
  def to_json(*args); end

  # The characters that trigger signature help
  # automatically.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_options.rb#25
  def trigger_characters; end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_options.rb#16
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/signature_help_params.rb#4
class LanguageServer::Protocol::Interface::SignatureHelpParams
  # @return [SignatureHelpParams] a new instance of SignatureHelpParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_params.rb#5
  def initialize(text_document:, position:, work_done_token: T.unsafe(nil), context: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_params.rb#50
  def attributes; end

  # The signature help context. This is only available if the client
  # specifies to send this using the client capability
  # `textDocument.signatureHelp.contextSupport === true`
  #
  # @return [SignatureHelpContext]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_params.rb#46
  def context; end

  # The position inside the text document.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_params.rb#28
  def position; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_params.rb#20
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_params.rb#52
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_params.rb#56
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_params.rb#36
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/signature_help_registration_options.rb#4
class LanguageServer::Protocol::Interface::SignatureHelpRegistrationOptions
  # @return [SignatureHelpRegistrationOptions] a new instance of SignatureHelpRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil), trigger_characters: T.unsafe(nil), retrigger_characters: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_registration_options.rb#51
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_registration_options.rb#21
  def document_selector; end

  # List of characters that re-trigger signature help.
  #
  # These trigger characters are only active when signature help is already
  # showing. All trigger characters are also counted as re-trigger
  # characters.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_registration_options.rb#47
  def retrigger_characters; end

  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_registration_options.rb#53
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_registration_options.rb#57
  def to_json(*args); end

  # The characters that trigger signature help
  # automatically.
  #
  # @return [string[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_registration_options.rb#35
  def trigger_characters; end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_help_registration_options.rb#26
  def work_done_progress; end
end

# Represents the signature of something callable. A signature
# can have a label, like a function-name, a doc-comment, and
# a set of parameters.
#
# source://language_server-protocol//lib/language_server/protocol/interface/signature_information.rb#9
class LanguageServer::Protocol::Interface::SignatureInformation
  # @return [SignatureInformation] a new instance of SignatureInformation
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_information.rb#10
  def initialize(label:, documentation: T.unsafe(nil), parameters: T.unsafe(nil), active_parameter: T.unsafe(nil)); end

  # The index of the active parameter.
  #
  # If provided, this is used in place of `SignatureHelp.activeParameter`.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_information.rb#53
  def active_parameter; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_information.rb#57
  def attributes; end

  # The human-readable doc-comment of this signature. Will be shown
  # in the UI but can be omitted.
  #
  # @return [string | MarkupContent]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_information.rb#35
  def documentation; end

  # The label of this signature. Will be shown in
  # the UI.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_information.rb#26
  def label; end

  # The parameters of this signature.
  #
  # @return [ParameterInformation[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/signature_information.rb#43
  def parameters; end

  # source://language_server-protocol//lib/language_server/protocol/interface/signature_information.rb#59
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/signature_information.rb#63
  def to_json(*args); end
end

# Static registration options to be returned in the initialize request.
#
# source://language_server-protocol//lib/language_server/protocol/interface/static_registration_options.rb#7
class LanguageServer::Protocol::Interface::StaticRegistrationOptions
  # @return [StaticRegistrationOptions] a new instance of StaticRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/static_registration_options.rb#8
  def initialize(id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/static_registration_options.rb#25
  def attributes; end

  # The id used to register the request. The id can be used to deregister
  # the request again. See also Registration#id.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/static_registration_options.rb#21
  def id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/static_registration_options.rb#27
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/static_registration_options.rb#31
  def to_json(*args); end
end

# Represents information about programming constructs like variables, classes,
# interfaces etc.
#
# source://language_server-protocol//lib/language_server/protocol/interface/symbol_information.rb#8
class LanguageServer::Protocol::Interface::SymbolInformation
  # @return [SymbolInformation] a new instance of SymbolInformation
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/symbol_information.rb#9
  def initialize(name:, kind:, location:, tags: T.unsafe(nil), deprecated: T.unsafe(nil), container_name: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/symbol_information.rb#81
  def attributes; end

  # The name of the symbol containing this symbol. This information is for
  # user interface purposes (e.g. to render a qualifier in the user interface
  # if necessary). It can't be used to re-infer a hierarchy for the document
  # symbols.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/symbol_information.rb#77
  def container_name; end

  # Indicates if this symbol is deprecated.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/symbol_information.rb#50
  def deprecated; end

  # The kind of this symbol.
  #
  # @return [SymbolKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/symbol_information.rb#34
  def kind; end

  # The location of this symbol. The location's range is used by a tool
  # to reveal the location in the editor. If the symbol is selected in the
  # tool the range's start information is used to position the cursor. So
  # the range usually spans more then the actual symbol's name and does
  # normally include things like visibility modifiers.
  #
  # The range doesn't have to denote a node range in the sense of an abstract
  # syntax tree. It can therefore not be used to re-construct a hierarchy of
  # the symbols.
  #
  # @return [Location]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/symbol_information.rb#66
  def location; end

  # The name of this symbol.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/symbol_information.rb#26
  def name; end

  # Tags for this symbol.
  #
  # @return [1[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/symbol_information.rb#42
  def tags; end

  # source://language_server-protocol//lib/language_server/protocol/interface/symbol_information.rb#83
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/symbol_information.rb#87
  def to_json(*args); end
end

# Describe options to be used when registering for text document change events.
#
# source://language_server-protocol//lib/language_server/protocol/interface/text_document_change_registration_options.rb#7
class LanguageServer::Protocol::Interface::TextDocumentChangeRegistrationOptions
  # @return [TextDocumentChangeRegistrationOptions] a new instance of TextDocumentChangeRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_change_registration_options.rb#8
  def initialize(document_selector:, sync_kind:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_change_registration_options.rb#35
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_change_registration_options.rb#22
  def document_selector; end

  # How documents are synced to the server. See TextDocumentSyncKind.Full
  # and TextDocumentSyncKind.Incremental.
  #
  # @return [TextDocumentSyncKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_change_registration_options.rb#31
  def sync_kind; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_change_registration_options.rb#37
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_change_registration_options.rb#41
  def to_json(*args); end
end

# Text document specific client capabilities.
#
# source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#7
class LanguageServer::Protocol::Interface::TextDocumentClientCapabilities
  # @return [TextDocumentClientCapabilities] a new instance of TextDocumentClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#8
  def initialize(synchronization: T.unsafe(nil), completion: T.unsafe(nil), hover: T.unsafe(nil), signature_help: T.unsafe(nil), declaration: T.unsafe(nil), definition: T.unsafe(nil), type_definition: T.unsafe(nil), implementation: T.unsafe(nil), references: T.unsafe(nil), document_highlight: T.unsafe(nil), document_symbol: T.unsafe(nil), code_action: T.unsafe(nil), code_lens: T.unsafe(nil), document_link: T.unsafe(nil), color_provider: T.unsafe(nil), formatting: T.unsafe(nil), range_formatting: T.unsafe(nil), on_type_formatting: T.unsafe(nil), rename: T.unsafe(nil), publish_diagnostics: T.unsafe(nil), folding_range: T.unsafe(nil), selection_range: T.unsafe(nil), linked_editing_range: T.unsafe(nil), call_hierarchy: T.unsafe(nil), semantic_tokens: T.unsafe(nil), moniker: T.unsafe(nil), type_hierarchy: T.unsafe(nil), inline_value: T.unsafe(nil), inlay_hint: T.unsafe(nil), diagnostic: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#285
  def attributes; end

  # Capabilities specific to the various call hierarchy requests.
  #
  # @return [CallHierarchyClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#233
  def call_hierarchy; end

  # Capabilities specific to the `textDocument/codeAction` request.
  #
  # @return [CodeActionClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#134
  def code_action; end

  # Capabilities specific to the `textDocument/codeLens` request.
  #
  # @return [CodeLensClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#142
  def code_lens; end

  # Capabilities specific to the `textDocument/documentColor` and the
  # `textDocument/colorPresentation` request.
  #
  # @return [DocumentColorClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#159
  def color_provider; end

  # Capabilities specific to the `textDocument/completion` request.
  #
  # @return [CompletionClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#54
  def completion; end

  # Capabilities specific to the `textDocument/declaration` request.
  #
  # @return [DeclarationClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#78
  def declaration; end

  # Capabilities specific to the `textDocument/definition` request.
  #
  # @return [DefinitionClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#86
  def definition; end

  # Capabilities specific to the diagnostic pull model.
  #
  # @return [DiagnosticClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#281
  def diagnostic; end

  # Capabilities specific to the `textDocument/documentHighlight` request.
  #
  # @return [DocumentHighlightClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#118
  def document_highlight; end

  # Capabilities specific to the `textDocument/documentLink` request.
  #
  # @return [DocumentLinkClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#150
  def document_link; end

  # Capabilities specific to the `textDocument/documentSymbol` request.
  #
  # @return [DocumentSymbolClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#126
  def document_symbol; end

  # Capabilities specific to the `textDocument/foldingRange` request.
  #
  # @return [FoldingRangeClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#209
  def folding_range; end

  # Capabilities specific to the `textDocument/formatting` request.
  #
  # @return [DocumentFormattingClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#167
  def formatting; end

  # Capabilities specific to the `textDocument/hover` request.
  #
  # @return [HoverClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#62
  def hover; end

  # Capabilities specific to the `textDocument/implementation` request.
  #
  # @return [ImplementationClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#102
  def implementation; end

  # Capabilities specific to the `textDocument/inlayHint` request.
  #
  # @return [InlayHintClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#273
  def inlay_hint; end

  # Capabilities specific to the `textDocument/inlineValue` request.
  #
  # @return [InlineValueClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#265
  def inline_value; end

  # Capabilities specific to the `textDocument/linkedEditingRange` request.
  #
  # @return [LinkedEditingRangeClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#225
  def linked_editing_range; end

  # Capabilities specific to the `textDocument/moniker` request.
  #
  # @return [MonikerClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#249
  def moniker; end

  # request.
  # Capabilities specific to the `textDocument/onTypeFormatting` request.
  #
  # @return [DocumentOnTypeFormattingClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#184
  def on_type_formatting; end

  # Capabilities specific to the `textDocument/publishDiagnostics`
  # notification.
  #
  # @return [PublishDiagnosticsClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#201
  def publish_diagnostics; end

  # Capabilities specific to the `textDocument/rangeFormatting` request.
  #
  # @return [DocumentRangeFormattingClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#175
  def range_formatting; end

  # Capabilities specific to the `textDocument/references` request.
  #
  # @return [ReferenceClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#110
  def references; end

  # Capabilities specific to the `textDocument/rename` request.
  #
  # @return [RenameClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#192
  def rename; end

  # Capabilities specific to the `textDocument/selectionRange` request.
  #
  # @return [SelectionRangeClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#217
  def selection_range; end

  # Capabilities specific to the various semantic token requests.
  #
  # @return [SemanticTokensClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#241
  def semantic_tokens; end

  # Capabilities specific to the `textDocument/signatureHelp` request.
  #
  # @return [SignatureHelpClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#70
  def signature_help; end

  # @return [TextDocumentSyncClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#46
  def synchronization; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#287
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#291
  def to_json(*args); end

  # Capabilities specific to the `textDocument/typeDefinition` request.
  #
  # @return [TypeDefinitionClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#94
  def type_definition; end

  # Capabilities specific to the various type hierarchy requests.
  #
  # @return [TypeHierarchyClientCapabilities]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_client_capabilities.rb#257
  def type_hierarchy; end
end

# An event describing a change to a text document. If only a text is provided
# it is considered to be the full content of the document.
#
# source://language_server-protocol//lib/language_server/protocol/interface/text_document_content_change_event.rb#8
class LanguageServer::Protocol::Interface::TextDocumentContentChangeEvent
  # @return [TextDocumentContentChangeEvent] a new instance of TextDocumentContentChangeEvent
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_content_change_event.rb#9
  def initialize(text:, range: T.unsafe(nil), range_length: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_content_change_event.rb#47
  def attributes; end

  # The range of the document that changed.
  #
  # @return [Range, nil]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_content_change_event.rb#23
  def range; end

  # The optional length of the range that got replaced.
  #
  # @return [number, nil]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_content_change_event.rb#31
  def range_length; end

  # The new text for the provided range.
  #
  # --- OR ---
  #
  # The new text of the whole document.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_content_change_event.rb#43
  def text; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_content_change_event.rb#49
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_content_change_event.rb#53
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/text_document_edit.rb#4
class LanguageServer::Protocol::Interface::TextDocumentEdit
  # @return [TextDocumentEdit] a new instance of TextDocumentEdit
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_edit.rb#5
  def initialize(text_document:, edits:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_edit.rb#30
  def attributes; end

  # The edits to be applied.
  #
  # @return [(TextEdit | AnnotatedTextEdit)[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_edit.rb#26
  def edits; end

  # The text document to change.
  #
  # @return [OptionalVersionedTextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_edit.rb#18
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_edit.rb#32
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_edit.rb#36
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/text_document_identifier.rb#4
class LanguageServer::Protocol::Interface::TextDocumentIdentifier
  # @return [TextDocumentIdentifier] a new instance of TextDocumentIdentifier
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_identifier.rb#5
  def initialize(uri:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_identifier.rb#21
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_identifier.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_identifier.rb#27
  def to_json(*args); end

  # The text document's URI.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_identifier.rb#17
  def uri; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/text_document_item.rb#4
class LanguageServer::Protocol::Interface::TextDocumentItem
  # @return [TextDocumentItem] a new instance of TextDocumentItem
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_item.rb#5
  def initialize(uri:, language_id:, version:, text:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_item.rb#49
  def attributes; end

  # The text document's language identifier.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_item.rb#28
  def language_id; end

  # The content of the opened text document.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_item.rb#45
  def text; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_item.rb#51
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_item.rb#55
  def to_json(*args); end

  # The text document's URI.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_item.rb#20
  def uri; end

  # The version number of this document (it will increase after each
  # change, including undo/redo).
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_item.rb#37
  def version; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/text_document_position_params.rb#4
class LanguageServer::Protocol::Interface::TextDocumentPositionParams
  # @return [TextDocumentPositionParams] a new instance of TextDocumentPositionParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_position_params.rb#5
  def initialize(text_document:, position:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_position_params.rb#30
  def attributes; end

  # The position inside the text document.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_position_params.rb#26
  def position; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_position_params.rb#18
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_position_params.rb#32
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_position_params.rb#36
  def to_json(*args); end
end

# General text document registration options.
#
# source://language_server-protocol//lib/language_server/protocol/interface/text_document_registration_options.rb#7
class LanguageServer::Protocol::Interface::TextDocumentRegistrationOptions
  # @return [TextDocumentRegistrationOptions] a new instance of TextDocumentRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_registration_options.rb#8
  def initialize(document_selector:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_registration_options.rb#25
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_registration_options.rb#21
  def document_selector; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_registration_options.rb#27
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_registration_options.rb#31
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/text_document_save_registration_options.rb#4
class LanguageServer::Protocol::Interface::TextDocumentSaveRegistrationOptions
  # @return [TextDocumentSaveRegistrationOptions] a new instance of TextDocumentSaveRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_save_registration_options.rb#5
  def initialize(document_selector:, include_text: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_save_registration_options.rb#31
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_save_registration_options.rb#19
  def document_selector; end

  # The client is supposed to include the content on save.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_save_registration_options.rb#27
  def include_text; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_save_registration_options.rb#33
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_save_registration_options.rb#37
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::TextDocumentSyncClientCapabilities
  # @return [TextDocumentSyncClientCapabilities] a new instance of TextDocumentSyncClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil), will_save: T.unsafe(nil), will_save_wait_until: T.unsafe(nil), did_save: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_client_capabilities.rb#50
  def attributes; end

  # The client supports did save notifications.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_client_capabilities.rb#46
  def did_save; end

  # Whether text document synchronization supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_client_capabilities.rb#20
  def dynamic_registration; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_client_capabilities.rb#52
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_client_capabilities.rb#56
  def to_json(*args); end

  # The client supports sending will save notifications.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_client_capabilities.rb#28
  def will_save; end

  # The client supports sending a will save request and
  # waits for a response providing text edits which will
  # be applied to the document before it is saved.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_client_capabilities.rb#38
  def will_save_wait_until; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_options.rb#4
class LanguageServer::Protocol::Interface::TextDocumentSyncOptions
  # @return [TextDocumentSyncOptions] a new instance of TextDocumentSyncOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_options.rb#5
  def initialize(open_close: T.unsafe(nil), change: T.unsafe(nil), will_save: T.unsafe(nil), will_save_wait_until: T.unsafe(nil), save: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_options.rb#66
  def attributes; end

  # Change notifications are sent to the server. See
  # TextDocumentSyncKind.None, TextDocumentSyncKind.Full and
  # TextDocumentSyncKind.Incremental. If omitted it defaults to
  # TextDocumentSyncKind.None.
  #
  # @return [TextDocumentSyncKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_options.rb#35
  def change; end

  # Open and close notifications are sent to the server. If omitted open
  # close notifications should not be sent.
  # Open and close notifications are sent to the server. If omitted open
  # close notification should not be sent.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_options.rb#24
  def open_close; end

  # If present save notifications are sent to the server. If omitted the
  # notification should not be sent.
  #
  # @return [boolean | SaveOptions]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_options.rb#62
  def save; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_options.rb#68
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_options.rb#72
  def to_json(*args); end

  # If present will save notifications are sent to the server. If omitted
  # the notification should not be sent.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_options.rb#44
  def will_save; end

  # If present will save wait until requests are sent to the server. If
  # omitted the request should not be sent.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_document_sync_options.rb#53
  def will_save_wait_until; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/text_edit.rb#4
class LanguageServer::Protocol::Interface::TextEdit
  # @return [TextEdit] a new instance of TextEdit
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_edit.rb#5
  def initialize(range:, new_text:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_edit.rb#32
  def attributes; end

  # The string to be inserted. For delete operations use an
  # empty string.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_edit.rb#28
  def new_text; end

  # The range of the text document to be manipulated. To insert
  # text into a document create a range where start === end.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/text_edit.rb#19
  def range; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_edit.rb#34
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/text_edit.rb#38
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/type_definition_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::TypeDefinitionClientCapabilities
  # @return [TypeDefinitionClientCapabilities] a new instance of TypeDefinitionClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil), link_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_client_capabilities.rb#32
  def attributes; end

  # Whether implementation supports dynamic registration. If this is set to
  # `true` the client supports the new `TypeDefinitionRegistrationOptions`
  # return value for the corresponding server capability as well.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_client_capabilities.rb#20
  def dynamic_registration; end

  # The client supports additional metadata in the form of definition links.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_client_capabilities.rb#28
  def link_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_client_capabilities.rb#34
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_client_capabilities.rb#38
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/type_definition_options.rb#4
class LanguageServer::Protocol::Interface::TypeDefinitionOptions
  # @return [TypeDefinitionOptions] a new instance of TypeDefinitionOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_options.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_options.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_options.rb#24
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_options.rb#14
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/type_definition_params.rb#4
class LanguageServer::Protocol::Interface::TypeDefinitionParams
  # @return [TypeDefinitionParams] a new instance of TypeDefinitionParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_params.rb#5
  def initialize(text_document:, position:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_params.rb#49
  def attributes; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_params.rb#45
  def partial_result_token; end

  # The position inside the text document.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_params.rb#28
  def position; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_params.rb#20
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_params.rb#51
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_params.rb#55
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_params.rb#36
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/type_definition_registration_options.rb#4
class LanguageServer::Protocol::Interface::TypeDefinitionRegistrationOptions
  # @return [TypeDefinitionRegistrationOptions] a new instance of TypeDefinitionRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil), id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_registration_options.rb#38
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_registration_options.rb#20
  def document_selector; end

  # The id used to register the request. The id can be used to deregister
  # the request again. See also Registration#id.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_registration_options.rb#34
  def id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_registration_options.rb#40
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_registration_options.rb#44
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_definition_registration_options.rb#25
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_item.rb#4
class LanguageServer::Protocol::Interface::TypeHierarchyItem
  # @return [TypeHierarchyItem] a new instance of TypeHierarchyItem
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_item.rb#5
  def initialize(name:, kind:, uri:, range:, selection_range:, tags: T.unsafe(nil), detail: T.unsafe(nil), data: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_item.rb#90
  def attributes; end

  # A data entry field that is preserved between a type hierarchy prepare and
  # supertypes or subtypes requests. It could also be used to identify the
  # type hierarchy in the server, helping improve the performance on
  # resolving supertypes and subtypes.
  #
  # @return [LSPAny]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_item.rb#86
  def data; end

  # More detail for this item, e.g. the signature of a function.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_item.rb#48
  def detail; end

  # The kind of this item.
  #
  # @return [SymbolKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_item.rb#32
  def kind; end

  # The name of this item.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_item.rb#24
  def name; end

  # The range enclosing this symbol not including leading/trailing whitespace
  # but everything else, e.g. comments and code.
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_item.rb#65
  def range; end

  # The range that should be selected and revealed when this symbol is being
  # picked, e.g. the name of a function. Must be contained by the
  # [`range`](#TypeHierarchyItem.range).
  #
  # @return [Range]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_item.rb#75
  def selection_range; end

  # Tags for this item.
  #
  # @return [1[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_item.rb#40
  def tags; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_item.rb#92
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_item.rb#96
  def to_json(*args); end

  # The resource identifier of this item.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_item.rb#56
  def uri; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_options.rb#4
class LanguageServer::Protocol::Interface::TypeHierarchyOptions
  # @return [TypeHierarchyOptions] a new instance of TypeHierarchyOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_options.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_options.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_options.rb#24
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_options.rb#14
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_prepare_params.rb#4
class LanguageServer::Protocol::Interface::TypeHierarchyPrepareParams
  # @return [TypeHierarchyPrepareParams] a new instance of TypeHierarchyPrepareParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_prepare_params.rb#5
  def initialize(text_document:, position:, work_done_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_prepare_params.rb#39
  def attributes; end

  # The position inside the text document.
  #
  # @return [Position]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_prepare_params.rb#27
  def position; end

  # The text document.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_prepare_params.rb#19
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_prepare_params.rb#41
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_prepare_params.rb#45
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_prepare_params.rb#35
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_registration_options.rb#4
class LanguageServer::Protocol::Interface::TypeHierarchyRegistrationOptions
  # @return [TypeHierarchyRegistrationOptions] a new instance of TypeHierarchyRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_registration_options.rb#5
  def initialize(document_selector:, work_done_progress: T.unsafe(nil), id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_registration_options.rb#38
  def attributes; end

  # A document selector to identify the scope of the registration. If set to
  # null the document selector provided on the client side will be used.
  #
  # @return [DocumentSelector]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_registration_options.rb#20
  def document_selector; end

  # The id used to register the request. The id can be used to deregister
  # the request again. See also Registration#id.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_registration_options.rb#34
  def id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_registration_options.rb#40
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_registration_options.rb#44
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_registration_options.rb#25
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_subtypes_params.rb#4
class LanguageServer::Protocol::Interface::TypeHierarchySubtypesParams
  # @return [TypeHierarchySubtypesParams] a new instance of TypeHierarchySubtypesParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_subtypes_params.rb#5
  def initialize(item:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_subtypes_params.rb#37
  def attributes; end

  # @return [TypeHierarchyItem]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_subtypes_params.rb#33
  def item; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_subtypes_params.rb#28
  def partial_result_token; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_subtypes_params.rb#39
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_subtypes_params.rb#43
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_subtypes_params.rb#19
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_supertypes_params.rb#4
class LanguageServer::Protocol::Interface::TypeHierarchySupertypesParams
  # @return [TypeHierarchySupertypesParams] a new instance of TypeHierarchySupertypesParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_supertypes_params.rb#5
  def initialize(item:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_supertypes_params.rb#37
  def attributes; end

  # @return [TypeHierarchyItem]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_supertypes_params.rb#33
  def item; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_supertypes_params.rb#28
  def partial_result_token; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_supertypes_params.rb#39
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_supertypes_params.rb#43
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/type_hierarchy_supertypes_params.rb#19
  def work_done_token; end
end

# A diagnostic report indicating that the last returned
# report is still accurate.
#
# source://language_server-protocol//lib/language_server/protocol/interface/unchanged_document_diagnostic_report.rb#8
class LanguageServer::Protocol::Interface::UnchangedDocumentDiagnosticReport
  # @return [UnchangedDocumentDiagnosticReport] a new instance of UnchangedDocumentDiagnosticReport
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/unchanged_document_diagnostic_report.rb#9
  def initialize(kind:, result_id:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/unchanged_document_diagnostic_report.rb#38
  def attributes; end

  # A document diagnostic report indicating
  # no changes to the last result. A server can
  # only return `unchanged` if result ids are
  # provided.
  #
  # @return [any]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/unchanged_document_diagnostic_report.rb#25
  def kind; end

  # A result id which will be sent on the next
  # diagnostic request for the same document.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/unchanged_document_diagnostic_report.rb#34
  def result_id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/unchanged_document_diagnostic_report.rb#40
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/unchanged_document_diagnostic_report.rb#44
  def to_json(*args); end
end

# General parameters to unregister a capability.
#
# source://language_server-protocol//lib/language_server/protocol/interface/unregistration.rb#7
class LanguageServer::Protocol::Interface::Unregistration
  # @return [Unregistration] a new instance of Unregistration
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/unregistration.rb#8
  def initialize(id:, method:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/unregistration.rb#34
  def attributes; end

  # The id used to unregister the request or notification. Usually an id
  # provided during the register request.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/unregistration.rb#22
  def id; end

  # The method / capability to unregister for.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/unregistration.rb#30
  def method; end

  # source://language_server-protocol//lib/language_server/protocol/interface/unregistration.rb#36
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/unregistration.rb#40
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/unregistration_params.rb#4
class LanguageServer::Protocol::Interface::UnregistrationParams
  # @return [UnregistrationParams] a new instance of UnregistrationParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/unregistration_params.rb#5
  def initialize(unregisterations:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/unregistration_params.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/unregistration_params.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/unregistration_params.rb#24
  def to_json(*args); end

  # @return [Unregistration[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/unregistration_params.rb#14
  def unregisterations; end
end

# A versioned notebook document identifier.
#
# source://language_server-protocol//lib/language_server/protocol/interface/versioned_notebook_document_identifier.rb#7
class LanguageServer::Protocol::Interface::VersionedNotebookDocumentIdentifier
  # @return [VersionedNotebookDocumentIdentifier] a new instance of VersionedNotebookDocumentIdentifier
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/versioned_notebook_document_identifier.rb#8
  def initialize(version:, uri:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/versioned_notebook_document_identifier.rb#33
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/versioned_notebook_document_identifier.rb#35
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/versioned_notebook_document_identifier.rb#39
  def to_json(*args); end

  # The notebook document's URI.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/versioned_notebook_document_identifier.rb#29
  def uri; end

  # The version number of this notebook document.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/versioned_notebook_document_identifier.rb#21
  def version; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/versioned_text_document_identifier.rb#4
class LanguageServer::Protocol::Interface::VersionedTextDocumentIdentifier
  # @return [VersionedTextDocumentIdentifier] a new instance of VersionedTextDocumentIdentifier
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/versioned_text_document_identifier.rb#5
  def initialize(uri:, version:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/versioned_text_document_identifier.rb#33
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/versioned_text_document_identifier.rb#35
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/versioned_text_document_identifier.rb#39
  def to_json(*args); end

  # The text document's URI.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/versioned_text_document_identifier.rb#18
  def uri; end

  # The version number of this document.
  #
  # The version number of a document will increase after each change,
  # including undo/redo. The number doesn't need to be consecutive.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/versioned_text_document_identifier.rb#29
  def version; end
end

# The parameters send in a will save text document notification.
#
# source://language_server-protocol//lib/language_server/protocol/interface/will_save_text_document_params.rb#7
class LanguageServer::Protocol::Interface::WillSaveTextDocumentParams
  # @return [WillSaveTextDocumentParams] a new instance of WillSaveTextDocumentParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/will_save_text_document_params.rb#8
  def initialize(text_document:, reason:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/will_save_text_document_params.rb#33
  def attributes; end

  # The 'TextDocumentSaveReason'.
  #
  # @return [TextDocumentSaveReason]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/will_save_text_document_params.rb#29
  def reason; end

  # The document that will be saved.
  #
  # @return [TextDocumentIdentifier]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/will_save_text_document_params.rb#21
  def text_document; end

  # source://language_server-protocol//lib/language_server/protocol/interface/will_save_text_document_params.rb#35
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/will_save_text_document_params.rb#39
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_begin.rb#4
class LanguageServer::Protocol::Interface::WorkDoneProgressBegin
  # @return [WorkDoneProgressBegin] a new instance of WorkDoneProgressBegin
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_begin.rb#5
  def initialize(kind:, title:, cancellable: T.unsafe(nil), message: T.unsafe(nil), percentage: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_begin.rb#68
  def attributes; end

  # Controls if a cancel button should show to allow the user to cancel the
  # long running operation. Clients that don't support cancellation are
  # allowed to ignore the setting.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_begin.rb#39
  def cancellable; end

  # @return ["begin"]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_begin.rb#18
  def kind; end

  # Optional, more detailed associated progress message. Contains
  # complementary information to the `title`.
  #
  # Examples: "3/25 files", "project/src/module2", "node_modules/some_dep".
  # If unset, the previous progress message (if any) is still valid.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_begin.rb#51
  def message; end

  # Optional progress percentage to display (value 100 is considered 100%).
  # If not provided infinite progress is assumed and clients are allowed
  # to ignore the `percentage` value in subsequent in report notifications.
  #
  # The value should be steadily rising. Clients are free to ignore values
  # that are not following this rule. The value range is [0, 100]
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_begin.rb#64
  def percentage; end

  # Mandatory title of the progress operation. Used to briefly inform about
  # the kind of operation being performed.
  #
  # Examples: "Indexing" or "Linking dependencies".
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_begin.rb#29
  def title; end

  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_begin.rb#70
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_begin.rb#74
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_cancel_params.rb#4
class LanguageServer::Protocol::Interface::WorkDoneProgressCancelParams
  # @return [WorkDoneProgressCancelParams] a new instance of WorkDoneProgressCancelParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_cancel_params.rb#5
  def initialize(token:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_cancel_params.rb#21
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_cancel_params.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_cancel_params.rb#27
  def to_json(*args); end

  # The token to be used to report progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_cancel_params.rb#17
  def token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_create_params.rb#4
class LanguageServer::Protocol::Interface::WorkDoneProgressCreateParams
  # @return [WorkDoneProgressCreateParams] a new instance of WorkDoneProgressCreateParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_create_params.rb#5
  def initialize(token:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_create_params.rb#21
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_create_params.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_create_params.rb#27
  def to_json(*args); end

  # The token to be used to report progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_create_params.rb#17
  def token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_end.rb#4
class LanguageServer::Protocol::Interface::WorkDoneProgressEnd
  # @return [WorkDoneProgressEnd] a new instance of WorkDoneProgressEnd
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_end.rb#5
  def initialize(kind:, message: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_end.rb#28
  def attributes; end

  # @return ["end"]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_end.rb#15
  def kind; end

  # Optional, a final message indicating to for example indicate the outcome
  # of the operation.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_end.rb#24
  def message; end

  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_end.rb#30
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_end.rb#34
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_options.rb#4
class LanguageServer::Protocol::Interface::WorkDoneProgressOptions
  # @return [WorkDoneProgressOptions] a new instance of WorkDoneProgressOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_options.rb#18
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_options.rb#20
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_options.rb#24
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_options.rb#14
  def work_done_progress; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_params.rb#4
class LanguageServer::Protocol::Interface::WorkDoneProgressParams
  # @return [WorkDoneProgressParams] a new instance of WorkDoneProgressParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_params.rb#5
  def initialize(work_done_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_params.rb#21
  def attributes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_params.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_params.rb#27
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_params.rb#17
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_report.rb#4
class LanguageServer::Protocol::Interface::WorkDoneProgressReport
  # @return [WorkDoneProgressReport] a new instance of WorkDoneProgressReport
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_report.rb#5
  def initialize(kind:, cancellable: T.unsafe(nil), message: T.unsafe(nil), percentage: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_report.rb#58
  def attributes; end

  # Controls enablement state of a cancel button. This property is only valid
  # if a cancel button got requested in the `WorkDoneProgressBegin` payload.
  #
  # Clients that don't support cancellation or don't support control the
  # button's enablement state are allowed to ignore the setting.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_report.rb#29
  def cancellable; end

  # @return ["report"]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_report.rb#17
  def kind; end

  # Optional, more detailed associated progress message. Contains
  # complementary information to the `title`.
  #
  # Examples: "3/25 files", "project/src/module2", "node_modules/some_dep".
  # If unset, the previous progress message (if any) is still valid.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_report.rb#41
  def message; end

  # Optional progress percentage to display (value 100 is considered 100%).
  # If not provided infinite progress is assumed and clients are allowed
  # to ignore the `percentage` value in subsequent in report notifications.
  #
  # The value should be steadily rising. Clients are free to ignore values
  # that are not following this rule. The value range is [0, 100]
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_report.rb#54
  def percentage; end

  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_report.rb#60
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/work_done_progress_report.rb#64
  def to_json(*args); end
end

# Parameters of the workspace diagnostic request.
#
# source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_params.rb#7
class LanguageServer::Protocol::Interface::WorkspaceDiagnosticParams
  # @return [WorkspaceDiagnosticParams] a new instance of WorkspaceDiagnosticParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_params.rb#8
  def initialize(previous_result_ids:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil), identifier: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_params.rb#53
  def attributes; end

  # The additional identifier provided during registration.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_params.rb#40
  def identifier; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_params.rb#32
  def partial_result_token; end

  # The currently known diagnostic reports with their
  # previous result ids.
  #
  # @return [PreviousResultId[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_params.rb#49
  def previous_result_ids; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_params.rb#55
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_params.rb#59
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_params.rb#23
  def work_done_token; end
end

# A workspace diagnostic report.
#
# source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_report.rb#7
class LanguageServer::Protocol::Interface::WorkspaceDiagnosticReport
  # @return [WorkspaceDiagnosticReport] a new instance of WorkspaceDiagnosticReport
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_report.rb#8
  def initialize(items:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_report.rb#21
  def attributes; end

  # @return [WorkspaceDocumentDiagnosticReport[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_report.rb#17
  def items; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_report.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_report.rb#27
  def to_json(*args); end
end

# A partial result for a workspace diagnostic report.
#
# source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_report_partial_result.rb#7
class LanguageServer::Protocol::Interface::WorkspaceDiagnosticReportPartialResult
  # @return [WorkspaceDiagnosticReportPartialResult] a new instance of WorkspaceDiagnosticReportPartialResult
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_report_partial_result.rb#8
  def initialize(items:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_report_partial_result.rb#21
  def attributes; end

  # @return [WorkspaceDocumentDiagnosticReport[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_report_partial_result.rb#17
  def items; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_report_partial_result.rb#23
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_diagnostic_report_partial_result.rb#27
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit.rb#4
class LanguageServer::Protocol::Interface::WorkspaceEdit
  # @return [WorkspaceEdit] a new instance of WorkspaceEdit
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit.rb#5
  def initialize(changes: T.unsafe(nil), document_changes: T.unsafe(nil), change_annotations: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit.rb#56
  def attributes; end

  # A map of change annotations that can be referenced in
  # `AnnotatedTextEdit`s or create, rename and delete file / folder
  # operations.
  #
  # Whether clients honor this property depends on the client capability
  # `workspace.changeAnnotationSupport`.
  #
  # @return [{ [id: string]: ChangeAnnotation; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit.rb#52
  def change_annotations; end

  # Holds changes to existing resources.
  #
  # @return [{}]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit.rb#19
  def changes; end

  # Depending on the client capability
  # `workspace.workspaceEdit.resourceOperations` document changes are either
  # an array of `TextDocumentEdit`s to express changes to n different text
  # documents where each text document edit addresses a specific version of
  # a text document. Or it can contain above `TextDocumentEdit`s mixed with
  # create, rename and delete file / folder operations.
  #
  # Whether a client supports versioned document edits is expressed via
  # `workspace.workspaceEdit.documentChanges` client capability.
  #
  # If a client neither supports `documentChanges` nor
  # `workspace.workspaceEdit.resourceOperations` then only plain `TextEdit`s
  # using the `changes` property are supported.
  #
  # @return [TextDocumentEdit[] | (TextDocumentEdit | CreateFile | RenameFile | DeleteFile)[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit.rb#39
  def document_changes; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit.rb#58
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit.rb#62
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::WorkspaceEditClientCapabilities
  # @return [WorkspaceEditClientCapabilities] a new instance of WorkspaceEditClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit_client_capabilities.rb#5
  def initialize(document_changes: T.unsafe(nil), resource_operations: T.unsafe(nil), failure_handling: T.unsafe(nil), normalizes_line_endings: T.unsafe(nil), change_annotation_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit_client_capabilities.rb#63
  def attributes; end

  # Whether the client in general supports change annotations on text edits,
  # create file, rename file and delete file changes.
  #
  # @return [{ groupsOnLabel?: boolean; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit_client_capabilities.rb#59
  def change_annotation_support; end

  # The client supports versioned document changes in `WorkspaceEdit`s
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit_client_capabilities.rb#21
  def document_changes; end

  # The failure handling strategy of a client if applying the workspace edit
  # fails.
  #
  # @return [FailureHandlingKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit_client_capabilities.rb#39
  def failure_handling; end

  # Whether the client normalizes line endings to the client specific
  # setting.
  # If set to `true` the client will normalize line ending characters
  # in a workspace edit to the client specific new line character(s).
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit_client_capabilities.rb#50
  def normalizes_line_endings; end

  # The resource operations the client supports. Clients should at least
  # support 'create', 'rename' and 'delete' files and folders.
  #
  # @return [ResourceOperationKind[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit_client_capabilities.rb#30
  def resource_operations; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit_client_capabilities.rb#65
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_edit_client_capabilities.rb#69
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/workspace_folder.rb#4
class LanguageServer::Protocol::Interface::WorkspaceFolder
  # @return [WorkspaceFolder] a new instance of WorkspaceFolder
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folder.rb#5
  def initialize(uri:, name:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folder.rb#31
  def attributes; end

  # The name of the workspace folder. Used to refer to this
  # workspace folder in the user interface.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folder.rb#27
  def name; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folder.rb#33
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folder.rb#37
  def to_json(*args); end

  # The associated URI for this workspace folder.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folder.rb#18
  def uri; end
end

# The workspace folder change event.
#
# source://language_server-protocol//lib/language_server/protocol/interface/workspace_folders_change_event.rb#7
class LanguageServer::Protocol::Interface::WorkspaceFoldersChangeEvent
  # @return [WorkspaceFoldersChangeEvent] a new instance of WorkspaceFoldersChangeEvent
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folders_change_event.rb#8
  def initialize(added:, removed:); end

  # The array of added workspace folders
  #
  # @return [WorkspaceFolder[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folders_change_event.rb#21
  def added; end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folders_change_event.rb#33
  def attributes; end

  # The array of the removed workspace folders
  #
  # @return [WorkspaceFolder[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folders_change_event.rb#29
  def removed; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folders_change_event.rb#35
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folders_change_event.rb#39
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/workspace_folders_server_capabilities.rb#4
class LanguageServer::Protocol::Interface::WorkspaceFoldersServerCapabilities
  # @return [WorkspaceFoldersServerCapabilities] a new instance of WorkspaceFoldersServerCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folders_server_capabilities.rb#5
  def initialize(supported: T.unsafe(nil), change_notifications: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folders_server_capabilities.rb#36
  def attributes; end

  # Whether the server wants to receive workspace folder
  # change notifications.
  #
  # If a string is provided, the string is treated as an ID
  # under which the notification is registered on the client
  # side. The ID can be used to unregister for these events
  # using the `client/unregisterCapability` request.
  #
  # @return [string | boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folders_server_capabilities.rb#32
  def change_notifications; end

  # The server has support for workspace folders
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folders_server_capabilities.rb#18
  def supported; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folders_server_capabilities.rb#38
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_folders_server_capabilities.rb#42
  def to_json(*args); end
end

# A full document diagnostic report for a workspace diagnostic result.
#
# source://language_server-protocol//lib/language_server/protocol/interface/workspace_full_document_diagnostic_report.rb#7
class LanguageServer::Protocol::Interface::WorkspaceFullDocumentDiagnosticReport
  # @return [WorkspaceFullDocumentDiagnosticReport] a new instance of WorkspaceFullDocumentDiagnosticReport
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_full_document_diagnostic_report.rb#8
  def initialize(kind:, items:, uri:, version:, result_id: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_full_document_diagnostic_report.rb#63
  def attributes; end

  # The actual items.
  #
  # @return [Diagnostic[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_full_document_diagnostic_report.rb#42
  def items; end

  # A full document diagnostic report.
  #
  # @return [any]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_full_document_diagnostic_report.rb#24
  def kind; end

  # An optional result id. If provided it will
  # be sent on the next diagnostic request for the
  # same document.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_full_document_diagnostic_report.rb#34
  def result_id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_full_document_diagnostic_report.rb#65
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_full_document_diagnostic_report.rb#69
  def to_json(*args); end

  # The URI for which diagnostic information is reported.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_full_document_diagnostic_report.rb#50
  def uri; end

  # The version number for which the diagnostics are reported.
  # If the document is not marked as open `null` can be provided.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_full_document_diagnostic_report.rb#59
  def version; end
end

# A special workspace symbol that supports locations without a range
#
# source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol.rb#7
class LanguageServer::Protocol::Interface::WorkspaceSymbol
  # @return [WorkspaceSymbol] a new instance of WorkspaceSymbol
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol.rb#8
  def initialize(name:, kind:, location:, tags: T.unsafe(nil), container_name: T.unsafe(nil), data: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol.rb#77
  def attributes; end

  # The name of the symbol containing this symbol. This information is for
  # user interface purposes (e.g. to render a qualifier in the user interface
  # if necessary). It can't be used to re-infer a hierarchy for the document
  # symbols.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol.rb#52
  def container_name; end

  # A data entry field that is preserved on a workspace symbol between a
  # workspace symbol request and a workspace symbol resolve request.
  #
  # @return [LSPAny]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol.rb#73
  def data; end

  # The kind of this symbol.
  #
  # @return [SymbolKind]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol.rb#33
  def kind; end

  # The location of this symbol. Whether a server is allowed to
  # return a location without a range depends on the client
  # capability `workspace.symbol.resolveSupport`.
  #
  # See also `SymbolInformation.location`.
  #
  # @return [Location | { uri: string; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol.rb#64
  def location; end

  # The name of this symbol.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol.rb#25
  def name; end

  # Tags for this completion item.
  #
  # @return [1[]]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol.rb#41
  def tags; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol.rb#79
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol.rb#83
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_client_capabilities.rb#4
class LanguageServer::Protocol::Interface::WorkspaceSymbolClientCapabilities
  # @return [WorkspaceSymbolClientCapabilities] a new instance of WorkspaceSymbolClientCapabilities
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_client_capabilities.rb#5
  def initialize(dynamic_registration: T.unsafe(nil), symbol_kind: T.unsafe(nil), tag_support: T.unsafe(nil), resolve_support: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_client_capabilities.rb#52
  def attributes; end

  # Symbol request supports dynamic registration.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_client_capabilities.rb#20
  def dynamic_registration; end

  # The client support partial workspace symbols. The client will send the
  # request `workspaceSymbol/resolve` to the server to resolve additional
  # properties.
  #
  # @return [{ properties: string[]; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_client_capabilities.rb#48
  def resolve_support; end

  # Specific capabilities for the `SymbolKind` in the `workspace/symbol`
  # request.
  #
  # @return [{ valueSet?: SymbolKind[]; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_client_capabilities.rb#29
  def symbol_kind; end

  # The client supports tags on `SymbolInformation` and `WorkspaceSymbol`.
  # Clients supporting tags have to handle unknown tags gracefully.
  #
  # @return [{ valueSet: 1[]; }]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_client_capabilities.rb#38
  def tag_support; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_client_capabilities.rb#54
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_client_capabilities.rb#58
  def to_json(*args); end
end

# source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_options.rb#4
class LanguageServer::Protocol::Interface::WorkspaceSymbolOptions
  # @return [WorkspaceSymbolOptions] a new instance of WorkspaceSymbolOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil), resolve_provider: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_options.rb#28
  def attributes; end

  # The server provides support to resolve additional
  # information for a workspace symbol.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_options.rb#24
  def resolve_provider; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_options.rb#30
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_options.rb#34
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_options.rb#15
  def work_done_progress; end
end

# The parameters of a Workspace Symbol Request.
#
# source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_params.rb#7
class LanguageServer::Protocol::Interface::WorkspaceSymbolParams
  # @return [WorkspaceSymbolParams] a new instance of WorkspaceSymbolParams
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_params.rb#8
  def initialize(query:, work_done_token: T.unsafe(nil), partial_result_token: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_params.rb#44
  def attributes; end

  # An optional token that a server can use to report partial results (e.g.
  # streaming) to the client.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_params.rb#31
  def partial_result_token; end

  # A query string to filter symbols by. Clients may send an empty
  # string here to request all symbols.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_params.rb#40
  def query; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_params.rb#46
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_params.rb#50
  def to_json(*args); end

  # An optional token that a server can use to report work done progress.
  #
  # @return [ProgressToken]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_params.rb#22
  def work_done_token; end
end

# source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_registration_options.rb#4
class LanguageServer::Protocol::Interface::WorkspaceSymbolRegistrationOptions
  # @return [WorkspaceSymbolRegistrationOptions] a new instance of WorkspaceSymbolRegistrationOptions
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_registration_options.rb#5
  def initialize(work_done_progress: T.unsafe(nil), resolve_provider: T.unsafe(nil)); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_registration_options.rb#28
  def attributes; end

  # The server provides support to resolve additional
  # information for a workspace symbol.
  #
  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_registration_options.rb#24
  def resolve_provider; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_registration_options.rb#30
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_registration_options.rb#34
  def to_json(*args); end

  # @return [boolean]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_symbol_registration_options.rb#15
  def work_done_progress; end
end

# An unchanged document diagnostic report for a workspace diagnostic result.
#
# source://language_server-protocol//lib/language_server/protocol/interface/workspace_unchanged_document_diagnostic_report.rb#7
class LanguageServer::Protocol::Interface::WorkspaceUnchangedDocumentDiagnosticReport
  # @return [WorkspaceUnchangedDocumentDiagnosticReport] a new instance of WorkspaceUnchangedDocumentDiagnosticReport
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_unchanged_document_diagnostic_report.rb#8
  def initialize(kind:, result_id:, uri:, version:); end

  # Returns the value of attribute attributes.
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_unchanged_document_diagnostic_report.rb#56
  def attributes; end

  # A document diagnostic report indicating
  # no changes to the last result. A server can
  # only return `unchanged` if result ids are
  # provided.
  #
  # @return [any]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_unchanged_document_diagnostic_report.rb#26
  def kind; end

  # A result id which will be sent on the next
  # diagnostic request for the same document.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_unchanged_document_diagnostic_report.rb#35
  def result_id; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_unchanged_document_diagnostic_report.rb#58
  def to_hash; end

  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_unchanged_document_diagnostic_report.rb#62
  def to_json(*args); end

  # The URI for which diagnostic information is reported.
  #
  # @return [string]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_unchanged_document_diagnostic_report.rb#43
  def uri; end

  # The version number for which the diagnostics are reported.
  # If the document is not marked as open `null` can be provided.
  #
  # @return [number]
  #
  # source://language_server-protocol//lib/language_server/protocol/interface/workspace_unchanged_document_diagnostic_report.rb#52
  def version; end
end

# source://language_server-protocol//lib/language_server/protocol/transport/io/reader.rb#7
module LanguageServer::Protocol::Transport; end

# source://language_server-protocol//lib/language_server/protocol/transport/io/reader.rb#8
module LanguageServer::Protocol::Transport::Io; end

# source://language_server-protocol//lib/language_server/protocol/transport/io/reader.rb#9
class LanguageServer::Protocol::Transport::Io::Reader
  # @return [Reader] a new instance of Reader
  #
  # source://language_server-protocol//lib/language_server/protocol/transport/io/reader.rb#10
  def initialize(io); end

  # source://language_server-protocol//lib/language_server/protocol/transport/io/reader.rb#24
  def close; end

  # source://language_server-protocol//lib/language_server/protocol/transport/io/reader.rb#15
  def read(&block); end

  private

  # Returns the value of attribute io.
  #
  # source://language_server-protocol//lib/language_server/protocol/transport/io/reader.rb#30
  def io; end
end

# source://language_server-protocol//lib/language_server/protocol/transport/io/writer.rb#5
class LanguageServer::Protocol::Transport::Io::Writer
  # @return [Writer] a new instance of Writer
  #
  # source://language_server-protocol//lib/language_server/protocol/transport/io/writer.rb#8
  def initialize(io); end

  # source://language_server-protocol//lib/language_server/protocol/transport/io/writer.rb#32
  def close; end

  # Returns the value of attribute io.
  #
  # source://language_server-protocol//lib/language_server/protocol/transport/io/writer.rb#6
  def io; end

  # source://language_server-protocol//lib/language_server/protocol/transport/io/writer.rb#13
  def write(response); end
end

# source://language_server-protocol//lib/language_server/protocol/transport/stdio/reader.rb#4
module LanguageServer::Protocol::Transport::Stdio; end

# source://language_server-protocol//lib/language_server/protocol/transport/stdio/reader.rb#5
class LanguageServer::Protocol::Transport::Stdio::Reader < ::LanguageServer::Protocol::Transport::Io::Reader
  # @return [Reader] a new instance of Reader
  #
  # source://language_server-protocol//lib/language_server/protocol/transport/stdio/reader.rb#6
  def initialize; end
end

# source://language_server-protocol//lib/language_server/protocol/transport/stdio/writer.rb#5
class LanguageServer::Protocol::Transport::Stdio::Writer < ::LanguageServer::Protocol::Transport::Io::Writer
  # @return [Writer] a new instance of Writer
  #
  # source://language_server-protocol//lib/language_server/protocol/transport/stdio/writer.rb#6
  def initialize; end
end

# source://language_server-protocol//lib/language_server/protocol/version.rb#3
LanguageServer::Protocol::VERSION = T.let(T.unsafe(nil), String)
