# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `prettyprint` gem.
# Please instead update this file by running `bin/tapioca gem prettyprint`.


# This class implements a pretty printing algorithm. It finds line breaks and
# nice indentations for grouped structure.
#
# By default, the class assumes that primitive elements are strings and each
# byte in the strings have single column in width. But it can be used for
# other situations by giving suitable arguments for some methods:
# * newline object and space generation block for PrettyPrint.new
# * optional width argument for PrettyPrint#text
# * PrettyPrint#breakable
#
# There are several candidate uses:
# * text formatting using proportional fonts
# * multibyte characters which has columns different to number of bytes
# * non-string formatting
#
# == Bugs
# * Box based formatting?
# * Other (better) model/algorithm?
#
# Report any bugs at http://bugs.ruby-lang.org
#
# == References
# Christian Lindig, Strictly Pretty, March 2000,
# https://lindig.github.io/papers/strictly-pretty-2000.pdf
#
# Philip Wadler, A prettier printer, March 1998,
# https://homepages.inf.ed.ac.uk/wadler/topics/language-design.html#prettier
#
# == Author
# Tanaka Akira <akr@fsij.org>
class PrettyPrint
  # Creates a buffer for pretty printing.
  #
  # +output+ is an output target. If it is not specified, '' is assumed. It
  # should have a << method which accepts the first argument +obj+ of
  # PrettyPrint#text, the first argument +sep+ of PrettyPrint#breakable, the
  # first argument +newline+ of PrettyPrint.new, and the result of a given
  # block for PrettyPrint.new.
  #
  # +maxwidth+ specifies maximum line length. If it is not specified, 79 is
  # assumed. However actual outputs may overflow +maxwidth+ if long
  # non-breakable texts are provided.
  #
  # +newline+ is used for line breaks. "\n" is used if it is not specified.
  #
  # The block is used to generate spaces. {|width| ' ' * width} is used if it
  # is not given.
  #
  # @return [PrettyPrint] a new instance of PrettyPrint
  #
  # source://prettyprint//lib/prettyprint.rb#84
  def initialize(output = T.unsafe(nil), maxwidth = T.unsafe(nil), newline = T.unsafe(nil), &genspace); end

  # Breaks the buffer into lines that are shorter than #maxwidth
  #
  # source://prettyprint//lib/prettyprint.rb#162
  def break_outmost_groups; end

  # This says "you can break a line here if necessary", and a +width+\-column
  # text +sep+ is inserted if a line is not broken at the point.
  #
  # If +sep+ is not specified, " " is used.
  #
  # If +width+ is not specified, +sep.length+ is used. You will have to
  # specify this when +sep+ is a multibyte character, for example.
  #
  # source://prettyprint//lib/prettyprint.rb#226
  def breakable(sep = T.unsafe(nil), width = T.unsafe(nil)); end

  # Returns the group most recently added to the stack.
  #
  # Contrived example:
  #   out = ""
  #   => ""
  #   q = PrettyPrint.new(out)
  #   => #<PrettyPrint:0x82f85c0 @output="", @maxwidth=79, @newline="\n", @genspace=#<Proc:0x82f8368@/home/vbatts/.rvm/rubies/ruby-head/lib/ruby/2.0.0/prettyprint.rb:82 (lambda)>, @output_width=0, @buffer_width=0, @buffer=[], @group_stack=[#<PrettyPrint::Group:0x82f8138 @depth=0, @breakables=[], @break=false>], @group_queue=#<PrettyPrint::GroupQueue:0x82fb7c0 @queue=[[#<PrettyPrint::Group:0x82f8138 @depth=0, @breakables=[], @break=false>]]>, @indent=0>
  #   q.group {
  #     q.text q.current_group.inspect
  #     q.text q.newline
  #     q.group(q.current_group.depth + 1) {
  #       q.text q.current_group.inspect
  #       q.text q.newline
  #       q.group(q.current_group.depth + 1) {
  #         q.text q.current_group.inspect
  #         q.text q.newline
  #         q.group(q.current_group.depth + 1) {
  #           q.text q.current_group.inspect
  #           q.text q.newline
  #         }
  #       }
  #     }
  #   }
  #   => 284
  #    puts out
  #   #<PrettyPrint::Group:0x8354758 @depth=1, @breakables=[], @break=false>
  #   #<PrettyPrint::Group:0x8354550 @depth=2, @breakables=[], @break=false>
  #   #<PrettyPrint::Group:0x83541cc @depth=3, @breakables=[], @break=false>
  #   #<PrettyPrint::Group:0x8347e54 @depth=4, @breakables=[], @break=false>
  #
  # source://prettyprint//lib/prettyprint.rb#157
  def current_group; end

  # This is similar to #breakable except
  # the decision to break or not is determined individually.
  #
  # Two #fill_breakable under a group may cause 4 results:
  # (break,break), (break,non-break), (non-break,break), (non-break,non-break).
  # This is different to #breakable because two #breakable under a group
  # may cause 2 results:
  # (break,break), (non-break,non-break).
  #
  # The text +sep+ is inserted if a line is not broken at this point.
  #
  # If +sep+ is not specified, " " is used.
  #
  # If +width+ is not specified, +sep.length+ is used. You will have to
  # specify this when +sep+ is a multibyte character, for example.
  #
  # source://prettyprint//lib/prettyprint.rb#214
  def fill_breakable(sep = T.unsafe(nil), width = T.unsafe(nil)); end

  # outputs buffered data.
  #
  # source://prettyprint//lib/prettyprint.rb#290
  def flush; end

  # A lambda or Proc, that takes one argument, of an Integer, and returns
  # the corresponding number of spaces.
  #
  # By default this is:
  #   lambda {|n| ' ' * n}
  #
  # source://prettyprint//lib/prettyprint.rb#120
  def genspace; end

  # Groups line break hints added in the block. The line break hints are all
  # to be used or not.
  #
  # If +indent+ is specified, the method call is regarded as nested by
  # nest(indent) { ... }.
  #
  # If +open_obj+ is specified, <tt>text open_obj, open_width</tt> is called
  # before grouping. If +close_obj+ is specified, <tt>text close_obj,
  # close_width</tt> is called after grouping.
  #
  # source://prettyprint//lib/prettyprint.rb#251
  def group(indent = T.unsafe(nil), open_obj = T.unsafe(nil), close_obj = T.unsafe(nil), open_width = T.unsafe(nil), close_width = T.unsafe(nil)); end

  # The PrettyPrint::GroupQueue of groups in stack to be pretty printed
  #
  # source://prettyprint//lib/prettyprint.rb#126
  def group_queue; end

  # Takes a block and queues a new group that is indented 1 level further.
  #
  # source://prettyprint//lib/prettyprint.rb#262
  def group_sub; end

  # The number of spaces to be indented
  #
  # source://prettyprint//lib/prettyprint.rb#123
  def indent; end

  # The maximum width of a line, before it is separated in to a newline
  #
  # This defaults to 79, and should be an Integer
  #
  # source://prettyprint//lib/prettyprint.rb#108
  def maxwidth; end

  # Increases left margin after newline with +indent+ for line breaks added in
  # the block.
  #
  # source://prettyprint//lib/prettyprint.rb#279
  def nest(indent); end

  # The value that is appended to +output+ to add a new line.
  #
  # This defaults to "\n", and should be String
  #
  # source://prettyprint//lib/prettyprint.rb#113
  def newline; end

  # The output object.
  #
  # This defaults to '', and should accept the << method
  #
  # source://prettyprint//lib/prettyprint.rb#103
  def output; end

  # This adds +obj+ as a text of +width+ columns in width.
  #
  # If +width+ is not specified, obj.length is used.
  #
  # source://prettyprint//lib/prettyprint.rb#182
  def text(obj, width = T.unsafe(nil)); end

  class << self
    # This is a convenience method which is same as follows:
    #
    #   begin
    #     q = PrettyPrint.new(output, maxwidth, newline, &genspace)
    #     ...
    #     q.flush
    #     output
    #   end
    #
    # @yield [q]
    #
    # source://prettyprint//lib/prettyprint.rb#47
    def format(output = T.unsafe(nil), maxwidth = T.unsafe(nil), newline = T.unsafe(nil), genspace = T.unsafe(nil)); end

    # This is similar to PrettyPrint::format but the result has no breaks.
    #
    # +maxwidth+, +newline+ and +genspace+ are ignored.
    #
    # The invocation of +breakable+ in the block doesn't break a line and is
    # treated as just an invocation of +text+.
    #
    # @yield [q]
    #
    # source://prettyprint//lib/prettyprint.rb#61
    def singleline_format(output = T.unsafe(nil), maxwidth = T.unsafe(nil), newline = T.unsafe(nil), genspace = T.unsafe(nil)); end
  end
end

# The Breakable class is used for breaking up object information
#
# This class is intended for internal use of the PrettyPrint buffers.
class PrettyPrint::Breakable
  # Create a new Breakable object.
  #
  # Arguments:
  # * +sep+ String of the separator
  # * +width+ Integer width of the +sep+
  # * +q+ parent PrettyPrint object, to base from
  #
  # @return [Breakable] a new instance of Breakable
  #
  # source://prettyprint//lib/prettyprint.rb#347
  def initialize(sep, width, q); end

  # The number of spaces to indent.
  #
  # This is inferred from +q+ within PrettyPrint, passed in ::new
  #
  # source://prettyprint//lib/prettyprint.rb#367
  def indent; end

  # Holds the separator String
  #
  # The +sep+ argument from ::new
  #
  # source://prettyprint//lib/prettyprint.rb#359
  def obj; end

  # Render the String text of the objects that have been added to this
  # Breakable object.
  #
  # Output the text to +out+, and increment the width to +output_width+
  #
  # source://prettyprint//lib/prettyprint.rb#373
  def output(out, output_width); end

  # The width of +obj+ / +sep+
  #
  # source://prettyprint//lib/prettyprint.rb#362
  def width; end
end

# The Group class is used for making indentation easier.
#
# While this class does neither the breaking into newlines nor indentation,
# it is used in a stack (as well as a queue) within PrettyPrint, to group
# objects.
#
# For information on using groups, see PrettyPrint#group
#
# This class is intended for internal use of the PrettyPrint buffers.
class PrettyPrint::Group
  # Create a Group object
  #
  # Arguments:
  # * +depth+ - this group's relation to previous groups
  #
  # @return [Group] a new instance of Group
  #
  # source://prettyprint//lib/prettyprint.rb#401
  def initialize(depth); end

  # Makes a break for this Group, and returns true
  #
  # source://prettyprint//lib/prettyprint.rb#414
  def break; end

  # Boolean of whether this Group has made a break
  #
  # @return [Boolean]
  #
  # source://prettyprint//lib/prettyprint.rb#419
  def break?; end

  # Array to hold the Breakable objects for this Group
  #
  # source://prettyprint//lib/prettyprint.rb#411
  def breakables; end

  # This group's relation to previous groups
  #
  # source://prettyprint//lib/prettyprint.rb#408
  def depth; end

  # Boolean of whether this Group has been queried for being first
  #
  # This is used as a predicate, and ought to be called first.
  #
  # @return [Boolean]
  #
  # source://prettyprint//lib/prettyprint.rb#426
  def first?; end
end

# The GroupQueue class is used for managing the queue of Group to be pretty
# printed.
#
# This queue groups the Group objects, based on their depth.
#
# This class is intended for internal use of the PrettyPrint buffers.
class PrettyPrint::GroupQueue
  # Create a GroupQueue object
  #
  # Arguments:
  # * +groups+ - one or more PrettyPrint::Group objects
  #
  # @return [GroupQueue] a new instance of GroupQueue
  #
  # source://prettyprint//lib/prettyprint.rb#447
  def initialize(*groups); end

  # Remote +group+ from this queue
  #
  # source://prettyprint//lib/prettyprint.rb#479
  def delete(group); end

  # Returns the outer group of the queue
  #
  # source://prettyprint//lib/prettyprint.rb#463
  def deq; end

  # Enqueue +group+
  #
  # This does not strictly append the group to the end of the queue,
  # but instead adds it in line, base on the +group.depth+
  #
  # source://prettyprint//lib/prettyprint.rb#456
  def enq(group); end
end

# PrettyPrint::SingleLine is used by PrettyPrint.singleline_format
#
# It is passed to be similar to a PrettyPrint object itself, by responding to:
# * #text
# * #breakable
# * #nest
# * #group
# * #flush
# * #first?
#
# but instead, the output has no line breaks
class PrettyPrint::SingleLine
  # Create a PrettyPrint::SingleLine object
  #
  # Arguments:
  # * +output+ - String (or similar) to store rendered text. Needs to respond to '<<'
  # * +maxwidth+ - Argument position expected to be here for compatibility.
  #                This argument is a noop.
  # * +newline+ - Argument position expected to be here for compatibility.
  #               This argument is a noop.
  #
  # @return [SingleLine] a new instance of SingleLine
  #
  # source://prettyprint//lib/prettyprint.rb#505
  def initialize(output, maxwidth = T.unsafe(nil), newline = T.unsafe(nil)); end

  # Appends +sep+ to the text to be output. By default +sep+ is ' '
  #
  # +width+ argument is here for compatibility. It is a noop argument.
  #
  # source://prettyprint//lib/prettyprint.rb#520
  def breakable(sep = T.unsafe(nil), width = T.unsafe(nil)); end

  # This is used as a predicate, and ought to be called first.
  #
  # @return [Boolean]
  #
  # source://prettyprint//lib/prettyprint.rb#552
  def first?; end

  # Method present for compatibility, but is a noop
  #
  # source://prettyprint//lib/prettyprint.rb#548
  def flush; end

  # Opens a block for grouping objects to be pretty printed.
  #
  # Arguments:
  # * +indent+ - noop argument. Present for compatibility.
  # * +open_obj+ - text appended before the &blok. Default is ''
  # * +close_obj+ - text appended after the &blok. Default is ''
  # * +open_width+ - noop argument. Present for compatibility.
  # * +close_width+ - noop argument. Present for compatibility.
  #
  # source://prettyprint//lib/prettyprint.rb#539
  def group(indent = T.unsafe(nil), open_obj = T.unsafe(nil), close_obj = T.unsafe(nil), open_width = T.unsafe(nil), close_width = T.unsafe(nil)); end

  # Takes +indent+ arg, but does nothing with it.
  #
  # Yields to a block.
  #
  # source://prettyprint//lib/prettyprint.rb#527
  def nest(indent); end

  # Add +obj+ to the text to be output.
  #
  # +width+ argument is here for compatibility. It is a noop argument.
  #
  # source://prettyprint//lib/prettyprint.rb#513
  def text(obj, width = T.unsafe(nil)); end
end

# The Text class is the means by which to collect strings from objects.
#
# This class is intended for internal use of the PrettyPrint buffers.
class PrettyPrint::Text
  # Creates a new text object.
  #
  # This constructor takes no arguments.
  #
  # The workflow is to append a PrettyPrint::Text object to the buffer, and
  # being able to call the buffer.last() to reference it.
  #
  # As there are objects, use PrettyPrint::Text#add to include the objects
  # and the width to utilized by the String version of this object.
  #
  # @return [Text] a new instance of Text
  #
  # source://prettyprint//lib/prettyprint.rb#312
  def initialize; end

  # Include +obj+ in the objects to be pretty printed, and increment
  # this Text object's total width by +width+
  #
  # source://prettyprint//lib/prettyprint.rb#330
  def add(obj, width); end

  # Render the String text of the objects that have been added to this Text object.
  #
  # Output the text to +out+, and increment the width to +output_width+
  #
  # source://prettyprint//lib/prettyprint.rb#323
  def output(out, output_width); end

  # The total width of the objects included in this Text object.
  #
  # source://prettyprint//lib/prettyprint.rb#318
  def width; end
end

# source://prettyprint//lib/prettyprint.rb#36
PrettyPrint::VERSION = T.let(T.unsafe(nil), String)
