# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `prism` gem.
# Please instead update this file by running `bin/tapioca gem prism`.


# typed: strict

# =begin
# This file is generated by the templates/template.rb script and should not be
# modified manually. See templates/rbi/prism/dsl.rbi.erb
# if you are looking to modify the template
# =end
# =begin
# This file is generated by the templates/template.rb script and should not be
# modified manually. See templates/rbi/prism/node.rbi.erb
# if you are looking to modify the template
# =end
# =begin
# This file is generated by the templates/template.rb script and should not be
# modified manually. See templates/rbi/prism/visitor.rbi.erb
# if you are looking to modify the template
# =end

# We keep these shims in here because our client libraries might not have parser
# in their bundle.
module Parser; end

class Parser::Base; end

# The Prism Ruby parser.
#
# "Parsing Ruby is suddenly manageable!"
#   - You, hopefully
#
# source://prism//lib/prism.rb#9
module Prism
  class << self
    # Mirror the Prism.dump API by using the serialization API.
    #
    # source://prism//lib/prism.rb#92
    def dump(*_arg0); end

    # Mirror the Prism.dump_file API by using the serialization API.
    #
    # source://prism//lib/prism.rb#92
    def dump_file(*_arg0); end

    # Mirror the Prism.lex API by using the serialization API.
    #
    # source://prism//lib/prism.rb#92
    def lex(*_arg0); end

    # :call-seq:
    #   Prism::lex_compat(source, **options) -> LexCompat::Result
    #
    # Returns a parse result whose value is an array of tokens that closely
    # resembles the return value of Ripper::lex.
    #
    # For supported options, see Prism::parse.
    #
    # source://prism//lib/prism.rb#65
    sig { params(source: String, options: T::Hash[Symbol, T.untyped]).returns(Prism::LexCompat::Result) }
    def lex_compat(source, **options); end

    # Mirror the Prism.lex_file API by using the serialization API.
    #
    # source://prism//lib/prism.rb#92
    def lex_file(*_arg0); end

    # :call-seq:
    #   Prism::load(source, serialized, freeze) -> ParseResult
    #
    # Load the serialized AST using the source as a reference into a tree.
    #
    # source://prism//lib/prism.rb#73
    sig { params(source: String, serialized: String, freeze: T.nilable(T::Boolean)).returns(Prism::ParseResult) }
    def load(source, serialized, freeze = T.unsafe(nil)); end

    # Mirror the Prism.parse API by using the serialization API.
    #
    # source://prism//lib/prism.rb#92
    def parse(*_arg0); end

    # Mirror the Prism.parse_comments API by using the serialization API.
    #
    # source://prism//lib/prism.rb#92
    def parse_comments(*_arg0); end

    # Mirror the Prism.parse_failure? API by using the serialization API.
    #
    # @return [Boolean]
    #
    # source://prism//lib/prism.rb#92
    def parse_failure?(*_arg0); end

    # Mirror the Prism.parse_file API by using the serialization API. This uses
    # native strings instead of Ruby strings because it allows us to use mmap
    # when it is available.
    #
    # source://prism//lib/prism.rb#92
    def parse_file(*_arg0); end

    # Mirror the Prism.parse_file_comments API by using the serialization
    # API. This uses native strings instead of Ruby strings because it allows us
    # to use mmap when it is available.
    #
    # source://prism//lib/prism.rb#92
    def parse_file_comments(*_arg0); end

    # Mirror the Prism.parse_file_failure? API by using the serialization API.
    #
    # @return [Boolean]
    #
    # source://prism//lib/prism.rb#92
    def parse_file_failure?(*_arg0); end

    # Mirror the Prism.parse_file_success? API by using the serialization API.
    #
    # @return [Boolean]
    #
    # source://prism//lib/prism.rb#92
    def parse_file_success?(*_arg0); end

    # Mirror the Prism.parse_lex API by using the serialization API.
    #
    # source://prism//lib/prism.rb#92
    def parse_lex(*_arg0); end

    # Mirror the Prism.parse_lex_file API by using the serialization API.
    #
    # source://prism//lib/prism.rb#92
    def parse_lex_file(*_arg0); end

    # Mirror the Prism.parse_stream API by using the serialization API.
    #
    # source://prism//lib/prism.rb#92
    def parse_stream(*_arg0); end

    # Mirror the Prism.parse_success? API by using the serialization API.
    #
    # @return [Boolean]
    #
    # source://prism//lib/prism.rb#92
    def parse_success?(*_arg0); end

    # Mirror the Prism.profile API by using the serialization API.
    #
    # source://prism//lib/prism.rb#92
    def profile(*_arg0); end

    # Mirror the Prism.profile_file API by using the serialization API.
    #
    # source://prism//lib/prism.rb#92
    def profile_file(*_arg0); end

    # Create a new scope with the given locals and forwarding options that is
    # suitable for passing into one of the Prism.* methods that accepts the
    # `scopes` option.
    #
    # source://prism//lib/prism/parse_result.rb#904
    sig { params(locals: T::Array[Symbol], forwarding: T::Array[Symbol]).returns(Prism::Scope) }
    def scope(locals: T.unsafe(nil), forwarding: T.unsafe(nil)); end
  end
end

# Specialized version of Prism::Source for source code that includes ASCII
# characters only. This class is used to apply performance optimizations that
# cannot be applied to sources that include multibyte characters.
#
# In the extremely rare case that a source includes multi-byte characters but
# is marked as binary because of a magic encoding comment and it cannot be
# eagerly converted to UTF-8, this class will be used as well. This is because
# at that point we will treat everything as single-byte characters.
#
# source://prism//lib/prism/parse_result.rb#250
class Prism::ASCIISource < ::Prism::Source
  # Return the column number in characters for the given byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#257
  sig { params(byte_offset: Integer).returns(Integer) }
  def character_column(byte_offset); end

  # Return the character offset for the given byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#252
  sig { params(byte_offset: Integer).returns(Integer) }
  def character_offset(byte_offset); end

  # Returns a cache that is the identity function in order to maintain the
  # same interface. We can do this because code units are always equivalent to
  # byte offsets for ASCII-only sources.
  #
  # source://prism//lib/prism/parse_result.rb#274
  sig do
    params(
      encoding: Encoding
    ).returns(T.any(Prism::CodeUnitsCache, T.proc.params(byte_offset: Integer).returns(Integer)))
  end
  def code_units_cache(encoding); end

  # Specialized version of `code_units_column` that does not depend on
  # `code_units_offset`, which is a more expensive operation. This is
  # essentially the same as `Prism::Source#column`.
  #
  # source://prism//lib/prism/parse_result.rb#281
  sig { params(byte_offset: Integer, encoding: Encoding).returns(Integer) }
  def code_units_column(byte_offset, encoding); end

  # Returns the offset from the start of the file for the given byte offset
  # counting in code units for the given encoding.
  #
  # This method is tested with UTF-8, UTF-16, and UTF-32. If there is the
  # concept of code units that differs from the number of characters in other
  # encodings, it is not captured here.
  #
  # source://prism//lib/prism/parse_result.rb#267
  sig { params(byte_offset: Integer, encoding: Encoding).returns(Integer) }
  def code_units_offset(byte_offset, encoding); end
end

# Represents the use of the `alias` keyword to alias a global variable.
#
#     alias $foo $bar
#     ^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#334
class Prism::AliasGlobalVariableNode < ::Prism::Node
  # Initialize a new AliasGlobalVariableNode node.
  #
  # @return [AliasGlobalVariableNode] a new instance of AliasGlobalVariableNode
  #
  # source://prism//lib/prism/node.rb#336
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      new_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode),
      old_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::SymbolNode, Prism::MissingNode),
      keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, new_name, old_name, keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#437
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#347
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#352
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#370
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#365
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?new_name: GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode, ?old_name: GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode | SymbolNode | MissingNode, ?keyword_loc: Location) -> AliasGlobalVariableNode
  #
  # source://prism//lib/prism/node.rb#375
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      new_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode),
      old_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::SymbolNode, Prism::MissingNode),
      keyword_loc: Prism::Location
    ).returns(Prism::AliasGlobalVariableNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), new_name: T.unsafe(nil), old_name: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#380
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, new_name: GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode, old_name: GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode | SymbolNode | MissingNode, keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#383
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [new_name]
  #
  # source://prism//lib/prism/node.rb#357
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#421
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#416
  sig { returns(String) }
  def keyword; end

  # The location of the `alias` keyword.
  #
  #     alias $foo $bar
  #     ^^^^^
  #
  # source://prism//lib/prism/node.rb#403
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # Represents the new name of the global variable that can be used after aliasing.
  #
  #     alias $foo $bar
  #           ^^^^
  #
  # source://prism//lib/prism/node.rb#391
  sig { returns(T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)) }
  def new_name; end

  # Represents the old name of the global variable that can be used before aliasing.
  #
  #     alias $foo $bar
  #                ^^^^
  #
  # source://prism//lib/prism/node.rb#397
  sig do
    returns(T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::SymbolNode, Prism::MissingNode))
  end
  def old_name; end

  # Save the keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#411
  def save_keyword_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#426
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#431
    def type; end
  end
end

# Represents the use of the `alias` keyword to alias a method.
#
#     alias foo bar
#     ^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#449
class Prism::AliasMethodNode < ::Prism::Node
  # Initialize a new AliasMethodNode node.
  #
  # @return [AliasMethodNode] a new instance of AliasMethodNode
  #
  # source://prism//lib/prism/node.rb#451
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      new_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode),
      old_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode, Prism::GlobalVariableReadNode, Prism::MissingNode),
      keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, new_name, old_name, keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#564
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#462
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#467
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#485
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#480
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?new_name: SymbolNode | InterpolatedSymbolNode, ?old_name: SymbolNode | InterpolatedSymbolNode | GlobalVariableReadNode | MissingNode, ?keyword_loc: Location) -> AliasMethodNode
  #
  # source://prism//lib/prism/node.rb#490
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      new_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode),
      old_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode, Prism::GlobalVariableReadNode, Prism::MissingNode),
      keyword_loc: Prism::Location
    ).returns(Prism::AliasMethodNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), new_name: T.unsafe(nil), old_name: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#495
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, new_name: SymbolNode | InterpolatedSymbolNode, old_name: SymbolNode | InterpolatedSymbolNode | GlobalVariableReadNode | MissingNode, keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#498
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [new_name]
  #
  # source://prism//lib/prism/node.rb#472
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#548
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#543
  sig { returns(String) }
  def keyword; end

  # Represents the location of the `alias` keyword.
  #
  #     alias foo bar
  #     ^^^^^
  #
  # source://prism//lib/prism/node.rb#530
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # Represents the new name of the method that will be aliased.
  #
  #     alias foo bar
  #           ^^^
  #
  #     alias :foo :bar
  #           ^^^^
  #
  #     alias :"#{foo}" :"#{bar}"
  #           ^^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#512
  sig { returns(T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode)) }
  def new_name; end

  # Represents the old name of the method that will be aliased.
  #
  #     alias foo bar
  #               ^^^
  #
  #     alias :foo :bar
  #                ^^^^
  #
  #     alias :"#{foo}" :"#{bar}"
  #                     ^^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#524
  sig do
    returns(T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode, Prism::GlobalVariableReadNode, Prism::MissingNode))
  end
  def old_name; end

  # Save the keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#538
  def save_keyword_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#553
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#558
    def type; end
  end
end

# Represents an alternation pattern in pattern matching.
#
#     foo => bar | baz
#            ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#576
class Prism::AlternationPatternNode < ::Prism::Node
  # Initialize a new AlternationPatternNode node.
  #
  # @return [AlternationPatternNode] a new instance of AlternationPatternNode
  #
  # source://prism//lib/prism/node.rb#578
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, left, right, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#679
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#589
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#594
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#612
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#607
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?left: Prism::node, ?right: Prism::node, ?operator_loc: Location) -> AlternationPatternNode
  #
  # source://prism//lib/prism/node.rb#617
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::AlternationPatternNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#622
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, left: Prism::node, right: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#625
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [left]
  #
  # source://prism//lib/prism/node.rb#599
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#663
  sig { override.returns(String) }
  def inspect; end

  # Represents the left side of the expression.
  #
  #     foo => bar | baz
  #            ^^^
  #
  # source://prism//lib/prism/node.rb#633
  sig { returns(Prism::Node) }
  def left; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#658
  sig { returns(String) }
  def operator; end

  # Represents the alternation operator location.
  #
  #     foo => bar | baz
  #                ^
  #
  # source://prism//lib/prism/node.rb#645
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Represents the right side of the expression.
  #
  #     foo => bar | baz
  #                  ^^^
  #
  # source://prism//lib/prism/node.rb#639
  sig { returns(Prism::Node) }
  def right; end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#653
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#668
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#673
    def type; end
  end
end

# Represents the use of the `&&` operator or the `and` keyword.
#
#     left and right
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#691
class Prism::AndNode < ::Prism::Node
  # Initialize a new AndNode node.
  #
  # @return [AndNode] a new instance of AndNode
  #
  # source://prism//lib/prism/node.rb#693
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, left, right, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#800
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#704
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#709
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#727
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#722
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?left: Prism::node, ?right: Prism::node, ?operator_loc: Location) -> AndNode
  #
  # source://prism//lib/prism/node.rb#732
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::AndNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#737
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, left: Prism::node, right: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#740
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [left]
  #
  # source://prism//lib/prism/node.rb#714
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#784
  sig { override.returns(String) }
  def inspect; end

  # Represents the left side of the expression. It can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     left and right
  #     ^^^^
  #
  #     1 && 2
  #     ^
  #
  # source://prism//lib/prism/node.rb#751
  sig { returns(Prism::Node) }
  def left; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#779
  sig { returns(String) }
  def operator; end

  # The location of the `and` keyword or the `&&` operator.
  #
  #     left and right
  #          ^^^
  #
  # source://prism//lib/prism/node.rb#766
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Represents the right side of the expression.
  #
  #     left && right
  #             ^^^^^
  #
  #     1 and 2
  #           ^
  #
  # source://prism//lib/prism/node.rb#760
  sig { returns(Prism::Node) }
  def right; end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#774
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#789
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#794
    def type; end
  end
end

# Represents a set of arguments to a method or a keyword.
#
#     return foo, bar, baz
#            ^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#812
class Prism::ArgumentsNode < ::Prism::Node
  # Initialize a new ArgumentsNode node.
  #
  # @return [ArgumentsNode] a new instance of ArgumentsNode
  #
  # source://prism//lib/prism/node.rb#814
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T::Array[Prism::Node]
    ).void
  end
  def initialize(source, node_id, location, flags, arguments); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#910
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#823
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # The list of arguments, if present. These can be any [non-void expressions](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     foo(bar, baz)
  #         ^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#891
  sig { returns(T::Array[Prism::Node]) }
  def arguments; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#828
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#845
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#840
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def contains_forwarding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#863
  sig { returns(T::Boolean) }
  def contains_forwarding?; end

  # def contains_keyword_splat?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#873
  sig { returns(T::Boolean) }
  def contains_keyword_splat?; end

  # def contains_keywords?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#868
  sig { returns(T::Boolean) }
  def contains_keywords?; end

  # def contains_multiple_splats?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#883
  sig { returns(T::Boolean) }
  def contains_multiple_splats?; end

  # def contains_splat?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#878
  sig { returns(T::Boolean) }
  def contains_splat?; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?arguments: Array[Prism::node]) -> ArgumentsNode
  #
  # source://prism//lib/prism/node.rb#850
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T::Array[Prism::Node]
    ).returns(Prism::ArgumentsNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), arguments: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#855
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, arguments: Array[Prism::node] }
  #
  # source://prism//lib/prism/node.rb#858
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#833
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#894
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#899
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#904
    def type; end
  end
end

# Flags for arguments nodes.
#
# source://prism//lib/prism/node.rb#19780
module Prism::ArgumentsNodeFlags; end

# if the arguments contain forwarding
#
# source://prism//lib/prism/node.rb#19782
Prism::ArgumentsNodeFlags::CONTAINS_FORWARDING = T.let(T.unsafe(nil), Integer)

# if the arguments contain keywords
#
# source://prism//lib/prism/node.rb#19785
Prism::ArgumentsNodeFlags::CONTAINS_KEYWORDS = T.let(T.unsafe(nil), Integer)

# if the arguments contain a keyword splat
#
# source://prism//lib/prism/node.rb#19788
Prism::ArgumentsNodeFlags::CONTAINS_KEYWORD_SPLAT = T.let(T.unsafe(nil), Integer)

# if the arguments contain multiple splats
#
# source://prism//lib/prism/node.rb#19794
Prism::ArgumentsNodeFlags::CONTAINS_MULTIPLE_SPLATS = T.let(T.unsafe(nil), Integer)

# if the arguments contain a splat
#
# source://prism//lib/prism/node.rb#19791
Prism::ArgumentsNodeFlags::CONTAINS_SPLAT = T.let(T.unsafe(nil), Integer)

# Represents an array literal. This can be a regular array using brackets or a special array using % like %w or %i.
#
#     [1, 2, 3]
#     ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#922
class Prism::ArrayNode < ::Prism::Node
  # Initialize a new ArrayNode node.
  #
  # @return [ArrayNode] a new instance of ArrayNode
  #
  # source://prism//lib/prism/node.rb#924
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      elements: T::Array[Prism::Node],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, elements, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1057
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#935
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#940
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#1036
  sig { returns(T.nilable(String)) }
  def closing; end

  # Represents the optional source location for the closing token.
  #
  #     [1,2,3]                 # "]"
  #     %w[foo bar baz]         # "]"
  #     %I(apple orange banana) # ")"
  #     foo = 1, 2, 3           # nil
  #
  # source://prism//lib/prism/node.rb#1012
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#957
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#952
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def contains_splat?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#975
  sig { returns(T::Boolean) }
  def contains_splat?; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?elements: Array[Prism::node], ?opening_loc: Location?, ?closing_loc: Location?) -> ArrayNode
  #
  # source://prism//lib/prism/node.rb#962
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      elements: T::Array[Prism::Node],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::ArrayNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), elements: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#967
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, elements: Array[Prism::node], opening_loc: Location?, closing_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#970
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#945
  def each_child_node; end

  # Represent the list of zero or more [non-void expressions](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression) within the array.
  #
  # source://prism//lib/prism/node.rb#980
  sig { returns(T::Array[Prism::Node]) }
  def elements; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#1041
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#1031
  sig { returns(T.nilable(String)) }
  def opening; end

  # Represents the optional source location for the opening token.
  #
  #     [1,2,3]                 # "["
  #     %w[foo bar baz]         # "%w["
  #     %I(apple orange banana) # "%I("
  #     foo = 1, 2, 3           # nil
  #
  # source://prism//lib/prism/node.rb#988
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#1026
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#1002
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#1046
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1051
    def type; end
  end
end

# Flags for array nodes.
#
# source://prism//lib/prism/node.rb#19798
module Prism::ArrayNodeFlags; end

# if array contains splat nodes
#
# source://prism//lib/prism/node.rb#19800
Prism::ArrayNodeFlags::CONTAINS_SPLAT = T.let(T.unsafe(nil), Integer)

# Represents an array pattern in pattern matching.
#
#     foo in 1, 2
#     ^^^^^^^^^^^
#
#     foo in [1, 2]
#     ^^^^^^^^^^^^^
#
#     foo in *bar
#     ^^^^^^^^^^^
#
#     foo in Bar[]
#     ^^^^^^^^^^^^
#
#     foo in Bar[1, 2, 3]
#     ^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#1083
class Prism::ArrayPatternNode < ::Prism::Node
  # Initialize a new ArrayPatternNode node.
  #
  # @return [ArrayPatternNode] a new instance of ArrayPatternNode
  #
  # source://prism//lib/prism/node.rb#1085
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantPathNode, Prism::ConstantReadNode)),
      requireds: T::Array[Prism::Node],
      rest: T.nilable(Prism::Node),
      posts: T::Array[Prism::Node],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, constant, requireds, rest, posts, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1247
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1099
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#1104
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#1226
  sig { returns(T.nilable(String)) }
  def closing; end

  # Represents the closing location of the array pattern.
  #
  #     foo in [1, 2]
  #                 ^
  #
  # source://prism//lib/prism/node.rb#1202
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1129
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1119
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # Represents the optional constant preceding the Array
  #
  #     foo in Bar[]
  #            ^^^
  #
  #     foo in Bar[1, 2, 3]
  #            ^^^
  #
  #     foo in Bar::Baz[1, 2, 3]
  #            ^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#1156
  sig { returns(T.nilable(T.any(Prism::ConstantPathNode, Prism::ConstantReadNode))) }
  def constant; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?constant: ConstantPathNode | ConstantReadNode | nil, ?requireds: Array[Prism::node], ?rest: Prism::node?, ?posts: Array[Prism::node], ?opening_loc: Location?, ?closing_loc: Location?) -> ArrayPatternNode
  #
  # source://prism//lib/prism/node.rb#1134
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantPathNode, Prism::ConstantReadNode)),
      requireds: T::Array[Prism::Node],
      rest: T.nilable(Prism::Node),
      posts: T::Array[Prism::Node],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::ArrayPatternNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), constant: T.unsafe(nil), requireds: T.unsafe(nil), rest: T.unsafe(nil), posts: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#1139
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, constant: ConstantPathNode | ConstantReadNode | nil, requireds: Array[Prism::node], rest: Prism::node?, posts: Array[Prism::node], opening_loc: Location?, closing_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#1142
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [constant]
  #
  # source://prism//lib/prism/node.rb#1109
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#1231
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#1221
  sig { returns(T.nilable(String)) }
  def opening; end

  # Represents the opening location of the array pattern.
  #
  #     foo in [1, 2]
  #            ^
  #
  # source://prism//lib/prism/node.rb#1180
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # Represents the elements after the rest element of the array pattern.
  #
  #     foo in *bar, baz
  #                  ^^^
  #
  # source://prism//lib/prism/node.rb#1174
  sig { returns(T::Array[Prism::Node]) }
  def posts; end

  # Represents the required elements of the array pattern.
  #
  #     foo in [1, 2]
  #             ^  ^
  #
  # source://prism//lib/prism/node.rb#1162
  sig { returns(T::Array[Prism::Node]) }
  def requireds; end

  # Represents the rest element of the array pattern.
  #
  #     foo in *bar
  #            ^^^^
  #
  # source://prism//lib/prism/node.rb#1168
  sig { returns(T.nilable(Prism::Node)) }
  def rest; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#1216
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#1194
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#1236
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1241
    def type; end
  end
end

# Represents a hash key/value pair.
#
#     { a => b }
#       ^^^^^^
#
# source://prism//lib/prism/node.rb#1264
class Prism::AssocNode < ::Prism::Node
  # Initialize a new AssocNode node.
  #
  # @return [AssocNode] a new instance of AssocNode
  #
  # source://prism//lib/prism/node.rb#1266
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      key: Prism::Node,
      value: Prism::Node,
      operator_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, key, value, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1382
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1277
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#1282
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1300
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1295
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?key: Prism::node, ?value: Prism::node, ?operator_loc: Location?) -> AssocNode
  #
  # source://prism//lib/prism/node.rb#1305
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      key: Prism::Node,
      value: Prism::Node,
      operator_loc: T.nilable(Prism::Location)
    ).returns(Prism::AssocNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), key: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#1310
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, key: Prism::node, value: Prism::node, operator_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#1313
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [key]
  #
  # source://prism//lib/prism/node.rb#1287
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#1366
  sig { override.returns(String) }
  def inspect; end

  # The key of the association. This can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     { a: b }
  #       ^
  #
  #     { foo => bar }
  #       ^^^
  #
  #     { def a; end => 1 }
  #       ^^^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#1327
  sig { returns(Prism::Node) }
  def key; end

  # def operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#1361
  sig { returns(T.nilable(String)) }
  def operator; end

  # The location of the `=>` operator, if present.
  #
  #     { foo => bar }
  #           ^^
  #
  # source://prism//lib/prism/node.rb#1342
  sig { returns(T.nilable(Prism::Location)) }
  def operator_loc; end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#1356
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#1371
  sig { override.returns(Symbol) }
  def type; end

  # The value of the association, if present. This can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     { foo => bar }
  #              ^^^
  #
  #     { x: 1 }
  #          ^
  #
  # source://prism//lib/prism/node.rb#1336
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1376
    def type; end
  end
end

# Represents a splat in a hash literal.
#
#     { **foo }
#       ^^^^^
#
# source://prism//lib/prism/node.rb#1394
class Prism::AssocSplatNode < ::Prism::Node
  # Initialize a new AssocSplatNode node.
  #
  # @return [AssocSplatNode] a new instance of AssocSplatNode
  #
  # source://prism//lib/prism/node.rb#1396
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, value, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1491
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1406
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#1411
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1430
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1423
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?value: Prism::node?, ?operator_loc: Location) -> AssocSplatNode
  #
  # source://prism//lib/prism/node.rb#1435
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).returns(Prism::AssocSplatNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#1440
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, value: Prism::node?, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#1443
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#1416
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#1475
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#1470
  sig { returns(String) }
  def operator; end

  # The location of the `**` operator.
  #
  #     { **x }
  #       ^^
  #
  # source://prism//lib/prism/node.rb#1457
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#1465
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#1480
  sig { override.returns(Symbol) }
  def type; end

  # The value to be splatted, if present. Will be missing when keyword rest argument forwarding is used.
  #
  #     { **foo }
  #         ^^^
  #
  # source://prism//lib/prism/node.rb#1451
  sig { returns(T.nilable(Prism::Node)) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1485
    def type; end
  end
end

# The FFI backend is used on other Ruby implementations.
#
# source://prism//lib/prism.rb#90
Prism::BACKEND = T.let(T.unsafe(nil), Symbol)

# Represents reading a reference to a field in the previous match.
#
#     $'
#     ^^
#
# source://prism//lib/prism/node.rb#1502
class Prism::BackReferenceReadNode < ::Prism::Node
  # Initialize a new BackReferenceReadNode node.
  #
  # @return [BackReferenceReadNode] a new instance of BackReferenceReadNode
  #
  # source://prism//lib/prism/node.rb#1504
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1575
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1513
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#1518
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1534
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1529
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> BackReferenceReadNode
  #
  # source://prism//lib/prism/node.rb#1539
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::BackReferenceReadNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#1544
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#1547
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#1523
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#1559
  sig { override.returns(String) }
  def inspect; end

  # The name of the back-reference variable, including the leading `$`.
  #
  #     $& # name `:$&`
  #
  #     $+ # name `:$+`
  #
  # source://prism//lib/prism/node.rb#1556
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#1564
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1569
    def type; end
  end
end

# A class that knows how to walk down the tree. None of the individual visit
# methods are implemented on this visitor, so it forces the consumer to
# implement each one that they need. For a default implementation that
# continues walking the tree, see the Visitor class.
#
# source://prism//lib/prism/visitor.rb#17
class Prism::BasicVisitor
  # Calls `accept` on the given node if it is not `nil`, which in turn should
  # call back into this visitor by calling the appropriate `visit_*` method.
  #
  # source://prism//lib/prism/visitor.rb#20
  sig { params(node: T.nilable(Prism::Node)).void }
  def visit(node); end

  # Visits each node in `nodes` by calling `accept` on each one.
  #
  # source://prism//lib/prism/visitor.rb#26
  sig { params(nodes: T::Array[T.nilable(Prism::Node)]).void }
  def visit_all(nodes); end

  # Visits the child nodes of `node` by calling `accept` on each one.
  #
  # source://prism//lib/prism/visitor.rb#32
  sig { params(node: Prism::Node).void }
  def visit_child_nodes(node); end
end

# Represents a begin statement.
#
#     begin
#       foo
#     end
#     ^^^^^
#
# source://prism//lib/prism/node.rb#1587
class Prism::BeginNode < ::Prism::Node
  # Initialize a new BeginNode node.
  #
  # @return [BeginNode] a new instance of BeginNode
  #
  # source://prism//lib/prism/node.rb#1589
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      begin_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      rescue_clause: T.nilable(Prism::RescueNode),
      else_clause: T.nilable(Prism::ElseNode),
      ensure_clause: T.nilable(Prism::EnsureNode),
      end_keyword_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, begin_keyword_loc, statements, rescue_clause, else_clause, ensure_clause, end_keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1745
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1603
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def begin_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#1719
  sig { returns(T.nilable(String)) }
  def begin_keyword; end

  # Represents the location of the `begin` keyword.
  #
  #     begin x end
  #     ^^^^^
  #
  # source://prism//lib/prism/node.rb#1654
  sig { returns(T.nilable(Prism::Location)) }
  def begin_keyword_loc; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#1608
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1633
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1623
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?begin_keyword_loc: Location?, ?statements: StatementsNode?, ?rescue_clause: RescueNode?, ?else_clause: ElseNode?, ?ensure_clause: EnsureNode?, ?end_keyword_loc: Location?) -> BeginNode
  #
  # source://prism//lib/prism/node.rb#1638
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      begin_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      rescue_clause: T.nilable(Prism::RescueNode),
      else_clause: T.nilable(Prism::ElseNode),
      ensure_clause: T.nilable(Prism::EnsureNode),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::BeginNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), begin_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), rescue_clause: T.unsafe(nil), else_clause: T.unsafe(nil), ensure_clause: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#1643
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, begin_keyword_loc: Location?, statements: StatementsNode?, rescue_clause: RescueNode?, else_clause: ElseNode?, ensure_clause: EnsureNode?, end_keyword_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#1646
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [statements]
  #
  # source://prism//lib/prism/node.rb#1613
  def each_child_node; end

  # Represents the else clause within the begin block.
  #
  #     begin x; rescue y; else z; end
  #                        ^^^^^^
  #
  # source://prism//lib/prism/node.rb#1688
  sig { returns(T.nilable(Prism::ElseNode)) }
  def else_clause; end

  # def end_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#1724
  sig { returns(T.nilable(String)) }
  def end_keyword; end

  # Represents the location of the `end` keyword.
  #
  #     begin x end
  #             ^^^
  #
  # source://prism//lib/prism/node.rb#1700
  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  # Represents the ensure clause within the begin block.
  #
  #     begin x; ensure y; end
  #              ^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#1694
  sig { returns(T.nilable(Prism::EnsureNode)) }
  def ensure_clause; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#1729
  sig { override.returns(String) }
  def inspect; end

  # source://prism//lib/prism/parse_result/newlines.rb#80
  def newline_flag!(lines); end

  # Represents the rescue clause within the begin block.
  #
  #     begin x; rescue y; end
  #              ^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#1682
  sig { returns(T.nilable(Prism::RescueNode)) }
  def rescue_clause; end

  # Save the begin_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#1668
  def save_begin_keyword_loc(repository); end

  # Save the end_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#1714
  def save_end_keyword_loc(repository); end

  # Represents the statements within the begin block.
  #
  #     begin x end
  #           ^
  #
  # source://prism//lib/prism/node.rb#1676
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#1734
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1739
    def type; end
  end
end

# Represents a block argument using `&`.
#
#     bar(&args)
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#1760
class Prism::BlockArgumentNode < ::Prism::Node
  # Initialize a new BlockArgumentNode node.
  #
  # @return [BlockArgumentNode] a new instance of BlockArgumentNode
  #
  # source://prism//lib/prism/node.rb#1762
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      expression: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, expression, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1857
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1772
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#1777
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1796
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1789
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?expression: Prism::node?, ?operator_loc: Location) -> BlockArgumentNode
  #
  # source://prism//lib/prism/node.rb#1801
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      expression: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).returns(Prism::BlockArgumentNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), expression: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#1806
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, expression: Prism::node?, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#1809
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [expression]
  #
  # source://prism//lib/prism/node.rb#1782
  def each_child_node; end

  # The expression that is being passed as a block argument. This can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     foo(&args)
  #         ^^^^^
  #
  # source://prism//lib/prism/node.rb#1817
  sig { returns(T.nilable(Prism::Node)) }
  def expression; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#1841
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#1836
  sig { returns(String) }
  def operator; end

  # Represents the location of the `&` operator.
  #
  #     foo(&args)
  #         ^
  #
  # source://prism//lib/prism/node.rb#1823
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#1831
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#1846
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1851
    def type; end
  end
end

# Represents a block local variable.
#
#     a { |; b| }
#            ^
#
# source://prism//lib/prism/node.rb#1868
class Prism::BlockLocalVariableNode < ::Prism::Node
  # Initialize a new BlockLocalVariableNode node.
  #
  # @return [BlockLocalVariableNode] a new instance of BlockLocalVariableNode
  #
  # source://prism//lib/prism/node.rb#1870
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1945
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1879
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#1884
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1900
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1895
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> BlockLocalVariableNode
  #
  # source://prism//lib/prism/node.rb#1905
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::BlockLocalVariableNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#1910
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#1913
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#1889
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#1929
  sig { override.returns(String) }
  def inspect; end

  # The name of the block local variable.
  #
  #     a { |; b| } # name `:b`
  #            ^
  #
  # source://prism//lib/prism/node.rb#1926
  sig { returns(Symbol) }
  def name; end

  # def repeated_parameter?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#1918
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#1934
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1939
    def type; end
  end
end

# Represents a block of ruby code.
#
#     [1, 2, 3].each { |i| puts x }
#                    ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#1956
class Prism::BlockNode < ::Prism::Node
  # Initialize a new BlockNode node.
  #
  # @return [BlockNode] a new instance of BlockNode
  #
  # source://prism//lib/prism/node.rb#1958
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, locals, parameters, body, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#2095
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1971
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # The body of the block.
  #
  #     [1, 2, 3].each { |i| puts x }
  #                          ^^^^^^
  #
  # source://prism//lib/prism/node.rb#2034
  sig { returns(T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))) }
  def body; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#1976
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#2074
  sig { returns(String) }
  def closing; end

  # Represents the location of the closing `}` or `end`.
  #
  #     [1, 2, 3].each { |i| puts x }
  #                                 ^
  #
  # source://prism//lib/prism/node.rb#2056
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1997
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1989
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?locals: Array[Symbol], ?parameters: BlockParametersNode | NumberedParametersNode | ItParametersNode | nil, ?body: StatementsNode | BeginNode | nil, ?opening_loc: Location, ?closing_loc: Location) -> BlockNode
  #
  # source://prism//lib/prism/node.rb#2002
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).returns(Prism::BlockNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), parameters: T.unsafe(nil), body: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#2007
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, locals: Array[Symbol], parameters: BlockParametersNode | NumberedParametersNode | ItParametersNode | nil, body: StatementsNode | BeginNode | nil, opening_loc: Location, closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#2010
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [parameters]
  #
  # source://prism//lib/prism/node.rb#1981
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#2079
  sig { override.returns(String) }
  def inspect; end

  # The local variables declared in the block.
  #
  #     [1, 2, 3].each { |i| puts x } # locals: [:i]
  #                       ^
  #
  # source://prism//lib/prism/node.rb#2018
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#2069
  sig { returns(String) }
  def opening; end

  # Represents the location of the opening `{` or `do`.
  #
  #     [1, 2, 3].each { |i| puts x }
  #                    ^
  #
  # source://prism//lib/prism/node.rb#2040
  sig { returns(Prism::Location) }
  def opening_loc; end

  # The parameters of the block.
  #
  #     [1, 2, 3].each { |i| puts x }
  #                      ^^^
  #     [1, 2, 3].each { puts _1 }
  #                    ^^^^^^^^^^^
  #     [1, 2, 3].each { puts it }
  #                    ^^^^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#2028
  sig { returns(T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode))) }
  def parameters; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#2064
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#2048
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#2084
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#2089
    def type; end
  end
end

# Represents a block parameter of a method, block, or lambda definition.
#
#     def a(&b)
#           ^^
#     end
#
# source://prism//lib/prism/node.rb#2111
class Prism::BlockParameterNode < ::Prism::Node
  # Initialize a new BlockParameterNode node.
  #
  # @return [BlockParameterNode] a new instance of BlockParameterNode
  #
  # source://prism//lib/prism/node.rb#2113
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#2235
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2124
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#2129
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2145
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2140
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol?, ?name_loc: Location?, ?operator_loc: Location) -> BlockParameterNode
  #
  # source://prism//lib/prism/node.rb#2150
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location
    ).returns(Prism::BlockParameterNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#2155
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol?, name_loc: Location?, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#2158
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#2134
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#2219
  sig { override.returns(String) }
  def inspect; end

  # The name of the block parameter.
  #
  #     def a(&b) # name `:b`
  #            ^
  #     end
  #
  # source://prism//lib/prism/node.rb#2172
  sig { returns(T.nilable(Symbol)) }
  def name; end

  # Represents the location of the block parameter name.
  #
  #     def a(&b)
  #            ^
  #
  # source://prism//lib/prism/node.rb#2178
  sig { returns(T.nilable(Prism::Location)) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#2214
  sig { returns(String) }
  def operator; end

  # Represents the location of the `&` operator.
  #
  #     def a(&b)
  #           ^
  #     end
  #
  # source://prism//lib/prism/node.rb#2201
  sig { returns(Prism::Location) }
  def operator_loc; end

  # def repeated_parameter?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2163
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#2192
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#2209
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#2224
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#2229
    def type; end
  end
end

# Represents a block's parameters declaration.
#
#     -> (a, b = 1; local) { }
#        ^^^^^^^^^^^^^^^^^
#
#     foo do |a, b = 1; local|
#            ^^^^^^^^^^^^^^^^^
#     end
#
# source://prism//lib/prism/node.rb#2252
class Prism::BlockParametersNode < ::Prism::Node
  # Initialize a new BlockParametersNode node.
  #
  # @return [BlockParametersNode] a new instance of BlockParametersNode
  #
  # source://prism//lib/prism/node.rb#2254
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parameters: T.nilable(Prism::ParametersNode),
      locals: T::Array[Prism::BlockLocalVariableNode],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, parameters, locals, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#2408
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2266
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#2271
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#2387
  sig { returns(T.nilable(String)) }
  def closing; end

  # Represents the closing location of the block parameters.
  #
  #     -> (a, b = 1; local) { }
  #                        ^
  #
  #     foo do |a, b = 1; local|
  #                            ^
  #     end
  #
  # source://prism//lib/prism/node.rb#2363
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2292
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2284
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?parameters: ParametersNode?, ?locals: Array[BlockLocalVariableNode], ?opening_loc: Location?, ?closing_loc: Location?) -> BlockParametersNode
  #
  # source://prism//lib/prism/node.rb#2297
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parameters: T.nilable(Prism::ParametersNode),
      locals: T::Array[Prism::BlockLocalVariableNode],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::BlockParametersNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), parameters: T.unsafe(nil), locals: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#2302
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, parameters: ParametersNode?, locals: Array[BlockLocalVariableNode], opening_loc: Location?, closing_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#2305
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [parameters]
  #
  # source://prism//lib/prism/node.rb#2276
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#2392
  sig { override.returns(String) }
  def inspect; end

  # Represents the local variables of the block.
  #
  #     -> (a, b = 1; local) { }
  #                   ^^^^^
  #
  #     foo do |a, b = 1; local|
  #                       ^^^^^
  #     end
  #
  # source://prism//lib/prism/node.rb#2327
  sig { returns(T::Array[Prism::BlockLocalVariableNode]) }
  def locals; end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#2382
  sig { returns(T.nilable(String)) }
  def opening; end

  # Represents the opening location of the block parameters.
  #
  #     -> (a, b = 1; local) { }
  #        ^
  #
  #     foo do |a, b = 1; local|
  #            ^
  #     end
  #
  # source://prism//lib/prism/node.rb#2337
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # Represents the parameters of the block.
  #
  #     -> (a, b = 1; local) { }
  #         ^^^^^^^^
  #
  #     foo do |a, b = 1; local|
  #             ^^^^^^^^
  #     end
  #
  # source://prism//lib/prism/node.rb#2317
  sig { returns(T.nilable(Prism::ParametersNode)) }
  def parameters; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#2377
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#2351
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#2397
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#2402
    def type; end
  end
end

# Represents the use of the `break` keyword.
#
#     break foo
#     ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#2422
class Prism::BreakNode < ::Prism::Node
  # Initialize a new BreakNode node.
  #
  # @return [BreakNode] a new instance of BreakNode
  #
  # source://prism//lib/prism/node.rb#2424
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T.nilable(Prism::ArgumentsNode),
      keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, arguments, keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#2519
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2434
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # The arguments to the break statement, if present. These can be any [non-void expressions](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     break foo
  #           ^^^
  #
  # source://prism//lib/prism/node.rb#2479
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#2439
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2458
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2451
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?arguments: ArgumentsNode?, ?keyword_loc: Location) -> BreakNode
  #
  # source://prism//lib/prism/node.rb#2463
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T.nilable(Prism::ArgumentsNode),
      keyword_loc: Prism::Location
    ).returns(Prism::BreakNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), arguments: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#2468
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, arguments: ArgumentsNode?, keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#2471
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [arguments]
  #
  # source://prism//lib/prism/node.rb#2444
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#2503
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#2498
  sig { returns(String) }
  def keyword; end

  # The location of the `break` keyword.
  #
  #     break foo
  #     ^^^^^
  #
  # source://prism//lib/prism/node.rb#2485
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # Save the keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#2493
  def save_keyword_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#2508
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#2513
    def type; end
  end
end

# Represents the use of the `&&=` operator on a call.
#
#     foo.bar &&= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#2530
class Prism::CallAndWriteNode < ::Prism::Node
  # Initialize a new CallAndWriteNode node.
  #
  # @return [CallAndWriteNode] a new instance of CallAndWriteNode
  #
  # source://prism//lib/prism/node.rb#2532
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#2726
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2547
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2601
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#2695
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # Represents the location of the call operator.
  #
  #     foo.bar &&= value
  #        ^
  #
  # source://prism//lib/prism/node.rb#2620
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#2552
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2573
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2565
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node?, ?call_operator_loc: Location?, ?message_loc: Location?, ?read_name: Symbol, ?write_name: Symbol, ?operator_loc: Location, ?value: Prism::node) -> CallAndWriteNode
  #
  # source://prism//lib/prism/node.rb#2578
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::CallAndWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), message_loc: T.unsafe(nil), read_name: T.unsafe(nil), write_name: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#2583
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node?, call_operator_loc: Location?, message_loc: Location?, read_name: Symbol, write_name: Symbol, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#2586
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [receiver]
  #
  # source://prism//lib/prism/node.rb#2557
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2606
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#2710
  sig { override.returns(String) }
  def inspect; end

  # def message: () -> String?
  #
  # source://prism//lib/prism/node.rb#2700
  sig { returns(T.nilable(String)) }
  def message; end

  # Represents the location of the message.
  #
  #     foo.bar &&= value
  #         ^^^
  #
  # source://prism//lib/prism/node.rb#2642
  sig { returns(T.nilable(Prism::Location)) }
  def message_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#2705
  sig { returns(String) }
  def operator; end

  # Represents the location of the operator.
  #
  #     foo.bar &&= value
  #             ^^^
  #
  # source://prism//lib/prism/node.rb#2676
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Represents the name of the method being called.
  #
  #     foo.bar &&= value # read_name `:bar`
  #         ^^^
  #
  # source://prism//lib/prism/node.rb#2664
  sig { returns(Symbol) }
  def read_name; end

  # The object that the method is being called on. This can be either `nil` or any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     foo.bar &&= value
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#2614
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2591
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Save the call_operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#2634
  def save_call_operator_loc(repository); end

  # Save the message_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#2656
  def save_message_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#2684
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#2715
  sig { override.returns(Symbol) }
  def type; end

  # Represents the value being assigned.
  #
  #     foo.bar &&= value
  #                 ^^^^^
  #
  # source://prism//lib/prism/node.rb#2692
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2596
  sig { returns(T::Boolean) }
  def variable_call?; end

  # Represents the name of the method being written to.
  #
  #     foo.bar &&= value # write_name `:bar=`
  #         ^^^
  #
  # source://prism//lib/prism/node.rb#2670
  sig { returns(Symbol) }
  def write_name; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#2720
    def type; end
  end
end

# Represents a method call, in all of the various forms that can take.
#
#     foo
#     ^^^
#
#     foo()
#     ^^^^^
#
#     +foo
#     ^^^^
#
#     foo + bar
#     ^^^^^^^^^
#
#     foo.bar
#     ^^^^^^^
#
#     foo&.bar
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#2758
class Prism::CallNode < ::Prism::Node
  # Initialize a new CallNode node.
  #
  # @return [CallNode] a new instance of CallNode
  #
  # source://prism//lib/prism/node.rb#2760
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      name: Symbol,
      message_loc: T.nilable(Prism::Location),
      opening_loc: T.nilable(Prism::Location),
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: T.nilable(Prism::Location),
      equal_loc: T.nilable(Prism::Location),
      block: T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, name, message_loc, opening_loc, arguments, closing_loc, equal_loc, block); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#3029
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2777
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # Represents the arguments to the method call. These can be any [non-void expressions](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     foo(bar)
  #         ^^^
  #
  # source://prism//lib/prism/node.rb#2932
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2833
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # Represents the block that is being passed to the method.
  #
  #     foo { |a| a }
  #         ^^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#2985
  sig { returns(T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))) }
  def block; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#2988
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # Represents the location of the call operator.
  #
  #     foo.bar
  #        ^
  #
  #     foo&.bar
  #        ^^
  #
  # source://prism//lib/prism/node.rb#2861
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#2782
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#3003
  sig { returns(T.nilable(String)) }
  def closing; end

  # Represents the location of the right parenthesis.
  #
  #     foo(bar)
  #            ^
  #
  # source://prism//lib/prism/node.rb#2938
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2805
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2796
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node?, ?call_operator_loc: Location?, ?name: Symbol, ?message_loc: Location?, ?opening_loc: Location?, ?arguments: ArgumentsNode?, ?closing_loc: Location?, ?equal_loc: Location?, ?block: BlockNode | BlockArgumentNode | nil) -> CallNode
  #
  # source://prism//lib/prism/node.rb#2810
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      name: Symbol,
      message_loc: T.nilable(Prism::Location),
      opening_loc: T.nilable(Prism::Location),
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: T.nilable(Prism::Location),
      equal_loc: T.nilable(Prism::Location),
      block: T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))
    ).returns(Prism::CallNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), name: T.unsafe(nil), message_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), equal_loc: T.unsafe(nil), block: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#2815
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node?, call_operator_loc: Location?, name: Symbol, message_loc: Location?, opening_loc: Location?, arguments: ArgumentsNode?, closing_loc: Location?, equal_loc: Location?, block: BlockNode | BlockArgumentNode | nil }
  #
  # source://prism//lib/prism/node.rb#2818
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [receiver]
  #
  # source://prism//lib/prism/node.rb#2787
  def each_child_node; end

  # def equal: () -> String?
  #
  # source://prism//lib/prism/node.rb#3008
  sig { returns(T.nilable(String)) }
  def equal; end

  # Represents the location of the equal sign, in the case that this is an attribute write.
  #
  #     foo.bar = value
  #             ^
  #
  #     foo[bar] = value
  #              ^
  #
  # source://prism//lib/prism/node.rb#2963
  sig { returns(T.nilable(Prism::Location)) }
  def equal_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # When a call node has the attribute_write flag set, it means that the call
  # is using the attribute write syntax. This is either a method call to []=
  # or a method call to a method that ends with =. Either way, the = sign is
  # present in the source.
  #
  # Prism returns the message_loc _without_ the = sign attached, because there
  # can be any amount of space between the message and the = sign. However,
  # sometimes you want the location of the full message including the inner
  # space and the = sign. This method provides that.
  #
  # source://prism//lib/prism/node_ext.rb#334
  sig { returns(T.nilable(Prism::Location)) }
  def full_message_loc; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2838
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#3013
  sig { override.returns(String) }
  def inspect; end

  # def message: () -> String?
  #
  # source://prism//lib/prism/node.rb#2993
  sig { returns(T.nilable(String)) }
  def message; end

  # Represents the location of the message.
  #
  #     foo.bar
  #         ^^^
  #
  # source://prism//lib/prism/node.rb#2889
  sig { returns(T.nilable(Prism::Location)) }
  def message_loc; end

  # Represents the name of the method being called.
  #
  #     foo.bar # name `:foo`
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#2883
  sig { returns(Symbol) }
  def name; end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#2998
  sig { returns(T.nilable(String)) }
  def opening; end

  # Represents the location of the left parenthesis.
  #     foo(bar)
  #        ^
  #
  # source://prism//lib/prism/node.rb#2910
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # The object that the method is being called on. This can be either `nil` or any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     foo.bar
  #     ^^^
  #
  #     +foo
  #      ^^^
  #
  #     foo + bar
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#2852
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2823
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Save the call_operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#2875
  def save_call_operator_loc(repository); end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#2952
  def save_closing_loc(repository); end

  # Save the equal_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#2977
  def save_equal_loc(repository); end

  # Save the message_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#2903
  def save_message_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#2924
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#3018
  sig { override.returns(Symbol) }
  def type; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2828
  sig { returns(T::Boolean) }
  def variable_call?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#3023
    def type; end
  end
end

# Flags for call nodes.
#
# source://prism//lib/prism/node.rb#19804
module Prism::CallNodeFlags; end

# a call that is an attribute write, so the value being written should be returned
#
# source://prism//lib/prism/node.rb#19812
Prism::CallNodeFlags::ATTRIBUTE_WRITE = T.let(T.unsafe(nil), Integer)

# a call that ignores method visibility
#
# source://prism//lib/prism/node.rb#19815
Prism::CallNodeFlags::IGNORE_VISIBILITY = T.let(T.unsafe(nil), Integer)

# &. operator
#
# source://prism//lib/prism/node.rb#19806
Prism::CallNodeFlags::SAFE_NAVIGATION = T.let(T.unsafe(nil), Integer)

# a call that could have been a local variable
#
# source://prism//lib/prism/node.rb#19809
Prism::CallNodeFlags::VARIABLE_CALL = T.let(T.unsafe(nil), Integer)

# Represents the use of an assignment operator on a call.
#
#     foo.bar += baz
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3048
class Prism::CallOperatorWriteNode < ::Prism::Node
  # Initialize a new CallOperatorWriteNode node.
  #
  # @return [CallOperatorWriteNode] a new instance of CallOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#3050
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      binary_operator: Symbol,
      binary_operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, message_loc, read_name, write_name, binary_operator, binary_operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#3246
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3066
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#3120
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # Represents the binary operator being used.
  #
  #     foo.bar += value # binary_operator `:+`
  #             ^
  #
  # source://prism//lib/prism/node.rb#3195
  sig { returns(Symbol) }
  def binary_operator; end

  # Represents the location of the binary operator.
  #
  #     foo.bar += value
  #             ^^
  #
  # source://prism//lib/prism/node.rb#3201
  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#3220
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # Represents the location of the call operator.
  #
  #     foo.bar += value
  #        ^
  #
  # source://prism//lib/prism/node.rb#3139
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#3071
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3092
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3084
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node?, ?call_operator_loc: Location?, ?message_loc: Location?, ?read_name: Symbol, ?write_name: Symbol, ?binary_operator: Symbol, ?binary_operator_loc: Location, ?value: Prism::node) -> CallOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#3097
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      binary_operator: Symbol,
      binary_operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::CallOperatorWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), message_loc: T.unsafe(nil), read_name: T.unsafe(nil), write_name: T.unsafe(nil), binary_operator: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#3102
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node?, call_operator_loc: Location?, message_loc: Location?, read_name: Symbol, write_name: Symbol, binary_operator: Symbol, binary_operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#3105
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [receiver]
  #
  # source://prism//lib/prism/node.rb#3076
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#3125
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#3230
  sig { override.returns(String) }
  def inspect; end

  # def message: () -> String?
  #
  # source://prism//lib/prism/node.rb#3225
  sig { returns(T.nilable(String)) }
  def message; end

  # Represents the location of the message.
  #
  #     foo.bar += value
  #         ^^^
  #
  # source://prism//lib/prism/node.rb#3161
  sig { returns(T.nilable(Prism::Location)) }
  def message_loc; end

  # Returns the binary operator used to modify the receiver. This method is
  # deprecated in favor of #binary_operator.
  #
  # source://prism//lib/prism/node_ext.rb#342
  def operator; end

  # Returns the location of the binary operator used to modify the receiver.
  # This method is deprecated in favor of #binary_operator_loc.
  #
  # source://prism//lib/prism/node_ext.rb#349
  def operator_loc; end

  # Represents the name of the method being called.
  #
  #     foo.bar += value # read_name `:bar`
  #         ^^^
  #
  # source://prism//lib/prism/node.rb#3183
  sig { returns(Symbol) }
  def read_name; end

  # The object that the method is being called on. This can be either `nil` or any [non-void expressions](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     foo.bar += value
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#3133
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#3110
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Save the binary_operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#3209
  def save_binary_operator_loc(repository); end

  # Save the call_operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#3153
  def save_call_operator_loc(repository); end

  # Save the message_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#3175
  def save_message_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#3235
  sig { override.returns(Symbol) }
  def type; end

  # Represents the value being assigned.
  #
  #     foo.bar += value
  #                ^^^^^
  #
  # source://prism//lib/prism/node.rb#3217
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#3115
  sig { returns(T::Boolean) }
  def variable_call?; end

  # Represents the name of the method being written to.
  #
  #     foo.bar += value # write_name `:bar=`
  #         ^^^
  #
  # source://prism//lib/prism/node.rb#3189
  sig { returns(Symbol) }
  def write_name; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#3240
    def type; end
  end
end

# Represents the use of the `||=` operator on a call.
#
#     foo.bar ||= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3264
class Prism::CallOrWriteNode < ::Prism::Node
  # Initialize a new CallOrWriteNode node.
  #
  # @return [CallOrWriteNode] a new instance of CallOrWriteNode
  #
  # source://prism//lib/prism/node.rb#3266
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#3460
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3281
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#3335
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#3429
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # Represents the location of the call operator.
  #
  #     foo.bar ||= value
  #        ^
  #
  # source://prism//lib/prism/node.rb#3354
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#3286
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3307
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3299
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node?, ?call_operator_loc: Location?, ?message_loc: Location?, ?read_name: Symbol, ?write_name: Symbol, ?operator_loc: Location, ?value: Prism::node) -> CallOrWriteNode
  #
  # source://prism//lib/prism/node.rb#3312
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::CallOrWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), message_loc: T.unsafe(nil), read_name: T.unsafe(nil), write_name: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#3317
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node?, call_operator_loc: Location?, message_loc: Location?, read_name: Symbol, write_name: Symbol, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#3320
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [receiver]
  #
  # source://prism//lib/prism/node.rb#3291
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#3340
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#3444
  sig { override.returns(String) }
  def inspect; end

  # def message: () -> String?
  #
  # source://prism//lib/prism/node.rb#3434
  sig { returns(T.nilable(String)) }
  def message; end

  # Represents the location of the message.
  #
  #     foo.bar ||= value
  #         ^^^
  #
  # source://prism//lib/prism/node.rb#3376
  sig { returns(T.nilable(Prism::Location)) }
  def message_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#3439
  sig { returns(String) }
  def operator; end

  # Represents the location of the operator.
  #
  #     foo.bar ||= value
  #             ^^^
  #
  # source://prism//lib/prism/node.rb#3410
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Represents the name of the method being called.
  #
  #     foo.bar ||= value # read_name `:bar`
  #         ^^^
  #
  # source://prism//lib/prism/node.rb#3398
  sig { returns(Symbol) }
  def read_name; end

  # The object that the method is being called on. This can be either `nil` or any [non-void expressions](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     foo.bar ||= value
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#3348
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#3325
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Save the call_operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#3368
  def save_call_operator_loc(repository); end

  # Save the message_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#3390
  def save_message_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#3418
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#3449
  sig { override.returns(Symbol) }
  def type; end

  # Represents the value being assigned.
  #
  #     foo.bar ||= value
  #                 ^^^^^
  #
  # source://prism//lib/prism/node.rb#3426
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#3330
  sig { returns(T::Boolean) }
  def variable_call?; end

  # Represents the name of the method being written to.
  #
  #     foo.bar ||= value # write_name `:bar=`
  #         ^^^
  #
  # source://prism//lib/prism/node.rb#3404
  sig { returns(Symbol) }
  def write_name; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#3454
    def type; end
  end
end

# Represents assigning to a method call.
#
#     foo.bar, = 1
#     ^^^^^^^
#
#     begin
#     rescue => foo.bar
#               ^^^^^^^
#     end
#
#     for foo.bar in baz do end
#         ^^^^^^^
#
# source://prism//lib/prism/node.rb#3485
class Prism::CallTargetNode < ::Prism::Node
  # Initialize a new CallTargetNode node.
  #
  # @return [CallTargetNode] a new instance of CallTargetNode
  #
  # source://prism//lib/prism/node.rb#3487
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: Prism::Node,
      call_operator_loc: Prism::Location,
      name: Symbol,
      message_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, name, message_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#3629
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3499
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#3549
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # def call_operator: () -> String
  #
  # source://prism//lib/prism/node.rb#3603
  sig { returns(String) }
  def call_operator; end

  # Represents the location of the call operator.
  #
  #     foo.bar = 1
  #        ^
  #
  # source://prism//lib/prism/node.rb#3568
  sig { returns(Prism::Location) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#3504
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3521
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3516
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node, ?call_operator_loc: Location, ?name: Symbol, ?message_loc: Location) -> CallTargetNode
  #
  # source://prism//lib/prism/node.rb#3526
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: Prism::Node,
      call_operator_loc: Prism::Location,
      name: Symbol,
      message_loc: Prism::Location
    ).returns(Prism::CallTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), name: T.unsafe(nil), message_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#3531
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node, call_operator_loc: Location, name: Symbol, message_loc: Location }
  #
  # source://prism//lib/prism/node.rb#3534
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [receiver]
  #
  # source://prism//lib/prism/node.rb#3509
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#3554
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#3613
  sig { override.returns(String) }
  def inspect; end

  # def message: () -> String
  #
  # source://prism//lib/prism/node.rb#3608
  sig { returns(String) }
  def message; end

  # Represents the location of the message.
  #
  #     foo.bar = 1
  #         ^^^
  #
  # source://prism//lib/prism/node.rb#3590
  sig { returns(Prism::Location) }
  def message_loc; end

  # Represents the name of the method being called.
  #
  #     foo.bar = 1 # name `:foo`
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#3584
  sig { returns(Symbol) }
  def name; end

  # The object that the method is being called on. This can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     foo.bar = 1
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#3562
  sig { returns(Prism::Node) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#3539
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Save the call_operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#3576
  def save_call_operator_loc(repository); end

  # Save the message_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#3598
  def save_message_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#3618
  sig { override.returns(Symbol) }
  def type; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#3544
  sig { returns(T::Boolean) }
  def variable_call?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#3623
    def type; end
  end
end

# Represents assigning to a local variable in pattern matching.
#
#     foo => [bar => baz]
#            ^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3643
class Prism::CapturePatternNode < ::Prism::Node
  # Initialize a new CapturePatternNode node.
  #
  # @return [CapturePatternNode] a new instance of CapturePatternNode
  #
  # source://prism//lib/prism/node.rb#3645
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      target: Prism::LocalVariableTargetNode,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, value, target, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#3746
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3656
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#3661
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3679
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3674
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?value: Prism::node, ?target: LocalVariableTargetNode, ?operator_loc: Location) -> CapturePatternNode
  #
  # source://prism//lib/prism/node.rb#3684
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      target: Prism::LocalVariableTargetNode,
      operator_loc: Prism::Location
    ).returns(Prism::CapturePatternNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil), target: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#3689
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, value: Prism::node, target: LocalVariableTargetNode, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#3692
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#3666
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#3730
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#3725
  sig { returns(String) }
  def operator; end

  # Represents the location of the `=>` operator.
  #
  #     foo => bar
  #         ^^
  #
  # source://prism//lib/prism/node.rb#3712
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#3720
  def save_operator_loc(repository); end

  # Represents the target of the capture.
  #
  #     foo => bar
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#3706
  sig { returns(Prism::LocalVariableTargetNode) }
  def target; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#3735
  sig { override.returns(Symbol) }
  def type; end

  # Represents the value to capture.
  #
  #     foo => bar
  #            ^^^
  #
  # source://prism//lib/prism/node.rb#3700
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#3740
    def type; end
  end
end

# Represents the use of a case statement for pattern matching.
#
#     case true
#     in false
#     end
#     ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3760
class Prism::CaseMatchNode < ::Prism::Node
  # Initialize a new CaseMatchNode node.
  #
  # @return [CaseMatchNode] a new instance of CaseMatchNode
  #
  # source://prism//lib/prism/node.rb#3762
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      predicate: T.nilable(Prism::Node),
      conditions: T::Array[Prism::InNode],
      else_clause: T.nilable(Prism::ElseNode),
      case_keyword_loc: Prism::Location,
      end_keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, predicate, conditions, else_clause, case_keyword_loc, end_keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#3897
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3775
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def case_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#3871
  sig { returns(String) }
  def case_keyword; end

  # Represents the location of the `case` keyword.
  #
  #     case true; in false; end
  #     ^^^^
  #
  # source://prism//lib/prism/node.rb#3842
  sig { returns(Prism::Location) }
  def case_keyword_loc; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#3780
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3803
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3794
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # Represents the conditions of the case match.
  #
  #     case true; in false; end
  #                ^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#3830
  sig { returns(T::Array[Prism::InNode]) }
  def conditions; end

  # Returns the else clause of the case match node. This method is deprecated
  # in favor of #else_clause.
  #
  # source://prism//lib/prism/node_ext.rb#470
  def consequent; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?predicate: Prism::node?, ?conditions: Array[InNode], ?else_clause: ElseNode?, ?case_keyword_loc: Location, ?end_keyword_loc: Location) -> CaseMatchNode
  #
  # source://prism//lib/prism/node.rb#3808
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      predicate: T.nilable(Prism::Node),
      conditions: T::Array[Prism::InNode],
      else_clause: T.nilable(Prism::ElseNode),
      case_keyword_loc: Prism::Location,
      end_keyword_loc: Prism::Location
    ).returns(Prism::CaseMatchNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), predicate: T.unsafe(nil), conditions: T.unsafe(nil), else_clause: T.unsafe(nil), case_keyword_loc: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#3813
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, predicate: Prism::node?, conditions: Array[InNode], else_clause: ElseNode?, case_keyword_loc: Location, end_keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#3816
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [predicate]
  #
  # source://prism//lib/prism/node.rb#3785
  def each_child_node; end

  # Represents the else clause of the case match.
  #
  #     case true; in false; else; end
  #                          ^^^^
  #
  # source://prism//lib/prism/node.rb#3836
  sig { returns(T.nilable(Prism::ElseNode)) }
  def else_clause; end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#3876
  sig { returns(String) }
  def end_keyword; end

  # Represents the location of the `end` keyword.
  #
  #     case true; in false; end
  #                          ^^^
  #
  # source://prism//lib/prism/node.rb#3858
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#3881
  sig { override.returns(String) }
  def inspect; end

  # Represents the predicate of the case match. This can be either `nil` or any [non-void expressions](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     case true; in false; end
  #     ^^^^
  #
  # source://prism//lib/prism/node.rb#3824
  sig { returns(T.nilable(Prism::Node)) }
  def predicate; end

  # Save the case_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#3850
  def save_case_keyword_loc(repository); end

  # Save the end_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#3866
  def save_end_keyword_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#3886
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#3891
    def type; end
  end
end

# Represents the use of a case statement.
#
#     case true
#     when false
#     end
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3914
class Prism::CaseNode < ::Prism::Node
  # Initialize a new CaseNode node.
  #
  # @return [CaseNode] a new instance of CaseNode
  #
  # source://prism//lib/prism/node.rb#3916
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      predicate: T.nilable(Prism::Node),
      conditions: T::Array[Prism::WhenNode],
      else_clause: T.nilable(Prism::ElseNode),
      case_keyword_loc: Prism::Location,
      end_keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, predicate, conditions, else_clause, case_keyword_loc, end_keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4051
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3929
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def case_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#4025
  sig { returns(String) }
  def case_keyword; end

  # Represents the location of the `case` keyword.
  #
  #     case true; when false; end
  #     ^^^^
  #
  # source://prism//lib/prism/node.rb#3996
  sig { returns(Prism::Location) }
  def case_keyword_loc; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#3934
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3957
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3948
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # Represents the conditions of the case statement.
  #
  #     case true; when false; end
  #                ^^^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#3984
  sig { returns(T::Array[Prism::WhenNode]) }
  def conditions; end

  # Returns the else clause of the case node. This method is deprecated in
  # favor of #else_clause.
  #
  # source://prism//lib/prism/node_ext.rb#479
  def consequent; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?predicate: Prism::node?, ?conditions: Array[WhenNode], ?else_clause: ElseNode?, ?case_keyword_loc: Location, ?end_keyword_loc: Location) -> CaseNode
  #
  # source://prism//lib/prism/node.rb#3962
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      predicate: T.nilable(Prism::Node),
      conditions: T::Array[Prism::WhenNode],
      else_clause: T.nilable(Prism::ElseNode),
      case_keyword_loc: Prism::Location,
      end_keyword_loc: Prism::Location
    ).returns(Prism::CaseNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), predicate: T.unsafe(nil), conditions: T.unsafe(nil), else_clause: T.unsafe(nil), case_keyword_loc: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#3967
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, predicate: Prism::node?, conditions: Array[WhenNode], else_clause: ElseNode?, case_keyword_loc: Location, end_keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#3970
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [predicate]
  #
  # source://prism//lib/prism/node.rb#3939
  def each_child_node; end

  # Represents the else clause of the case statement.
  #
  #     case true; when false; else; end
  #                            ^^^^
  #
  # source://prism//lib/prism/node.rb#3990
  sig { returns(T.nilable(Prism::ElseNode)) }
  def else_clause; end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#4030
  sig { returns(String) }
  def end_keyword; end

  # Represents the location of the `end` keyword.
  #
  #     case true; when false; end
  #                            ^^^
  #
  # source://prism//lib/prism/node.rb#4012
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4035
  sig { override.returns(String) }
  def inspect; end

  # Represents the predicate of the case statement. This can be either `nil` or any [non-void expressions](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     case true; when false; end
  #          ^^^^
  #
  # source://prism//lib/prism/node.rb#3978
  sig { returns(T.nilable(Prism::Node)) }
  def predicate; end

  # Save the case_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#4004
  def save_case_keyword_loc(repository); end

  # Save the end_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#4020
  def save_end_keyword_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4040
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4045
    def type; end
  end
end

# Represents a class declaration involving the `class` keyword.
#
#     class Foo end
#     ^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4066
class Prism::ClassNode < ::Prism::Node
  # Initialize a new ClassNode node.
  #
  # @return [ClassNode] a new instance of ClassNode
  #
  # source://prism//lib/prism/node.rb#4068
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      class_keyword_loc: Prism::Location,
      constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::CallNode),
      inheritance_operator_loc: T.nilable(Prism::Location),
      superclass: T.nilable(Prism::Node),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      end_keyword_loc: Prism::Location,
      name: Symbol
    ).void
  end
  def initialize(source, node_id, location, flags, locals, class_keyword_loc, constant_path, inheritance_operator_loc, superclass, body, end_keyword_loc, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4239
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4084
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # Represents the body of the class.
  #
  #     class Foo
  #       foo
  #       ^^^
  #
  # source://prism//lib/prism/node.rb#4184
  sig { returns(T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))) }
  def body; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#4089
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def class_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#4208
  sig { returns(String) }
  def class_keyword; end

  # Represents the location of the `class` keyword.
  #
  #     class Foo end
  #     ^^^^^
  #
  # source://prism//lib/prism/node.rb#4136
  sig { returns(Prism::Location) }
  def class_keyword_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4112
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4103
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # attr_reader constant_path: ConstantReadNode | ConstantPathNode | CallNode
  #
  # source://prism//lib/prism/node.rb#4149
  sig { returns(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::CallNode)) }
  def constant_path; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?locals: Array[Symbol], ?class_keyword_loc: Location, ?constant_path: ConstantReadNode | ConstantPathNode | CallNode, ?inheritance_operator_loc: Location?, ?superclass: Prism::node?, ?body: StatementsNode | BeginNode | nil, ?end_keyword_loc: Location, ?name: Symbol) -> ClassNode
  #
  # source://prism//lib/prism/node.rb#4117
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      class_keyword_loc: Prism::Location,
      constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::CallNode),
      inheritance_operator_loc: T.nilable(Prism::Location),
      superclass: T.nilable(Prism::Node),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      end_keyword_loc: Prism::Location,
      name: Symbol
    ).returns(Prism::ClassNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), class_keyword_loc: T.unsafe(nil), constant_path: T.unsafe(nil), inheritance_operator_loc: T.unsafe(nil), superclass: T.unsafe(nil), body: T.unsafe(nil), end_keyword_loc: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#4122
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, locals: Array[Symbol], class_keyword_loc: Location, constant_path: ConstantReadNode | ConstantPathNode | CallNode, inheritance_operator_loc: Location?, superclass: Prism::node?, body: StatementsNode | BeginNode | nil, end_keyword_loc: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#4125
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [constant_path]
  #
  # source://prism//lib/prism/node.rb#4094
  def each_child_node; end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#4218
  sig { returns(String) }
  def end_keyword; end

  # Represents the location of the `end` keyword.
  #
  #     class Foo end
  #               ^^^
  #
  # source://prism//lib/prism/node.rb#4190
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inheritance_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#4213
  sig { returns(T.nilable(String)) }
  def inheritance_operator; end

  # Represents the location of the `<` operator.
  #
  #     class Foo < Bar
  #               ^
  #
  # source://prism//lib/prism/node.rb#4155
  sig { returns(T.nilable(Prism::Location)) }
  def inheritance_operator_loc; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4223
  sig { override.returns(String) }
  def inspect; end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#4130
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # The name of the class.
  #
  #     class Foo end # name `:Foo`
  #
  # source://prism//lib/prism/node.rb#4205
  sig { returns(Symbol) }
  def name; end

  # Save the class_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#4144
  def save_class_keyword_loc(repository); end

  # Save the end_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#4198
  def save_end_keyword_loc(repository); end

  # Save the inheritance_operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#4169
  def save_inheritance_operator_loc(repository); end

  # Represents the superclass of the class.
  #
  #     class Foo < Bar
  #                 ^^^
  #
  # source://prism//lib/prism/node.rb#4177
  sig { returns(T.nilable(Prism::Node)) }
  def superclass; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4228
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4233
    def type; end
  end
end

# Represents the use of the `&&=` operator for assignment to a class variable.
#
#     @@target &&= value
#     ^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4257
class Prism::ClassVariableAndWriteNode < ::Prism::Node
  # Initialize a new ClassVariableAndWriteNode node.
  #
  # @return [ClassVariableAndWriteNode] a new instance of ClassVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#4259
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4376
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4271
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#4276
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4293
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4288
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> ClassVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#4298
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ClassVariableAndWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#4303
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#4306
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#165
  def desugar; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#4281
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4360
  sig { override.returns(String) }
  def inspect; end

  # The name of the class variable, which is a `@@` followed by an [identifier](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#identifiers).
  #
  #     @@target &&= value # name `:@@target`
  #     ^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#4314
  sig { returns(Symbol) }
  def name; end

  # Represents the location of the variable name.
  #
  #     @@target &&= value
  #     ^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#4320
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#4355
  sig { returns(String) }
  def operator; end

  # Represents the location of the `&&=` operator.
  #
  #     @@target &&= value
  #              ^^^
  #
  # source://prism//lib/prism/node.rb#4336
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#4328
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#4344
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4365
  sig { override.returns(Symbol) }
  def type; end

  # Represents the value being assigned. This can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     @@target &&= value
  #                  ^^^^^
  #
  # source://prism//lib/prism/node.rb#4352
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4370
    def type; end
  end
end

# Represents assigning to a class variable using an operator that isn't `=`.
#
#     @@target += value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4389
class Prism::ClassVariableOperatorWriteNode < ::Prism::Node
  # Initialize a new ClassVariableOperatorWriteNode node.
  #
  # @return [ClassVariableOperatorWriteNode] a new instance of ClassVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#4391
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, binary_operator_loc, value, binary_operator); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4495
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4404
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader binary_operator: Symbol
  #
  # source://prism//lib/prism/node.rb#4476
  sig { returns(Symbol) }
  def binary_operator; end

  # attr_reader binary_operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#4460
  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#4409
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4426
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4421
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?binary_operator_loc: Location, ?value: Prism::node, ?binary_operator: Symbol) -> ClassVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#4431
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::ClassVariableOperatorWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#4436
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, binary_operator_loc: Location, value: Prism::node, binary_operator: Symbol }
  #
  # source://prism//lib/prism/node.rb#4439
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#177
  def desugar; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#4414
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4479
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#4444
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#4447
  sig { returns(Prism::Location) }
  def name_loc; end

  # Returns the binary operator used to modify the receiver. This method is
  # deprecated in favor of #binary_operator.
  #
  # source://prism//lib/prism/node_ext.rb#358
  def operator; end

  # Returns the location of the binary operator used to modify the receiver.
  # This method is deprecated in favor of #binary_operator_loc.
  #
  # source://prism//lib/prism/node_ext.rb#365
  def operator_loc; end

  # Save the binary_operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#4468
  def save_binary_operator_loc(repository); end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#4455
  def save_name_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4484
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#4473
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4489
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to a class variable.
#
#     @@target ||= value
#     ^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4509
class Prism::ClassVariableOrWriteNode < ::Prism::Node
  # Initialize a new ClassVariableOrWriteNode node.
  #
  # @return [ClassVariableOrWriteNode] a new instance of ClassVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#4511
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4616
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4523
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#4528
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4545
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4540
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> ClassVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#4550
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ClassVariableOrWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#4555
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#4558
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#171
  def desugar; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#4533
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4600
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#4563
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#4566
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#4595
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#4579
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#4574
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#4587
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4605
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#4592
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4610
    def type; end
  end
end

# Represents referencing a class variable.
#
#     @@foo
#     ^^^^^
#
# source://prism//lib/prism/node.rb#4629
class Prism::ClassVariableReadNode < ::Prism::Node
  # Initialize a new ClassVariableReadNode node.
  #
  # @return [ClassVariableReadNode] a new instance of ClassVariableReadNode
  #
  # source://prism//lib/prism/node.rb#4631
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4702
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4640
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#4645
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4661
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4656
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> ClassVariableReadNode
  #
  # source://prism//lib/prism/node.rb#4666
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::ClassVariableReadNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#4671
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#4674
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#4650
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4686
  sig { override.returns(String) }
  def inspect; end

  # The name of the class variable, which is a `@@` followed by an [identifier](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#identifiers).
  #
  #     @@abc   # name `:@@abc`
  #
  #     @@_test # name `:@@_test`
  #
  # source://prism//lib/prism/node.rb#4683
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4691
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4696
    def type; end
  end
end

# Represents writing to a class variable in a context that doesn't have an explicit value.
#
#     @@foo, @@bar = baz
#     ^^^^^  ^^^^^
#
# source://prism//lib/prism/node.rb#4712
class Prism::ClassVariableTargetNode < ::Prism::Node
  # Initialize a new ClassVariableTargetNode node.
  #
  # @return [ClassVariableTargetNode] a new instance of ClassVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#4714
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4781
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4723
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#4728
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4744
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4739
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> ClassVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#4749
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::ClassVariableTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#4754
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#4757
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#4733
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4765
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#4762
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4770
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4775
    def type; end
  end
end

# Represents writing to a class variable.
#
#     @@foo = 1
#     ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4791
class Prism::ClassVariableWriteNode < ::Prism::Node
  # Initialize a new ClassVariableWriteNode node.
  #
  # @return [ClassVariableWriteNode] a new instance of ClassVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#4793
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, value, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4914
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4805
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#4810
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4827
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4822
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?value: Prism::node, ?operator_loc: Location) -> ClassVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#4832
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::ClassVariableWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#4837
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, value: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#4840
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#4815
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4898
  sig { override.returns(String) }
  def inspect; end

  # The name of the class variable, which is a `@@` followed by an [identifier](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#identifiers).
  #
  #     @@abc = 123     # name `@@abc`
  #
  #     @@_test = :test # name `@@_test`
  #
  # source://prism//lib/prism/node.rb#4849
  sig { returns(Symbol) }
  def name; end

  # The location of the variable name.
  #
  #     @@foo = :bar
  #     ^^^^^
  #
  # source://prism//lib/prism/node.rb#4855
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#4893
  sig { returns(String) }
  def operator; end

  # The location of the `=` operator.
  #
  #     @@foo = :bar
  #           ^
  #
  # source://prism//lib/prism/node.rb#4880
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#4863
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#4888
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4903
  sig { override.returns(Symbol) }
  def type; end

  # The value to write to the class variable. This can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     @@foo = :bar
  #             ^^^^
  #
  #     @@_xyz = 123
  #              ^^^
  #
  # source://prism//lib/prism/node.rb#4874
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4908
    def type; end
  end
end

# A cache that can be used to quickly compute code unit offsets from byte
# offsets. It purposefully provides only a single #[] method to access the
# cache in order to minimize surface area.
#
# Note that there are some known issues here that may or may not be addressed
# in the future:
#
# * The first is that there are issues when the cache computes values that are
#   not on character boundaries. This can result in subsequent computations
#   being off by one or more code units.
# * The second is that this cache is currently unbounded. In theory we could
#   introduce some kind of LRU cache to limit the number of entries, but this
#   has not yet been implemented.
#
# source://prism//lib/prism/parse_result.rb#186
class Prism::CodeUnitsCache
  # Initialize a new cache with the given source and encoding.
  #
  # @return [CodeUnitsCache] a new instance of CodeUnitsCache
  #
  # source://prism//lib/prism/parse_result.rb#212
  sig { params(source: String, encoding: Encoding).void }
  def initialize(source, encoding); end

  # Retrieve the code units offset from the given byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#226
  sig { params(byte_offset: Integer).returns(Integer) }
  def [](byte_offset); end
end

# source://prism//lib/prism/parse_result.rb#198
class Prism::CodeUnitsCache::LengthCounter
  # @return [LengthCounter] a new instance of LengthCounter
  #
  # source://prism//lib/prism/parse_result.rb#199
  def initialize(source, encoding); end

  # source://prism//lib/prism/parse_result.rb#204
  def count(byte_offset, byte_length); end
end

# source://prism//lib/prism/parse_result.rb#187
class Prism::CodeUnitsCache::UTF16Counter
  # @return [UTF16Counter] a new instance of UTF16Counter
  #
  # source://prism//lib/prism/parse_result.rb#188
  def initialize(source, encoding); end

  # source://prism//lib/prism/parse_result.rb#193
  def count(byte_offset, byte_length); end
end

# This represents a comment that was encountered during parsing. It is the
# base class for all comment types.
#
# source://prism//lib/prism/parse_result.rb#521
class Prism::Comment
  abstract!

  # Create a new comment object with the given location.
  #
  # @return [Comment] a new instance of Comment
  #
  # source://prism//lib/prism/parse_result.rb#526
  sig { params(location: Prism::Location).void }
  def initialize(location); end

  # Implement the hash pattern matching interface for Comment.
  #
  # source://prism//lib/prism/parse_result.rb#531
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # The location of this comment in the source.
  #
  # source://prism//lib/prism/parse_result.rb#523
  sig { returns(Prism::Location) }
  def location; end

  # Returns the content of the comment by slicing it from the source code.
  #
  # source://prism//lib/prism/parse_result.rb#536
  sig { returns(String) }
  def slice; end

  sig { abstract.returns(T::Boolean) }
  def trailing?; end
end

# A compiler is a visitor that returns the value of each node as it visits.
# This is as opposed to a visitor which will only walk the tree. This can be
# useful when you are trying to compile a tree into a different format.
#
# For example, to build a representation of the tree as s-expressions, you
# could write:
#
#     class SExpressions < Prism::Compiler
#       def visit_arguments_node(node) = [:arguments, super]
#       def visit_call_node(node) = [:call, super]
#       def visit_integer_node(node) = [:integer]
#       def visit_program_node(node) = [:program, super]
#     end
#
#     Prism.parse("1 + 2").value.accept(SExpressions.new)
#     # => [:program, [[[:call, [[:integer], [:arguments, [[:integer]]]]]]]]
#
# source://prism//lib/prism/compiler.rb#30
class Prism::Compiler < ::Prism::Visitor
  # Visit an individual node.
  #
  # source://prism//lib/prism/compiler.rb#32
  sig { params(node: T.nilable(Prism::Node)).returns(T.untyped) }
  def visit(node); end

  # Compile a AliasGlobalVariableNode node
  #
  # source://prism//lib/prism/compiler.rb#47
  def visit_alias_global_variable_node(node); end

  # Compile a AliasMethodNode node
  #
  # source://prism//lib/prism/compiler.rb#52
  def visit_alias_method_node(node); end

  # Visit a list of nodes.
  #
  # source://prism//lib/prism/compiler.rb#37
  sig { params(nodes: T::Array[T.nilable(Prism::Node)]).returns(T::Array[T.untyped]) }
  def visit_all(nodes); end

  # Compile a AlternationPatternNode node
  #
  # source://prism//lib/prism/compiler.rb#57
  def visit_alternation_pattern_node(node); end

  # Compile a AndNode node
  #
  # source://prism//lib/prism/compiler.rb#62
  def visit_and_node(node); end

  # Compile a ArgumentsNode node
  #
  # source://prism//lib/prism/compiler.rb#67
  def visit_arguments_node(node); end

  # Compile a ArrayNode node
  #
  # source://prism//lib/prism/compiler.rb#72
  def visit_array_node(node); end

  # Compile a ArrayPatternNode node
  #
  # source://prism//lib/prism/compiler.rb#77
  def visit_array_pattern_node(node); end

  # Compile a AssocNode node
  #
  # source://prism//lib/prism/compiler.rb#82
  def visit_assoc_node(node); end

  # Compile a AssocSplatNode node
  #
  # source://prism//lib/prism/compiler.rb#87
  def visit_assoc_splat_node(node); end

  # Compile a BackReferenceReadNode node
  #
  # source://prism//lib/prism/compiler.rb#92
  def visit_back_reference_read_node(node); end

  # Compile a BeginNode node
  #
  # source://prism//lib/prism/compiler.rb#97
  def visit_begin_node(node); end

  # Compile a BlockArgumentNode node
  #
  # source://prism//lib/prism/compiler.rb#102
  def visit_block_argument_node(node); end

  # Compile a BlockLocalVariableNode node
  #
  # source://prism//lib/prism/compiler.rb#107
  def visit_block_local_variable_node(node); end

  # Compile a BlockNode node
  #
  # source://prism//lib/prism/compiler.rb#112
  def visit_block_node(node); end

  # Compile a BlockParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#117
  def visit_block_parameter_node(node); end

  # Compile a BlockParametersNode node
  #
  # source://prism//lib/prism/compiler.rb#122
  def visit_block_parameters_node(node); end

  # Compile a BreakNode node
  #
  # source://prism//lib/prism/compiler.rb#127
  def visit_break_node(node); end

  # Compile a CallAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#132
  def visit_call_and_write_node(node); end

  # Compile a CallNode node
  #
  # source://prism//lib/prism/compiler.rb#137
  def visit_call_node(node); end

  # Compile a CallOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#142
  def visit_call_operator_write_node(node); end

  # Compile a CallOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#147
  def visit_call_or_write_node(node); end

  # Compile a CallTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#152
  def visit_call_target_node(node); end

  # Compile a CapturePatternNode node
  #
  # source://prism//lib/prism/compiler.rb#157
  def visit_capture_pattern_node(node); end

  # Compile a CaseMatchNode node
  #
  # source://prism//lib/prism/compiler.rb#162
  def visit_case_match_node(node); end

  # Compile a CaseNode node
  #
  # source://prism//lib/prism/compiler.rb#167
  def visit_case_node(node); end

  # Visit the child nodes of the given node.
  #
  # source://prism//lib/prism/compiler.rb#42
  sig { params(node: Prism::Node).returns(T::Array[T.untyped]) }
  def visit_child_nodes(node); end

  # Compile a ClassNode node
  #
  # source://prism//lib/prism/compiler.rb#172
  def visit_class_node(node); end

  # Compile a ClassVariableAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#177
  def visit_class_variable_and_write_node(node); end

  # Compile a ClassVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#182
  def visit_class_variable_operator_write_node(node); end

  # Compile a ClassVariableOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#187
  def visit_class_variable_or_write_node(node); end

  # Compile a ClassVariableReadNode node
  #
  # source://prism//lib/prism/compiler.rb#192
  def visit_class_variable_read_node(node); end

  # Compile a ClassVariableTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#197
  def visit_class_variable_target_node(node); end

  # Compile a ClassVariableWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#202
  def visit_class_variable_write_node(node); end

  # Compile a ConstantAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#207
  def visit_constant_and_write_node(node); end

  # Compile a ConstantOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#212
  def visit_constant_operator_write_node(node); end

  # Compile a ConstantOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#217
  def visit_constant_or_write_node(node); end

  # Compile a ConstantPathAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#222
  def visit_constant_path_and_write_node(node); end

  # Compile a ConstantPathNode node
  #
  # source://prism//lib/prism/compiler.rb#227
  def visit_constant_path_node(node); end

  # Compile a ConstantPathOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#232
  def visit_constant_path_operator_write_node(node); end

  # Compile a ConstantPathOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#237
  def visit_constant_path_or_write_node(node); end

  # Compile a ConstantPathTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#242
  def visit_constant_path_target_node(node); end

  # Compile a ConstantPathWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#247
  def visit_constant_path_write_node(node); end

  # Compile a ConstantReadNode node
  #
  # source://prism//lib/prism/compiler.rb#252
  def visit_constant_read_node(node); end

  # Compile a ConstantTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#257
  def visit_constant_target_node(node); end

  # Compile a ConstantWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#262
  def visit_constant_write_node(node); end

  # Compile a DefNode node
  #
  # source://prism//lib/prism/compiler.rb#267
  def visit_def_node(node); end

  # Compile a DefinedNode node
  #
  # source://prism//lib/prism/compiler.rb#272
  def visit_defined_node(node); end

  # Compile a ElseNode node
  #
  # source://prism//lib/prism/compiler.rb#277
  def visit_else_node(node); end

  # Compile a EmbeddedStatementsNode node
  #
  # source://prism//lib/prism/compiler.rb#282
  def visit_embedded_statements_node(node); end

  # Compile a EmbeddedVariableNode node
  #
  # source://prism//lib/prism/compiler.rb#287
  def visit_embedded_variable_node(node); end

  # Compile a EnsureNode node
  #
  # source://prism//lib/prism/compiler.rb#292
  def visit_ensure_node(node); end

  # Compile a FalseNode node
  #
  # source://prism//lib/prism/compiler.rb#297
  def visit_false_node(node); end

  # Compile a FindPatternNode node
  #
  # source://prism//lib/prism/compiler.rb#302
  def visit_find_pattern_node(node); end

  # Compile a FlipFlopNode node
  #
  # source://prism//lib/prism/compiler.rb#307
  def visit_flip_flop_node(node); end

  # Compile a FloatNode node
  #
  # source://prism//lib/prism/compiler.rb#312
  def visit_float_node(node); end

  # Compile a ForNode node
  #
  # source://prism//lib/prism/compiler.rb#317
  def visit_for_node(node); end

  # Compile a ForwardingArgumentsNode node
  #
  # source://prism//lib/prism/compiler.rb#322
  def visit_forwarding_arguments_node(node); end

  # Compile a ForwardingParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#327
  def visit_forwarding_parameter_node(node); end

  # Compile a ForwardingSuperNode node
  #
  # source://prism//lib/prism/compiler.rb#332
  def visit_forwarding_super_node(node); end

  # Compile a GlobalVariableAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#337
  def visit_global_variable_and_write_node(node); end

  # Compile a GlobalVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#342
  def visit_global_variable_operator_write_node(node); end

  # Compile a GlobalVariableOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#347
  def visit_global_variable_or_write_node(node); end

  # Compile a GlobalVariableReadNode node
  #
  # source://prism//lib/prism/compiler.rb#352
  def visit_global_variable_read_node(node); end

  # Compile a GlobalVariableTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#357
  def visit_global_variable_target_node(node); end

  # Compile a GlobalVariableWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#362
  def visit_global_variable_write_node(node); end

  # Compile a HashNode node
  #
  # source://prism//lib/prism/compiler.rb#367
  def visit_hash_node(node); end

  # Compile a HashPatternNode node
  #
  # source://prism//lib/prism/compiler.rb#372
  def visit_hash_pattern_node(node); end

  # Compile a IfNode node
  #
  # source://prism//lib/prism/compiler.rb#377
  def visit_if_node(node); end

  # Compile a ImaginaryNode node
  #
  # source://prism//lib/prism/compiler.rb#382
  def visit_imaginary_node(node); end

  # Compile a ImplicitNode node
  #
  # source://prism//lib/prism/compiler.rb#387
  def visit_implicit_node(node); end

  # Compile a ImplicitRestNode node
  #
  # source://prism//lib/prism/compiler.rb#392
  def visit_implicit_rest_node(node); end

  # Compile a InNode node
  #
  # source://prism//lib/prism/compiler.rb#397
  def visit_in_node(node); end

  # Compile a IndexAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#402
  def visit_index_and_write_node(node); end

  # Compile a IndexOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#407
  def visit_index_operator_write_node(node); end

  # Compile a IndexOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#412
  def visit_index_or_write_node(node); end

  # Compile a IndexTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#417
  def visit_index_target_node(node); end

  # Compile a InstanceVariableAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#422
  def visit_instance_variable_and_write_node(node); end

  # Compile a InstanceVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#427
  def visit_instance_variable_operator_write_node(node); end

  # Compile a InstanceVariableOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#432
  def visit_instance_variable_or_write_node(node); end

  # Compile a InstanceVariableReadNode node
  #
  # source://prism//lib/prism/compiler.rb#437
  def visit_instance_variable_read_node(node); end

  # Compile a InstanceVariableTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#442
  def visit_instance_variable_target_node(node); end

  # Compile a InstanceVariableWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#447
  def visit_instance_variable_write_node(node); end

  # Compile a IntegerNode node
  #
  # source://prism//lib/prism/compiler.rb#452
  def visit_integer_node(node); end

  # Compile a InterpolatedMatchLastLineNode node
  #
  # source://prism//lib/prism/compiler.rb#457
  def visit_interpolated_match_last_line_node(node); end

  # Compile a InterpolatedRegularExpressionNode node
  #
  # source://prism//lib/prism/compiler.rb#462
  def visit_interpolated_regular_expression_node(node); end

  # Compile a InterpolatedStringNode node
  #
  # source://prism//lib/prism/compiler.rb#467
  def visit_interpolated_string_node(node); end

  # Compile a InterpolatedSymbolNode node
  #
  # source://prism//lib/prism/compiler.rb#472
  def visit_interpolated_symbol_node(node); end

  # Compile a InterpolatedXStringNode node
  #
  # source://prism//lib/prism/compiler.rb#477
  def visit_interpolated_x_string_node(node); end

  # Compile a ItLocalVariableReadNode node
  #
  # source://prism//lib/prism/compiler.rb#482
  def visit_it_local_variable_read_node(node); end

  # Compile a ItParametersNode node
  #
  # source://prism//lib/prism/compiler.rb#487
  def visit_it_parameters_node(node); end

  # Compile a KeywordHashNode node
  #
  # source://prism//lib/prism/compiler.rb#492
  def visit_keyword_hash_node(node); end

  # Compile a KeywordRestParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#497
  def visit_keyword_rest_parameter_node(node); end

  # Compile a LambdaNode node
  #
  # source://prism//lib/prism/compiler.rb#502
  def visit_lambda_node(node); end

  # Compile a LocalVariableAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#507
  def visit_local_variable_and_write_node(node); end

  # Compile a LocalVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#512
  def visit_local_variable_operator_write_node(node); end

  # Compile a LocalVariableOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#517
  def visit_local_variable_or_write_node(node); end

  # Compile a LocalVariableReadNode node
  #
  # source://prism//lib/prism/compiler.rb#522
  def visit_local_variable_read_node(node); end

  # Compile a LocalVariableTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#527
  def visit_local_variable_target_node(node); end

  # Compile a LocalVariableWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#532
  def visit_local_variable_write_node(node); end

  # Compile a MatchLastLineNode node
  #
  # source://prism//lib/prism/compiler.rb#537
  def visit_match_last_line_node(node); end

  # Compile a MatchPredicateNode node
  #
  # source://prism//lib/prism/compiler.rb#542
  def visit_match_predicate_node(node); end

  # Compile a MatchRequiredNode node
  #
  # source://prism//lib/prism/compiler.rb#547
  def visit_match_required_node(node); end

  # Compile a MatchWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#552
  def visit_match_write_node(node); end

  # Compile a MissingNode node
  #
  # source://prism//lib/prism/compiler.rb#557
  def visit_missing_node(node); end

  # Compile a ModuleNode node
  #
  # source://prism//lib/prism/compiler.rb#562
  def visit_module_node(node); end

  # Compile a MultiTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#567
  def visit_multi_target_node(node); end

  # Compile a MultiWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#572
  def visit_multi_write_node(node); end

  # Compile a NextNode node
  #
  # source://prism//lib/prism/compiler.rb#577
  def visit_next_node(node); end

  # Compile a NilNode node
  #
  # source://prism//lib/prism/compiler.rb#582
  def visit_nil_node(node); end

  # Compile a NoKeywordsParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#587
  def visit_no_keywords_parameter_node(node); end

  # Compile a NumberedParametersNode node
  #
  # source://prism//lib/prism/compiler.rb#592
  def visit_numbered_parameters_node(node); end

  # Compile a NumberedReferenceReadNode node
  #
  # source://prism//lib/prism/compiler.rb#597
  def visit_numbered_reference_read_node(node); end

  # Compile a OptionalKeywordParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#602
  def visit_optional_keyword_parameter_node(node); end

  # Compile a OptionalParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#607
  def visit_optional_parameter_node(node); end

  # Compile a OrNode node
  #
  # source://prism//lib/prism/compiler.rb#612
  def visit_or_node(node); end

  # Compile a ParametersNode node
  #
  # source://prism//lib/prism/compiler.rb#617
  def visit_parameters_node(node); end

  # Compile a ParenthesesNode node
  #
  # source://prism//lib/prism/compiler.rb#622
  def visit_parentheses_node(node); end

  # Compile a PinnedExpressionNode node
  #
  # source://prism//lib/prism/compiler.rb#627
  def visit_pinned_expression_node(node); end

  # Compile a PinnedVariableNode node
  #
  # source://prism//lib/prism/compiler.rb#632
  def visit_pinned_variable_node(node); end

  # Compile a PostExecutionNode node
  #
  # source://prism//lib/prism/compiler.rb#637
  def visit_post_execution_node(node); end

  # Compile a PreExecutionNode node
  #
  # source://prism//lib/prism/compiler.rb#642
  def visit_pre_execution_node(node); end

  # Compile a ProgramNode node
  #
  # source://prism//lib/prism/compiler.rb#647
  def visit_program_node(node); end

  # Compile a RangeNode node
  #
  # source://prism//lib/prism/compiler.rb#652
  def visit_range_node(node); end

  # Compile a RationalNode node
  #
  # source://prism//lib/prism/compiler.rb#657
  def visit_rational_node(node); end

  # Compile a RedoNode node
  #
  # source://prism//lib/prism/compiler.rb#662
  def visit_redo_node(node); end

  # Compile a RegularExpressionNode node
  #
  # source://prism//lib/prism/compiler.rb#667
  def visit_regular_expression_node(node); end

  # Compile a RequiredKeywordParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#672
  def visit_required_keyword_parameter_node(node); end

  # Compile a RequiredParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#677
  def visit_required_parameter_node(node); end

  # Compile a RescueModifierNode node
  #
  # source://prism//lib/prism/compiler.rb#682
  def visit_rescue_modifier_node(node); end

  # Compile a RescueNode node
  #
  # source://prism//lib/prism/compiler.rb#687
  def visit_rescue_node(node); end

  # Compile a RestParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#692
  def visit_rest_parameter_node(node); end

  # Compile a RetryNode node
  #
  # source://prism//lib/prism/compiler.rb#697
  def visit_retry_node(node); end

  # Compile a ReturnNode node
  #
  # source://prism//lib/prism/compiler.rb#702
  def visit_return_node(node); end

  # Compile a SelfNode node
  #
  # source://prism//lib/prism/compiler.rb#707
  def visit_self_node(node); end

  # Compile a ShareableConstantNode node
  #
  # source://prism//lib/prism/compiler.rb#712
  def visit_shareable_constant_node(node); end

  # Compile a SingletonClassNode node
  #
  # source://prism//lib/prism/compiler.rb#717
  def visit_singleton_class_node(node); end

  # Compile a SourceEncodingNode node
  #
  # source://prism//lib/prism/compiler.rb#722
  def visit_source_encoding_node(node); end

  # Compile a SourceFileNode node
  #
  # source://prism//lib/prism/compiler.rb#727
  def visit_source_file_node(node); end

  # Compile a SourceLineNode node
  #
  # source://prism//lib/prism/compiler.rb#732
  def visit_source_line_node(node); end

  # Compile a SplatNode node
  #
  # source://prism//lib/prism/compiler.rb#737
  def visit_splat_node(node); end

  # Compile a StatementsNode node
  #
  # source://prism//lib/prism/compiler.rb#742
  def visit_statements_node(node); end

  # Compile a StringNode node
  #
  # source://prism//lib/prism/compiler.rb#747
  def visit_string_node(node); end

  # Compile a SuperNode node
  #
  # source://prism//lib/prism/compiler.rb#752
  def visit_super_node(node); end

  # Compile a SymbolNode node
  #
  # source://prism//lib/prism/compiler.rb#757
  def visit_symbol_node(node); end

  # Compile a TrueNode node
  #
  # source://prism//lib/prism/compiler.rb#762
  def visit_true_node(node); end

  # Compile a UndefNode node
  #
  # source://prism//lib/prism/compiler.rb#767
  def visit_undef_node(node); end

  # Compile a UnlessNode node
  #
  # source://prism//lib/prism/compiler.rb#772
  def visit_unless_node(node); end

  # Compile a UntilNode node
  #
  # source://prism//lib/prism/compiler.rb#777
  def visit_until_node(node); end

  # Compile a WhenNode node
  #
  # source://prism//lib/prism/compiler.rb#782
  def visit_when_node(node); end

  # Compile a WhileNode node
  #
  # source://prism//lib/prism/compiler.rb#787
  def visit_while_node(node); end

  # Compile a XStringNode node
  #
  # source://prism//lib/prism/compiler.rb#792
  def visit_x_string_node(node); end

  # Compile a YieldNode node
  #
  # source://prism//lib/prism/compiler.rb#797
  def visit_yield_node(node); end
end

# Represents the use of the `&&=` operator for assignment to a constant.
#
#     Target &&= value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4927
class Prism::ConstantAndWriteNode < ::Prism::Node
  # Initialize a new ConstantAndWriteNode node.
  #
  # @return [ConstantAndWriteNode] a new instance of ConstantAndWriteNode
  #
  # source://prism//lib/prism/node.rb#4929
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5034
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4941
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#4946
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4963
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4958
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> ConstantAndWriteNode
  #
  # source://prism//lib/prism/node.rb#4968
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantAndWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#4973
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#4976
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#183
  def desugar; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#4951
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#5018
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#4981
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#4984
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#5013
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#4997
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#4992
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#5005
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#5023
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#5010
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5028
    def type; end
  end
end

# Represents assigning to a constant using an operator that isn't `=`.
#
#     Target += value
#     ^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#5047
class Prism::ConstantOperatorWriteNode < ::Prism::Node
  # Initialize a new ConstantOperatorWriteNode node.
  #
  # @return [ConstantOperatorWriteNode] a new instance of ConstantOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#5049
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, binary_operator_loc, value, binary_operator); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5153
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5062
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader binary_operator: Symbol
  #
  # source://prism//lib/prism/node.rb#5134
  sig { returns(Symbol) }
  def binary_operator; end

  # attr_reader binary_operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#5118
  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#5067
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5084
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5079
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?binary_operator_loc: Location, ?value: Prism::node, ?binary_operator: Symbol) -> ConstantOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#5089
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::ConstantOperatorWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#5094
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, binary_operator_loc: Location, value: Prism::node, binary_operator: Symbol }
  #
  # source://prism//lib/prism/node.rb#5097
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#195
  def desugar; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#5072
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#5137
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#5102
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#5105
  sig { returns(Prism::Location) }
  def name_loc; end

  # Returns the binary operator used to modify the receiver. This method is
  # deprecated in favor of #binary_operator.
  #
  # source://prism//lib/prism/node_ext.rb#374
  def operator; end

  # Returns the location of the binary operator used to modify the receiver.
  # This method is deprecated in favor of #binary_operator_loc.
  #
  # source://prism//lib/prism/node_ext.rb#381
  def operator_loc; end

  # Save the binary_operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#5126
  def save_binary_operator_loc(repository); end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#5113
  def save_name_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#5142
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#5131
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5147
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to a constant.
#
#     Target ||= value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#5167
class Prism::ConstantOrWriteNode < ::Prism::Node
  # Initialize a new ConstantOrWriteNode node.
  #
  # @return [ConstantOrWriteNode] a new instance of ConstantOrWriteNode
  #
  # source://prism//lib/prism/node.rb#5169
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5274
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5181
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#5186
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5203
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5198
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> ConstantOrWriteNode
  #
  # source://prism//lib/prism/node.rb#5208
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantOrWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#5213
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#5216
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#189
  def desugar; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#5191
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#5258
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#5221
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#5224
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#5253
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#5237
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#5232
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#5245
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#5263
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#5250
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5268
    def type; end
  end
end

# Represents the use of the `&&=` operator for assignment to a constant path.
#
#     Parent::Child &&= value
#     ^^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#5287
class Prism::ConstantPathAndWriteNode < ::Prism::Node
  # Initialize a new ConstantPathAndWriteNode node.
  #
  # @return [ConstantPathAndWriteNode] a new instance of ConstantPathAndWriteNode
  #
  # source://prism//lib/prism/node.rb#5289
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, target, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5381
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5300
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#5305
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5323
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5318
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?target: ConstantPathNode, ?operator_loc: Location, ?value: Prism::node) -> ConstantPathAndWriteNode
  #
  # source://prism//lib/prism/node.rb#5328
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantPathAndWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), target: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#5333
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, target: ConstantPathNode, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#5336
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [target]
  #
  # source://prism//lib/prism/node.rb#5310
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#5365
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#5360
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#5344
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#5352
  def save_operator_loc(repository); end

  # attr_reader target: ConstantPathNode
  #
  # source://prism//lib/prism/node.rb#5341
  sig { returns(Prism::ConstantPathNode) }
  def target; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#5370
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#5357
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5375
    def type; end
  end
end

# Represents accessing a constant through a path of `::` operators.
#
#     Foo::Bar
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#5393
class Prism::ConstantPathNode < ::Prism::Node
  # Initialize a new ConstantPathNode node.
  #
  # @return [ConstantPathNode] a new instance of ConstantPathNode
  #
  # source://prism//lib/prism/node.rb#5395
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parent: T.nilable(Prism::Node),
      name: T.nilable(Symbol),
      delimiter_loc: Prism::Location,
      name_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, parent, name, delimiter_loc, name_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5523
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5407
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # Previously, we had a child node on this class that contained either a
  # constant read or a missing node. To not cause a breaking change, we
  # continue to supply that API.
  #
  # source://prism//lib/prism/node_ext.rb#205
  def child; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#5412
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5431
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5424
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?parent: Prism::node?, ?name: Symbol?, ?delimiter_loc: Location, ?name_loc: Location) -> ConstantPathNode
  #
  # source://prism//lib/prism/node.rb#5436
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parent: T.nilable(Prism::Node),
      name: T.nilable(Symbol),
      delimiter_loc: Prism::Location,
      name_loc: Prism::Location
    ).returns(Prism::ConstantPathNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), parent: T.unsafe(nil), name: T.unsafe(nil), delimiter_loc: T.unsafe(nil), name_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#5441
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, parent: Prism::node?, name: Symbol?, delimiter_loc: Location, name_loc: Location }
  #
  # source://prism//lib/prism/node.rb#5444
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def delimiter: () -> String
  #
  # source://prism//lib/prism/node.rb#5502
  sig { returns(String) }
  def delimiter; end

  # The location of the `::` delimiter.
  #
  #     ::Foo
  #     ^^
  #
  #     One::Two
  #        ^^
  #
  # source://prism//lib/prism/node.rb#5470
  sig { returns(Prism::Location) }
  def delimiter_loc; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [parent]
  #
  # source://prism//lib/prism/node.rb#5417
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # Returns the full name of this constant path. For example: "Foo::Bar"
  #
  # source://prism//lib/prism/node_ext.rb#198
  sig { returns(String) }
  def full_name; end

  # Returns the list of parts for the full name of this constant path.
  # For example: [:Foo, :Bar]
  #
  # source://prism//lib/prism/node_ext.rb#176
  sig { returns(T::Array[Symbol]) }
  def full_name_parts; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#5507
  sig { override.returns(String) }
  def inspect; end

  # The name of the constant being accessed. This could be `nil` in the event of a syntax error.
  #
  # source://prism//lib/prism/node.rb#5461
  sig { returns(T.nilable(Symbol)) }
  def name; end

  # The location of the name of the constant.
  #
  #     ::Foo
  #       ^^^
  #
  #     One::Two
  #          ^^^
  #
  # source://prism//lib/prism/node.rb#5489
  sig { returns(Prism::Location) }
  def name_loc; end

  # The left-hand node of the path, if present. It can be `nil` or any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression). It will be `nil` when the constant lookup is at the root of the module tree.
  #
  #     Foo::Bar
  #     ^^^
  #
  #     self::Test
  #     ^^^^
  #
  #     a.b::C
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#5458
  sig { returns(T.nilable(Prism::Node)) }
  def parent; end

  # Save the delimiter_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#5478
  def save_delimiter_loc(repository); end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#5497
  def save_name_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#5512
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5517
    def type; end
  end
end

# An error class raised when dynamic parts are found while computing a
# constant path's full name. For example:
# Foo::Bar::Baz -> does not raise because all parts of the constant path are
# simple constants
# var::Bar::Baz -> raises because the first part of the constant path is a
# local variable
#
# source://prism//lib/prism/node_ext.rb#167
class Prism::ConstantPathNode::DynamicPartsInConstantPathError < ::StandardError; end

# An error class raised when missing nodes are found while computing a
# constant path's full name. For example:
# Foo:: -> raises because the constant path is missing the last part
#
# source://prism//lib/prism/node_ext.rb#172
class Prism::ConstantPathNode::MissingNodesInConstantPathError < ::StandardError; end

# Represents assigning to a constant path using an operator that isn't `=`.
#
#     Parent::Child += value
#     ^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#5536
class Prism::ConstantPathOperatorWriteNode < ::Prism::Node
  # Initialize a new ConstantPathOperatorWriteNode node.
  #
  # @return [ConstantPathOperatorWriteNode] a new instance of ConstantPathOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#5538
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).void
  end
  def initialize(source, node_id, location, flags, target, binary_operator_loc, value, binary_operator); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5629
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5550
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader binary_operator: Symbol
  #
  # source://prism//lib/prism/node.rb#5610
  sig { returns(Symbol) }
  def binary_operator; end

  # attr_reader binary_operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#5594
  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#5555
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5573
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5568
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?target: ConstantPathNode, ?binary_operator_loc: Location, ?value: Prism::node, ?binary_operator: Symbol) -> ConstantPathOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#5578
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::ConstantPathOperatorWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), target: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#5583
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, target: ConstantPathNode, binary_operator_loc: Location, value: Prism::node, binary_operator: Symbol }
  #
  # source://prism//lib/prism/node.rb#5586
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [target]
  #
  # source://prism//lib/prism/node.rb#5560
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#5613
  sig { override.returns(String) }
  def inspect; end

  # Returns the binary operator used to modify the receiver. This method is
  # deprecated in favor of #binary_operator.
  #
  # source://prism//lib/prism/node_ext.rb#390
  def operator; end

  # Returns the location of the binary operator used to modify the receiver.
  # This method is deprecated in favor of #binary_operator_loc.
  #
  # source://prism//lib/prism/node_ext.rb#397
  def operator_loc; end

  # Save the binary_operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#5602
  def save_binary_operator_loc(repository); end

  # attr_reader target: ConstantPathNode
  #
  # source://prism//lib/prism/node.rb#5591
  sig { returns(Prism::ConstantPathNode) }
  def target; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#5618
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#5607
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5623
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to a constant path.
#
#     Parent::Child ||= value
#     ^^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#5642
class Prism::ConstantPathOrWriteNode < ::Prism::Node
  # Initialize a new ConstantPathOrWriteNode node.
  #
  # @return [ConstantPathOrWriteNode] a new instance of ConstantPathOrWriteNode
  #
  # source://prism//lib/prism/node.rb#5644
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, target, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5736
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5655
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#5660
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5678
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5673
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?target: ConstantPathNode, ?operator_loc: Location, ?value: Prism::node) -> ConstantPathOrWriteNode
  #
  # source://prism//lib/prism/node.rb#5683
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantPathOrWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), target: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#5688
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, target: ConstantPathNode, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#5691
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [target]
  #
  # source://prism//lib/prism/node.rb#5665
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#5720
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#5715
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#5699
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#5707
  def save_operator_loc(repository); end

  # attr_reader target: ConstantPathNode
  #
  # source://prism//lib/prism/node.rb#5696
  sig { returns(Prism::ConstantPathNode) }
  def target; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#5725
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#5712
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5730
    def type; end
  end
end

# Represents writing to a constant path in a context that doesn't have an explicit value.
#
#     Foo::Foo, Bar::Bar = baz
#     ^^^^^^^^  ^^^^^^^^
#
# source://prism//lib/prism/node.rb#5748
class Prism::ConstantPathTargetNode < ::Prism::Node
  # Initialize a new ConstantPathTargetNode node.
  #
  # @return [ConstantPathTargetNode] a new instance of ConstantPathTargetNode
  #
  # source://prism//lib/prism/node.rb#5750
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parent: T.nilable(Prism::Node),
      name: T.nilable(Symbol),
      delimiter_loc: Prism::Location,
      name_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, parent, name, delimiter_loc, name_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5857
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5762
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # Previously, we had a child node on this class that contained either a
  # constant read or a missing node. To not cause a breaking change, we
  # continue to supply that API.
  #
  # source://prism//lib/prism/node_ext.rb#246
  def child; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#5767
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5786
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5779
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?parent: Prism::node?, ?name: Symbol?, ?delimiter_loc: Location, ?name_loc: Location) -> ConstantPathTargetNode
  #
  # source://prism//lib/prism/node.rb#5791
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parent: T.nilable(Prism::Node),
      name: T.nilable(Symbol),
      delimiter_loc: Prism::Location,
      name_loc: Prism::Location
    ).returns(Prism::ConstantPathTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), parent: T.unsafe(nil), name: T.unsafe(nil), delimiter_loc: T.unsafe(nil), name_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#5796
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, parent: Prism::node?, name: Symbol?, delimiter_loc: Location, name_loc: Location }
  #
  # source://prism//lib/prism/node.rb#5799
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def delimiter: () -> String
  #
  # source://prism//lib/prism/node.rb#5836
  sig { returns(String) }
  def delimiter; end

  # attr_reader delimiter_loc: Location
  #
  # source://prism//lib/prism/node.rb#5810
  sig { returns(Prism::Location) }
  def delimiter_loc; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [parent]
  #
  # source://prism//lib/prism/node.rb#5772
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # Returns the full name of this constant path. For example: "Foo::Bar"
  #
  # source://prism//lib/prism/node_ext.rb#239
  sig { returns(String) }
  def full_name; end

  # Returns the list of parts for the full name of this constant path.
  # For example: [:Foo, :Bar]
  #
  # source://prism//lib/prism/node_ext.rb#219
  sig { returns(T::Array[Symbol]) }
  def full_name_parts; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#5841
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol?
  #
  # source://prism//lib/prism/node.rb#5807
  sig { returns(T.nilable(Symbol)) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#5823
  sig { returns(Prism::Location) }
  def name_loc; end

  # attr_reader parent: Prism::node?
  #
  # source://prism//lib/prism/node.rb#5804
  sig { returns(T.nilable(Prism::Node)) }
  def parent; end

  # Save the delimiter_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#5818
  def save_delimiter_loc(repository); end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#5831
  def save_name_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#5846
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5851
    def type; end
  end
end

# Represents writing to a constant path.
#
#     ::Foo = 1
#     ^^^^^^^^^
#
#     Foo::Bar = 1
#     ^^^^^^^^^^^^
#
#     ::Foo::Bar = 1
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#5876
class Prism::ConstantPathWriteNode < ::Prism::Node
  # Initialize a new ConstantPathWriteNode node.
  #
  # @return [ConstantPathWriteNode] a new instance of ConstantPathWriteNode
  #
  # source://prism//lib/prism/node.rb#5878
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, target, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5982
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5889
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#5894
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5912
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5907
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?target: ConstantPathNode, ?operator_loc: Location, ?value: Prism::node) -> ConstantPathWriteNode
  #
  # source://prism//lib/prism/node.rb#5917
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantPathWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), target: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#5922
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, target: ConstantPathNode, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#5925
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [target]
  #
  # source://prism//lib/prism/node.rb#5899
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#5966
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#5961
  sig { returns(String) }
  def operator; end

  # The location of the `=` operator.
  #
  #     ::ABC = 123
  #           ^
  #
  # source://prism//lib/prism/node.rb#5942
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#5950
  def save_operator_loc(repository); end

  # A node representing the constant path being written to.
  #
  #     Foo::Bar = 1
  #     ^^^^^^^^
  #
  #     ::Foo = :abc
  #     ^^^^^
  #
  # source://prism//lib/prism/node.rb#5936
  sig { returns(Prism::ConstantPathNode) }
  def target; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#5971
  sig { override.returns(Symbol) }
  def type; end

  # The value to write to the constant path. It can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     FOO::BAR = :abc
  #                ^^^^
  #
  # source://prism//lib/prism/node.rb#5958
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5976
    def type; end
  end
end

# Represents referencing a constant.
#
#     Foo
#     ^^^
#
# source://prism//lib/prism/node.rb#5994
class Prism::ConstantReadNode < ::Prism::Node
  # Initialize a new ConstantReadNode node.
  #
  # @return [ConstantReadNode] a new instance of ConstantReadNode
  #
  # source://prism//lib/prism/node.rb#5996
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#6067
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6005
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#6010
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6026
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6021
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> ConstantReadNode
  #
  # source://prism//lib/prism/node.rb#6031
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::ConstantReadNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#6036
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#6039
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#6015
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # Returns the full name of this constant. For example: "Foo"
  #
  # source://prism//lib/prism/node_ext.rb#142
  sig { returns(String) }
  def full_name; end

  # Returns the list of parts for the full name of this constant.
  # For example: [:Foo]
  #
  # source://prism//lib/prism/node_ext.rb#137
  sig { returns(T::Array[Symbol]) }
  def full_name_parts; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#6051
  sig { override.returns(String) }
  def inspect; end

  # The name of the [constant](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#constants).
  #
  #     X              # name `:X`
  #
  #     SOME_CONSTANT  # name `:SOME_CONSTANT`
  #
  # source://prism//lib/prism/node.rb#6048
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#6056
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#6061
    def type; end
  end
end

# Represents writing to a constant in a context that doesn't have an explicit value.
#
#     Foo, Bar = baz
#     ^^^  ^^^
#
# source://prism//lib/prism/node.rb#6077
class Prism::ConstantTargetNode < ::Prism::Node
  # Initialize a new ConstantTargetNode node.
  #
  # @return [ConstantTargetNode] a new instance of ConstantTargetNode
  #
  # source://prism//lib/prism/node.rb#6079
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#6146
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6088
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#6093
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6109
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6104
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> ConstantTargetNode
  #
  # source://prism//lib/prism/node.rb#6114
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::ConstantTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#6119
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#6122
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#6098
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # Returns the full name of this constant. For example: "Foo"
  #
  # source://prism//lib/prism/node_ext.rb#265
  sig { returns(String) }
  def full_name; end

  # Returns the list of parts for the full name of this constant.
  # For example: [:Foo]
  #
  # source://prism//lib/prism/node_ext.rb#260
  sig { returns(T::Array[Symbol]) }
  def full_name_parts; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#6130
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#6127
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#6135
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#6140
    def type; end
  end
end

# Represents writing to a constant.
#
#     Foo = 1
#     ^^^^^^^
#
# source://prism//lib/prism/node.rb#6156
class Prism::ConstantWriteNode < ::Prism::Node
  # Initialize a new ConstantWriteNode node.
  #
  # @return [ConstantWriteNode] a new instance of ConstantWriteNode
  #
  # source://prism//lib/prism/node.rb#6158
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, value, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#6279
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6170
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#6175
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6192
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6187
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?value: Prism::node, ?operator_loc: Location) -> ConstantWriteNode
  #
  # source://prism//lib/prism/node.rb#6197
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::ConstantWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#6202
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, value: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#6205
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#6180
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # Returns the full name of this constant. For example: "Foo"
  #
  # source://prism//lib/prism/node_ext.rb#155
  sig { returns(String) }
  def full_name; end

  # Returns the list of parts for the full name of this constant.
  # For example: [:Foo]
  #
  # source://prism//lib/prism/node_ext.rb#150
  sig { returns(T::Array[Symbol]) }
  def full_name_parts; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#6263
  sig { override.returns(String) }
  def inspect; end

  # The name of the [constant](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#constants).
  #
  #     Foo = :bar # name `:Foo`
  #
  #     XYZ = 1    # name `:XYZ`
  #
  # source://prism//lib/prism/node.rb#6214
  sig { returns(Symbol) }
  def name; end

  # The location of the constant name.
  #
  #     FOO = 1
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#6220
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#6258
  sig { returns(String) }
  def operator; end

  # The location of the `=` operator.
  #
  #     FOO = :bar
  #         ^
  #
  # source://prism//lib/prism/node.rb#6245
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#6228
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#6253
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#6268
  sig { override.returns(Symbol) }
  def type; end

  # The value to write to the constant. It can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     FOO = :bar
  #           ^^^^
  #
  #     MyClass = Class.new
  #               ^^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#6239
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#6273
    def type; end
  end
end

# Raised when requested to parse as the currently running Ruby version but Prism has no support for it.
#
# source://prism//lib/prism.rb#39
class Prism::CurrentVersionError < ::ArgumentError
  # Initialize a new exception for the given ruby version string.
  #
  # @return [CurrentVersionError] a new instance of CurrentVersionError
  #
  # source://prism//lib/prism.rb#41
  def initialize(version); end
end

# The DSL module provides a set of methods that can be used to create prism
# nodes in a more concise manner. For example, instead of writing:
#
#     source = Prism::Source.for("[1]")
#
#     Prism::ArrayNode.new(
#       source,
#       0,
#       Prism::Location.new(source, 0, 3),
#       0,
#       [
#         Prism::IntegerNode.new(
#           source,
#           0,
#           Prism::Location.new(source, 1, 1),
#           Prism::IntegerBaseFlags::DECIMAL,
#           1
#         )
#       ],
#       Prism::Location.new(source, 0, 1),
#       Prism::Location.new(source, 2, 1)
#     )
#
# you could instead write:
#
#     class Builder
#       include Prism::DSL
#
#       attr_reader :default_source
#
#       def initialize
#         @default_source = source("[1]")
#       end
#
#       def build
#         array_node(
#           location: location(start_offset: 0, length: 3),
#           elements: [
#             integer_node(
#               location: location(start_offset: 1, length: 1),
#               flags: integer_base_flag(:decimal),
#               value: 1
#             )
#           ],
#           opening_loc: location(start_offset: 0, length: 1),
#           closing_loc: location(start_offset: 2, length: 1)
#         )
#       end
#     end
#
# This is mostly helpful in the context of generating trees programmatically.
#
# source://prism//lib/prism/dsl.rb#64
module Prism::DSL
  extend ::Prism::DSL

  # Create a new AliasGlobalVariableNode node.
  #
  # source://prism//lib/prism/dsl.rb#80
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      new_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode),
      old_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::SymbolNode, Prism::MissingNode),
      keyword_loc: Prism::Location
    ).returns(Prism::AliasGlobalVariableNode)
  end
  def alias_global_variable_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), new_name: T.unsafe(nil), old_name: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # Create a new AliasMethodNode node.
  #
  # source://prism//lib/prism/dsl.rb#85
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      new_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode),
      old_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode, Prism::GlobalVariableReadNode, Prism::MissingNode),
      keyword_loc: Prism::Location
    ).returns(Prism::AliasMethodNode)
  end
  def alias_method_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), new_name: T.unsafe(nil), old_name: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # Create a new AlternationPatternNode node.
  #
  # source://prism//lib/prism/dsl.rb#90
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::AlternationPatternNode)
  end
  def alternation_pattern_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new AndNode node.
  #
  # source://prism//lib/prism/dsl.rb#95
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::AndNode)
  end
  def and_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new ArgumentsNode node.
  #
  # source://prism//lib/prism/dsl.rb#100
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T::Array[Prism::Node]
    ).returns(Prism::ArgumentsNode)
  end
  def arguments_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), arguments: T.unsafe(nil)); end

  # Retrieve the value of one of the ArgumentsNodeFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#835
  sig { params(name: Symbol).returns(Integer) }
  def arguments_node_flag(name); end

  # Create a new ArrayNode node.
  #
  # source://prism//lib/prism/dsl.rb#105
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      elements: T::Array[Prism::Node],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::ArrayNode)
  end
  def array_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), elements: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Retrieve the value of one of the ArrayNodeFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#847
  sig { params(name: Symbol).returns(Integer) }
  def array_node_flag(name); end

  # Create a new ArrayPatternNode node.
  #
  # source://prism//lib/prism/dsl.rb#110
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantPathNode, Prism::ConstantReadNode)),
      requireds: T::Array[Prism::Node],
      rest: T.nilable(Prism::Node),
      posts: T::Array[Prism::Node],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::ArrayPatternNode)
  end
  def array_pattern_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), constant: T.unsafe(nil), requireds: T.unsafe(nil), rest: T.unsafe(nil), posts: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new AssocNode node.
  #
  # source://prism//lib/prism/dsl.rb#115
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      key: Prism::Node,
      value: Prism::Node,
      operator_loc: T.nilable(Prism::Location)
    ).returns(Prism::AssocNode)
  end
  def assoc_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), key: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new AssocSplatNode node.
  #
  # source://prism//lib/prism/dsl.rb#120
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).returns(Prism::AssocSplatNode)
  end
  def assoc_splat_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new BackReferenceReadNode node.
  #
  # source://prism//lib/prism/dsl.rb#125
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::BackReferenceReadNode)
  end
  def back_reference_read_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new BeginNode node.
  #
  # source://prism//lib/prism/dsl.rb#130
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      begin_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      rescue_clause: T.nilable(Prism::RescueNode),
      else_clause: T.nilable(Prism::ElseNode),
      ensure_clause: T.nilable(Prism::EnsureNode),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::BeginNode)
  end
  def begin_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), begin_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), rescue_clause: T.unsafe(nil), else_clause: T.unsafe(nil), ensure_clause: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new BlockArgumentNode node.
  #
  # source://prism//lib/prism/dsl.rb#135
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      expression: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).returns(Prism::BlockArgumentNode)
  end
  def block_argument_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), expression: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new BlockLocalVariableNode node.
  #
  # source://prism//lib/prism/dsl.rb#140
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::BlockLocalVariableNode)
  end
  def block_local_variable_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new BlockNode node.
  #
  # source://prism//lib/prism/dsl.rb#145
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).returns(Prism::BlockNode)
  end
  def block_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), parameters: T.unsafe(nil), body: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new BlockParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#150
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location
    ).returns(Prism::BlockParameterNode)
  end
  def block_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new BlockParametersNode node.
  #
  # source://prism//lib/prism/dsl.rb#155
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parameters: T.nilable(Prism::ParametersNode),
      locals: T::Array[Prism::BlockLocalVariableNode],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::BlockParametersNode)
  end
  def block_parameters_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), parameters: T.unsafe(nil), locals: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new BreakNode node.
  #
  # source://prism//lib/prism/dsl.rb#160
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T.nilable(Prism::ArgumentsNode),
      keyword_loc: Prism::Location
    ).returns(Prism::BreakNode)
  end
  def break_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), arguments: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # Create a new CallAndWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#165
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::CallAndWriteNode)
  end
  def call_and_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), message_loc: T.unsafe(nil), read_name: T.unsafe(nil), write_name: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new CallNode node.
  #
  # source://prism//lib/prism/dsl.rb#170
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      name: Symbol,
      message_loc: T.nilable(Prism::Location),
      opening_loc: T.nilable(Prism::Location),
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: T.nilable(Prism::Location),
      equal_loc: T.nilable(Prism::Location),
      block: T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))
    ).returns(Prism::CallNode)
  end
  def call_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), name: T.unsafe(nil), message_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), equal_loc: T.unsafe(nil), block: T.unsafe(nil)); end

  # Retrieve the value of one of the CallNodeFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#855
  sig { params(name: Symbol).returns(Integer) }
  def call_node_flag(name); end

  # Create a new CallOperatorWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#175
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      binary_operator: Symbol,
      binary_operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::CallOperatorWriteNode)
  end
  def call_operator_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), message_loc: T.unsafe(nil), read_name: T.unsafe(nil), write_name: T.unsafe(nil), binary_operator: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new CallOrWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#180
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::CallOrWriteNode)
  end
  def call_or_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), message_loc: T.unsafe(nil), read_name: T.unsafe(nil), write_name: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new CallTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#185
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: Prism::Node,
      call_operator_loc: Prism::Location,
      name: Symbol,
      message_loc: Prism::Location
    ).returns(Prism::CallTargetNode)
  end
  def call_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), name: T.unsafe(nil), message_loc: T.unsafe(nil)); end

  # Create a new CapturePatternNode node.
  #
  # source://prism//lib/prism/dsl.rb#190
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      target: Prism::LocalVariableTargetNode,
      operator_loc: Prism::Location
    ).returns(Prism::CapturePatternNode)
  end
  def capture_pattern_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil), target: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new CaseMatchNode node.
  #
  # source://prism//lib/prism/dsl.rb#195
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      predicate: T.nilable(Prism::Node),
      conditions: T::Array[Prism::InNode],
      else_clause: T.nilable(Prism::ElseNode),
      case_keyword_loc: Prism::Location,
      end_keyword_loc: Prism::Location
    ).returns(Prism::CaseMatchNode)
  end
  def case_match_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), predicate: T.unsafe(nil), conditions: T.unsafe(nil), else_clause: T.unsafe(nil), case_keyword_loc: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new CaseNode node.
  #
  # source://prism//lib/prism/dsl.rb#200
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      predicate: T.nilable(Prism::Node),
      conditions: T::Array[Prism::WhenNode],
      else_clause: T.nilable(Prism::ElseNode),
      case_keyword_loc: Prism::Location,
      end_keyword_loc: Prism::Location
    ).returns(Prism::CaseNode)
  end
  def case_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), predicate: T.unsafe(nil), conditions: T.unsafe(nil), else_clause: T.unsafe(nil), case_keyword_loc: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new ClassNode node.
  #
  # source://prism//lib/prism/dsl.rb#205
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      class_keyword_loc: Prism::Location,
      constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::CallNode),
      inheritance_operator_loc: T.nilable(Prism::Location),
      superclass: T.nilable(Prism::Node),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      end_keyword_loc: Prism::Location,
      name: Symbol
    ).returns(Prism::ClassNode)
  end
  def class_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), class_keyword_loc: T.unsafe(nil), constant_path: T.unsafe(nil), inheritance_operator_loc: T.unsafe(nil), superclass: T.unsafe(nil), body: T.unsafe(nil), end_keyword_loc: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new ClassVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#210
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ClassVariableAndWriteNode)
  end
  def class_variable_and_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ClassVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#215
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::ClassVariableOperatorWriteNode)
  end
  def class_variable_operator_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # Create a new ClassVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#220
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ClassVariableOrWriteNode)
  end
  def class_variable_or_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ClassVariableReadNode node.
  #
  # source://prism//lib/prism/dsl.rb#225
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::ClassVariableReadNode)
  end
  def class_variable_read_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new ClassVariableTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#230
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::ClassVariableTargetNode)
  end
  def class_variable_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new ClassVariableWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#235
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::ClassVariableWriteNode)
  end
  def class_variable_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new ConstantAndWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#240
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantAndWriteNode)
  end
  def constant_and_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ConstantOperatorWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#245
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::ConstantOperatorWriteNode)
  end
  def constant_operator_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # Create a new ConstantOrWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#250
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantOrWriteNode)
  end
  def constant_or_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ConstantPathAndWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#255
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantPathAndWriteNode)
  end
  def constant_path_and_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), target: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ConstantPathNode node.
  #
  # source://prism//lib/prism/dsl.rb#260
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parent: T.nilable(Prism::Node),
      name: T.nilable(Symbol),
      delimiter_loc: Prism::Location,
      name_loc: Prism::Location
    ).returns(Prism::ConstantPathNode)
  end
  def constant_path_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), parent: T.unsafe(nil), name: T.unsafe(nil), delimiter_loc: T.unsafe(nil), name_loc: T.unsafe(nil)); end

  # Create a new ConstantPathOperatorWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#265
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::ConstantPathOperatorWriteNode)
  end
  def constant_path_operator_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), target: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # Create a new ConstantPathOrWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#270
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantPathOrWriteNode)
  end
  def constant_path_or_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), target: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ConstantPathTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#275
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parent: T.nilable(Prism::Node),
      name: T.nilable(Symbol),
      delimiter_loc: Prism::Location,
      name_loc: Prism::Location
    ).returns(Prism::ConstantPathTargetNode)
  end
  def constant_path_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), parent: T.unsafe(nil), name: T.unsafe(nil), delimiter_loc: T.unsafe(nil), name_loc: T.unsafe(nil)); end

  # Create a new ConstantPathWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#280
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantPathWriteNode)
  end
  def constant_path_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), target: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ConstantReadNode node.
  #
  # source://prism//lib/prism/dsl.rb#285
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::ConstantReadNode)
  end
  def constant_read_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new ConstantTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#290
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::ConstantTargetNode)
  end
  def constant_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new ConstantWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#295
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::ConstantWriteNode)
  end
  def constant_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new DefNode node.
  #
  # source://prism//lib/prism/dsl.rb#300
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      receiver: T.nilable(Prism::Node),
      parameters: T.nilable(Prism::ParametersNode),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      locals: T::Array[Symbol],
      def_keyword_loc: Prism::Location,
      operator_loc: T.nilable(Prism::Location),
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location),
      equal_loc: T.nilable(Prism::Location),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::DefNode)
  end
  def def_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), receiver: T.unsafe(nil), parameters: T.unsafe(nil), body: T.unsafe(nil), locals: T.unsafe(nil), def_keyword_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), lparen_loc: T.unsafe(nil), rparen_loc: T.unsafe(nil), equal_loc: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new DefinedNode node.
  #
  # source://prism//lib/prism/dsl.rb#305
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lparen_loc: T.nilable(Prism::Location),
      value: Prism::Node,
      rparen_loc: T.nilable(Prism::Location),
      keyword_loc: Prism::Location
    ).returns(Prism::DefinedNode)
  end
  def defined_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), lparen_loc: T.unsafe(nil), value: T.unsafe(nil), rparen_loc: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # Create a new ElseNode node.
  #
  # source://prism//lib/prism/dsl.rb#310
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      else_keyword_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::ElseNode)
  end
  def else_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), else_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new EmbeddedStatementsNode node.
  #
  # source://prism//lib/prism/dsl.rb#315
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      closing_loc: Prism::Location
    ).returns(Prism::EmbeddedStatementsNode)
  end
  def embedded_statements_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), statements: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new EmbeddedVariableNode node.
  #
  # source://prism//lib/prism/dsl.rb#320
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      operator_loc: Prism::Location,
      variable: T.any(Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)
    ).returns(Prism::EmbeddedVariableNode)
  end
  def embedded_variable_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), operator_loc: T.unsafe(nil), variable: T.unsafe(nil)); end

  # Retrieve the value of one of the EncodingFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#866
  sig { params(name: Symbol).returns(Integer) }
  def encoding_flag(name); end

  # Create a new EnsureNode node.
  #
  # source://prism//lib/prism/dsl.rb#325
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      ensure_keyword_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      end_keyword_loc: Prism::Location
    ).returns(Prism::EnsureNode)
  end
  def ensure_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), ensure_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new FalseNode node.
  #
  # source://prism//lib/prism/dsl.rb#330
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::FalseNode)
  end
  def false_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new FindPatternNode node.
  #
  # source://prism//lib/prism/dsl.rb#335
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantPathNode, Prism::ConstantReadNode)),
      left: Prism::SplatNode,
      requireds: T::Array[Prism::Node],
      right: T.any(Prism::SplatNode, Prism::MissingNode),
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::FindPatternNode)
  end
  def find_pattern_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), constant: T.unsafe(nil), left: T.unsafe(nil), requireds: T.unsafe(nil), right: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new FlipFlopNode node.
  #
  # source://prism//lib/prism/dsl.rb#340
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: T.nilable(Prism::Node),
      right: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).returns(Prism::FlipFlopNode)
  end
  def flip_flop_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new FloatNode node.
  #
  # source://prism//lib/prism/dsl.rb#345
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Float
    ).returns(Prism::FloatNode)
  end
  def float_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ForNode node.
  #
  # source://prism//lib/prism/dsl.rb#350
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      index: T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode),
      collection: Prism::Node,
      statements: T.nilable(Prism::StatementsNode),
      for_keyword_loc: Prism::Location,
      in_keyword_loc: Prism::Location,
      do_keyword_loc: T.nilable(Prism::Location),
      end_keyword_loc: Prism::Location
    ).returns(Prism::ForNode)
  end
  def for_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), index: T.unsafe(nil), collection: T.unsafe(nil), statements: T.unsafe(nil), for_keyword_loc: T.unsafe(nil), in_keyword_loc: T.unsafe(nil), do_keyword_loc: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new ForwardingArgumentsNode node.
  #
  # source://prism//lib/prism/dsl.rb#355
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::ForwardingArgumentsNode)
  end
  def forwarding_arguments_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new ForwardingParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#360
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::ForwardingParameterNode)
  end
  def forwarding_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new ForwardingSuperNode node.
  #
  # source://prism//lib/prism/dsl.rb#365
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      block: T.nilable(Prism::BlockNode)
    ).returns(Prism::ForwardingSuperNode)
  end
  def forwarding_super_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), block: T.unsafe(nil)); end

  # Create a new GlobalVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#370
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::GlobalVariableAndWriteNode)
  end
  def global_variable_and_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new GlobalVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#375
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::GlobalVariableOperatorWriteNode)
  end
  def global_variable_operator_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # Create a new GlobalVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#380
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::GlobalVariableOrWriteNode)
  end
  def global_variable_or_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new GlobalVariableReadNode node.
  #
  # source://prism//lib/prism/dsl.rb#385
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::GlobalVariableReadNode)
  end
  def global_variable_read_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new GlobalVariableTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#390
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::GlobalVariableTargetNode)
  end
  def global_variable_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new GlobalVariableWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#395
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::GlobalVariableWriteNode)
  end
  def global_variable_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new HashNode node.
  #
  # source://prism//lib/prism/dsl.rb#400
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)],
      closing_loc: Prism::Location
    ).returns(Prism::HashNode)
  end
  def hash_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), elements: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new HashPatternNode node.
  #
  # source://prism//lib/prism/dsl.rb#405
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantPathNode, Prism::ConstantReadNode)),
      elements: T::Array[Prism::AssocNode],
      rest: T.nilable(T.any(Prism::AssocSplatNode, Prism::NoKeywordsParameterNode)),
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::HashPatternNode)
  end
  def hash_pattern_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), constant: T.unsafe(nil), elements: T.unsafe(nil), rest: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new IfNode node.
  #
  # source://prism//lib/prism/dsl.rb#410
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      if_keyword_loc: T.nilable(Prism::Location),
      predicate: Prism::Node,
      then_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      subsequent: T.nilable(T.any(Prism::ElseNode, Prism::IfNode)),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::IfNode)
  end
  def if_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), if_keyword_loc: T.unsafe(nil), predicate: T.unsafe(nil), then_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), subsequent: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new ImaginaryNode node.
  #
  # source://prism//lib/prism/dsl.rb#415
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      numeric: T.any(Prism::FloatNode, Prism::IntegerNode, Prism::RationalNode)
    ).returns(Prism::ImaginaryNode)
  end
  def imaginary_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), numeric: T.unsafe(nil)); end

  # Create a new ImplicitNode node.
  #
  # source://prism//lib/prism/dsl.rb#420
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: T.any(Prism::LocalVariableReadNode, Prism::CallNode, Prism::ConstantReadNode, Prism::LocalVariableTargetNode)
    ).returns(Prism::ImplicitNode)
  end
  def implicit_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ImplicitRestNode node.
  #
  # source://prism//lib/prism/dsl.rb#425
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::ImplicitRestNode)
  end
  def implicit_rest_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new InNode node.
  #
  # source://prism//lib/prism/dsl.rb#430
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      pattern: Prism::Node,
      statements: T.nilable(Prism::StatementsNode),
      in_loc: Prism::Location,
      then_loc: T.nilable(Prism::Location)
    ).returns(Prism::InNode)
  end
  def in_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), pattern: T.unsafe(nil), statements: T.unsafe(nil), in_loc: T.unsafe(nil), then_loc: T.unsafe(nil)); end

  # Create a new IndexAndWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#435
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::IndexAndWriteNode)
  end
  def index_and_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new IndexOperatorWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#440
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      binary_operator: Symbol,
      binary_operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::IndexOperatorWriteNode)
  end
  def index_operator_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil), binary_operator: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new IndexOrWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#445
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::IndexOrWriteNode)
  end
  def index_or_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new IndexTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#450
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: Prism::Node,
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode)
    ).returns(Prism::IndexTargetNode)
  end
  def index_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil)); end

  # Create a new InstanceVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#455
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::InstanceVariableAndWriteNode)
  end
  def instance_variable_and_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new InstanceVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#460
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::InstanceVariableOperatorWriteNode)
  end
  def instance_variable_operator_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # Create a new InstanceVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#465
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::InstanceVariableOrWriteNode)
  end
  def instance_variable_or_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new InstanceVariableReadNode node.
  #
  # source://prism//lib/prism/dsl.rb#470
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::InstanceVariableReadNode)
  end
  def instance_variable_read_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new InstanceVariableTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#475
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::InstanceVariableTargetNode)
  end
  def instance_variable_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new InstanceVariableWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#480
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::InstanceVariableWriteNode)
  end
  def instance_variable_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Retrieve the value of one of the IntegerBaseFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#875
  sig { params(name: Symbol).returns(Integer) }
  def integer_base_flag(name); end

  # Create a new IntegerNode node.
  #
  # source://prism//lib/prism/dsl.rb#485
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Integer
    ).returns(Prism::IntegerNode)
  end
  def integer_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new InterpolatedMatchLastLineNode node.
  #
  # source://prism//lib/prism/dsl.rb#490
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).returns(Prism::InterpolatedMatchLastLineNode)
  end
  def interpolated_match_last_line_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new InterpolatedRegularExpressionNode node.
  #
  # source://prism//lib/prism/dsl.rb#495
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).returns(Prism::InterpolatedRegularExpressionNode)
  end
  def interpolated_regular_expression_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new InterpolatedStringNode node.
  #
  # source://prism//lib/prism/dsl.rb#500
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode, Prism::InterpolatedStringNode, Prism::XStringNode, Prism::InterpolatedXStringNode, Prism::SymbolNode, Prism::InterpolatedSymbolNode)],
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::InterpolatedStringNode)
  end
  def interpolated_string_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Retrieve the value of one of the InterpolatedStringNodeFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#886
  sig { params(name: Symbol).returns(Integer) }
  def interpolated_string_node_flag(name); end

  # Create a new InterpolatedSymbolNode node.
  #
  # source://prism//lib/prism/dsl.rb#505
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::InterpolatedSymbolNode)
  end
  def interpolated_symbol_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new InterpolatedXStringNode node.
  #
  # source://prism//lib/prism/dsl.rb#510
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).returns(Prism::InterpolatedXStringNode)
  end
  def interpolated_x_string_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new ItLocalVariableReadNode node.
  #
  # source://prism//lib/prism/dsl.rb#515
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::ItLocalVariableReadNode)
  end
  def it_local_variable_read_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new ItParametersNode node.
  #
  # source://prism//lib/prism/dsl.rb#520
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::ItParametersNode)
  end
  def it_parameters_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new KeywordHashNode node.
  #
  # source://prism//lib/prism/dsl.rb#525
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)]
    ).returns(Prism::KeywordHashNode)
  end
  def keyword_hash_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), elements: T.unsafe(nil)); end

  # Retrieve the value of one of the KeywordHashNodeFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#895
  sig { params(name: Symbol).returns(Integer) }
  def keyword_hash_node_flag(name); end

  # Create a new KeywordRestParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#530
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location
    ).returns(Prism::KeywordRestParameterNode)
  end
  def keyword_rest_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new LambdaNode node.
  #
  # source://prism//lib/prism/dsl.rb#535
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      operator_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location,
      parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))
    ).returns(Prism::LambdaNode)
  end
  def lambda_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), operator_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), parameters: T.unsafe(nil), body: T.unsafe(nil)); end

  # Create a new LocalVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#540
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableAndWriteNode)
  end
  def local_variable_and_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil)); end

  # Create a new LocalVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#545
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      binary_operator: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableOperatorWriteNode)
  end
  def local_variable_operator_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), name: T.unsafe(nil), binary_operator: T.unsafe(nil), depth: T.unsafe(nil)); end

  # Create a new LocalVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#550
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableOrWriteNode)
  end
  def local_variable_or_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil)); end

  # Create a new LocalVariableReadNode node.
  #
  # source://prism//lib/prism/dsl.rb#555
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableReadNode)
  end
  def local_variable_read_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil)); end

  # Create a new LocalVariableTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#560
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableTargetNode)
  end
  def local_variable_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil)); end

  # Create a new LocalVariableWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#565
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::LocalVariableWriteNode)
  end
  def local_variable_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new Location object.
  #
  # source://prism//lib/prism/dsl.rb#75
  sig { params(source: Prism::Source, start_offset: Integer, length: Integer).returns(Prism::Location) }
  def location(source: T.unsafe(nil), start_offset: T.unsafe(nil), length: T.unsafe(nil)); end

  # Retrieve the value of one of the LoopFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#903
  sig { params(name: Symbol).returns(Integer) }
  def loop_flag(name); end

  # Create a new MatchLastLineNode node.
  #
  # source://prism//lib/prism/dsl.rb#570
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      content_loc: Prism::Location,
      closing_loc: Prism::Location,
      unescaped: String
    ).returns(Prism::MatchLastLineNode)
  end
  def match_last_line_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), content_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), unescaped: T.unsafe(nil)); end

  # Create a new MatchPredicateNode node.
  #
  # source://prism//lib/prism/dsl.rb#575
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      pattern: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::MatchPredicateNode)
  end
  def match_predicate_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil), pattern: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new MatchRequiredNode node.
  #
  # source://prism//lib/prism/dsl.rb#580
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      pattern: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::MatchRequiredNode)
  end
  def match_required_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil), pattern: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new MatchWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#585
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      call: Prism::CallNode,
      targets: T::Array[Prism::LocalVariableTargetNode]
    ).returns(Prism::MatchWriteNode)
  end
  def match_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), call: T.unsafe(nil), targets: T.unsafe(nil)); end

  # Create a new MissingNode node.
  #
  # source://prism//lib/prism/dsl.rb#590
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::MissingNode)
  end
  def missing_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new ModuleNode node.
  #
  # source://prism//lib/prism/dsl.rb#595
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      module_keyword_loc: Prism::Location,
      constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::MissingNode),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      end_keyword_loc: Prism::Location,
      name: Symbol
    ).returns(Prism::ModuleNode)
  end
  def module_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), module_keyword_loc: T.unsafe(nil), constant_path: T.unsafe(nil), body: T.unsafe(nil), end_keyword_loc: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new MultiTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#600
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)),
      rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location)
    ).returns(Prism::MultiTargetNode)
  end
  def multi_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), lefts: T.unsafe(nil), rest: T.unsafe(nil), rights: T.unsafe(nil), lparen_loc: T.unsafe(nil), rparen_loc: T.unsafe(nil)); end

  # Create a new MultiWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#605
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)),
      rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::MultiWriteNode)
  end
  def multi_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), lefts: T.unsafe(nil), rest: T.unsafe(nil), rights: T.unsafe(nil), lparen_loc: T.unsafe(nil), rparen_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new NextNode node.
  #
  # source://prism//lib/prism/dsl.rb#610
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T.nilable(Prism::ArgumentsNode),
      keyword_loc: Prism::Location
    ).returns(Prism::NextNode)
  end
  def next_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), arguments: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # Create a new NilNode node.
  #
  # source://prism//lib/prism/dsl.rb#615
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::NilNode)
  end
  def nil_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new NoKeywordsParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#620
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      operator_loc: Prism::Location,
      keyword_loc: Prism::Location
    ).returns(Prism::NoKeywordsParameterNode)
  end
  def no_keywords_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), operator_loc: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # Create a new NumberedParametersNode node.
  #
  # source://prism//lib/prism/dsl.rb#625
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      maximum: Integer
    ).returns(Prism::NumberedParametersNode)
  end
  def numbered_parameters_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), maximum: T.unsafe(nil)); end

  # Create a new NumberedReferenceReadNode node.
  #
  # source://prism//lib/prism/dsl.rb#630
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      number: Integer
    ).returns(Prism::NumberedReferenceReadNode)
  end
  def numbered_reference_read_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), number: T.unsafe(nil)); end

  # Create a new OptionalKeywordParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#635
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::OptionalKeywordParameterNode)
  end
  def optional_keyword_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new OptionalParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#640
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::OptionalParameterNode)
  end
  def optional_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new OrNode node.
  #
  # source://prism//lib/prism/dsl.rb#645
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::OrNode)
  end
  def or_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Retrieve the value of one of the ParameterFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#911
  sig { params(name: Symbol).returns(Integer) }
  def parameter_flag(name); end

  # Create a new ParametersNode node.
  #
  # source://prism//lib/prism/dsl.rb#650
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      requireds: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode)],
      optionals: T::Array[Prism::OptionalParameterNode],
      rest: T.nilable(T.any(Prism::RestParameterNode, Prism::ImplicitRestNode)),
      posts: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode, Prism::KeywordRestParameterNode, Prism::NoKeywordsParameterNode, Prism::ForwardingParameterNode)],
      keywords: T::Array[T.any(Prism::RequiredKeywordParameterNode, Prism::OptionalKeywordParameterNode)],
      keyword_rest: T.nilable(T.any(Prism::KeywordRestParameterNode, Prism::ForwardingParameterNode, Prism::NoKeywordsParameterNode)),
      block: T.nilable(Prism::BlockParameterNode)
    ).returns(Prism::ParametersNode)
  end
  def parameters_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), requireds: T.unsafe(nil), optionals: T.unsafe(nil), rest: T.unsafe(nil), posts: T.unsafe(nil), keywords: T.unsafe(nil), keyword_rest: T.unsafe(nil), block: T.unsafe(nil)); end

  # Create a new ParenthesesNode node.
  #
  # source://prism//lib/prism/dsl.rb#655
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      body: T.nilable(Prism::Node),
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).returns(Prism::ParenthesesNode)
  end
  def parentheses_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), body: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Retrieve the value of one of the ParenthesesNodeFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#919
  sig { params(name: Symbol).returns(Integer) }
  def parentheses_node_flag(name); end

  # Create a new PinnedExpressionNode node.
  #
  # source://prism//lib/prism/dsl.rb#660
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      expression: Prism::Node,
      operator_loc: Prism::Location,
      lparen_loc: Prism::Location,
      rparen_loc: Prism::Location
    ).returns(Prism::PinnedExpressionNode)
  end
  def pinned_expression_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), expression: T.unsafe(nil), operator_loc: T.unsafe(nil), lparen_loc: T.unsafe(nil), rparen_loc: T.unsafe(nil)); end

  # Create a new PinnedVariableNode node.
  #
  # source://prism//lib/prism/dsl.rb#665
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      variable: T.any(Prism::LocalVariableReadNode, Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::ItLocalVariableReadNode, Prism::MissingNode),
      operator_loc: Prism::Location
    ).returns(Prism::PinnedVariableNode)
  end
  def pinned_variable_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), variable: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new PostExecutionNode node.
  #
  # source://prism//lib/prism/dsl.rb#670
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      statements: T.nilable(Prism::StatementsNode),
      keyword_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).returns(Prism::PostExecutionNode)
  end
  def post_execution_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), statements: T.unsafe(nil), keyword_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new PreExecutionNode node.
  #
  # source://prism//lib/prism/dsl.rb#675
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      statements: T.nilable(Prism::StatementsNode),
      keyword_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).returns(Prism::PreExecutionNode)
  end
  def pre_execution_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), statements: T.unsafe(nil), keyword_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new ProgramNode node.
  #
  # source://prism//lib/prism/dsl.rb#680
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      statements: Prism::StatementsNode
    ).returns(Prism::ProgramNode)
  end
  def program_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), statements: T.unsafe(nil)); end

  # Retrieve the value of one of the RangeFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#927
  sig { params(name: Symbol).returns(Integer) }
  def range_flag(name); end

  # Create a new RangeNode node.
  #
  # source://prism//lib/prism/dsl.rb#685
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: T.nilable(Prism::Node),
      right: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).returns(Prism::RangeNode)
  end
  def range_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new RationalNode node.
  #
  # source://prism//lib/prism/dsl.rb#690
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      numerator: Integer,
      denominator: Integer
    ).returns(Prism::RationalNode)
  end
  def rational_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), numerator: T.unsafe(nil), denominator: T.unsafe(nil)); end

  # Create a new RedoNode node.
  #
  # source://prism//lib/prism/dsl.rb#695
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::RedoNode)
  end
  def redo_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Retrieve the value of one of the RegularExpressionFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#935
  sig { params(name: Symbol).returns(Integer) }
  def regular_expression_flag(name); end

  # Create a new RegularExpressionNode node.
  #
  # source://prism//lib/prism/dsl.rb#700
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      content_loc: Prism::Location,
      closing_loc: Prism::Location,
      unescaped: String
    ).returns(Prism::RegularExpressionNode)
  end
  def regular_expression_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), content_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), unescaped: T.unsafe(nil)); end

  # Create a new RequiredKeywordParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#705
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location
    ).returns(Prism::RequiredKeywordParameterNode)
  end
  def required_keyword_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil)); end

  # Create a new RequiredParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#710
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::RequiredParameterNode)
  end
  def required_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new RescueModifierNode node.
  #
  # source://prism//lib/prism/dsl.rb#715
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      expression: Prism::Node,
      keyword_loc: Prism::Location,
      rescue_expression: Prism::Node
    ).returns(Prism::RescueModifierNode)
  end
  def rescue_modifier_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), expression: T.unsafe(nil), keyword_loc: T.unsafe(nil), rescue_expression: T.unsafe(nil)); end

  # Create a new RescueNode node.
  #
  # source://prism//lib/prism/dsl.rb#720
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      exceptions: T::Array[Prism::Node],
      operator_loc: T.nilable(Prism::Location),
      reference: T.nilable(T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode)),
      then_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      subsequent: T.nilable(Prism::RescueNode)
    ).returns(Prism::RescueNode)
  end
  def rescue_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), exceptions: T.unsafe(nil), operator_loc: T.unsafe(nil), reference: T.unsafe(nil), then_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), subsequent: T.unsafe(nil)); end

  # Create a new RestParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#725
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location
    ).returns(Prism::RestParameterNode)
  end
  def rest_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new RetryNode node.
  #
  # source://prism//lib/prism/dsl.rb#730
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::RetryNode)
  end
  def retry_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new ReturnNode node.
  #
  # source://prism//lib/prism/dsl.rb#735
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode)
    ).returns(Prism::ReturnNode)
  end
  def return_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), arguments: T.unsafe(nil)); end

  # Create a new SelfNode node.
  #
  # source://prism//lib/prism/dsl.rb#740
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::SelfNode)
  end
  def self_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new ShareableConstantNode node.
  #
  # source://prism//lib/prism/dsl.rb#745
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      write: T.any(Prism::ConstantWriteNode, Prism::ConstantAndWriteNode, Prism::ConstantOrWriteNode, Prism::ConstantOperatorWriteNode, Prism::ConstantPathWriteNode, Prism::ConstantPathAndWriteNode, Prism::ConstantPathOrWriteNode, Prism::ConstantPathOperatorWriteNode)
    ).returns(Prism::ShareableConstantNode)
  end
  def shareable_constant_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), write: T.unsafe(nil)); end

  # Retrieve the value of one of the ShareableConstantNodeFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#953
  sig { params(name: Symbol).returns(Integer) }
  def shareable_constant_node_flag(name); end

  # Create a new SingletonClassNode node.
  #
  # source://prism//lib/prism/dsl.rb#750
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      class_keyword_loc: Prism::Location,
      operator_loc: Prism::Location,
      expression: Prism::Node,
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      end_keyword_loc: Prism::Location
    ).returns(Prism::SingletonClassNode)
  end
  def singleton_class_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), class_keyword_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), expression: T.unsafe(nil), body: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new Source object.
  #
  # source://prism//lib/prism/dsl.rb#70
  sig { params(string: String).returns(Prism::Source) }
  def source(string); end

  # Create a new SourceEncodingNode node.
  #
  # source://prism//lib/prism/dsl.rb#755
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::SourceEncodingNode)
  end
  def source_encoding_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new SourceFileNode node.
  #
  # source://prism//lib/prism/dsl.rb#760
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      filepath: String
    ).returns(Prism::SourceFileNode)
  end
  def source_file_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), filepath: T.unsafe(nil)); end

  # Create a new SourceLineNode node.
  #
  # source://prism//lib/prism/dsl.rb#765
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::SourceLineNode)
  end
  def source_line_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new SplatNode node.
  #
  # source://prism//lib/prism/dsl.rb#770
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      operator_loc: Prism::Location,
      expression: T.nilable(Prism::Node)
    ).returns(Prism::SplatNode)
  end
  def splat_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), operator_loc: T.unsafe(nil), expression: T.unsafe(nil)); end

  # Create a new StatementsNode node.
  #
  # source://prism//lib/prism/dsl.rb#775
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      body: T::Array[Prism::Node]
    ).returns(Prism::StatementsNode)
  end
  def statements_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), body: T.unsafe(nil)); end

  # Retrieve the value of one of the StringFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#963
  sig { params(name: Symbol).returns(Integer) }
  def string_flag(name); end

  # Create a new StringNode node.
  #
  # source://prism//lib/prism/dsl.rb#780
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      content_loc: Prism::Location,
      closing_loc: T.nilable(Prism::Location),
      unescaped: String
    ).returns(Prism::StringNode)
  end
  def string_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), content_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), unescaped: T.unsafe(nil)); end

  # Create a new SuperNode node.
  #
  # source://prism//lib/prism/dsl.rb#785
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      lparen_loc: T.nilable(Prism::Location),
      arguments: T.nilable(Prism::ArgumentsNode),
      rparen_loc: T.nilable(Prism::Location),
      block: T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))
    ).returns(Prism::SuperNode)
  end
  def super_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), lparen_loc: T.unsafe(nil), arguments: T.unsafe(nil), rparen_loc: T.unsafe(nil), block: T.unsafe(nil)); end

  # Retrieve the value of one of the SymbolFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#974
  sig { params(name: Symbol).returns(Integer) }
  def symbol_flag(name); end

  # Create a new SymbolNode node.
  #
  # source://prism//lib/prism/dsl.rb#790
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      value_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location),
      unescaped: String
    ).returns(Prism::SymbolNode)
  end
  def symbol_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), value_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), unescaped: T.unsafe(nil)); end

  # Create a new TrueNode node.
  #
  # source://prism//lib/prism/dsl.rb#795
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::TrueNode)
  end
  def true_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new UndefNode node.
  #
  # source://prism//lib/prism/dsl.rb#800
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      names: T::Array[T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode)],
      keyword_loc: Prism::Location
    ).returns(Prism::UndefNode)
  end
  def undef_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), names: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # Create a new UnlessNode node.
  #
  # source://prism//lib/prism/dsl.rb#805
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      predicate: Prism::Node,
      then_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      else_clause: T.nilable(Prism::ElseNode),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::UnlessNode)
  end
  def unless_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), predicate: T.unsafe(nil), then_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), else_clause: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new UntilNode node.
  #
  # source://prism//lib/prism/dsl.rb#810
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      do_keyword_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location),
      predicate: Prism::Node,
      statements: T.nilable(Prism::StatementsNode)
    ).returns(Prism::UntilNode)
  end
  def until_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), do_keyword_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), predicate: T.unsafe(nil), statements: T.unsafe(nil)); end

  # Create a new WhenNode node.
  #
  # source://prism//lib/prism/dsl.rb#815
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      conditions: T::Array[Prism::Node],
      then_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode)
    ).returns(Prism::WhenNode)
  end
  def when_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), conditions: T.unsafe(nil), then_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil)); end

  # Create a new WhileNode node.
  #
  # source://prism//lib/prism/dsl.rb#820
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      do_keyword_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location),
      predicate: Prism::Node,
      statements: T.nilable(Prism::StatementsNode)
    ).returns(Prism::WhileNode)
  end
  def while_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), do_keyword_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), predicate: T.unsafe(nil), statements: T.unsafe(nil)); end

  # Create a new XStringNode node.
  #
  # source://prism//lib/prism/dsl.rb#825
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      content_loc: Prism::Location,
      closing_loc: Prism::Location,
      unescaped: String
    ).returns(Prism::XStringNode)
  end
  def x_string_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), content_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), unescaped: T.unsafe(nil)); end

  # Create a new YieldNode node.
  #
  # source://prism//lib/prism/dsl.rb#830
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      lparen_loc: T.nilable(Prism::Location),
      arguments: T.nilable(Prism::ArgumentsNode),
      rparen_loc: T.nilable(Prism::Location)
    ).returns(Prism::YieldNode)
  end
  def yield_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), lparen_loc: T.unsafe(nil), arguments: T.unsafe(nil), rparen_loc: T.unsafe(nil)); end

  private

  # The default location object that gets attached to nodes if no location is
  # specified, which uses the given source.
  #
  # source://prism//lib/prism/dsl.rb#993
  sig { returns(Prism::Location) }
  def default_location; end

  # The default node that gets attached to nodes if no node is specified for a
  # required node field.
  #
  # source://prism//lib/prism/dsl.rb#999
  sig { params(source: Prism::Source, location: Prism::Location).returns(Prism::Node) }
  def default_node(source, location); end

  # The default source object that gets attached to nodes and locations if no
  # source is specified.
  #
  # source://prism//lib/prism/dsl.rb#987
  sig { returns(Prism::Source) }
  def default_source; end
end

# Represents a method definition.
#
#     def method
#     end
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#6293
class Prism::DefNode < ::Prism::Node
  # Initialize a new DefNode node.
  #
  # @return [DefNode] a new instance of DefNode
  #
  # source://prism//lib/prism/node.rb#6295
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      receiver: T.nilable(Prism::Node),
      parameters: T.nilable(Prism::ParametersNode),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      locals: T::Array[Symbol],
      def_keyword_loc: Prism::Location,
      operator_loc: T.nilable(Prism::Location),
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location),
      equal_loc: T.nilable(Prism::Location),
      end_keyword_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, receiver, parameters, body, locals, def_keyword_loc, operator_loc, lparen_loc, rparen_loc, equal_loc, end_keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#6543
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6315
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader body: StatementsNode | BeginNode | nil
  #
  # source://prism//lib/prism/node.rb#6383
  sig { returns(T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))) }
  def body; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#6320
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6343
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6334
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?receiver: Prism::node?, ?parameters: ParametersNode?, ?body: StatementsNode | BeginNode | nil, ?locals: Array[Symbol], ?def_keyword_loc: Location, ?operator_loc: Location?, ?lparen_loc: Location?, ?rparen_loc: Location?, ?equal_loc: Location?, ?end_keyword_loc: Location?) -> DefNode
  #
  # source://prism//lib/prism/node.rb#6348
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      receiver: T.nilable(Prism::Node),
      parameters: T.nilable(Prism::ParametersNode),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      locals: T::Array[Symbol],
      def_keyword_loc: Prism::Location,
      operator_loc: T.nilable(Prism::Location),
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location),
      equal_loc: T.nilable(Prism::Location),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::DefNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), receiver: T.unsafe(nil), parameters: T.unsafe(nil), body: T.unsafe(nil), locals: T.unsafe(nil), def_keyword_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), lparen_loc: T.unsafe(nil), rparen_loc: T.unsafe(nil), equal_loc: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#6353
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, receiver: Prism::node?, parameters: ParametersNode?, body: StatementsNode | BeginNode | nil, locals: Array[Symbol], def_keyword_loc: Location, operator_loc: Location?, lparen_loc: Location?, rparen_loc: Location?, equal_loc: Location?, end_keyword_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#6356
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def def_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#6497
  sig { returns(String) }
  def def_keyword; end

  # attr_reader def_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#6389
  sig { returns(Prism::Location) }
  def def_keyword_loc; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [receiver]
  #
  # source://prism//lib/prism/node.rb#6325
  def each_child_node; end

  # def end_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#6522
  sig { returns(T.nilable(String)) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location?
  #
  # source://prism//lib/prism/node.rb#6478
  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  # def equal: () -> String?
  #
  # source://prism//lib/prism/node.rb#6517
  sig { returns(T.nilable(String)) }
  def equal; end

  # attr_reader equal_loc: Location?
  #
  # source://prism//lib/prism/node.rb#6459
  sig { returns(T.nilable(Prism::Location)) }
  def equal_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#6527
  sig { override.returns(String) }
  def inspect; end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#6386
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # def lparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#6507
  sig { returns(T.nilable(String)) }
  def lparen; end

  # attr_reader lparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#6421
  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#6361
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#6364
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#6502
  sig { returns(T.nilable(String)) }
  def operator; end

  # attr_reader operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#6402
  sig { returns(T.nilable(Prism::Location)) }
  def operator_loc; end

  # attr_reader parameters: ParametersNode?
  #
  # source://prism//lib/prism/node.rb#6380
  sig { returns(T.nilable(Prism::ParametersNode)) }
  def parameters; end

  # attr_reader receiver: Prism::node?
  #
  # source://prism//lib/prism/node.rb#6377
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def rparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#6512
  sig { returns(T.nilable(String)) }
  def rparen; end

  # attr_reader rparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#6440
  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  # Save the def_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#6397
  def save_def_keyword_loc(repository); end

  # Save the end_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#6492
  def save_end_keyword_loc(repository); end

  # Save the equal_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#6473
  def save_equal_loc(repository); end

  # Save the lparen_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#6435
  def save_lparen_loc(repository); end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#6372
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#6416
  def save_operator_loc(repository); end

  # Save the rparen_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#6454
  def save_rparen_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#6532
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#6537
    def type; end
  end
end

# Represents the use of the `defined?` keyword.
#
#     defined?(a)
#     ^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#6565
class Prism::DefinedNode < ::Prism::Node
  # Initialize a new DefinedNode node.
  #
  # @return [DefinedNode] a new instance of DefinedNode
  #
  # source://prism//lib/prism/node.rb#6567
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lparen_loc: T.nilable(Prism::Location),
      value: Prism::Node,
      rparen_loc: T.nilable(Prism::Location),
      keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, lparen_loc, value, rparen_loc, keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#6704
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6579
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#6584
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6601
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6596
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?lparen_loc: Location?, ?value: Prism::node, ?rparen_loc: Location?, ?keyword_loc: Location) -> DefinedNode
  #
  # source://prism//lib/prism/node.rb#6606
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lparen_loc: T.nilable(Prism::Location),
      value: Prism::Node,
      rparen_loc: T.nilable(Prism::Location),
      keyword_loc: Prism::Location
    ).returns(Prism::DefinedNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), lparen_loc: T.unsafe(nil), value: T.unsafe(nil), rparen_loc: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#6611
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, lparen_loc: Location?, value: Prism::node, rparen_loc: Location?, keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#6614
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#6589
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#6688
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#6683
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#6660
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # def lparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#6673
  sig { returns(T.nilable(String)) }
  def lparen; end

  # attr_reader lparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#6619
  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  # def rparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#6678
  sig { returns(T.nilable(String)) }
  def rparen; end

  # attr_reader rparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#6641
  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  # Save the keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#6668
  def save_keyword_loc(repository); end

  # Save the lparen_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#6633
  def save_lparen_loc(repository); end

  # Save the rparen_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#6655
  def save_rparen_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#6693
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#6638
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#6698
    def type; end
  end
end

# source://prism//lib/prism/desugar_compiler.rb#5
class Prism::DesugarAndWriteNode
  include ::Prism::DSL

  # @return [DesugarAndWriteNode] a new instance of DesugarAndWriteNode
  #
  # source://prism//lib/prism/desugar_compiler.rb#10
  def initialize(node, default_source, read_class, write_class, **arguments); end

  # Returns the value of attribute arguments.
  #
  # source://prism//lib/prism/desugar_compiler.rb#8
  def arguments; end

  # Desugar `x &&= y` to `x && x = y`
  #
  # source://prism//lib/prism/desugar_compiler.rb#19
  def compile; end

  # Returns the value of attribute default_source.
  #
  # source://prism//lib/prism/desugar_compiler.rb#8
  def default_source; end

  # Returns the value of attribute node.
  #
  # source://prism//lib/prism/desugar_compiler.rb#8
  def node; end

  # Returns the value of attribute read_class.
  #
  # source://prism//lib/prism/desugar_compiler.rb#8
  def read_class; end

  # Returns the value of attribute write_class.
  #
  # source://prism//lib/prism/desugar_compiler.rb#8
  def write_class; end
end

# DesugarCompiler is a compiler that desugars Ruby code into a more primitive
# form. This is useful for consumers that want to deal with fewer node types.
#
# source://prism//lib/prism/desugar_compiler.rb#256
class Prism::DesugarCompiler < ::Prism::MutationCompiler
  # @@foo &&= bar
  #
  # becomes
  #
  # @@foo && @@foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#262
  def visit_class_variable_and_write_node(node); end

  # @@foo += bar
  #
  # becomes
  #
  # @@foo = @@foo + bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#280
  def visit_class_variable_operator_write_node(node); end

  # @@foo ||= bar
  #
  # becomes
  #
  # defined?(@@foo) ? @@foo : @@foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#271
  def visit_class_variable_or_write_node(node); end

  # Foo &&= bar
  #
  # becomes
  #
  # Foo && Foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#289
  def visit_constant_and_write_node(node); end

  # Foo += bar
  #
  # becomes
  #
  # Foo = Foo + bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#307
  def visit_constant_operator_write_node(node); end

  # Foo ||= bar
  #
  # becomes
  #
  # defined?(Foo) ? Foo : Foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#298
  def visit_constant_or_write_node(node); end

  # $foo &&= bar
  #
  # becomes
  #
  # $foo && $foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#316
  def visit_global_variable_and_write_node(node); end

  # $foo += bar
  #
  # becomes
  #
  # $foo = $foo + bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#334
  def visit_global_variable_operator_write_node(node); end

  # $foo ||= bar
  #
  # becomes
  #
  # defined?($foo) ? $foo : $foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#325
  def visit_global_variable_or_write_node(node); end

  # becomes
  #
  # source://prism//lib/prism/desugar_compiler.rb#343
  def visit_instance_variable_and_write_node(node); end

  # becomes
  #
  # source://prism//lib/prism/desugar_compiler.rb#361
  def visit_instance_variable_operator_write_node(node); end

  # becomes
  #
  # source://prism//lib/prism/desugar_compiler.rb#352
  def visit_instance_variable_or_write_node(node); end

  # foo &&= bar
  #
  # becomes
  #
  # foo && foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#370
  def visit_local_variable_and_write_node(node); end

  # foo += bar
  #
  # becomes
  #
  # foo = foo + bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#388
  def visit_local_variable_operator_write_node(node); end

  # foo ||= bar
  #
  # becomes
  #
  # foo || foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#379
  def visit_local_variable_or_write_node(node); end
end

# source://prism//lib/prism/desugar_compiler.rb#87
class Prism::DesugarOperatorWriteNode
  include ::Prism::DSL

  # @return [DesugarOperatorWriteNode] a new instance of DesugarOperatorWriteNode
  #
  # source://prism//lib/prism/desugar_compiler.rb#92
  def initialize(node, default_source, read_class, write_class, **arguments); end

  # Returns the value of attribute arguments.
  #
  # source://prism//lib/prism/desugar_compiler.rb#90
  def arguments; end

  # Desugar `x += y` to `x = x + y`
  #
  # source://prism//lib/prism/desugar_compiler.rb#101
  def compile; end

  # Returns the value of attribute default_source.
  #
  # source://prism//lib/prism/desugar_compiler.rb#90
  def default_source; end

  # Returns the value of attribute node.
  #
  # source://prism//lib/prism/desugar_compiler.rb#90
  def node; end

  # Returns the value of attribute read_class.
  #
  # source://prism//lib/prism/desugar_compiler.rb#90
  def read_class; end

  # Returns the value of attribute write_class.
  #
  # source://prism//lib/prism/desugar_compiler.rb#90
  def write_class; end
end

# source://prism//lib/prism/desugar_compiler.rb#36
class Prism::DesugarOrWriteDefinedNode
  include ::Prism::DSL

  # @return [DesugarOrWriteDefinedNode] a new instance of DesugarOrWriteDefinedNode
  #
  # source://prism//lib/prism/desugar_compiler.rb#41
  def initialize(node, default_source, read_class, write_class, **arguments); end

  # Returns the value of attribute arguments.
  #
  # source://prism//lib/prism/desugar_compiler.rb#39
  def arguments; end

  # Desugar `x ||= y` to `defined?(x) ? x : x = y`
  #
  # source://prism//lib/prism/desugar_compiler.rb#50
  def compile; end

  # Returns the value of attribute default_source.
  #
  # source://prism//lib/prism/desugar_compiler.rb#39
  def default_source; end

  # Returns the value of attribute node.
  #
  # source://prism//lib/prism/desugar_compiler.rb#39
  def node; end

  # Returns the value of attribute read_class.
  #
  # source://prism//lib/prism/desugar_compiler.rb#39
  def read_class; end

  # Returns the value of attribute write_class.
  #
  # source://prism//lib/prism/desugar_compiler.rb#39
  def write_class; end
end

# source://prism//lib/prism/desugar_compiler.rb#131
class Prism::DesugarOrWriteNode
  include ::Prism::DSL

  # @return [DesugarOrWriteNode] a new instance of DesugarOrWriteNode
  #
  # source://prism//lib/prism/desugar_compiler.rb#136
  def initialize(node, default_source, read_class, write_class, **arguments); end

  # Returns the value of attribute arguments.
  #
  # source://prism//lib/prism/desugar_compiler.rb#134
  def arguments; end

  # Desugar `x ||= y` to `x || x = y`
  #
  # source://prism//lib/prism/desugar_compiler.rb#145
  def compile; end

  # Returns the value of attribute default_source.
  #
  # source://prism//lib/prism/desugar_compiler.rb#134
  def default_source; end

  # Returns the value of attribute node.
  #
  # source://prism//lib/prism/desugar_compiler.rb#134
  def node; end

  # Returns the value of attribute read_class.
  #
  # source://prism//lib/prism/desugar_compiler.rb#134
  def read_class; end

  # Returns the value of attribute write_class.
  #
  # source://prism//lib/prism/desugar_compiler.rb#134
  def write_class; end
end

# The dispatcher class fires events for nodes that are found while walking an
# AST to all registered listeners. It's useful for performing different types
# of analysis on the AST while only having to walk the tree once.
#
# To use the dispatcher, you would first instantiate it and register listeners
# for the events you're interested in:
#
#     class OctalListener
#       def on_integer_node_enter(node)
#         if node.octal? && !node.slice.start_with?("0o")
#           warn("Octal integers should be written with the 0o prefix")
#         end
#       end
#     end
#
#     listener = OctalListener.new
#     dispatcher = Prism::Dispatcher.new
#     dispatcher.register(listener, :on_integer_node_enter)
#
# Then, you can walk any number of trees and dispatch events to the listeners:
#
#     result = Prism.parse("001 + 002 + 003")
#     dispatcher.dispatch(result.value)
#
# Optionally, you can also use `#dispatch_once` to dispatch enter and leave
# events for a single node without recursing further down the tree. This can
# be useful in circumstances where you want to reuse the listeners you already
# have registers but want to stop walking the tree at a certain point.
#
#     integer = result.value.statements.body.first.receiver.receiver
#     dispatcher.dispatch_once(integer)
#
# source://prism//lib/prism/dispatcher.rb#45
class Prism::Dispatcher < ::Prism::Visitor
  # Initialize a new dispatcher.
  #
  # @return [Dispatcher] a new instance of Dispatcher
  #
  # source://prism//lib/prism/dispatcher.rb#50
  def initialize; end

  # Walks `root` dispatching events to all registered listeners.
  #
  # def dispatch: (Node) -> void
  #
  # source://prism//lib/prism/dispatcher.rb#77
  def dispatch(node); end

  # Dispatches a single event for `node` to all registered listeners.
  #
  # def dispatch_once: (Node) -> void
  #
  # source://prism//lib/prism/dispatcher.rb#82
  def dispatch_once(node); end

  # attr_reader listeners: Hash[Symbol, Array[Listener]]
  #
  # source://prism//lib/prism/dispatcher.rb#47
  def listeners; end

  # Register a listener for one or more events.
  #
  # def register: (Listener, *Symbol) -> void
  #
  # source://prism//lib/prism/dispatcher.rb#57
  def register(listener, *events); end

  # Register all public methods of a listener that match the pattern
  # `on_<node_name>_(enter|leave)`.
  #
  # def register_public_methods: (Listener) -> void
  #
  # source://prism//lib/prism/dispatcher.rb#65
  def register_public_methods(listener); end

  # Dispatch enter and leave events for AliasGlobalVariableNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#88
  def visit_alias_global_variable_node(node); end

  # Dispatch enter and leave events for AliasMethodNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#96
  def visit_alias_method_node(node); end

  # Dispatch enter and leave events for AlternationPatternNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#104
  def visit_alternation_pattern_node(node); end

  # Dispatch enter and leave events for AndNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#112
  def visit_and_node(node); end

  # Dispatch enter and leave events for ArgumentsNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#120
  def visit_arguments_node(node); end

  # Dispatch enter and leave events for ArrayNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#128
  def visit_array_node(node); end

  # Dispatch enter and leave events for ArrayPatternNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#136
  def visit_array_pattern_node(node); end

  # Dispatch enter and leave events for AssocNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#144
  def visit_assoc_node(node); end

  # Dispatch enter and leave events for AssocSplatNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#152
  def visit_assoc_splat_node(node); end

  # Dispatch enter and leave events for BackReferenceReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#160
  def visit_back_reference_read_node(node); end

  # Dispatch enter and leave events for BeginNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#168
  def visit_begin_node(node); end

  # Dispatch enter and leave events for BlockArgumentNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#176
  def visit_block_argument_node(node); end

  # Dispatch enter and leave events for BlockLocalVariableNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#184
  def visit_block_local_variable_node(node); end

  # Dispatch enter and leave events for BlockNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#192
  def visit_block_node(node); end

  # Dispatch enter and leave events for BlockParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#200
  def visit_block_parameter_node(node); end

  # Dispatch enter and leave events for BlockParametersNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#208
  def visit_block_parameters_node(node); end

  # Dispatch enter and leave events for BreakNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#216
  def visit_break_node(node); end

  # Dispatch enter and leave events for CallAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#224
  def visit_call_and_write_node(node); end

  # Dispatch enter and leave events for CallNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#232
  def visit_call_node(node); end

  # Dispatch enter and leave events for CallOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#240
  def visit_call_operator_write_node(node); end

  # Dispatch enter and leave events for CallOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#248
  def visit_call_or_write_node(node); end

  # Dispatch enter and leave events for CallTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#256
  def visit_call_target_node(node); end

  # Dispatch enter and leave events for CapturePatternNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#264
  def visit_capture_pattern_node(node); end

  # Dispatch enter and leave events for CaseMatchNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#272
  def visit_case_match_node(node); end

  # Dispatch enter and leave events for CaseNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#280
  def visit_case_node(node); end

  # Dispatch enter and leave events for ClassNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#288
  def visit_class_node(node); end

  # Dispatch enter and leave events for ClassVariableAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#296
  def visit_class_variable_and_write_node(node); end

  # Dispatch enter and leave events for ClassVariableOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#304
  def visit_class_variable_operator_write_node(node); end

  # Dispatch enter and leave events for ClassVariableOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#312
  def visit_class_variable_or_write_node(node); end

  # Dispatch enter and leave events for ClassVariableReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#320
  def visit_class_variable_read_node(node); end

  # Dispatch enter and leave events for ClassVariableTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#328
  def visit_class_variable_target_node(node); end

  # Dispatch enter and leave events for ClassVariableWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#336
  def visit_class_variable_write_node(node); end

  # Dispatch enter and leave events for ConstantAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#344
  def visit_constant_and_write_node(node); end

  # Dispatch enter and leave events for ConstantOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#352
  def visit_constant_operator_write_node(node); end

  # Dispatch enter and leave events for ConstantOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#360
  def visit_constant_or_write_node(node); end

  # Dispatch enter and leave events for ConstantPathAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#368
  def visit_constant_path_and_write_node(node); end

  # Dispatch enter and leave events for ConstantPathNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#376
  def visit_constant_path_node(node); end

  # Dispatch enter and leave events for ConstantPathOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#384
  def visit_constant_path_operator_write_node(node); end

  # Dispatch enter and leave events for ConstantPathOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#392
  def visit_constant_path_or_write_node(node); end

  # Dispatch enter and leave events for ConstantPathTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#400
  def visit_constant_path_target_node(node); end

  # Dispatch enter and leave events for ConstantPathWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#408
  def visit_constant_path_write_node(node); end

  # Dispatch enter and leave events for ConstantReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#416
  def visit_constant_read_node(node); end

  # Dispatch enter and leave events for ConstantTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#424
  def visit_constant_target_node(node); end

  # Dispatch enter and leave events for ConstantWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#432
  def visit_constant_write_node(node); end

  # Dispatch enter and leave events for DefNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#440
  def visit_def_node(node); end

  # Dispatch enter and leave events for DefinedNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#448
  def visit_defined_node(node); end

  # Dispatch enter and leave events for ElseNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#456
  def visit_else_node(node); end

  # Dispatch enter and leave events for EmbeddedStatementsNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#464
  def visit_embedded_statements_node(node); end

  # Dispatch enter and leave events for EmbeddedVariableNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#472
  def visit_embedded_variable_node(node); end

  # Dispatch enter and leave events for EnsureNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#480
  def visit_ensure_node(node); end

  # Dispatch enter and leave events for FalseNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#488
  def visit_false_node(node); end

  # Dispatch enter and leave events for FindPatternNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#496
  def visit_find_pattern_node(node); end

  # Dispatch enter and leave events for FlipFlopNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#504
  def visit_flip_flop_node(node); end

  # Dispatch enter and leave events for FloatNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#512
  def visit_float_node(node); end

  # Dispatch enter and leave events for ForNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#520
  def visit_for_node(node); end

  # Dispatch enter and leave events for ForwardingArgumentsNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#528
  def visit_forwarding_arguments_node(node); end

  # Dispatch enter and leave events for ForwardingParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#536
  def visit_forwarding_parameter_node(node); end

  # Dispatch enter and leave events for ForwardingSuperNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#544
  def visit_forwarding_super_node(node); end

  # Dispatch enter and leave events for GlobalVariableAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#552
  def visit_global_variable_and_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#560
  def visit_global_variable_operator_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#568
  def visit_global_variable_or_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#576
  def visit_global_variable_read_node(node); end

  # Dispatch enter and leave events for GlobalVariableTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#584
  def visit_global_variable_target_node(node); end

  # Dispatch enter and leave events for GlobalVariableWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#592
  def visit_global_variable_write_node(node); end

  # Dispatch enter and leave events for HashNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#600
  def visit_hash_node(node); end

  # Dispatch enter and leave events for HashPatternNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#608
  def visit_hash_pattern_node(node); end

  # Dispatch enter and leave events for IfNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#616
  def visit_if_node(node); end

  # Dispatch enter and leave events for ImaginaryNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#624
  def visit_imaginary_node(node); end

  # Dispatch enter and leave events for ImplicitNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#632
  def visit_implicit_node(node); end

  # Dispatch enter and leave events for ImplicitRestNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#640
  def visit_implicit_rest_node(node); end

  # Dispatch enter and leave events for InNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#648
  def visit_in_node(node); end

  # Dispatch enter and leave events for IndexAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#656
  def visit_index_and_write_node(node); end

  # Dispatch enter and leave events for IndexOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#664
  def visit_index_operator_write_node(node); end

  # Dispatch enter and leave events for IndexOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#672
  def visit_index_or_write_node(node); end

  # Dispatch enter and leave events for IndexTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#680
  def visit_index_target_node(node); end

  # Dispatch enter and leave events for InstanceVariableAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#688
  def visit_instance_variable_and_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#696
  def visit_instance_variable_operator_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#704
  def visit_instance_variable_or_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#712
  def visit_instance_variable_read_node(node); end

  # Dispatch enter and leave events for InstanceVariableTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#720
  def visit_instance_variable_target_node(node); end

  # Dispatch enter and leave events for InstanceVariableWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#728
  def visit_instance_variable_write_node(node); end

  # Dispatch enter and leave events for IntegerNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#736
  def visit_integer_node(node); end

  # Dispatch enter and leave events for InterpolatedMatchLastLineNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#744
  def visit_interpolated_match_last_line_node(node); end

  # Dispatch enter and leave events for InterpolatedRegularExpressionNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#752
  def visit_interpolated_regular_expression_node(node); end

  # Dispatch enter and leave events for InterpolatedStringNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#760
  def visit_interpolated_string_node(node); end

  # Dispatch enter and leave events for InterpolatedSymbolNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#768
  def visit_interpolated_symbol_node(node); end

  # Dispatch enter and leave events for InterpolatedXStringNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#776
  def visit_interpolated_x_string_node(node); end

  # Dispatch enter and leave events for ItLocalVariableReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#784
  def visit_it_local_variable_read_node(node); end

  # Dispatch enter and leave events for ItParametersNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#792
  def visit_it_parameters_node(node); end

  # Dispatch enter and leave events for KeywordHashNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#800
  def visit_keyword_hash_node(node); end

  # Dispatch enter and leave events for KeywordRestParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#808
  def visit_keyword_rest_parameter_node(node); end

  # Dispatch enter and leave events for LambdaNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#816
  def visit_lambda_node(node); end

  # Dispatch enter and leave events for LocalVariableAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#824
  def visit_local_variable_and_write_node(node); end

  # Dispatch enter and leave events for LocalVariableOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#832
  def visit_local_variable_operator_write_node(node); end

  # Dispatch enter and leave events for LocalVariableOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#840
  def visit_local_variable_or_write_node(node); end

  # Dispatch enter and leave events for LocalVariableReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#848
  def visit_local_variable_read_node(node); end

  # Dispatch enter and leave events for LocalVariableTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#856
  def visit_local_variable_target_node(node); end

  # Dispatch enter and leave events for LocalVariableWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#864
  def visit_local_variable_write_node(node); end

  # Dispatch enter and leave events for MatchLastLineNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#872
  def visit_match_last_line_node(node); end

  # Dispatch enter and leave events for MatchPredicateNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#880
  def visit_match_predicate_node(node); end

  # Dispatch enter and leave events for MatchRequiredNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#888
  def visit_match_required_node(node); end

  # Dispatch enter and leave events for MatchWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#896
  def visit_match_write_node(node); end

  # Dispatch enter and leave events for MissingNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#904
  def visit_missing_node(node); end

  # Dispatch enter and leave events for ModuleNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#912
  def visit_module_node(node); end

  # Dispatch enter and leave events for MultiTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#920
  def visit_multi_target_node(node); end

  # Dispatch enter and leave events for MultiWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#928
  def visit_multi_write_node(node); end

  # Dispatch enter and leave events for NextNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#936
  def visit_next_node(node); end

  # Dispatch enter and leave events for NilNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#944
  def visit_nil_node(node); end

  # Dispatch enter and leave events for NoKeywordsParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#952
  def visit_no_keywords_parameter_node(node); end

  # Dispatch enter and leave events for NumberedParametersNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#960
  def visit_numbered_parameters_node(node); end

  # Dispatch enter and leave events for NumberedReferenceReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#968
  def visit_numbered_reference_read_node(node); end

  # Dispatch enter and leave events for OptionalKeywordParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#976
  def visit_optional_keyword_parameter_node(node); end

  # Dispatch enter and leave events for OptionalParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#984
  def visit_optional_parameter_node(node); end

  # Dispatch enter and leave events for OrNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#992
  def visit_or_node(node); end

  # Dispatch enter and leave events for ParametersNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1000
  def visit_parameters_node(node); end

  # Dispatch enter and leave events for ParenthesesNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1008
  def visit_parentheses_node(node); end

  # Dispatch enter and leave events for PinnedExpressionNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1016
  def visit_pinned_expression_node(node); end

  # Dispatch enter and leave events for PinnedVariableNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1024
  def visit_pinned_variable_node(node); end

  # Dispatch enter and leave events for PostExecutionNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1032
  def visit_post_execution_node(node); end

  # Dispatch enter and leave events for PreExecutionNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1040
  def visit_pre_execution_node(node); end

  # Dispatch enter and leave events for ProgramNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1048
  def visit_program_node(node); end

  # Dispatch enter and leave events for RangeNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1056
  def visit_range_node(node); end

  # Dispatch enter and leave events for RationalNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1064
  def visit_rational_node(node); end

  # Dispatch enter and leave events for RedoNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1072
  def visit_redo_node(node); end

  # Dispatch enter and leave events for RegularExpressionNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1080
  def visit_regular_expression_node(node); end

  # Dispatch enter and leave events for RequiredKeywordParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1088
  def visit_required_keyword_parameter_node(node); end

  # Dispatch enter and leave events for RequiredParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1096
  def visit_required_parameter_node(node); end

  # Dispatch enter and leave events for RescueModifierNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1104
  def visit_rescue_modifier_node(node); end

  # Dispatch enter and leave events for RescueNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1112
  def visit_rescue_node(node); end

  # Dispatch enter and leave events for RestParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1120
  def visit_rest_parameter_node(node); end

  # Dispatch enter and leave events for RetryNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1128
  def visit_retry_node(node); end

  # Dispatch enter and leave events for ReturnNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1136
  def visit_return_node(node); end

  # Dispatch enter and leave events for SelfNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1144
  def visit_self_node(node); end

  # Dispatch enter and leave events for ShareableConstantNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1152
  def visit_shareable_constant_node(node); end

  # Dispatch enter and leave events for SingletonClassNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1160
  def visit_singleton_class_node(node); end

  # Dispatch enter and leave events for SourceEncodingNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1168
  def visit_source_encoding_node(node); end

  # Dispatch enter and leave events for SourceFileNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1176
  def visit_source_file_node(node); end

  # Dispatch enter and leave events for SourceLineNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1184
  def visit_source_line_node(node); end

  # Dispatch enter and leave events for SplatNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1192
  def visit_splat_node(node); end

  # Dispatch enter and leave events for StatementsNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1200
  def visit_statements_node(node); end

  # Dispatch enter and leave events for StringNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1208
  def visit_string_node(node); end

  # Dispatch enter and leave events for SuperNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1216
  def visit_super_node(node); end

  # Dispatch enter and leave events for SymbolNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1224
  def visit_symbol_node(node); end

  # Dispatch enter and leave events for TrueNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1232
  def visit_true_node(node); end

  # Dispatch enter and leave events for UndefNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1240
  def visit_undef_node(node); end

  # Dispatch enter and leave events for UnlessNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1248
  def visit_unless_node(node); end

  # Dispatch enter and leave events for UntilNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1256
  def visit_until_node(node); end

  # Dispatch enter and leave events for WhenNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1264
  def visit_when_node(node); end

  # Dispatch enter and leave events for WhileNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1272
  def visit_while_node(node); end

  # Dispatch enter and leave events for XStringNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1280
  def visit_x_string_node(node); end

  # Dispatch enter and leave events for YieldNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1288
  def visit_yield_node(node); end

  private

  # Register a listener for the given events.
  #
  # source://prism//lib/prism/dispatcher.rb#70
  def register_events(listener, events); end
end

# source://prism//lib/prism/dispatcher.rb#1294
class Prism::Dispatcher::DispatchOnce < ::Prism::Visitor
  # @return [DispatchOnce] a new instance of DispatchOnce
  #
  # source://prism//lib/prism/dispatcher.rb#1297
  def initialize(listeners); end

  # Returns the value of attribute listeners.
  #
  # source://prism//lib/prism/dispatcher.rb#1295
  def listeners; end

  # Dispatch enter and leave events for AliasGlobalVariableNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1302
  def visit_alias_global_variable_node(node); end

  # Dispatch enter and leave events for AliasMethodNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1308
  def visit_alias_method_node(node); end

  # Dispatch enter and leave events for AlternationPatternNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1314
  def visit_alternation_pattern_node(node); end

  # Dispatch enter and leave events for AndNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1320
  def visit_and_node(node); end

  # Dispatch enter and leave events for ArgumentsNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1326
  def visit_arguments_node(node); end

  # Dispatch enter and leave events for ArrayNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1332
  def visit_array_node(node); end

  # Dispatch enter and leave events for ArrayPatternNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1338
  def visit_array_pattern_node(node); end

  # Dispatch enter and leave events for AssocNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1344
  def visit_assoc_node(node); end

  # Dispatch enter and leave events for AssocSplatNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1350
  def visit_assoc_splat_node(node); end

  # Dispatch enter and leave events for BackReferenceReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1356
  def visit_back_reference_read_node(node); end

  # Dispatch enter and leave events for BeginNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1362
  def visit_begin_node(node); end

  # Dispatch enter and leave events for BlockArgumentNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1368
  def visit_block_argument_node(node); end

  # Dispatch enter and leave events for BlockLocalVariableNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1374
  def visit_block_local_variable_node(node); end

  # Dispatch enter and leave events for BlockNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1380
  def visit_block_node(node); end

  # Dispatch enter and leave events for BlockParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1386
  def visit_block_parameter_node(node); end

  # Dispatch enter and leave events for BlockParametersNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1392
  def visit_block_parameters_node(node); end

  # Dispatch enter and leave events for BreakNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1398
  def visit_break_node(node); end

  # Dispatch enter and leave events for CallAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1404
  def visit_call_and_write_node(node); end

  # Dispatch enter and leave events for CallNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1410
  def visit_call_node(node); end

  # Dispatch enter and leave events for CallOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1416
  def visit_call_operator_write_node(node); end

  # Dispatch enter and leave events for CallOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1422
  def visit_call_or_write_node(node); end

  # Dispatch enter and leave events for CallTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1428
  def visit_call_target_node(node); end

  # Dispatch enter and leave events for CapturePatternNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1434
  def visit_capture_pattern_node(node); end

  # Dispatch enter and leave events for CaseMatchNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1440
  def visit_case_match_node(node); end

  # Dispatch enter and leave events for CaseNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1446
  def visit_case_node(node); end

  # Dispatch enter and leave events for ClassNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1452
  def visit_class_node(node); end

  # Dispatch enter and leave events for ClassVariableAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1458
  def visit_class_variable_and_write_node(node); end

  # Dispatch enter and leave events for ClassVariableOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1464
  def visit_class_variable_operator_write_node(node); end

  # Dispatch enter and leave events for ClassVariableOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1470
  def visit_class_variable_or_write_node(node); end

  # Dispatch enter and leave events for ClassVariableReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1476
  def visit_class_variable_read_node(node); end

  # Dispatch enter and leave events for ClassVariableTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1482
  def visit_class_variable_target_node(node); end

  # Dispatch enter and leave events for ClassVariableWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1488
  def visit_class_variable_write_node(node); end

  # Dispatch enter and leave events for ConstantAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1494
  def visit_constant_and_write_node(node); end

  # Dispatch enter and leave events for ConstantOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1500
  def visit_constant_operator_write_node(node); end

  # Dispatch enter and leave events for ConstantOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1506
  def visit_constant_or_write_node(node); end

  # Dispatch enter and leave events for ConstantPathAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1512
  def visit_constant_path_and_write_node(node); end

  # Dispatch enter and leave events for ConstantPathNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1518
  def visit_constant_path_node(node); end

  # Dispatch enter and leave events for ConstantPathOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1524
  def visit_constant_path_operator_write_node(node); end

  # Dispatch enter and leave events for ConstantPathOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1530
  def visit_constant_path_or_write_node(node); end

  # Dispatch enter and leave events for ConstantPathTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1536
  def visit_constant_path_target_node(node); end

  # Dispatch enter and leave events for ConstantPathWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1542
  def visit_constant_path_write_node(node); end

  # Dispatch enter and leave events for ConstantReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1548
  def visit_constant_read_node(node); end

  # Dispatch enter and leave events for ConstantTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1554
  def visit_constant_target_node(node); end

  # Dispatch enter and leave events for ConstantWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1560
  def visit_constant_write_node(node); end

  # Dispatch enter and leave events for DefNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1566
  def visit_def_node(node); end

  # Dispatch enter and leave events for DefinedNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1572
  def visit_defined_node(node); end

  # Dispatch enter and leave events for ElseNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1578
  def visit_else_node(node); end

  # Dispatch enter and leave events for EmbeddedStatementsNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1584
  def visit_embedded_statements_node(node); end

  # Dispatch enter and leave events for EmbeddedVariableNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1590
  def visit_embedded_variable_node(node); end

  # Dispatch enter and leave events for EnsureNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1596
  def visit_ensure_node(node); end

  # Dispatch enter and leave events for FalseNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1602
  def visit_false_node(node); end

  # Dispatch enter and leave events for FindPatternNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1608
  def visit_find_pattern_node(node); end

  # Dispatch enter and leave events for FlipFlopNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1614
  def visit_flip_flop_node(node); end

  # Dispatch enter and leave events for FloatNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1620
  def visit_float_node(node); end

  # Dispatch enter and leave events for ForNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1626
  def visit_for_node(node); end

  # Dispatch enter and leave events for ForwardingArgumentsNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1632
  def visit_forwarding_arguments_node(node); end

  # Dispatch enter and leave events for ForwardingParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1638
  def visit_forwarding_parameter_node(node); end

  # Dispatch enter and leave events for ForwardingSuperNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1644
  def visit_forwarding_super_node(node); end

  # Dispatch enter and leave events for GlobalVariableAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1650
  def visit_global_variable_and_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1656
  def visit_global_variable_operator_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1662
  def visit_global_variable_or_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1668
  def visit_global_variable_read_node(node); end

  # Dispatch enter and leave events for GlobalVariableTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1674
  def visit_global_variable_target_node(node); end

  # Dispatch enter and leave events for GlobalVariableWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1680
  def visit_global_variable_write_node(node); end

  # Dispatch enter and leave events for HashNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1686
  def visit_hash_node(node); end

  # Dispatch enter and leave events for HashPatternNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1692
  def visit_hash_pattern_node(node); end

  # Dispatch enter and leave events for IfNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1698
  def visit_if_node(node); end

  # Dispatch enter and leave events for ImaginaryNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1704
  def visit_imaginary_node(node); end

  # Dispatch enter and leave events for ImplicitNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1710
  def visit_implicit_node(node); end

  # Dispatch enter and leave events for ImplicitRestNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1716
  def visit_implicit_rest_node(node); end

  # Dispatch enter and leave events for InNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1722
  def visit_in_node(node); end

  # Dispatch enter and leave events for IndexAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1728
  def visit_index_and_write_node(node); end

  # Dispatch enter and leave events for IndexOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1734
  def visit_index_operator_write_node(node); end

  # Dispatch enter and leave events for IndexOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1740
  def visit_index_or_write_node(node); end

  # Dispatch enter and leave events for IndexTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1746
  def visit_index_target_node(node); end

  # Dispatch enter and leave events for InstanceVariableAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1752
  def visit_instance_variable_and_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1758
  def visit_instance_variable_operator_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1764
  def visit_instance_variable_or_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1770
  def visit_instance_variable_read_node(node); end

  # Dispatch enter and leave events for InstanceVariableTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1776
  def visit_instance_variable_target_node(node); end

  # Dispatch enter and leave events for InstanceVariableWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1782
  def visit_instance_variable_write_node(node); end

  # Dispatch enter and leave events for IntegerNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1788
  def visit_integer_node(node); end

  # Dispatch enter and leave events for InterpolatedMatchLastLineNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1794
  def visit_interpolated_match_last_line_node(node); end

  # Dispatch enter and leave events for InterpolatedRegularExpressionNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1800
  def visit_interpolated_regular_expression_node(node); end

  # Dispatch enter and leave events for InterpolatedStringNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1806
  def visit_interpolated_string_node(node); end

  # Dispatch enter and leave events for InterpolatedSymbolNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1812
  def visit_interpolated_symbol_node(node); end

  # Dispatch enter and leave events for InterpolatedXStringNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1818
  def visit_interpolated_x_string_node(node); end

  # Dispatch enter and leave events for ItLocalVariableReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1824
  def visit_it_local_variable_read_node(node); end

  # Dispatch enter and leave events for ItParametersNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1830
  def visit_it_parameters_node(node); end

  # Dispatch enter and leave events for KeywordHashNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1836
  def visit_keyword_hash_node(node); end

  # Dispatch enter and leave events for KeywordRestParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1842
  def visit_keyword_rest_parameter_node(node); end

  # Dispatch enter and leave events for LambdaNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1848
  def visit_lambda_node(node); end

  # Dispatch enter and leave events for LocalVariableAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1854
  def visit_local_variable_and_write_node(node); end

  # Dispatch enter and leave events for LocalVariableOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1860
  def visit_local_variable_operator_write_node(node); end

  # Dispatch enter and leave events for LocalVariableOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1866
  def visit_local_variable_or_write_node(node); end

  # Dispatch enter and leave events for LocalVariableReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1872
  def visit_local_variable_read_node(node); end

  # Dispatch enter and leave events for LocalVariableTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1878
  def visit_local_variable_target_node(node); end

  # Dispatch enter and leave events for LocalVariableWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1884
  def visit_local_variable_write_node(node); end

  # Dispatch enter and leave events for MatchLastLineNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1890
  def visit_match_last_line_node(node); end

  # Dispatch enter and leave events for MatchPredicateNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1896
  def visit_match_predicate_node(node); end

  # Dispatch enter and leave events for MatchRequiredNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1902
  def visit_match_required_node(node); end

  # Dispatch enter and leave events for MatchWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1908
  def visit_match_write_node(node); end

  # Dispatch enter and leave events for MissingNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1914
  def visit_missing_node(node); end

  # Dispatch enter and leave events for ModuleNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1920
  def visit_module_node(node); end

  # Dispatch enter and leave events for MultiTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1926
  def visit_multi_target_node(node); end

  # Dispatch enter and leave events for MultiWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1932
  def visit_multi_write_node(node); end

  # Dispatch enter and leave events for NextNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1938
  def visit_next_node(node); end

  # Dispatch enter and leave events for NilNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1944
  def visit_nil_node(node); end

  # Dispatch enter and leave events for NoKeywordsParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1950
  def visit_no_keywords_parameter_node(node); end

  # Dispatch enter and leave events for NumberedParametersNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1956
  def visit_numbered_parameters_node(node); end

  # Dispatch enter and leave events for NumberedReferenceReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1962
  def visit_numbered_reference_read_node(node); end

  # Dispatch enter and leave events for OptionalKeywordParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1968
  def visit_optional_keyword_parameter_node(node); end

  # Dispatch enter and leave events for OptionalParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1974
  def visit_optional_parameter_node(node); end

  # Dispatch enter and leave events for OrNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1980
  def visit_or_node(node); end

  # Dispatch enter and leave events for ParametersNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1986
  def visit_parameters_node(node); end

  # Dispatch enter and leave events for ParenthesesNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1992
  def visit_parentheses_node(node); end

  # Dispatch enter and leave events for PinnedExpressionNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1998
  def visit_pinned_expression_node(node); end

  # Dispatch enter and leave events for PinnedVariableNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2004
  def visit_pinned_variable_node(node); end

  # Dispatch enter and leave events for PostExecutionNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2010
  def visit_post_execution_node(node); end

  # Dispatch enter and leave events for PreExecutionNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2016
  def visit_pre_execution_node(node); end

  # Dispatch enter and leave events for ProgramNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2022
  def visit_program_node(node); end

  # Dispatch enter and leave events for RangeNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2028
  def visit_range_node(node); end

  # Dispatch enter and leave events for RationalNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2034
  def visit_rational_node(node); end

  # Dispatch enter and leave events for RedoNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2040
  def visit_redo_node(node); end

  # Dispatch enter and leave events for RegularExpressionNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2046
  def visit_regular_expression_node(node); end

  # Dispatch enter and leave events for RequiredKeywordParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2052
  def visit_required_keyword_parameter_node(node); end

  # Dispatch enter and leave events for RequiredParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2058
  def visit_required_parameter_node(node); end

  # Dispatch enter and leave events for RescueModifierNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2064
  def visit_rescue_modifier_node(node); end

  # Dispatch enter and leave events for RescueNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2070
  def visit_rescue_node(node); end

  # Dispatch enter and leave events for RestParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2076
  def visit_rest_parameter_node(node); end

  # Dispatch enter and leave events for RetryNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2082
  def visit_retry_node(node); end

  # Dispatch enter and leave events for ReturnNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2088
  def visit_return_node(node); end

  # Dispatch enter and leave events for SelfNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2094
  def visit_self_node(node); end

  # Dispatch enter and leave events for ShareableConstantNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2100
  def visit_shareable_constant_node(node); end

  # Dispatch enter and leave events for SingletonClassNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2106
  def visit_singleton_class_node(node); end

  # Dispatch enter and leave events for SourceEncodingNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2112
  def visit_source_encoding_node(node); end

  # Dispatch enter and leave events for SourceFileNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2118
  def visit_source_file_node(node); end

  # Dispatch enter and leave events for SourceLineNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2124
  def visit_source_line_node(node); end

  # Dispatch enter and leave events for SplatNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2130
  def visit_splat_node(node); end

  # Dispatch enter and leave events for StatementsNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2136
  def visit_statements_node(node); end

  # Dispatch enter and leave events for StringNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2142
  def visit_string_node(node); end

  # Dispatch enter and leave events for SuperNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2148
  def visit_super_node(node); end

  # Dispatch enter and leave events for SymbolNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2154
  def visit_symbol_node(node); end

  # Dispatch enter and leave events for TrueNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2160
  def visit_true_node(node); end

  # Dispatch enter and leave events for UndefNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2166
  def visit_undef_node(node); end

  # Dispatch enter and leave events for UnlessNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2172
  def visit_unless_node(node); end

  # Dispatch enter and leave events for UntilNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2178
  def visit_until_node(node); end

  # Dispatch enter and leave events for WhenNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2184
  def visit_when_node(node); end

  # Dispatch enter and leave events for WhileNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2190
  def visit_while_node(node); end

  # Dispatch enter and leave events for XStringNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2196
  def visit_x_string_node(node); end

  # Dispatch enter and leave events for YieldNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2202
  def visit_yield_node(node); end
end

# This visitor provides the ability to call Node#to_dot, which converts a
# subtree into a graphviz dot graph.
#
# source://prism//lib/prism/dot_visitor.rb#18
class Prism::DotVisitor < ::Prism::Visitor
  # Initialize a new dot visitor.
  #
  # @return [DotVisitor] a new instance of DotVisitor
  #
  # source://prism//lib/prism/dot_visitor.rb#110
  def initialize; end

  # The digraph that is being built.
  #
  # source://prism//lib/prism/dot_visitor.rb#107
  def digraph; end

  # Convert this visitor into a graphviz dot graph string.
  #
  # source://prism//lib/prism/dot_visitor.rb#115
  def to_dot; end

  # Visit a AliasGlobalVariableNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#120
  def visit_alias_global_variable_node(node); end

  # Visit a AliasMethodNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#145
  def visit_alias_method_node(node); end

  # Visit a AlternationPatternNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#170
  def visit_alternation_pattern_node(node); end

  # Visit a AndNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#195
  def visit_and_node(node); end

  # Visit a ArgumentsNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#220
  def visit_arguments_node(node); end

  # Visit a ArrayNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#250
  def visit_array_node(node); end

  # Visit a ArrayPatternNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#290
  def visit_array_pattern_node(node); end

  # Visit a AssocNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#352
  def visit_assoc_node(node); end

  # Visit a AssocSplatNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#379
  def visit_assoc_splat_node(node); end

  # Visit a BackReferenceReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#402
  def visit_back_reference_read_node(node); end

  # Visit a BeginNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#419
  def visit_begin_node(node); end

  # Visit a BlockArgumentNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#467
  def visit_block_argument_node(node); end

  # Visit a BlockLocalVariableNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#490
  def visit_block_local_variable_node(node); end

  # Visit a BlockNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#510
  def visit_block_node(node); end

  # Visit a BlockParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#545
  def visit_block_parameter_node(node); end

  # Visit a BlockParametersNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#573
  def visit_block_parameters_node(node); end

  # Visit a BreakNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#616
  def visit_break_node(node); end

  # Visit a CallAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#639
  def visit_call_and_write_node(node); end

  # Visit a CallNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#685
  def visit_call_node(node); end

  # Visit a CallOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#748
  def visit_call_operator_write_node(node); end

  # Visit a CallOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#797
  def visit_call_or_write_node(node); end

  # Visit a CallTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#843
  def visit_call_target_node(node); end

  # Visit a CapturePatternNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#873
  def visit_capture_pattern_node(node); end

  # Visit a CaseMatchNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#898
  def visit_case_match_node(node); end

  # Visit a CaseNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#943
  def visit_case_node(node); end

  # Visit a ClassNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#988
  def visit_class_node(node); end

  # Visit a ClassVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1035
  def visit_class_variable_and_write_node(node); end

  # Visit a ClassVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1062
  def visit_class_variable_operator_write_node(node); end

  # Visit a ClassVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1092
  def visit_class_variable_or_write_node(node); end

  # Visit a ClassVariableReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1119
  def visit_class_variable_read_node(node); end

  # Visit a ClassVariableTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1136
  def visit_class_variable_target_node(node); end

  # Visit a ClassVariableWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1153
  def visit_class_variable_write_node(node); end

  # Visit a ConstantAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1180
  def visit_constant_and_write_node(node); end

  # Visit a ConstantOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1207
  def visit_constant_operator_write_node(node); end

  # Visit a ConstantOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1237
  def visit_constant_or_write_node(node); end

  # Visit a ConstantPathAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1264
  def visit_constant_path_and_write_node(node); end

  # Visit a ConstantPathNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1289
  def visit_constant_path_node(node); end

  # Visit a ConstantPathOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1318
  def visit_constant_path_operator_write_node(node); end

  # Visit a ConstantPathOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1346
  def visit_constant_path_or_write_node(node); end

  # Visit a ConstantPathTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1371
  def visit_constant_path_target_node(node); end

  # Visit a ConstantPathWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1400
  def visit_constant_path_write_node(node); end

  # Visit a ConstantReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1425
  def visit_constant_read_node(node); end

  # Visit a ConstantTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1442
  def visit_constant_target_node(node); end

  # Visit a ConstantWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1459
  def visit_constant_write_node(node); end

  # Visit a DefNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1486
  def visit_def_node(node); end

  # Visit a DefinedNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1555
  def visit_defined_node(node); end

  # Visit a ElseNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1586
  def visit_else_node(node); end

  # Visit a EmbeddedStatementsNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1614
  def visit_embedded_statements_node(node); end

  # Visit a EmbeddedVariableNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1640
  def visit_embedded_variable_node(node); end

  # Visit a EnsureNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1661
  def visit_ensure_node(node); end

  # Visit a FalseNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1687
  def visit_false_node(node); end

  # Visit a FindPatternNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1701
  def visit_find_pattern_node(node); end

  # Visit a FlipFlopNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1752
  def visit_flip_flop_node(node); end

  # Visit a FloatNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1784
  def visit_float_node(node); end

  # Visit a ForNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1801
  def visit_for_node(node); end

  # Visit a ForwardingArgumentsNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1843
  def visit_forwarding_arguments_node(node); end

  # Visit a ForwardingParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1857
  def visit_forwarding_parameter_node(node); end

  # Visit a ForwardingSuperNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1871
  def visit_forwarding_super_node(node); end

  # Visit a GlobalVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1891
  def visit_global_variable_and_write_node(node); end

  # Visit a GlobalVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1918
  def visit_global_variable_operator_write_node(node); end

  # Visit a GlobalVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1948
  def visit_global_variable_or_write_node(node); end

  # Visit a GlobalVariableReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1975
  def visit_global_variable_read_node(node); end

  # Visit a GlobalVariableTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1992
  def visit_global_variable_target_node(node); end

  # Visit a GlobalVariableWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2009
  def visit_global_variable_write_node(node); end

  # Visit a HashNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2036
  def visit_hash_node(node); end

  # Visit a HashPatternNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2069
  def visit_hash_pattern_node(node); end

  # Visit a IfNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2118
  def visit_if_node(node); end

  # Visit a ImaginaryNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2163
  def visit_imaginary_node(node); end

  # Visit a ImplicitNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2181
  def visit_implicit_node(node); end

  # Visit a ImplicitRestNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2199
  def visit_implicit_rest_node(node); end

  # Visit a InNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2213
  def visit_in_node(node); end

  # Visit a IndexAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2245
  def visit_index_and_write_node(node); end

  # Visit a IndexOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2298
  def visit_index_operator_write_node(node); end

  # Visit a IndexOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2354
  def visit_index_or_write_node(node); end

  # Visit a IndexTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2407
  def visit_index_target_node(node); end

  # Visit a InstanceVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2446
  def visit_instance_variable_and_write_node(node); end

  # Visit a InstanceVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2473
  def visit_instance_variable_operator_write_node(node); end

  # Visit a InstanceVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2503
  def visit_instance_variable_or_write_node(node); end

  # Visit a InstanceVariableReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2530
  def visit_instance_variable_read_node(node); end

  # Visit a InstanceVariableTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2547
  def visit_instance_variable_target_node(node); end

  # Visit a InstanceVariableWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2564
  def visit_instance_variable_write_node(node); end

  # Visit a IntegerNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2591
  def visit_integer_node(node); end

  # Visit a InterpolatedMatchLastLineNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2611
  def visit_interpolated_match_last_line_node(node); end

  # Visit a InterpolatedRegularExpressionNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2647
  def visit_interpolated_regular_expression_node(node); end

  # Visit a InterpolatedStringNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2683
  def visit_interpolated_string_node(node); end

  # Visit a InterpolatedSymbolNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2723
  def visit_interpolated_symbol_node(node); end

  # Visit a InterpolatedXStringNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2760
  def visit_interpolated_x_string_node(node); end

  # Visit a ItLocalVariableReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2793
  def visit_it_local_variable_read_node(node); end

  # Visit a ItParametersNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2807
  def visit_it_parameters_node(node); end

  # Visit a KeywordHashNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2821
  def visit_keyword_hash_node(node); end

  # Visit a KeywordRestParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2851
  def visit_keyword_rest_parameter_node(node); end

  # Visit a LambdaNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2879
  def visit_lambda_node(node); end

  # Visit a LocalVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2917
  def visit_local_variable_and_write_node(node); end

  # Visit a LocalVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2947
  def visit_local_variable_operator_write_node(node); end

  # Visit a LocalVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2980
  def visit_local_variable_or_write_node(node); end

  # Visit a LocalVariableReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3010
  def visit_local_variable_read_node(node); end

  # Visit a LocalVariableTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3030
  def visit_local_variable_target_node(node); end

  # Visit a LocalVariableWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3050
  def visit_local_variable_write_node(node); end

  # Visit a MatchLastLineNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3080
  def visit_match_last_line_node(node); end

  # Visit a MatchPredicateNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3109
  def visit_match_predicate_node(node); end

  # Visit a MatchRequiredNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3134
  def visit_match_required_node(node); end

  # Visit a MatchWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3159
  def visit_match_write_node(node); end

  # Visit a MissingNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3190
  def visit_missing_node(node); end

  # Visit a ModuleNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3204
  def visit_module_node(node); end

  # Visit a MultiTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3240
  def visit_multi_target_node(node); end

  # Visit a MultiWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3296
  def visit_multi_write_node(node); end

  # Visit a NextNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3359
  def visit_next_node(node); end

  # Visit a NilNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3382
  def visit_nil_node(node); end

  # Visit a NoKeywordsParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3396
  def visit_no_keywords_parameter_node(node); end

  # Visit a NumberedParametersNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3416
  def visit_numbered_parameters_node(node); end

  # Visit a NumberedReferenceReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3433
  def visit_numbered_reference_read_node(node); end

  # Visit a OptionalKeywordParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3450
  def visit_optional_keyword_parameter_node(node); end

  # Visit a OptionalParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3477
  def visit_optional_parameter_node(node); end

  # Visit a OrNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3507
  def visit_or_node(node); end

  # Visit a ParametersNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3532
  def visit_parameters_node(node); end

  # Visit a ParenthesesNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3616
  def visit_parentheses_node(node); end

  # Visit a PinnedExpressionNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3645
  def visit_pinned_expression_node(node); end

  # Visit a PinnedVariableNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3672
  def visit_pinned_variable_node(node); end

  # Visit a PostExecutionNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3693
  def visit_post_execution_node(node); end

  # Visit a PreExecutionNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3722
  def visit_pre_execution_node(node); end

  # Visit a ProgramNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3751
  def visit_program_node(node); end

  # Visit a RangeNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3772
  def visit_range_node(node); end

  # Visit a RationalNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3804
  def visit_rational_node(node); end

  # Visit a RedoNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3827
  def visit_redo_node(node); end

  # Visit a RegularExpressionNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3841
  def visit_regular_expression_node(node); end

  # Visit a RequiredKeywordParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3870
  def visit_required_keyword_parameter_node(node); end

  # Visit a RequiredParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3893
  def visit_required_parameter_node(node); end

  # Visit a RescueModifierNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3913
  def visit_rescue_modifier_node(node); end

  # Visit a RescueNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3938
  def visit_rescue_node(node); end

  # Visit a RestParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3996
  def visit_rest_parameter_node(node); end

  # Visit a RetryNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4024
  def visit_retry_node(node); end

  # Visit a ReturnNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4038
  def visit_return_node(node); end

  # Visit a SelfNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4061
  def visit_self_node(node); end

  # Visit a ShareableConstantNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4075
  def visit_shareable_constant_node(node); end

  # Visit a SingletonClassNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4096
  def visit_singleton_class_node(node); end

  # Visit a SourceEncodingNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4132
  def visit_source_encoding_node(node); end

  # Visit a SourceFileNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4146
  def visit_source_file_node(node); end

  # Visit a SourceLineNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4166
  def visit_source_line_node(node); end

  # Visit a SplatNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4180
  def visit_splat_node(node); end

  # Visit a StatementsNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4203
  def visit_statements_node(node); end

  # Visit a StringNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4230
  def visit_string_node(node); end

  # Visit a SuperNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4263
  def visit_super_node(node); end

  # Visit a SymbolNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4302
  def visit_symbol_node(node); end

  # Visit a TrueNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4337
  def visit_true_node(node); end

  # Visit a UndefNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4351
  def visit_undef_node(node); end

  # Visit a UnlessNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4381
  def visit_unless_node(node); end

  # Visit a UntilNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4424
  def visit_until_node(node); end

  # Visit a WhenNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4464
  def visit_when_node(node); end

  # Visit a WhileNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4505
  def visit_while_node(node); end

  # Visit a XStringNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4545
  def visit_x_string_node(node); end

  # Visit a YieldNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4574
  def visit_yield_node(node); end

  private

  # Inspect a node that has arguments_node_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4620
  def arguments_node_flags_inspect(node); end

  # Inspect a node that has array_node_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4632
  def array_node_flags_inspect(node); end

  # Inspect a node that has call_node_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4640
  def call_node_flags_inspect(node); end

  # Inspect a node that has encoding_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4651
  def encoding_flags_inspect(node); end

  # Inspect a node that has integer_base_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4660
  def integer_base_flags_inspect(node); end

  # Inspect a node that has interpolated_string_node_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4671
  def interpolated_string_node_flags_inspect(node); end

  # Inspect a node that has keyword_hash_node_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4680
  def keyword_hash_node_flags_inspect(node); end

  # Inspect a location to display the start and end line and column numbers.
  #
  # source://prism//lib/prism/dot_visitor.rb#4614
  def location_inspect(location); end

  # Inspect a node that has loop_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4688
  def loop_flags_inspect(node); end

  # Generate a unique node ID for a node throughout the digraph.
  #
  # source://prism//lib/prism/dot_visitor.rb#4609
  def node_id(node); end

  # Inspect a node that has parameter_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4696
  def parameter_flags_inspect(node); end

  # Inspect a node that has parentheses_node_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4704
  def parentheses_node_flags_inspect(node); end

  # Inspect a node that has range_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4712
  def range_flags_inspect(node); end

  # Inspect a node that has regular_expression_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4720
  def regular_expression_flags_inspect(node); end

  # Inspect a node that has shareable_constant_node_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4738
  def shareable_constant_node_flags_inspect(node); end

  # Inspect a node that has string_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4748
  def string_flags_inspect(node); end

  # Inspect a node that has symbol_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4759
  def symbol_flags_inspect(node); end
end

# source://prism//lib/prism/dot_visitor.rb#63
class Prism::DotVisitor::Digraph
  # @return [Digraph] a new instance of Digraph
  #
  # source://prism//lib/prism/dot_visitor.rb#66
  def initialize; end

  # source://prism//lib/prism/dot_visitor.rb#80
  def edge(value); end

  # Returns the value of attribute edges.
  #
  # source://prism//lib/prism/dot_visitor.rb#64
  def edges; end

  # source://prism//lib/prism/dot_visitor.rb#72
  def node(value); end

  # Returns the value of attribute nodes.
  #
  # source://prism//lib/prism/dot_visitor.rb#64
  def nodes; end

  # source://prism//lib/prism/dot_visitor.rb#84
  def to_dot; end

  # source://prism//lib/prism/dot_visitor.rb#76
  def waypoint(value); end

  # Returns the value of attribute waypoints.
  #
  # source://prism//lib/prism/dot_visitor.rb#64
  def waypoints; end
end

# source://prism//lib/prism/dot_visitor.rb#19
class Prism::DotVisitor::Field
  # @return [Field] a new instance of Field
  #
  # source://prism//lib/prism/dot_visitor.rb#22
  def initialize(name, value, port); end

  # Returns the value of attribute name.
  #
  # source://prism//lib/prism/dot_visitor.rb#20
  def name; end

  # Returns the value of attribute port.
  #
  # source://prism//lib/prism/dot_visitor.rb#20
  def port; end

  # source://prism//lib/prism/dot_visitor.rb#28
  def to_dot; end

  # Returns the value of attribute value.
  #
  # source://prism//lib/prism/dot_visitor.rb#20
  def value; end
end

# source://prism//lib/prism/dot_visitor.rb#37
class Prism::DotVisitor::Table
  # @return [Table] a new instance of Table
  #
  # source://prism//lib/prism/dot_visitor.rb#40
  def initialize(name); end

  # source://prism//lib/prism/dot_visitor.rb#45
  def field(name, value = T.unsafe(nil), port: T.unsafe(nil)); end

  # Returns the value of attribute fields.
  #
  # source://prism//lib/prism/dot_visitor.rb#38
  def fields; end

  # Returns the value of attribute name.
  #
  # source://prism//lib/prism/dot_visitor.rb#38
  def name; end

  # source://prism//lib/prism/dot_visitor.rb#49
  def to_dot; end
end

# Represents an `else` clause in a `case`, `if`, or `unless` statement.
#
#     if a then b else c end
#                 ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#6717
class Prism::ElseNode < ::Prism::Node
  # Initialize a new ElseNode node.
  #
  # @return [ElseNode] a new instance of ElseNode
  #
  # source://prism//lib/prism/node.rb#6719
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      else_keyword_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      end_keyword_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, else_keyword_loc, statements, end_keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#6833
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6730
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#6735
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6754
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6747
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?else_keyword_loc: Location, ?statements: StatementsNode?, ?end_keyword_loc: Location?) -> ElseNode
  #
  # source://prism//lib/prism/node.rb#6759
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      else_keyword_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::ElseNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), else_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#6764
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, else_keyword_loc: Location, statements: StatementsNode?, end_keyword_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#6767
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [statements]
  #
  # source://prism//lib/prism/node.rb#6740
  def each_child_node; end

  # def else_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#6807
  sig { returns(String) }
  def else_keyword; end

  # attr_reader else_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#6772
  sig { returns(Prism::Location) }
  def else_keyword_loc; end

  # def end_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#6812
  sig { returns(T.nilable(String)) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location?
  #
  # source://prism//lib/prism/node.rb#6788
  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#6817
  sig { override.returns(String) }
  def inspect; end

  # Save the else_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#6780
  def save_else_keyword_loc(repository); end

  # Save the end_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#6802
  def save_end_keyword_loc(repository); end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#6785
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#6822
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#6827
    def type; end
  end
end

# EmbDocComment objects correspond to comments that are surrounded by =begin
# and =end.
#
# source://prism//lib/prism/parse_result.rb#558
class Prism::EmbDocComment < ::Prism::Comment
  # Returns a string representation of this comment.
  #
  # source://prism//lib/prism/parse_result.rb#565
  sig { returns(String) }
  def inspect; end

  # This can only be true for inline comments.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result.rb#560
  sig { override.returns(T::Boolean) }
  def trailing?; end
end

# Represents an interpolated set of statements.
#
#     "foo #{bar}"
#          ^^^^^^
#
# source://prism//lib/prism/node.rb#6845
class Prism::EmbeddedStatementsNode < ::Prism::Node
  # Initialize a new EmbeddedStatementsNode node.
  #
  # @return [EmbeddedStatementsNode] a new instance of EmbeddedStatementsNode
  #
  # source://prism//lib/prism/node.rb#6847
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, statements, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#6955
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6858
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#6863
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#6934
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#6916
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6882
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6875
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location, ?statements: StatementsNode?, ?closing_loc: Location) -> EmbeddedStatementsNode
  #
  # source://prism//lib/prism/node.rb#6887
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      closing_loc: Prism::Location
    ).returns(Prism::EmbeddedStatementsNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), statements: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#6892
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location, statements: StatementsNode?, closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#6895
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [statements]
  #
  # source://prism//lib/prism/node.rb#6868
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#6939
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#6929
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#6900
  sig { returns(Prism::Location) }
  def opening_loc; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#6924
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#6908
  def save_opening_loc(repository); end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#6913
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#6944
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#6949
    def type; end
  end
end

# Represents an interpolated variable.
#
#     "foo #@bar"
#          ^^^^^
#
# source://prism//lib/prism/node.rb#6967
class Prism::EmbeddedVariableNode < ::Prism::Node
  # Initialize a new EmbeddedVariableNode node.
  #
  # @return [EmbeddedVariableNode] a new instance of EmbeddedVariableNode
  #
  # source://prism//lib/prism/node.rb#6969
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      operator_loc: Prism::Location,
      variable: T.any(Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)
    ).void
  end
  def initialize(source, node_id, location, flags, operator_loc, variable); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#7056
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6979
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#6984
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7001
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6996
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?operator_loc: Location, ?variable: InstanceVariableReadNode | ClassVariableReadNode | GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode) -> EmbeddedVariableNode
  #
  # source://prism//lib/prism/node.rb#7006
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      operator_loc: Prism::Location,
      variable: T.any(Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)
    ).returns(Prism::EmbeddedVariableNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), operator_loc: T.unsafe(nil), variable: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#7011
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, operator_loc: Location, variable: InstanceVariableReadNode | ClassVariableReadNode | GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode }
  #
  # source://prism//lib/prism/node.rb#7014
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [variable]
  #
  # source://prism//lib/prism/node.rb#6989
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7040
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#7035
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#7019
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#7027
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7045
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader variable: InstanceVariableReadNode | ClassVariableReadNode | GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode
  #
  # source://prism//lib/prism/node.rb#7032
  sig do
    returns(T.any(Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode))
  end
  def variable; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7050
    def type; end
  end
end

# Flags for nodes that have unescaped content.
#
# source://prism//lib/prism/node.rb#19819
module Prism::EncodingFlags; end

# internal bytes forced the encoding to binary
#
# source://prism//lib/prism/node.rb#19824
Prism::EncodingFlags::FORCED_BINARY_ENCODING = T.let(T.unsafe(nil), Integer)

# internal bytes forced the encoding to UTF-8
#
# source://prism//lib/prism/node.rb#19821
Prism::EncodingFlags::FORCED_UTF8_ENCODING = T.let(T.unsafe(nil), Integer)

# Represents an `ensure` clause in a `begin` statement.
#
#     begin
#       foo
#     ensure
#     ^^^^^^
#       bar
#     end
#
# source://prism//lib/prism/node.rb#7071
class Prism::EnsureNode < ::Prism::Node
  # Initialize a new EnsureNode node.
  #
  # @return [EnsureNode] a new instance of EnsureNode
  #
  # source://prism//lib/prism/node.rb#7073
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      ensure_keyword_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      end_keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, ensure_keyword_loc, statements, end_keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#7181
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7084
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#7089
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7108
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7101
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?ensure_keyword_loc: Location, ?statements: StatementsNode?, ?end_keyword_loc: Location) -> EnsureNode
  #
  # source://prism//lib/prism/node.rb#7113
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      ensure_keyword_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      end_keyword_loc: Prism::Location
    ).returns(Prism::EnsureNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), ensure_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#7118
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, ensure_keyword_loc: Location, statements: StatementsNode?, end_keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#7121
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [statements]
  #
  # source://prism//lib/prism/node.rb#7094
  def each_child_node; end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#7160
  sig { returns(String) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#7142
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  # def ensure_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#7155
  sig { returns(String) }
  def ensure_keyword; end

  # attr_reader ensure_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#7126
  sig { returns(Prism::Location) }
  def ensure_keyword_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7165
  sig { override.returns(String) }
  def inspect; end

  # Save the end_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#7150
  def save_end_keyword_loc(repository); end

  # Save the ensure_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#7134
  def save_ensure_keyword_loc(repository); end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#7139
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7170
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7175
    def type; end
  end
end

# Represents the use of the literal `false` keyword.
#
#     false
#     ^^^^^
#
# source://prism//lib/prism/node.rb#7193
class Prism::FalseNode < ::Prism::Node
  # Initialize a new FalseNode node.
  #
  # @return [FalseNode] a new instance of FalseNode
  #
  # source://prism//lib/prism/node.rb#7195
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#7258
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7203
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#7208
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7224
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7219
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> FalseNode
  #
  # source://prism//lib/prism/node.rb#7229
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::FalseNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#7234
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#7237
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#7213
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7242
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7247
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7252
    def type; end
  end
end

# Represents a find pattern in pattern matching.
#
#     foo in *bar, baz, *qux
#            ^^^^^^^^^^^^^^^
#
#     foo in [*bar, baz, *qux]
#            ^^^^^^^^^^^^^^^^^
#
#     foo in Foo(*bar, baz, *qux)
#            ^^^^^^^^^^^^^^^^^^^^
#
#     foo => *bar, baz, *qux
#            ^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#7276
class Prism::FindPatternNode < ::Prism::Node
  # Initialize a new FindPatternNode node.
  #
  # @return [FindPatternNode] a new instance of FindPatternNode
  #
  # source://prism//lib/prism/node.rb#7278
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantPathNode, Prism::ConstantReadNode)),
      left: Prism::SplatNode,
      requireds: T::Array[Prism::Node],
      right: T.any(Prism::SplatNode, Prism::MissingNode),
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, constant, left, requireds, right, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#7449
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7292
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#7297
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#7428
  sig { returns(T.nilable(String)) }
  def closing; end

  # The location of the closing brace.
  #
  #     foo in [*bar, baz, *qux]
  #                            ^
  #
  #     foo in Foo(*bar, baz, *qux)
  #                               ^
  #
  # source://prism//lib/prism/node.rb#7404
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7322
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7312
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # Represents the optional constant preceding the pattern
  #
  #     foo in Foo(*bar, baz, *qux)
  #            ^^^
  #
  # source://prism//lib/prism/node.rb#7343
  sig { returns(T.nilable(T.any(Prism::ConstantPathNode, Prism::ConstantReadNode))) }
  def constant; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?constant: ConstantPathNode | ConstantReadNode | nil, ?left: SplatNode, ?requireds: Array[Prism::node], ?right: SplatNode | MissingNode, ?opening_loc: Location?, ?closing_loc: Location?) -> FindPatternNode
  #
  # source://prism//lib/prism/node.rb#7327
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantPathNode, Prism::ConstantReadNode)),
      left: Prism::SplatNode,
      requireds: T::Array[Prism::Node],
      right: T.any(Prism::SplatNode, Prism::MissingNode),
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::FindPatternNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), constant: T.unsafe(nil), left: T.unsafe(nil), requireds: T.unsafe(nil), right: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#7332
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, constant: ConstantPathNode | ConstantReadNode | nil, left: SplatNode, requireds: Array[Prism::node], right: SplatNode | MissingNode, opening_loc: Location?, closing_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#7335
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [constant]
  #
  # source://prism//lib/prism/node.rb#7302
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7433
  sig { override.returns(String) }
  def inspect; end

  # Represents the first wildcard node in the pattern.
  #
  #     foo in *bar, baz, *qux
  #            ^^^^
  #
  #     foo in Foo(*bar, baz, *qux)
  #                ^^^^
  #
  # source://prism//lib/prism/node.rb#7352
  sig { returns(Prism::SplatNode) }
  def left; end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#7423
  sig { returns(T.nilable(String)) }
  def opening; end

  # The location of the opening brace.
  #
  #     foo in [*bar, baz, *qux]
  #            ^
  #
  #     foo in Foo(*bar, baz, *qux)
  #               ^
  #
  # source://prism//lib/prism/node.rb#7379
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # Represents the nodes in between the wildcards.
  #
  #     foo in *bar, baz, *qux
  #                  ^^^
  #
  #     foo in Foo(*bar, baz, 1, *qux)
  #                      ^^^^^^
  #
  # source://prism//lib/prism/node.rb#7361
  sig { returns(T::Array[Prism::Node]) }
  def requireds; end

  # Represents the second wildcard node in the pattern.
  #
  #     foo in *bar, baz, *qux
  #                       ^^^^
  #
  #     foo in Foo(*bar, baz, *qux)
  #                           ^^^^
  #
  # source://prism//lib/prism/node.rb#7370
  sig { returns(T.any(Prism::SplatNode, Prism::MissingNode)) }
  def right; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#7418
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#7393
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7438
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7443
    def type; end
  end
end

# Represents the use of the `..` or `...` operators to create flip flops.
#
#     baz if foo .. bar
#            ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#7465
class Prism::FlipFlopNode < ::Prism::Node
  # Initialize a new FlipFlopNode node.
  #
  # @return [FlipFlopNode] a new instance of FlipFlopNode
  #
  # source://prism//lib/prism/node.rb#7467
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: T.nilable(Prism::Node),
      right: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, left, right, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#7567
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7478
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#7483
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7504
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7496
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?left: Prism::node?, ?right: Prism::node?, ?operator_loc: Location) -> FlipFlopNode
  #
  # source://prism//lib/prism/node.rb#7509
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: T.nilable(Prism::Node),
      right: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).returns(Prism::FlipFlopNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#7514
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, left: Prism::node?, right: Prism::node?, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#7517
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [left]
  #
  # source://prism//lib/prism/node.rb#7488
  def each_child_node; end

  # def exclude_end?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#7522
  sig { returns(T::Boolean) }
  def exclude_end?; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7551
  sig { override.returns(String) }
  def inspect; end

  # attr_reader left: Prism::node?
  #
  # source://prism//lib/prism/node.rb#7527
  sig { returns(T.nilable(Prism::Node)) }
  def left; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#7546
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#7533
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader right: Prism::node?
  #
  # source://prism//lib/prism/node.rb#7530
  sig { returns(T.nilable(Prism::Node)) }
  def right; end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#7541
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7556
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7561
    def type; end
  end
end

# Represents a floating point number literal.
#
#     1.0
#     ^^^
#
# source://prism//lib/prism/node.rb#7580
class Prism::FloatNode < ::Prism::Node
  # Initialize a new FloatNode node.
  #
  # @return [FloatNode] a new instance of FloatNode
  #
  # source://prism//lib/prism/node.rb#7582
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, value: Float).void }
  def initialize(source, node_id, location, flags, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#7649
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7591
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#7596
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7612
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7607
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?value: Float) -> FloatNode
  #
  # source://prism//lib/prism/node.rb#7617
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, value: Float).returns(Prism::FloatNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#7622
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, value: Float }
  #
  # source://prism//lib/prism/node.rb#7625
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#7601
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7633
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7638
  sig { override.returns(Symbol) }
  def type; end

  # The value of the floating point number as a Float.
  #
  # source://prism//lib/prism/node.rb#7630
  sig { returns(Float) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7643
    def type; end
  end
end

# Represents the use of the `for` keyword.
#
#     for i in a end
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#7659
class Prism::ForNode < ::Prism::Node
  # Initialize a new ForNode node.
  #
  # @return [ForNode] a new instance of ForNode
  #
  # source://prism//lib/prism/node.rb#7661
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      index: T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode),
      collection: Prism::Node,
      statements: T.nilable(Prism::StatementsNode),
      for_keyword_loc: Prism::Location,
      in_keyword_loc: Prism::Location,
      do_keyword_loc: T.nilable(Prism::Location),
      end_keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, index, collection, statements, for_keyword_loc, in_keyword_loc, do_keyword_loc, end_keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#7848
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7676
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#7681
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # The collection to iterate over.
  #
  #     for i in a end
  #              ^
  #
  # source://prism//lib/prism/node.rb#7731
  sig { returns(Prism::Node) }
  def collection; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7704
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7695
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?index: LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | BackReferenceReadNode | NumberedReferenceReadNode | MissingNode, ?collection: Prism::node, ?statements: StatementsNode?, ?for_keyword_loc: Location, ?in_keyword_loc: Location, ?do_keyword_loc: Location?, ?end_keyword_loc: Location) -> ForNode
  #
  # source://prism//lib/prism/node.rb#7709
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      index: T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode),
      collection: Prism::Node,
      statements: T.nilable(Prism::StatementsNode),
      for_keyword_loc: Prism::Location,
      in_keyword_loc: Prism::Location,
      do_keyword_loc: T.nilable(Prism::Location),
      end_keyword_loc: Prism::Location
    ).returns(Prism::ForNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), index: T.unsafe(nil), collection: T.unsafe(nil), statements: T.unsafe(nil), for_keyword_loc: T.unsafe(nil), in_keyword_loc: T.unsafe(nil), do_keyword_loc: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#7714
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, index: LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | BackReferenceReadNode | NumberedReferenceReadNode | MissingNode, collection: Prism::node, statements: StatementsNode?, for_keyword_loc: Location, in_keyword_loc: Location, do_keyword_loc: Location?, end_keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#7717
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def do_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#7822
  sig { returns(T.nilable(String)) }
  def do_keyword; end

  # The location of the `do` keyword, if present.
  #
  #     for i in a do end
  #                ^^
  #
  # source://prism//lib/prism/node.rb#7777
  sig { returns(T.nilable(Prism::Location)) }
  def do_keyword_loc; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [index]
  #
  # source://prism//lib/prism/node.rb#7686
  def each_child_node; end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#7827
  sig { returns(String) }
  def end_keyword; end

  # The location of the `end` keyword.
  #
  #     for i in a end
  #                ^^^
  #
  # source://prism//lib/prism/node.rb#7799
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def for_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#7812
  sig { returns(String) }
  def for_keyword; end

  # The location of the `for` keyword.
  #
  #     for i in a end
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#7745
  sig { returns(Prism::Location) }
  def for_keyword_loc; end

  # def in_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#7817
  sig { returns(String) }
  def in_keyword; end

  # The location of the `in` keyword.
  #
  #     for i in a end
  #           ^^
  #
  # source://prism//lib/prism/node.rb#7761
  sig { returns(Prism::Location) }
  def in_keyword_loc; end

  # The index expression for `for` loops.
  #
  #     for i in a end
  #         ^
  #
  # source://prism//lib/prism/node.rb#7725
  sig do
    returns(T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode))
  end
  def index; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7832
  sig { override.returns(String) }
  def inspect; end

  # Save the do_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#7791
  def save_do_keyword_loc(repository); end

  # Save the end_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#7807
  def save_end_keyword_loc(repository); end

  # Save the for_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#7753
  def save_for_keyword_loc(repository); end

  # Save the in_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#7769
  def save_in_keyword_loc(repository); end

  # Represents the body of statements to execute for each iteration of the loop.
  #
  #     for i in a
  #       foo(i)
  #       ^^^^^^
  #     end
  #
  # source://prism//lib/prism/node.rb#7739
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7837
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7842
    def type; end
  end
end

# Represents forwarding all arguments to this method to another method.
#
#     def foo(...)
#       bar(...)
#           ^^^
#     end
#
# source://prism//lib/prism/node.rb#7866
class Prism::ForwardingArgumentsNode < ::Prism::Node
  # Initialize a new ForwardingArgumentsNode node.
  #
  # @return [ForwardingArgumentsNode] a new instance of ForwardingArgumentsNode
  #
  # source://prism//lib/prism/node.rb#7868
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#7931
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7876
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#7881
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7897
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7892
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> ForwardingArgumentsNode
  #
  # source://prism//lib/prism/node.rb#7902
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ForwardingArgumentsNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#7907
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#7910
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#7886
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7915
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7920
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7925
    def type; end
  end
end

# Represents the use of the forwarding parameter in a method, block, or lambda declaration.
#
#     def foo(...)
#             ^^^
#     end
#
# source://prism//lib/prism/node.rb#7941
class Prism::ForwardingParameterNode < ::Prism::Node
  # Initialize a new ForwardingParameterNode node.
  #
  # @return [ForwardingParameterNode] a new instance of ForwardingParameterNode
  #
  # source://prism//lib/prism/node.rb#7943
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#8006
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7951
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#7956
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7972
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7967
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> ForwardingParameterNode
  #
  # source://prism//lib/prism/node.rb#7977
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ForwardingParameterNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#7982
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#7985
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#7961
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7990
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7995
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#8000
    def type; end
  end
end

# Represents the use of the `super` keyword without parentheses or arguments, but which might have a block.
#
#     super
#     ^^^^^
#
#     super { 123 }
#     ^^^^^^^^^^^^^
#
# If it has any other arguments, it would be a `SuperNode` instead.
#
# source://prism//lib/prism/node.rb#8020
class Prism::ForwardingSuperNode < ::Prism::Node
  # Initialize a new ForwardingSuperNode node.
  #
  # @return [ForwardingSuperNode] a new instance of ForwardingSuperNode
  #
  # source://prism//lib/prism/node.rb#8022
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      block: T.nilable(Prism::BlockNode)
    ).void
  end
  def initialize(source, node_id, location, flags, block); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#8092
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8031
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # All other arguments are forwarded as normal, except the original block is replaced with the new block.
  #
  # source://prism//lib/prism/node.rb#8073
  sig { returns(T.nilable(Prism::BlockNode)) }
  def block; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8036
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8055
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8048
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?block: BlockNode?) -> ForwardingSuperNode
  #
  # source://prism//lib/prism/node.rb#8060
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      block: T.nilable(Prism::BlockNode)
    ).returns(Prism::ForwardingSuperNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), block: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8065
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, block: BlockNode? }
  #
  # source://prism//lib/prism/node.rb#8068
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [block]
  #
  # source://prism//lib/prism/node.rb#8041
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#8076
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#8081
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#8086
    def type; end
  end
end

# Represents the use of the `&&=` operator for assignment to a global variable.
#
#     $target &&= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#8102
class Prism::GlobalVariableAndWriteNode < ::Prism::Node
  # Initialize a new GlobalVariableAndWriteNode node.
  #
  # @return [GlobalVariableAndWriteNode] a new instance of GlobalVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#8104
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#8209
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8116
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8121
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8138
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8133
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> GlobalVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#8143
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::GlobalVariableAndWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8148
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#8151
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#201
  def desugar; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#8126
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#8193
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#8156
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#8159
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#8188
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#8172
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#8167
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#8180
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#8198
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#8185
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#8203
    def type; end
  end
end

# Represents assigning to a global variable using an operator that isn't `=`.
#
#     $target += value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#8222
class Prism::GlobalVariableOperatorWriteNode < ::Prism::Node
  # Initialize a new GlobalVariableOperatorWriteNode node.
  #
  # @return [GlobalVariableOperatorWriteNode] a new instance of GlobalVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#8224
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, binary_operator_loc, value, binary_operator); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#8328
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8237
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader binary_operator: Symbol
  #
  # source://prism//lib/prism/node.rb#8309
  sig { returns(Symbol) }
  def binary_operator; end

  # attr_reader binary_operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#8293
  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8242
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8259
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8254
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?binary_operator_loc: Location, ?value: Prism::node, ?binary_operator: Symbol) -> GlobalVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#8264
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::GlobalVariableOperatorWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8269
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, binary_operator_loc: Location, value: Prism::node, binary_operator: Symbol }
  #
  # source://prism//lib/prism/node.rb#8272
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#213
  def desugar; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#8247
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#8312
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#8277
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#8280
  sig { returns(Prism::Location) }
  def name_loc; end

  # Returns the binary operator used to modify the receiver. This method is
  # deprecated in favor of #binary_operator.
  #
  # source://prism//lib/prism/node_ext.rb#406
  def operator; end

  # Returns the location of the binary operator used to modify the receiver.
  # This method is deprecated in favor of #binary_operator_loc.
  #
  # source://prism//lib/prism/node_ext.rb#413
  def operator_loc; end

  # Save the binary_operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#8301
  def save_binary_operator_loc(repository); end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#8288
  def save_name_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#8317
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#8306
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#8322
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to a global variable.
#
#     $target ||= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#8342
class Prism::GlobalVariableOrWriteNode < ::Prism::Node
  # Initialize a new GlobalVariableOrWriteNode node.
  #
  # @return [GlobalVariableOrWriteNode] a new instance of GlobalVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#8344
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#8449
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8356
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8361
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8378
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8373
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> GlobalVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#8383
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::GlobalVariableOrWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8388
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#8391
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#207
  def desugar; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#8366
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#8433
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#8396
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#8399
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#8428
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#8412
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#8407
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#8420
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#8438
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#8425
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#8443
    def type; end
  end
end

# Represents referencing a global variable.
#
#     $foo
#     ^^^^
#
# source://prism//lib/prism/node.rb#8462
class Prism::GlobalVariableReadNode < ::Prism::Node
  # Initialize a new GlobalVariableReadNode node.
  #
  # @return [GlobalVariableReadNode] a new instance of GlobalVariableReadNode
  #
  # source://prism//lib/prism/node.rb#8464
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#8535
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8473
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8478
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8494
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8489
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> GlobalVariableReadNode
  #
  # source://prism//lib/prism/node.rb#8499
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::GlobalVariableReadNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8504
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#8507
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#8483
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#8519
  sig { override.returns(String) }
  def inspect; end

  # The name of the global variable, which is a `$` followed by an [identifier](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#identifier). Alternatively, it can be one of the special global variables designated by a symbol.
  #
  #     $foo   # name `:$foo`
  #
  #     $_Test # name `:$_Test`
  #
  # source://prism//lib/prism/node.rb#8516
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#8524
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#8529
    def type; end
  end
end

# Represents writing to a global variable in a context that doesn't have an explicit value.
#
#     $foo, $bar = baz
#     ^^^^  ^^^^
#
# source://prism//lib/prism/node.rb#8545
class Prism::GlobalVariableTargetNode < ::Prism::Node
  # Initialize a new GlobalVariableTargetNode node.
  #
  # @return [GlobalVariableTargetNode] a new instance of GlobalVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#8547
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#8614
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8556
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8561
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8577
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8572
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> GlobalVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#8582
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::GlobalVariableTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8587
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#8590
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#8566
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#8598
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#8595
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#8603
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#8608
    def type; end
  end
end

# Represents writing to a global variable.
#
#     $foo = 1
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#8624
class Prism::GlobalVariableWriteNode < ::Prism::Node
  # Initialize a new GlobalVariableWriteNode node.
  #
  # @return [GlobalVariableWriteNode] a new instance of GlobalVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#8626
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, value, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#8747
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8638
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8643
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8660
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8655
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?value: Prism::node, ?operator_loc: Location) -> GlobalVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#8665
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::GlobalVariableWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8670
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, value: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#8673
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#8648
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#8731
  sig { override.returns(String) }
  def inspect; end

  # The name of the global variable, which is a `$` followed by an [identifier](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#identifier). Alternatively, it can be one of the special global variables designated by a symbol.
  #
  #     $foo = :bar  # name `:$foo`
  #
  #     $_Test = 123 # name `:$_Test`
  #
  # source://prism//lib/prism/node.rb#8682
  sig { returns(Symbol) }
  def name; end

  # The location of the global variable's name.
  #
  #     $foo = :bar
  #     ^^^^
  #
  # source://prism//lib/prism/node.rb#8688
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#8726
  sig { returns(String) }
  def operator; end

  # The location of the `=` operator.
  #
  #     $foo = :bar
  #          ^
  #
  # source://prism//lib/prism/node.rb#8713
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#8696
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#8721
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#8736
  sig { override.returns(Symbol) }
  def type; end

  # The value to write to the global variable. It can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     $foo = :bar
  #            ^^^^
  #
  #     $-xyz = 123
  #             ^^^
  #
  # source://prism//lib/prism/node.rb#8707
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#8741
    def type; end
  end
end

# Represents a hash literal.
#
#     { a => b }
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#8760
class Prism::HashNode < ::Prism::Node
  # Initialize a new HashNode node.
  #
  # @return [HashNode] a new instance of HashNode
  #
  # source://prism//lib/prism/node.rb#8762
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)],
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, elements, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#8880
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8773
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8778
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#8859
  sig { returns(String) }
  def closing; end

  # The location of the closing brace.
  #
  #     { a => b }
  #              ^
  #
  # source://prism//lib/prism/node.rb#8841
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8795
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8790
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location, ?elements: Array[AssocNode | AssocSplatNode], ?closing_loc: Location) -> HashNode
  #
  # source://prism//lib/prism/node.rb#8800
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)],
      closing_loc: Prism::Location
    ).returns(Prism::HashNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), elements: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8805
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location, elements: Array[AssocNode | AssocSplatNode], closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#8808
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#8783
  def each_child_node; end

  # The elements of the hash. These can be either `AssocNode`s or `AssocSplatNode`s.
  #
  #     { a: b }
  #       ^^^^
  #
  #     { **foo }
  #       ^^^^^
  #
  # source://prism//lib/prism/node.rb#8835
  sig { returns(T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)]) }
  def elements; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#8864
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#8854
  sig { returns(String) }
  def opening; end

  # The location of the opening brace.
  #
  #     { a => b }
  #     ^
  #
  # source://prism//lib/prism/node.rb#8816
  sig { returns(Prism::Location) }
  def opening_loc; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#8849
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#8824
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#8869
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#8874
    def type; end
  end
end

# Represents a hash pattern in pattern matching.
#
#     foo => { a: 1, b: 2 }
#            ^^^^^^^^^^^^^^
#
#     foo => { a: 1, b: 2, **c }
#            ^^^^^^^^^^^^^^^^^^^
#
#     foo => Bar[a: 1, b: 2]
#            ^^^^^^^^^^^^^^^
#
#     foo in { a: 1, b: 2 }
#            ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#8902
class Prism::HashPatternNode < ::Prism::Node
  # Initialize a new HashPatternNode node.
  #
  # @return [HashPatternNode] a new instance of HashPatternNode
  #
  # source://prism//lib/prism/node.rb#8904
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantPathNode, Prism::ConstantReadNode)),
      elements: T::Array[Prism::AssocNode],
      rest: T.nilable(T.any(Prism::AssocSplatNode, Prism::NoKeywordsParameterNode)),
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, constant, elements, rest, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#9066
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8917
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8922
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#9045
  sig { returns(T.nilable(String)) }
  def closing; end

  # The location of the closing brace.
  #
  #     foo => { a: 1 }
  #                   ^
  #
  #     foo => Bar[a: 1]
  #                    ^
  #
  # source://prism//lib/prism/node.rb#9021
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8945
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8936
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # Represents the optional constant preceding the Hash.
  #
  #     foo => Bar[a: 1, b: 2]
  #          ^^^
  #
  #     foo => Bar::Baz[a: 1, b: 2]
  #          ^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#8969
  sig { returns(T.nilable(T.any(Prism::ConstantPathNode, Prism::ConstantReadNode))) }
  def constant; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?constant: ConstantPathNode | ConstantReadNode | nil, ?elements: Array[AssocNode], ?rest: AssocSplatNode | NoKeywordsParameterNode | nil, ?opening_loc: Location?, ?closing_loc: Location?) -> HashPatternNode
  #
  # source://prism//lib/prism/node.rb#8950
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantPathNode, Prism::ConstantReadNode)),
      elements: T::Array[Prism::AssocNode],
      rest: T.nilable(T.any(Prism::AssocSplatNode, Prism::NoKeywordsParameterNode)),
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::HashPatternNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), constant: T.unsafe(nil), elements: T.unsafe(nil), rest: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#8955
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, constant: ConstantPathNode | ConstantReadNode | nil, elements: Array[AssocNode], rest: AssocSplatNode | NoKeywordsParameterNode | nil, opening_loc: Location?, closing_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#8958
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [constant]
  #
  # source://prism//lib/prism/node.rb#8927
  def each_child_node; end

  # Represents the explicit named hash keys and values.
  #
  #     foo => { a: 1, b:, ** }
  #              ^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#8975
  sig { returns(T::Array[Prism::AssocNode]) }
  def elements; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#9050
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#9040
  sig { returns(T.nilable(String)) }
  def opening; end

  # The location of the opening brace.
  #
  #     foo => { a: 1 }
  #            ^
  #
  #     foo => Bar[a: 1]
  #               ^
  #
  # source://prism//lib/prism/node.rb#8996
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # Represents the rest of the Hash keys and values. This can be named, unnamed, or explicitly forbidden via `**nil`, this last one results in a `NoKeywordsParameterNode`.
  #
  #     foo => { a: 1, b:, **c }
  #                        ^^^
  #
  #     foo => { a: 1, b:, ** }
  #                        ^^
  #
  #     foo => { a: 1, b:, **nil }
  #                        ^^^^^
  #
  # source://prism//lib/prism/node.rb#8987
  sig { returns(T.nilable(T.any(Prism::AssocSplatNode, Prism::NoKeywordsParameterNode))) }
  def rest; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#9035
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#9010
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#9055
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#9060
    def type; end
  end
end

# source://prism//lib/prism/node_ext.rb#55
module Prism::HeredocQuery
  # Returns true if this node was represented as a heredoc in the source code.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node_ext.rb#57
  def heredoc?; end
end

# Represents the use of the `if` keyword, either in the block form or the modifier form, or a ternary expression.
#
#     bar if foo
#     ^^^^^^^^^^
#
#     if foo then bar end
#     ^^^^^^^^^^^^^^^^^^^
#
#     foo ? bar : baz
#     ^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#9087
class Prism::IfNode < ::Prism::Node
  # Initialize a new IfNode node.
  #
  # @return [IfNode] a new instance of IfNode
  #
  # source://prism//lib/prism/node.rb#9089
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      if_keyword_loc: T.nilable(Prism::Location),
      predicate: Prism::Node,
      then_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      subsequent: T.nilable(T.any(Prism::ElseNode, Prism::IfNode)),
      end_keyword_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, if_keyword_loc, predicate, then_keyword_loc, statements, subsequent, end_keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#9292
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9103
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#9108
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9131
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9122
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # Returns the subsequent if/elsif/else clause of the if node. This method is
  # deprecated in favor of #subsequent.
  #
  # source://prism//lib/prism/node_ext.rb#488
  def consequent; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?if_keyword_loc: Location?, ?predicate: Prism::node, ?then_keyword_loc: Location?, ?statements: StatementsNode?, ?subsequent: ElseNode | IfNode | nil, ?end_keyword_loc: Location?) -> IfNode
  #
  # source://prism//lib/prism/node.rb#9136
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      if_keyword_loc: T.nilable(Prism::Location),
      predicate: Prism::Node,
      then_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      subsequent: T.nilable(T.any(Prism::ElseNode, Prism::IfNode)),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::IfNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), if_keyword_loc: T.unsafe(nil), predicate: T.unsafe(nil), then_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), subsequent: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#9141
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, if_keyword_loc: Location?, predicate: Prism::node, then_keyword_loc: Location?, statements: StatementsNode?, subsequent: ElseNode | IfNode | nil, end_keyword_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#9144
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [predicate]
  #
  # source://prism//lib/prism/node.rb#9113
  def each_child_node; end

  # def end_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#9271
  sig { returns(T.nilable(String)) }
  def end_keyword; end

  # The location of the `end` keyword if present, `nil` otherwise.
  #
  #     if foo
  #       bar
  #     end
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#9242
  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def if_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#9261
  sig { returns(T.nilable(String)) }
  def if_keyword; end

  # The location of the `if` keyword if present.
  #
  #     bar if foo
  #         ^^
  #
  # The `if_keyword_loc` field will be `nil` when the `IfNode` represents a ternary expression.
  #
  # source://prism//lib/prism/node.rb#9154
  sig { returns(T.nilable(Prism::Location)) }
  def if_keyword_loc; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#9276
  sig { override.returns(String) }
  def inspect; end

  # source://prism//lib/prism/parse_result/newlines.rb#92
  def newline_flag!(lines); end

  # The node for the condition the `IfNode` is testing.
  #
  #     if foo
  #        ^^^
  #       bar
  #     end
  #
  #     bar if foo
  #            ^^^
  #
  #     foo ? bar : baz
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#9184
  sig { returns(Prism::Node) }
  def predicate; end

  # Save the end_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#9256
  def save_end_keyword_loc(repository); end

  # Save the if_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#9168
  def save_if_keyword_loc(repository); end

  # Save the then_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#9207
  def save_then_keyword_loc(repository); end

  # Represents the body of statements that will be executed when the predicate is evaluated as truthy. Will be `nil` when no body is provided.
  #
  #     if foo
  #       bar
  #       ^^^
  #       baz
  #       ^^^
  #     end
  #
  # source://prism//lib/prism/node.rb#9219
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Represents an `ElseNode` or an `IfNode` when there is an `else` or an `elsif` in the `if` statement.
  #
  #     if foo
  #       bar
  #     elsif baz
  #     ^^^^^^^^^
  #       qux
  #       ^^^
  #     end
  #     ^^^
  #
  #     if foo then bar else baz end
  #                     ^^^^^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#9234
  sig { returns(T.nilable(T.any(Prism::ElseNode, Prism::IfNode))) }
  def subsequent; end

  # def then_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#9266
  sig { returns(T.nilable(String)) }
  def then_keyword; end

  # The location of the `then` keyword (if present) or the `?` in a ternary expression, `nil` otherwise.
  #
  #     if foo then bar end
  #            ^^^^
  #
  #     a ? b : c
  #       ^
  #
  # source://prism//lib/prism/node.rb#9193
  sig { returns(T.nilable(Prism::Location)) }
  def then_keyword_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#9281
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#9286
    def type; end
  end
end

# Represents an imaginary number literal.
#
#     1.0i
#     ^^^^
#
# source://prism//lib/prism/node.rb#9307
class Prism::ImaginaryNode < ::Prism::Node
  # Initialize a new ImaginaryNode node.
  #
  # @return [ImaginaryNode] a new instance of ImaginaryNode
  #
  # source://prism//lib/prism/node.rb#9309
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      numeric: T.any(Prism::FloatNode, Prism::IntegerNode, Prism::RationalNode)
    ).void
  end
  def initialize(source, node_id, location, flags, numeric); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#9377
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9318
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#9323
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9340
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9335
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?numeric: FloatNode | IntegerNode | RationalNode) -> ImaginaryNode
  #
  # source://prism//lib/prism/node.rb#9345
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      numeric: T.any(Prism::FloatNode, Prism::IntegerNode, Prism::RationalNode)
    ).returns(Prism::ImaginaryNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), numeric: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#9350
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, numeric: FloatNode | IntegerNode | RationalNode }
  #
  # source://prism//lib/prism/node.rb#9353
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [numeric]
  #
  # source://prism//lib/prism/node.rb#9328
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#9361
  sig { override.returns(String) }
  def inspect; end

  # attr_reader numeric: FloatNode | IntegerNode | RationalNode
  #
  # source://prism//lib/prism/node.rb#9358
  sig { returns(T.any(Prism::FloatNode, Prism::IntegerNode, Prism::RationalNode)) }
  def numeric; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#9366
  sig { override.returns(Symbol) }
  def type; end

  # Returns the value of the node as a Ruby Complex.
  #
  # source://prism//lib/prism/node_ext.rb#110
  sig { returns(Complex) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#9371
    def type; end
  end
end

# Represents a node that is implicitly being added to the tree but doesn't correspond directly to a node in the source.
#
#     { foo: }
#       ^^^^
#
#     { Foo: }
#       ^^^^
#
#     foo in { bar: }
#              ^^^^
#
# source://prism//lib/prism/node.rb#9393
class Prism::ImplicitNode < ::Prism::Node
  # Initialize a new ImplicitNode node.
  #
  # @return [ImplicitNode] a new instance of ImplicitNode
  #
  # source://prism//lib/prism/node.rb#9395
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: T.any(Prism::LocalVariableReadNode, Prism::CallNode, Prism::ConstantReadNode, Prism::LocalVariableTargetNode)
    ).void
  end
  def initialize(source, node_id, location, flags, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#9463
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9404
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#9409
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9426
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9421
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?value: LocalVariableReadNode | CallNode | ConstantReadNode | LocalVariableTargetNode) -> ImplicitNode
  #
  # source://prism//lib/prism/node.rb#9431
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: T.any(Prism::LocalVariableReadNode, Prism::CallNode, Prism::ConstantReadNode, Prism::LocalVariableTargetNode)
    ).returns(Prism::ImplicitNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#9436
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, value: LocalVariableReadNode | CallNode | ConstantReadNode | LocalVariableTargetNode }
  #
  # source://prism//lib/prism/node.rb#9439
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#9414
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#9447
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#9452
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: LocalVariableReadNode | CallNode | ConstantReadNode | LocalVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#9444
  sig do
    returns(T.any(Prism::LocalVariableReadNode, Prism::CallNode, Prism::ConstantReadNode, Prism::LocalVariableTargetNode))
  end
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#9457
    def type; end
  end
end

# Represents using a trailing comma to indicate an implicit rest parameter.
#
#     foo { |bar,| }
#               ^
#
#     foo in [bar,]
#                ^
#
#     for foo, in bar do end
#            ^
#
#     foo, = bar
#        ^
#
# source://prism//lib/prism/node.rb#9482
class Prism::ImplicitRestNode < ::Prism::Node
  # Initialize a new ImplicitRestNode node.
  #
  # @return [ImplicitRestNode] a new instance of ImplicitRestNode
  #
  # source://prism//lib/prism/node.rb#9484
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#9547
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9492
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#9497
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9513
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9508
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> ImplicitRestNode
  #
  # source://prism//lib/prism/node.rb#9518
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ImplicitRestNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#9523
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#9526
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#9502
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#9531
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#9536
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#9541
    def type; end
  end
end

# Represents the use of the `in` keyword in a case statement.
#
#     case a; in b then c end
#             ^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#9556
class Prism::InNode < ::Prism::Node
  # Initialize a new InNode node.
  #
  # @return [InNode] a new instance of InNode
  #
  # source://prism//lib/prism/node.rb#9558
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      pattern: Prism::Node,
      statements: T.nilable(Prism::StatementsNode),
      in_loc: Prism::Location,
      then_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, pattern, statements, in_loc, then_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#9678
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9570
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#9575
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9596
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9588
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?pattern: Prism::node, ?statements: StatementsNode?, ?in_loc: Location, ?then_loc: Location?) -> InNode
  #
  # source://prism//lib/prism/node.rb#9601
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      pattern: Prism::Node,
      statements: T.nilable(Prism::StatementsNode),
      in_loc: Prism::Location,
      then_loc: T.nilable(Prism::Location)
    ).returns(Prism::InNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), pattern: T.unsafe(nil), statements: T.unsafe(nil), in_loc: T.unsafe(nil), then_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#9606
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, pattern: Prism::node, statements: StatementsNode?, in_loc: Location, then_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#9609
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [pattern]
  #
  # source://prism//lib/prism/node.rb#9580
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def in: () -> String
  #
  # source://prism//lib/prism/node.rb#9652
  sig { returns(String) }
  def in; end

  # attr_reader in_loc: Location
  #
  # source://prism//lib/prism/node.rb#9620
  sig { returns(Prism::Location) }
  def in_loc; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#9662
  sig { override.returns(String) }
  def inspect; end

  # attr_reader pattern: Prism::node
  #
  # source://prism//lib/prism/node.rb#9614
  sig { returns(Prism::Node) }
  def pattern; end

  # Save the in_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#9628
  def save_in_loc(repository); end

  # Save the then_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#9647
  def save_then_loc(repository); end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#9617
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # def then: () -> String?
  #
  # source://prism//lib/prism/node.rb#9657
  sig { returns(T.nilable(String)) }
  def then; end

  # attr_reader then_loc: Location?
  #
  # source://prism//lib/prism/node.rb#9633
  sig { returns(T.nilable(Prism::Location)) }
  def then_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#9667
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#9672
    def type; end
  end
end

# Represents the use of the `&&=` operator on a call to the `[]` method.
#
#     foo.bar[baz] &&= value
#     ^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#9691
class Prism::IndexAndWriteNode < ::Prism::Node
  # Initialize a new IndexAndWriteNode node.
  #
  # @return [IndexAndWriteNode] a new instance of IndexAndWriteNode
  #
  # source://prism//lib/prism/node.rb#9693
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#9883
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9709
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#9812
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9767
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # attr_reader block: BlockArgumentNode?
  #
  # source://prism//lib/prism/node.rb#9828
  sig { returns(T.nilable(Prism::BlockArgumentNode)) }
  def block; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#9847
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # attr_reader call_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#9780
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#9714
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#9857
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#9815
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9739
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9729
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node?, ?call_operator_loc: Location?, ?opening_loc: Location, ?arguments: ArgumentsNode?, ?closing_loc: Location, ?block: BlockArgumentNode?, ?operator_loc: Location, ?value: Prism::node) -> IndexAndWriteNode
  #
  # source://prism//lib/prism/node.rb#9744
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::IndexAndWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#9749
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node?, call_operator_loc: Location?, opening_loc: Location, arguments: ArgumentsNode?, closing_loc: Location, block: BlockArgumentNode?, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#9752
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [receiver]
  #
  # source://prism//lib/prism/node.rb#9719
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9772
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#9867
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#9852
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#9799
  sig { returns(Prism::Location) }
  def opening_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#9862
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#9831
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader receiver: Prism::node?
  #
  # source://prism//lib/prism/node.rb#9777
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9757
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Save the call_operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#9794
  def save_call_operator_loc(repository); end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#9823
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#9807
  def save_opening_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#9839
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#9872
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#9844
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9762
  sig { returns(T::Boolean) }
  def variable_call?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#9877
    def type; end
  end
end

# Represents the use of an assignment operator on a call to `[]`.
#
#     foo.bar[baz] += value
#     ^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#9901
class Prism::IndexOperatorWriteNode < ::Prism::Node
  # Initialize a new IndexOperatorWriteNode node.
  #
  # @return [IndexOperatorWriteNode] a new instance of IndexOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#9903
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      binary_operator: Symbol,
      binary_operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, binary_operator, binary_operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10092
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9920
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#10023
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9978
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # attr_reader binary_operator: Symbol
  #
  # source://prism//lib/prism/node.rb#10042
  sig { returns(Symbol) }
  def binary_operator; end

  # attr_reader binary_operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#10045
  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  # attr_reader block: BlockArgumentNode?
  #
  # source://prism//lib/prism/node.rb#10039
  sig { returns(T.nilable(Prism::BlockArgumentNode)) }
  def block; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#10061
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # attr_reader call_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#9991
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#9925
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#10071
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#10026
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9950
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9940
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node?, ?call_operator_loc: Location?, ?opening_loc: Location, ?arguments: ArgumentsNode?, ?closing_loc: Location, ?block: BlockArgumentNode?, ?binary_operator: Symbol, ?binary_operator_loc: Location, ?value: Prism::node) -> IndexOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#9955
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      binary_operator: Symbol,
      binary_operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::IndexOperatorWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil), binary_operator: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#9960
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node?, call_operator_loc: Location?, opening_loc: Location, arguments: ArgumentsNode?, closing_loc: Location, block: BlockArgumentNode?, binary_operator: Symbol, binary_operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#9963
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [receiver]
  #
  # source://prism//lib/prism/node.rb#9930
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9983
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10076
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#10066
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#10010
  sig { returns(Prism::Location) }
  def opening_loc; end

  # Returns the binary operator used to modify the receiver. This method is
  # deprecated in favor of #binary_operator.
  #
  # source://prism//lib/prism/node_ext.rb#422
  def operator; end

  # Returns the location of the binary operator used to modify the receiver.
  # This method is deprecated in favor of #binary_operator_loc.
  #
  # source://prism//lib/prism/node_ext.rb#429
  def operator_loc; end

  # attr_reader receiver: Prism::node?
  #
  # source://prism//lib/prism/node.rb#9988
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9968
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Save the binary_operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#10053
  def save_binary_operator_loc(repository); end

  # Save the call_operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#10005
  def save_call_operator_loc(repository); end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#10034
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#10018
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10081
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#10058
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9973
  sig { returns(T::Boolean) }
  def variable_call?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10086
    def type; end
  end
end

# Represents the use of the `||=` operator on a call to `[]`.
#
#     foo.bar[baz] ||= value
#     ^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#10111
class Prism::IndexOrWriteNode < ::Prism::Node
  # Initialize a new IndexOrWriteNode node.
  #
  # @return [IndexOrWriteNode] a new instance of IndexOrWriteNode
  #
  # source://prism//lib/prism/node.rb#10113
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10303
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10129
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#10232
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#10187
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # attr_reader block: BlockArgumentNode?
  #
  # source://prism//lib/prism/node.rb#10248
  sig { returns(T.nilable(Prism::BlockArgumentNode)) }
  def block; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#10267
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # attr_reader call_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#10200
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#10134
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#10277
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#10235
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10159
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10149
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node?, ?call_operator_loc: Location?, ?opening_loc: Location, ?arguments: ArgumentsNode?, ?closing_loc: Location, ?block: BlockArgumentNode?, ?operator_loc: Location, ?value: Prism::node) -> IndexOrWriteNode
  #
  # source://prism//lib/prism/node.rb#10164
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::IndexOrWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#10169
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node?, call_operator_loc: Location?, opening_loc: Location, arguments: ArgumentsNode?, closing_loc: Location, block: BlockArgumentNode?, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#10172
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [receiver]
  #
  # source://prism//lib/prism/node.rb#10139
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#10192
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10287
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#10272
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#10219
  sig { returns(Prism::Location) }
  def opening_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#10282
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#10251
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader receiver: Prism::node?
  #
  # source://prism//lib/prism/node.rb#10197
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#10177
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Save the call_operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#10214
  def save_call_operator_loc(repository); end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#10243
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#10227
  def save_opening_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#10259
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10292
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#10264
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#10182
  sig { returns(T::Boolean) }
  def variable_call?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10297
    def type; end
  end
end

# Represents assigning to an index.
#
#     foo[bar], = 1
#     ^^^^^^^^
#
#     begin
#     rescue => foo[bar]
#               ^^^^^^^^
#     end
#
#     for foo[bar] in baz do end
#         ^^^^^^^^
#
# source://prism//lib/prism/node.rb#10329
class Prism::IndexTargetNode < ::Prism::Node
  # Initialize a new IndexTargetNode node.
  #
  # @return [IndexTargetNode] a new instance of IndexTargetNode
  #
  # source://prism//lib/prism/node.rb#10331
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: Prism::Node,
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode)
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, opening_loc, arguments, closing_loc, block); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10471
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10344
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#10426
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#10400
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # attr_reader block: BlockArgumentNode?
  #
  # source://prism//lib/prism/node.rb#10442
  sig { returns(T.nilable(Prism::BlockArgumentNode)) }
  def block; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#10349
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#10450
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#10429
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10372
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10363
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node, ?opening_loc: Location, ?arguments: ArgumentsNode?, ?closing_loc: Location, ?block: BlockArgumentNode?) -> IndexTargetNode
  #
  # source://prism//lib/prism/node.rb#10377
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: Prism::Node,
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode)
    ).returns(Prism::IndexTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#10382
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node, opening_loc: Location, arguments: ArgumentsNode?, closing_loc: Location, block: BlockArgumentNode? }
  #
  # source://prism//lib/prism/node.rb#10385
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [receiver]
  #
  # source://prism//lib/prism/node.rb#10354
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#10405
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10455
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#10445
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#10413
  sig { returns(Prism::Location) }
  def opening_loc; end

  # attr_reader receiver: Prism::node
  #
  # source://prism//lib/prism/node.rb#10410
  sig { returns(Prism::Node) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#10390
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#10437
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#10421
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10460
  sig { override.returns(Symbol) }
  def type; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#10395
  sig { returns(T::Boolean) }
  def variable_call?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10465
    def type; end
  end
end

# InlineComment objects are the most common. They correspond to comments in
# the source file like this one that start with #.
#
# source://prism//lib/prism/parse_result.rb#543
class Prism::InlineComment < ::Prism::Comment
  # Returns a string representation of this comment.
  #
  # source://prism//lib/prism/parse_result.rb#551
  sig { returns(String) }
  def inspect; end

  # Returns true if this comment happens on the same line as other code and
  # false if the comment is by itself.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result.rb#546
  sig { override.returns(T::Boolean) }
  def trailing?; end
end

# This visitor is responsible for composing the strings that get returned by
# the various #inspect methods defined on each of the nodes.
#
# source://prism//lib/prism/inspect_visitor.rb#15
class Prism::InspectVisitor < ::Prism::Visitor
  # Initializes a new instance of the InspectVisitor.
  #
  # @return [InspectVisitor] a new instance of InspectVisitor
  #
  # source://prism//lib/prism/inspect_visitor.rb#38
  sig { params(indent: String).void }
  def initialize(indent = T.unsafe(nil)); end

  # The list of commands that we need to execute in order to compose the
  # final string.
  #
  # source://prism//lib/prism/inspect_visitor.rb#35
  def commands; end

  # Compose the final string.
  #
  # source://prism//lib/prism/inspect_visitor.rb#51
  sig { returns(String) }
  def compose; end

  # The current prefix string.
  #
  # source://prism//lib/prism/inspect_visitor.rb#31
  def indent; end

  # Inspect a AliasGlobalVariableNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#80
  def visit_alias_global_variable_node(node); end

  # Inspect a AliasMethodNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#92
  def visit_alias_method_node(node); end

  # Inspect a AlternationPatternNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#104
  def visit_alternation_pattern_node(node); end

  # Inspect a AndNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#116
  def visit_and_node(node); end

  # Inspect a ArgumentsNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#128
  def visit_arguments_node(node); end

  # Inspect a ArrayNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#144
  def visit_array_node(node); end

  # Inspect a ArrayPatternNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#162
  def visit_array_pattern_node(node); end

  # Inspect a AssocNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#201
  def visit_assoc_node(node); end

  # Inspect a AssocSplatNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#213
  def visit_assoc_splat_node(node); end

  # Inspect a BackReferenceReadNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#227
  def visit_back_reference_read_node(node); end

  # Inspect a BeginNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#235
  def visit_begin_node(node); end

  # Inspect a BlockArgumentNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#268
  def visit_block_argument_node(node); end

  # Inspect a BlockLocalVariableNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#282
  def visit_block_local_variable_node(node); end

  # Inspect a BlockNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#290
  def visit_block_node(node); end

  # Inspect a BlockParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#312
  def visit_block_parameter_node(node); end

  # Inspect a BlockParametersNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#326
  def visit_block_parameters_node(node); end

  # Inspect a BreakNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#350
  def visit_break_node(node); end

  # Inspect a CallAndWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#364
  def visit_call_and_write_node(node); end

  # Inspect a CallNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#384
  def visit_call_node(node); end

  # Inspect a CallOperatorWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#415
  def visit_call_operator_write_node(node); end

  # Inspect a CallOrWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#436
  def visit_call_or_write_node(node); end

  # Inspect a CallTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#456
  def visit_call_target_node(node); end

  # Inspect a CapturePatternNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#468
  def visit_capture_pattern_node(node); end

  # Inspect a CaseMatchNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#480
  def visit_case_match_node(node); end

  # Inspect a CaseNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#510
  def visit_case_node(node); end

  # Inspect a ClassNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#540
  def visit_class_node(node); end

  # Inspect a ClassVariableAndWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#566
  def visit_class_variable_and_write_node(node); end

  # Inspect a ClassVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#578
  def visit_class_variable_operator_write_node(node); end

  # Inspect a ClassVariableOrWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#591
  def visit_class_variable_or_write_node(node); end

  # Inspect a ClassVariableReadNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#603
  def visit_class_variable_read_node(node); end

  # Inspect a ClassVariableTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#611
  def visit_class_variable_target_node(node); end

  # Inspect a ClassVariableWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#619
  def visit_class_variable_write_node(node); end

  # Inspect a ConstantAndWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#631
  def visit_constant_and_write_node(node); end

  # Inspect a ConstantOperatorWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#643
  def visit_constant_operator_write_node(node); end

  # Inspect a ConstantOrWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#656
  def visit_constant_or_write_node(node); end

  # Inspect a ConstantPathAndWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#668
  def visit_constant_path_and_write_node(node); end

  # Inspect a ConstantPathNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#680
  def visit_constant_path_node(node); end

  # Inspect a ConstantPathOperatorWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#700
  def visit_constant_path_operator_write_node(node); end

  # Inspect a ConstantPathOrWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#713
  def visit_constant_path_or_write_node(node); end

  # Inspect a ConstantPathTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#725
  def visit_constant_path_target_node(node); end

  # Inspect a ConstantPathWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#745
  def visit_constant_path_write_node(node); end

  # Inspect a ConstantReadNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#757
  def visit_constant_read_node(node); end

  # Inspect a ConstantTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#765
  def visit_constant_target_node(node); end

  # Inspect a ConstantWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#773
  def visit_constant_write_node(node); end

  # Inspect a DefNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#785
  def visit_def_node(node); end

  # Inspect a DefinedNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#819
  def visit_defined_node(node); end

  # Inspect a ElseNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#831
  def visit_else_node(node); end

  # Inspect a EmbeddedStatementsNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#846
  def visit_embedded_statements_node(node); end

  # Inspect a EmbeddedVariableNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#861
  def visit_embedded_variable_node(node); end

  # Inspect a EnsureNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#871
  def visit_ensure_node(node); end

  # Inspect a FalseNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#886
  def visit_false_node(node); end

  # Inspect a FindPatternNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#893
  def visit_find_pattern_node(node); end

  # Inspect a FlipFlopNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#921
  def visit_flip_flop_node(node); end

  # Inspect a FloatNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#941
  def visit_float_node(node); end

  # Inspect a ForNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#949
  def visit_for_node(node); end

  # Inspect a ForwardingArgumentsNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#970
  def visit_forwarding_arguments_node(node); end

  # Inspect a ForwardingParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#977
  def visit_forwarding_parameter_node(node); end

  # Inspect a ForwardingSuperNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#984
  def visit_forwarding_super_node(node); end

  # Inspect a GlobalVariableAndWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#997
  def visit_global_variable_and_write_node(node); end

  # Inspect a GlobalVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1009
  def visit_global_variable_operator_write_node(node); end

  # Inspect a GlobalVariableOrWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1022
  def visit_global_variable_or_write_node(node); end

  # Inspect a GlobalVariableReadNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1034
  def visit_global_variable_read_node(node); end

  # Inspect a GlobalVariableTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1042
  def visit_global_variable_target_node(node); end

  # Inspect a GlobalVariableWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1050
  def visit_global_variable_write_node(node); end

  # Inspect a HashNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1062
  def visit_hash_node(node); end

  # Inspect a HashPatternNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1080
  def visit_hash_pattern_node(node); end

  # Inspect a IfNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1110
  def visit_if_node(node); end

  # Inspect a ImaginaryNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1134
  def visit_imaginary_node(node); end

  # Inspect a ImplicitNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1143
  def visit_implicit_node(node); end

  # Inspect a ImplicitRestNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1152
  def visit_implicit_rest_node(node); end

  # Inspect a InNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1159
  def visit_in_node(node); end

  # Inspect a IndexAndWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1176
  def visit_index_and_write_node(node); end

  # Inspect a IndexOperatorWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1207
  def visit_index_operator_write_node(node); end

  # Inspect a IndexOrWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1239
  def visit_index_or_write_node(node); end

  # Inspect a IndexTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1270
  def visit_index_target_node(node); end

  # Inspect a InstanceVariableAndWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1293
  def visit_instance_variable_and_write_node(node); end

  # Inspect a InstanceVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1305
  def visit_instance_variable_operator_write_node(node); end

  # Inspect a InstanceVariableOrWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1318
  def visit_instance_variable_or_write_node(node); end

  # Inspect a InstanceVariableReadNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1330
  def visit_instance_variable_read_node(node); end

  # Inspect a InstanceVariableTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1338
  def visit_instance_variable_target_node(node); end

  # Inspect a InstanceVariableWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1346
  def visit_instance_variable_write_node(node); end

  # Inspect a IntegerNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1358
  def visit_integer_node(node); end

  # Inspect a InterpolatedMatchLastLineNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1366
  def visit_interpolated_match_last_line_node(node); end

  # Inspect a InterpolatedRegularExpressionNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1384
  def visit_interpolated_regular_expression_node(node); end

  # Inspect a InterpolatedStringNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1402
  def visit_interpolated_string_node(node); end

  # Inspect a InterpolatedSymbolNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1420
  def visit_interpolated_symbol_node(node); end

  # Inspect a InterpolatedXStringNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1438
  def visit_interpolated_x_string_node(node); end

  # Inspect a ItLocalVariableReadNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1456
  def visit_it_local_variable_read_node(node); end

  # Inspect a ItParametersNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1463
  def visit_it_parameters_node(node); end

  # Inspect a KeywordHashNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1470
  def visit_keyword_hash_node(node); end

  # Inspect a KeywordRestParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1486
  def visit_keyword_rest_parameter_node(node); end

  # Inspect a LambdaNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1500
  def visit_lambda_node(node); end

  # Inspect a LocalVariableAndWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1523
  def visit_local_variable_and_write_node(node); end

  # Inspect a LocalVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1536
  def visit_local_variable_operator_write_node(node); end

  # Inspect a LocalVariableOrWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1550
  def visit_local_variable_or_write_node(node); end

  # Inspect a LocalVariableReadNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1563
  def visit_local_variable_read_node(node); end

  # Inspect a LocalVariableTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1572
  def visit_local_variable_target_node(node); end

  # Inspect a LocalVariableWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1581
  def visit_local_variable_write_node(node); end

  # Inspect a MatchLastLineNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1594
  def visit_match_last_line_node(node); end

  # Inspect a MatchPredicateNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1605
  def visit_match_predicate_node(node); end

  # Inspect a MatchRequiredNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1617
  def visit_match_required_node(node); end

  # Inspect a MatchWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1629
  def visit_match_write_node(node); end

  # Inspect a MissingNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1647
  def visit_missing_node(node); end

  # Inspect a ModuleNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1654
  def visit_module_node(node); end

  # Inspect a MultiTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1673
  def visit_multi_target_node(node); end

  # Inspect a MultiWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1706
  def visit_multi_write_node(node); end

  # Inspect a NextNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1742
  def visit_next_node(node); end

  # Inspect a NilNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1756
  def visit_nil_node(node); end

  # Inspect a NoKeywordsParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1763
  def visit_no_keywords_parameter_node(node); end

  # Inspect a NumberedParametersNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1772
  def visit_numbered_parameters_node(node); end

  # Inspect a NumberedReferenceReadNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1780
  def visit_numbered_reference_read_node(node); end

  # Inspect a OptionalKeywordParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1788
  def visit_optional_keyword_parameter_node(node); end

  # Inspect a OptionalParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1799
  def visit_optional_parameter_node(node); end

  # Inspect a OrNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1811
  def visit_or_node(node); end

  # Inspect a ParametersNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1823
  def visit_parameters_node(node); end

  # Inspect a ParenthesesNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1884
  def visit_parentheses_node(node); end

  # Inspect a PinnedExpressionNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1899
  def visit_pinned_expression_node(node); end

  # Inspect a PinnedVariableNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1911
  def visit_pinned_variable_node(node); end

  # Inspect a PostExecutionNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1921
  def visit_post_execution_node(node); end

  # Inspect a PreExecutionNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1937
  def visit_pre_execution_node(node); end

  # Inspect a ProgramNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1953
  def visit_program_node(node); end

  # Inspect a RangeNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1963
  def visit_range_node(node); end

  # Inspect a RationalNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1983
  def visit_rational_node(node); end

  # Inspect a RedoNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1992
  def visit_redo_node(node); end

  # Inspect a RegularExpressionNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1999
  def visit_regular_expression_node(node); end

  # Inspect a RequiredKeywordParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2010
  def visit_required_keyword_parameter_node(node); end

  # Inspect a RequiredParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2019
  def visit_required_parameter_node(node); end

  # Inspect a RescueModifierNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2027
  def visit_rescue_modifier_node(node); end

  # Inspect a RescueNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2039
  def visit_rescue_node(node); end

  # Inspect a RestParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2076
  def visit_rest_parameter_node(node); end

  # Inspect a RetryNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2090
  def visit_retry_node(node); end

  # Inspect a ReturnNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2097
  def visit_return_node(node); end

  # Inspect a SelfNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2111
  def visit_self_node(node); end

  # Inspect a ShareableConstantNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2118
  def visit_shareable_constant_node(node); end

  # Inspect a SingletonClassNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2127
  def visit_singleton_class_node(node); end

  # Inspect a SourceEncodingNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2146
  def visit_source_encoding_node(node); end

  # Inspect a SourceFileNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2153
  def visit_source_file_node(node); end

  # Inspect a SourceLineNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2161
  def visit_source_line_node(node); end

  # Inspect a SplatNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2168
  def visit_splat_node(node); end

  # Inspect a StatementsNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2182
  def visit_statements_node(node); end

  # Inspect a StringNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2198
  def visit_string_node(node); end

  # Inspect a SuperNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2209
  def visit_super_node(node); end

  # Inspect a SymbolNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2231
  def visit_symbol_node(node); end

  # Inspect a TrueNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2242
  def visit_true_node(node); end

  # Inspect a UndefNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2249
  def visit_undef_node(node); end

  # Inspect a UnlessNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2266
  def visit_unless_node(node); end

  # Inspect a UntilNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2290
  def visit_until_node(node); end

  # Inspect a WhenNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2308
  def visit_when_node(node); end

  # Inspect a WhileNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2332
  def visit_while_node(node); end

  # Inspect a XStringNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2350
  def visit_x_string_node(node); end

  # Inspect a YieldNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2361
  def visit_yield_node(node); end

  private

  # Compose a string representing the given inner location field.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2385
  def inspect_location(location); end

  # Compose a header for the given node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2379
  def inspect_node(name, node); end

  class << self
    # Compose an inspect string for the given node.
    #
    # source://prism//lib/prism/inspect_visitor.rb#44
    sig { params(node: Prism::Node).returns(String) }
    def compose(node); end
  end
end

# Most of the time, we can simply pass down the indent to the next node.
# However, when we are inside a list we want some extra special formatting
# when we hit an element in that list. In this case, we have a special
# command that replaces the subsequent indent with the given value.
#
# source://prism//lib/prism/inspect_visitor.rb#20
class Prism::InspectVisitor::Replace
  # @return [Replace] a new instance of Replace
  #
  # source://prism//lib/prism/inspect_visitor.rb#23
  def initialize(value); end

  # source://prism//lib/prism/inspect_visitor.rb#21
  def value; end
end

# Represents the use of the `&&=` operator for assignment to an instance variable.
#
#     @target &&= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#10486
class Prism::InstanceVariableAndWriteNode < ::Prism::Node
  # Initialize a new InstanceVariableAndWriteNode node.
  #
  # @return [InstanceVariableAndWriteNode] a new instance of InstanceVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#10488
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10593
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10500
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#10505
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10522
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10517
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> InstanceVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#10527
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::InstanceVariableAndWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#10532
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#10535
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#219
  def desugar; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#10510
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10577
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#10540
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#10543
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#10572
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#10556
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#10551
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#10564
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10582
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#10569
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10587
    def type; end
  end
end

# Represents assigning to an instance variable using an operator that isn't `=`.
#
#     @target += value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#10606
class Prism::InstanceVariableOperatorWriteNode < ::Prism::Node
  # Initialize a new InstanceVariableOperatorWriteNode node.
  #
  # @return [InstanceVariableOperatorWriteNode] a new instance of InstanceVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#10608
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, binary_operator_loc, value, binary_operator); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10712
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10621
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader binary_operator: Symbol
  #
  # source://prism//lib/prism/node.rb#10693
  sig { returns(Symbol) }
  def binary_operator; end

  # attr_reader binary_operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#10677
  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#10626
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10643
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10638
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?binary_operator_loc: Location, ?value: Prism::node, ?binary_operator: Symbol) -> InstanceVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#10648
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::InstanceVariableOperatorWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#10653
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, binary_operator_loc: Location, value: Prism::node, binary_operator: Symbol }
  #
  # source://prism//lib/prism/node.rb#10656
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#231
  def desugar; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#10631
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10696
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#10661
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#10664
  sig { returns(Prism::Location) }
  def name_loc; end

  # Returns the binary operator used to modify the receiver. This method is
  # deprecated in favor of #binary_operator.
  #
  # source://prism//lib/prism/node_ext.rb#438
  def operator; end

  # Returns the location of the binary operator used to modify the receiver.
  # This method is deprecated in favor of #binary_operator_loc.
  #
  # source://prism//lib/prism/node_ext.rb#445
  def operator_loc; end

  # Save the binary_operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#10685
  def save_binary_operator_loc(repository); end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#10672
  def save_name_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10701
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#10690
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10706
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to an instance variable.
#
#     @target ||= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#10726
class Prism::InstanceVariableOrWriteNode < ::Prism::Node
  # Initialize a new InstanceVariableOrWriteNode node.
  #
  # @return [InstanceVariableOrWriteNode] a new instance of InstanceVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#10728
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10833
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10740
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#10745
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10762
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10757
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> InstanceVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#10767
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::InstanceVariableOrWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#10772
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#10775
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#225
  def desugar; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#10750
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10817
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#10780
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#10783
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#10812
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#10796
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#10791
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#10804
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10822
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#10809
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10827
    def type; end
  end
end

# Represents referencing an instance variable.
#
#     @foo
#     ^^^^
#
# source://prism//lib/prism/node.rb#10846
class Prism::InstanceVariableReadNode < ::Prism::Node
  # Initialize a new InstanceVariableReadNode node.
  #
  # @return [InstanceVariableReadNode] a new instance of InstanceVariableReadNode
  #
  # source://prism//lib/prism/node.rb#10848
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10919
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10857
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#10862
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10878
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10873
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> InstanceVariableReadNode
  #
  # source://prism//lib/prism/node.rb#10883
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::InstanceVariableReadNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#10888
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#10891
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#10867
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10903
  sig { override.returns(String) }
  def inspect; end

  # The name of the instance variable, which is a `@` followed by an [identifier](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#identifiers).
  #
  #     @x     # name `:@x`
  #
  #     @_test # name `:@_test`
  #
  # source://prism//lib/prism/node.rb#10900
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10908
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10913
    def type; end
  end
end

# Represents writing to an instance variable in a context that doesn't have an explicit value.
#
#     @foo, @bar = baz
#     ^^^^  ^^^^
#
# source://prism//lib/prism/node.rb#10929
class Prism::InstanceVariableTargetNode < ::Prism::Node
  # Initialize a new InstanceVariableTargetNode node.
  #
  # @return [InstanceVariableTargetNode] a new instance of InstanceVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#10931
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10998
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10940
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#10945
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10961
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10956
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> InstanceVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#10966
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::InstanceVariableTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#10971
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#10974
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#10950
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10982
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#10979
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10987
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10992
    def type; end
  end
end

# Represents writing to an instance variable.
#
#     @foo = 1
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#11008
class Prism::InstanceVariableWriteNode < ::Prism::Node
  # Initialize a new InstanceVariableWriteNode node.
  #
  # @return [InstanceVariableWriteNode] a new instance of InstanceVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#11010
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, value, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#11131
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11022
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#11027
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11044
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11039
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?value: Prism::node, ?operator_loc: Location) -> InstanceVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#11049
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::InstanceVariableWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#11054
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, value: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#11057
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#11032
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#11115
  sig { override.returns(String) }
  def inspect; end

  # The name of the instance variable, which is a `@` followed by an [identifier](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#identifiers).
  #
  #     @x = :y       # name `:@x`
  #
  #     @_foo = "bar" # name `@_foo`
  #
  # source://prism//lib/prism/node.rb#11066
  sig { returns(Symbol) }
  def name; end

  # The location of the variable name.
  #
  #     @_x = 1
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#11072
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#11110
  sig { returns(String) }
  def operator; end

  # The location of the `=` operator.
  #
  #     @x = y
  #        ^
  #
  # source://prism//lib/prism/node.rb#11097
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#11080
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#11105
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#11120
  sig { override.returns(Symbol) }
  def type; end

  # The value to write to the instance variable. It can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     @foo = :bar
  #            ^^^^
  #
  #     @_x = 1234
  #           ^^^^
  #
  # source://prism//lib/prism/node.rb#11091
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#11125
    def type; end
  end
end

# Flags for integer nodes that correspond to the base of the integer.
#
# source://prism//lib/prism/node.rb#19828
module Prism::IntegerBaseFlags; end

# 0b prefix
#
# source://prism//lib/prism/node.rb#19830
Prism::IntegerBaseFlags::BINARY = T.let(T.unsafe(nil), Integer)

# 0d or no prefix
#
# source://prism//lib/prism/node.rb#19833
Prism::IntegerBaseFlags::DECIMAL = T.let(T.unsafe(nil), Integer)

# 0x prefix
#
# source://prism//lib/prism/node.rb#19839
Prism::IntegerBaseFlags::HEXADECIMAL = T.let(T.unsafe(nil), Integer)

# 0o or 0 prefix
#
# source://prism//lib/prism/node.rb#19836
Prism::IntegerBaseFlags::OCTAL = T.let(T.unsafe(nil), Integer)

# Represents an integer number literal.
#
#     1
#     ^
#
# source://prism//lib/prism/node.rb#11144
class Prism::IntegerNode < ::Prism::Node
  # Initialize a new IntegerNode node.
  #
  # @return [IntegerNode] a new instance of IntegerNode
  #
  # source://prism//lib/prism/node.rb#11146
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#11233
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11155
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def binary?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11194
  sig { returns(T::Boolean) }
  def binary?; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#11160
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11176
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11171
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?value: Integer) -> IntegerNode
  #
  # source://prism//lib/prism/node.rb#11181
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Integer
    ).returns(Prism::IntegerNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil)); end

  # def decimal?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11199
  sig { returns(T::Boolean) }
  def decimal?; end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#11186
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, value: Integer }
  #
  # source://prism//lib/prism/node.rb#11189
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#11165
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def hexadecimal?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11209
  sig { returns(T::Boolean) }
  def hexadecimal?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#11217
  sig { override.returns(String) }
  def inspect; end

  # def octal?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11204
  sig { returns(T::Boolean) }
  def octal?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#11222
  sig { override.returns(Symbol) }
  def type; end

  # The value of the integer literal as a number.
  #
  # source://prism//lib/prism/node.rb#11214
  sig { returns(Integer) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#11227
    def type; end
  end
end

# Represents a regular expression literal that contains interpolation that is being used in the predicate of a conditional to implicitly match against the last line read by an IO object.
#
#     if /foo #{bar} baz/ then end
#        ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#11244
class Prism::InterpolatedMatchLastLineNode < ::Prism::Node
  include ::Prism::RegularExpressionOptions

  # Initialize a new InterpolatedMatchLastLineNode node.
  #
  # @return [InterpolatedMatchLastLineNode] a new instance of InterpolatedMatchLastLineNode
  #
  # source://prism//lib/prism/node.rb#11246
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, parts, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#11407
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11257
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def ascii_8bit?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11322
  sig { returns(T::Boolean) }
  def ascii_8bit?; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#11262
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#11386
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#11368
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11279
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11274
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location, ?parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode], ?closing_loc: Location) -> InterpolatedMatchLastLineNode
  #
  # source://prism//lib/prism/node.rb#11284
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).returns(Prism::InterpolatedMatchLastLineNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#11289
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location, parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode], closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#11292
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#11267
  def each_child_node; end

  # def euc_jp?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11317
  sig { returns(T::Boolean) }
  def euc_jp?; end

  # def extended?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11302
  sig { returns(T::Boolean) }
  def extended?; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def forced_binary_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11342
  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  # def forced_us_ascii_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11347
  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  # def forced_utf8_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11337
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  # def ignore_case?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11297
  sig { returns(T::Boolean) }
  def ignore_case?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#11391
  sig { override.returns(String) }
  def inspect; end

  # def multi_line?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11307
  sig { returns(T::Boolean) }
  def multi_line?; end

  # source://prism//lib/prism/parse_result/newlines.rb#122
  def newline_flag!(lines); end

  # def once?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11312
  sig { returns(T::Boolean) }
  def once?; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#11381
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#11352
  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(Integer) }
  def options; end

  # attr_reader parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode]
  #
  # source://prism//lib/prism/node.rb#11365
  sig { returns(T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)]) }
  def parts; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#11376
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#11360
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#11396
  sig { override.returns(Symbol) }
  def type; end

  # def utf_8?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11332
  sig { returns(T::Boolean) }
  def utf_8?; end

  # def windows_31j?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11327
  sig { returns(T::Boolean) }
  def windows_31j?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#11401
    def type; end
  end
end

# Represents a regular expression literal that contains interpolation.
#
#     /foo #{bar} baz/
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#11421
class Prism::InterpolatedRegularExpressionNode < ::Prism::Node
  include ::Prism::RegularExpressionOptions

  # Initialize a new InterpolatedRegularExpressionNode node.
  #
  # @return [InterpolatedRegularExpressionNode] a new instance of InterpolatedRegularExpressionNode
  #
  # source://prism//lib/prism/node.rb#11423
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, parts, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#11584
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11434
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def ascii_8bit?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11499
  sig { returns(T::Boolean) }
  def ascii_8bit?; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#11439
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#11563
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#11545
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11456
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11451
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location, ?parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode], ?closing_loc: Location) -> InterpolatedRegularExpressionNode
  #
  # source://prism//lib/prism/node.rb#11461
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).returns(Prism::InterpolatedRegularExpressionNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#11466
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location, parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode], closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#11469
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#11444
  def each_child_node; end

  # def euc_jp?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11494
  sig { returns(T::Boolean) }
  def euc_jp?; end

  # def extended?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11479
  sig { returns(T::Boolean) }
  def extended?; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def forced_binary_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11519
  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  # def forced_us_ascii_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11524
  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  # def forced_utf8_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11514
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  # def ignore_case?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11474
  sig { returns(T::Boolean) }
  def ignore_case?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#11568
  sig { override.returns(String) }
  def inspect; end

  # def multi_line?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11484
  sig { returns(T::Boolean) }
  def multi_line?; end

  # source://prism//lib/prism/parse_result/newlines.rb#129
  def newline_flag!(lines); end

  # def once?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11489
  sig { returns(T::Boolean) }
  def once?; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#11558
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#11529
  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(Integer) }
  def options; end

  # attr_reader parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode]
  #
  # source://prism//lib/prism/node.rb#11542
  sig { returns(T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)]) }
  def parts; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#11553
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#11537
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#11573
  sig { override.returns(Symbol) }
  def type; end

  # def utf_8?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11509
  sig { returns(T::Boolean) }
  def utf_8?; end

  # def windows_31j?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11504
  sig { returns(T::Boolean) }
  def windows_31j?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#11578
    def type; end
  end
end

# Represents a string literal that contains interpolation.
#
#     "foo #{bar} baz"
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#11598
class Prism::InterpolatedStringNode < ::Prism::Node
  include ::Prism::HeredocQuery

  # Initialize a new InterpolatedStringNode node.
  #
  # @return [InterpolatedStringNode] a new instance of InterpolatedStringNode
  #
  # source://prism//lib/prism/node.rb#11600
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode, Prism::InterpolatedStringNode, Prism::XStringNode, Prism::InterpolatedXStringNode, Prism::SymbolNode, Prism::InterpolatedSymbolNode)],
      closing_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, parts, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#11728
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11611
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#11616
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#11707
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#11683
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11633
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11628
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location?, ?parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode | InterpolatedStringNode | XStringNode | InterpolatedXStringNode | SymbolNode | InterpolatedSymbolNode], ?closing_loc: Location?) -> InterpolatedStringNode
  #
  # source://prism//lib/prism/node.rb#11638
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode, Prism::InterpolatedStringNode, Prism::XStringNode, Prism::InterpolatedXStringNode, Prism::SymbolNode, Prism::InterpolatedSymbolNode)],
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::InterpolatedStringNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#11643
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location?, parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode | InterpolatedStringNode | XStringNode | InterpolatedXStringNode | SymbolNode | InterpolatedSymbolNode], closing_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#11646
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#11621
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def frozen?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11651
  sig { returns(T::Boolean) }
  def frozen?; end

  sig { returns(T::Boolean) }
  def heredoc?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#11712
  sig { override.returns(String) }
  def inspect; end

  # def mutable?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11656
  sig { returns(T::Boolean) }
  def mutable?; end

  # source://prism//lib/prism/parse_result/newlines.rb#136
  def newline_flag!(lines); end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#11702
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#11661
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # attr_reader parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode | InterpolatedStringNode | XStringNode | InterpolatedXStringNode | SymbolNode | InterpolatedSymbolNode]
  #
  # source://prism//lib/prism/node.rb#11680
  sig do
    returns(T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode, Prism::InterpolatedStringNode, Prism::XStringNode, Prism::InterpolatedXStringNode, Prism::SymbolNode, Prism::InterpolatedSymbolNode)])
  end
  def parts; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#11697
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#11675
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#11717
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#11722
    def type; end
  end
end

# Flags for interpolated string nodes that indicated mutability if they are also marked as literals.
#
# source://prism//lib/prism/node.rb#19843
module Prism::InterpolatedStringNodeFlags; end

# source://prism//lib/prism/node.rb#19845
Prism::InterpolatedStringNodeFlags::FROZEN = T.let(T.unsafe(nil), Integer)

# source://prism//lib/prism/node.rb#19848
Prism::InterpolatedStringNodeFlags::MUTABLE = T.let(T.unsafe(nil), Integer)

# Represents a symbol literal that contains interpolation.
#
#     :"foo #{bar} baz"
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#11742
class Prism::InterpolatedSymbolNode < ::Prism::Node
  # Initialize a new InterpolatedSymbolNode node.
  #
  # @return [InterpolatedSymbolNode] a new instance of InterpolatedSymbolNode
  #
  # source://prism//lib/prism/node.rb#11744
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, parts, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#11862
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11755
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#11760
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#11841
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#11817
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11777
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11772
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location?, ?parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode], ?closing_loc: Location?) -> InterpolatedSymbolNode
  #
  # source://prism//lib/prism/node.rb#11782
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::InterpolatedSymbolNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#11787
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location?, parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode], closing_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#11790
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#11765
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#11846
  sig { override.returns(String) }
  def inspect; end

  # source://prism//lib/prism/parse_result/newlines.rb#143
  def newline_flag!(lines); end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#11836
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#11795
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # attr_reader parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode]
  #
  # source://prism//lib/prism/node.rb#11814
  sig { returns(T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)]) }
  def parts; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#11831
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#11809
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#11851
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#11856
    def type; end
  end
end

# Represents an xstring literal that contains interpolation.
#
#     `foo #{bar} baz`
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#11875
class Prism::InterpolatedXStringNode < ::Prism::Node
  include ::Prism::HeredocQuery

  # Initialize a new InterpolatedXStringNode node.
  #
  # @return [InterpolatedXStringNode] a new instance of InterpolatedXStringNode
  #
  # source://prism//lib/prism/node.rb#11877
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, parts, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#11983
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11888
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#11893
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#11962
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#11944
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11910
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11905
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location, ?parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode], ?closing_loc: Location) -> InterpolatedXStringNode
  #
  # source://prism//lib/prism/node.rb#11915
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).returns(Prism::InterpolatedXStringNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#11920
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location, parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode], closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#11923
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#11898
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { returns(T::Boolean) }
  def heredoc?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#11967
  sig { override.returns(String) }
  def inspect; end

  # source://prism//lib/prism/parse_result/newlines.rb#150
  def newline_flag!(lines); end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#11957
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#11928
  sig { returns(Prism::Location) }
  def opening_loc; end

  # attr_reader parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode]
  #
  # source://prism//lib/prism/node.rb#11941
  sig { returns(T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)]) }
  def parts; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#11952
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#11936
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#11972
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#11977
    def type; end
  end
end

# Represents reading from the implicit `it` local variable.
#
#     -> { it }
#          ^^
#
# source://prism//lib/prism/node.rb#11996
class Prism::ItLocalVariableReadNode < ::Prism::Node
  # Initialize a new ItLocalVariableReadNode node.
  #
  # @return [ItLocalVariableReadNode] a new instance of ItLocalVariableReadNode
  #
  # source://prism//lib/prism/node.rb#11998
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12061
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12006
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12011
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12027
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12022
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> ItLocalVariableReadNode
  #
  # source://prism//lib/prism/node.rb#12032
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ItLocalVariableReadNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12037
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#12040
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#12016
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12045
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12050
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12055
    def type; end
  end
end

# Represents an implicit set of parameters through the use of the `it` keyword within a block or lambda.
#
#     -> { it + it }
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#12070
class Prism::ItParametersNode < ::Prism::Node
  # Initialize a new ItParametersNode node.
  #
  # @return [ItParametersNode] a new instance of ItParametersNode
  #
  # source://prism//lib/prism/node.rb#12072
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12135
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12080
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12085
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12101
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12096
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> ItParametersNode
  #
  # source://prism//lib/prism/node.rb#12106
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ItParametersNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12111
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#12114
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#12090
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12119
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12124
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12129
    def type; end
  end
end

# Represents a hash literal without opening and closing braces.
#
#     foo(a: b)
#         ^^^^
#
# source://prism//lib/prism/node.rb#12144
class Prism::KeywordHashNode < ::Prism::Node
  # Initialize a new KeywordHashNode node.
  #
  # @return [KeywordHashNode] a new instance of KeywordHashNode
  #
  # source://prism//lib/prism/node.rb#12146
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)]
    ).void
  end
  def initialize(source, node_id, location, flags, elements); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12219
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12155
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12160
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12177
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12172
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?elements: Array[AssocNode | AssocSplatNode]) -> KeywordHashNode
  #
  # source://prism//lib/prism/node.rb#12182
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)]
    ).returns(Prism::KeywordHashNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), elements: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12187
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, elements: Array[AssocNode | AssocSplatNode] }
  #
  # source://prism//lib/prism/node.rb#12190
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#12165
  def each_child_node; end

  # attr_reader elements: Array[AssocNode | AssocSplatNode]
  #
  # source://prism//lib/prism/node.rb#12200
  sig { returns(T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)]) }
  def elements; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12203
  sig { override.returns(String) }
  def inspect; end

  # def symbol_keys?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#12195
  sig { returns(T::Boolean) }
  def symbol_keys?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12208
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12213
    def type; end
  end
end

# Flags for keyword hash nodes.
#
# source://prism//lib/prism/node.rb#19852
module Prism::KeywordHashNodeFlags; end

# a keyword hash which only has `AssocNode` elements all with symbol keys, which means the elements can be treated as keyword arguments
#
# source://prism//lib/prism/node.rb#19854
Prism::KeywordHashNodeFlags::SYMBOL_KEYS = T.let(T.unsafe(nil), Integer)

# Represents a keyword rest parameter to a method, block, or lambda definition.
#
#     def a(**b)
#           ^^^
#     end
#
# source://prism//lib/prism/node.rb#12232
class Prism::KeywordRestParameterNode < ::Prism::Node
  # Initialize a new KeywordRestParameterNode node.
  #
  # @return [KeywordRestParameterNode] a new instance of KeywordRestParameterNode
  #
  # source://prism//lib/prism/node.rb#12234
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12345
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12245
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12250
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12266
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12261
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol?, ?name_loc: Location?, ?operator_loc: Location) -> KeywordRestParameterNode
  #
  # source://prism//lib/prism/node.rb#12271
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location
    ).returns(Prism::KeywordRestParameterNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12276
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol?, name_loc: Location?, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#12279
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#12255
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12329
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol?
  #
  # source://prism//lib/prism/node.rb#12289
  sig { returns(T.nilable(Symbol)) }
  def name; end

  # attr_reader name_loc: Location?
  #
  # source://prism//lib/prism/node.rb#12292
  sig { returns(T.nilable(Prism::Location)) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#12324
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#12311
  sig { returns(Prism::Location) }
  def operator_loc; end

  # def repeated_parameter?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#12284
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#12306
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#12319
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12334
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12339
    def type; end
  end
end

# Represents using a lambda literal (not the lambda method call).
#
#     ->(value) { value * 2 }
#     ^^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#12358
class Prism::LambdaNode < ::Prism::Node
  # Initialize a new LambdaNode node.
  #
  # @return [LambdaNode] a new instance of LambdaNode
  #
  # source://prism//lib/prism/node.rb#12360
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      operator_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location,
      parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))
    ).void
  end
  def initialize(source, node_id, location, flags, locals, operator_loc, opening_loc, closing_loc, parameters, body); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12497
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12374
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader body: StatementsNode | BeginNode | nil
  #
  # source://prism//lib/prism/node.rb#12463
  sig { returns(T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))) }
  def body; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12379
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#12476
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#12447
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12400
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12392
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?locals: Array[Symbol], ?operator_loc: Location, ?opening_loc: Location, ?closing_loc: Location, ?parameters: BlockParametersNode | NumberedParametersNode | ItParametersNode | nil, ?body: StatementsNode | BeginNode | nil) -> LambdaNode
  #
  # source://prism//lib/prism/node.rb#12405
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      operator_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location,
      parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))
    ).returns(Prism::LambdaNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), operator_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), parameters: T.unsafe(nil), body: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12410
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, locals: Array[Symbol], operator_loc: Location, opening_loc: Location, closing_loc: Location, parameters: BlockParametersNode | NumberedParametersNode | ItParametersNode | nil, body: StatementsNode | BeginNode | nil }
  #
  # source://prism//lib/prism/node.rb#12413
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [parameters]
  #
  # source://prism//lib/prism/node.rb#12384
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12481
  sig { override.returns(String) }
  def inspect; end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#12418
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#12471
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#12434
  sig { returns(Prism::Location) }
  def opening_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#12466
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#12421
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader parameters: BlockParametersNode | NumberedParametersNode | ItParametersNode | nil
  #
  # source://prism//lib/prism/node.rb#12460
  sig { returns(T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode))) }
  def parameters; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#12455
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#12442
  def save_opening_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#12429
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12486
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12491
    def type; end
  end
end

# This class is responsible for lexing the source using prism and then
# converting those tokens to be compatible with Ripper. In the vast majority
# of cases, this is a one-to-one mapping of the token type. Everything else
# generally lines up. However, there are a few cases that require special
# handling.
#
# source://prism//lib/prism/lex_compat.rb#10
class Prism::LexCompat
  # @return [LexCompat] a new instance of LexCompat
  #
  # source://prism//lib/prism/lex_compat.rb#586
  def initialize(code, **options); end

  # source://prism//lib/prism/lex_compat.rb#828
  def add_on_sp_tokens(tokens, source, data_loc, bom, eof_token); end

  # Returns the value of attribute options.
  #
  # source://prism//lib/prism/lex_compat.rb#584
  def options; end

  # source://prism//lib/prism/lex_compat.rb#591
  def result; end
end

# In previous versions of Ruby, Ripper wouldn't flush the bom before the
# first token, so we had to have a hack in place to account for that.
#
# source://prism//lib/prism/lex_compat.rb#581
Prism::LexCompat::BOM_FLUSHED = T.let(T.unsafe(nil), TrueClass)

# A heredoc in this case is a list of tokens that belong to the body of the
# heredoc that should be appended onto the list of tokens when the heredoc
# closes.
#
# source://prism//lib/prism/lex_compat.rb#253
module Prism::LexCompat::Heredoc
  class << self
    # Here we will split between the two types of heredocs and return the
    # object that will store their tokens.
    #
    # source://prism//lib/prism/lex_compat.rb#565
    def build(opening); end
  end
end

# Dash heredocs are a little more complicated. They are a list of tokens
# that need to be split on "\\\n" to mimic Ripper's behavior. We also need
# to keep track of the state that the heredoc was opened in.
#
# source://prism//lib/prism/lex_compat.rb#277
class Prism::LexCompat::Heredoc::DashHeredoc
  # @return [DashHeredoc] a new instance of DashHeredoc
  #
  # source://prism//lib/prism/lex_compat.rb#280
  def initialize(split); end

  # source://prism//lib/prism/lex_compat.rb#285
  def <<(token); end

  # source://prism//lib/prism/lex_compat.rb#278
  def split; end

  # source://prism//lib/prism/lex_compat.rb#289
  def to_a; end

  # source://prism//lib/prism/lex_compat.rb#278
  def tokens; end
end

# Heredocs that are dedenting heredocs are a little more complicated.
# Ripper outputs on_ignored_sp tokens for the whitespace that is being
# removed from the output. prism only modifies the node itself and keeps
# the token the same. This simplifies prism, but makes comparing against
# Ripper much harder because there is a length mismatch.
#
# Fortunately, we already have to pull out the heredoc tokens in order to
# insert them into the stream in the correct order. As such, we can do
# some extra manipulation on the tokens to make them match Ripper's
# output by mirroring the dedent logic that Ripper uses.
#
# source://prism//lib/prism/lex_compat.rb#336
class Prism::LexCompat::Heredoc::DedentingHeredoc
  # @return [DedentingHeredoc] a new instance of DedentingHeredoc
  #
  # source://prism//lib/prism/lex_compat.rb#341
  def initialize; end

  # As tokens are coming in, we track the minimum amount of common leading
  # whitespace on plain string content tokens. This allows us to later
  # remove that amount of whitespace from the beginning of each line.
  #
  # source://prism//lib/prism/lex_compat.rb#352
  def <<(token); end

  # Returns the value of attribute dedent.
  #
  # source://prism//lib/prism/lex_compat.rb#339
  def dedent; end

  # Returns the value of attribute dedent_next.
  #
  # source://prism//lib/prism/lex_compat.rb#339
  def dedent_next; end

  # Returns the value of attribute embexpr_balance.
  #
  # source://prism//lib/prism/lex_compat.rb#339
  def embexpr_balance; end

  # source://prism//lib/prism/lex_compat.rb#389
  def to_a; end

  # Returns the value of attribute tokens.
  #
  # source://prism//lib/prism/lex_compat.rb#339
  def tokens; end
end

# source://prism//lib/prism/lex_compat.rb#337
Prism::LexCompat::Heredoc::DedentingHeredoc::TAB_WIDTH = T.let(T.unsafe(nil), Integer)

# Heredocs that are no dash or tilde heredocs are just a list of tokens.
# We need to keep them around so that we can insert them in the correct
# order back into the token stream and set the state of the last token to
# the state that the heredoc was opened in.
#
# source://prism//lib/prism/lex_compat.rb#258
class Prism::LexCompat::Heredoc::PlainHeredoc
  # @return [PlainHeredoc] a new instance of PlainHeredoc
  #
  # source://prism//lib/prism/lex_compat.rb#261
  def initialize; end

  # source://prism//lib/prism/lex_compat.rb#265
  def <<(token); end

  # source://prism//lib/prism/lex_compat.rb#269
  def to_a; end

  # source://prism//lib/prism/lex_compat.rb#259
  def tokens; end
end

# Tokens where state should be ignored
# used for :on_sp, :on_comment, :on_heredoc_end, :on_embexpr_end
#
# source://prism//lib/prism/lex_compat.rb#244
class Prism::LexCompat::IgnoreStateToken < ::Prism::LexCompat::Token
  # source://prism//lib/prism/lex_compat.rb#245
  def ==(other); end
end

# This is a mapping of prism token types to Ripper token types. This is a
# many-to-one mapping because we split up our token types, whereas Ripper
# tends to group them.
#
# source://prism//lib/prism/lex_compat.rb#31
Prism::LexCompat::RIPPER = T.let(T.unsafe(nil), Hash)

# A result class specialized for holding tokens produced by the lexer.
#
# source://prism//lib/prism/lex_compat.rb#12
class Prism::LexCompat::Result < ::Prism::Result
  # Create a new lex compat result object with the given values.
  #
  # @return [Result] a new instance of Result
  #
  # source://prism//lib/prism/lex_compat.rb#17
  def initialize(value, comments, magic_comments, data_loc, errors, warnings, source); end

  # Implement the hash pattern matching interface for Result.
  #
  # source://prism//lib/prism/lex_compat.rb#23
  def deconstruct_keys(keys); end

  # The list of tokens that were produced by the lexer.
  #
  # source://prism//lib/prism/lex_compat.rb#14
  def value; end
end

# When we produce tokens, we produce the same arrays that Ripper does.
# However, we add a couple of convenience methods onto them to make them a
# little easier to work with. We delegate all other methods to the array.
#
# source://prism//lib/prism/lex_compat.rb#202
class Prism::LexCompat::Token < ::BasicObject
  # Create a new token object with the given ripper-compatible array.
  #
  # @return [Token] a new instance of Token
  #
  # source://prism//lib/prism/lex_compat.rb#204
  def initialize(array); end

  # We want to pretend that this is just an Array.
  #
  # source://prism//lib/prism/lex_compat.rb#229
  def ==(other); end

  # The type of the token.
  #
  # source://prism//lib/prism/lex_compat.rb#214
  def event; end

  # The location of the token in the source.
  #
  # source://prism//lib/prism/lex_compat.rb#209
  def location; end

  # source://prism//lib/prism/lex_compat.rb#237
  def method_missing(name, *_arg1, **_arg2, &_arg3); end

  # The state of the lexer when this token was produced.
  #
  # source://prism//lib/prism/lex_compat.rb#224
  def state; end

  # The slice of the source that this token represents.
  #
  # source://prism//lib/prism/lex_compat.rb#219
  def value; end

  private

  # @return [Boolean]
  #
  # source://prism//lib/prism/lex_compat.rb#233
  def respond_to_missing?(name, include_private = T.unsafe(nil)); end
end

# This is a result specific to the `lex` and `lex_file` methods.
#
# source://prism//lib/prism/parse_result.rb#778
class Prism::LexResult < ::Prism::Result
  # Create a new lex result object with the given values.
  #
  # @return [LexResult] a new instance of LexResult
  #
  # source://prism//lib/prism/parse_result.rb#783
  sig do
    params(
      value: T::Array[T.untyped],
      comments: T::Array[Prism::Comment],
      magic_comments: T::Array[Prism::MagicComment],
      data_loc: T.nilable(Prism::Location),
      errors: T::Array[Prism::ParseError],
      warnings: T::Array[Prism::ParseWarning],
      source: Prism::Source
    ).void
  end
  def initialize(value, comments, magic_comments, data_loc, errors, warnings, source); end

  # Implement the hash pattern matching interface for LexResult.
  #
  # source://prism//lib/prism/parse_result.rb#789
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # The list of tokens that were parsed from the source code.
  #
  # source://prism//lib/prism/parse_result.rb#780
  sig { returns(T::Array[T.untyped]) }
  def value; end
end

# Represents the use of the `&&=` operator for assignment to a local variable.
#
#     target &&= value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#12513
class Prism::LocalVariableAndWriteNode < ::Prism::Node
  # Initialize a new LocalVariableAndWriteNode node.
  #
  # @return [LocalVariableAndWriteNode] a new instance of LocalVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#12515
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      depth: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, name_loc, operator_loc, value, name, depth); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12624
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12528
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12533
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12550
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12545
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node, ?name: Symbol, ?depth: Integer) -> LocalVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#12555
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableAndWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12560
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name_loc: Location, operator_loc: Location, value: Prism::node, name: Symbol, depth: Integer }
  #
  # source://prism//lib/prism/node.rb#12563
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader depth: Integer
  #
  # source://prism//lib/prism/node.rb#12600
  sig { returns(Integer) }
  def depth; end

  # source://prism//lib/prism/desugar_compiler.rb#237
  def desugar; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#12538
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12608
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#12597
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#12568
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#12603
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#12581
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#12576
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#12589
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12613
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#12594
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12618
    def type; end
  end
end

# Represents assigning to a local variable using an operator that isn't `=`.
#
#     target += value
#     ^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#12638
class Prism::LocalVariableOperatorWriteNode < ::Prism::Node
  # Initialize a new LocalVariableOperatorWriteNode node.
  #
  # @return [LocalVariableOperatorWriteNode] a new instance of LocalVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#12640
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      binary_operator: Symbol,
      depth: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, name_loc, binary_operator_loc, value, name, binary_operator, depth); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12748
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12654
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader binary_operator: Symbol
  #
  # source://prism//lib/prism/node.rb#12726
  sig { returns(Symbol) }
  def binary_operator; end

  # attr_reader binary_operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#12707
  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12659
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12676
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12671
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name_loc: Location, ?binary_operator_loc: Location, ?value: Prism::node, ?name: Symbol, ?binary_operator: Symbol, ?depth: Integer) -> LocalVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#12681
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      binary_operator: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableOperatorWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), name: T.unsafe(nil), binary_operator: T.unsafe(nil), depth: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12686
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name_loc: Location, binary_operator_loc: Location, value: Prism::node, name: Symbol, binary_operator: Symbol, depth: Integer }
  #
  # source://prism//lib/prism/node.rb#12689
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader depth: Integer
  #
  # source://prism//lib/prism/node.rb#12729
  sig { returns(Integer) }
  def depth; end

  # source://prism//lib/prism/desugar_compiler.rb#249
  def desugar; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#12664
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12732
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#12723
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#12694
  sig { returns(Prism::Location) }
  def name_loc; end

  # Returns the binary operator used to modify the receiver. This method is
  # deprecated in favor of #binary_operator.
  #
  # source://prism//lib/prism/node_ext.rb#454
  def operator; end

  # Returns the location of the binary operator used to modify the receiver.
  # This method is deprecated in favor of #binary_operator_loc.
  #
  # source://prism//lib/prism/node_ext.rb#461
  def operator_loc; end

  # Save the binary_operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#12715
  def save_binary_operator_loc(repository); end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#12702
  def save_name_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12737
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#12720
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12742
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to a local variable.
#
#     target ||= value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#12763
class Prism::LocalVariableOrWriteNode < ::Prism::Node
  # Initialize a new LocalVariableOrWriteNode node.
  #
  # @return [LocalVariableOrWriteNode] a new instance of LocalVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#12765
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      depth: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, name_loc, operator_loc, value, name, depth); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12874
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12778
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12783
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12800
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12795
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node, ?name: Symbol, ?depth: Integer) -> LocalVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#12805
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableOrWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12810
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name_loc: Location, operator_loc: Location, value: Prism::node, name: Symbol, depth: Integer }
  #
  # source://prism//lib/prism/node.rb#12813
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader depth: Integer
  #
  # source://prism//lib/prism/node.rb#12850
  sig { returns(Integer) }
  def depth; end

  # source://prism//lib/prism/desugar_compiler.rb#243
  def desugar; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#12788
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12858
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#12847
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#12818
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#12853
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#12831
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#12826
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#12839
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12863
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#12844
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12868
    def type; end
  end
end

# Represents reading a local variable. Note that this requires that a local variable of the same name has already been written to in the same scope, otherwise it is parsed as a method call.
#
#     foo
#     ^^^
#
# source://prism//lib/prism/node.rb#12888
class Prism::LocalVariableReadNode < ::Prism::Node
  # Initialize a new LocalVariableReadNode node.
  #
  # @return [LocalVariableReadNode] a new instance of LocalVariableReadNode
  #
  # source://prism//lib/prism/node.rb#12890
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, name, depth); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12975
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12900
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12905
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12921
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12916
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?depth: Integer) -> LocalVariableReadNode
  #
  # source://prism//lib/prism/node.rb#12926
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableReadNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#12931
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, depth: Integer }
  #
  # source://prism//lib/prism/node.rb#12934
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # The number of visible scopes that should be searched to find the origin of this local variable.
  #
  #     foo = 1; foo # depth 0
  #
  #     bar = 2; tap { bar } # depth 1
  #
  # The specific rules for calculating the depth may differ from individual Ruby implementations, as they are not specified by the language. For more information, see [the Prism documentation](https://github.com/ruby/prism/blob/main/docs/local_variable_depth.md).
  #
  # source://prism//lib/prism/node.rb#12956
  sig { returns(Integer) }
  def depth; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#12910
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12959
  sig { override.returns(String) }
  def inspect; end

  # The name of the local variable, which is an [identifier](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#identifiers).
  #
  #     x      # name `:x`
  #
  #     _Test  # name `:_Test`
  #
  # Note that this can also be an underscore followed by a number for the default block parameters.
  #
  #     _1     # name `:_1`
  #
  # source://prism//lib/prism/node.rb#12947
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12964
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12969
    def type; end
  end
end

# Represents writing to a local variable in a context that doesn't have an explicit value.
#
#     foo, bar = baz
#     ^^^  ^^^
#
#     foo => baz
#            ^^^
#
# source://prism//lib/prism/node.rb#12989
class Prism::LocalVariableTargetNode < ::Prism::Node
  # Initialize a new LocalVariableTargetNode node.
  #
  # @return [LocalVariableTargetNode] a new instance of LocalVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#12991
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, name, depth); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#13062
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13001
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#13006
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13022
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13017
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?depth: Integer) -> LocalVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#13027
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#13032
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, depth: Integer }
  #
  # source://prism//lib/prism/node.rb#13035
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader depth: Integer
  #
  # source://prism//lib/prism/node.rb#13043
  sig { returns(Integer) }
  def depth; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#13011
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#13046
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#13040
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#13051
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#13056
    def type; end
  end
end

# Represents writing to a local variable.
#
#     foo = 1
#     ^^^^^^^
#
# source://prism//lib/prism/node.rb#13073
class Prism::LocalVariableWriteNode < ::Prism::Node
  # Initialize a new LocalVariableWriteNode node.
  #
  # @return [LocalVariableWriteNode] a new instance of LocalVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#13075
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, name, depth, name_loc, value, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#13210
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13088
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#13093
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13110
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13105
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?depth: Integer, ?name_loc: Location, ?value: Prism::node, ?operator_loc: Location) -> LocalVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#13115
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::LocalVariableWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#13120
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, depth: Integer, name_loc: Location, value: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#13123
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # The number of semantic scopes we have to traverse to find the declaration of this variable.
  #
  #     foo = 1         # depth 0
  #
  #     tap { foo = 1 } # depth 1
  #
  # The specific rules for calculating the depth may differ from individual Ruby implementations, as they are not specified by the language. For more information, see [the Prism documentation](https://github.com/ruby/prism/blob/main/docs/local_variable_depth.md).
  #
  # source://prism//lib/prism/node.rb#13141
  sig { returns(Integer) }
  def depth; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#13098
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#13194
  sig { override.returns(String) }
  def inspect; end

  # The name of the local variable, which is an [identifier](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#identifiers).
  #
  #     foo = :bar # name `:foo`
  #
  #     abc = 123  # name `:abc`
  #
  # source://prism//lib/prism/node.rb#13132
  sig { returns(Symbol) }
  def name; end

  # The location of the variable name.
  #
  #     foo = :bar
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#13147
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#13189
  sig { returns(String) }
  def operator; end

  # The location of the `=` operator.
  #
  #     x = :y
  #       ^
  #
  # source://prism//lib/prism/node.rb#13176
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#13155
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#13184
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#13199
  sig { override.returns(Symbol) }
  def type; end

  # The value to write to the local variable. It can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     foo = :bar
  #           ^^^^
  #
  #     abc = 1234
  #           ^^^^
  #
  # Note that since the name of a local variable is known before the value is parsed, it is valid for a local variable to appear within the value of its own write.
  #
  #     foo = foo
  #
  # source://prism//lib/prism/node.rb#13170
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#13204
    def type; end
  end
end

# This represents a location in the source.
#
# source://prism//lib/prism/parse_result.rb#287
class Prism::Location
  # Create a new location object with the given source, start byte offset, and
  # byte length.
  #
  # @return [Location] a new instance of Location
  #
  # source://prism//lib/prism/parse_result.rb#302
  sig { params(source: Prism::Source, start_offset: Integer, length: Integer).void }
  def initialize(source, start_offset, length); end

  # Returns true if the given other location is equal to this location.
  #
  # source://prism//lib/prism/parse_result.rb#490
  sig { params(other: T.untyped).returns(T::Boolean) }
  def ==(other); end

  # Join this location with the first occurrence of the string in the source
  # that occurs after this location on the same line, and return the new
  # location. This will raise an error if the string does not exist.
  #
  # source://prism//lib/prism/parse_result.rb#509
  sig { params(string: String).returns(Prism::Location) }
  def adjoin(string); end

  # The end column in code units using the given cache to fetch or calculate
  # the value.
  #
  # source://prism//lib/prism/parse_result.rb#475
  sig do
    params(
      cache: T.any(Prism::CodeUnitsCache, T.proc.params(byte_offset: Integer).returns(Integer))
    ).returns(Integer)
  end
  def cached_end_code_units_column(cache); end

  # The end offset from the start of the file in code units using the given
  # cache to fetch or calculate the value.
  #
  # source://prism//lib/prism/parse_result.rb#411
  sig do
    params(
      cache: T.any(Prism::CodeUnitsCache, T.proc.params(byte_offset: Integer).returns(Integer))
    ).returns(Integer)
  end
  def cached_end_code_units_offset(cache); end

  # The start column in code units using the given cache to fetch or calculate
  # the value.
  #
  # source://prism//lib/prism/parse_result.rb#451
  sig do
    params(
      cache: T.any(Prism::CodeUnitsCache, T.proc.params(byte_offset: Integer).returns(Integer))
    ).returns(Integer)
  end
  def cached_start_code_units_column(cache); end

  # The start offset from the start of the file in code units using the given
  # cache to fetch or calculate the value.
  #
  # source://prism//lib/prism/parse_result.rb#389
  sig do
    params(
      cache: T.any(Prism::CodeUnitsCache, T.proc.params(byte_offset: Integer).returns(Integer))
    ).returns(Integer)
  end
  def cached_start_code_units_offset(cache); end

  # Returns a new location that is the result of chopping off the last byte.
  #
  # source://prism//lib/prism/parse_result.rb#348
  sig { returns(Prism::Location) }
  def chop; end

  # Returns all comments that are associated with this location (both leading
  # and trailing comments).
  #
  # source://prism//lib/prism/parse_result.rb#338
  sig { returns(T::Array[Prism::Comment]) }
  def comments; end

  # Create a new location object with the given options.
  #
  # source://prism//lib/prism/parse_result.rb#343
  sig { params(source: Prism::Source, start_offset: Integer, length: Integer).returns(Prism::Location) }
  def copy(source: T.unsafe(nil), start_offset: T.unsafe(nil), length: T.unsafe(nil)); end

  # Implement the hash pattern matching interface for Location.
  #
  # source://prism//lib/prism/parse_result.rb#480
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # The column number in characters where this location ends from the start of
  # the line.
  #
  # source://prism//lib/prism/parse_result.rb#463
  sig { returns(Integer) }
  def end_character_column; end

  # The character offset from the beginning of the source where this location
  # ends.
  #
  # source://prism//lib/prism/parse_result.rb#400
  sig { returns(Integer) }
  def end_character_offset; end

  # The column number in code units of the given encoding where this location
  # ends from the start of the line.
  #
  # source://prism//lib/prism/parse_result.rb#469
  sig { params(encoding: Encoding).returns(Integer) }
  def end_code_units_column(encoding = T.unsafe(nil)); end

  # The offset from the start of the file in code units of the given encoding.
  #
  # source://prism//lib/prism/parse_result.rb#405
  sig { params(encoding: Encoding).returns(Integer) }
  def end_code_units_offset(encoding = T.unsafe(nil)); end

  # The column number in bytes where this location ends from the start of the
  # line.
  #
  # source://prism//lib/prism/parse_result.rb#457
  sig { returns(Integer) }
  def end_column; end

  # The line number where this location ends.
  #
  # source://prism//lib/prism/parse_result.rb#427
  sig { returns(Integer) }
  def end_line; end

  # The byte offset from the beginning of the source where this location ends.
  #
  # source://prism//lib/prism/parse_result.rb#394
  sig { returns(Integer) }
  def end_offset; end

  # Returns a string representation of this location.
  #
  # source://prism//lib/prism/parse_result.rb#353
  sig { returns(String) }
  def inspect; end

  # Returns a new location that stretches from this location to the given
  # other location. Raises an error if this location is not before the other
  # location or if they don't share the same source.
  #
  # source://prism//lib/prism/parse_result.rb#499
  sig { params(other: Prism::Location).returns(Prism::Location) }
  def join(other); end

  # Attach a comment to the leading comments of this location.
  #
  # source://prism//lib/prism/parse_result.rb#321
  sig { params(comment: Prism::Comment).void }
  def leading_comment(comment); end

  # These are the comments that are associated with this location that exist
  # before the start of this location.
  #
  # source://prism//lib/prism/parse_result.rb#316
  sig { returns(T::Array[Prism::Comment]) }
  def leading_comments; end

  # The length of this location in bytes.
  #
  # source://prism//lib/prism/parse_result.rb#298
  sig { returns(Integer) }
  def length; end

  # Implement the pretty print interface for Location.
  #
  # source://prism//lib/prism/parse_result.rb#485
  sig { params(q: T.untyped).void }
  def pretty_print(q); end

  # The source code that this location represents.
  #
  # source://prism//lib/prism/parse_result.rb#363
  sig { returns(String) }
  def slice; end

  # The source code that this location represents starting from the beginning
  # of the line that this location starts on to the end of the line that this
  # location ends on.
  #
  # source://prism//lib/prism/parse_result.rb#370
  def slice_lines; end

  # Returns all of the lines of the source code associated with this location.
  #
  # source://prism//lib/prism/parse_result.rb#358
  sig { returns(T::Array[String]) }
  def source_lines; end

  # The column number in characters where this location ends from the start of
  # the line.
  #
  # source://prism//lib/prism/parse_result.rb#439
  sig { returns(Integer) }
  def start_character_column; end

  # The character offset from the beginning of the source where this location
  # starts.
  #
  # source://prism//lib/prism/parse_result.rb#378
  sig { returns(Integer) }
  def start_character_offset; end

  # The column number in code units of the given encoding where this location
  # starts from the start of the line.
  #
  # source://prism//lib/prism/parse_result.rb#445
  sig { params(encoding: Encoding).returns(Integer) }
  def start_code_units_column(encoding = T.unsafe(nil)); end

  # The offset from the start of the file in code units of the given encoding.
  #
  # source://prism//lib/prism/parse_result.rb#383
  sig { params(encoding: Encoding).returns(Integer) }
  def start_code_units_offset(encoding = T.unsafe(nil)); end

  # The column number in bytes where this location starts from the start of
  # the line.
  #
  # source://prism//lib/prism/parse_result.rb#433
  sig { returns(Integer) }
  def start_column; end

  # The line number where this location starts.
  #
  # source://prism//lib/prism/parse_result.rb#416
  sig { returns(Integer) }
  def start_line; end

  # The content of the line where this location starts before this location.
  #
  # source://prism//lib/prism/parse_result.rb#421
  sig { returns(String) }
  def start_line_slice; end

  # The byte offset from the beginning of the source where this location
  # starts.
  #
  # source://prism//lib/prism/parse_result.rb#295
  sig { returns(Integer) }
  def start_offset; end

  # Attach a comment to the trailing comments of this location.
  #
  # source://prism//lib/prism/parse_result.rb#332
  sig { params(comment: Prism::Comment).void }
  def trailing_comment(comment); end

  # These are the comments that are associated with this location that exist
  # after the end of this location.
  #
  # source://prism//lib/prism/parse_result.rb#327
  sig { returns(T::Array[Prism::Comment]) }
  def trailing_comments; end

  protected

  # A Source object that is used to determine more information from the given
  # offset and length.
  #
  # source://prism//lib/prism/parse_result.rb#290
  sig { returns(Prism::Source) }
  def source; end
end

# Flags for while and until loop nodes.
#
# source://prism//lib/prism/node.rb#19858
module Prism::LoopFlags; end

# a loop after a begin statement, so the body is executed first before the condition
#
# source://prism//lib/prism/node.rb#19860
Prism::LoopFlags::BEGIN_MODIFIER = T.let(T.unsafe(nil), Integer)

# This represents a magic comment that was encountered during parsing.
#
# source://prism//lib/prism/parse_result.rb#571
class Prism::MagicComment
  # Create a new magic comment object with the given key and value locations.
  #
  # @return [MagicComment] a new instance of MagicComment
  #
  # source://prism//lib/prism/parse_result.rb#579
  sig { params(key_loc: Prism::Location, value_loc: Prism::Location).void }
  def initialize(key_loc, value_loc); end

  # Implement the hash pattern matching interface for MagicComment.
  #
  # source://prism//lib/prism/parse_result.rb#595
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # Returns a string representation of this magic comment.
  #
  # source://prism//lib/prism/parse_result.rb#600
  sig { returns(String) }
  def inspect; end

  # Returns the key of the magic comment by slicing it from the source code.
  #
  # source://prism//lib/prism/parse_result.rb#585
  sig { returns(String) }
  def key; end

  # A Location object representing the location of the key in the source.
  #
  # source://prism//lib/prism/parse_result.rb#573
  sig { returns(Prism::Location) }
  def key_loc; end

  # Returns the value of the magic comment by slicing it from the source code.
  #
  # source://prism//lib/prism/parse_result.rb#590
  sig { returns(String) }
  def value; end

  # A Location object representing the location of the value in the source.
  #
  # source://prism//lib/prism/parse_result.rb#576
  sig { returns(Prism::Location) }
  def value_loc; end
end

# Represents a regular expression literal used in the predicate of a conditional to implicitly match against the last line read by an IO object.
#
#     if /foo/i then end
#        ^^^^^^
#
# source://prism//lib/prism/node.rb#13224
class Prism::MatchLastLineNode < ::Prism::Node
  include ::Prism::RegularExpressionOptions

  # Initialize a new MatchLastLineNode node.
  #
  # @return [MatchLastLineNode] a new instance of MatchLastLineNode
  #
  # source://prism//lib/prism/node.rb#13226
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      content_loc: Prism::Location,
      closing_loc: Prism::Location,
      unescaped: String
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, content_loc, closing_loc, unescaped); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#13405
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13238
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def ascii_8bit?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13302
  sig { returns(T::Boolean) }
  def ascii_8bit?; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#13243
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#13384
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#13358
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13259
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13254
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def content: () -> String
  #
  # source://prism//lib/prism/node.rb#13379
  sig { returns(String) }
  def content; end

  # attr_reader content_loc: Location
  #
  # source://prism//lib/prism/node.rb#13345
  sig { returns(Prism::Location) }
  def content_loc; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location, ?content_loc: Location, ?closing_loc: Location, ?unescaped: String) -> MatchLastLineNode
  #
  # source://prism//lib/prism/node.rb#13264
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      content_loc: Prism::Location,
      closing_loc: Prism::Location,
      unescaped: String
    ).returns(Prism::MatchLastLineNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), content_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), unescaped: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#13269
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location, content_loc: Location, closing_loc: Location, unescaped: String }
  #
  # source://prism//lib/prism/node.rb#13272
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#13248
  def each_child_node; end

  # def euc_jp?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13297
  sig { returns(T::Boolean) }
  def euc_jp?; end

  # def extended?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13282
  sig { returns(T::Boolean) }
  def extended?; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def forced_binary_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13322
  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  # def forced_us_ascii_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13327
  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  # def forced_utf8_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13317
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  # def ignore_case?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13277
  sig { returns(T::Boolean) }
  def ignore_case?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#13389
  sig { override.returns(String) }
  def inspect; end

  # def multi_line?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13287
  sig { returns(T::Boolean) }
  def multi_line?; end

  # def once?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13292
  sig { returns(T::Boolean) }
  def once?; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#13374
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#13332
  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(Integer) }
  def options; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#13366
  def save_closing_loc(repository); end

  # Save the content_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#13353
  def save_content_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#13340
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#13394
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader unescaped: String
  #
  # source://prism//lib/prism/node.rb#13371
  sig { returns(String) }
  def unescaped; end

  # def utf_8?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13312
  sig { returns(T::Boolean) }
  def utf_8?; end

  # def windows_31j?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13307
  sig { returns(T::Boolean) }
  def windows_31j?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#13399
    def type; end
  end
end

# Represents the use of the modifier `in` operator.
#
#     foo in bar
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#13419
class Prism::MatchPredicateNode < ::Prism::Node
  # Initialize a new MatchPredicateNode node.
  #
  # @return [MatchPredicateNode] a new instance of MatchPredicateNode
  #
  # source://prism//lib/prism/node.rb#13421
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      pattern: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, value, pattern, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#13513
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13432
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#13437
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13455
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13450
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?value: Prism::node, ?pattern: Prism::node, ?operator_loc: Location) -> MatchPredicateNode
  #
  # source://prism//lib/prism/node.rb#13460
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      pattern: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::MatchPredicateNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil), pattern: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#13465
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, value: Prism::node, pattern: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#13468
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#13442
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#13497
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#13492
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#13479
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader pattern: Prism::node
  #
  # source://prism//lib/prism/node.rb#13476
  sig { returns(Prism::Node) }
  def pattern; end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#13487
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#13502
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#13473
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#13507
    def type; end
  end
end

# Represents the use of the `=>` operator.
#
#     foo => bar
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#13525
class Prism::MatchRequiredNode < ::Prism::Node
  # Initialize a new MatchRequiredNode node.
  #
  # @return [MatchRequiredNode] a new instance of MatchRequiredNode
  #
  # source://prism//lib/prism/node.rb#13527
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      pattern: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, value, pattern, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#13667
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13538
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#13543
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13561
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13556
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?value: Prism::node, ?pattern: Prism::node, ?operator_loc: Location) -> MatchRequiredNode
  #
  # source://prism//lib/prism/node.rb#13566
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      pattern: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::MatchRequiredNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil), pattern: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#13571
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, value: Prism::node, pattern: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#13574
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#13548
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#13651
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#13646
  sig { returns(String) }
  def operator; end

  # The location of the operator.
  #
  #     foo => bar
  #         ^^
  #
  # source://prism//lib/prism/node.rb#13633
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Represents the right-hand side of the operator. The type of the node depends on the expression.
  #
  # Anything that looks like a local variable name (including `_`) will result in a `LocalVariableTargetNode`.
  #
  #     foo => a # This is equivalent to writing `a = foo`
  #            ^
  #
  # Using an explicit `Array` or combining expressions with `,` will result in a `ArrayPatternNode`. This can be preceded by a constant.
  #
  #     foo => [a]
  #            ^^^
  #
  #     foo => a, b
  #            ^^^^
  #
  #     foo => Bar[a, b]
  #            ^^^^^^^^^
  #
  # If the array pattern contains at least two wildcard matches, a `FindPatternNode` is created instead.
  #
  #     foo => *, 1, *a
  #            ^^^^^
  #
  # Using an explicit `Hash` or a constant with square brackets and hash keys in the square brackets will result in a `HashPatternNode`.
  #
  #     foo => { a: 1, b: }
  #
  #     foo => Bar[a: 1, b:]
  #
  #     foo => Bar[**]
  #
  # To use any variable that needs run time evaluation, pinning is required. This results in a `PinnedVariableNode`
  #
  #     foo => ^a
  #            ^^
  #
  # Similar, any expression can be used with pinning. This results in a `PinnedExpressionNode`.
  #
  #     foo => ^(a + 1)
  #
  # Anything else will result in the regular node for that expression, for example a `ConstantReadNode`.
  #
  #     foo => CONST
  #
  # source://prism//lib/prism/node.rb#13627
  sig { returns(Prism::Node) }
  def pattern; end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#13641
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#13656
  sig { override.returns(Symbol) }
  def type; end

  # Represents the left-hand side of the operator.
  #
  #     foo => bar
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#13582
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#13661
    def type; end
  end
end

# Represents writing local variables using a regular expression match with named capture groups.
#
#     /(?<foo>bar)/ =~ baz
#     ^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#13679
class Prism::MatchWriteNode < ::Prism::Node
  # Initialize a new MatchWriteNode node.
  #
  # @return [MatchWriteNode] a new instance of MatchWriteNode
  #
  # source://prism//lib/prism/node.rb#13681
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      call: Prism::CallNode,
      targets: T::Array[Prism::LocalVariableTargetNode]
    ).void
  end
  def initialize(source, node_id, location, flags, call, targets); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#13754
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13691
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader call: CallNode
  #
  # source://prism//lib/prism/node.rb#13732
  sig { returns(Prism::CallNode) }
  def call; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#13696
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13714
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13709
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?call: CallNode, ?targets: Array[LocalVariableTargetNode]) -> MatchWriteNode
  #
  # source://prism//lib/prism/node.rb#13719
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      call: Prism::CallNode,
      targets: T::Array[Prism::LocalVariableTargetNode]
    ).returns(Prism::MatchWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), call: T.unsafe(nil), targets: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#13724
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, call: CallNode, targets: Array[LocalVariableTargetNode] }
  #
  # source://prism//lib/prism/node.rb#13727
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [call]
  #
  # source://prism//lib/prism/node.rb#13701
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#13738
  sig { override.returns(String) }
  def inspect; end

  # attr_reader targets: Array[LocalVariableTargetNode]
  #
  # source://prism//lib/prism/node.rb#13735
  sig { returns(T::Array[Prism::LocalVariableTargetNode]) }
  def targets; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#13743
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#13748
    def type; end
  end
end

# Represents a node that is missing from the source and results in a syntax error.
#
# source://prism//lib/prism/node.rb#13763
class Prism::MissingNode < ::Prism::Node
  # Initialize a new MissingNode node.
  #
  # @return [MissingNode] a new instance of MissingNode
  #
  # source://prism//lib/prism/node.rb#13765
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#13828
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13773
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#13778
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13794
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13789
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> MissingNode
  #
  # source://prism//lib/prism/node.rb#13799
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::MissingNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#13804
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#13807
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#13783
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#13812
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#13817
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#13822
    def type; end
  end
end

# Represents a module declaration involving the `module` keyword.
#
#     module Foo end
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#13837
class Prism::ModuleNode < ::Prism::Node
  # Initialize a new ModuleNode node.
  #
  # @return [ModuleNode] a new instance of ModuleNode
  #
  # source://prism//lib/prism/node.rb#13839
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      module_keyword_loc: Prism::Location,
      constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::MissingNode),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      end_keyword_loc: Prism::Location,
      name: Symbol
    ).void
  end
  def initialize(source, node_id, location, flags, locals, module_keyword_loc, constant_path, body, end_keyword_loc, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#13961
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13853
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader body: StatementsNode | BeginNode | nil
  #
  # source://prism//lib/prism/node.rb#13916
  sig { returns(T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))) }
  def body; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#13858
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13879
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13871
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # attr_reader constant_path: ConstantReadNode | ConstantPathNode | MissingNode
  #
  # source://prism//lib/prism/node.rb#13913
  sig { returns(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::MissingNode)) }
  def constant_path; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?locals: Array[Symbol], ?module_keyword_loc: Location, ?constant_path: ConstantReadNode | ConstantPathNode | MissingNode, ?body: StatementsNode | BeginNode | nil, ?end_keyword_loc: Location, ?name: Symbol) -> ModuleNode
  #
  # source://prism//lib/prism/node.rb#13884
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      module_keyword_loc: Prism::Location,
      constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::MissingNode),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      end_keyword_loc: Prism::Location,
      name: Symbol
    ).returns(Prism::ModuleNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), module_keyword_loc: T.unsafe(nil), constant_path: T.unsafe(nil), body: T.unsafe(nil), end_keyword_loc: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#13889
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, locals: Array[Symbol], module_keyword_loc: Location, constant_path: ConstantReadNode | ConstantPathNode | MissingNode, body: StatementsNode | BeginNode | nil, end_keyword_loc: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#13892
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [constant_path]
  #
  # source://prism//lib/prism/node.rb#13863
  def each_child_node; end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#13940
  sig { returns(String) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#13919
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#13945
  sig { override.returns(String) }
  def inspect; end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#13897
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # def module_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#13935
  sig { returns(String) }
  def module_keyword; end

  # attr_reader module_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#13900
  sig { returns(Prism::Location) }
  def module_keyword_loc; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#13932
  sig { returns(Symbol) }
  def name; end

  # Save the end_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#13927
  def save_end_keyword_loc(repository); end

  # Save the module_keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#13908
  def save_module_keyword_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#13950
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#13955
    def type; end
  end
end

# Represents a multi-target expression.
#
#     a, (b, c) = 1, 2, 3
#        ^^^^^^
#
# This can be a part of `MultiWriteNode` as above, or the target of a `for` loop
#
#     for a, b in [[1, 2], [3, 4]]
#         ^^^^
#
# source://prism//lib/prism/node.rb#13982
class Prism::MultiTargetNode < ::Prism::Node
  # Initialize a new MultiTargetNode node.
  #
  # @return [MultiTargetNode] a new instance of MultiTargetNode
  #
  # source://prism//lib/prism/node.rb#13984
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)),
      rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, lefts, rest, rights, lparen_loc, rparen_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14146
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13997
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14002
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14025
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14016
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?lefts: Array[LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | RequiredParameterNode | BackReferenceReadNode | NumberedReferenceReadNode], ?rest: ImplicitRestNode | SplatNode | nil, ?rights: Array[LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | RequiredParameterNode | BackReferenceReadNode | NumberedReferenceReadNode], ?lparen_loc: Location?, ?rparen_loc: Location?) -> MultiTargetNode
  #
  # source://prism//lib/prism/node.rb#14030
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)),
      rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location)
    ).returns(Prism::MultiTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), lefts: T.unsafe(nil), rest: T.unsafe(nil), rights: T.unsafe(nil), lparen_loc: T.unsafe(nil), rparen_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14035
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, lefts: Array[LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | RequiredParameterNode | BackReferenceReadNode | NumberedReferenceReadNode], rest: ImplicitRestNode | SplatNode | nil, rights: Array[LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | RequiredParameterNode | BackReferenceReadNode | NumberedReferenceReadNode], lparen_loc: Location?, rparen_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#14038
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [rest]
  #
  # source://prism//lib/prism/node.rb#14007
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14130
  sig { override.returns(String) }
  def inspect; end

  # Represents the targets expressions before a splat node.
  #
  #     a, (b, c, *) = 1, 2, 3, 4, 5
  #         ^^^^
  #
  # The splat node can be absent, in that case all target expressions are in the left field.
  #
  #     a, (b, c) = 1, 2, 3, 4, 5
  #         ^^^^
  #
  # source://prism//lib/prism/node.rb#14051
  sig do
    returns(T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)])
  end
  def lefts; end

  # def lparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#14120
  sig { returns(T.nilable(String)) }
  def lparen; end

  # The location of the opening parenthesis.
  #
  #     a, (b, c) = 1, 2, 3
  #        ^
  #
  # source://prism//lib/prism/node.rb#14079
  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  # Represents a splat node in the target expression.
  #
  #     a, (b, *c) = 1, 2, 3, 4
  #            ^^
  #
  # The variable can be empty, this results in a `SplatNode` with a `nil` expression field.
  #
  #     a, (b, *) = 1, 2, 3, 4
  #            ^
  #
  # If the `*` is omitted, this field will contain an `ImplicitRestNode`
  #
  #     a, (b,) = 1, 2, 3, 4
  #          ^
  #
  # source://prism//lib/prism/node.rb#14067
  sig { returns(T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode))) }
  def rest; end

  # Represents the targets expressions after a splat node.
  #
  #     a, (*, b, c) = 1, 2, 3, 4, 5
  #            ^^^^
  #
  # source://prism//lib/prism/node.rb#14073
  sig do
    returns(T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)])
  end
  def rights; end

  # def rparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#14125
  sig { returns(T.nilable(String)) }
  def rparen; end

  # The location of the closing parenthesis.
  #
  #     a, (b, c) = 1, 2, 3
  #             ^
  #
  # source://prism//lib/prism/node.rb#14101
  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  # Save the lparen_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#14093
  def save_lparen_loc(repository); end

  # Save the rparen_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#14115
  def save_rparen_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14135
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14140
    def type; end
  end
end

# Represents a write to a multi-target expression.
#
#     a, b, c = 1, 2, 3
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#14162
class Prism::MultiWriteNode < ::Prism::Node
  # Initialize a new MultiWriteNode node.
  #
  # @return [MultiWriteNode] a new instance of MultiWriteNode
  #
  # source://prism//lib/prism/node.rb#14164
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)),
      rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, lefts, rest, rights, lparen_loc, rparen_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14357
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14179
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14184
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14209
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14199
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?lefts: Array[LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | BackReferenceReadNode | NumberedReferenceReadNode], ?rest: ImplicitRestNode | SplatNode | nil, ?rights: Array[LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | BackReferenceReadNode | NumberedReferenceReadNode], ?lparen_loc: Location?, ?rparen_loc: Location?, ?operator_loc: Location, ?value: Prism::node) -> MultiWriteNode
  #
  # source://prism//lib/prism/node.rb#14214
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)),
      rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::MultiWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), lefts: T.unsafe(nil), rest: T.unsafe(nil), rights: T.unsafe(nil), lparen_loc: T.unsafe(nil), rparen_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14219
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, lefts: Array[LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | BackReferenceReadNode | NumberedReferenceReadNode], rest: ImplicitRestNode | SplatNode | nil, rights: Array[LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | BackReferenceReadNode | NumberedReferenceReadNode], lparen_loc: Location?, rparen_loc: Location?, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#14222
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [rest]
  #
  # source://prism//lib/prism/node.rb#14189
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14341
  sig { override.returns(String) }
  def inspect; end

  # Represents the targets expressions before a splat node.
  #
  #     a, b, * = 1, 2, 3, 4, 5
  #     ^^^^
  #
  # The splat node can be absent, in that case all target expressions are in the left field.
  #
  #     a, b, c = 1, 2, 3, 4, 5
  #     ^^^^^^^
  #
  # source://prism//lib/prism/node.rb#14235
  sig do
    returns(T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)])
  end
  def lefts; end

  # def lparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#14326
  sig { returns(T.nilable(String)) }
  def lparen; end

  # The location of the opening parenthesis.
  #
  #     (a, b, c) = 1, 2, 3
  #     ^
  #
  # source://prism//lib/prism/node.rb#14263
  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#14336
  sig { returns(String) }
  def operator; end

  # The location of the operator.
  #
  #     a, b, c = 1, 2, 3
  #             ^
  #
  # source://prism//lib/prism/node.rb#14307
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Represents a splat node in the target expression.
  #
  #     a, b, *c = 1, 2, 3, 4
  #           ^^
  #
  # The variable can be empty, this results in a `SplatNode` with a `nil` expression field.
  #
  #     a, b, * = 1, 2, 3, 4
  #           ^
  #
  # If the `*` is omitted, this field will contain an `ImplicitRestNode`
  #
  #     a, b, = 1, 2, 3, 4
  #         ^
  #
  # source://prism//lib/prism/node.rb#14251
  sig { returns(T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode))) }
  def rest; end

  # Represents the targets expressions after a splat node.
  #
  #     a, *, b, c = 1, 2, 3, 4, 5
  #           ^^^^
  #
  # source://prism//lib/prism/node.rb#14257
  sig do
    returns(T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)])
  end
  def rights; end

  # def rparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#14331
  sig { returns(T.nilable(String)) }
  def rparen; end

  # The location of the closing parenthesis.
  #
  #     (a, b, c) = 1, 2, 3
  #             ^
  #
  # source://prism//lib/prism/node.rb#14285
  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  # Save the lparen_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#14277
  def save_lparen_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#14315
  def save_operator_loc(repository); end

  # Save the rparen_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#14299
  def save_rparen_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14346
  sig { override.returns(Symbol) }
  def type; end

  # The value to write to the targets. It can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     a, b, c = 1, 2, 3
  #               ^^^^^^^
  #
  # source://prism//lib/prism/node.rb#14323
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14351
    def type; end
  end
end

# This visitor walks through the tree and copies each node as it is being
# visited. This is useful for consumers that want to mutate the tree, as you
# can change subtrees in place without effecting the rest of the tree.
#
# source://prism//lib/prism/mutation_compiler.rb#16
class Prism::MutationCompiler < ::Prism::Compiler
  # Copy a AliasGlobalVariableNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#18
  def visit_alias_global_variable_node(node); end

  # Copy a AliasMethodNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#23
  def visit_alias_method_node(node); end

  # Copy a AlternationPatternNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#28
  def visit_alternation_pattern_node(node); end

  # Copy a AndNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#33
  def visit_and_node(node); end

  # Copy a ArgumentsNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#38
  def visit_arguments_node(node); end

  # Copy a ArrayNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#43
  def visit_array_node(node); end

  # Copy a ArrayPatternNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#48
  def visit_array_pattern_node(node); end

  # Copy a AssocNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#53
  def visit_assoc_node(node); end

  # Copy a AssocSplatNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#58
  def visit_assoc_splat_node(node); end

  # Copy a BackReferenceReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#63
  def visit_back_reference_read_node(node); end

  # Copy a BeginNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#68
  def visit_begin_node(node); end

  # Copy a BlockArgumentNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#73
  def visit_block_argument_node(node); end

  # Copy a BlockLocalVariableNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#78
  def visit_block_local_variable_node(node); end

  # Copy a BlockNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#83
  def visit_block_node(node); end

  # Copy a BlockParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#88
  def visit_block_parameter_node(node); end

  # Copy a BlockParametersNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#93
  def visit_block_parameters_node(node); end

  # Copy a BreakNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#98
  def visit_break_node(node); end

  # Copy a CallAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#103
  def visit_call_and_write_node(node); end

  # Copy a CallNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#108
  def visit_call_node(node); end

  # Copy a CallOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#113
  def visit_call_operator_write_node(node); end

  # Copy a CallOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#118
  def visit_call_or_write_node(node); end

  # Copy a CallTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#123
  def visit_call_target_node(node); end

  # Copy a CapturePatternNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#128
  def visit_capture_pattern_node(node); end

  # Copy a CaseMatchNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#133
  def visit_case_match_node(node); end

  # Copy a CaseNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#138
  def visit_case_node(node); end

  # Copy a ClassNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#143
  def visit_class_node(node); end

  # Copy a ClassVariableAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#148
  def visit_class_variable_and_write_node(node); end

  # Copy a ClassVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#153
  def visit_class_variable_operator_write_node(node); end

  # Copy a ClassVariableOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#158
  def visit_class_variable_or_write_node(node); end

  # Copy a ClassVariableReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#163
  def visit_class_variable_read_node(node); end

  # Copy a ClassVariableTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#168
  def visit_class_variable_target_node(node); end

  # Copy a ClassVariableWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#173
  def visit_class_variable_write_node(node); end

  # Copy a ConstantAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#178
  def visit_constant_and_write_node(node); end

  # Copy a ConstantOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#183
  def visit_constant_operator_write_node(node); end

  # Copy a ConstantOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#188
  def visit_constant_or_write_node(node); end

  # Copy a ConstantPathAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#193
  def visit_constant_path_and_write_node(node); end

  # Copy a ConstantPathNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#198
  def visit_constant_path_node(node); end

  # Copy a ConstantPathOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#203
  def visit_constant_path_operator_write_node(node); end

  # Copy a ConstantPathOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#208
  def visit_constant_path_or_write_node(node); end

  # Copy a ConstantPathTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#213
  def visit_constant_path_target_node(node); end

  # Copy a ConstantPathWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#218
  def visit_constant_path_write_node(node); end

  # Copy a ConstantReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#223
  def visit_constant_read_node(node); end

  # Copy a ConstantTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#228
  def visit_constant_target_node(node); end

  # Copy a ConstantWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#233
  def visit_constant_write_node(node); end

  # Copy a DefNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#238
  def visit_def_node(node); end

  # Copy a DefinedNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#243
  def visit_defined_node(node); end

  # Copy a ElseNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#248
  def visit_else_node(node); end

  # Copy a EmbeddedStatementsNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#253
  def visit_embedded_statements_node(node); end

  # Copy a EmbeddedVariableNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#258
  def visit_embedded_variable_node(node); end

  # Copy a EnsureNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#263
  def visit_ensure_node(node); end

  # Copy a FalseNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#268
  def visit_false_node(node); end

  # Copy a FindPatternNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#273
  def visit_find_pattern_node(node); end

  # Copy a FlipFlopNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#278
  def visit_flip_flop_node(node); end

  # Copy a FloatNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#283
  def visit_float_node(node); end

  # Copy a ForNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#288
  def visit_for_node(node); end

  # Copy a ForwardingArgumentsNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#293
  def visit_forwarding_arguments_node(node); end

  # Copy a ForwardingParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#298
  def visit_forwarding_parameter_node(node); end

  # Copy a ForwardingSuperNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#303
  def visit_forwarding_super_node(node); end

  # Copy a GlobalVariableAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#308
  def visit_global_variable_and_write_node(node); end

  # Copy a GlobalVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#313
  def visit_global_variable_operator_write_node(node); end

  # Copy a GlobalVariableOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#318
  def visit_global_variable_or_write_node(node); end

  # Copy a GlobalVariableReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#323
  def visit_global_variable_read_node(node); end

  # Copy a GlobalVariableTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#328
  def visit_global_variable_target_node(node); end

  # Copy a GlobalVariableWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#333
  def visit_global_variable_write_node(node); end

  # Copy a HashNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#338
  def visit_hash_node(node); end

  # Copy a HashPatternNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#343
  def visit_hash_pattern_node(node); end

  # Copy a IfNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#348
  def visit_if_node(node); end

  # Copy a ImaginaryNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#353
  def visit_imaginary_node(node); end

  # Copy a ImplicitNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#358
  def visit_implicit_node(node); end

  # Copy a ImplicitRestNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#363
  def visit_implicit_rest_node(node); end

  # Copy a InNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#368
  def visit_in_node(node); end

  # Copy a IndexAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#373
  def visit_index_and_write_node(node); end

  # Copy a IndexOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#378
  def visit_index_operator_write_node(node); end

  # Copy a IndexOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#383
  def visit_index_or_write_node(node); end

  # Copy a IndexTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#388
  def visit_index_target_node(node); end

  # Copy a InstanceVariableAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#393
  def visit_instance_variable_and_write_node(node); end

  # Copy a InstanceVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#398
  def visit_instance_variable_operator_write_node(node); end

  # Copy a InstanceVariableOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#403
  def visit_instance_variable_or_write_node(node); end

  # Copy a InstanceVariableReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#408
  def visit_instance_variable_read_node(node); end

  # Copy a InstanceVariableTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#413
  def visit_instance_variable_target_node(node); end

  # Copy a InstanceVariableWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#418
  def visit_instance_variable_write_node(node); end

  # Copy a IntegerNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#423
  def visit_integer_node(node); end

  # Copy a InterpolatedMatchLastLineNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#428
  def visit_interpolated_match_last_line_node(node); end

  # Copy a InterpolatedRegularExpressionNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#433
  def visit_interpolated_regular_expression_node(node); end

  # Copy a InterpolatedStringNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#438
  def visit_interpolated_string_node(node); end

  # Copy a InterpolatedSymbolNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#443
  def visit_interpolated_symbol_node(node); end

  # Copy a InterpolatedXStringNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#448
  def visit_interpolated_x_string_node(node); end

  # Copy a ItLocalVariableReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#453
  def visit_it_local_variable_read_node(node); end

  # Copy a ItParametersNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#458
  def visit_it_parameters_node(node); end

  # Copy a KeywordHashNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#463
  def visit_keyword_hash_node(node); end

  # Copy a KeywordRestParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#468
  def visit_keyword_rest_parameter_node(node); end

  # Copy a LambdaNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#473
  def visit_lambda_node(node); end

  # Copy a LocalVariableAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#478
  def visit_local_variable_and_write_node(node); end

  # Copy a LocalVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#483
  def visit_local_variable_operator_write_node(node); end

  # Copy a LocalVariableOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#488
  def visit_local_variable_or_write_node(node); end

  # Copy a LocalVariableReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#493
  def visit_local_variable_read_node(node); end

  # Copy a LocalVariableTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#498
  def visit_local_variable_target_node(node); end

  # Copy a LocalVariableWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#503
  def visit_local_variable_write_node(node); end

  # Copy a MatchLastLineNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#508
  def visit_match_last_line_node(node); end

  # Copy a MatchPredicateNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#513
  def visit_match_predicate_node(node); end

  # Copy a MatchRequiredNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#518
  def visit_match_required_node(node); end

  # Copy a MatchWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#523
  def visit_match_write_node(node); end

  # Copy a MissingNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#528
  def visit_missing_node(node); end

  # Copy a ModuleNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#533
  def visit_module_node(node); end

  # Copy a MultiTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#538
  def visit_multi_target_node(node); end

  # Copy a MultiWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#543
  def visit_multi_write_node(node); end

  # Copy a NextNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#548
  def visit_next_node(node); end

  # Copy a NilNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#553
  def visit_nil_node(node); end

  # Copy a NoKeywordsParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#558
  def visit_no_keywords_parameter_node(node); end

  # Copy a NumberedParametersNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#563
  def visit_numbered_parameters_node(node); end

  # Copy a NumberedReferenceReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#568
  def visit_numbered_reference_read_node(node); end

  # Copy a OptionalKeywordParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#573
  def visit_optional_keyword_parameter_node(node); end

  # Copy a OptionalParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#578
  def visit_optional_parameter_node(node); end

  # Copy a OrNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#583
  def visit_or_node(node); end

  # Copy a ParametersNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#588
  def visit_parameters_node(node); end

  # Copy a ParenthesesNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#593
  def visit_parentheses_node(node); end

  # Copy a PinnedExpressionNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#598
  def visit_pinned_expression_node(node); end

  # Copy a PinnedVariableNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#603
  def visit_pinned_variable_node(node); end

  # Copy a PostExecutionNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#608
  def visit_post_execution_node(node); end

  # Copy a PreExecutionNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#613
  def visit_pre_execution_node(node); end

  # Copy a ProgramNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#618
  def visit_program_node(node); end

  # Copy a RangeNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#623
  def visit_range_node(node); end

  # Copy a RationalNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#628
  def visit_rational_node(node); end

  # Copy a RedoNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#633
  def visit_redo_node(node); end

  # Copy a RegularExpressionNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#638
  def visit_regular_expression_node(node); end

  # Copy a RequiredKeywordParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#643
  def visit_required_keyword_parameter_node(node); end

  # Copy a RequiredParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#648
  def visit_required_parameter_node(node); end

  # Copy a RescueModifierNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#653
  def visit_rescue_modifier_node(node); end

  # Copy a RescueNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#658
  def visit_rescue_node(node); end

  # Copy a RestParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#663
  def visit_rest_parameter_node(node); end

  # Copy a RetryNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#668
  def visit_retry_node(node); end

  # Copy a ReturnNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#673
  def visit_return_node(node); end

  # Copy a SelfNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#678
  def visit_self_node(node); end

  # Copy a ShareableConstantNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#683
  def visit_shareable_constant_node(node); end

  # Copy a SingletonClassNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#688
  def visit_singleton_class_node(node); end

  # Copy a SourceEncodingNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#693
  def visit_source_encoding_node(node); end

  # Copy a SourceFileNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#698
  def visit_source_file_node(node); end

  # Copy a SourceLineNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#703
  def visit_source_line_node(node); end

  # Copy a SplatNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#708
  def visit_splat_node(node); end

  # Copy a StatementsNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#713
  def visit_statements_node(node); end

  # Copy a StringNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#718
  def visit_string_node(node); end

  # Copy a SuperNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#723
  def visit_super_node(node); end

  # Copy a SymbolNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#728
  def visit_symbol_node(node); end

  # Copy a TrueNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#733
  def visit_true_node(node); end

  # Copy a UndefNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#738
  def visit_undef_node(node); end

  # Copy a UnlessNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#743
  def visit_unless_node(node); end

  # Copy a UntilNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#748
  def visit_until_node(node); end

  # Copy a WhenNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#753
  def visit_when_node(node); end

  # Copy a WhileNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#758
  def visit_while_node(node); end

  # Copy a XStringNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#763
  def visit_x_string_node(node); end

  # Copy a YieldNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#768
  def visit_yield_node(node); end
end

# Represents the use of the `next` keyword.
#
#     next 1
#     ^^^^^^
#
# source://prism//lib/prism/node.rb#14375
class Prism::NextNode < ::Prism::Node
  # Initialize a new NextNode node.
  #
  # @return [NextNode] a new instance of NextNode
  #
  # source://prism//lib/prism/node.rb#14377
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T.nilable(Prism::ArgumentsNode),
      keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, arguments, keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14466
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14387
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#14429
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14392
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14411
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14404
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?arguments: ArgumentsNode?, ?keyword_loc: Location) -> NextNode
  #
  # source://prism//lib/prism/node.rb#14416
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T.nilable(Prism::ArgumentsNode),
      keyword_loc: Prism::Location
    ).returns(Prism::NextNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), arguments: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14421
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, arguments: ArgumentsNode?, keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#14424
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [arguments]
  #
  # source://prism//lib/prism/node.rb#14397
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14450
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#14445
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#14432
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # Save the keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#14440
  def save_keyword_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14455
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14460
    def type; end
  end
end

# Represents the use of the `nil` keyword.
#
#     nil
#     ^^^
#
# source://prism//lib/prism/node.rb#14477
class Prism::NilNode < ::Prism::Node
  # Initialize a new NilNode node.
  #
  # @return [NilNode] a new instance of NilNode
  #
  # source://prism//lib/prism/node.rb#14479
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14542
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14487
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14492
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14508
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14503
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> NilNode
  #
  # source://prism//lib/prism/node.rb#14513
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::NilNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14518
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#14521
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#14497
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14526
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14531
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14536
    def type; end
  end
end

# Represents the use of `**nil` inside method arguments.
#
#     def a(**nil)
#           ^^^^^
#     end
#
# source://prism//lib/prism/node.rb#14552
class Prism::NoKeywordsParameterNode < ::Prism::Node
  # Initialize a new NoKeywordsParameterNode node.
  #
  # @return [NoKeywordsParameterNode] a new instance of NoKeywordsParameterNode
  #
  # source://prism//lib/prism/node.rb#14554
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      operator_loc: Prism::Location,
      keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, operator_loc, keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14655
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14564
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14569
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14585
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14580
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?operator_loc: Location, ?keyword_loc: Location) -> NoKeywordsParameterNode
  #
  # source://prism//lib/prism/node.rb#14590
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      operator_loc: Prism::Location,
      keyword_loc: Prism::Location
    ).returns(Prism::NoKeywordsParameterNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), operator_loc: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14595
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, operator_loc: Location, keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#14598
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#14574
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14639
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#14634
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#14616
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#14629
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#14603
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#14624
  def save_keyword_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#14611
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14644
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14649
    def type; end
  end
end

# This represents a node in the tree. It is the parent class of all of the
# various node types.
#
# source://prism//lib/prism/node.rb#15
class Prism::Node
  abstract!

  # Accepts a visitor and calls back into the specialized visit function.
  #
  # @raise [NoMethodError]
  #
  # source://prism//lib/prism/node.rb#269
  sig { abstract.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # Returns the first node that matches the given block when visited in a
  # breadth-first search. This is useful for finding a node that matches a
  # particular condition.
  #
  #     node.breadth_first_search { |node| node.node_id == node_id }
  #
  # source://prism//lib/prism/node.rb#219
  sig { params(block: T.proc.params(node: Prism::Node).returns(T::Boolean)).returns(T.nilable(Prism::Node)) }
  def breadth_first_search(&block); end

  # Returns all of the nodes that match the given block when visited in a
  # breadth-first search. This is useful for finding all nodes that match a
  # particular condition.
  #
  #     node.breadth_first_search_all { |node| node.is_a?(Prism::CallNode) }
  #
  # source://prism//lib/prism/node.rb#237
  sig { params(block: T.proc.params(node: Prism::Node).returns(T::Boolean)).returns(T::Array[Prism::Node]) }
  def breadth_first_search_all(&block); end

  # Delegates to the cached_end_code_units_column of the associated location
  # object.
  #
  # source://prism//lib/prism/node.rb#118
  def cached_end_code_units_column(cache); end

  # Delegates to the cached_end_code_units_offset of the associated location
  # object.
  #
  # source://prism//lib/prism/node.rb#86
  def cached_end_code_units_offset(cache); end

  # Delegates to the cached_start_code_units_column of the associated location
  # object.
  #
  # source://prism//lib/prism/node.rb#112
  def cached_start_code_units_column(cache); end

  # Delegates to the cached_start_code_units_offset of the associated location
  # object.
  #
  # source://prism//lib/prism/node.rb#80
  def cached_start_code_units_offset(cache); end

  # Returns an array of child nodes, including `nil`s in the place of optional
  # nodes that were not present.
  #
  # @raise [NoMethodError]
  #
  # source://prism//lib/prism/node.rb#275
  sig { abstract.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # Returns an array of child nodes and locations that could potentially have
  # comments attached to them.
  #
  # @raise [NoMethodError]
  #
  # source://prism//lib/prism/node.rb#296
  sig { abstract.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # Delegates to the comments of the associated location object.
  #
  # source://prism//lib/prism/node.rb#133
  def comments; end

  # Returns an array of child nodes, excluding any `nil`s in the place of
  # optional nodes that were not present.
  #
  # @raise [NoMethodError]
  #
  # source://prism//lib/prism/node.rb#290
  sig { abstract.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # Returns an array of child nodes, including `nil`s in the place of optional
  # nodes that were not present.
  #
  # @raise [NoMethodError]
  #
  # source://prism//lib/prism/node.rb#279
  sig { abstract.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # source://prism//lib/prism/node_ext.rb#10
  def deprecated(*replacements); end

  # With a block given, yields each child node. Without a block, returns
  # an enumerator that contains each child node. Excludes any `nil`s in
  # the place of optional nodes that were not present.
  #
  # @raise [NoMethodError]
  #
  # source://prism//lib/prism/node.rb#284
  def each_child_node; end

  # Delegates to the end_character_column of the associated location object.
  #
  # source://prism//lib/prism/node.rb#106
  def end_character_column; end

  # Delegates to the end_character_offset of the associated location object.
  #
  # source://prism//lib/prism/node.rb#74
  def end_character_offset; end

  # Delegates to the end_column of the associated location object.
  #
  # source://prism//lib/prism/node.rb#96
  def end_column; end

  # Delegates to the end_line of the associated location object.
  #
  # source://prism//lib/prism/node.rb#50
  def end_line; end

  # The end offset of the node in the source. This method is effectively a
  # delegate method to the location object.
  #
  # source://prism//lib/prism/node.rb#63
  sig { returns(Integer) }
  def end_offset; end

  sig { abstract.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # Returns the first node that matches the given block when visited in a
  # breadth-first search. This is useful for finding a node that matches a
  # particular condition.
  #
  #     node.breadth_first_search { |node| node.node_id == node_id }
  #
  # source://prism//lib/prism/node.rb#229
  def find(&block); end

  # Returns all of the nodes that match the given block when visited in a
  # breadth-first search. This is useful for finding all nodes that match a
  # particular condition.
  #
  #     node.breadth_first_search_all { |node| node.is_a?(Prism::CallNode) }
  #
  # source://prism//lib/prism/node.rb#248
  def find_all(&block); end

  # Returns a string representation of the node.
  #
  # @raise [NoMethodError]
  #
  # source://prism//lib/prism/node.rb#301
  sig { abstract.returns(String) }
  def inspect; end

  # Delegates to the leading_comments of the associated location object.
  #
  # source://prism//lib/prism/node.rb#123
  def leading_comments; end

  # A Location instance that represents the location of this node in the
  # source.
  #
  # source://prism//lib/prism/node.rb#33
  sig { returns(Prism::Location) }
  def location; end

  # Returns true if the node has the newline flag set.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#164
  sig { returns(T::Boolean) }
  def newline?; end

  # source://prism//lib/prism/parse_result/newlines.rb#70
  def newline_flag!(lines); end

  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result/newlines.rb#66
  def newline_flag?; end

  # A unique identifier for this node. This is used in a very specific
  # use case where you want to keep around a reference to a node without
  # having to keep around the syntax tree in memory. This unique identifier
  # will be consistent across multiple parses of the same source code.
  #
  # source://prism//lib/prism/node.rb#24
  sig { returns(Integer) }
  def node_id; end

  # Similar to inspect, but respects the current level of indentation given by
  # the pretty print object.
  #
  # source://prism//lib/prism/node.rb#175
  sig { params(q: T.untyped).void }
  def pretty_print(q); end

  # Save this node using a saved source so that it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#27
  def save(repository); end

  # Save the location using a saved source so that it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#40
  def save_location(repository); end

  # Returns all of the lines of the source code associated with this node.
  # An alias for source_lines, used to mimic the API from
  # RubyVM::AbstractSyntaxTree to make it easier to migrate.
  #
  # source://prism//lib/prism/node.rb#144
  sig { returns(T::Array[String]) }
  def script_lines; end

  # Slice the location of the node from the source.
  #
  # source://prism//lib/prism/node.rb#147
  sig { returns(String) }
  def slice; end

  # Slice the location of the node from the source, starting at the beginning
  # of the line that the location starts on, ending at the end of the line
  # that the location ends on.
  #
  # source://prism//lib/prism/node.rb#154
  sig { returns(String) }
  def slice_lines; end

  # Returns all of the lines of the source code associated with this node.
  #
  # source://prism//lib/prism/node.rb#138
  sig { returns(T::Array[String]) }
  def source_lines; end

  # Delegates to the start_character_column of the associated location object.
  #
  # source://prism//lib/prism/node.rb#101
  def start_character_column; end

  # Delegates to the start_character_offset of the associated location object.
  #
  # source://prism//lib/prism/node.rb#69
  def start_character_offset; end

  # Delegates to the start_column of the associated location object.
  #
  # source://prism//lib/prism/node.rb#91
  def start_column; end

  # Delegates to the start_line of the associated location object.
  #
  # source://prism//lib/prism/node.rb#45
  def start_line; end

  # The start offset of the node in the source. This method is effectively a
  # delegate method to the location object.
  #
  # source://prism//lib/prism/node.rb#56
  sig { returns(Integer) }
  def start_offset; end

  # Returns true if the node has the static literal flag set.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#169
  sig { returns(T::Boolean) }
  def static_literal?; end

  # Convert this node into a graphviz dot graph string.
  #
  # source://prism//lib/prism/node.rb#183
  sig { returns(String) }
  def to_dot; end

  # Delegates to the trailing_comments of the associated location object.
  #
  # source://prism//lib/prism/node.rb#128
  def trailing_comments; end

  # Returns a list of nodes that are descendants of this node that contain the
  # given line and column. This is useful for locating a node that is selected
  # based on the line and column of the source code.
  #
  # Important to note is that the column given to this method should be in
  # bytes, as opposed to characters or code units.
  #
  # source://prism//lib/prism/node.rb#194
  sig { params(line: Integer, column: Integer).returns(T::Array[Prism::Node]) }
  def tunnel(line, column); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # @raise [NoMethodError]
  #
  # source://prism//lib/prism/node.rb#317
  sig { abstract.returns(Symbol) }
  def type; end

  protected

  # An bitset of flags for this node. There are certain flags that are common
  # for all nodes, and then some nodes have specific flags.
  #
  # source://prism//lib/prism/node.rb#160
  sig { returns(Integer) }
  def flags; end

  private

  # A pointer to the source that this node was created from.
  #
  # source://prism//lib/prism/node.rb#17
  sig { returns(Prism::Source) }
  def source; end

  class << self
    # Returns a list of the fields that exist for this node class. Fields
    # describe the structure of the node. This kind of reflection is useful for
    # things like recursively visiting each node _and_ field in the tree.
    #
    # @raise [NoMethodError]
    #
    # source://prism//lib/prism/node.rb#253
    def fields; end

    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # @raise [NoMethodError]
    #
    # source://prism//lib/prism/node.rb#325
    def type; end
  end
end

# The flags that are common to all nodes.
#
# source://prism//lib/prism/node.rb#19957
module Prism::NodeFlags; end

# A flag to indicate that the node is a candidate to emit a :line event
# through tracepoint when compiled.
#
# source://prism//lib/prism/node.rb#19960
Prism::NodeFlags::NEWLINE = T.let(T.unsafe(nil), Integer)

# A flag to indicate that the value that the node represents is a value that
# can be determined at parse-time.
#
# source://prism//lib/prism/node.rb#19964
Prism::NodeFlags::STATIC_LITERAL = T.let(T.unsafe(nil), Integer)

# Represents an implicit set of parameters through the use of numbered parameters within a block or lambda.
#
#     -> { _1 + _2 }
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#14666
class Prism::NumberedParametersNode < ::Prism::Node
  # Initialize a new NumberedParametersNode node.
  #
  # @return [NumberedParametersNode] a new instance of NumberedParametersNode
  #
  # source://prism//lib/prism/node.rb#14668
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      maximum: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, maximum); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14735
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14677
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14682
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14698
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14693
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?maximum: Integer) -> NumberedParametersNode
  #
  # source://prism//lib/prism/node.rb#14703
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      maximum: Integer
    ).returns(Prism::NumberedParametersNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), maximum: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14708
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, maximum: Integer }
  #
  # source://prism//lib/prism/node.rb#14711
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#14687
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14719
  sig { override.returns(String) }
  def inspect; end

  # attr_reader maximum: Integer
  #
  # source://prism//lib/prism/node.rb#14716
  sig { returns(Integer) }
  def maximum; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14724
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14729
    def type; end
  end
end

# Represents reading a numbered reference to a capture in the previous match.
#
#     $1
#     ^^
#
# source://prism//lib/prism/node.rb#14745
class Prism::NumberedReferenceReadNode < ::Prism::Node
  # Initialize a new NumberedReferenceReadNode node.
  #
  # @return [NumberedReferenceReadNode] a new instance of NumberedReferenceReadNode
  #
  # source://prism//lib/prism/node.rb#14747
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      number: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, number); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14820
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14756
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14761
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14777
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14772
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?number: Integer) -> NumberedReferenceReadNode
  #
  # source://prism//lib/prism/node.rb#14782
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      number: Integer
    ).returns(Prism::NumberedReferenceReadNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), number: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14787
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, number: Integer }
  #
  # source://prism//lib/prism/node.rb#14790
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#14766
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14804
  sig { override.returns(String) }
  def inspect; end

  # The (1-indexed, from the left) number of the capture group. Numbered references that are too large result in this value being `0`.
  #
  #     $1          # number `1`
  #
  #     $5432       # number `5432`
  #
  #     $4294967296 # number `0`
  #
  # source://prism//lib/prism/node.rb#14801
  sig { returns(Integer) }
  def number; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14809
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14814
    def type; end
  end
end

# Represents an optional keyword parameter to a method, block, or lambda definition.
#
#     def a(b: 1)
#           ^^^^
#     end
#
# source://prism//lib/prism/node.rb#14831
class Prism::OptionalKeywordParameterNode < ::Prism::Node
  # Initialize a new OptionalKeywordParameterNode node.
  #
  # @return [OptionalKeywordParameterNode] a new instance of OptionalKeywordParameterNode
  #
  # source://prism//lib/prism/node.rb#14833
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14924
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14844
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14849
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14866
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14861
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?value: Prism::node) -> OptionalKeywordParameterNode
  #
  # source://prism//lib/prism/node.rb#14871
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::OptionalKeywordParameterNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14876
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#14879
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#14854
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14908
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#14889
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#14892
  sig { returns(Prism::Location) }
  def name_loc; end

  # def repeated_parameter?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14884
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#14900
  def save_name_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14913
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#14905
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14918
    def type; end
  end
end

# Represents an optional parameter to a method, block, or lambda definition.
#
#     def a(b = 1)
#           ^^^^^
#     end
#
# source://prism//lib/prism/node.rb#14938
class Prism::OptionalParameterNode < ::Prism::Node
  # Initialize a new OptionalParameterNode node.
  #
  # @return [OptionalParameterNode] a new instance of OptionalParameterNode
  #
  # source://prism//lib/prism/node.rb#14940
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#15050
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14952
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14957
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14974
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14969
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> OptionalParameterNode
  #
  # source://prism//lib/prism/node.rb#14979
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::OptionalParameterNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#14984
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#14987
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [value]
  #
  # source://prism//lib/prism/node.rb#14962
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#15034
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#14997
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#15000
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#15029
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#15013
  sig { returns(Prism::Location) }
  def operator_loc; end

  # def repeated_parameter?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14992
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  # Save the name_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#15008
  def save_name_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#15021
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#15039
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#15026
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#15044
    def type; end
  end
end

# Represents the use of the `||` operator or the `or` keyword.
#
#     left or right
#     ^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#15064
class Prism::OrNode < ::Prism::Node
  # Initialize a new OrNode node.
  #
  # @return [OrNode] a new instance of OrNode
  #
  # source://prism//lib/prism/node.rb#15066
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, left, right, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#15173
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15077
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#15082
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15100
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15095
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?left: Prism::node, ?right: Prism::node, ?operator_loc: Location) -> OrNode
  #
  # source://prism//lib/prism/node.rb#15105
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::OrNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#15110
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, left: Prism::node, right: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#15113
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [left]
  #
  # source://prism//lib/prism/node.rb#15087
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#15157
  sig { override.returns(String) }
  def inspect; end

  # Represents the left side of the expression. It can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     left or right
  #     ^^^^
  #
  #     1 || 2
  #     ^
  #
  # source://prism//lib/prism/node.rb#15124
  sig { returns(Prism::Node) }
  def left; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#15152
  sig { returns(String) }
  def operator; end

  # The location of the `or` keyword or the `||` operator.
  #
  #     left or right
  #          ^^
  #
  # source://prism//lib/prism/node.rb#15139
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Represents the right side of the expression.
  #
  #     left || right
  #             ^^^^^
  #
  #     1 or 2
  #          ^
  #
  # source://prism//lib/prism/node.rb#15133
  sig { returns(Prism::Node) }
  def right; end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#15147
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#15162
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#15167
    def type; end
  end
end

# A parser for the pack template language.
#
# source://prism//lib/prism/pack.rb#8
module Prism::Pack
  class << self
    # source://prism//lib/prism.rb#92
    def parse(_arg0, _arg1, _arg2); end
  end
end

# source://prism//lib/prism/pack.rb#58
Prism::Pack::AGNOSTIC_ENDIAN = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::BACK = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::BER = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::BIG_ENDIAN = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::COMMENT = T.let(T.unsafe(nil), Symbol)

# A directive in the pack template language.
#
# source://prism//lib/prism/pack.rb#62
class Prism::Pack::Directive
  # Initialize a new directive with the given values.
  #
  # @return [Directive] a new instance of Directive
  #
  # source://prism//lib/prism/pack.rb#91
  def initialize(version, variant, source, type, signed, endian, size, length_type, length); end

  # Provide a human-readable description of the directive.
  #
  # source://prism//lib/prism/pack.rb#133
  def describe; end

  # The type of endianness of the directive.
  #
  # source://prism//lib/prism/pack.rb#79
  def endian; end

  # The length of this directive (used for integers).
  #
  # source://prism//lib/prism/pack.rb#88
  def length; end

  # The length type of this directive (used for integers).
  #
  # source://prism//lib/prism/pack.rb#85
  def length_type; end

  # The type of signedness of the directive.
  #
  # source://prism//lib/prism/pack.rb#76
  def signed; end

  # The size of the directive.
  #
  # source://prism//lib/prism/pack.rb#82
  def size; end

  # A byteslice of the source string that this directive represents.
  #
  # source://prism//lib/prism/pack.rb#70
  def source; end

  # The type of the directive.
  #
  # source://prism//lib/prism/pack.rb#73
  def type; end

  # A symbol representing whether or not we are packing or unpacking.
  #
  # source://prism//lib/prism/pack.rb#67
  def variant; end

  # A symbol representing the version of Ruby.
  #
  # source://prism//lib/prism/pack.rb#64
  def version; end
end

# The descriptions of the various types of endianness.
#
# source://prism//lib/prism/pack.rb#104
Prism::Pack::Directive::ENDIAN_DESCRIPTIONS = T.let(T.unsafe(nil), Hash)

# The descriptions of the various types of signedness.
#
# source://prism//lib/prism/pack.rb#113
Prism::Pack::Directive::SIGNED_DESCRIPTIONS = T.let(T.unsafe(nil), Hash)

# The descriptions of the various types of sizes.
#
# source://prism//lib/prism/pack.rb#120
Prism::Pack::Directive::SIZE_DESCRIPTIONS = T.let(T.unsafe(nil), Hash)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::ENDIAN_NA = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::FLOAT = T.let(T.unsafe(nil), Symbol)

# The result of parsing a pack template.
#
# source://prism//lib/prism/pack.rb#200
class Prism::Pack::Format
  # Create a new Format with the given directives and encoding.
  #
  # @return [Format] a new instance of Format
  #
  # source://prism//lib/prism/pack.rb#208
  def initialize(directives, encoding); end

  # Provide a human-readable description of the format.
  #
  # source://prism//lib/prism/pack.rb#214
  def describe; end

  # A list of the directives in the template.
  #
  # source://prism//lib/prism/pack.rb#202
  def directives; end

  # The encoding of the template.
  #
  # source://prism//lib/prism/pack.rb#205
  def encoding; end
end

# source://prism//lib/prism/pack.rb#58
Prism::Pack::INTEGER = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::LENGTH_FIXED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::LENGTH_MAX = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::LENGTH_NA = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::LENGTH_RELATIVE = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::LITTLE_ENDIAN = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::MOVE = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::NATIVE_ENDIAN = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::NULL = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::SIGNED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::SIGNED_NA = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::SIZE_16 = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::SIZE_32 = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::SIZE_64 = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::SIZE_8 = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::SIZE_INT = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::SIZE_LONG = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::SIZE_LONG_LONG = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::SIZE_NA = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::SIZE_P = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::SIZE_SHORT = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::SPACE = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::STRING_BASE64 = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::STRING_FIXED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::STRING_HEX_HIGH = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::STRING_HEX_LOW = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::STRING_LSB = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::STRING_MIME = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::STRING_MSB = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::STRING_NULL_PADDED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::STRING_NULL_TERMINATED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::STRING_POINTER = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::STRING_SPACE_PADDED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::STRING_UU = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::UNSIGNED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#58
Prism::Pack::UTF8 = T.let(T.unsafe(nil), Symbol)

# Flags for parameter nodes.
#
# source://prism//lib/prism/node.rb#19864
module Prism::ParameterFlags; end

# a parameter name that has been repeated in the method signature
#
# source://prism//lib/prism/node.rb#19866
Prism::ParameterFlags::REPEATED_PARAMETER = T.let(T.unsafe(nil), Integer)

# Represents the list of parameters on a method, block, or lambda definition.
#
#     def a(b, c, d)
#           ^^^^^^^
#     end
#
# source://prism//lib/prism/node.rb#15186
class Prism::ParametersNode < ::Prism::Node
  # Initialize a new ParametersNode node.
  #
  # @return [ParametersNode] a new instance of ParametersNode
  #
  # source://prism//lib/prism/node.rb#15188
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      requireds: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode)],
      optionals: T::Array[Prism::OptionalParameterNode],
      rest: T.nilable(T.any(Prism::RestParameterNode, Prism::ImplicitRestNode)),
      posts: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode, Prism::KeywordRestParameterNode, Prism::NoKeywordsParameterNode, Prism::ForwardingParameterNode)],
      keywords: T::Array[T.any(Prism::RequiredKeywordParameterNode, Prism::OptionalKeywordParameterNode)],
      keyword_rest: T.nilable(T.any(Prism::KeywordRestParameterNode, Prism::ForwardingParameterNode, Prism::NoKeywordsParameterNode)),
      block: T.nilable(Prism::BlockParameterNode)
    ).void
  end
  def initialize(source, node_id, location, flags, requireds, optionals, rest, posts, keywords, keyword_rest, block); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#15294
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15203
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader block: BlockParameterNode?
  #
  # source://prism//lib/prism/node.rb#15275
  sig { returns(T.nilable(Prism::BlockParameterNode)) }
  def block; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#15208
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15239
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15226
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?requireds: Array[RequiredParameterNode | MultiTargetNode], ?optionals: Array[OptionalParameterNode], ?rest: RestParameterNode | ImplicitRestNode | nil, ?posts: Array[RequiredParameterNode | MultiTargetNode | KeywordRestParameterNode | NoKeywordsParameterNode | ForwardingParameterNode], ?keywords: Array[RequiredKeywordParameterNode | OptionalKeywordParameterNode], ?keyword_rest: KeywordRestParameterNode | ForwardingParameterNode | NoKeywordsParameterNode | nil, ?block: BlockParameterNode?) -> ParametersNode
  #
  # source://prism//lib/prism/node.rb#15244
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      requireds: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode)],
      optionals: T::Array[Prism::OptionalParameterNode],
      rest: T.nilable(T.any(Prism::RestParameterNode, Prism::ImplicitRestNode)),
      posts: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode, Prism::KeywordRestParameterNode, Prism::NoKeywordsParameterNode, Prism::ForwardingParameterNode)],
      keywords: T::Array[T.any(Prism::RequiredKeywordParameterNode, Prism::OptionalKeywordParameterNode)],
      keyword_rest: T.nilable(T.any(Prism::KeywordRestParameterNode, Prism::ForwardingParameterNode, Prism::NoKeywordsParameterNode)),
      block: T.nilable(Prism::BlockParameterNode)
    ).returns(Prism::ParametersNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), requireds: T.unsafe(nil), optionals: T.unsafe(nil), rest: T.unsafe(nil), posts: T.unsafe(nil), keywords: T.unsafe(nil), keyword_rest: T.unsafe(nil), block: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#15249
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, requireds: Array[RequiredParameterNode | MultiTargetNode], optionals: Array[OptionalParameterNode], rest: RestParameterNode | ImplicitRestNode | nil, posts: Array[RequiredParameterNode | MultiTargetNode | KeywordRestParameterNode | NoKeywordsParameterNode | ForwardingParameterNode], keywords: Array[RequiredKeywordParameterNode | OptionalKeywordParameterNode], keyword_rest: KeywordRestParameterNode | ForwardingParameterNode | NoKeywordsParameterNode | nil, block: BlockParameterNode? }
  #
  # source://prism//lib/prism/node.rb#15252
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [rest]
  #
  # source://prism//lib/prism/node.rb#15213
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#15278
  sig { override.returns(String) }
  def inspect; end

  # attr_reader keyword_rest: KeywordRestParameterNode | ForwardingParameterNode | NoKeywordsParameterNode | nil
  #
  # source://prism//lib/prism/node.rb#15272
  sig do
    returns(T.nilable(T.any(Prism::KeywordRestParameterNode, Prism::ForwardingParameterNode, Prism::NoKeywordsParameterNode)))
  end
  def keyword_rest; end

  # attr_reader keywords: Array[RequiredKeywordParameterNode | OptionalKeywordParameterNode]
  #
  # source://prism//lib/prism/node.rb#15269
  sig { returns(T::Array[T.any(Prism::RequiredKeywordParameterNode, Prism::OptionalKeywordParameterNode)]) }
  def keywords; end

  # attr_reader optionals: Array[OptionalParameterNode]
  #
  # source://prism//lib/prism/node.rb#15260
  sig { returns(T::Array[Prism::OptionalParameterNode]) }
  def optionals; end

  # attr_reader posts: Array[RequiredParameterNode | MultiTargetNode | KeywordRestParameterNode | NoKeywordsParameterNode | ForwardingParameterNode]
  #
  # source://prism//lib/prism/node.rb#15266
  sig do
    returns(T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode, Prism::KeywordRestParameterNode, Prism::NoKeywordsParameterNode, Prism::ForwardingParameterNode)])
  end
  def posts; end

  # attr_reader requireds: Array[RequiredParameterNode | MultiTargetNode]
  #
  # source://prism//lib/prism/node.rb#15257
  sig { returns(T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode)]) }
  def requireds; end

  # attr_reader rest: RestParameterNode | ImplicitRestNode | nil
  #
  # source://prism//lib/prism/node.rb#15263
  sig { returns(T.nilable(T.any(Prism::RestParameterNode, Prism::ImplicitRestNode))) }
  def rest; end

  # Mirrors the Method#parameters method.
  #
  # source://prism//lib/prism/node_ext.rb#272
  sig { returns(T::Array[T.any([Symbol, Symbol], [Symbol])]) }
  def signature; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#15283
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#15288
    def type; end
  end
end

# Represents a parenthesized expression
#
#     (10 + 34)
#     ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#15314
class Prism::ParenthesesNode < ::Prism::Node
  # Initialize a new ParenthesesNode node.
  #
  # @return [ParenthesesNode] a new instance of ParenthesesNode
  #
  # source://prism//lib/prism/node.rb#15316
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      body: T.nilable(Prism::Node),
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, body, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#15429
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15327
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader body: Prism::node?
  #
  # source://prism//lib/prism/node.rb#15374
  sig { returns(T.nilable(Prism::Node)) }
  def body; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#15332
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#15408
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#15390
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15351
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15344
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?body: Prism::node?, ?opening_loc: Location, ?closing_loc: Location) -> ParenthesesNode
  #
  # source://prism//lib/prism/node.rb#15356
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      body: T.nilable(Prism::Node),
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).returns(Prism::ParenthesesNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), body: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#15361
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, body: Prism::node?, opening_loc: Location, closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#15364
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [body]
  #
  # source://prism//lib/prism/node.rb#15337
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#15413
  sig { override.returns(String) }
  def inspect; end

  # def multiple_statements?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#15369
  sig { returns(T::Boolean) }
  def multiple_statements?; end

  # source://prism//lib/prism/parse_result/newlines.rb#86
  def newline_flag!(lines); end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#15403
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#15377
  sig { returns(Prism::Location) }
  def opening_loc; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#15398
  def save_closing_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#15385
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#15418
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#15423
    def type; end
  end
end

# Flags for parentheses nodes.
#
# source://prism//lib/prism/node.rb#19870
module Prism::ParenthesesNodeFlags; end

# parentheses that contain multiple potentially void statements
#
# source://prism//lib/prism/node.rb#19872
Prism::ParenthesesNodeFlags::MULTIPLE_STATEMENTS = T.let(T.unsafe(nil), Integer)

# This represents an error that was encountered during parsing.
#
# source://prism//lib/prism/parse_result.rb#606
class Prism::ParseError
  # Create a new error object with the given message and location.
  #
  # @return [ParseError] a new instance of ParseError
  #
  # source://prism//lib/prism/parse_result.rb#621
  sig { params(type: Symbol, message: String, location: Prism::Location, level: Symbol).void }
  def initialize(type, message, location, level); end

  # Implement the hash pattern matching interface for ParseError.
  #
  # source://prism//lib/prism/parse_result.rb#629
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # Returns a string representation of this error.
  #
  # source://prism//lib/prism/parse_result.rb#634
  sig { returns(String) }
  def inspect; end

  # The level of this error.
  #
  # source://prism//lib/prism/parse_result.rb#618
  sig { returns(Symbol) }
  def level; end

  # A Location object representing the location of this error in the source.
  #
  # source://prism//lib/prism/parse_result.rb#615
  sig { returns(Prism::Location) }
  def location; end

  # The message associated with this error.
  #
  # source://prism//lib/prism/parse_result.rb#612
  sig { returns(String) }
  def message; end

  # The type of error. This is an _internal_ symbol that is used for
  # communicating with translation layers. It is not meant to be public API.
  #
  # source://prism//lib/prism/parse_result.rb#609
  sig { returns(Symbol) }
  def type; end
end

# This is a result specific to the `parse_lex` and `parse_lex_file` methods.
#
# source://prism//lib/prism/parse_result.rb#795
class Prism::ParseLexResult < ::Prism::Result
  # Create a new parse lex result object with the given values.
  #
  # @return [ParseLexResult] a new instance of ParseLexResult
  #
  # source://prism//lib/prism/parse_result.rb#801
  sig do
    params(
      value: [Prism::ProgramNode, T::Array[T.untyped]],
      comments: T::Array[Prism::Comment],
      magic_comments: T::Array[Prism::MagicComment],
      data_loc: T.nilable(Prism::Location),
      errors: T::Array[Prism::ParseError],
      warnings: T::Array[Prism::ParseWarning],
      source: Prism::Source
    ).void
  end
  def initialize(value, comments, magic_comments, data_loc, errors, warnings, source); end

  # Implement the hash pattern matching interface for ParseLexResult.
  #
  # source://prism//lib/prism/parse_result.rb#807
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # A tuple of the syntax tree and the list of tokens that were parsed from
  # the source code.
  #
  # source://prism//lib/prism/parse_result.rb#798
  sig { returns([Prism::ProgramNode, T::Array[T.untyped]]) }
  def value; end
end

# This is a result specific to the `parse` and `parse_file` methods.
#
# source://prism//lib/prism/parse_result.rb#736
class Prism::ParseResult < ::Prism::Result
  # Create a new parse result object with the given values.
  #
  # @return [ParseResult] a new instance of ParseResult
  #
  # source://prism//lib/prism/parse_result.rb#749
  sig do
    params(
      value: Prism::ProgramNode,
      comments: T::Array[Prism::Comment],
      magic_comments: T::Array[Prism::MagicComment],
      data_loc: T.nilable(Prism::Location),
      errors: T::Array[Prism::ParseError],
      warnings: T::Array[Prism::ParseWarning],
      source: Prism::Source
    ).void
  end
  def initialize(value, comments, magic_comments, data_loc, errors, warnings, source); end

  # Attach the list of comments to their respective locations in the tree.
  #
  # source://prism//lib/prism/parse_result.rb#760
  def attach_comments!; end

  # Implement the hash pattern matching interface for ParseResult.
  #
  # source://prism//lib/prism/parse_result.rb#755
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # Returns a string representation of the syntax tree with the errors
  # displayed inline.
  #
  # source://prism//lib/prism/parse_result.rb#772
  def errors_format; end

  # Walk the tree and mark nodes that are on a new line, loosely emulating
  # the behavior of CRuby's `:line` tracepoint event.
  #
  # source://prism//lib/prism/parse_result.rb#766
  def mark_newlines!; end

  # The syntax tree that was parsed from the source code.
  #
  # source://prism//lib/prism/parse_result.rb#746
  sig { returns(Prism::ProgramNode) }
  def value; end
end

# When we've parsed the source, we have both the syntax tree and the list of
# comments that we found in the source. This class is responsible for
# walking the tree and finding the nearest location to attach each comment.
#
# It does this by first finding the nearest locations to each comment.
# Locations can either come from nodes directly or from location fields on
# nodes. For example, a `ClassNode` has an overall location encompassing the
# entire class, but it also has a location for the `class` keyword.
#
# Once the nearest locations are found, it determines which one to attach
# to. If it's a trailing comment (a comment on the same line as other source
# code), it will favor attaching to the nearest location that occurs before
# the comment. Otherwise it will favor attaching to the nearest location
# that is after the comment.
#
# source://prism//lib/prism/parse_result/comments.rb#20
class Prism::ParseResult::Comments
  # Create a new Comments object that will attach comments to the given
  # parse result.
  #
  # @return [Comments] a new instance of Comments
  #
  # source://prism//lib/prism/parse_result/comments.rb#87
  def initialize(parse_result); end

  # Attach the comments to their respective locations in the tree by
  # mutating the parse result.
  #
  # source://prism//lib/prism/parse_result/comments.rb#93
  def attach!; end

  # The parse result that we are attaching comments to.
  #
  # source://prism//lib/prism/parse_result/comments.rb#83
  def parse_result; end

  private

  # Responsible for finding the nearest targets to the given comment within
  # the context of the given encapsulating node.
  #
  # source://prism//lib/prism/parse_result/comments.rb#120
  def nearest_targets(node, comment); end
end

# A target for attaching comments that is based on a location field on a
# node. For example, the `end` token of a ClassNode.
#
# source://prism//lib/prism/parse_result/comments.rb#54
class Prism::ParseResult::Comments::LocationTarget
  # @return [LocationTarget] a new instance of LocationTarget
  #
  # source://prism//lib/prism/parse_result/comments.rb#57
  def initialize(location); end

  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result/comments.rb#69
  def encloses?(comment); end

  # source://prism//lib/prism/parse_result/comments.rb#65
  def end_offset; end

  # source://prism//lib/prism/parse_result/comments.rb#73
  def leading_comment(comment); end

  # source://prism//lib/prism/parse_result/comments.rb#55
  def location; end

  # source://prism//lib/prism/parse_result/comments.rb#61
  def start_offset; end

  # source://prism//lib/prism/parse_result/comments.rb#77
  def trailing_comment(comment); end
end

# A target for attaching comments that is based on a specific node's
# location.
#
# source://prism//lib/prism/parse_result/comments.rb#23
class Prism::ParseResult::Comments::NodeTarget
  # @return [NodeTarget] a new instance of NodeTarget
  #
  # source://prism//lib/prism/parse_result/comments.rb#26
  def initialize(node); end

  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result/comments.rb#38
  def encloses?(comment); end

  # source://prism//lib/prism/parse_result/comments.rb#34
  def end_offset; end

  # source://prism//lib/prism/parse_result/comments.rb#43
  def leading_comment(comment); end

  # source://prism//lib/prism/parse_result/comments.rb#24
  def node; end

  # source://prism//lib/prism/parse_result/comments.rb#30
  def start_offset; end

  # source://prism//lib/prism/parse_result/comments.rb#47
  def trailing_comment(comment); end
end

# An object to represent the set of errors on a parse result. This object
# can be used to format the errors in a human-readable way.
#
# source://prism//lib/prism/parse_result/errors.rb#10
class Prism::ParseResult::Errors
  # Initialize a new set of errors from the given parse result.
  #
  # @return [Errors] a new instance of Errors
  #
  # source://prism//lib/prism/parse_result/errors.rb#15
  def initialize(parse_result); end

  # Formats the errors in a human-readable way and return them as a string.
  #
  # source://prism//lib/prism/parse_result/errors.rb#20
  def format; end

  # The parse result that contains the errors.
  #
  # source://prism//lib/prism/parse_result/errors.rb#12
  def parse_result; end
end

# The :line tracepoint event gets fired whenever the Ruby VM encounters an
# expression on a new line. The types of expressions that can trigger this
# event are:
#
# * if statements
# * unless statements
# * nodes that are children of statements lists
#
# In order to keep track of the newlines, we have a list of offsets that
# come back from the parser. We assign these offsets to the first nodes that
# we find in the tree that are on those lines.
#
# Note that the logic in this file should be kept in sync with the Java
# MarkNewlinesVisitor, since that visitor is responsible for marking the
# newlines for JRuby/TruffleRuby.
#
# This file is autoloaded only when `mark_newlines!` is called, so the
# re-opening of the various nodes in this file will only be performed in
# that case. We do that to avoid storing the extra `@newline` instance
# variable on every node if we don't need it.
#
# source://prism//lib/prism/parse_result/newlines.rb#26
class Prism::ParseResult::Newlines < ::Prism::Visitor
  # Create a new Newlines visitor with the given newline offsets.
  #
  # @return [Newlines] a new instance of Newlines
  #
  # source://prism//lib/prism/parse_result/newlines.rb#28
  def initialize(lines); end

  # Permit block/lambda nodes to mark newlines within themselves.
  #
  # source://prism//lib/prism/parse_result/newlines.rb#34
  def visit_block_node(node); end

  # Mark if/unless nodes as newlines.
  #
  # source://prism//lib/prism/parse_result/newlines.rb#48
  def visit_if_node(node); end

  # Permit block/lambda nodes to mark newlines within themselves.
  #
  # source://prism//lib/prism/parse_result/newlines.rb#45
  def visit_lambda_node(node); end

  # Permit statements lists to mark newlines within themselves.
  #
  # source://prism//lib/prism/parse_result/newlines.rb#56
  def visit_statements_node(node); end

  # Mark if/unless nodes as newlines.
  #
  # source://prism//lib/prism/parse_result/newlines.rb#53
  def visit_unless_node(node); end
end

# This represents a warning that was encountered during parsing.
#
# source://prism//lib/prism/parse_result.rb#640
class Prism::ParseWarning
  # Create a new warning object with the given message and location.
  #
  # @return [ParseWarning] a new instance of ParseWarning
  #
  # source://prism//lib/prism/parse_result.rb#655
  sig { params(type: Symbol, message: String, location: Prism::Location, level: Symbol).void }
  def initialize(type, message, location, level); end

  # Implement the hash pattern matching interface for ParseWarning.
  #
  # source://prism//lib/prism/parse_result.rb#663
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # Returns a string representation of this warning.
  #
  # source://prism//lib/prism/parse_result.rb#668
  sig { returns(String) }
  def inspect; end

  # The level of this warning.
  #
  # source://prism//lib/prism/parse_result.rb#652
  sig { returns(Symbol) }
  def level; end

  # A Location object representing the location of this warning in the source.
  #
  # source://prism//lib/prism/parse_result.rb#649
  sig { returns(Prism::Location) }
  def location; end

  # The message associated with this warning.
  #
  # source://prism//lib/prism/parse_result.rb#646
  sig { returns(String) }
  def message; end

  # The type of warning. This is an _internal_ symbol that is used for
  # communicating with translation layers. It is not meant to be public API.
  #
  # source://prism//lib/prism/parse_result.rb#643
  sig { returns(Symbol) }
  def type; end
end

# A pattern is an object that wraps a Ruby pattern matching expression. The
# expression would normally be passed to an `in` clause within a `case`
# expression or a rightward assignment expression. For example, in the
# following snippet:
#
#     case node
#     in ConstantPathNode[ConstantReadNode[name: :Prism], ConstantReadNode[name: :Pattern]]
#     end
#
# the pattern is the <tt>ConstantPathNode[...]</tt> expression.
#
# The pattern gets compiled into an object that responds to #call by running
# the #compile method. This method itself will run back through Prism to
# parse the expression into a tree, then walk the tree to generate the
# necessary callable objects. For example, if you wanted to compile the
# expression above into a callable, you would:
#
#     callable = Prism::Pattern.new("ConstantPathNode[ConstantReadNode[name: :Prism], ConstantReadNode[name: :Pattern]]").compile
#     callable.call(node)
#
# The callable object returned by #compile is guaranteed to respond to #call
# with a single argument, which is the node to match against. It also is
# guaranteed to respond to #===, which means it itself can be used in a `case`
# expression, as in:
#
#     case node
#     when callable
#     end
#
# If the query given to the initializer cannot be compiled into a valid
# matcher (either because of a syntax error or because it is using syntax we
# do not yet support) then a Prism::Pattern::CompilationError will be
# raised.
#
# source://prism//lib/prism/pattern.rb#38
class Prism::Pattern
  # Create a new pattern with the given query. The query should be a string
  # containing a Ruby pattern matching expression.
  #
  # @return [Pattern] a new instance of Pattern
  #
  # source://prism//lib/prism/pattern.rb#64
  def initialize(query); end

  # Compile the query into a callable object that can be used to match against
  # nodes.
  #
  # @raise [CompilationError]
  #
  # source://prism//lib/prism/pattern.rb#71
  def compile; end

  # The query that this pattern was initialized with.
  #
  # source://prism//lib/prism/pattern.rb#60
  def query; end

  # Scan the given node and all of its children for nodes that match the
  # pattern. If a block is given, it will be called with each node that
  # matches the pattern. If no block is given, an enumerator will be returned
  # that will yield each node that matches the pattern.
  #
  # source://prism//lib/prism/pattern.rb#87
  def scan(root); end

  private

  # Shortcut for combining two procs into one that returns true if both return
  # true.
  #
  # source://prism//lib/prism/pattern.rb#103
  def combine_and(left, right); end

  # Shortcut for combining two procs into one that returns true if either
  # returns true.
  #
  # source://prism//lib/prism/pattern.rb#109
  def combine_or(left, right); end

  # in foo | bar
  #
  # source://prism//lib/prism/pattern.rb#144
  def compile_alternation_pattern_node(node); end

  # in [foo, bar, baz]
  #
  # source://prism//lib/prism/pattern.rb#119
  def compile_array_pattern_node(node); end

  # Compile a name associated with a constant.
  #
  # source://prism//lib/prism/pattern.rb#169
  def compile_constant_name(node, name); end

  # in Prism::ConstantReadNode
  #
  # source://prism//lib/prism/pattern.rb#149
  def compile_constant_path_node(node); end

  # in ConstantReadNode
  # in String
  #
  # source://prism//lib/prism/pattern.rb#164
  def compile_constant_read_node(node); end

  # Raise an error because the given node is not supported.
  #
  # @raise [CompilationError]
  #
  # source://prism//lib/prism/pattern.rb#114
  def compile_error(node); end

  # in InstanceVariableReadNode[name: Symbol]
  # in { name: Symbol }
  #
  # source://prism//lib/prism/pattern.rb#185
  def compile_hash_pattern_node(node); end

  # in nil
  #
  # source://prism//lib/prism/pattern.rb#215
  def compile_nil_node(node); end

  # Compile any kind of node. Dispatch out to the individual compilation
  # methods based on the type of node.
  #
  # source://prism//lib/prism/pattern.rb#244
  def compile_node(node); end

  # in /foo/
  #
  # source://prism//lib/prism/pattern.rb#220
  def compile_regular_expression_node(node); end

  # in ""
  # in "foo"
  #
  # source://prism//lib/prism/pattern.rb#228
  def compile_string_node(node); end

  # in :+
  # in :foo
  #
  # source://prism//lib/prism/pattern.rb#236
  def compile_symbol_node(node); end
end

# Raised when the query given to a pattern is either invalid Ruby syntax or
# is using syntax that we don't yet support.
#
# source://prism//lib/prism/pattern.rb#41
class Prism::Pattern::CompilationError < ::StandardError
  # Create a new CompilationError with the given representation of the node
  # that caused the error.
  #
  # @return [CompilationError] a new instance of CompilationError
  #
  # source://prism//lib/prism/pattern.rb#44
  def initialize(repr); end
end

# Represents the use of the `^` operator for pinning an expression in a pattern matching expression.
#
#     foo in ^(bar)
#            ^^^^^^
#
# source://prism//lib/prism/node.rb#15442
class Prism::PinnedExpressionNode < ::Prism::Node
  # Initialize a new PinnedExpressionNode node.
  #
  # @return [PinnedExpressionNode] a new instance of PinnedExpressionNode
  #
  # source://prism//lib/prism/node.rb#15444
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      expression: Prism::Node,
      operator_loc: Prism::Location,
      lparen_loc: Prism::Location,
      rparen_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, expression, operator_loc, lparen_loc, rparen_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#15581
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15456
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#15461
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15478
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15473
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?expression: Prism::node, ?operator_loc: Location, ?lparen_loc: Location, ?rparen_loc: Location) -> PinnedExpressionNode
  #
  # source://prism//lib/prism/node.rb#15483
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      expression: Prism::Node,
      operator_loc: Prism::Location,
      lparen_loc: Prism::Location,
      rparen_loc: Prism::Location
    ).returns(Prism::PinnedExpressionNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), expression: T.unsafe(nil), operator_loc: T.unsafe(nil), lparen_loc: T.unsafe(nil), rparen_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#15488
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, expression: Prism::node, operator_loc: Location, lparen_loc: Location, rparen_loc: Location }
  #
  # source://prism//lib/prism/node.rb#15491
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [expression]
  #
  # source://prism//lib/prism/node.rb#15466
  def each_child_node; end

  # The expression used in the pinned expression
  #
  #     foo in ^(bar)
  #              ^^^
  #
  # source://prism//lib/prism/node.rb#15499
  sig { returns(Prism::Node) }
  def expression; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#15565
  sig { override.returns(String) }
  def inspect; end

  # def lparen: () -> String
  #
  # source://prism//lib/prism/node.rb#15555
  sig { returns(String) }
  def lparen; end

  # The location of the opening parenthesis.
  #
  #     foo in ^(bar)
  #             ^
  #
  # source://prism//lib/prism/node.rb#15521
  sig { returns(Prism::Location) }
  def lparen_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#15550
  sig { returns(String) }
  def operator; end

  # The location of the `^` operator
  #
  #     foo in ^(bar)
  #            ^
  #
  # source://prism//lib/prism/node.rb#15505
  sig { returns(Prism::Location) }
  def operator_loc; end

  # def rparen: () -> String
  #
  # source://prism//lib/prism/node.rb#15560
  sig { returns(String) }
  def rparen; end

  # The location of the closing parenthesis.
  #
  #     foo in ^(bar)
  #                 ^
  #
  # source://prism//lib/prism/node.rb#15537
  sig { returns(Prism::Location) }
  def rparen_loc; end

  # Save the lparen_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#15529
  def save_lparen_loc(repository); end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#15513
  def save_operator_loc(repository); end

  # Save the rparen_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#15545
  def save_rparen_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#15570
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#15575
    def type; end
  end
end

# Represents the use of the `^` operator for pinning a variable in a pattern matching expression.
#
#     foo in ^bar
#            ^^^^
#
# source://prism//lib/prism/node.rb#15594
class Prism::PinnedVariableNode < ::Prism::Node
  # Initialize a new PinnedVariableNode node.
  #
  # @return [PinnedVariableNode] a new instance of PinnedVariableNode
  #
  # source://prism//lib/prism/node.rb#15596
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      variable: T.any(Prism::LocalVariableReadNode, Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::ItLocalVariableReadNode, Prism::MissingNode),
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, variable, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#15689
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15606
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#15611
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15628
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15623
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?variable: LocalVariableReadNode | InstanceVariableReadNode | ClassVariableReadNode | GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode | ItLocalVariableReadNode | MissingNode, ?operator_loc: Location) -> PinnedVariableNode
  #
  # source://prism//lib/prism/node.rb#15633
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      variable: T.any(Prism::LocalVariableReadNode, Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::ItLocalVariableReadNode, Prism::MissingNode),
      operator_loc: Prism::Location
    ).returns(Prism::PinnedVariableNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), variable: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#15638
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, variable: LocalVariableReadNode | InstanceVariableReadNode | ClassVariableReadNode | GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode | ItLocalVariableReadNode | MissingNode, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#15641
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [variable]
  #
  # source://prism//lib/prism/node.rb#15616
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#15673
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#15668
  sig { returns(String) }
  def operator; end

  # The location of the `^` operator
  #
  #     foo in ^bar
  #            ^
  #
  # source://prism//lib/prism/node.rb#15655
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#15663
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#15678
  sig { override.returns(Symbol) }
  def type; end

  # The variable used in the pinned expression
  #
  #     foo in ^bar
  #             ^^^
  #
  # source://prism//lib/prism/node.rb#15649
  sig do
    returns(T.any(Prism::LocalVariableReadNode, Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::ItLocalVariableReadNode, Prism::MissingNode))
  end
  def variable; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#15683
    def type; end
  end
end

# Represents the use of the `END` keyword.
#
#     END { foo }
#     ^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#15700
class Prism::PostExecutionNode < ::Prism::Node
  # Initialize a new PostExecutionNode node.
  #
  # @return [PostExecutionNode] a new instance of PostExecutionNode
  #
  # source://prism//lib/prism/node.rb#15702
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      statements: T.nilable(Prism::StatementsNode),
      keyword_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, statements, keyword_loc, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#15829
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15714
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#15719
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#15808
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#15785
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15738
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15731
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?statements: StatementsNode?, ?keyword_loc: Location, ?opening_loc: Location, ?closing_loc: Location) -> PostExecutionNode
  #
  # source://prism//lib/prism/node.rb#15743
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      statements: T.nilable(Prism::StatementsNode),
      keyword_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).returns(Prism::PostExecutionNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), statements: T.unsafe(nil), keyword_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#15748
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, statements: StatementsNode?, keyword_loc: Location, opening_loc: Location, closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#15751
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [statements]
  #
  # source://prism//lib/prism/node.rb#15724
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#15813
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#15798
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#15759
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#15803
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#15772
  sig { returns(Prism::Location) }
  def opening_loc; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#15793
  def save_closing_loc(repository); end

  # Save the keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#15767
  def save_keyword_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#15780
  def save_opening_loc(repository); end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#15756
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#15818
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#15823
    def type; end
  end
end

# Represents the use of the `BEGIN` keyword.
#
#     BEGIN { foo }
#     ^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#15842
class Prism::PreExecutionNode < ::Prism::Node
  # Initialize a new PreExecutionNode node.
  #
  # @return [PreExecutionNode] a new instance of PreExecutionNode
  #
  # source://prism//lib/prism/node.rb#15844
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      statements: T.nilable(Prism::StatementsNode),
      keyword_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, statements, keyword_loc, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#15971
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15856
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#15861
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#15950
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#15927
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15880
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15873
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?statements: StatementsNode?, ?keyword_loc: Location, ?opening_loc: Location, ?closing_loc: Location) -> PreExecutionNode
  #
  # source://prism//lib/prism/node.rb#15885
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      statements: T.nilable(Prism::StatementsNode),
      keyword_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).returns(Prism::PreExecutionNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), statements: T.unsafe(nil), keyword_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#15890
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, statements: StatementsNode?, keyword_loc: Location, opening_loc: Location, closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#15893
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [statements]
  #
  # source://prism//lib/prism/node.rb#15866
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#15955
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#15940
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#15901
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#15945
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#15914
  sig { returns(Prism::Location) }
  def opening_loc; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#15935
  def save_closing_loc(repository); end

  # Save the keyword_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#15909
  def save_keyword_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#15922
  def save_opening_loc(repository); end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#15898
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#15960
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#15965
    def type; end
  end
end

# The top level node of any parse tree.
#
# source://prism//lib/prism/node.rb#15981
class Prism::ProgramNode < ::Prism::Node
  # Initialize a new ProgramNode node.
  #
  # @return [ProgramNode] a new instance of ProgramNode
  #
  # source://prism//lib/prism/node.rb#15983
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      statements: Prism::StatementsNode
    ).void
  end
  def initialize(source, node_id, location, flags, locals, statements); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#16055
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15993
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#15998
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#16015
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#16010
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?locals: Array[Symbol], ?statements: StatementsNode) -> ProgramNode
  #
  # source://prism//lib/prism/node.rb#16020
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      statements: Prism::StatementsNode
    ).returns(Prism::ProgramNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), statements: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#16025
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, locals: Array[Symbol], statements: StatementsNode }
  #
  # source://prism//lib/prism/node.rb#16028
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [statements]
  #
  # source://prism//lib/prism/node.rb#16003
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#16039
  sig { override.returns(String) }
  def inspect; end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#16033
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # attr_reader statements: StatementsNode
  #
  # source://prism//lib/prism/node.rb#16036
  sig { returns(Prism::StatementsNode) }
  def statements; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#16044
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#16049
    def type; end
  end
end

# Flags for range and flip-flop nodes.
#
# source://prism//lib/prism/node.rb#19876
module Prism::RangeFlags; end

# ... operator
#
# source://prism//lib/prism/node.rb#19878
Prism::RangeFlags::EXCLUDE_END = T.let(T.unsafe(nil), Integer)

# Represents the use of the `..` or `...` operators.
#
#     1..2
#     ^^^^
#
#     c if a =~ /left/ ... b =~ /right/
#          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#16070
class Prism::RangeNode < ::Prism::Node
  # Initialize a new RangeNode node.
  #
  # @return [RangeNode] a new instance of RangeNode
  #
  # source://prism//lib/prism/node.rb#16072
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: T.nilable(Prism::Node),
      right: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, left, right, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#16185
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#16083
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#16088
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#16109
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#16101
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?left: Prism::node?, ?right: Prism::node?, ?operator_loc: Location) -> RangeNode
  #
  # source://prism//lib/prism/node.rb#16114
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: T.nilable(Prism::Node),
      right: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).returns(Prism::RangeNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#16119
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, left: Prism::node?, right: Prism::node?, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#16122
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # @yield [left]
  #
  # source://prism//lib/prism/node.rb#16093
  def each_child_node; end

  # def exclude_end?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16127
  sig { returns(T::Boolean) }
  def exclude_end?; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#16169
  sig { override.returns(String) }
  def inspect; end

  # The left-hand side of the range, if present. It can be either `nil` or any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     1...
  #     ^
  #
  #     hello...goodbye
  #     ^^^^^
  #
  # source://prism//lib/prism/node.rb#16138
  sig { returns(T.nilable(Prism::Node)) }
  def left; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#16164
  sig { returns(String) }
  def operator; end

  # The location of the `..` or `...` operator.
  #
  # source://prism//lib/prism/node.rb#16151
  sig { returns(Prism::Location) }
  def operator_loc; end

  # The right-hand side of the range, if present. It can be either `nil` or any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     ..5
  #       ^
  #
  #     1...foo
  #         ^^^
  # If neither right-hand or left-hand side was included, this will be a MissingNode.
  #
  # source://prism//lib/prism/node.rb#16148
  sig { returns(T.nilable(Prism::Node)) }
  def right; end

  # Save the operator_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#16159
  def save_operator_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#16174
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#16179
    def type; end
  end
end

# Represents a rational number literal.
#
#     1.0r
#     ^^^^
#
# source://prism//lib/prism/node.rb#16198
class Prism::RationalNode < ::Prism::Node
  # Initialize a new RationalNode node.
  #
  # @return [RationalNode] a new instance of RationalNode
  #
  # source://prism//lib/prism/node.rb#16200
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      numerator: Integer,
      denominator: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, numerator, denominator); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#16295
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#16210
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def binary?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16249
  sig { returns(T::Boolean) }
  def binary?; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#16215
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#16231
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#16226
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?numerator: Integer, ?denominator: Integer) -> RationalNode
  #
  # source://prism//lib/prism/node.rb#16236
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      numerator: Integer,
      denominator: Integer
    ).returns(Prism::RationalNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), numerator: T.unsafe(nil), denominator: T.unsafe(nil)); end

  # def decimal?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16254
  sig { returns(T::Boolean) }
  def decimal?; end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#16241
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, numerator: Integer, denominator: Integer }
  #
  # source://prism//lib/prism/node.rb#16244
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # The denominator of the rational number.
  #
  #     1.5r # denominator 2
  #
  # source://prism//lib/prism/node.rb#16276
  sig { returns(Integer) }
  def denominator; end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#16220
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def hexadecimal?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16264
  sig { returns(T::Boolean) }
  def hexadecimal?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#16279
  sig { override.returns(String) }
  def inspect; end

  # The numerator of the rational number.
  #
  #     1.5r # numerator 3
  #
  # source://prism//lib/prism/node.rb#16271
  sig { returns(Integer) }
  def numerator; end

  # Returns the value of the node as an IntegerNode or a FloatNode. This
  # method is deprecated in favor of #value or #numerator/#denominator.
  #
  # source://prism//lib/prism/node_ext.rb#123
  def numeric; end

  # def octal?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16259
  sig { returns(T::Boolean) }
  def octal?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#16284
  sig { override.returns(Symbol) }
  def type; end

  # Returns the value of the node as a Ruby Rational.
  #
  # source://prism//lib/prism/node_ext.rb#117
  sig { returns(Rational) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#16289
    def type; end
  end
end

# Represents the use of the `redo` keyword.
#
#     redo
#     ^^^^
#
# source://prism//lib/prism/node.rb#16307
class Prism::RedoNode < ::Prism::Node
  # Initialize a new RedoNode node.
  #
  # @return [RedoNode] a new instance of RedoNode
  #
  # source://prism//lib/prism/node.rb#16309
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#16372
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#16317
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#16322
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#16338
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#16333
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> RedoNode
  #
  # source://prism//lib/prism/node.rb#16343
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::RedoNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#16348
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#16351
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#16327
  def each_child_node; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#16356
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#16361
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#16366
    def type; end
  end
end

# The Reflection module provides the ability to reflect on the structure of
# the syntax tree itself, as opposed to looking at a single syntax tree. This
# is useful in metaprogramming contexts.
#
# source://prism//lib/prism/reflection.rb#16
module Prism::Reflection
  class << self
    # Returns the fields for the given node.
    #
    # source://prism//lib/prism/reflection.rb#107
    sig { params(node: T.class_of(Prism::Node)).returns(T::Array[Prism::Reflection::Field]) }
    def fields_for(node); end
  end
end

# A constant field represents a constant value on a node. Effectively, it
# represents an identifier found within the source. It resolves to a symbol
# in Ruby.
#
# source://prism//lib/prism/reflection.rb#48
class Prism::Reflection::ConstantField < ::Prism::Reflection::Field; end

# A constant list field represents a list of constant values on a node. It
# resolves to an array of symbols in Ruby.
#
# source://prism//lib/prism/reflection.rb#58
class Prism::Reflection::ConstantListField < ::Prism::Reflection::Field; end

# A field represents a single piece of data on a node. It is the base class
# for all other field types.
#
# source://prism//lib/prism/reflection.rb#19
class Prism::Reflection::Field
  # Initializes the field with the given name.
  #
  # @return [Field] a new instance of Field
  #
  # source://prism//lib/prism/reflection.rb#24
  sig { params(name: Symbol).void }
  def initialize(name); end

  # The name of the field.
  #
  # source://prism//lib/prism/reflection.rb#21
  sig { returns(Symbol) }
  def name; end
end

# A flags field represents a bitset of flags on a node. It resolves to an
# integer in Ruby. Note that the flags cannot be accessed directly on the
# node because the integer is kept private. Instead, the various flags in
# the bitset should be accessed through their query methods.
#
# source://prism//lib/prism/reflection.rb#95
class Prism::Reflection::FlagsField < ::Prism::Reflection::Field
  # Initializes the flags field with the given name and flags.
  #
  # @return [FlagsField] a new instance of FlagsField
  #
  # source://prism//lib/prism/reflection.rb#100
  sig { params(name: Symbol, flags: T::Array[Symbol]).void }
  def initialize(name, flags); end

  # The names of the flags in the bitset.
  #
  # source://prism//lib/prism/reflection.rb#97
  sig { returns(T::Array[Symbol]) }
  def flags; end
end

# A float field represents a double-precision floating point value. It is
# used exclusively to represent the value of a floating point literal. It
# resolves to a Float in Ruby.
#
# source://prism//lib/prism/reflection.rb#88
class Prism::Reflection::FloatField < ::Prism::Reflection::Field; end

# An integer field represents an integer value. It is used to represent the
# value of an integer literal, the depth of local variables, and the number
# of a numbered reference. It resolves to an Integer in Ruby.
#
# source://prism//lib/prism/reflection.rb#82
class Prism::Reflection::IntegerField < ::Prism::Reflection::Field; end

# A location field represents the location of some part of the node in the
# source code. For example, the location of a keyword or an operator. It
# resolves to a Prism::Location in Ruby.
#
# source://prism//lib/prism/reflection.rb#70
class Prism::Reflection::LocationField < ::Prism::Reflection::Field; end

# A node field represents a single child node in the syntax tree. It
# resolves to a Prism::Node in Ruby.
#
# source://prism//lib/prism/reflection.rb#31
class Prism::Reflection::NodeField < ::Prism::Reflection::Field; end

# A node list field represents a list of child nodes in the syntax tree. It
# resolves to an array of Prism::Node instances in Ruby.
#
# source://prism//lib/prism/reflection.rb#42
class Prism::Reflection::NodeListField < ::Prism::Reflection::Field; end

# An optional constant field represents a constant value on a node that may
# or may not be present. It resolves to either a symbol or nil in Ruby.
#
# source://prism//lib/prism/reflection.rb#53
class Prism::Reflection::OptionalConstantField < ::Prism::Reflection::Field; end

# An optional location field represents the location of some part of the
# node in the source code that may or may not be present. It resolves to
# either a Prism::Location or nil in Ruby.
#
# source://prism//lib/prism/reflection.rb#76
class Prism::Reflection::OptionalLocationField < ::Prism::Reflection::Field; end

# An optional node field represents a single child node in the syntax tree
# that may or may not be present. It resolves to either a Prism::Node or nil
# in Ruby.
#
# source://prism//lib/prism/reflection.rb#37
class Prism::Reflection::OptionalNodeField < ::Prism::Reflection::Field; end

# A string field represents a string value on a node. It almost always
# represents the unescaped value of a string-like literal. It resolves to a
# string in Ruby.
#
# source://prism//lib/prism/reflection.rb#64
class Prism::Reflection::StringField < ::Prism::Reflection::Field; end

# Flags for regular expression and match last line nodes.
#
# source://prism//lib/prism/node.rb#19882
module Prism::RegularExpressionFlags; end

# n - forces the ASCII-8BIT encoding
#
# source://prism//lib/prism/node.rb#19899
Prism::RegularExpressionFlags::ASCII_8BIT = T.let(T.unsafe(nil), Integer)

# e - forces the EUC-JP encoding
#
# source://prism//lib/prism/node.rb#19896
Prism::RegularExpressionFlags::EUC_JP = T.let(T.unsafe(nil), Integer)

# x - ignores whitespace and allows comments in regular expressions
#
# source://prism//lib/prism/node.rb#19887
Prism::RegularExpressionFlags::EXTENDED = T.let(T.unsafe(nil), Integer)

# internal bytes forced the encoding to binary
#
# source://prism//lib/prism/node.rb#19911
Prism::RegularExpressionFlags::FORCED_BINARY_ENCODING = T.let(T.unsafe(nil), Integer)

# internal bytes forced the encoding to US-ASCII
#
# source://prism//lib/prism/node.rb#19914
Prism::RegularExpressionFlags::FORCED_US_ASCII_ENCODING = T.let(T.unsafe(nil), Integer)

# internal bytes forced the encoding to UTF-8
#
# source://prism//lib/prism/node.rb#19908
Prism::RegularExpressionFlags::FORCED_UTF8_ENCODING = T.let(T.unsafe(nil), Integer)

# i - ignores the case of characters when matching
#
# source://prism//lib/prism/node.rb#19884
Prism::RegularExpressionFlags::IGNORE_CASE = T.let(T.unsafe(nil), Integer)

# m - allows $ to match the end of lines within strings
#
# source://prism//lib/prism/node.rb#19890
Prism::RegularExpressionFlags::MULTI_LINE = T.let(T.unsafe(nil), Integer)

# o - only interpolates values into the regular expression once
#
# source://prism//lib/prism/node.rb#19893
Prism::RegularExpressionFlags::ONCE = T.let(T.unsafe(nil), Integer)

# u - forces the UTF-8 encoding
#
# source://prism//lib/prism/node.rb#19905
Prism::RegularExpressionFlags::UTF_8 = T.let(T.unsafe(nil), Integer)

# s - forces the Windows-31J encoding
#
# source://prism//lib/prism/node.rb#19902
Prism::RegularExpressionFlags::WINDOWS_31J = T.let(T.unsafe(nil), Integer)

# Represents a regular expression literal with no interpolation.
#
#     /foo/i
#     ^^^^^^
#
# source://prism//lib/prism/node.rb#16381
class Prism::RegularExpressionNode < ::Prism::Node
  include ::Prism::RegularExpressionOptions

  # Initialize a new RegularExpressionNode node.
  #
  # @return [RegularExpressionNode] a new instance of RegularExpressionNode
  #
  # source://prism//lib/prism/node.rb#16383
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      content_loc: Prism::Location,
      closing_loc: Prism::Location,
      unescaped: String
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, content_loc, closing_loc, unescaped); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#16562
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#16395
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def ascii_8bit?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16459
  sig { returns(T::Boolean) }
  def ascii_8bit?; end

  # def child_nodes: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#16400
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#16541
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#16515
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#16416
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#16411
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def content: () -> String
  #
  # source://prism//lib/prism/node.rb#16536
  sig { returns(String) }
  def content; end

  # attr_reader content_loc: Location
  #
  # source://prism//lib/prism/node.rb#16502
  sig { returns(Prism::Location) }
  def content_loc; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location, ?content_loc: Location, ?closing_loc: Location, ?unescaped: String) -> RegularExpressionNode
  #
  # source://prism//lib/prism/node.rb#16421
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      content_loc: Prism::Location,
      closing_loc: Prism::Location,
      unescaped: String
    ).returns(Prism::RegularExpressionNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), content_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), unescaped: T.unsafe(nil)); end

  # def child_nodes: () -> Array[Node?]
  # def deconstruct: () -> Array[Node?]
  #
  # source://prism//lib/prism/node.rb#16426
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location, content_loc: Location, closing_loc: Location, unescaped: String }
  #
  # source://prism//lib/prism/node.rb#16429
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def each_child_node: () { (Prism::node) -> void } -> void | () -> Enumerator[Prism::node]
  #
  # source://prism//lib/prism/node.rb#16405
  def each_child_node; end

  # def euc_jp?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16454
  sig { returns(T::Boolean) }
  def euc_jp?; end

  # def extended?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16439
  sig { returns(T::Boolean) }
  def extended?; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def forced_binary_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16479
  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  # def forced_us_ascii_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16484
  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  # def forced_utf8_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16474
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  # def ignore_case?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16434
  sig { returns(T::Boolean) }
  def ignore_case?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#16546
  sig { override.returns(String) }
  def inspect; end

  # def multi_line?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16444
  sig { returns(T::Boolean) }
  def multi_line?; end

  # def once?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16449
  sig { returns(T::Boolean) }
  def once?; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#16531
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#16489
  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(Integer) }
  def options; end

  # Save the closing_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#16523
  def save_closing_loc(repository); end

  # Save the content_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#16510
  def save_content_loc(repository); end

  # Save the opening_loc location using the given saved source so that
  # it can be retrieved later.
  #
  # source://prism//lib/prism/node.rb#16497
  def save_opening_loc(repository); end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#16551
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader unescaped: String
  #
  # source://prism//lib/prism/node.rb#16528
  sig { returns(String) }
  def unescaped; end

  # def utf_8?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16469
  sig { returns(T::Boolean) }
  def utf_8?; end

  # def windows_31j?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#16464
  sig { returns(T::Boolean) }
  def windows_31j?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#16556
    def type; end
  end
end

# source://prism//lib/prism/node_ext.rb#23
module Prism::RegularExpressionOptions
  # Returns a numeric value that represents the flags that were used to create
  # the regular expression.
  #
  # source://prism//lib/prism/node_ext.rb#26
  def options; end
end

# Prism parses deterministically for the same input. This provides a nice
# property that is exposed through the #node_id API on nodes. Effectively this
# means that for the same input, these values will remain consistent every
# time the source is parsed. This means we can reparse the source same with a
# #node_id value and find the exact same node again.
#
# The Relocation module provides an API around this property. It allows you to
# "save" nodes and locations using a minimal amount of memory (just the
# node_id and a field identifier) and then reify them later.
#
# source://prism//lib/prism/relocation.rb#14
module Prism::Relocation
  class << self
    # Create a new repository for the given filepath.
    #
    # source://prism//lib/prism/relocation.rb#496
    def filepath(value); end

    # Create a new repository for the given string.
    #
    # source://prism//lib/prism/relocation.rb#501
    def string(value); end
  end
end

# A field representing the start and end character columns.
#
# source://prism//lib/prism/relocation.rb#270
class Prism::Relocation::CharacterColumnsField
  # Fetches the start and end character column of a value.
  #
  # source://prism//lib/prism/relocation.rb#272
  def fields(value); end
end

# A field representing the start and end character offsets.
#
# source://prism//lib/prism/relocation.rb#218
class Prism::Relocation::CharacterOffsetsField
  # Fetches the start and end character offset of a value.
  #
  # source://prism//lib/prism/relocation.rb#220
  def fields(value); end
end

# A field representing the start and end code unit columns for a specific
# encoding.
#
# source://prism//lib/prism/relocation.rb#282
class Prism::Relocation::CodeUnitColumnsField
  # Initialize a new field with the associated repository and encoding.
  #
  # @return [CodeUnitColumnsField] a new instance of CodeUnitColumnsField
  #
  # source://prism//lib/prism/relocation.rb#291
  def initialize(repository, encoding); end

  # The associated encoding for the code units.
  #
  # source://prism//lib/prism/relocation.rb#288
  def encoding; end

  # Fetches the start and end code units column of a value for a particular
  # encoding.
  #
  # source://prism//lib/prism/relocation.rb#299
  def fields(value); end

  # The repository object that is used for lazily creating a code units
  # cache.
  #
  # source://prism//lib/prism/relocation.rb#285
  def repository; end

  private

  # Lazily create a code units cache for the associated encoding.
  #
  # source://prism//lib/prism/relocation.rb#309
  def cache; end
end

# A field representing the start and end code unit offsets.
#
# source://prism//lib/prism/relocation.rb#229
class Prism::Relocation::CodeUnitOffsetsField
  # Initialize a new field with the associated repository and encoding.
  #
  # @return [CodeUnitOffsetsField] a new instance of CodeUnitOffsetsField
  #
  # source://prism//lib/prism/relocation.rb#238
  def initialize(repository, encoding); end

  # The associated encoding for the code units.
  #
  # source://prism//lib/prism/relocation.rb#235
  def encoding; end

  # Fetches the start and end code units offset of a value for a particular
  # encoding.
  #
  # source://prism//lib/prism/relocation.rb#246
  def fields(value); end

  # A pointer to the repository object that is used for lazily creating a
  # code units cache.
  #
  # source://prism//lib/prism/relocation.rb#232
  def repository; end

  private

  # Lazily create a code units cache for the associated encoding.
  #
  # source://prism//lib/prism/relocation.rb#256
  def cache; end
end

# A field representing the start and end byte columns.
#
# source://prism//lib/prism/relocation.rb#262
class Prism::Relocation::ColumnsField
  # Fetches the start and end byte column of a value.
  #
  # source://prism//lib/prism/relocation.rb#264
  def fields(value); end
end

# An abstract field used as the parent class of the two comments fields.
#
# source://prism//lib/prism/relocation.rb#315
class Prism::Relocation::CommentsField
  private

  # Create comment objects from the given values.
  #
  # source://prism//lib/prism/relocation.rb#330
  def comments(values); end
end

# An object that represents a slice of a comment.
#
# source://prism//lib/prism/relocation.rb#317
class Prism::Relocation::CommentsField::Comment
  # Initialize a new comment with the given slice.
  #
  # @return [Comment] a new instance of Comment
  #
  # source://prism//lib/prism/relocation.rb#322
  def initialize(slice); end

  # The slice of the comment.
  #
  # source://prism//lib/prism/relocation.rb#319
  def slice; end
end

# An entry in a repository that will lazily reify its values when they are
# first accessed.
#
# source://prism//lib/prism/relocation.rb#17
class Prism::Relocation::Entry
  # Initialize a new entry with the given repository.
  #
  # @return [Entry] a new instance of Entry
  #
  # source://prism//lib/prism/relocation.rb#25
  def initialize(repository); end

  # Fetch the leading and trailing comments of the value.
  #
  # source://prism//lib/prism/relocation.rb#120
  def comments; end

  # Fetch the end character column of the value.
  #
  # source://prism//lib/prism/relocation.rb#93
  def end_character_column; end

  # Fetch the end character offset of the value.
  #
  # source://prism//lib/prism/relocation.rb#61
  def end_character_offset; end

  # Fetch the end code units column of the value, for the encoding that was
  # configured on the repository.
  #
  # source://prism//lib/prism/relocation.rb#105
  def end_code_units_column; end

  # Fetch the end code units offset of the value, for the encoding that was
  # configured on the repository.
  #
  # source://prism//lib/prism/relocation.rb#73
  def end_code_units_offset; end

  # Fetch the end byte column of the value.
  #
  # source://prism//lib/prism/relocation.rb#83
  def end_column; end

  # Fetch the end line of the value.
  #
  # source://prism//lib/prism/relocation.rb#41
  def end_line; end

  # Fetch the end byte offset of the value.
  #
  # source://prism//lib/prism/relocation.rb#51
  def end_offset; end

  # Fetch the filepath of the value.
  #
  # source://prism//lib/prism/relocation.rb#31
  def filepath; end

  # Fetch the leading comments of the value.
  #
  # source://prism//lib/prism/relocation.rb#110
  def leading_comments; end

  # Reify the values on this entry with the given values. This is an
  # internal-only API that is called from the repository when it is time to
  # reify the values.
  #
  # source://prism//lib/prism/relocation.rb#127
  def reify!(values); end

  # Fetch the start character column of the value.
  #
  # source://prism//lib/prism/relocation.rb#88
  def start_character_column; end

  # Fetch the start character offset of the value.
  #
  # source://prism//lib/prism/relocation.rb#56
  def start_character_offset; end

  # Fetch the start code units column of the value, for the encoding that
  # was configured on the repository.
  #
  # source://prism//lib/prism/relocation.rb#99
  def start_code_units_column; end

  # Fetch the start code units offset of the value, for the encoding that
  # was configured on the repository.
  #
  # source://prism//lib/prism/relocation.rb#67
  def start_code_units_offset; end

  # Fetch the start byte column of the value.
  #
  # source://prism//lib/prism/relocation.rb#78
  def start_column; end

  # Fetch the start line of the value.
  #
  # source://prism//lib/prism/relocation.rb#36
  def start_line; end

  # Fetch the start byte offset of the value.
  #
  # source://prism//lib/prism/relocation.rb#46
  def start_offset; end

  # Fetch the trailing comments of the value.
  #
  # source://prism//lib/prism/relocation.rb#115
  def trailing_comments; end

  private

  # Fetch a value from the entry, raising an error if it is missing.
  #
  # source://prism//lib/prism/relocation.rb#135
  def fetch_value(name); end

  # Return the values from the repository, reifying them if necessary.
  #
  # source://prism//lib/prism/relocation.rb#143
  def values; end
end

# Raised if a value that could potentially be on an entry is missing
# because it was either not configured on the repository or it has not yet
# been fetched.
#
# source://prism//lib/prism/relocation.rb#21
class Prism::Relocation::Entry::MissingValueError < ::StandardError; end

# A field that represents the file path.
#
# source://prism//lib/prism/relocation.rb#186
class Prism::Relocation::FilepathField
  # Initialize a new field with the given file path.
  #
  # @return [FilepathField] a new instance of FilepathField
  #
  # source://prism//lib/prism/relocation.rb#191
  def initialize(value); end

  # Fetch the file path.
  #
  # source://prism//lib/prism/relocation.rb#196
  def fields(_value); end

  # The file path that this field represents.
  #
  # source://prism//lib/prism/relocation.rb#188
  def value; end
end

# A field representing the leading comments.
#
# source://prism//lib/prism/relocation.rb#336
class Prism::Relocation::LeadingCommentsField < ::Prism::Relocation::CommentsField
  # Fetches the leading comments of a value.
  #
  # source://prism//lib/prism/relocation.rb#338
  def fields(value); end
end

# A field representing the start and end lines.
#
# source://prism//lib/prism/relocation.rb#202
class Prism::Relocation::LinesField
  # Fetches the start and end line of a value.
  #
  # source://prism//lib/prism/relocation.rb#204
  def fields(value); end
end

# A field representing the start and end byte offsets.
#
# source://prism//lib/prism/relocation.rb#210
class Prism::Relocation::OffsetsField
  # Fetches the start and end byte offset of a value.
  #
  # source://prism//lib/prism/relocation.rb#212
  def fields(value); end
end

# A repository is a configured collection of fields and a set of entries
# that knows how to reparse a source and reify the values.
#
# source://prism//lib/prism/relocation.rb#353
class Prism::Relocation::Repository
  # Initialize a new repository with the given source.
  #
  # @return [Repository] a new instance of Repository
  #
  # source://prism//lib/prism/relocation.rb#370
  def initialize(source); end

  # Configure the character columns field for this repository and return
  # self.
  #
  # source://prism//lib/prism/relocation.rb#416
  def character_columns; end

  # Configure the character offsets field for this repository and return
  # self.
  #
  # source://prism//lib/prism/relocation.rb#399
  def character_offsets; end

  # Configure the code unit columns field for this repository for a specific
  # encoding and return self.
  #
  # source://prism//lib/prism/relocation.rb#422
  def code_unit_columns(encoding); end

  # Configure the code unit offsets field for this repository for a specific
  # encoding and return self.
  #
  # source://prism//lib/prism/relocation.rb#405
  def code_unit_offsets(encoding); end

  # Create a code units cache for the given encoding from the source.
  #
  # source://prism//lib/prism/relocation.rb#377
  def code_units_cache(encoding); end

  # Configure the columns field for this repository and return self.
  #
  # source://prism//lib/prism/relocation.rb#410
  def columns; end

  # Configure both the leading and trailing comment fields for this
  # repository and return self.
  #
  # source://prism//lib/prism/relocation.rb#440
  def comments; end

  # This method is called from nodes and locations when they want to enter
  # themselves into the repository. It it internal-only and meant to be
  # called from the #save* APIs.
  #
  # source://prism//lib/prism/relocation.rb#447
  def enter(node_id, field_name); end

  # The entries that have been saved on this repository.
  #
  # source://prism//lib/prism/relocation.rb#367
  def entries; end

  # The fields that have been configured on this repository.
  #
  # source://prism//lib/prism/relocation.rb#364
  def fields; end

  # Configure the filepath field for this repository and return self.
  #
  # @raise [ConfigurationError]
  #
  # source://prism//lib/prism/relocation.rb#382
  def filepath; end

  # Configure the leading comments field for this repository and return
  # self.
  #
  # source://prism//lib/prism/relocation.rb#428
  def leading_comments; end

  # Configure the lines field for this repository and return self.
  #
  # source://prism//lib/prism/relocation.rb#388
  def lines; end

  # Configure the offsets field for this repository and return self.
  #
  # source://prism//lib/prism/relocation.rb#393
  def offsets; end

  # This method is called from the entries in the repository when they need
  # to reify their values. It is internal-only and meant to be called from
  # the various value APIs.
  #
  # source://prism//lib/prism/relocation.rb#456
  def reify!; end

  # The source associated with this repository. This will be either a
  # SourceFilepath (the most common use case) or a SourceString.
  #
  # source://prism//lib/prism/relocation.rb#361
  def source; end

  # Configure the trailing comments field for this repository and return
  # self.
  #
  # source://prism//lib/prism/relocation.rb#434
  def trailing_comments; end

  private

  # Append the given field to the repository and return the repository so
  # that these calls can be chained.
  #
  # @raise [ConfigurationError]
  #
  # source://prism//lib/prism/relocation.rb#488
  def field(name, value); end
end

# Raised when multiple fields of the same type are configured on the same
# repository.
#
# source://prism//lib/prism/relocation.rb#356
class Prism::Relocation::Repository::ConfigurationError < ::StandardError; end

# Represents the source of a repository that will be reparsed.
#
# source://prism//lib/prism/relocation.rb#149
class Prism::Relocation::Source
  # Initialize the source with the given value.
  #
  # @return [Source] a new instance of Source
  #
  # source://prism//lib/prism/relocation.rb#154
  def initialize(value); end

  # Create a code units cache for the given encoding.
  #
  # source://prism//lib/prism/relocation.rb#164
  def code_units_cache(encoding); end

  # Reparse the value and return the parse result.
  #
  # @raise [NotImplementedError]
  #
  # source://prism//lib/prism/relocation.rb#159
  def result; end

  # The value that will need to be reparsed.
  #
  # source://prism//lib/prism/relocation.rb#151
  def value; end
end

# A source that is represented by a file path.
#
# source://prism//lib/prism/relocation.rb#170
class Prism::Relocation::SourceFilepath < ::Prism::Relocation::Source
  # Reparse the file and return the parse result.
  #
  # source://prism//lib/prism/relocation.rb#172
  def result; end
end

# A source that is represented by a string.
#
# source://prism//lib/prism/relocation.rb#178
class Prism::Relocation::SourceString < ::Prism::Relocation::Source
  # Reparse the string and return the parse result.
  #
  # source://prism//lib/prism/relocation.rb#180
  def result; end
end

# A field representing the trailing comments.
#
# source://prism//lib/prism/relocation.rb#344
class Prism::Relocation::TrailingCommentsField < ::Prism::Relocation::CommentsField
  # Fetches the trailing comments of a value.
  #
  # source://prism//lib