# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rubocop-minitest` gem.
# Please instead update this file by running `bin/tapioca gem rubocop-minitest`.


# source://rubocop-minitest//lib/rubocop/minitest.rb#3
module RuboCop; end

# source://rubocop-minitest//lib/rubocop/cop/mixin/argument_range_helper.rb#4
module RuboCop::Cop; end

# Methods that calculate and return `Parser::Source::Ranges`.
#
# @api private
#
# source://rubocop-minitest//lib/rubocop/cop/mixin/argument_range_helper.rb#7
module RuboCop::Cop::ArgumentRangeHelper
  include ::RuboCop::Cop::RangeHelp

  private

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/argument_range_helper.rb#19
  def all_arguments_range(node); end

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/argument_range_helper.rb#12
  def first_and_second_arguments_range(node); end
end

# Common functionality for `AssertInDelta` and `RefuteInDelta` cops.
#
# @api private
#
# source://rubocop-minitest//lib/rubocop/cop/mixin/in_delta_mixin.rb#7
module RuboCop::Cop::InDeltaMixin
  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/in_delta_mixin.rb#10
  def on_send(node); end

  private

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/in_delta_mixin.rb#35
  def assertion_method; end

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/in_delta_mixin.rb#27
  def build_good_method(expected, actual, message); end
end

# @api private
#
# source://rubocop-minitest//lib/rubocop/cop/mixin/in_delta_mixin.rb#8
RuboCop::Cop::InDeltaMixin::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/mixin/instance_of_assertion_handleable.rb#5
module RuboCop::Cop::Minitest; end

# Enforces the test to use `assert_empty` instead of using `assert(object.empty?)`.
#
# @example
#   # bad
#   assert(object.empty?)
#   assert(object.empty?, 'message')
#
#   # good
#   assert_empty(object)
#   assert_empty(object, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_empty.rb#17
class RuboCop::Cop::Minitest::AssertEmpty < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  extend ::RuboCop::Cop::MinitestCopRule
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_empty.rb#20
  def autocorrect(corrector, node, arguments); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_empty.rb#20
  def on_send(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_empty.rb#20
  def correct_receiver(receiver); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_empty.rb#20
  def new_arguments(arguments); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_empty.rb#20
  def offense_message(arguments); end
end

# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#43
RuboCop::Cop::Minitest::AssertEmpty::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#44
RuboCop::Cop::Minitest::AssertEmpty::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the test to use `assert_empty`
# instead of using `assert_equal([], object)` or `assert_equal({}, object)`.
#
# @example
#   # bad
#   assert_equal([], object)
#   assert_equal({}, object)
#
#   # good
#   assert_empty(object)
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_empty_literal.rb#17
class RuboCop::Cop::Minitest::AssertEmptyLiteral < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_empty_literal.rb#24
  def assert_equal_with_empty_literal(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_empty_literal.rb#28
  def on_send(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_empty_literal.rb#21
RuboCop::Cop::Minitest::AssertEmptyLiteral::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_empty_literal.rb#22
RuboCop::Cop::Minitest::AssertEmptyLiteral::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of `assert_equal(expected, actual)`
# over `assert(expected == actual)`.
#
# @example
#   # bad
#   assert("rubocop-minitest" == actual)
#   assert_operator("rubocop-minitest", :==, actual)
#
#   # good
#   assert_equal("rubocop-minitest", actual)
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_equal.rb#17
class RuboCop::Cop::Minitest::AssertEqual < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_equal.rb#24
  def assert_equal(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_equal.rb#32
  def on_send(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_equal.rb#21
RuboCop::Cop::Minitest::AssertEqual::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_equal.rb#22
RuboCop::Cop::Minitest::AssertEqual::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the test to use `assert_in_delta`
# instead of using `assert_equal` to compare floats.
#
# @example
#   # bad
#   assert_equal(0.2, actual)
#   assert_equal(0.2, actual, 'message')
#
#   # good
#   assert_in_delta(0.2, actual)
#   assert_in_delta(0.2, actual, 0.001, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_in_delta.rb#18
class RuboCop::Cop::Minitest::AssertInDelta < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::InDeltaMixin
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_in_delta.rb#24
  def equal_floats_call(param0 = T.unsafe(nil)); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_in_delta.rb#22
RuboCop::Cop::Minitest::AssertInDelta::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the test to use `assert_includes`
# instead of using `assert(collection.include?(object))`.
#
# @example
#   # bad
#   assert(collection.include?(object))
#   assert(collection.include?(object), 'message')
#
#   # good
#   assert_includes(collection, object)
#   assert_includes(collection, object, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_includes.rb#18
class RuboCop::Cop::Minitest::AssertIncludes < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  extend ::RuboCop::Cop::MinitestCopRule
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_includes.rb#21
  def autocorrect(corrector, node, arguments); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_includes.rb#21
  def on_send(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_includes.rb#21
  def correct_receiver(receiver); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_includes.rb#21
  def new_arguments(arguments); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_includes.rb#21
  def offense_message(arguments); end
end

# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#43
RuboCop::Cop::Minitest::AssertIncludes::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#44
RuboCop::Cop::Minitest::AssertIncludes::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the test to use `assert_instance_of(Class, object)`
# over `assert(object.instance_of?(Class))`.
#
# @example
#   # bad
#   assert(object.instance_of?(Class))
#   assert(object.instance_of?(Class), 'message')
#
#   # bad
#   assert_equal(Class, object.class)
#   assert_equal(Class, object.class, 'message')
#
#   # good
#   assert_instance_of(Class, object)
#   assert_instance_of(Class, object, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_instance_of.rb#22
class RuboCop::Cop::Minitest::AssertInstanceOf < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  include ::RuboCop::Cop::Minitest::InstanceOfAssertionHandleable
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_instance_of.rb#28
  def instance_of_assertion?(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_instance_of.rb#35
  def on_send(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_instance_of.rb#26
RuboCop::Cop::Minitest::AssertInstanceOf::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the test to use `assert_kind_of(Class, object)`
# over `assert(object.kind_of?(Class))`.
#
# @example
#   # bad
#   assert(object.kind_of?(Class))
#   assert(object.kind_of?(Class), 'message')
#
#   # bad
#   # `is_a?` is an alias for `kind_of?`
#   assert(object.is_a?(Class))
#   assert(object.is_a?(Class), 'message')
#
#   # good
#   assert_kind_of(Class, object)
#   assert_kind_of(Class, object, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_kind_of.rb#23
class RuboCop::Cop::Minitest::AssertKindOf < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  extend ::RuboCop::Cop::MinitestCopRule
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_kind_of.rb#26
  def autocorrect(corrector, node, arguments); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_kind_of.rb#26
  def on_send(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_kind_of.rb#26
  def correct_receiver(receiver); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_kind_of.rb#26
  def new_arguments(arguments); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_kind_of.rb#26
  def offense_message(arguments); end
end

# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#43
RuboCop::Cop::Minitest::AssertKindOf::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#44
RuboCop::Cop::Minitest::AssertKindOf::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the test to use `assert_match`
# instead of using `assert(matcher.match(string))`.
#
# @example
#   # bad
#   assert(matcher.match(string))
#   assert(matcher.match?(string))
#   assert(matcher =~ string)
#   assert_operator(matcher, :=~, string)
#   assert(matcher.match(string), 'message')
#
#   # good
#   assert_match(regex, string)
#   assert_match(matcher, string, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_match.rb#21
class RuboCop::Cop::Minitest::AssertMatch < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_match.rb#28
  def assert_match(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_match.rb#36
  def on_send(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_match.rb#59
  def order_expected_and_actual(expected, actual); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_match.rb#25
RuboCop::Cop::Minitest::AssertMatch::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_match.rb#26
RuboCop::Cop::Minitest::AssertMatch::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the test to use `assert_nil` instead of using
# `assert_equal(nil, something)`, `assert(something.nil?)`, or `assert_predicate(something, :nil?)`.
#
# @example
#   # bad
#   assert_equal(nil, actual)
#   assert_equal(nil, actual, 'message')
#   assert(object.nil?)
#   assert(object.nil?, 'message')
#   assert_predicate(object, :nil?)
#   assert_predicate(object, :nil?, 'message')
#
#   # good
#   assert_nil(actual)
#   assert_nil(actual, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_nil.rb#22
class RuboCop::Cop::Minitest::AssertNil < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  include ::RuboCop::Cop::Minitest::NilAssertionHandleable
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_nil.rb#30
  def nil_assertion(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_nil.rb#38
  def on_send(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_nil.rb#46
  def assertion_type; end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_nil.rb#27
RuboCop::Cop::Minitest::AssertNil::ASSERTION_TYPE = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_nil.rb#28
RuboCop::Cop::Minitest::AssertNil::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of `assert_operator(expected, :<, actual)` over `assert(expected < actual)`.
#
# @example
#
#   # bad
#   assert(expected < actual)
#
#   # good
#   assert_operator(expected, :<, actual)
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_operator.rb#16
class RuboCop::Cop::Minitest::AssertOperator < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_operator.rb#23
  def on_send(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_operator.rb#41
  def build_new_arguments(node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_operator.rb#52
  def range_of_arguments(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_operator.rb#21
RuboCop::Cop::Minitest::AssertOperator::ALLOWED_OPERATORS = T.let(T.unsafe(nil), Array)

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_operator.rb#19
RuboCop::Cop::Minitest::AssertOperator::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_operator.rb#20
RuboCop::Cop::Minitest::AssertOperator::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for opportunities to use `assert_output`.
#
# @example
#   # bad
#   $stdout = StringIO.new
#   puts object.method
#   $stdout.rewind
#   assert_match expected, $stdout.read
#
#   # good
#   assert_output(expected) { puts object.method }
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_output.rb#18
class RuboCop::Cop::Minitest::AssertOutput < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  include ::RuboCop::Cop::MinitestExplorationHelpers

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_output.rb#24
  def on_gvasgn(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_output.rb#38
  def find_test_case(node); end

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_output.rb#42
  def references_gvar?(assertion, gvar_name); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_output.rb#21
RuboCop::Cop::Minitest::AssertOutput::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_output.rb#22
RuboCop::Cop::Minitest::AssertOutput::OUTPUT_GLOBAL_VARIABLES = T.let(T.unsafe(nil), Array)

# Enforces the test to use `assert_path_exists` instead of using `assert(File.exist?(path))`.
#
# @example
#   # bad
#   assert(File.exist?(path))
#   assert(File.exist?(path), 'message')
#
#   # good
#   assert_path_exists(path)
#   assert_path_exists(path, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_path_exists.rb#17
class RuboCop::Cop::Minitest::AssertPathExists < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_path_exists.rb#23
  def assert_file_exists(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_path_exists.rb#30
  def on_send(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_path_exists.rb#45
  def build_good_method(node, path, message); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_path_exists.rb#20
RuboCop::Cop::Minitest::AssertPathExists::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_path_exists.rb#21
RuboCop::Cop::Minitest::AssertPathExists::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the test to use `assert_predicate`
# instead of using `assert(obj.a_predicate_method?)`.
#
# @example
#   # bad
#   assert(obj.one?)
#   assert(obj.one?, 'message')
#
#   # good
#   assert_predicate(obj, :one?)
#   assert_predicate(obj, :one?, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_predicate.rb#18
class RuboCop::Cop::Minitest::AssertPredicate < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  include ::RuboCop::Cop::Minitest::PredicateAssertionHandleable
  extend ::RuboCop::Cop::AutoCorrector

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_predicate.rb#28
  def assertion_type; end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_predicate.rb#23
RuboCop::Cop::Minitest::AssertPredicate::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_predicate.rb#24
RuboCop::Cop::Minitest::AssertPredicate::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the block body of `assert_raises { ... }` to be reduced to only the raising code.
#
# @example
#   # bad
#   assert_raises(MyError) do
#   foo
#   bar
#   end
#
#   # good
#   assert_raises(MyError) do
#   foo
#   end
#
#   # good
#   assert_raises(MyError) do
#   foo do
#   bar
#   baz
#   end
#   end
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_raises_compound_body.rb#28
class RuboCop::Cop::Minitest::AssertRaisesCompoundBody < ::RuboCop::Cop::Base
  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_raises_compound_body.rb#31
  def on_block(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_raises_compound_body.rb#39
  def multi_statement_begin?(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_raises_compound_body.rb#29
RuboCop::Cop::Minitest::AssertRaisesCompoundBody::MSG = T.let(T.unsafe(nil), String)

# Checks for `assert_raises` with arguments of regular expression literals.
# Arguments should be exception classes.
# Optionally the last argument can be a custom message string to help explain failures.
# Either way, it's not the argument that `exception.message` is compared to.
# The raised exception is returned and can be used
# to match against a regular expression.
#
# @example
#
#   # bad
#   assert_raises FooError, /some message/ do
#   obj.occur_error
#   end
#
#   # good
#   exception = assert_raises FooError do
#   obj.occur_error
#   end
#   assert_match(/some message/, exception.message)
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_raises_with_regexp_argument.rb#26
class RuboCop::Cop::Minitest::AssertRaisesWithRegexpArgument < ::RuboCop::Cop::Base
  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_raises_with_regexp_argument.rb#30
  def on_send(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_raises_with_regexp_argument.rb#27
RuboCop::Cop::Minitest::AssertRaisesWithRegexpArgument::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_raises_with_regexp_argument.rb#28
RuboCop::Cop::Minitest::AssertRaisesWithRegexpArgument::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of `assert_respond_to(object, :do_something)`
# over `assert(object.respond_to?(:do_something))`.
#
# @example
#   # bad
#   assert(object.respond_to?(:do_something))
#   assert(object.respond_to?(:do_something), 'message')
#   assert(respond_to?(:do_something))
#
#   # good
#   assert_respond_to(object, :do_something)
#   assert_respond_to(object, :do_something, 'message')
#   assert_respond_to(self, :do_something)
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_respond_to.rb#20
class RuboCop::Cop::Minitest::AssertRespondTo < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  extend ::RuboCop::Cop::MinitestCopRule
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_respond_to.rb#23
  def autocorrect(corrector, node, arguments); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_respond_to.rb#23
  def on_send(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_respond_to.rb#23
  def correct_receiver(receiver); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_respond_to.rb#23
  def new_arguments(arguments); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_respond_to.rb#23
  def offense_message(arguments); end
end

# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#43
RuboCop::Cop::Minitest::AssertRespondTo::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#44
RuboCop::Cop::Minitest::AssertRespondTo::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of `assert_same(expected, actual)`
# over `assert(expected.equal?(actual))`.
#
# NOTE: Use `assert_same` only when there is a need to compare by identity.
#       Otherwise, use `assert_equal`.
#
# @example
#   # bad
#   assert(expected.equal?(actual))
#   assert_equal(expected.object_id, actual.object_id)
#
#   # good
#   assert_same(expected, actual)
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_same.rb#20
class RuboCop::Cop::Minitest::AssertSame < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_same.rb#32
  def assert_equal_with_object_id?(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_same.rb#26
  def assert_with_equal?(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_same.rb#40
  def on_send(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_same.rb#58
  def message(expected_node, actual_node, message_node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_same.rb#63
  def remove_method_call(send_node, corrector); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_same.rb#23
RuboCop::Cop::Minitest::AssertSame::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_same.rb#24
RuboCop::Cop::Minitest::AssertSame::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the test to use `assert_silent { ... }`
# instead of using `assert_output('', '') { ... }`.
#
# @example
#   # bad
#   assert_output('', '') { puts object.do_something }
#
#   # good
#   assert_silent { puts object.do_something }
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_silent.rb#16
class RuboCop::Cop::Minitest::AssertSilent < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_silent.rb#21
  def assert_silent_candidate?(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_silent.rb#29
  def on_block(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_silent.rb#41
  def empty_string?(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_silent.rb#19
RuboCop::Cop::Minitest::AssertSilent::MSG = T.let(T.unsafe(nil), String)

# Enforces the test to use `assert(actual)` instead of using `assert_equal(true, actual)`.
#
# @example
#   # bad
#   assert_equal(true, actual)
#   assert_equal(true, actual, 'message')
#
#   # good
#   assert(actual)
#   assert(actual, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_truthy.rb#27
class RuboCop::Cop::Minitest::AssertTruthy < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_truthy.rb#34
  def assert_equal_with_truthy(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_truthy.rb#38
  def on_send(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_truthy.rb#31
RuboCop::Cop::Minitest::AssertTruthy::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_truthy.rb#32
RuboCop::Cop::Minitest::AssertTruthy::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Tries to detect when a user accidentally used
# `assert` when they meant to use `assert_equal`.
#
# NOTE: The second argument to the `assert` method named `message` and `msg` is allowed.
#       Because their names are inferred as message arguments.
#
# @example
#   # bad
#   assert(3, my_list.length)
#   assert(expected, actual)
#
#   # good
#   assert_equal(3, my_list.length)
#   assert_equal(expected, actual)
#   assert(foo, 'message')
#   assert(foo, message)
#   assert(foo, msg)
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_with_expected_argument.rb#28
class RuboCop::Cop::Minitest::AssertWithExpectedArgument < ::RuboCop::Cop::Base
  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_with_expected_argument.rb#33
  def assert_with_two_arguments?(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assert_with_expected_argument.rb#37
  def on_send(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_with_expected_argument.rb#31
RuboCop::Cop::Minitest::AssertWithExpectedArgument::MESSAGE_VARIABLES = T.let(T.unsafe(nil), Array)

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_with_expected_argument.rb#29
RuboCop::Cop::Minitest::AssertWithExpectedArgument::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/assert_with_expected_argument.rb#30
RuboCop::Cop::Minitest::AssertWithExpectedArgument::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for usage of assertions in lifecycle hooks.
#
# @example
#   # bad
#   class FooTest < Minitest::Test
#   def setup
#   assert_equal(foo, bar)
#   end
#   end
#
#   # good
#   class FooTest < Minitest::Test
#   def test_something
#   assert_equal(foo, bar)
#   end
#   end
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/assertion_in_lifecycle_hook.rb#23
class RuboCop::Cop::Minitest::AssertionInLifecycleHook < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  include ::RuboCop::Cop::MinitestExplorationHelpers

  # source://rubocop-minitest//lib/rubocop/cop/minitest/assertion_in_lifecycle_hook.rb#28
  def on_class(class_node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/assertion_in_lifecycle_hook.rb#26
RuboCop::Cop::Minitest::AssertionInLifecycleHook::MSG = T.let(T.unsafe(nil), String)

# If a Minitest class inherits from another class,
# it will also inherit its methods causing Minitest to run the parent's tests methods twice.
#
# This cop detects when there are two tests classes, one inherits from the other, and both have tests methods.
# This cop will add an offense to the Child class in such a case.
#
# @example
#   # bad
#   class ParentTest < Minitest::Test
#   def test_parent # it will run this test twice.
#   end
#   end
#
#   class ChildTest < ParentTest
#   def test_child
#   end
#   end
#
#   # good
#   class ParentTest < Minitest::Test
#   def test_parent
#   end
#   end
#
#   class ChildTest < Minitest::Test
#   def test_child
#   end
#   end
#
#   # good
#   class ParentTest < Minitest::Test
#   end
#
#   class ChildTest
#   def test_child
#   end
#
#   def test_parent
#   end
#   end
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/duplicate_test_run.rb#48
class RuboCop::Cop::Minitest::DuplicateTestRun < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  include ::RuboCop::Cop::MinitestExplorationHelpers

  # source://rubocop-minitest//lib/rubocop/cop/minitest/duplicate_test_run.rb#53
  def on_class(class_node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/duplicate_test_run.rb#63
  def parent_class_has_test_methods?(class_node); end

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/duplicate_test_run.rb#77
  def test_methods?(class_node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/duplicate_test_run.rb#51
RuboCop::Cop::Minitest::DuplicateTestRun::MSG = T.let(T.unsafe(nil), String)

# Enforces empty line before assertion methods because it separates assertion phase.
#
# @example
#
#   # bad
#   do_something
#   assert_equal(expected, actual)
#
#   # good
#   do_something
#
#   assert_equal(expected, actual)
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/empty_line_before_assertion_methods.rb#19
class RuboCop::Cop::Minitest::EmptyLineBeforeAssertionMethods < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  include ::RuboCop::Cop::MinitestExplorationHelpers
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/empty_line_before_assertion_methods.rb#27
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/empty_line_before_assertion_methods.rb#52
  def accept_previous_line?(previous_line_node, node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/empty_line_before_assertion_methods.rb#43
  def assertion_method(node); end

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/empty_line_before_assertion_methods.rb#73
  def heredoc?(last_argument); end

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/empty_line_before_assertion_methods.rb#77
  def no_empty_line?(previous_line_node, node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/empty_line_before_assertion_methods.rb#87
  def register_offense(node, previous_line_node); end

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/empty_line_before_assertion_methods.rb#63
  def use_assertion_method_at_last_of_block?(node); end

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/empty_line_before_assertion_methods.rb#59
  def use_heredoc_argument?(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/empty_line_before_assertion_methods.rb#24
RuboCop::Cop::Minitest::EmptyLineBeforeAssertionMethods::MSG = T.let(T.unsafe(nil), String)

# Enforces tests are not focused.
#
# @example
#   # bad
#   focus test 'foo' do
#   end
#
#   # bad
#   focus
#   test 'foo' do
#   end
#
#   # good
#   test 'foo' do
#   end
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/focus.rb#22
class RuboCop::Cop::Minitest::Focus < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/focus.rb#29
  def focused?(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/focus.rb#33
  def on_send(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/focus.rb#26
RuboCop::Cop::Minitest::Focus::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/focus.rb#27
RuboCop::Cop::Minitest::Focus::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks for deprecated global expectations
# and autocorrects them to use expect format.
#
# @example EnforcedStyle: _
#   # bad
#   musts.must_equal expected_musts
#   wonts.wont_match expected_wonts
#   musts.must_raise TypeError
#
#   expect(musts).must_equal expected_musts
#   expect(wonts).wont_match expected_wonts
#   expect { musts }.must_raise TypeError
#
#   value(musts).must_equal expected_musts
#   value(wonts).wont_match expected_wonts
#   value { musts }.must_raise TypeError
#
#   # good
#   _(musts).must_equal expected_musts
#   _(wonts).wont_match expected_wonts
#   _ { musts }.must_raise TypeError
# @example EnforcedStyle: any (default)
#   # bad
#   musts.must_equal expected_musts
#   wonts.wont_match expected_wonts
#   musts.must_raise TypeError
#
#   # good
#   _(musts).must_equal expected_musts
#   _(wonts).wont_match expected_wonts
#   _ { musts }.must_raise TypeError
#
#   expect(musts).must_equal expected_musts
#   expect(wonts).wont_match expected_wonts
#   expect { musts }.must_raise TypeError
#
#   value(musts).must_equal expected_musts
#   value(wonts).wont_match expected_wonts
#   value { musts }.must_raise TypeError
# @example EnforcedStyle: expect
#   # bad
#   musts.must_equal expected_musts
#   wonts.wont_match expected_wonts
#   musts.must_raise TypeError
#
#   _(musts).must_equal expected_musts
#   _(wonts).wont_match expected_wonts
#   _ { musts }.must_raise TypeError
#
#   value(musts).must_equal expected_musts
#   value(wonts).wont_match expected_wonts
#   value { musts }.must_raise TypeError
#
#   # good
#   expect(musts).must_equal expected_musts
#   expect(wonts).wont_match expected_wonts
#   expect { musts }.must_raise TypeError
# @example EnforcedStyle: value
#   # bad
#   musts.must_equal expected_musts
#   wonts.wont_match expected_wonts
#   musts.must_raise TypeError
#
#   _(musts).must_equal expected_musts
#   _(wonts).wont_match expected_wonts
#   _ { musts }.must_raise TypeError
#
#   expect(musts).must_equal expected_musts
#   expect(wonts).wont_match expected_wonts
#   expect { musts }.must_raise TypeError
#
#   # good
#   value(musts).must_equal expected_musts
#   value(wonts).wont_match expected_wonts
#   value { musts }.must_raise TypeError
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/global_expectations.rb#84
class RuboCop::Cop::Minitest::GlobalExpectations < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::ConfigurableEnforcedStyle
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/global_expectations.rb#110
  def block_receiver?(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/global_expectations.rb#98
  def on_send(node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/global_expectations.rb#114
  def value_receiver?(param0 = T.unsafe(nil)); end

  private

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/global_expectations.rb#118
  def method_allowed?(method); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/global_expectations.rb#122
  def preferred_method; end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/global_expectations.rb#126
  def preferred_receiver(node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/global_expectations.rb#137
  def register_offense(node, method); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/global_expectations.rb#91
RuboCop::Cop::Minitest::GlobalExpectations::BLOCK_MATCHERS = T.let(T.unsafe(nil), Array)

# There are aliases for the `_` method - `expect` and `value`
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/global_expectations.rb#96
RuboCop::Cop::Minitest::GlobalExpectations::DSL_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-minitest//lib/rubocop/cop/minitest/global_expectations.rb#88
RuboCop::Cop::Minitest::GlobalExpectations::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/global_expectations.rb#93
RuboCop::Cop::Minitest::GlobalExpectations::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-minitest//lib/rubocop/cop/minitest/global_expectations.rb#90
RuboCop::Cop::Minitest::GlobalExpectations::VALUE_MATCHERS = T.let(T.unsafe(nil), Array)

# Common functionality for `Minitest/AssertInstanceOf` and `Minitest/RefuteInstanceOf` cops.
#
# @api private
#
# source://rubocop-minitest//lib/rubocop/cop/mixin/instance_of_assertion_handleable.rb#8
module RuboCop::Cop::Minitest::InstanceOfAssertionHandleable
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper

  private

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/instance_of_assertion_handleable.rb#30
  def build_required_arguments(node, method_name, first_capture, second_capture); end

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/instance_of_assertion_handleable.rb#15
  def investigate(node, assertion_type); end

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/instance_of_assertion_handleable.rb#38
  def replacement_range(node, method_name); end
end

# @api private
#
# source://rubocop-minitest//lib/rubocop/cop/mixin/instance_of_assertion_handleable.rb#11
RuboCop::Cop::Minitest::InstanceOfAssertionHandleable::MSG = T.let(T.unsafe(nil), String)

# Checks that lifecycle hooks are declared in the order in which they will be executed.
#
# @example
#   # bad
#   class FooTest < Minitest::Test
#   def teardown; end
#   def setup; end
#   end
#
#   # good
#   class FooTest < Minitest::Test
#   def setup; end
#   def teardown; end
#   end
#
#   # bad (after test cases)
#   class FooTest < Minitest::Test
#   def test_something
#   assert foo
#   end
#   def setup; end
#   def teardown; end
#   end
#
#   # good
#   class FooTest < Minitest::Test
#   def setup; end
#   def teardown; end
#   def test_something
#   assert foo
#   end
#   end
#
#   # good (after non test case methods)
#   class FooTest < Minitest::Test
#   def do_something; end
#   def setup; end
#   def teardown; end
#   end
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/lifecycle_hooks_order.rb#46
class RuboCop::Cop::Minitest::LifecycleHooksOrder < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  include ::RuboCop::Cop::MinitestExplorationHelpers
  include ::RuboCop::Cop::RangeHelp
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/lifecycle_hooks_order.rb#60
  def on_class(class_node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/lifecycle_hooks_order.rb#90
  def autocorrect(corrector, previous_node, node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/lifecycle_hooks_order.rb#84
  def hooks_and_test_cases(class_node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/lifecycle_hooks_order.rb#55
RuboCop::Cop::Minitest::LifecycleHooksOrder::HOOKS_ORDER_MAP = T.let(T.unsafe(nil), Hash)

# source://rubocop-minitest//lib/rubocop/cop/minitest/lifecycle_hooks_order.rb#51
RuboCop::Cop::Minitest::LifecycleHooksOrder::MSG = T.let(T.unsafe(nil), String)

# Regular method's position should be last.
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/lifecycle_hooks_order.rb#54
RuboCop::Cop::Minitest::LifecycleHooksOrder::REGULAR_METHOD_POSITION = T.let(T.unsafe(nil), Integer)

# Enforces correct order of expected and
# actual arguments for `assert_equal`.
#
# @example
#   # bad
#   assert_equal foo, 2
#   assert_equal foo, [1, 2]
#   assert_equal foo, [1, 2], 'message'
#
#   # good
#   assert_equal 2, foo
#   assert_equal [1, 2], foo
#   assert_equal [1, 2], foo, 'message'
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/literal_as_actual_argument.rb#20
class RuboCop::Cop::Minitest::LiteralAsActualArgument < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/literal_as_actual_argument.rb#27
  def on_send(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/literal_as_actual_argument.rb#41
  def autocorrect(corrector, node, expected, actual); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/literal_as_actual_argument.rb#54
  def wrap_with_parentheses(corrector, node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/literal_as_actual_argument.rb#24
RuboCop::Cop::Minitest::LiteralAsActualArgument::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/literal_as_actual_argument.rb#25
RuboCop::Cop::Minitest::LiteralAsActualArgument::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks if test cases contain too many assertion calls. If conditional code with assertions
# is used, the branch with maximum assertions is counted.
# The maximum allowed assertion calls is configurable.
#
# @example Max: 1
#   # bad
#   class FooTest < Minitest::Test
#   def test_asserts_twice
#   assert_equal(42, do_something)
#   assert_empty(array)
#   end
#   end
#
#   # good
#   class FooTest < Minitest::Test
#   def test_asserts_once
#   assert_equal(42, do_something)
#   end
#
#   def test_another_asserts_once
#   assert_empty(array)
#   end
#   end
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/multiple_assertions.rb#30
class RuboCop::Cop::Minitest::MultipleAssertions < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  include ::RuboCop::Cop::MinitestExplorationHelpers

  # source://rubocop-minitest//lib/rubocop/cop/minitest/multiple_assertions.rb#35
  def max=(value); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/multiple_assertions.rb#37
  def on_class(class_node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/multiple_assertions.rb#54
  def assertions_count(node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/multiple_assertions.rb#62
  def assertions_count_based_on_type(node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/multiple_assertions.rb#77
  def assertions_count_in_assignment(node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/multiple_assertions.rb#99
  def assertions_count_in_branches(branches); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/multiple_assertions.rb#103
  def max_assertions; end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/multiple_assertions.rb#33
RuboCop::Cop::Minitest::MultipleAssertions::MSG = T.let(T.unsafe(nil), String)

# Common functionality for `AssertNil` and `RefuteNil` cops.
#
# @api private
#
# source://rubocop-minitest//lib/rubocop/cop/mixin/nil_assertion_handleable.rb#8
module RuboCop::Cop::Minitest::NilAssertionHandleable
  private

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/nil_assertion_handleable.rb#35
  def autocorrect(corrector, node, actual); end

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/nil_assertion_handleable.rb#21
  def build_message(node, actual, message); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/nil_assertion_handleable.rb#45
  def comparison_or_predicate_assertion_method?(node); end

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/nil_assertion_handleable.rb#13
  def register_offense(node, actual, message); end
end

# @api private
#
# source://rubocop-minitest//lib/rubocop/cop/mixin/nil_assertion_handleable.rb#9
RuboCop::Cop::Minitest::NilAssertionHandleable::MSG = T.let(T.unsafe(nil), String)

# Checks if test cases contain any assertion calls.
#
# Matchers such as `must_equal` and `wont_match` are also treated as assertion methods.
#
# @example
#   # bad
#   class FooTest < Minitest::Test
#   def test_the_truth
#   end
#   end
#
#   # good
#   class FooTest < Minitest::Test
#   def test_the_truth
#   assert true
#   end
#   end
#
#   # bad
#   class FooTest < ActiveSupport::TestCase
#   describe 'foo' do
#   it 'test equal' do
#   end
#   end
#   end
#
#   # good
#   class FooTest < ActiveSupport::TestCase
#   describe 'foo' do
#   it 'test equal' do
#   musts.must_equal expected_musts
#   end
#   end
#   end
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/no_assertions.rb#41
class RuboCop::Cop::Minitest::NoAssertions < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  include ::RuboCop::Cop::MinitestExplorationHelpers

  # source://rubocop-minitest//lib/rubocop/cop/minitest/no_assertions.rb#46
  def on_class(class_node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/no_assertions.rb#44
RuboCop::Cop::Minitest::NoAssertions::MSG = T.let(T.unsafe(nil), String)

# Checks if test class contains any test cases.
#
# @example
#   # bad
#   class FooTest < Minitest::Test
#   def do_something
#   end
#   end
#
#   # good
#   class FooTest < Minitest::Test
#   def test_something
#   assert true
#   end
#   end
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/no_test_cases.rb#22
class RuboCop::Cop::Minitest::NoTestCases < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  include ::RuboCop::Cop::MinitestExplorationHelpers

  # source://rubocop-minitest//lib/rubocop/cop/minitest/no_test_cases.rb#27
  def on_class(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/no_test_cases.rb#25
RuboCop::Cop::Minitest::NoTestCases::MSG = T.let(T.unsafe(nil), String)

# Checks for the use of test methods outside of a test class.
#
# Test methods should be defined within a test class to ensure their execution.
#
# NOTE: This cop assumes that classes whose superclass name includes the word
# "`Test`" are test classes, in order to prevent false positives.
#
# @example
#
#   # bad
#   class FooTest < Minitest::Test
#   end
#   def test_method_should_be_inside_test_class
#   end
#
#   # good
#   class FooTest < Minitest::Test
#   def test_method_should_be_inside_test_class
#   end
#   end
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/non_executable_test_method.rb#27
class RuboCop::Cop::Minitest::NonExecutableTestMethod < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  include ::RuboCop::Cop::MinitestExplorationHelpers

  # source://rubocop-minitest//lib/rubocop/cop/minitest/non_executable_test_method.rb#32
  def on_def(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/non_executable_test_method.rb#47
  def possible_test_class?(node); end

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/non_executable_test_method.rb#41
  def use_test_class?; end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/non_executable_test_method.rb#30
RuboCop::Cop::Minitest::NonExecutableTestMethod::MSG = T.let(T.unsafe(nil), String)

# Detects non `public` (marked as `private` or `protected`) test methods.
# Minitest runs only test methods which are `public`.
#
# @example
#   # bad
#   class FooTest
#   private # or protected
#   def test_does_something
#   assert_equal 42, do_something
#   end
#   end
#
#   # good
#   class FooTest
#   def test_does_something
#   assert_equal 42, do_something
#   end
#   end
#
#   # good (not a test case name)
#   class FooTest
#   private # or protected
#   def does_something
#   assert_equal 42, do_something
#   end
#   end
#
#   # good (no assertions)
#   class FooTest
#   private # or protected
#   def test_does_something
#   do_something
#   end
#   end
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/non_public_test_method.rb#41
class RuboCop::Cop::Minitest::NonPublicTestMethod < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  include ::RuboCop::Cop::MinitestExplorationHelpers

  # source://rubocop-minitest//lib/rubocop/cop/minitest/non_public_test_method.rb#47
  def on_class(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/non_public_test_method.rb#45
RuboCop::Cop::Minitest::NonPublicTestMethod::MSG = T.let(T.unsafe(nil), String)

# Common functionality for `Minitest/AssertPredicate` and `Minitest/RefutePredicate` cops.
#
# @api private
#
# source://rubocop-minitest//lib/rubocop/cop/mixin/predicate_assertion_handleable.rb#8
module RuboCop::Cop::Minitest::PredicateAssertionHandleable
  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/predicate_assertion_handleable.rb#21
  def autocorrect(corrector, node, arguments); end

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/predicate_assertion_handleable.rb#11
  def on_send(node); end

  private

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/predicate_assertion_handleable.rb#50
  def correct_receiver(receiver); end

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/predicate_assertion_handleable.rb#43
  def new_arguments(arguments); end

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/predicate_assertion_handleable.rb#35
  def offense_message(arguments); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/predicate_assertion_handleable.rb#31
  def predicate_method?(first_argument); end
end

# @api private
#
# source://rubocop-minitest//lib/rubocop/cop/mixin/predicate_assertion_handleable.rb#9
RuboCop::Cop::Minitest::PredicateAssertionHandleable::MSG = T.let(T.unsafe(nil), String)

# Detects redundant message argument in assertion methods.
# The message argument `nil` is redundant because it is the default value.
#
# @example
#
#   # bad
#   assert_equal(expected, actual, nil)
#
#   # good
#   assert_equal(expected, actual)
#   assert_equal(expected, actual, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/redundant_message_argument.rb#18
class RuboCop::Cop::Minitest::RedundantMessageArgument < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/redundant_message_argument.rb#71
  def on_send(node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/redundant_message_argument.rb#34
  def redundant_message_argument(param0 = T.unsafe(nil)); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/redundant_message_argument.rb#21
RuboCop::Cop::Minitest::RedundantMessageArgument::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/redundant_message_argument.rb#23
RuboCop::Cop::Minitest::RedundantMessageArgument::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces to use `refute_empty` instead of using `refute(object.empty?)`.
#
# @example
#   # bad
#   refute(object.empty?)
#   refute(object.empty?, 'message')
#
#   # good
#   refute_empty(object)
#   refute_empty(object, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_empty.rb#17
class RuboCop::Cop::Minitest::RefuteEmpty < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  extend ::RuboCop::Cop::MinitestCopRule
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_empty.rb#20
  def autocorrect(corrector, node, arguments); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_empty.rb#20
  def on_send(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_empty.rb#20
  def correct_receiver(receiver); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_empty.rb#20
  def new_arguments(arguments); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_empty.rb#20
  def offense_message(arguments); end
end

# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#43
RuboCop::Cop::Minitest::RefuteEmpty::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#44
RuboCop::Cop::Minitest::RefuteEmpty::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of `refute_equal(expected, object)`
# over `assert(expected != actual)` or `assert(! expected == actual)`.
#
# @example
#   # bad
#   assert("rubocop-minitest" != actual)
#   refute("rubocop-minitest" == actual)
#   assert_operator("rubocop-minitest", :!=, actual)
#   refute_operator("rubocop-minitest", :==, actual)
#
#   # good
#   refute_equal("rubocop-minitest", actual)
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_equal.rb#19
class RuboCop::Cop::Minitest::RefuteEqual < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_equal.rb#36
  def on_send(node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_equal.rb#26
  def refute_equal(param0 = T.unsafe(nil)); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_equal.rb#23
RuboCop::Cop::Minitest::RefuteEqual::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_equal.rb#24
RuboCop::Cop::Minitest::RefuteEqual::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of `refute(object)` over `assert_equal(false, object)`.
#
# @example
#   # bad
#   assert_equal(false, actual)
#   assert_equal(false, actual, 'message')
#
#   assert(!test)
#   assert(!test, 'message')
#
#   # good
#   refute(actual)
#   refute(actual, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_false.rb#30
class RuboCop::Cop::Minitest::RefuteFalse < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_false.rb#38
  def assert_equal_with_false(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_false.rb#42
  def assert_with_bang_argument(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_false.rb#46
  def on_send(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_false.rb#63
  def autocorrect(corrector, node, actual); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_false.rb#35
RuboCop::Cop::Minitest::RefuteFalse::MSG_FOR_ASSERT = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_false.rb#34
RuboCop::Cop::Minitest::RefuteFalse::MSG_FOR_ASSERT_EQUAL = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_false.rb#36
RuboCop::Cop::Minitest::RefuteFalse::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the test to use `refute_in_delta`
# instead of using `refute_equal` to compare floats.
#
# @example
#   # bad
#   refute_equal(0.2, actual)
#   refute_equal(0.2, actual, 'message')
#
#   # good
#   refute_in_delta(0.2, actual)
#   refute_in_delta(0.2, actual, 0.001, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_in_delta.rb#18
class RuboCop::Cop::Minitest::RefuteInDelta < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::InDeltaMixin
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_in_delta.rb#24
  def equal_floats_call(param0 = T.unsafe(nil)); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_in_delta.rb#22
RuboCop::Cop::Minitest::RefuteInDelta::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the test to use `refute_includes`
# instead of using `refute(collection.include?(object))`.
#
# @example
#   # bad
#   refute(collection.include?(object))
#   refute(collection.include?(object), 'message')
#
#   # good
#   refute_includes(collection, object)
#   refute_includes(collection, object, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_includes.rb#18
class RuboCop::Cop::Minitest::RefuteIncludes < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  extend ::RuboCop::Cop::MinitestCopRule
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_includes.rb#21
  def autocorrect(corrector, node, arguments); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_includes.rb#21
  def on_send(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_includes.rb#21
  def correct_receiver(receiver); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_includes.rb#21
  def new_arguments(arguments); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_includes.rb#21
  def offense_message(arguments); end
end

# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#43
RuboCop::Cop::Minitest::RefuteIncludes::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#44
RuboCop::Cop::Minitest::RefuteIncludes::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of `refute_instance_of(Class, object)`
# over `refute(object.instance_of?(Class))`.
#
# @example
#   # bad
#   refute(object.instance_of?(Class))
#   refute(object.instance_of?(Class), 'message')
#
#   # bad
#   refute_equal(Class, object.class)
#   refute_equal(Class, object.class, 'message')
#
#   # good
#   refute_instance_of(Class, object)
#   refute_instance_of(Class, object, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_instance_of.rb#22
class RuboCop::Cop::Minitest::RefuteInstanceOf < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  include ::RuboCop::Cop::Minitest::InstanceOfAssertionHandleable
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_instance_of.rb#28
  def instance_of_assertion?(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_instance_of.rb#35
  def on_send(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_instance_of.rb#26
RuboCop::Cop::Minitest::RefuteInstanceOf::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of `refute_kind_of(Class, object)`
# over `refute(object.kind_of?(Class))`.
#
# @example
#   # bad
#   refute(object.kind_of?(Class))
#   refute(object.kind_of?(Class), 'message')
#
#   # bad
#   # `is_a?` is an alias for `kind_of?`
#   refute(object.is_of?(Class))
#   refute(object.is_of?(Class), 'message')
#
#   # good
#   refute_kind_of(Class, object)
#   refute_kind_of(Class, object, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_kind_of.rb#23
class RuboCop::Cop::Minitest::RefuteKindOf < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  extend ::RuboCop::Cop::MinitestCopRule
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_kind_of.rb#26
  def autocorrect(corrector, node, arguments); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_kind_of.rb#26
  def on_send(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_kind_of.rb#26
  def correct_receiver(receiver); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_kind_of.rb#26
  def new_arguments(arguments); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_kind_of.rb#26
  def offense_message(arguments); end
end

# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#43
RuboCop::Cop::Minitest::RefuteKindOf::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#44
RuboCop::Cop::Minitest::RefuteKindOf::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the test to use `refute_match`
# instead of using `refute(matcher.match(string))`.
#
# @example
#   # bad
#   refute(matcher.match(string))
#   refute(matcher.match?(string))
#   refute(matcher =~ string)
#   refute_operator(matcher, :=~, string)
#   assert_operator(matcher, :!~, string)
#   refute(matcher.match(string), 'message')
#
#   # good
#   refute_match(matcher, string)
#   refute_match(matcher, string, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_match.rb#22
class RuboCop::Cop::Minitest::RefuteMatch < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_match.rb#38
  def on_send(node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_match.rb#29
  def refute_match(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_match.rb#61
  def order_expected_and_actual(expected, actual); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_match.rb#26
RuboCop::Cop::Minitest::RefuteMatch::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_match.rb#27
RuboCop::Cop::Minitest::RefuteMatch::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the test to use `refute_nil` instead of using
# `refute_equal(nil, something)`, `refute(something.nil?)`, or `refute_predicate(something, :nil?)`.
#
# @example
#   # bad
#   refute_equal(nil, actual)
#   refute_equal(nil, actual, 'message')
#   refute(actual.nil?)
#   refute(actual.nil?, 'message')
#   refute_predicate(object, :nil?)
#   refute_predicate(object, :nil?, 'message')
#
#   # good
#   refute_nil(actual)
#   refute_nil(actual, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_nil.rb#22
class RuboCop::Cop::Minitest::RefuteNil < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  include ::RuboCop::Cop::Minitest::NilAssertionHandleable
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_nil.rb#30
  def nil_refutation(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_nil.rb#38
  def on_send(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_nil.rb#46
  def assertion_type; end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_nil.rb#27
RuboCop::Cop::Minitest::RefuteNil::ASSERTION_TYPE = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_nil.rb#28
RuboCop::Cop::Minitest::RefuteNil::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of `refute_operator(expected, :<, actual)` over `refute(expected < actual)`.
#
# @example
#
#   # bad
#   refute(expected < actual)
#
#   # good
#   refute_operator(expected, :<, actual)
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_operator.rb#16
class RuboCop::Cop::Minitest::RefuteOperator < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_operator.rb#23
  def on_send(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_operator.rb#41
  def build_new_arguments(node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_operator.rb#52
  def range_of_arguments(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_operator.rb#21
RuboCop::Cop::Minitest::RefuteOperator::ALLOWED_OPERATORS = T.let(T.unsafe(nil), Array)

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_operator.rb#19
RuboCop::Cop::Minitest::RefuteOperator::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_operator.rb#20
RuboCop::Cop::Minitest::RefuteOperator::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the test to use `refute_path_exists` instead of using `refute(File.exist?(path))`.
#
# @example
#   # bad
#   refute(File.exist?(path))
#   refute(File.exist?(path), 'message')
#
#   # good
#   refute_path_exists(path)
#   refute_path_exists(path, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_path_exists.rb#17
class RuboCop::Cop::Minitest::RefutePathExists < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_path_exists.rb#30
  def on_send(node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_path_exists.rb#23
  def refute_file_exists(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_path_exists.rb#45
  def build_good_method(node, path, message); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_path_exists.rb#20
RuboCop::Cop::Minitest::RefutePathExists::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_path_exists.rb#21
RuboCop::Cop::Minitest::RefutePathExists::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the test to use `refute_predicate`
# instead of using `refute(obj.a_predicate_method?)`.
#
# @example
#   # bad
#   refute(obj.one?)
#   refute(obj.one?, 'message')
#
#   # good
#   refute_predicate(obj, :one?)
#   refute_predicate(obj, :one?, 'message')
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_predicate.rb#18
class RuboCop::Cop::Minitest::RefutePredicate < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  include ::RuboCop::Cop::Minitest::PredicateAssertionHandleable
  extend ::RuboCop::Cop::AutoCorrector

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_predicate.rb#28
  def assertion_type; end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_predicate.rb#23
RuboCop::Cop::Minitest::RefutePredicate::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_predicate.rb#24
RuboCop::Cop::Minitest::RefutePredicate::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the test to use `refute_respond_to(object, :do_something)`
# over `refute(object.respond_to?(:do_something))`.
#
# @example
#   # bad
#   refute(object.respond_to?(:do_something))
#   refute(object.respond_to?(:do_something), 'message')
#   refute(respond_to?(:do_something))
#
#   # good
#   refute_respond_to(object, :do_something)
#   refute_respond_to(object, :do_something, 'message')
#   refute_respond_to(self, :do_something)
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_respond_to.rb#20
class RuboCop::Cop::Minitest::RefuteRespondTo < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::RangeHelp
  include ::RuboCop::Cop::ArgumentRangeHelper
  extend ::RuboCop::Cop::MinitestCopRule
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_respond_to.rb#23
  def autocorrect(corrector, node, arguments); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_respond_to.rb#23
  def on_send(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_respond_to.rb#23
  def correct_receiver(receiver); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_respond_to.rb#23
  def new_arguments(arguments); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_respond_to.rb#23
  def offense_message(arguments); end
end

# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#43
RuboCop::Cop::Minitest::RefuteRespondTo::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#44
RuboCop::Cop::Minitest::RefuteRespondTo::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of `refute_same(expected, object)`
# over `refute(expected.equal?(actual))`.
#
# NOTE: Use `refute_same` only when there is a need to compare by identity.
#       Otherwise, use `refute_equal`.
#
# @example
#   # bad
#   refute(expected.equal?(actual))
#   refute_equal(expected.object_id, actual.object_id)
#
#   # good
#   refute_same(expected, actual)
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_same.rb#20
class RuboCop::Cop::Minitest::RefuteSame < ::RuboCop::Cop::Base
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_same.rb#40
  def on_send(node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_same.rb#32
  def refute_equal_with_object_id?(param0 = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_same.rb#26
  def refute_with_equal?(param0 = T.unsafe(nil)); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_same.rb#58
  def message(expected_node, actual_node, message_node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/refute_same.rb#63
  def remove_method_call(send_node, corrector); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_same.rb#23
RuboCop::Cop::Minitest::RefuteSame::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/refute_same.rb#24
RuboCop::Cop::Minitest::RefuteSame::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Enforces the use of `skip` instead of `return` in test methods.
#
# @example
#   # bad
#   def test_something
#   return if condition?
#   assert_equal(42, something)
#   end
#
#   # good
#   def test_something
#   skip if condition?
#   assert_equal(42, something)
#   end
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/return_in_test_method.rb#21
class RuboCop::Cop::Minitest::ReturnInTestMethod < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  include ::RuboCop::Cop::MinitestExplorationHelpers
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/return_in_test_method.rb#27
  def on_return(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/return_in_test_method.rb#38
  def inside_block?(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/return_in_test_method.rb#25
RuboCop::Cop::Minitest::ReturnInTestMethod::MSG = T.let(T.unsafe(nil), String)

# Checks that `ensure` call even if `skip`. It is unexpected that `ensure` will be called when skipping test.
# If conditional `skip` is used, it checks that `ensure` is also called conditionally.
#
# On the other hand, it accepts `skip` used in `rescue` because `ensure` may be teardown process to `begin`
# setup process.
#
# @example
#
#   # bad
#   def test_skip
#   skip 'This test is skipped.'
#
#   assert 'foo'.present?
#   ensure
#   do_something
#   end
#
#   # bad
#   def test_conditional_skip
#   skip 'This test is skipped.' if condition
#
#   assert do_something
#   ensure
#   do_teardown
#   end
#
#   # good
#   def test_skip
#   skip 'This test is skipped.'
#
#   begin
#   assert 'foo'.present?
#   ensure
#   do_something
#   end
#   end
#
#   # good
#   def test_conditional_skip
#   skip 'This test is skipped.' if condition
#
#   assert do_something
#   ensure
#   if condition
#   do_teardown
#   end
#   end
#
#   # good
#   def test_skip_is_used_in_rescue
#   do_setup
#   assert do_something
#   rescue
#   skip 'This test is skipped.'
#   ensure
#   do_teardown
#   end
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/skip_ensure.rb#64
class RuboCop::Cop::Minitest::SkipEnsure < ::RuboCop::Cop::Base
  # source://rubocop-minitest//lib/rubocop/cop/minitest/skip_ensure.rb#67
  def on_ensure(node); end

  private

  # source://rubocop-minitest//lib/rubocop/cop/minitest/skip_ensure.rb#77
  def find_skip(node); end

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/skip_ensure.rb#83
  def use_skip_in_rescue?(skip_method); end

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/skip_ensure.rb#87
  def valid_conditional_skip?(skip_method, ensure_node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/skip_ensure.rb#65
RuboCop::Cop::Minitest::SkipEnsure::MSG = T.let(T.unsafe(nil), String)

# Checks for skipped tests missing the skipping reason.
#
# @example
#   # bad
#   skip
#   skip('')
#
#   # bad
#   if condition?
#   skip
#   else
#   skip
#   end
#
#   # good
#   skip("Reason why the test was skipped")
#
#   # good
#   skip if condition?
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/skip_without_reason.rb#26
class RuboCop::Cop::Minitest::SkipWithoutReason < ::RuboCop::Cop::Base
  # source://rubocop-minitest//lib/rubocop/cop/minitest/skip_without_reason.rb#31
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/skip_without_reason.rb#44
  def blank_argument?(node); end

  # source://rubocop-minitest//lib/rubocop/cop/minitest/skip_without_reason.rb#49
  def conditional_parent(node); end

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/skip_without_reason.rb#59
  def only_skip_branches?(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/skip_without_reason.rb#27
RuboCop::Cop::Minitest::SkipWithoutReason::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/skip_without_reason.rb#29
RuboCop::Cop::Minitest::SkipWithoutReason::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# Checks if test file names start with `test_` or end with `_test.rb`.
# Files which define classes having names ending with `Test` are checked.
# Not following this convention may result in tests not being run.
#
# @example
#   # bad
#   my_class.rb
#
#   # good
#   my_class_test.rb
#   test_my_class.rb
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/test_file_name.rb#18
class RuboCop::Cop::Minitest::TestFileName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  include ::RuboCop::Cop::MinitestExplorationHelpers

  # source://rubocop-minitest//lib/rubocop/cop/minitest/test_file_name.rb#23
  def on_new_investigation; end

  private

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/test_file_name.rb#32
  def test_file?(node); end

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/test_file_name.rb#38
  def valid_file_name?; end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/test_file_name.rb#21
RuboCop::Cop::Minitest::TestFileName::MSG = T.let(T.unsafe(nil), String)

# Enforces that test method names start with `test_` prefix.
# It aims to prevent tests that aren't executed by forgetting to start test method name with `test_`.
#
# @example
#   # bad
#   class FooTest < Minitest::Test
#   def does_something
#   assert_equal 42, do_something
#   end
#   end
#
#   # good
#   class FooTest < Minitest::Test
#   def test_does_something
#   assert_equal 42, do_something
#   end
#   end
#
#   # good
#   class FooTest < Minitest::Test
#   def helper_method(argument)
#   end
#   end
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/test_method_name.rb#30
class RuboCop::Cop::Minitest::TestMethodName < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  include ::RuboCop::Cop::MinitestExplorationHelpers
  extend ::RuboCop::Cop::AutoCorrector

  # source://rubocop-minitest//lib/rubocop/cop/minitest/test_method_name.rb#37
  def on_class(class_node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/test_method_name.rb#53
  def offense?(node); end

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/test_method_name.rb#59
  def public?(node); end

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/test_method_name.rb#63
  def test_method_name?(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/test_method_name.rb#35
RuboCop::Cop::Minitest::TestMethodName::MSG = T.let(T.unsafe(nil), String)

# Checks for `assert_raises` has an assertion method at
# the bottom of block because the assertion will be never reached.
#
# @example
#
#   # bad
#   assert_raises FooError do
#   obj.occur_error
#   assert_equal('foo', obj.bar) # Never asserted.
#   end
#
#   # good
#   assert_raises FooError do
#   obj.occur_error
#   end
#   assert_equal('foo', obj.bar)
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/unreachable_assertion.rb#23
class RuboCop::Cop::Minitest::UnreachableAssertion < ::RuboCop::Cop::Base
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  include ::RuboCop::Cop::MinitestExplorationHelpers

  # source://rubocop-minitest//lib/rubocop/cop/minitest/unreachable_assertion.rb#28
  def on_block(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/unreachable_assertion.rb#26
RuboCop::Cop::Minitest::UnreachableAssertion::MSG = T.let(T.unsafe(nil), String)

# Checks for a specified error in `assert_raises`.
#
# @example
#   # bad
#   assert_raises { raise FooException }
#   assert_raises('This should have raised') { raise FooException }
#
#   # good
#   assert_raises(FooException) { raise FooException }
#   assert_raises(FooException, 'This should have raised') { raise FooException }
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/unspecified_exception.rb#17
class RuboCop::Cop::Minitest::UnspecifiedException < ::RuboCop::Cop::Base
  # source://rubocop-minitest//lib/rubocop/cop/minitest/unspecified_exception.rb#20
  def on_block(block_node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/unspecified_exception.rb#29
  def unspecified_exception?(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/unspecified_exception.rb#18
RuboCop::Cop::Minitest::UnspecifiedException::MSG = T.let(T.unsafe(nil), String)

# Detects useless assertions (assertions that either always pass or always fail).
#
# @example
#   # bad
#   assert true
#   assert_equal @foo, @foo
#   assert_nil [foo, bar]
#
#   # good
#   assert something
#   assert_equal foo, bar
#   assert_nil foo
#   assert false, "My message"
#
# source://rubocop-minitest//lib/rubocop/cop/minitest/useless_assertion.rb#20
class RuboCop::Cop::Minitest::UselessAssertion < ::RuboCop::Cop::Base
  # source://rubocop-minitest//lib/rubocop/cop/minitest/useless_assertion.rb#35
  def on_send(node); end

  private

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/useless_assertion.rb#67
  def empty_composite?(node); end

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/minitest/useless_assertion.rb#44
  def offense?(node); end
end

# source://rubocop-minitest//lib/rubocop/cop/minitest/useless_assertion.rb#21
RuboCop::Cop::Minitest::UselessAssertion::MSG = T.let(T.unsafe(nil), String)

# source://rubocop-minitest//lib/rubocop/cop/minitest/useless_assertion.rb#31
RuboCop::Cop::Minitest::UselessAssertion::RESTRICT_ON_SEND = T.let(T.unsafe(nil), Array)

# source://rubocop-minitest//lib/rubocop/cop/minitest/useless_assertion.rb#23
RuboCop::Cop::Minitest::UselessAssertion::SINGLE_ASSERTION_ARGUMENT_METHODS = T.let(T.unsafe(nil), Array)

# source://rubocop-minitest//lib/rubocop/cop/minitest/useless_assertion.rb#26
RuboCop::Cop::Minitest::UselessAssertion::TWO_ASSERTION_ARGUMENTS_METHODS = T.let(T.unsafe(nil), Array)

# Provide a method to define offense rule for Minitest cops.
#
# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#6
module RuboCop::Cop::MinitestCopRule
  # Define offense rule for Minitest cops.
  #
  # @api private
  # @example
  #   define_rule :assert, target_method: :match
  #   define_rule :refute, target_method: :match
  #   define_rule :assert, target_method: :include?, preferred_method: :assert_includes
  #   define_rule :assert, target_method: :instance_of?, inverse: true
  # @example Multiple target methods
  #   # `preferred_method` is required
  #   define_rule :assert, target_method: %i[match match? =~],
  #   preferred_method: :assert_match, inverse: 'regexp_type?'
  # @param assertion_method [Symbol] Assertion method like `assert` or `refute`.
  # @param inverse [Boolean, String] An optional param. Order of arguments replaced by autocorrection.
  #   If string is passed, it becomes a predicate method for the first argument node.
  # @param preferred_method [Symbol] Is required if passing multiple target methods. Custom method name replaced by
  #   autocorrection. The preferred method name that connects
  #   `assertion_method` and `target_method` with `_` is
  #   the default name.
  # @param target_method [Symbol, Array<Symbol>] Method name(s) offensed by assertion method arguments.
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_cop_rule.rb#31
  def define_rule(assertion_method, target_method:, preferred_method: T.unsafe(nil), inverse: T.unsafe(nil)); end
end

# Helper methods for different explorations against test files and test cases.
#
# @api private
#
# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#9
module RuboCop::Cop::MinitestExplorationHelpers
  include ::RuboCop::Cop::VisibilityHelp
  include ::RuboCop::Cop::DefNode
  extend ::RuboCop::AST::NodePattern::Macros

  private

  # @api private
  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#118
  def assertion_method?(node); end

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#97
  def assertions(def_node); end

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#111
  def assertions_count(node); end

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#82
  def class_def_nodes(class_node); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#130
  def lifecycle_hook_method?(node); end

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#77
  def lifecycle_hooks(class_node); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#73
  def test_block?(block_node); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#47
  def test_case?(node); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#93
  def test_case_name?(name); end

  # @api private
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#55
  def test_cases(class_node, visibility_check: T.unsafe(nil)); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#43
  def test_class?(class_node); end

  # @api private
  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#67
  def test_method?(def_node, visibility_check: T.unsafe(nil)); end
end

# @api private
#
# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#28
RuboCop::Cop::MinitestExplorationHelpers::ASSERTION_PREFIXES = T.let(T.unsafe(nil), Array)

# @api private
#
# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#22
RuboCop::Cop::MinitestExplorationHelpers::BLOCK_MATCHERS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#39
RuboCop::Cop::MinitestExplorationHelpers::LIFECYCLE_HOOK_METHODS = T.let(T.unsafe(nil), Set)

# @api private
#
# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#30
RuboCop::Cop::MinitestExplorationHelpers::LIFECYCLE_HOOK_METHODS_IN_ORDER = T.let(T.unsafe(nil), Array)

# @api private
#
# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#26
RuboCop::Cop::MinitestExplorationHelpers::MATCHER_METHODS = T.let(T.unsafe(nil), Array)

# @api private
#
# source://rubocop-minitest//lib/rubocop/cop/mixin/minitest_exploration_helpers.rb#13
RuboCop::Cop::MinitestExplorationHelpers::VALUE_MATCHERS = T.let(T.unsafe(nil), Array)

# RuboCop minitest project namespace.
#
# source://rubocop-minitest//lib/rubocop/minitest.rb#5
module RuboCop::Minitest; end

# Mixin for `assert_offense` and `assert_no_offenses`
#
# This mixin makes it easier to specify strict offense assertions
# in a declarative and visual fashion. Just type out the code that
# should generate an offense, annotate code by writing '^'s
# underneath each character that should be highlighted, and follow
# the carets with a string (separated by a space) that is the
# message of the offense. You can include multiple offenses in
# one code snippet.
#
# Autocorrection can be tested using `assert_correction` after
# `assert_offense`.
#
# If you do not want to specify an offense then use the
# companion method `assert_no_offenses`. This method is a much
# simpler assertion since it just inspects the source and checks
# that there were no offenses. The `assert_offense` method has
# to do more work by parsing out lines that contain carets.
#
# If the code produces an offense that could not be autocorrected, you can
# use `assert_no_corrections` after `assert_offense`.
#
#
# @example Usage
#
#   assert_offense(<<~RUBY)
#   class FooTest < Minitest::Test
#   def test_do_something
#   assert_equal(nil, somestuff)
#   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^ Prefer using `assert_nil(somestuff)`.
#   end
#   end
#   RUBY
# @example `assert_offense` and `assert_correction`
#
#   assert_offense(<<~RUBY)
#   class FooTest < Minitest::Test
#   def test_do_something
#   assert_equal(nil, somestuff)
#   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^ Prefer using `assert_nil(somestuff)`.
#   end
#   end
#   RUBY
#
#   assert_correction(<<~RUBY)
#   class FooTest < Minitest::Test
#   def test_do_something
#   assert_nil(somestuff)
#   end
#   end
#   RUBY
# @example `assert_offense` and `assert_no_corrections`
#
#   assert_offense(<<~RUBY)
#   class FooTest < Minitest::Test
#   def test_do_something
#   assert_equal(nil, somestuff)
#   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^ Prefer using `assert_nil(somestuff)`.
#   end
#   end
#   RUBY
#
#   assert_no_corrections
#
# source://rubocop-minitest//lib/rubocop/minitest/assert_offense.rb#75
module RuboCop::Minitest::AssertOffense
  private

  # source://rubocop-minitest//lib/rubocop/minitest/assert_offense.rb#127
  def _investigate(cop, processed_source); end

  # source://rubocop-minitest//lib/rubocop/minitest/assert_offense.rb#138
  def assert_correction(correction, loop: T.unsafe(nil)); end

  # @raise [RuboCop::Runner::InfiniteCorrectionLoop]
  #
  # source://rubocop-minitest//lib/rubocop/minitest/assert_offense.rb#163
  def assert_no_corrections; end

  # source://rubocop-minitest//lib/rubocop/minitest/assert_offense.rb#97
  def assert_no_offenses(source, file = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/minitest/assert_offense.rb#108
  def assert_offense(source, file = T.unsafe(nil), **replacements); end

  # source://rubocop-minitest//lib/rubocop/minitest/assert_offense.rb#215
  def configuration; end

  # source://rubocop-minitest//lib/rubocop/minitest/assert_offense.rb#78
  def cop; end

  # source://rubocop-minitest//lib/rubocop/minitest/assert_offense.rb#134
  def enable_autocorrect; end

  # source://rubocop-minitest//lib/rubocop/minitest/assert_offense.rb#87
  def format_offense(source, **replacements); end

  # source://rubocop-minitest//lib/rubocop/minitest/assert_offense.rb#183
  def inspect_source(source, cop, file = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/minitest/assert_offense.rb#190
  def investigate(cop, processed_source); end

  # source://rubocop-minitest//lib/rubocop/minitest/assert_offense.rb#202
  def parse_source!(source, file = T.unsafe(nil)); end

  # source://rubocop-minitest//lib/rubocop/minitest/assert_offense.rb#237
  def parser_engine; end

  # source://rubocop-minitest//lib/rubocop/minitest/assert_offense.rb#223
  def registry; end

  # source://rubocop-minitest//lib/rubocop/minitest/assert_offense.rb#232
  def ruby_version; end

  # source://rubocop-minitest//lib/rubocop/minitest/assert_offense.rb#178
  def setup_assertion; end
end

# A plugin that integrates RuboCop Minitest with RuboCop's plugin system.
#
# source://rubocop-minitest//lib/rubocop/minitest/plugin.rb#8
class RuboCop::Minitest::Plugin < ::LintRoller::Plugin
  # source://rubocop-minitest//lib/rubocop/minitest/plugin.rb#9
  def about; end

  # source://rubocop-minitest//lib/rubocop/minitest/plugin.rb#22
  def rules(_context); end

  # @return [Boolean]
  #
  # source://rubocop-minitest//lib/rubocop/minitest/plugin.rb#18
  def supported?(context); end
end

# This module holds the RuboCop Minitest version information.
#
# source://rubocop-minitest//lib/rubocop/minitest/version.rb#6
module RuboCop::Minitest::Version
  class << self
    # source://rubocop-minitest//lib/rubocop/minitest/version.rb#9
    def document_version; end
  end
end

# source://rubocop-minitest//lib/rubocop/minitest/version.rb#7
RuboCop::Minitest::Version::STRING = T.let(T.unsafe(nil), String)
