use super::{color, Color, Element};

impl Element {
    /// Returns the color for the element in the CPK convention.
    ///
    /// ```
    /// use mendeleev::{Element, Color};
    ///
    /// assert_eq!(Element::H.cpk_color(), Some(Color{r: 255, g: 255, b: 255}));
    /// assert_eq!(Element::Og.cpk_color(), None);
    /// assert_eq!(Element::Au.cpk_color(), Some(Color{r: 218, g: 165, b: 32}));
    /// ```
    pub const fn cpk_color(&self) -> Option<Color> {
        match self {
            Element::H => color(255, 255, 255),
            Element::He => color(255, 192, 203),
            Element::Li => color(178, 34, 34),
            Element::Be => color(255, 20, 147),
            Element::B => color(0, 255, 0),
            Element::C => color(200, 200, 200),
            Element::N => color(143, 143, 255),
            Element::O => color(240, 0, 0),
            Element::F => color(218, 165, 32),
            Element::Ne => color(255, 20, 147),
            Element::Na => color(0, 0, 255),
            Element::Mg => color(34, 139, 34),
            Element::Al => color(128, 128, 144),
            Element::Si => color(218, 165, 32),
            Element::P => color(255, 165, 0),
            Element::S => color(255, 200, 50),
            Element::Cl => color(0, 255, 0),
            Element::Ar => color(255, 20, 147),
            Element::K => color(255, 20, 147),
            Element::Ca => color(128, 128, 144),
            Element::Sc => color(255, 20, 147),
            Element::Ti => color(128, 128, 144),
            Element::V => color(255, 20, 147),
            Element::Cr => color(128, 128, 144),
            Element::Mn => color(128, 128, 144),
            Element::Fe => color(255, 165, 0),
            Element::Co => color(255, 20, 147),
            Element::Ni => color(165, 42, 42),
            Element::Cu => color(165, 42, 42),
            Element::Zn => color(165, 42, 42),
            Element::Ga => color(255, 20, 147),
            Element::Ge => color(255, 20, 147),
            Element::As => color(255, 20, 147),
            Element::Se => color(255, 20, 147),
            Element::Br => color(165, 42, 42),
            Element::Kr => color(255, 20, 147),
            Element::Rb => color(255, 20, 147),
            Element::Sr => color(255, 20, 147),
            Element::Y => color(255, 20, 147),
            Element::Zr => color(255, 20, 147),
            Element::Nb => color(255, 20, 147),
            Element::Mo => color(255, 20, 147),
            Element::Tc => color(255, 20, 147),
            Element::Ru => color(255, 20, 147),
            Element::Rh => color(255, 20, 147),
            Element::Pd => color(255, 20, 147),
            Element::Ag => color(128, 128, 144),
            Element::Cd => color(255, 20, 147),
            Element::In => color(255, 20, 147),
            Element::Sn => color(255, 20, 147),
            Element::Sb => color(255, 20, 147),
            Element::Te => color(255, 20, 147),
            Element::I => color(160, 32, 240),
            Element::Xe => color(255, 20, 147),
            Element::Cs => color(255, 20, 147),
            Element::Ba => color(255, 165, 0),
            Element::La => color(255, 20, 147),
            Element::Ce => color(255, 20, 147),
            Element::Pr => color(255, 20, 147),
            Element::Nd => color(255, 20, 147),
            Element::Pm => color(255, 20, 147),
            Element::Sm => color(255, 20, 147),
            Element::Eu => color(255, 20, 147),
            Element::Gd => color(255, 20, 147),
            Element::Tb => color(255, 20, 147),
            Element::Dy => color(255, 20, 147),
            Element::Ho => color(255, 20, 147),
            Element::Er => color(255, 20, 147),
            Element::Tm => color(255, 20, 147),
            Element::Yb => color(255, 20, 147),
            Element::Lu => color(255, 20, 147),
            Element::Hf => color(255, 20, 147),
            Element::Ta => color(255, 20, 147),
            Element::W => color(255, 20, 147),
            Element::Re => color(255, 20, 147),
            Element::Os => color(255, 20, 147),
            Element::Ir => color(255, 20, 147),
            Element::Pt => color(255, 20, 147),
            Element::Au => color(218, 165, 32),
            Element::Hg => color(255, 20, 147),
            Element::Tl => color(255, 20, 147),
            Element::Pb => color(255, 20, 147),
            Element::Bi => color(255, 20, 147),
            Element::Po => color(255, 20, 147),
            Element::At => color(255, 20, 147),
            Element::Rn => color(255, 255, 255),
            Element::Fr => color(255, 255, 255),
            Element::Ra => color(255, 255, 255),
            Element::Ac => color(255, 255, 255),
            Element::Th => color(255, 20, 147),
            Element::Pa => color(255, 255, 255),
            Element::U => color(255, 20, 147),
            Element::Np => color(255, 255, 255),
            Element::Pu => color(255, 255, 255),
            Element::Am => color(255, 255, 255),
            Element::Cm => color(255, 255, 255),
            Element::Bk => color(255, 255, 255),
            Element::Cf => color(255, 255, 255),
            Element::Es => color(255, 255, 255),
            Element::Fm => color(255, 255, 255),
            Element::Md => color(255, 255, 255),
            Element::No => color(255, 255, 255),
            Element::Lr => color(255, 255, 255),
            Element::Rf => None,
            Element::Db => None,
            Element::Sg => None,
            Element::Bh => None,
            Element::Hs => None,
            Element::Mt => None,
            Element::Ds => None,
            Element::Rg => None,
            Element::Cn => None,
            Element::Nh => None,
            Element::Fl => None,
            Element::Mc => None,
            Element::Lv => None,
            Element::Ts => None,
            Element::Og => None,
        }
    }
}
