/*
 * Decompiled with CFR 0.152.
 */
package org.probatron.officeotron;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.probatron.officeotron.HtmlValidationReport;
import org.probatron.officeotron.ReportFactory;
import org.probatron.officeotron.Utils;
import org.probatron.officeotron.ValidationReport;
import org.probatron.officeotron.WebSubmission;
import org.probatron.officeotron.sessionstorage.ValidationSession;

public class WebTask
implements Runnable {
    WebSubmission sub;
    private HttpServletResponse resp;

    WebTask(WebSubmission webSubmission, HttpServletResponse httpServletResponse) {
        this.resp = httpServletResponse;
        this.sub = webSubmission;
    }

    @Override
    public void run() {
        ValidationSession validationSession = Utils.autoCreateValidationSession(this.sub, new HttpReportFactory(this.resp));
        if (validationSession == null) {
            try {
                this.resp.sendError(412, "Submitted resource must be a recognisable Office document package");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
        validationSession.prepare();
        validationSession.validate();
        validationSession.getCommentary().endReport();
        validationSession.cleanup();
        try {
            validationSession.getCommentary().streamOut();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static class HttpReportFactory
    implements ReportFactory {
        private HttpServletResponse resp;

        public HttpReportFactory(HttpServletResponse httpServletResponse) {
            this.resp = httpServletResponse;
        }

        @Override
        public ValidationReport create() {
            return new HtmlValidationReport(this.resp);
        }
    }
}

