/*****************************************************************************
 * Copyright (c) 2014-2025 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#pragma once

#include <cstdint>

namespace OpenRCT2::CSChar
{
    constexpr char32_t quote_close = 0x22;

    constexpr char32_t a_ogonek_uc = 0x9F;
    constexpr char32_t up = 0xA0;

    constexpr char32_t c_acute_uc = 0xA2;
    constexpr char32_t e_ogonek_uc = 0xA6;
    constexpr char32_t l_stroke_uc = 0xA7;

    constexpr char32_t down = 0xAA;
    constexpr char32_t tick = 0xAC;
    constexpr char32_t cross = 0xAD;
    constexpr char32_t right = 0xAF;
    constexpr char32_t railway = 0xB1;
    constexpr char32_t quote_open = 0xB4;
    constexpr char32_t euro = 0xB5;
    constexpr char32_t road = 0xB6;
    constexpr char32_t air = 0xB7;
    constexpr char32_t water = 0xB8;
    constexpr char32_t superscript_minus_one = 0xB9;
    constexpr char32_t bullet = 0xBA;
    constexpr char32_t small_up = 0xBC;
    constexpr char32_t small_down = 0xBD;
    constexpr char32_t left = 0xBE;

    constexpr char32_t n_acute_uc = 0xC6;
    constexpr char32_t s_acute_uc = 0xD0;
    constexpr char32_t z_acute_uc = 0xD7;
    constexpr char32_t z_dot_uc = 0xD8;
    constexpr char32_t a_ogonek = 0xDD;
    constexpr char32_t c_acute = 0xDE;
    constexpr char32_t e_ogonek = 0xE6;
    constexpr char32_t n_acute = 0xF0;
    constexpr char32_t o_circumflex = 0xF4;
    constexpr char32_t l_stroke = 0xF7;
    constexpr char32_t s_acute = 0xF8;
    constexpr char32_t z_acute = 0xFE;

    constexpr char32_t z_dot = 0xFD;
} // namespace OpenRCT2::CSChar
