/* SPDX-License-Identifier: GPL-2.0 */
/* Copyright (c) 2024 Intel Corporation */

#ifndef _INTEL_THC_HW_H_
#define _INTEL_THC_HW_H_

#include <linux/bits.h>

/* THC registers offset */
/* Touch Host Controller Control Register */
#define THC_M_PRT_CONTROL_OFFSET		0x1008
/* THC SPI Bus Configuration Register */
#define THC_M_PRT_SPI_CFG_OFFSET		0x1010
/* THC SPI Bus Read Opcode Register */
#define THC_M_PRT_SPI_ICRRD_OPCODE_OFFSET	0x1014
/* THC SPI Bus Read Opcode Register */
#define THC_M_PRT_SPI_DMARD_OPCODE_OFFSET	0x1018
/* THC SPI Bus Write Opcode Register */
#define THC_M_PRT_SPI_WR_OPCODE_OFFSET		0x101C
/* THC Interrupt Enable Register */
#define THC_M_PRT_INT_EN_OFFSET			0x1020
/* THC Interrupt Status Register */
#define THC_M_PRT_INT_STATUS_OFFSET		0x1024
/* THC Error Cause Register */
#define THC_M_PRT_ERR_CAUSE_OFFSET		0x1028
/* THC SW sequencing Control */
#define THC_M_PRT_SW_SEQ_CNTRL_OFFSET		0x1040
/* THC SW sequencing Status */
#define THC_M_PRT_SW_SEQ_STS_OFFSET		0x1044
/* THC SW Sequencing Data DW0 or SPI Address Register */
#define THC_M_PRT_SW_SEQ_DATA0_ADDR_OFFSET	0x1048
/* THC SW sequencing Data DW1 */
#define THC_M_PRT_SW_SEQ_DATA1_OFFSET		0x104C
/* THC SW sequencing Data DW2 */
#define THC_M_PRT_SW_SEQ_DATA2_OFFSET		0x1050
/* THC SW sequencing Data DW3 */
#define THC_M_PRT_SW_SEQ_DATA3_OFFSET		0x1054
/* THC SW sequencing Data DW4 */
#define THC_M_PRT_SW_SEQ_DATA4_OFFSET		0x1058
/* THC SW sequencing Data DW5 */
#define THC_M_PRT_SW_SEQ_DATA5_OFFSET		0x105C
/* THC SW sequencing Data DW6 */
#define THC_M_PRT_SW_SEQ_DATA6_OFFSET		0x1060
/* THC SW sequencing Data DW7 */
#define THC_M_PRT_SW_SEQ_DATA7_OFFSET		0x1064
/* THC SW sequencing Data DW8 */
#define THC_M_PRT_SW_SEQ_DATA8_OFFSET		0x1068
/* THC SW sequencing Data DW9 */
#define THC_M_PRT_SW_SEQ_DATA9_OFFSET		0x106C
/* THC SW sequencing Data DW10 */
#define THC_M_PRT_SW_SEQ_DATA10_OFFSET		0x1070
/* THC SW sequencing Data DW11 */
#define THC_M_PRT_SW_SEQ_DATA11_OFFSET		0x1074
/* THC SW sequencing Data DW12 */
#define THC_M_PRT_SW_SEQ_DATA12_OFFSET		0x1078
/* THC SW sequencing Data DW13 */
#define THC_M_PRT_SW_SEQ_DATA13_OFFSET		0x107C
/* THC SW sequencing Data DW14 */
#define THC_M_PRT_SW_SEQ_DATA14_OFFSET		0x1080
/* THC SW sequencing Data DW15 */
#define THC_M_PRT_SW_SEQ_DATA15_OFFSET		0x1084
/* THC SW sequencing Data DW16 */
#define THC_M_PRT_SW_SEQ_DATA16_OFFSET		0x1088
/* THC Write PRD Base Address Register Low */
#define THC_M_PRT_WPRD_BA_LOW_OFFSET		0x1090
/* THC Write PRD Base Address Register High */
#define THC_M_PRT_WPRD_BA_HI_OFFSET		0x1094
/* THC Write DMA Control */
#define THC_M_PRT_WRITE_DMA_CNTRL_OFFSET	0x1098
/* THC Write Interrupt Status */
#define THC_M_PRT_WRITE_INT_STS_OFFSET		0x109C
/* THC Write DMA Error Register */
#define THC_M_PRT_WRITE_DMA_ERR_OFFSET		0x10A0
/* THC device address for the bulk write */
#define THC_M_PRT_WR_BULK_ADDR_OFFSET		0x10B4
/* THC Device Interrupt Cause Register Address */
#define THC_M_PRT_DEV_INT_CAUSE_ADDR_OFFSET	0x10B8
/* THC Device Interrupt Cause Register Value */
#define THC_M_PRT_DEV_INT_CAUSE_REG_VAL_OFFSET	0x10BC
/* THC TXDMA Frame Count */
#define THC_M_PRT_TX_FRM_CNT_OFFSET		0x10E0
/* THC TXDMA Packet Count */
#define THC_M_PRT_TXDMA_PKT_CNT_OFFSET		0x10E4
/* THC Device Interrupt Count on this port */
#define THC_M_PRT_DEVINT_CNT_OFFSET		0x10E8
/* Touch Device Interrupt Cause register Format Configuration Register 1 */
#define THC_M_PRT_DEVINT_CFG_1_OFFSET		0x10EC
/* Touch Device Interrupt Cause register Format Configuration Register 2 */
#define THC_M_PRT_DEVINT_CFG_2_OFFSET		0x10F0
/* THC Read PRD Base Address Low for the 1st RXDMA */
#define THC_M_PRT_RPRD_BA_LOW_1_OFFSET		0x1100
/* THC Read PRD Base Address High for the 1st RXDMA */
#define THC_M_PRT_RPRD_BA_HI_1_OFFSET		0x1104
/* THC Read PRD Control for the 1st RXDMA */
#define THC_M_PRT_RPRD_CNTRL_1_OFFSET		0x1108
/* THC Read DMA Control for the 1st RXDMA */
#define THC_M_PRT_READ_DMA_CNTRL_1_OFFSET	0x110C
/* THC Read Interrupt Status for the 1st RXDMA */
#define THC_M_PRT_READ_DMA_INT_STS_1_OFFSET	0x1110
/* THC Read DMA Error Register for the 1st RXDMA */
#define THC_M_PRT_READ_DMA_ERR_1_OFFSET		0x1114
/* Touch Sequencer GuC Tail Offset Address Low for the 1st RXDMA */
#define THC_M_PRT_GUC_OFFSET_LOW_1_OFFSET	0x1118
/* Touch Sequencer GuC Tail Offset Address High for the 1st RXDMA */
#define THC_M_PRT_GUC_OFFSET_HI_1_OFFSET	0x111C
/* Touch Host Controller GuC Work Queue Item Size for the 1st RXDMA */
#define THC_M_PRT_GUC_WORKQ_ITEM_SZ_1_OFFSET	0x1120
/* Touch Host Controller GuC Control register for the 1st RXDMA */
#define THC_M_PRT_GUC_WORKQ_SZ_1_OFFSET		0x1124
/* Touch Sequencer Control for the 1st DMA */
#define THC_M_PRT_TSEQ_CNTRL_1_OFFSET		0x1128
/* Touch Sequencer GuC Doorbell Address Low for the 1st RXDMA */
#define THC_M_PRT_GUC_DB_ADDR_LOW_1_OFFSET	0x1130
/* Touch Sequencer GuC Doorbell Address High for the 1st RXDMA */
#define THC_M_PRT_GUC_DB_ADDR_HI_1_OFFSET	0x1134
/* Touch Sequencer GuC Doorbell Data */
#define THC_M_PRT_GUC_DB_DATA_1_OFFSET		0x1138
/* Touch Sequencer GuC Tail Offset Initial Value for the 1st RXDMA */
#define THC_M_PRT_GUC_OFFSET_INITVAL_1_OFFSET	0x1140
/* THC Device Address for the bulk/touch data read for the 1st RXDMA */
#define THC_M_PRT_RD_BULK_ADDR_1_OFFSET		0x1170
/* THC Gfx/SW Doorbell Count from the 1st Stream RXDMA on this port */
#define THC_M_PRT_DB_CNT_1_OFFSET		0x11A0
/* THC Frame Count from the 1st Stream RXDMA on this port */
#define THC_M_PRT_FRM_CNT_1_OFFSET		0x11A4
/* THC Micro Frame Count from the 1st Stream RXDMA on this port */
#define THC_M_PRT_UFRM_CNT_1_OFFSET		0x11A8
/* THC Packet Count from the 1st Stream RXDMA on this port */
#define THC_M_PRT_RXDMA_PKT_CNT_1_OFFSET	0x11AC
/*
 * THC Software Interrupt Count from the 1st Stream RXDMA
 * on this port
 */
#define THC_M_PRT_SWINT_CNT_1_OFFSET		0x11B0
/* Touch Sequencer Frame Drop Counter for the 1st RXDMA */
#define THC_M_PRT_FRAME_DROP_CNT_1_OFFSET	0x11B4
/* THC Coaescing 1 */
#define THC_M_PRT_COALESCE_1_OFFSET		0x11B8
/* THC Read PRD Base Address Low for the 2nd RXDMA */
#define THC_M_PRT_RPRD_BA_LOW_2_OFFSET		0x1200
/* THC Read PRD Base Address High for the 2nd RXDMA */
#define THC_M_PRT_RPRD_BA_HI_2_OFFSET		0x1204
/* THC Read PRD Control for the 2nd RXDMA */
#define THC_M_PRT_RPRD_CNTRL_2_OFFSET		0x1208
/* THC Read DMA Control for the 2nd RXDMA */
#define THC_M_PRT_READ_DMA_CNTRL_2_OFFSET	0x120C
/* THC Read Interrupt Status for the 2nd RXDMA */
#define THC_M_PRT_READ_DMA_INT_STS_2_OFFSET	0x1210
/* THC Read DMA Error Register for the 2nd RXDMA */
#define THC_M_PRT_READ_DMA_ERR_2_OFFSET		0x1214
/* Touch Sequencer GuC Tail Offset Address Low for the 2nd RXDMA */
#define THC_M_PRT_GUC_OFFSET_LOW_2_OFFSET	0x1218
/* Touch Sequencer GuC Tail Offset Address High for the 2nd RXDMA */
#define THC_M_PRT_GUC_OFFSET_HI_2_OFFSET	0x121C
/* Touch Host Controller GuC Work Queue Item Size for the 2nd RXDMA */
#define THC_M_PRT_GUC_WORKQ_ITEM_SZ_2_OFFSET	0x1220
/* Touch Host Controller GuC Control register for the 2nd RXDMA */
#define THC_M_PRT_GUC_WORKQ_SZ_2_OFFSET		0x1224
/* Touch Sequencer Control for the 2nd DMA */
#define THC_M_PRT_TSEQ_CNTRL_2_OFFSET		0x1228
/* Touch Sequencer GuC Doorbell Address Low for the 2nd RXDMA */
#define THC_M_PRT_GUC_DB_ADDR_LOW_2_OFFSET	0x1230
/* Touch Sequencer GuC Doorbell Address High for the 2nd RXDMA */
#define THC_M_PRT_GUC_DB_ADDR_HI_2_OFFSET	0x1234
/* Touch Sequencer GuC Doorbell Data for PRD2 */
#define THC_M_PRT_GUC_DB_DATA_2_OFFSET		0x1238
/* Touch Sequencer GuC Tail Offset Initial Value for the 2nd RXDMA */
#define THC_M_PRT_GUC_OFFSET_INITVAL_2_OFFSET	0x1240
/* THC Device Address for the bulk/touch data read for the 2nd RXDMA */
#define THC_M_PRT_RD_BULK_ADDR_2_OFFSET		0x1270
/* THC Gfx/SW Doorbell Count from the 2nd Stream RXDMA on this port */
#define THC_M_PRT_DB_CNT_2_OFFSET		0x12A0
/* THC Frame Count from the 2nd Stream RXDMA on this port */
#define THC_M_PRT_FRM_CNT_2_OFFSET		0x12A4
/* THC Micro Frame Count from the 2nd Stream RXDMA on this port */
#define THC_M_PRT_UFRM_CNT_2_OFFSET		0x12A8
/* THC Packet Count from the 2nd Stream RXDMA on this port */
#define THC_M_PRT_RXDMA_PKT_CNT_2_OFFSET	0x12AC
/*
 * THC Software Interrupt Count from the 2nd Stream RXDMA
 * on this port
 */
#define THC_M_PRT_SWINT_CNT_2_OFFSET		0x12B0
/* Touch Sequencer Frame Drop Counter for the 2nd RXDMA */
#define THC_M_PRT_FRAME_DROP_CNT_2_OFFSET	0x12B4
/* THC Coaescing 2 */
#define THC_M_PRT_COALESCE_2_OFFSET		0x12B8
/* THC SPARE REGISTER */
#define THC_M_PRT_SPARE_REG_OFFSET		0x12BC
/* THC Read PRD Base Address Low for the SW RXDMA */
#define THC_M_PRT_RPRD_BA_LOW_SW_OFFSET		0x12C0
/* THC Read PRD Base Address High for the SW RXDMA */
#define THC_M_PRT_RPRD_BA_HI_SW_OFFSET		0x12C4
/* THC Read PRD Control for the SW RXDMA */
#define THC_M_PRT_RPRD_CNTRL_SW_OFFSET		0x12C8
/* THC Read DMA Control for the SW RXDMA */
#define THC_M_PRT_READ_DMA_CNTRL_SW_OFFSET	0x12CC
/* THC Read Interrupt Status for the SW RXDMA */
#define THC_M_PRT_READ_DMA_INT_STS_SW_OFFSET	0x12D0
/* Touch Sequencer Control for the SW DMA */
#define THC_M_PRT_TSEQ_CNTRL_SW_OFFSET		0x12D4
/* Address for the bulk read for SW DMA engine */
#define THC_M_PRT_RD_BULK_ADDR_SW_OFFSET	0x12D8
/* THC Frame Count from the SW RXDMA on this port */
#define THC_M_PRT_FRM_CNT_SW_OFFSET		0x12DC
/* THC Packet Count from the SW RXDMA on this port */
#define THC_M_PRT_RXDMA_PKT_CNT_SW_OFFSET	0x12E0
/* SW DMA PRD Table Length */
#define THC_M_PRT_SW_DMA_PRD_TABLE_LEN_OFFSET	0x12E4
/* THC timing based Frame/Interrupt caolescing control register for 1st RXDMA */
#define THC_M_PRT_COALESCE_CNTRL_1_OFFSET	0x12E8
/* THC timing based Frame/Interrupt caolescing control register for 2nd RXDMA */
#define THC_M_PRT_COALESCE_CNTRL_2_OFFSET	0x12EC
/* Touch Sequencer PRD Table Empty Counter for the 1st RXDMA */
#define THC_M_PRT_PRD_EMPTY_CNT_1_OFFSET	0x12F0
/* Touch Sequencer PRD Table Empty Counter for the 2nd RXDM */
#define THC_M_PRT_PRD_EMPTY_CNT_2_OFFSET	0x12F4
/* THC coalescing status to reflect the current coalescing FSM state for 1st RXDMA */
#define THC_M_PRT_COALESCE_STS_1_OFFSET		0x12F8
/* THC coalescing status to reflect the current coalescing FSM state for 2nd RXDMA */
#define THC_M_PRT_COALESCE_STS_2_OFFSET		0x12FC
/* THC Register for the SPI Port Duty Cycle Configuration */
#define THC_M_PRT_SPI_DUTYC_CFG_OFFSET		0x1300
/* THC Register for SW I2C Wtite Sequecning control */
#define THC_M_PRT_SW_SEQ_I2C_WR_CNTRL_OFFSET	0x1304
/* THC current Timestamp Register for RXDMA1 */
#define THC_M_PRT_TIMESTAMP_1_OFFSET		0x1308
/* THC current Timestamp Register for RXDMA2 */
#define THC_M_PRT_TIMESTAMP_2_OFFSET		0x130C
/* Current SYNC Event Timestamp Register */
#define THC_M_PRT_SYNC_TIMESTAMP_OFFSET		0x1310
/* THC Display Sync Register */
#define THC_M_PRT_DISP_SYNC_OFFSET		0x1314
/* THC Display Sync Register */
#define THC_M_PRT_DISP_SYNC_2_OFFSET		0x1318
/* THC Register for SW I2C Wtite Sequecning control */
#define THC_M_PRT_I2C_CFG_OFFSET		0x131C

/* THC register bits definition */
#define TXN_ERR_INT_STS_BIT			BIT(28)
#define TXN_FATAL_INT_STS_BIT			BIT(30)

#define NONDMA_INT_STS_BIT			BIT(4)
#define EOF_INT_STS_BIT				BIT(5)

#define THC_CFG_DID_VID_VID		        GENMASK(15, 0)
#define THC_CFG_DID_VID_DID		        GENMASK(31, 16)

#define THC_CFG_STS_CMD_IOSE			BIT(0)
#define THC_CFG_STS_CMD_MSE			BIT(1)
#define THC_CFG_STS_CMD_BME			BIT(2)
#define THC_CFG_STS_CMD_SPCYC			BIT(3)
#define THC_CFG_STS_CMD_MWRIEN			BIT(4)
#define THC_CFG_STS_CMD_VGAPS			BIT(5)
#define THC_CFG_STS_CMD_PERRR			BIT(6)
#define THC_CFG_STS_CMD_SERREN			BIT(8)
#define THC_CFG_STS_CMD_FBTBEN			BIT(9)
#define THC_CFG_STS_CMD_INTD			BIT(10)
#define THC_CFG_STS_CMD_INTS			BIT(19)
#define THC_CFG_STS_CMD_CAPL			BIT(20)
#define THC_CFG_STS_CMD_MCAP			BIT(21)
#define THC_CFG_STS_CMD_FBTBC			BIT(23)
#define THC_CFG_STS_CMD_MDPE			BIT(24)
#define THC_CFG_STS_CMD_DEVT			GENMASK(26, 25)
#define THC_CFG_STS_CMD_STA			BIT(27)
#define THC_CFG_STS_CMD_RTA			BIT(28)
#define THC_CFG_STS_CMD_RMA			BIT(29)
#define THC_CFG_STS_CMD_SSE			BIT(30)
#define THC_CFG_STS_CMD_DPE			BIT(31)

#define THC_CFG_CC_RID_RID			GENMASK(7, 0)
#define THC_CFG_CC_RID_PI			GENMASK(15, 8)
#define THC_CFG_CC_RID_SCC			GENMASK(23, 16)
#define THC_CFG_CC_RID_BCC			GENMASK(31, 24)

#define THC_CFG_BIST_HTYPE_LT_CLS_CLSZ		GENMASK(7, 0)
#define THC_CFG_BIST_HTYPE_LT_CLS_LT		GENMASK(15, 8)
#define THC_CFG_BIST_HTYPE_LT_CLS_HTYPE		GENMASK(22, 16)
#define THC_CFG_BIST_HTYPE_LT_CLS_MFD		BIT(23)

#define THC_CFG_BAR0_LOW_MEMSPACE		BIT(0)
#define THC_CFG_BAR0_LOW_TYP			GENMASK(2, 1)
#define THC_CFG_BAR0_LOW_PREFETCH		BIT(3)
#define THC_CFG_BAR0_LOW_MEMSIZE		GENMASK(14, 4)
#define THC_CFG_BAR0_LOW_MEMBAR			GENMASK(31, 15)
#define THC_CFG_BAR0_HI_MEMBAR			GENMASK(31, 0)

#define THC_CFG_SID_SVID_SSVID			GENMASK(15, 0)
#define THC_CFG_SID_SVID_SSID			GENMASK(31, 16)

#define THC_CFG_CAPP_CP				GENMASK(7, 0)

#define THC_CFG_INT_ILINE			GENMASK(7, 0)
#define THC_CFG_INT_IPIN			GENMASK(15, 8)

#define THC_CFG_UR_STS_CTL_URRE			BIT(0)
#define THC_CFG_UR_STS_CTL_URD			BIT(1)
#define THC_CFG_UR_STS_CTL_FD			BIT(2)

#define THC_CFG_MSIMC_MSINP_MSICID_CAPID	GENMASK(7, 0)
#define THC_CFG_MSIMC_MSINP_MSICID_NXTP	        GENMASK(15, 8)
#define THC_CFG_MSIMC_MSINP_MSICID_MSIE		BIT(16)
#define THC_CFG_MSIMC_MSINP_MSICID_MMC	        GENMASK(19, 17)
#define THC_CFG_MSIMC_MSINP_MSICID_MMEN	        GENMASK(22, 20)
#define THC_CFG_MSIMC_MSINP_MSICID_XAC		BIT(23)
#define THC_CFG_MSIMC_MSINP_MSICID_PVMC		BIT(24)
#define THC_CFG_MSIMA_MADDR		        GENMASK(31, 2)
#define THC_CFG_MSIMUA_MAUDDR		        GENMASK(31, 0)
#define THC_CFG_MSIMD_MDAT			GENMASK(15, 0)

#define THC_CFG_PMCAP_PMNP_PMCID_CAPP	        GENMASK(7, 0)
#define THC_CFG_PMCAP_PMNP_PMCID_NXTP	        GENMASK(15, 8)
#define THC_CFG_PMCAP_PMNP_PMCID_VER	        GENMASK(18, 16)
#define THC_CFG_PMCAP_PMNP_PMCID_PMECLK		BIT(19)
#define THC_CFG_PMCAP_PMNP_PMCID_DSI		BIT(21)
#define THC_CFG_PMCAP_PMNP_PMCID_AUXC	        GENMASK(24, 22)
#define THC_CFG_PMCAP_PMNP_PMCID_D1S		BIT(25)
#define THC_CFG_PMCAP_PMNP_PMCID_D2S		BIT(26)
#define THC_CFG_PMCAP_PMNP_PMCID_PMES	        GENMASK(31, 27)

#define THC_CFG_PMD_PMCSRBSE_PMCSR_PWRST	GENMASK(1, 0)
#define THC_CFG_PMD_PMCSRBSE_PMCSR_NSR		BIT(3)
#define THC_CFG_PMD_PMCSRBSE_PMCSR_PMEEN	BIT(8)
#define THC_CFG_PMD_PMCSRBSE_PMCSR_DSEL	        GENMASK(12, 9)
#define THC_CFG_PMD_PMCSRBSE_PMCSR_DS	        GENMASK(14, 13)
#define THC_CFG_PMD_PMCSRBSE_PMCSR_PMESTS	BIT(15)

#define THC_CFG_DEVIDLE_CAPPID		        GENMASK(7, 0)
#define THC_CFG_DEVIDLE_NCAPPP		        GENMASK(15, 8)
#define THC_CFG_DEVIDLE_LENGTH		        GENMASK(23, 16)
#define THC_CFG_DEVIDLE_REV		        GENMASK(27, 24)
#define THC_CFG_DEVIDLE_VID		        GENMASK(31, 28)

#define THC_CFG_VSHDR_VSECID		        GENMASK(15, 0)
#define THC_CFG_VSHDR_VSECR		        GENMASK(19, 16)
#define THC_CFG_VSHDR_VSECL		        GENMASK(31, 20)

#define THC_CFG_SWLTRPTR_VALID			BIT(0)
#define THC_CFG_SWLTRPTR_BARNUM		        GENMASK(3, 1)
#define THC_CFG_SWLTRPTR_SWLTRLOC		GENMASK(31, 4)

#define THC_CFG_DEVIDLEPTR_VALID		BIT(0)
#define THC_CFG_DEVIDLEPTR_BARNUM		GENMASK(3, 1)
#define THC_CFG_DEVIDLEPTR_DEVIDLELOC	        GENMASK(31, 4)
#define THC_CFG_DEVIDLEPOL_POLV		        GENMASK(9, 0)
#define THC_CFG_DEVIDLEPOL_POLS		        GENMASK(12, 10)

#define THC_CFG_PCE_SPE				BIT(0)
#define THC_CFG_PCE_I3E				BIT(1)
#define THC_CFG_PCE_D3HE			BIT(2)
#define THC_CFG_PCE_SE				BIT(3)
#define THC_CFG_PCE_HAE				BIT(5)

#define THC_CFG_MANID_PROC			GENMASK(7, 0)
#define THC_CFG_MANID_MID			GENMASK(15, 8)
#define THC_CFG_MANID_MSID			GENMASK(23, 16)
#define THC_CFG_MANID_DOT			GENMASK(27, 24)

#define THC_M_CMN_DEVIDLECTRL_CIP		BIT(0)
#define THC_M_CMN_DEVIDLECTRL_IR		BIT(1)
#define THC_M_CMN_DEVIDLECTRL_DEVIDLE		BIT(2)
#define THC_M_CMN_DEVIDLECTRL_RR		BIT(3)
#define THC_M_CMN_DEVIDLECTRL_IRC		BIT(4)

#define THC_M_CMN_LTR_CTRL_OFFSET		0x14
#define THC_M_CMN_LTR_CTRL_ACTIVE_LTR_REQ	BIT(0)
#define THC_M_CMN_LTR_CTRL_ACTIVE_LTR_EN	BIT(1)
#define THC_M_CMN_LTR_CTRL_LP_LTR_REQ		BIT(2)
#define THC_M_CMN_LTR_CTRL_LP_LTR_EN		BIT(3)
#define THC_M_CMN_LTR_CTRL_LP_LTR_SCALE	        GENMASK(6, 4)
#define THC_M_CMN_LTR_CTRL_LP_LTR_VAL	        GENMASK(16, 7)
#define THC_M_CMN_LTR_CTRL_ACT_LTR_SCALE	GENMASK(19, 17)
#define THC_M_CMN_LTR_CTRL_ACT_LTR_VAL	        GENMASK(29, 20)
#define THC_M_CMN_LTR_CTRL_LAST_LTR_SENT	GENMASK(31, 30)

#define THC_M_PRT_CONTROL_TSFTRST		BIT(0)
#define THC_M_PRT_CONTROL_THC_DEVINT_QUIESCE_EN	BIT(1)
#define THC_M_PRT_CONTROL_THC_DEVINT_QUIESCE_HW_STS	BIT(2)
#define THC_M_PRT_CONTROL_DEVRST		BIT(3)
#define THC_M_PRT_CONTROL_THC_DRV_LOCK_EN	BIT(13)
#define THC_M_PRT_CONTROL_THC_INSTANCE_INDEX	GENMASK(18, 16)
#define THC_M_PRT_CONTROL_PORT_INDEX	        GENMASK(22, 20)
#define THC_M_PRT_CONTROL_THC_ARB_POLICY	GENMASK(25, 24)
#define THC_M_PRT_CONTROL_THC_BIOS_LOCK_EN	BIT(27)
#define THC_M_PRT_CONTROL_PORT_SUPPORTED	BIT(28)
#define THC_M_PRT_CONTROL_SPI_IO_RDY		BIT(29)
#define THC_M_PRT_CONTROL_PORT_TYPE	        GENMASK(31, 30)

#define THC_M_PRT_SPI_CFG_SPI_TRDC		GENMASK(1, 0)
#define THC_M_PRT_SPI_CFG_SPI_TRMODE	        GENMASK(3, 2)
#define THC_M_PRT_SPI_CFG_SPI_TCRF		GENMASK(6, 4)
#define THC_M_PRT_SPI_CFG_SPI_RD_MPS	        GENMASK(15, 7)
#define THC_M_PRT_SPI_CFG_SPI_TWMODE	        GENMASK(19, 18)
#define THC_M_PRT_SPI_CFG_SPI_TCWF		GENMASK(22, 20)
#define THC_M_PRT_SPI_CFG_SPI_LOW_FREQ_EN	BIT(23)
#define THC_M_PRT_SPI_CFG_SPI_WR_MPS	        GENMASK(31, 24)

#define THC_M_PRT_SPI_ICRRD_OPCODE_SPI_SIO	GENMASK(31, 24)
#define THC_M_PRT_SPI_ICRRD_OPCODE_SPI_DIO	GENMASK(23, 16)
#define THC_M_PRT_SPI_ICRRD_OPCODE_SPI_QIO	GENMASK(15, 8)

#define THC_M_PRT_SPI_ICRRD_OPCODE_I2C_MAX_SIZE		GENMASK(15, 0)
#define THC_M_PRT_SPI_ICRRD_OPCODE_I2C_INTERVAL		GENMASK(23, 16)
#define THC_M_PRT_SPI_ICRRD_OPCODE_I2C_INTERVAL_EN	BIT(30)
#define THC_M_PRT_SPI_ICRRD_OPCODE_I2C_MAX_SIZE_EN	BIT(31)

#define THC_M_PRT_INT_EN_SIPE				BIT(0)
#define THC_M_PRT_INT_EN_SBO				BIT(1)
#define THC_M_PRT_INT_EN_SIDR				BIT(2)
#define THC_M_PRT_INT_EN_SOFB				BIT(3)
#define THC_M_PRT_INT_EN_INVLD_DEV_ENTRY_INT_EN		BIT(9)
#define THC_M_PRT_INT_EN_FRAME_BABBLE_ERR_INT_EN	BIT(10)
#define THC_M_PRT_INT_EN_BUF_OVRRUN_ERR_INT_EN		BIT(12)
#define THC_M_PRT_INT_EN_PRD_ENTRY_ERR_INT_EN		BIT(13)
#define THC_M_PRT_INT_EN_DISP_SYNC_EVT_INT_EN		BIT(14)
#define THC_M_PRT_INT_EN_DEV_RAW_INT_EN			BIT(15)
#define THC_M_PRT_INT_EN_FATAL_ERR_INT_EN		BIT(16)
#define THC_M_PRT_INT_EN_THC_I2C_IC_RX_UNDER_INT_EN	BIT(17)
#define THC_M_PRT_INT_EN_THC_I2C_IC_RX_OVER_INT_EN	BIT(18)
#define THC_M_PRT_INT_EN_THC_I2C_IC_RX_FULL_INT_EN	BIT(19)
#define THC_M_PRT_INT_EN_THC_I2C_IC_TX_OVER_INT_EN	BIT(20)
#define THC_M_PRT_INT_EN_THC_I2C_IC_TX_EMPTY_INT_EN	BIT(21)
#define THC_M_PRT_INT_EN_THC_I2C_IC_TX_ABRT_INT_EN	BIT(22)
#define THC_M_PRT_INT_EN_THC_I2C_IC_SCL_STUCK_AT_LOW_DET_INT_EN	BIT(24)
#define THC_M_PRT_INT_EN_THC_I2C_IC_STOP_DET_INT_EN	BIT(25)
#define THC_M_PRT_INT_EN_THC_I2C_IC_START_DET_INT_EN	BIT(26)
#define THC_M_PRT_INT_EN_THC_I2C_IC_MST_ON_HOLD_INT_EN	BIT(27)
#define THC_M_PRT_INT_EN_TXN_ERR_INT_EN			BIT(29)
#define THC_M_PRT_INT_EN_GBL_INT_EN			BIT(31)

#define THC_M_PRT_INT_STATUS_DISP_SYNC_EVT_INT_STS		BIT(14)
#define THC_M_PRT_INT_STATUS_DEV_RAW_INT_STS			BIT(15)
#define THC_M_PRT_INT_STATUS_THC_I2C_IC_RX_UNDER_INT_STS	BIT(17)
#define THC_M_PRT_INT_STATUS_THC_I2C_IC_RX_OVER_INT_STS		BIT(18)
#define THC_M_PRT_INT_STATUS_THC_I2C_IC_RX_FULL_INT_STS		BIT(19)
#define THC_M_PRT_INT_STATUS_THC_I2C_IC_TX_OVER_INT_STS		BIT(20)
#define THC_M_PRT_INT_STATUS_THC_I2C_IC_TX_EMPTY_INT_STS	BIT(21)
#define THC_M_PRT_INT_STATUS_THC_I2C_IC_TX_ABRT_INT_STS		BIT(22)
#define THC_M_PRT_INT_STATUS_THC_I2C_IC_ACTIVITY_INT_STS	BIT(23)
#define THC_M_PRT_INT_STATUS_THC_I2C_IC_SCL_STUCK_AT_LOW_INT_STS	BIT(24)
#define THC_M_PRT_INT_STATUS_THC_I2C_IC_STOP_DET_INT_STS	BIT(25)
#define THC_M_PRT_INT_STATUS_THC_I2C_IC_START_DET_INT_STS	BIT(26)
#define THC_M_PRT_INT_STATUS_THC_I2C_IC_MST_ON_HOLD_INT_STS	BIT(27)
#define THC_M_PRT_INT_STATUS_TXN_ERR_INT_STS			BIT(28)
#define THC_M_PRT_INT_STATUS_FATAL_ERR_INT_STS			BIT(30)

#define THC_M_PRT_ERR_CAUSE_INVLD_DEV_ENTRY	BIT(9)
#define THC_M_PRT_ERR_CAUSE_FRAME_BABBLE_ERR	BIT(10)
#define THC_M_PRT_ERR_CAUSE_BUF_OVRRUN_ERR	BIT(12)
#define THC_M_PRT_ERR_CAUSE_PRD_ENTRY_ERR	BIT(13)
#define THC_M_PRT_ERR_CAUSE_FATAL_ERR_CAUSE	GENMASK(23, 16)

#define THC_M_PRT_SW_SEQ_CNTRL_TSSGO		BIT(0)
#define THC_M_PRT_SW_SEQ_CNTRL_THC_SS_CD_IE	BIT(1)
#define THC_M_PRT_SW_SEQ_CNTRL_THC_SS_CMD	GENMASK(15, 8)
#define THC_M_PRT_SW_SEQ_CNTRL_THC_SS_BC	GENMASK(31, 16)
#define THC_M_PRT_SW_SEQ_STS_TSSDONE		BIT(0)
#define THC_M_PRT_SW_SEQ_STS_THC_SS_ERR		BIT(1)
#define THC_M_PRT_SW_SEQ_STS_THC_SS_CIP		BIT(3)
#define THC_M_PRT_SW_SEQ_DATA0_ADDR_THC_SW_SEQ_DATA0_ADDR	GENMASK(31, 0)
#define THC_M_PRT_SW_SEQ_DATA1_THC_SW_SEQ_DATA1		        GENMASK(31, 0)

#define THC_M_PRT_WPRD_BA_LOW_THC_M_PRT_WPRD_BA_LOW	        GENMASK(31, 12)
#define THC_M_PRT_WPRD_BA_HI_THC_M_PRT_WPRD_BA_HI		GENMASK(31, 0)

#define THC_M_PRT_WRITE_DMA_CNTRL_THC_WRDMA_START		BIT(0)
#define THC_M_PRT_WRITE_DMA_CNTRL_THC_WRDMA_IE_IOC_ERROR	BIT(1)
#define THC_M_PRT_WRITE_DMA_CNTRL_THC_WRDMA_IE_IOC		BIT(2)
#define THC_M_PRT_WRITE_DMA_CNTRL_THC_WRDMA_IE_IOC_DMACPL	BIT(3)
#define THC_M_PRT_WRITE_DMA_CNTRL_THC_WRDMA_UHS			BIT(23)
#define THC_M_PRT_WRITE_DMA_CNTRL_THC_WRDMA_PTEC		GENMASK(31, 24)

#define THC_M_PRT_WRITE_INT_STS_THC_WRDMA_CMPL_STATUS		BIT(0)
#define THC_M_PRT_WRITE_INT_STS_THC_WRDMA_ERROR_STS		BIT(1)
#define THC_M_PRT_WRITE_INT_STS_THC_WRDMA_IOC_STS		BIT(2)
#define THC_M_PRT_WRITE_INT_STS_THC_WRDMA_ACTIVE		BIT(3)

#define THC_M_PRT_WR_BULK_ADDR_THC_M_PRT_WR_BULK_ADDR	        GENMASK(31, 0)

#define THC_M_PRT_DEV_INT_CAUSE_ADDR_THC_M_PRT_DEV_INT_CAUSE_ADDR	GENMASK(31, 0)
#define THC_M_PRT_DEV_INT_CAUSE_REG_VAL_INTERRUPT_TYPE	        GENMASK(3, 0)
#define THC_M_PRT_DEV_INT_CAUSE_REG_VAL_MICRO_FRAME_SIZE	GENMASK(23, 4)
#define THC_M_PRT_DEV_INT_CAUSE_REG_VAL_BEGINNING_OF_FRAME	BIT(29)
#define THC_M_PRT_DEV_INT_CAUSE_REG_VAL_END_OF_FRAME		BIT(30)
#define THC_M_PRT_DEV_INT_CAUSE_REG_VAL_FRAME_TYPE		BIT(31)

#define THC_M_PRT_TX_FRM_CNT_THC_M_PRT_TX_FRM_CNT		GENMASK(30, 0)
#define THC_M_PRT_TX_FRM_CNT_THC_M_PRT_TX_FRM_CNT_RST		BIT(31)

#define THC_M_PRT_TXDMA_PKT_CNT_THC_M_PRT_TXDMA_PKT_CNT	        GENMASK(30, 0)
#define THC_M_PRT_TXDMA_PKT_CNT_THC_M_PRT_TXDMA_PKT_CNT_RST	BIT(31)

#define THC_M_PRT_DEVINT_CNT_THC_M_PRT_DEVINT_CNT		GENMASK(30, 0)
#define THC_M_PRT_DEVINT_CNT_THC_M_PRT_DEVINT_CNT_RST		BIT(31)

#define THC_M_PRT_DEVINT_CFG_1_THC_M_PRT_INTTYP_OFFSET	        GENMASK(4, 0)
#define THC_M_PRT_DEVINT_CFG_1_THC_M_PRT_INTTYP_LEN	        GENMASK(9, 5)
#define THC_M_PRT_DEVINT_CFG_1_THC_M_PRT_EOF_OFFSET	        GENMASK(14, 10)
#define THC_M_PRT_DEVINT_CFG_1_THC_M_PRT_SEND_ICR_US_EN		BIT(15)
#define THC_M_PRT_DEVINT_CFG_1_THC_M_PRT_INTTYP_DATA_VAL	GENMASK(31, 16)

#define THC_M_PRT_DEVINT_CFG_2_THC_M_PRT_UFSIZE_OFFSET	        GENMASK(4, 0)
#define THC_M_PRT_DEVINT_CFG_2_THC_M_PRT_UFSIZE_LEN	        GENMASK(9, 5)
#define THC_M_PRT_DEVINT_CFG_2_THC_M_PRT_UFSIZE_UNIT	        GENMASK(15, 12)
#define THC_M_PRT_DEVINT_CFG_2_THC_M_PRT_FTYPE_IGNORE		BIT(16)
#define THC_M_PRT_DEVINT_CFG_2_THC_M_PRT_FTYPE_VAL		BIT(17)
#define THC_M_PRT_DEVINT_CFG_2_THC_M_PRT_RXDMA_ADDRINC_DIS	BIT(24)
#define THC_M_PRT_DEVINT_CFG_2_THC_M_PRT_TXDMA_ADDRINC_DIS	BIT(25)
#define THC_M_PRT_DEVINT_CFG_2_THC_M_PRT_RXDMA_PKT_STRM_EN	BIT(26)
#define THC_M_PRT_DEVINT_CFG_2_THC_M_PRT_TXDMA_PKT_STRM_EN	BIT(27)
#define THC_M_PRT_DEVINT_CFG_2_THC_M_PRT_DEVINT_POL		BIT(28)

#define THC_M_PRT_RPRD_BA_LOW_1_THC_M_PRT_RPRD_BA_LOW	        GENMASK(31, 12)
#define THC_M_PRT_RPRD_BA_HI_1_THC_M_PRT_RPRD_BA_HI	        GENMASK(31, 0)

#define THC_M_PRT_RPRD_CNTRL_PCD		GENMASK(6, 0)
#define THC_M_PRT_RPRD_CNTRL_PTEC		GENMASK(15, 8)
#define THC_M_PRT_RPRD_CNTRL_PREFETCH_WM	GENMASK(19, 16)

#define THC_M_PRT_READ_DMA_CNTRL_START		BIT(0)
#define THC_M_PRT_READ_DMA_CNTRL_IE_ERROR	BIT(1)
#define THC_M_PRT_READ_DMA_CNTRL_IE_IOC		BIT(2)
#define THC_M_PRT_READ_DMA_CNTRL_IE_STALL	BIT(3)
#define THC_M_PRT_READ_DMA_CNTRL_IE_NDDI	BIT(4)
#define THC_M_PRT_READ_DMA_CNTRL_IE_EOF		BIT(5)
#define THC_M_PRT_READ_DMA_CNTRL_IE_DMACPL	BIT(7)
#define THC_M_PRT_READ_DMA_CNTRL_TPCRP	        GENMASK(15, 8)
#define THC_M_PRT_READ_DMA_CNTRL_TPCWP	        GENMASK(23, 16)
#define THC_M_PRT_READ_DMA_CNTRL_INT_SW_DMA_EN	BIT(28)
#define THC_M_PRT_READ_DMA_CNTRL_SOO		BIT(29)
#define THC_M_PRT_READ_DMA_CNTRL_UHS		BIT(30)
#define THC_M_PRT_READ_DMA_CNTRL_TPCPR		BIT(31)

#define THC_M_PRT_READ_DMA_INT_STS_DMACPL_STS	BIT(0)
#define THC_M_PRT_READ_DMA_INT_STS_ERROR_STS	BIT(1)
#define THC_M_PRT_READ_DMA_INT_STS_IOC_STS	BIT(2)
#define THC_M_PRT_READ_DMA_INT_STS_STALL_STS	BIT(3)
#define THC_M_PRT_READ_DMA_INT_STS_NONDMA_INT_STS	BIT(4)
#define THC_M_PRT_READ_DMA_INT_STS_EOF_INT_STS	BIT(5)
#define THC_M_PRT_READ_DMA_INT_STS_ACTIVE	BIT(8)

#define THC_M_PRT_READ_DMA_ERR_1_DLERR		BIT(0)

#define THC_M_PRT_GUC_OFFSET_LOW_1_THC_M_PRT_GUC_OFFSET_LOW	GENMASK(31, 3)
#define THC_M_PRT_GUC_OFFSET_HI_1_THC_M_PRT_GUC_OFFSET_HI	GENMASK(31, 0)
#define THC_M_PRT_GUC_WORKQ_ITEM_SZ_1_WORKQ_ITEM_SZ	        GENMASK(23, 0)
#define THC_M_PRT_GUC_WORKQ_SZ_1_WORKQ_SZ       GENMASK(23, 0)
#define THC_M_PRT_GUC_WORKQ_SZ_1_FCD	        GENMASK(27, 24)
#define THC_M_PRT_GUC_WORKQ_SZ_1_GIC	        GENMASK(31, 28)

#define THC_M_PRT_TSEQ_CNTRL_1_RGD		BIT(2)
#define THC_M_PRT_TSEQ_CNTRL_1_EGP		BIT(3)
#define THC_M_PRT_TSEQ_CNTRL_1_RTO		BIT(4)
#define THC_M_PRT_TSEQ_CNTRL_1_EWOG		BIT(5)
#define THC_M_PRT_TSEQ_CNTRL_1_RWOGC		BIT(6)
#define THC_M_PRT_TSEQ_CNTRL_1_RX_DATA_FIFO_WR_WM		GENMASK(25, 16)
#define THC_M_PRT_TSEQ_CNTRL_1_RESET_PREP_CHICKEN		BIT(30)
#define THC_M_PRT_TSEQ_CNTRL_1_INT_EDG_DET_EN			BIT(31)

#define THC_M_PRT_GUC_DB_ADDR_LOW_1_GUC_DB_ADDR_LOW	        GENMASK(31, 2)
#define THC_M_PRT_GUC_DB_ADDR_HI_1_GUC_DB_ADDR_HI		GENMASK(31, 0)
#define THC_M_PRT_GUC_DB_DATA_1_GUC_DB_DATA		        GENMASK(31, 0)
#define THC_M_PRT_GUC_OFFSET_INITVAL_1_THC_M_PRT_GUC_OFFSET_INITVAL	GENMASK(31, 0)

#define THC_M_PRT_RD_BULK_ADDR_1_THC_M_PRT_RD_BULK_ADDR	        GENMASK(31, 0)

#define THC_M_PRT_DB_CNT_1_THC_M_PRT_DB_CNT		        GENMASK(30, 0)
#define THC_M_PRT_DB_CNT_1_THC_M_PRT_DB_CNT_RST			BIT(31)

#define THC_M_PRT_FRM_CNT_1_THC_M_PRT_FRM_CNT		        GENMASK(30, 0)
#define THC_M_PRT_FRM_CNT_1_THC_M_PRT_FRM_CNT_RST		BIT(31)

#define THC_M_PRT_UFRM_CNT_1_THC_M_PRT_UFRM_CNT		        GENMASK(30, 0)
#define THC_M_PRT_UFRM_CNT_1_THC_M_PRT_UFRM_CNT_RST		BIT(31)

#define THC_M_PRT_RXDMA_PKT_CNT_1_THC_M_PRT_RXDMA_PKT_CNT	GENMASK(30, 0)
#define THC_M_PRT_RXDMA_PKT_CNT_1_THC_M_PRT_RXDMA_PKT_CNT_RST	BIT(31)

#define THC_M_PRT_SWINT_CNT_1_THC_M_PRT_SWINT_CNT		GENMASK(30, 0)
#define THC_M_PRT_SWINT_CNT_1_THC_M_PRT_SWINT_CNT_RST		BIT(31)

#define THC_M_PRT_FRAME_DROP_CNT_1_NOFD			        GENMASK(30, 0)
#define THC_M_PRT_FRAME_DROP_CNT_1_RFDC				BIT(31)

#define THC_M_PRT_COALESCE_1_COALESCE_TIMEOUT		        GENMASK(6, 0)

#define THC_M_PRT_RPRD_BA_LOW_2_THC_M_PRT_RPRD_BA_LOW	        GENMASK(31, 12)
#define THC_M_PRT_RPRD_BA_HI_2_THC_M_PRT_RPRD_BA_HI	        GENMASK(31, 0)

#define THC_M_PRT_READ_DMA_ERR_2_DLERR				BIT(0)

#define THC_M_PRT_GUC_OFFSET_LOW_2_THC_M_PRT_GUC_OFFSET_LOW     GENMASK(31, 3)
#define THC_M_PRT_GUC_OFFSET_HI_2_THC_M_PRT_GUC_OFFSET_HI	GENMASK(31, 0)

#define THC_M_PRT_GUC_WORKQ_ITEM_SZ_2_WORKQ_ITEM_SZ	        GENMASK(23, 0)
#define THC_M_PRT_GUC_WORKQ_SZ_2_WORKQ_SZ			GENMASK(23, 0)
#define THC_M_PRT_GUC_WORKQ_SZ_2_FCD			        GENMASK(27, 24)
#define THC_M_PRT_GUC_WORKQ_SZ_2_GIC			        GENMASK(31, 28)

#define THC_M_PRT_TSEQ_CNTRL_2_RGD				BIT(2)
#define THC_M_PRT_TSEQ_CNTRL_2_EGP				BIT(3)
#define THC_M_PRT_TSEQ_CNTRL_2_RTO				BIT(4)

#define THC_M_PRT_GUC_DB_ADDR_LOW_2_GUC_DB_ADDR_LOW	        GENMASK(31, 2)
#define THC_M_PRT_GUC_DB_ADDR_HI_2_GUC_DB_ADDR_HI		GENMASK(31, 0)

#define THC_M_PRT_GUC_DB_DATA_2_GUC_DB_DATA		        GENMASK(31, 0)

#define THC_M_PRT_GUC_OFFSET_INITVAL_2_THC_M_PRT_GUC_OFFSET_INITVAL	GENMASK(31, 0)

#define THC_M_PRT_RD_BULK_ADDR_2_THC_M_PRT_RD_BULK_ADDR	        GENMASK(31, 0)

#define THC_M_PRT_DB_CNT_2_THC_M_PRT_DB_CNT		        GENMASK(30, 0)
#define THC_M_PRT_DB_CNT_2_THC_M_PRT_DB_CNT_RST			BIT(31)

#define THC_M_PRT_FRM_CNT_2_THC_M_PRT_FRM_CNT		        GENMASK(30, 0)
#define THC_M_PRT_FRM_CNT_2_THC_M_PRT_FRM_CNT_RST		BIT(31)

#define THC_M_PRT_UFRM_CNT_2_THC_M_PRT_UFRM_CNT		        GENMASK(30, 0)
#define THC_M_PRT_UFRM_CNT_2_THC_M_PRT_UFRM_CNT_RST		BIT(31)

#define THC_M_PRT_RXDMA_PKT_CNT_2_THC_M_PRT_RXDMA_PKT_CNT	GENMASK(30, 0)
#define THC_M_PRT_RXDMA_PKT_CNT_2_THC_M_PRT_RXDMA_PKT_CNT_RST	BIT(31)

#define THC_M_PRT_SWINT_CNT_2_THC_M_PRT_SWINT_CNT		GENMASK(30, 0)
#define THC_M_PRT_SWINT_CNT_2_THC_M_PRT_SWINT_CNT_RST		BIT(31)

#define THC_M_PRT_FRAME_DROP_CNT_2_NOFD			        GENMASK(30, 0)
#define THC_M_PRT_FRAME_DROP_CNT_2_RFDC				BIT(31)

#define THC_M_PRT_COALESCE_2_COALESCE_TIMEOUT		        GENMASK(6, 0)

#define THC_M_PRT_SW_SEQ_I2C_WR_CNTRL_THC_I2C_RW_PIO_EN		BIT(23)
#define THC_M_PRT_SW_SEQ_I2C_WR_CNTRL_THC_PIO_I2C_WBC	        GENMASK(31, 26)

#define THC_M_PRT_RPRD_CNTRL_SW_THC_SWDMA_I2C_RX_DLEN_EN	BIT(23)
#define THC_M_PRT_RPRD_CNTRL_SW_THC_SWDMA_I2C_WBC		GENMASK(31, 26)

#define THC_M_PRT_PRD_EMPTY_CNT_1_RPTEC				BIT(31)
#define THC_M_PRT_PRD_EMPTY_CNT_2_RPTEC				BIT(31)

#define THC_M_PRT_SW_DMA_PRD_TABLE_LEN_THC_M_PRT_SW_DMA_PRD_TABLE_LEN	GENMASK(23, 0)

#define THC_M_PRT_SPI_DUTYC_CFG_SPI_CSA_CK_DELAY_VAL		GENMASK(3, 0)
#define THC_M_PRT_SPI_DUTYC_CFG_SPI_CSA_CK_DELAY_EN		BIT(25)

/* CS Assertion delay default value */
#define THC_CSA_CK_DELAY_VAL_DEFAULT		4

/* ARB policy definition */
/* Arbiter switches on packet boundary */
#define THC_ARB_POLICY_PACKET_BOUNDARY		0
/* Arbiter switches on Micro Frame boundary */
#define THC_ARB_POLICY_UFRAME_BOUNDARY		1
/* Arbiter switches on Frame boundary */
#define THC_ARB_POLICY_FRAME_BOUNDARY		2

#define THC_REGMAP_POLLING_INTERVAL_US		10 /* 10us */
#define THC_PIO_DONE_TIMEOUT_US			USEC_PER_SEC /* 1s */

/* Default configures for HIDSPI */
#define THC_BIT_OFFSET_INTERRUPT_TYPE		4
/* input_report_type is 4 bits for HIDSPI */
#define THC_BIT_LENGTH_INTERRUPT_TYPE		4
/* Last fragment indicator is bit 15 for HIDSPI */
#define THC_BIT_OFFSET_LAST_FRAGMENT_FLAG	22
#define THC_BIT_OFFSET_MICROFRAME_SIZE		8
/* input_report_length is 14 bits for HIDSPI */
#define THC_BIT_LENGTH_MICROFRAME_SIZE		14
/* MFS unit in power of 2 */
#define THC_UNIT_MICROFRAME_SIZE		2
#define THC_BITMASK_INTERRUPT_TYPE_DATA		1
#define THC_BITMASK_INVALID_TYPE_DATA		2

/* Interrupt Quiesce default timeout value */
#define THC_QUIESCE_EN_TIMEOUT_US		USEC_PER_SEC /* 1s */

/* LTR definition */
/*
 * THC uses scale to calculate final LTR value.
 * Scale is geometric progression of 2^5 step, starting from 2^0.
 * For example, THC_LTR_SCALE_2(2) means 2^(5 * 2) = 1024, unit is ns.
 */
#define THC_LTR_SCALE_0				0
#define THC_LTR_SCALE_1				1
#define THC_LTR_SCALE_2				2
#define THC_LTR_SCALE_3				3
#define THC_LTR_SCALE_4				4
#define THC_LTR_SCALE_5				5
#define THC_LTR_MODE_ACTIVE			0
#define THC_LTR_MODE_LP				1
#define THC_LTR_MIN_VAL_SCALE_3			BIT(10)
#define THC_LTR_MAX_VAL_SCALE_3			BIT(15)
#define THC_LTR_MIN_VAL_SCALE_4			BIT(15)
#define THC_LTR_MAX_VAL_SCALE_4			BIT(20)
#define THC_LTR_MIN_VAL_SCALE_5			BIT(20)
#define THC_LTR_MAX_VAL_SCALE_5			BIT(25)

/*
 * THC PIO opcode default value
 * @THC_PIO_OP_SPI_TIC_READ: THC opcode for SPI PIO read
 * @THC_PIO_OP_SPI_TIC_WRITE: THC opcode for SPI PIO write
 * @THC_PIO_OP_I2C_SUBSYSTEM_READ: THC opcode for read I2C subsystem registers
 * @THC_PIO_OP_I2C_SUBSYSTEM_WRITE: THC opcode for write I2C subsystem registers
 * @THC_PIO_OP_I2C_TIC_READ: THC opcode for read I2C device
 * @THC_PIO_OP_I2C_TIC_WRITE: THC opcode for write I2C device
 * @THC_PIO_OP_I2C_TIC_WRITE_AND_READ: THC opcode for write followed by read I2C device
 */
enum thc_pio_opcode {
	THC_PIO_OP_SPI_TIC_READ = 0x4,
	THC_PIO_OP_SPI_TIC_WRITE = 0x6,
	THC_PIO_OP_I2C_SUBSYSTEM_READ = 0x12,
	THC_PIO_OP_I2C_SUBSYSTEM_WRITE = 0x13,
	THC_PIO_OP_I2C_TIC_READ = 0x14,
	THC_PIO_OP_I2C_TIC_WRITE = 0x18,
	THC_PIO_OP_I2C_TIC_WRITE_AND_READ = 0x1C,
};

/**
 * THC SPI IO mode
 * @THC_SINGLE_IO: single IO mode, 1(opcode) - 1(address) - 1(data)
 * @THC_DUAL_IO: dual IO mode, 1(opcode) - 2(address) - 2(data)
 * @THC_QUAD_IO: quad IO mode, 1(opcode) - 4(address) - 4(data)
 * @THC_QUAD_PARALLEL_IO: parallel quad IO mode, 4(opcode) - 4(address) - 4(data)
 */
enum thc_spi_iomode {
	THC_SINGLE_IO = 0,
	THC_DUAL_IO = 1,
	THC_QUAD_IO = 2,
	THC_QUAD_PARALLEL_IO = 3,
};

/**
 * THC SPI frequency divider
 *
 * This DIV final value is determined by THC_M_PRT_SPI_CFG_SPI_LOW_FREQ_EN bit.
 * If THC_M_PRT_SPI_CFG_SPI_LOW_FREQ_EN isn't be set, THC takes the DIV value directly;
 * If THC_M_PRT_SPI_CFG_SPI_LOW_FREQ_EN is set, THC takes the DIV value multiply by 8.
 *
 * For example, if THC input clock is 125MHz:
 * When THC_M_PRT_SPI_CFG_SPI_LOW_FREQ_EN isn't set, THC_SPI_FRQ_DIV_3 means DIV is 3,
 * THC final clock is 125 / 3 = 41.667MHz;
 * When THC_M_PRT_SPI_CFG_SPI_LOW_FREQ_EN is set, THC_SPI_FRQ_DIV_3 means DIV is 3 * 8,
 * THC final clock is 125 / (3 * 8) = 5.208MHz;
 */
enum thc_spi_frq_div {
	THC_SPI_FRQ_RESERVED = 0,
	THC_SPI_FRQ_DIV_1 = 1,
	THC_SPI_FRQ_DIV_2 = 2,
	THC_SPI_FRQ_DIV_3 = 3,
	THC_SPI_FRQ_DIV_4 = 4,
	THC_SPI_FRQ_DIV_5 = 5,
	THC_SPI_FRQ_DIV_6 = 6,
	THC_SPI_FRQ_DIV_7 = 7,
};

/* THC I2C sub-system registers */
#define THC_I2C_IC_CON_OFFSET				0x0
#define THC_I2C_IC_TAR_OFFSET				0x4
#define THC_I2C_IC_SAR_OFFSET				0x8
#define THC_I2C_IC_HS_MADDR_OFFSET			0xC
#define THC_I2C_IC_DATA_CMD_OFFSET			0x10
#define THC_I2C_IC_SS_SCL_HCNT_OFFSET			0x14
#define THC_I2C_IC_UFM_SCL_HCNT_OFFSET			0x14
#define THC_I2C_IC_SS_SCL_LCNT_OFFSET			0x18
#define THC_I2C_IC_UFM_SCL_LCNT_OFFSET			0x18
#define THC_I2C_IC_FS_SCL_HCNT_OFFSET			0x1C
#define THC_I2C_IC_UFM_TBUF_CNT_OFFSET			0x1C
#define THC_I2C_IC_FS_SCL_LCNT_OFFSET			0x20
#define THC_I2C_IC_HS_SCL_HCNT_OFFSET			0x24
#define THC_I2C_IC_HS_SCL_LCNT_OFFSET			0x28
#define THC_I2C_IC_INTR_STAT_OFFSET			0x2C
#define THC_I2C_IC_INTR_MASK_OFFSET			0x30
#define THC_I2C_IC_RAW_INTR_STAT_OFFSET			0x34
#define THC_I2C_IC_RX_TL_OFFSET				0x38
#define THC_I2C_IC_TX_TL_OFFSET				0x3C
#define THC_I2C_IC_CLR_INTR_OFFSET			0x40
#define THC_I2C_IC_CLR_RX_UNDER_OFFSET			0x44
#define THC_I2C_IC_CLR_RX_OVER_OFFSET			0x48
#define THC_I2C_IC_CLR_TX_OVER_OFFSET			0x4C
#define THC_I2C_IC_CLR_RD_REQ_OFFSET			0x50
#define THC_I2C_IC_CLR_TX_ABRT_OFFSET			0x54
#define THC_I2C_IC_CLR_RX_DONE_OFFSET			0x58
#define THC_I2C_IC_CLR_ACTIVITY_OFFSET			0x5C
#define THC_I2C_IC_CLR_STOP_DET_OFFSET			0x60
#define THC_I2C_IC_CLR_START_DET_OFFSET			0x64
#define THC_I2C_IC_CLR_GEN_CALL_OFFSET			0x68
#define THC_I2C_IC_ENABLE_OFFSET			0x6C
#define THC_I2C_IC_STATUS_OFFSET			0x70
#define THC_I2C_IC_TXFLR_OFFSET				0x74
#define THC_I2C_IC_RXFLR_OFFSET				0x78
#define THC_I2C_IC_SDA_HOLD_OFFSET			0x7C
#define THC_I2C_IC_TX_ABRT_SOURCE_OFFSET		0x80
#define THC_I2C_IC_SLV_DATA_NACK_ONLY_OFFSET		0x84
#define THC_I2C_IC_DMA_CR_OFFSET			0x88
#define THC_I2C_IC_DMA_TDLR_OFFSET			0x8C
#define THC_I2C_IC_DMA_RDLR_OFFSET			0x90
#define THC_I2C_IC_SDA_SETUP_OFFSET			0x94
#define THC_I2C_IC_ACK_GENERAL_CALL_OFFSET		0x98
#define THC_I2C_IC_ENABLE_STATUS_OFFSET			0x9C
#define THC_I2C_IC_FS_SPKLEN_OFFSET			0xA0
#define THC_I2C_IC_UFM_SPKLEN_OFFSET			0xA0
#define THC_I2C_IC_HS_SPKLEN_OFFSET			0xA4
#define THC_I2C_IC_CLR_RESTART_DET_OFFSET		0xA8
#define THC_I2C_IC_SCL_STUCK_AT_LOW_TIMEOUT_OFFSET	0xAC
#define THC_I2C_IC_SDA_STUCK_AT_LOW_TIMEOUT_OFFSET	0xB0
#define THC_I2C_IC_CLR_SCL_STUCK_DET_OFFSET		0xB4
#define THC_I2C_IC_DEVICE_ID_OFFSET			0xB8
#define THC_I2C_IC_SMBUS_CLK_LOW_SEXT_OFFSET		0xBC
#define THC_I2C_IC_SMBUS_CLK_LOW_MEXT_OFFSET		0xC0
#define THC_I2C_IC_SMBUS_THIGH_MAX_IDLE_COUNT_OFFSET	0xC4
#define THC_I2C_IC_SMBUS_INTR_STAT_OFFSET		0xC8
#define THC_I2C_IC_SMBUS_INTR_MASK_OFFSET		0xCC
#define THC_I2C_IC_SMBUS_RAW_INTR_STAT_OFFSET		0xD0
#define THC_I2C_IC_CLR_SMBUS_INTR_OFFSET		0xD4
#define THC_I2C_IC_OPTIONAL_SAR_OFFSET			0xD8
#define THC_I2C_IC_SMBUS_UDID_LSB_OFFSET		0xDC
#define THC_I2C_IC_SMBUS_UDID_WORD0_OFFSET		0xDC
#define THC_I2C_IC_SMBUS_UDID_WORD1_OFFSET		0xE0
#define THC_I2C_IC_SMBUS_UDID_WORD2_OFFSET		0xE4
#define THC_I2C_IC_SMBUS_UDID_WORD3_OFFSET		0xE8
#define THC_I2C_IC_COMP_PARAM_1_OFFSET			0xF4
#define THC_I2C_IC_COMP_VERSION_OFFSET			0xF8
#define THC_I2C_IC_COMP_TYPE_OFFSET			0xFC

/**
 * THC I2C sub-system supported speed mode
 */
enum THC_I2C_SPEED_MODE {
	THC_I2C_STANDARD = 1,
	THC_I2C_FAST_AND_PLUS = 2,
	THC_I2C_HIGH_SPEED = 3,
};

/* THC I2C sub-system register bits definition */
#define THC_I2C_IC_ENABLE_ENABLE			BIT(0)
#define THC_I2C_IC_ENABLE_ABORT				BIT(1)
#define THC_I2C_IC_ENABLE_TX_CMD_BLOCK			BIT(2)
#define THC_I2C_IC_ENABLE_SDA_STUCK_RECOVERY_ENABLE	BIT(3)
#define THC_I2C_IC_ENABLE_SMBUS_CLK_RESET		BIT(16)
#define THC_I2C_IC_ENABLE_SMBUS_SUSPEND_EN		BIT(17)
#define THC_I2C_IC_ENABLE_SMBUS_ALERT_EN		BIT(18)

#define THC_I2C_IC_CON_MASTER_MODE			BIT(0)
#define THC_I2C_IC_CON_SPEED				GENMASK(2, 1)
#define THC_I2C_IC_CON_IC_10BITADDR_SLAVE		BIT(3)
#define THC_I2C_IC_CON_IC_10BITADDR_MASTER		BIT(4)
#define THC_I2C_IC_CON_IC_RESTART_EN			BIT(5)
#define THC_I2C_IC_CON_IC_SLAVE_DISABLE			BIT(6)
#define THC_I2C_IC_CON_STOP_DET_IFADDRESSED		BIT(7)
#define THC_I2C_IC_CON_TX_EMPTY_CTRL			BIT(8)
#define THC_I2C_IC_CON_RX_FIFO_FULL_HLD_CTRL		BIT(9)
#define THC_I2C_IC_CON_STOP_DET_IF_MASTER_ACTIVE	BIT(10)
#define THC_I2C_IC_CON_BUS_CLEAR_FEATURE_CTRL		BIT(11)
#define THC_I2C_IC_CON_OPTIONAL_SAR_CTRL		BIT(16)
#define THC_I2C_IC_CON_SMBUS_SLAVE_QUICK_EN		BIT(17)
#define THC_I2C_IC_CON_SMBUS_ARP_EN			BIT(18)
#define THC_I2C_IC_CON_SMBUS_PERSISTENT_SLV_ADDR_EN	BIT(19)

#define THC_I2C_IC_TAR_IC_TAR				GENMASK(9, 0)
#define THC_I2C_IC_TAR_GC_OR_START			BIT(10)
#define THC_I2C_IC_TAR_SPECIAL				BIT(11)
#define THC_I2C_IC_TAR_IC_10BITADDR_MASTER		BIT(12)
#define THC_I2C_IC_TAR_DEVICE_ID			BIT(13)
#define THC_I2C_IC_TAR_SMBUS_QUICK_CMD			BIT(16)

#define THC_I2C_IC_INTR_MASK_M_RX_UNDER			BIT(0)
#define THC_I2C_IC_INTR_MASK_M_RX_OVER			BIT(1)
#define THC_I2C_IC_INTR_MASK_M_RX_FULL			BIT(2)
#define THC_I2C_IC_INTR_MASK_M_TX_OVER			BIT(3)
#define THC_I2C_IC_INTR_MASK_M_TX_EMPTY			BIT(4)
#define THC_I2C_IC_INTR_MASK_M_RD_REQ			BIT(5)
#define THC_I2C_IC_INTR_MASK_M_TX_ABRT			BIT(6)
#define THC_I2C_IC_INTR_MASK_M_RX_DONE			BIT(7)
#define THC_I2C_IC_INTR_MASK_M_ACTIVITY			BIT(8)
#define THC_I2C_IC_INTR_MASK_M_STOP_DET			BIT(9)
#define THC_I2C_IC_INTR_MASK_M_START_DET		BIT(10)
#define THC_I2C_IC_INTR_MASK_M_GEN_CALL			BIT(11)
#define THC_I2C_IC_INTR_MASK_M_RESTART_DET		BIT(12)
#define THC_I2C_IC_INTR_MASK_M_MASTER_ON_HOLD		BIT(13)
#define THC_I2C_IC_INTR_MASK_M_SCL_STUCK_AT_LOW		BIT(14)

#define THC_I2C_IC_DMA_CR_RDMAE				BIT(0)
#define THC_I2C_IC_DMA_CR_TDMAE				BIT(1)

#endif /* _INTEL_THC_HW_H_  */
