/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.IOException;
import java.io.Writer;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.lib.BitsInt;
import org.apache.jena.atlas.lib.Chars;

public class OutputUtils {
    public static void printHex(StringBuilder out, int x, int width) {
        for (int i = width - 1; i >= 0; --i) {
            x = OutputUtils.oneHex(out, x, i);
        }
    }

    public static int oneHex(StringBuilder out, int x, int i) {
        int y = BitsInt.unpack(x, 4 * i, 4 * i + 4);
        char charHex = Chars.hexDigitsUC[y];
        out.append(charHex);
        return BitsInt.clear(x, 4 * i, 4 * i + 4);
    }

    public static void printHex(Writer out, int x, int width) {
        for (int i = width - 1; i >= 0; --i) {
            x = OutputUtils.oneHex(out, x, i);
        }
    }

    public static int oneHex(Writer out, int x, int i) {
        int y = BitsInt.unpack(x, 4 * i, 4 * i + 4);
        char charHex = Chars.hexDigitsUC[y];
        try {
            out.write(charHex);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return BitsInt.clear(x, 4 * i, 4 * i + 4);
    }

    public static void printHex(AWriter out, int x, int width) {
        for (int i = width - 1; i >= 0; --i) {
            x = OutputUtils.oneHex(out, x, i);
        }
    }

    public static int oneHex(AWriter out, int x, int i) {
        int y = BitsInt.unpack(x, 4 * i, 4 * i + 4);
        char charHex = Chars.hexDigitsUC[y];
        out.print(charHex);
        return BitsInt.clear(x, 4 * i, 4 * i + 4);
    }
}

