// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Test that Unicode property escapes for `RGI_Emoji` (property of strings)
  match Emoji 14.0 strings.
info: |
  Generated by https://github.com/mathiasbynens/caniunicode
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes, regexp-v-flag]
includes: [regExpUtils.js]
---*/

testPropertyOfStrings({
  regExp: /^\p{RGI_Emoji}+$/v,
  expression: "\\p{RGI_Emoji}",
  matchStrings: [
    "\u{1F6DD}",
    "\u{1F6DE}",
    "\u{1F6DF}",
    "\u{1F7F0}",
    "\u{1F91D}\u{1F3FB}",
    "\u{1F91D}\u{1F3FC}",
    "\u{1F91D}\u{1F3FD}",
    "\u{1F91D}\u{1F3FE}",
    "\u{1F91D}\u{1F3FF}",
    "\u{1F979}",
    "\u{1F9CC}",
    "\u{1FA7B}",
    "\u{1FA7C}",
    "\u{1FAA9}",
    "\u{1FAAA}",
    "\u{1FAAB}",
    "\u{1FAAC}",
    "\u{1FAB7}",
    "\u{1FAB8}",
    "\u{1FAB9}",
    "\u{1FABA}",
    "\u{1FAC3}",
    "\u{1FAC3}\u{1F3FB}",
    "\u{1FAC3}\u{1F3FC}",
    "\u{1FAC3}\u{1F3FD}",
    "\u{1FAC3}\u{1F3FE}",
    "\u{1FAC3}\u{1F3FF}",
    "\u{1FAC4}",
    "\u{1FAC4}\u{1F3FB}",
    "\u{1FAC4}\u{1F3FC}",
    "\u{1FAC4}\u{1F3FD}",
    "\u{1FAC4}\u{1F3FE}",
    "\u{1FAC4}\u{1F3FF}",
    "\u{1FAC5}",
    "\u{1FAC5}\u{1F3FB}",
    "\u{1FAC5}\u{1F3FC}",
    "\u{1FAC5}\u{1F3FD}",
    "\u{1FAC5}\u{1F3FE}",
    "\u{1FAC5}\u{1F3FF}",
    "\u{1FAD7}",
    "\u{1FAD8}",
    "\u{1FAD9}",
    "\u{1FAE0}",
    "\u{1FAE1}",
    "\u{1FAE2}",
    "\u{1FAE3}",
    "\u{1FAE4}",
    "\u{1FAE5}",
    "\u{1FAE6}",
    "\u{1FAE7}",
    "\u{1FAF0}",
    "\u{1FAF0}\u{1F3FB}",
    "\u{1FAF0}\u{1F3FC}",
    "\u{1FAF0}\u{1F3FD}",
    "\u{1FAF0}\u{1F3FE}",
    "\u{1FAF0}\u{1F3FF}",
    "\u{1FAF1}",
    "\u{1FAF1}\u{1F3FB}",
    "\u{1FAF1}\u{1F3FB}\u200D\u{1FAF2}\u{1F3FC}",
    "\u{1FAF1}\u{1F3FB}\u200D\u{1FAF2}\u{1F3FD}",
    "\u{1FAF1}\u{1F3FB}\u200D\u{1FAF2}\u{1F3FE}",
    "\u{1FAF1}\u{1F3FB}\u200D\u{1FAF2}\u{1F3FF}",
    "\u{1FAF1}\u{1F3FC}",
    "\u{1FAF1}\u{1F3FC}\u200D\u{1FAF2}\u{1F3FB}",
    "\u{1FAF1}\u{1F3FC}\u200D\u{1FAF2}\u{1F3FD}",
    "\u{1FAF1}\u{1F3FC}\u200D\u{1FAF2}\u{1F3FE}",
    "\u{1FAF1}\u{1F3FC}\u200D\u{1FAF2}\u{1F3FF}",
    "\u{1FAF1}\u{1F3FD}",
    "\u{1FAF1}\u{1F3FD}\u200D\u{1FAF2}\u{1F3FB}",
    "\u{1FAF1}\u{1F3FD}\u200D\u{1FAF2}\u{1F3FC}",
    "\u{1FAF1}\u{1F3FD}\u200D\u{1FAF2}\u{1F3FE}",
    "\u{1FAF1}\u{1F3FD}\u200D\u{1FAF2}\u{1F3FF}",
    "\u{1FAF1}\u{1F3FE}",
    "\u{1FAF1}\u{1F3FE}\u200D\u{1FAF2}\u{1F3FB}",
    "\u{1FAF1}\u{1F3FE}\u200D\u{1FAF2}\u{1F3FC}",
    "\u{1FAF1}\u{1F3FE}\u200D\u{1FAF2}\u{1F3FD}",
    "\u{1FAF1}\u{1F3FE}\u200D\u{1FAF2}\u{1F3FF}",
    "\u{1FAF1}\u{1F3FF}",
    "\u{1FAF1}\u{1F3FF}\u200D\u{1FAF2}\u{1F3FB}",
    "\u{1FAF1}\u{1F3FF}\u200D\u{1FAF2}\u{1F3FC}",
    "\u{1FAF1}\u{1F3FF}\u200D\u{1FAF2}\u{1F3FD}",
    "\u{1FAF1}\u{1F3FF}\u200D\u{1FAF2}\u{1F3FE}",
    "\u{1FAF2}",
    "\u{1FAF2}\u{1F3FB}",
    "\u{1FAF2}\u{1F3FC}",
    "\u{1FAF2}\u{1F3FD}",
    "\u{1FAF2}\u{1F3FE}",
    "\u{1FAF2}\u{1F3FF}",
    "\u{1FAF3}",
    "\u{1FAF3}\u{1F3FB}",
    "\u{1FAF3}\u{1F3FC}",
    "\u{1FAF3}\u{1F3FD}",
    "\u{1FAF3}\u{1F3FE}",
    "\u{1FAF3}\u{1F3FF}",
    "\u{1FAF4}",
    "\u{1FAF4}\u{1F3FB}",
    "\u{1FAF4}\u{1F3FC}",
    "\u{1FAF4}\u{1F3FD}",
    "\u{1FAF4}\u{1F3FE}",
    "\u{1FAF4}\u{1F3FF}",
    "\u{1FAF5}",
    "\u{1FAF5}\u{1F3FB}",
    "\u{1FAF5}\u{1F3FC}",
    "\u{1FAF5}\u{1F3FD}",
    "\u{1FAF5}\u{1F3FE}",
    "\u{1FAF5}\u{1F3FF}",
    "\u{1FAF6}",
    "\u{1FAF6}\u{1F3FB}",
    "\u{1FAF6}\u{1F3FC}",
    "\u{1FAF6}\u{1F3FD}",
    "\u{1FAF6}\u{1F3FE}",
    "\u{1FAF6}\u{1F3FF}"
  ],
});

reportCompare(0, 0);
