#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Jacek Szafarkiewicz
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Thief: Deadly Shadows
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250807.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='thief-3'
GAME_NAME='Thief 3: Deadly Shadows'

ARCHIVE_BASE_1_NAME='setup_thief_-_deadly_shadows_1.1_(21683).exe'
ARCHIVE_BASE_1_MD5='153723f2908242cf27a23ad58d0608b5'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_thief_-_deadly_shadows_1.1_(21683)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='8c549826345776df192fb1721740096f'
ARCHIVE_BASE_1_SIZE='2300000'
ARCHIVE_BASE_1_VERSION='1.1-gog2.21683'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/thief_3'

ARCHIVE_BASE_0_NAME='setup_thief3_2.0.0.6.exe'
ARCHIVE_BASE_0_MD5='e5b84de58a1037f3e8aa3a1bb2a982be'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='2300000'
ARCHIVE_BASE_0_VERSION='1.1-gog2.0.0.6'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
CONTENT_GAME_BIN_FILES='
system'
CONTENT_GAME0_BIN_PATH='__support/app'
CONTENT_GAME0_BIN_PATH_0='app'
CONTENT_GAME0_BIN_FILES='
user.ini'
CONTENT_GAME_DATA_FILES='
content'
CONTENT_DOC_DATA_FILES='
eula.txt
readme.rtf
*.pdf'

USER_PERSISTENT_DIRECTORIES='
saves'
USER_PERSISTENT_FILES='
*.ini'

## Set up required registry keys.
# shellcheck disable=SC1003
WINE_REGISTRY_INIT='
[HKEY_LOCAL_MACHINE\Software\Ion Storm\Thief - Deadly Shadows]
"ION_ROOT"="C:\\'"${GAME_ID}"'"
"SaveGamePath"="C:\\'"${GAME_ID}"'\\saves"
'

APP_MAIN_EXE='system/t3.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
## Ensure easy upgrades from packages generated with pre-20201031.16 game scripts.
PKG_BIN_PROVIDES="${PKG_BIN_PROVIDES:-}
thief3"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
## Ensure easy upgrades from packages generated with pre-20201031.16 game scripts.
PKG_DATA_PROVIDES="${PKG_DATA_PROVIDES:-}
thief3-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
