#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Emmanuel Gil Peyrot <linkmauve@linkmauve.fr>
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2024 BetaRays <array@dotslashplay.it>
set -o errexit

###
# TrackMania Nations Forever
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250320.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='trackmania-nations-forever'
GAME_NAME='TrackMania Nations Forever'

ARCHIVE_BASE_0_NAME='tmnationsforever_setup.exe'
ARCHIVE_BASE_0_MD5='2a36d70989f94ba9369993749ff20640'
ARCHIVE_BASE_0_EXTRACTOR='bsdtar'
ARCHIVE_BASE_0_SIZE='520000'
ARCHIVE_BASE_0_VERSION='2.11.26-1'
ARCHIVE_BASE_0_URL='https://trackmaniaforever.com/nations/'

## TrackMania Competition Patch
ARCHIVE_OPTIONAL_TMCP_0_NAME='TMCompetitionPatch_1.5.1.zip'
ARCHIVE_OPTIONAL_TMCP_0_MD5='6420ae68976973e57cf1d5a1e135bae7'
ARCHIVE_OPTIONAL_TMCP_0_SIZE='2200'
ARCHIVE_OPTIONAL_TMCP_0_VERSION='1.5.1'
ARCHIVE_OPTIONAL_TMCP_0_URL='https://donadigo.com/tmcp'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
binkw32.dll
openal32.dll
thumbgbx.dll
thumbgbx.tlb
tmforever.exe
tmforeverlauncher.exe
wrap_oal.dll'
CONTENT_GAME_DATA_FILES='
gamedata
packs
tmforever.map
gbx.ico
launchicon.png
nadeo.ini'
## TrackMania Competition Patch
CONTENT_GAME0_BIN_PATH='.'
CONTENT_GAME0_BIN_FILES='
dinput8.dll
TMCompPatch.dll'

WINE_DIRECT3D_RENDERER='dxvk'
WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/TmForever'

APP_MAIN_EXE='tmforeverlauncher.exe'
APP_MAIN_ICON='launchicon.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# innoextract is required to extract the content of an inner archive

REQUIREMENTS_LIST="${REQUIREMENTS_LIST:-}
innoextract"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Check for the presence of the TrackMania Competition Patch

archive_initialize_optional 'ARCHIVE_TMCP' 'ARCHIVE_OPTIONAL_TMCP_0'

# Extract game data

archive_extraction_default
ARCHIVE_INNER_PATH="${PLAYIT_WORKDIR}/gamedata/TmNationsForever_Setup_Tmp.exe"
ARCHIVE_INNER_TYPE='innosetup'
archive_extraction 'ARCHIVE_INNER'
rm "$ARCHIVE_INNER_PATH" "${PLAYIT_WORKDIR}/gamedata/TmNationsForever_Setup_Tmp-1.bin"

if archive_is_available 'ARCHIVE_TMCP'; then
	archive_extraction 'ARCHIVE_TMCP'
fi

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

if archive_is_available 'ARCHIVE_TMCP'; then
	APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')"'
	# Load the TrackMania Competition Patch
	export WINEDLLOVERRIDES="dinput8.dll=n,b;$WINEDLLOVERRIDES"
	'
fi

launchers_generation 'PKG_BIN'

# Build package

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
