/*
 * Decompiled with CFR 0.152.
 */
package jalview.structure;

import jalview.datamodel.SequenceI;

public class StructureMapping {
    String mappingDetails;
    SequenceI sequence;
    String pdbfile;
    String pdbid;
    String pdbchain;
    int[][] mapping;

    public StructureMapping(SequenceI seq, String pdbfile, String pdbid, String chain, int[][] mapping, String mappingDetails) {
        this.sequence = seq;
        this.pdbfile = pdbfile;
        this.pdbid = pdbid;
        this.pdbchain = chain;
        this.mapping = mapping;
        this.mappingDetails = mappingDetails;
    }

    public SequenceI getSequence() {
        return this.sequence;
    }

    public String getChain() {
        return this.pdbchain;
    }

    public String getPdbId() {
        return this.pdbid;
    }

    public int getAtomNum(int seqpos) {
        if (this.mapping.length > seqpos) {
            return this.mapping[seqpos][1];
        }
        return 0;
    }

    public int getPDBResNum(int seqpos) {
        if (this.mapping.length > seqpos) {
            return this.mapping[seqpos][0];
        }
        return 0;
    }

    public int getSeqPos(int pdbResNum) {
        for (int i = 0; i < this.mapping.length; ++i) {
            if (this.mapping[i][0] != pdbResNum) continue;
            return i;
        }
        return -1;
    }
}

