"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.between = exports.nonzero = exports.zero = exports.unequal = exports.equal = void 0;
function equal(a, b, tolerance) {
    return Math.abs(a - b) <= tolerance;
}
exports.equal = equal;
function unequal(a, b, tolerance) {
    return Math.abs(a - b) > tolerance;
}
exports.unequal = unequal;
function zero(a, tolerance) {
    return Math.abs(a) <= tolerance;
}
exports.zero = zero;
function nonzero(a, tolerance) {
    return Math.abs(a) > tolerance;
}
exports.nonzero = nonzero;
function between(d1, dj, d2, tolerance) {
    return Math.min(d1, d2) - tolerance <= dj && dj <= Math.max(d1, d2) + tolerance;
}
exports.between = between;
//# sourceMappingURL=approx.js.map