"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CffCidCharsetSink = exports.CffGlyphNameCharsetSink = exports.CffGlyphNaming = void 0;
class CffGlyphNaming {
    constructor() {
        this.mapping = new Map();
    }
    getName(g) {
        return this.mapping.get(g);
    }
    setName(g, name) {
        this.mapping.set(g, name);
    }
}
exports.CffGlyphNaming = CffGlyphNaming;
class CffGlyphNameCharsetSink {
    constructor(glyphs, naming, ctx) {
        this.glyphs = glyphs;
        this.naming = naming;
        this.ctx = ctx;
    }
    getGlyphCount() {
        return this.glyphs.length;
    }
    put(gid, chr) {
        const name = this.ctx.strings.get(chr);
        if (this.naming)
            this.naming.setName(this.glyphs.at(gid), name);
    }
}
exports.CffGlyphNameCharsetSink = CffGlyphNameCharsetSink;
class CffCidCharsetSink {
    constructor(glyphs, naming, cidMap) {
        this.glyphs = glyphs;
        this.naming = naming;
        this.cidMap = cidMap;
    }
    getGlyphCount() {
        return this.glyphs.length;
    }
    put(gid, chr) {
        this.cidMap.set(chr, this.glyphs.at(gid));
        if (this.naming) {
            this.naming.setName(this.glyphs.at(gid), `CID${chr}`);
        }
    }
}
exports.CffCidCharsetSink = CffCidCharsetSink;
//# sourceMappingURL=glyph-data-sink.js.map