"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Encoder = exports.Interpreter = exports.operator = exports.operand = exports.isOperator = void 0;
function isOperator(ir) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return ir.opCode !== undefined;
}
exports.isOperator = isOperator;
function operand(x) {
    return { t: x };
}
exports.operand = operand;
function operator(x, flags) {
    return { opCode: x, flags };
}
exports.operator = operator;
class Interpreter {
    operand(...xs) {
        for (const x of xs)
            this.doOperand(x);
        return this;
    }
    operator(opCode, flags) {
        this.doOperator(opCode, flags);
        return this;
    }
    next(ir) {
        if (isOperator(ir)) {
            this.doOperator(ir.opCode, ir.flags);
        }
        else {
            this.doOperand(ir.t);
        }
    }
}
exports.Interpreter = Interpreter;
class Encoder {
    push(ir) {
        if (isOperator(ir)) {
            this.operator(ir.opCode, ir.flags);
        }
        else {
            this.operand(ir.t);
        }
    }
}
exports.Encoder = Encoder;
//# sourceMappingURL=ir.js.map