import { Point } from "./base";
export type SpiroK = [number, number, number, number];
export declare function integrate_spiro(ks: SpiroK): [number, number];
export declare function ksBend(ks: SpiroK): number;
export declare function ksTheta(s0: number, s1: number, ks: SpiroK): number;
export declare class SpiroArc {
    private readonly ks;
    readonly x0: number;
    readonly y0: number;
    readonly x1: number;
    readonly y1: number;
    private rot;
    deriveX0: number;
    deriveY0: number;
    deriveX1: number;
    deriveY1: number;
    arcLength: number;
    bend: number;
    constructor(ks: SpiroK, x0: number, y0: number, x1: number, y1: number);
    toCubicBezier(): [Point, Point, Point, Point];
    private evalImpl;
    eval(at: number): Point;
    derivative(at: number): {
        x: number;
        y: number;
    };
    subdivide(at: number): [SpiroArc, SpiroArc];
}
