/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   


#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__UPPERCASECOMMAND_HPP)
#include <UpperCaseCommand.hpp>
#endif

#if   !defined(__RESTORECASECOMMAND_HPP)
#include <RestoreCaseCommand.hpp>
#endif

#include <cctype>

using namespace corelinux;

// Default constructor

UpperCaseCommand::UpperCaseCommand( void )
   throw ( Assertion )
   :
   Command(),
   theOriginalValue( NULLPTR ),
   theNewValue( NULLPTR )
{
   NEVER_GET_HERE;
}

// Proper constructor

UpperCaseCommand::UpperCaseCommand( const std::string & aValue )
   :
   Command(),
   theOriginalValue( new std::string(aValue) ),
   theNewValue( new std::string("") )
{
   ;  // do nothing
}

// Copy constructor

UpperCaseCommand::UpperCaseCommand( UpperCaseCommandCref aUpCaseCmd )
   :
   Command( aUpCaseCmd ),
   theOriginalValue( new std::string(aUpCaseCmd.getOriginalValue()) ),
   theNewValue( new std::string("") )
{
   ;  // do nothing
}

// Destructor

UpperCaseCommand::~UpperCaseCommand( void )
{
   if( theOriginalValue != NULLPTR )
   {
      delete theOriginalValue;
      theOriginalValue = NULLPTR;
   }
   else
   {
      ;  // do nothing
   }

   if( theNewValue != NULLPTR )
   {
      delete theNewValue;
      theNewValue = NULLPTR;
   }
   else
   {
      ;  // do nothing
   }
}

// Assignment operator

UpperCaseCommandRef UpperCaseCommand::operator=
   ( 
      UpperCaseCommandCref aUpCaseCmd 
   )
{
   if( *this == aUpCaseCmd )
   {
      ;  // do nothing, its us
   }
   else
   {
      *theOriginalValue = aUpCaseCmd.getOriginalValue() ;
      *theNewValue = "";
   }

   return (*this);
}

// Equality operator

bool UpperCaseCommand::operator==( UpperCaseCommandCref aUpCaseCmd ) const
{
   return ( this == &aUpCaseCmd );
}

// Access for original

const std::string &  UpperCaseCommand::getOriginalValue( void ) const
{
   return *theOriginalValue;
}

// Access for results

const std::string &  UpperCaseCommand::getNewValue( void ) const
{
   return *theNewValue;
}

void  UpperCaseCommand::setReverseCommand( AbstractCommandPtr aCmdPtr )
{
   if( dynamic_cast<RestoreCaseCommandPtr>(aCmdPtr) != NULLPTR )
   {
      dynamic_cast<RestoreCaseCommandPtr>(aCmdPtr)->setValues
         ( 
            &theOriginalValue, 
            &theNewValue 
         );
   }
   else
   {
      ;  // do nothing
   }

   Command::setReverseCommand( aCmdPtr );
}

// Do the work

void  UpperCaseCommand::execute( void ) 
{
   size_t   len = theOriginalValue->length();

   *theNewValue = "";
   if( len != 0 )
   {
      for( size_t x = 0; x < len; ++x )
      {
         *theNewValue += toupper((*theOriginalValue)[x]);
      }
   }
   else
   {
      ; // do nothing
   }
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/04 05:41:59 $
   $Locker:  $
*/

