%feature("docstring") OT::FrankCopulaFactory
R"RAW(Frank Copula factory.

Notes
-----
The parameters are estimated using the following equations:

:math:`\Hat{\theta}_n` is solution of

.. math::

    \displaystyle \Hat{\tau}_n = 1-4\left( \frac{1-D(\Hat{\theta}_n, 1)^{\strut}}{\theta} \right)

where :math:`D` is the Debye function defined as

.. math::

    \displaystyle D(x, n)=\frac{n}{x^n}\int_0^x \frac{t^n}{e^t-1_{\strut}} dt

See also
--------
DistributionFactory, FrankCopula)RAW"


// ---------------------------------------------------------------------

%feature("docstring") OT::FrankCopulaFactory::buildAsFrankCopula
R"RAW(Estimate the copula as native copula.

**Available usages**:

    buildAsFrankCopula()

    buildAsFrankCopula(*sample*)

    buildAsFrankCopula(*param*)

Parameters
----------
sample : 2-d sequence of float
    Data of dimension 2.
param : sequence of float of size 1
   The parameter :math:`\theta`.

Returns
-------
copula : :class:`~openturns.FrankCopula`
    The estimated copula as a Frank copula.
    
    In the first usage, the default Frank copula is built.)RAW"
