# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.informaticadatamanagement.aio import InformaticaDataMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestInformaticaDataMgmtServerlessRuntimesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(InformaticaDataMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_informatica_organization_resource(self, resource_group):
        response = self.client.serverless_runtimes.list_by_informatica_organization_resource(
            resource_group_name=resource_group.name,
            organization_name="str",
            api_version="2024-05-08",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.serverless_runtimes.get(
            resource_group_name=resource_group.name,
            organization_name="str",
            serverless_runtime_name="str",
            api_version="2024-05-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.serverless_runtimes.begin_create_or_update(
                resource_group_name=resource_group.name,
                organization_name="str",
                serverless_runtime_name="str",
                resource={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "serverlessAccountLocation": "str",
                        "advancedCustomProperties": [{"key": "str", "value": "str"}],
                        "applicationType": "str",
                        "computeUnits": "str",
                        "description": "str",
                        "executionTimeout": "str",
                        "platform": "str",
                        "provisioningState": "str",
                        "serverlessRuntimeConfig": {
                            "cdiConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",
                                            "defaultValue": "str",
                                            "name": "str",
                                            "platform": "str",
                                            "type": "str",
                                            "value": "str",
                                        }
                                    ],
                                    "engineName": "str",
                                    "engineVersion": "str",
                                }
                            ],
                            "cdieConfigProps": [
                                {
                                    "applicationConfigs": [
                                        {
                                            "customized": "str",
                                            "defaultValue": "str",
                                            "name": "str",
                                            "platform": "str",
                                            "type": "str",
                                            "value": "str",
                                        }
                                    ],
                                    "engineName": "str",
                                    "engineVersion": "str",
                                }
                            ],
                        },
                        "serverlessRuntimeNetworkProfile": {
                            "networkInterfaceConfiguration": {
                                "subnetId": "str",
                                "vnetId": "str",
                                "vnetResourceGuid": "str",
                            }
                        },
                        "serverlessRuntimeTags": [{"name": "str", "value": "str"}],
                        "serverlessRuntimeUserContextProperties": {"userContextToken": "str"},
                        "supplementaryFileLocation": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2024-05-08",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_update(self, resource_group):
        response = await self.client.serverless_runtimes.update(
            resource_group_name=resource_group.name,
            organization_name="str",
            serverless_runtime_name="str",
            properties={
                "properties": {
                    "advancedCustomProperties": [{"key": "str", "value": "str"}],
                    "applicationType": "str",
                    "computeUnits": "str",
                    "description": "str",
                    "executionTimeout": "str",
                    "platform": "str",
                    "serverlessAccountLocation": "str",
                    "serverlessRuntimeConfig": {
                        "cdiConfigProps": [
                            {
                                "applicationConfigs": [
                                    {
                                        "customized": "str",
                                        "defaultValue": "str",
                                        "name": "str",
                                        "platform": "str",
                                        "type": "str",
                                        "value": "str",
                                    }
                                ],
                                "engineName": "str",
                                "engineVersion": "str",
                            }
                        ],
                        "cdieConfigProps": [
                            {
                                "applicationConfigs": [
                                    {
                                        "customized": "str",
                                        "defaultValue": "str",
                                        "name": "str",
                                        "platform": "str",
                                        "type": "str",
                                        "value": "str",
                                    }
                                ],
                                "engineName": "str",
                                "engineVersion": "str",
                            }
                        ],
                    },
                    "serverlessRuntimeNetworkProfile": {
                        "networkInterfaceConfiguration": {"subnetId": "str", "vnetId": "str", "vnetResourceGuid": "str"}
                    },
                    "serverlessRuntimeTags": [{"name": "str", "value": "str"}],
                    "serverlessRuntimeUserContextProperties": {"userContextToken": "str"},
                    "supplementaryFileLocation": "str",
                }
            },
            api_version="2024-05-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.serverless_runtimes.begin_delete(
                resource_group_name=resource_group.name,
                organization_name="str",
                serverless_runtime_name="str",
                api_version="2024-05-08",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_check_dependencies(self, resource_group):
        response = await self.client.serverless_runtimes.check_dependencies(
            resource_group_name=resource_group.name,
            organization_name="str",
            serverless_runtime_name="str",
            api_version="2024-05-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_serverless_resource_by_id(self, resource_group):
        response = await self.client.serverless_runtimes.serverless_resource_by_id(
            resource_group_name=resource_group.name,
            organization_name="str",
            serverless_runtime_name="str",
            api_version="2024-05-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_start_failed_serverless_runtime(self, resource_group):
        response = await self.client.serverless_runtimes.start_failed_serverless_runtime(
            resource_group_name=resource_group.name,
            organization_name="str",
            serverless_runtime_name="str",
            api_version="2024-05-08",
        )

        # please add some check logic here by yourself
        # ...
