% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxModel.Frame.R
\name{coxModelFrame}
\alias{coxModelFrame}
\alias{coxModelFrame.coxph}
\alias{coxModelFrame.cph}
\alias{coxModelFrame.phreg}
\alias{coxModelFrame.prodlim}
\alias{coxModelFrame.GLMnet}
\title{Extract the design matrix used to train a Cox model}
\usage{
coxModelFrame(object, center)

\method{coxModelFrame}{coxph}(object, center = FALSE)

\method{coxModelFrame}{cph}(object, center = FALSE)

\method{coxModelFrame}{phreg}(object, center = FALSE)

\method{coxModelFrame}{prodlim}(object, center = FALSE)

\method{coxModelFrame}{GLMnet}(object, center = FALSE)
}
\arguments{
\item{object}{The fitted Cox regression model object either
obtained with \code{coxph} (survival package), \code{cph}
(rms package), or \code{phreg} (mets package).}

\item{center}{[logical] Should the variables of the linear predictor be added ?}
}
\description{
Extract the design matrix used to train a Cox model. Should contain the time of event, the type of event, 
the variable for the linear predictor, the strata variables and the date of entry (in case of delayed entry).
}
\author{
Brice Ozenne broz@sund.ku.dk
}
