## TFSA-2022-049: Multiple `CHECK`-fails in `function.cc`

### CVE Number
CVE-2022-23586

### Impact
A malicious user can cause a denial of service by altering a `SavedModel` such that [assertions in `function.cc`](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/core/framework/function.cc) would be falsified and crash the Python interpreter.

### Patches
We have patched the issue in GitHub commits [dcc21c7bc972b10b6fb95c2fb0f4ab5a59680ec2](https://github.com/tensorflow/tensorflow/commit/dcc21c7bc972b10b6fb95c2fb0f4ab5a59680ec2) and [3d89911481ba6ebe8c88c1c0b595412121e6c645](https://github.com/tensorflow/tensorflow/commit/3d89911481ba6ebe8c88c1c0b595412121e6c645).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
