import functools
from dataclasses import dataclass

from yt_dlp.utils._utils import NO_DEFAULT
from yt_dlp.YoutubeDL import YoutubeDL

__all__ = ["Updater"]

@dataclass
class UpdateInfo:
    tag: str
    version: str | None = ...
    requested_version: str | None = ...
    commit: str | None = ...
    binary_name: str | None = ...
    checksum: str | None = ...

class Updater:
    ydl: YoutubeDL
    requested_channel: str
    requested_tag: str | None
    requested_repo: str | None
    def __init__(self, ydl: YoutubeDL, target: str | None = None) -> None: ...
    @property
    def current_version(self) -> str: ...
    @property
    def current_commit(self) -> str: ...
    def query_update(self, *, _output: bool = False) -> UpdateInfo | None: ...
    def update(self, update_info: type[NO_DEFAULT] | None | UpdateInfo = ...) -> bool | None: ...
    @functools.cached_property
    def filename(self) -> str: ...
    @functools.cached_property
    def cmd(self) -> list[str]: ...
    def restart(self) -> int: ...
